/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webplugin.service.workflow;

import com.bokesoft.erp.webplugin.service.workflow.WFConstants;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.meta.persist.dom.bpm.MetaProcessLoad;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.excel.IImportService2;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.IOUtils;

public class ImportWorkFlowData
implements IImportService2 {
    private static final String Group_Name = "\u5916\u90e8\u5bfc\u5165";
    private static final String Group_Code = "000";

    public void setFormKey(String s) {
    }

    public Object importData(DefaultContext defaultContext, byte[] bytes) throws Throwable {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        String xml = IOUtils.toString((InputStream)is, (Charset)Charsets.toCharset((String)"utf-8"));
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        MetaProcessLoad load = new MetaProcessLoad(1);
        load.load((InputStream)in);
        MetaProcess metaProcess = (MetaProcess)load.getRootMetaObject();
        metaProcess.doPostProcess();
        String key = metaProcess.getKey();
        String caption = metaProcess.getCaption();
        int version = metaProcess.getVersion();
        HashSet<String> keySet = this.getSyncedWorkflow(defaultContext);
        HashMap<String, Long> mapGroupDictID = this.saveWorkflowGroups(Group_Name, Group_Code, defaultContext);
        String fileName = WFConstants.getBpmProfileKey(key, version);
        if (!keySet.contains(fileName)) {
            this.saveWorkflow(key, version, caption, fileName, xml, TypeConvertor.toLong((Object)mapGroupDictID.get(Group_Code)), defaultContext);
        }
        return true;
    }

    private long saveWorkflow(String key, Integer version, String caption, String fileName, String xml, long parentID, DefaultContext defaultContext) throws Throwable {
        RichDocumentContext newContext = null;
        MetaDataObject metaDataObject = defaultContext.getVE().getMetaFactory().getDataObject("BPMN_WorkflowConfig");
        Document document = DocumentUtil.newDocument((MetaDataObject)metaDataObject);
        document.setNew();
        DataTable wfDataTable = document.get("EBPMN_WorkflowConfig");
        wfDataTable.first();
        wfDataTable.setString("Code", fileName);
        wfDataTable.setString("Name", caption);
        wfDataTable.setString("WorkflowKey", key);
        wfDataTable.setInt("Version", version);
        wfDataTable.setInt("Enable", Integer.valueOf(0));
        wfDataTable.setString("FileName", fileName);
        wfDataTable.setString("content", xml);
        wfDataTable.setLong("ParentID", Long.valueOf(parentID));
        newContext = new RichDocumentContext(defaultContext);
        newContext.setFormKey("UserWorkflowDesigner");
        SaveData saveData = new SaveData(metaDataObject, null, document);
        saveData.save((DefaultContext)newContext);
        return document.getOID();
    }

    private HashSet<String> getSyncedWorkflow(DefaultContext defaultContext) throws Throwable {
        HashSet<String> keySet = new HashSet<String>();
        DataTable dataTable = defaultContext.getDBManager().execQuery("select FileName from EBPMN_WorkflowConfig");
        dataTable.beforeFirst();
        while (dataTable.next()) {
            keySet.add(dataTable.getString(0));
        }
        return keySet;
    }

    private HashMap<String, Long> saveWorkflowGroups(String name, String code, DefaultContext defaultContext) {
        HashMap<String, Long> mapGroupDictID = new HashMap<String, Long>();
        mapGroupDictID.put("", -1L);
        try {
            DataTable dataTable = defaultContext.getDBManager().execPrepareQuery("select Code, OID from EBPMN_WorkflowConfig where nodetype=?", new Object[]{1});
            dataTable.beforeFirst();
            while (dataTable.next()) {
                mapGroupDictID.put(dataTable.getString(0), dataTable.getLong(1));
            }
            if (!mapGroupDictID.containsKey(code)) {
                long oid = this.saveWorkflowGroupItem(code, name, defaultContext);
                mapGroupDictID.put(code, oid);
            }
        }
        catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
        }
        return mapGroupDictID;
    }

    private long saveWorkflowGroupItem(String key, String caption, DefaultContext defaultContext) throws Throwable {
        MetaDataObject metaDataObject = defaultContext.getVE().getMetaFactory().getDataObject("BPMN_WorkflowConfig");
        Document document = DocumentUtil.newDocument((MetaDataObject)metaDataObject);
        document.setNew();
        DataTable wfDataTable = document.get("EBPMN_WorkflowConfig");
        wfDataTable.first();
        wfDataTable.setString("Code", key);
        wfDataTable.setString("Name", caption);
        wfDataTable.setInt("NodeType", Integer.valueOf(1));
        wfDataTable.setInt("Enable", Integer.valueOf(1));
        RichDocumentContext newContext = new RichDocumentContext(defaultContext);
        newContext.setFormKey("UserWorkflowDesigner");
        SaveData saveData = new SaveData(metaDataObject, null, document);
        saveData.save((DefaultContext)newContext);
        return document.getOID();
    }

    public void setClearOriginalData(boolean b) {
    }

    public void setPostServiceName(String s) {
    }
}

