/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webplugin.service.common.util;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.file.util.AttachmentUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    public static String inputStream2String(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = -1;
        while ((i = is.read()) != -1) {
            baos.write(i);
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    public static String getExportFilePath(IMetaFactory metaFactory, String prefix, String formKey) throws Throwable {
        String dirPath = metaFactory.getSolution().getDataPath();
        if (dirPath == null || dirPath.isEmpty()) {
            dirPath = AttachmentUtil.getAttachDataPath((String)formKey, (IMetaFactory)metaFactory);
        }
        dirPath = FileUtil.removeSlant((String)dirPath);
        String filePath = String.valueOf(dirPath) + prefix;
        FileUtil.createFoldIfNotExist((String)filePath);
        return filePath;
    }

    public static void toZip(String srcDir, OutputStream out, boolean KeepDirStructure) throws RuntimeException {
        long start = System.currentTimeMillis();
        ZipOutputStream zos = null;
        try {
            try {
                zos = new ZipOutputStream(out);
                File sourceFile = new File(srcDir);
                FileUtils.compress(sourceFile, zos, sourceFile.getName(), KeepDirStructure);
                long l = System.currentTimeMillis();
            }
            catch (Exception e) {
                throw new RuntimeException("zip error from ZipUtils", e);
            }
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure) throws Exception {
        byte[] buf = new byte[1024];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (KeepDirStructure) {
                    zos.putNextEntry(new ZipEntry(String.valueOf(name) + "/"));
                    zos.closeEntry();
                }
            } else {
                File[] fileArray = listFiles;
                int n = listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (KeepDirStructure) {
                        FileUtils.compress(file, zos, String.valueOf(name) + "/" + file.getName(), KeepDirStructure);
                    } else {
                        FileUtils.compress(file, zos, file.getName(), KeepDirStructure);
                    }
                    ++n2;
                }
            }
        }
    }
}

