/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.index;

import com.bokesoft.erp.webdesigner.language.common.ClassHelper;
import com.bokesoft.erp.webdesigner.language.common.SAXHelper;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndex;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndexEnum;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public abstract class KeyIndexLoader<T extends KeyIndex> {
    public List<T> loadDefine(KeyIndexEnum keyIndexEnum) throws Exception {
        return this.a(keyIndexEnum, KeyIndexEnum::getDefineFile);
    }

    public List<T> loadRefer(KeyIndexEnum keyIndexEnum) throws Exception {
        return this.a(keyIndexEnum, KeyIndexEnum::getReferFile);
    }

    private List<T> a(KeyIndexEnum keyIndexEnum, Function<KeyIndexEnum, File> function) throws Exception {
        File file = function.apply(keyIndexEnum);
        Function function2 = this.a(keyIndexEnum);
        ArrayList arrayList = new ArrayList();
        if (file.exists()) {
            SAXHelper.parse(file, function2.apply(arrayList));
        }
        return arrayList;
    }

    private Function<List<T>, DefaultHandler> a(final KeyIndexEnum keyIndexEnum) {
        final Class<?> clazz = this.getClass();
        return list -> new DefaultHandler((List)list){
            private final /* synthetic */ List d;
            {
                this.d = list;
            }

            @Override
            public void startElement(String string, String string2, String string3, Attributes attributes) {
                if (StringUtils.equals((CharSequence)string3, (CharSequence)keyIndexEnum.getCode())) {
                    KeyIndex keyIndex = (KeyIndex)ClassHelper.newParameterInstance(clazz);
                    keyIndex.setFileID(attributes.getValue("FileID"));
                    keyIndex.setKey(attributes.getValue("Key"));
                    keyIndex.setLine(Integer.parseInt(attributes.getValue("Line")));
                    keyIndex.setColumn(Integer.parseInt(attributes.getValue("Column")));
                    keyIndex.setSnapshot(attributes.getValue("Snapshot"));
                    String string4 = attributes.getIndex("Caption") >= 0 ? attributes.getValue("Caption") : "";
                    keyIndex.setCaption(string4);
                    BiConsumer<Attributes, Attributes> biConsumer = KeyIndexLoader.this.getConsumer();
                    if (Objects.nonNull(biConsumer)) {
                        biConsumer.accept(attributes, (Attributes)((Object)keyIndex));
                    }
                    this.d.add(keyIndex);
                }
            }
        };
    }

    protected BiConsumer<Attributes, T> getConsumer() {
        return null;
    }
}

