/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.debugger;

import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.DesignerDebuggerImpl;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.OperateTypeEnum;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@ServerEndpoint(value="/debugger")
public class DebuggerWebsocketServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebuggerWebsocketServer.class);
    private static final List<Session> SESSIONS = new ArrayList<Session>();

    public static boolean notExistClient() {
        return SESSIONS.isEmpty();
    }

    public static void sendText(String string) {
        List<Session> list = DebuggerWebsocketServer.getSessions();
        for (Session session : list) {
            session.getAsyncRemote().sendText(string);
        }
    }

    @OnOpen
    public void onOpen(Session session) {
        LOGGER.info("[websocket] \u65b0\u7684\u8fde\u63a5\uff1aid={}", (Object)session.getId());
        SESSIONS.add(session);
    }

    @OnMessage
    public void onMessage(Session session, String string) throws IOException {
        LOGGER.info("[websocket] \u6536\u5230\u6d88\u606f\uff1aid={}\uff0cmessage={}", (Object)session.getId(), (Object)string);
        if (string.equalsIgnoreCase("bye")) {
            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Bye"));
        } else {
            session.getAsyncRemote().sendText("[" + Instant.now().toEpochMilli() + "] \u6d88\u606f\u5df2\u88ab\u63a5\u6536\u5230\uff01");
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        LOGGER.info("[websocket] \u8fde\u63a5\u65ad\u5f00\uff1aid={}\uff0creason={}", (Object)session.getId(), (Object)closeReason);
        SESSIONS.remove(session);
        if (SESSIONS.isEmpty()) {
            DesignerDebuggerImpl.operate(OperateTypeEnum.OFF);
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) throws IOException {
        LOGGER.info("[websocket] \u8fde\u63a5\u5f02\u5e38\uff1aid={}\uff0cthrowable={}", (Object)session.getId(), (Object)throwable.getMessage());
        session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, throwable.getMessage()));
        SESSIONS.remove(session);
        if (SESSIONS.isEmpty()) {
            DesignerDebuggerImpl.operate(OperateTypeEnum.OFF);
        }
    }

    public static List<Session> getSessions() {
        return Collections.unmodifiableList(SESSIONS);
    }

    @Component
    public static class Exporter
    extends ServerEndpointExporter {
        public Exporter() {
            this.setAnnotatedEndpointClasses(new Class[]{DebuggerWebsocketServer.class});
        }
    }
}

