/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.debugger;

import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.Breakpoint;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.BreakpointLoader;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.BreakpointManager;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.BreakpointWriter;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.DesignerDebuggerImpl;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.OperateTypeEnum;
import com.bokesoft.yes.common.log.LogSvr;
import java.util.List;

public class DebuggerFacade {
    public static void init() {
        try {
            List<Breakpoint> list = BreakpointLoader.load();
            BreakpointManager.addAll(list);
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public static Breakpoint getBreakpoint(long l) {
        return BreakpointManager.get(l);
    }

    public static void saveBreakpoint(Breakpoint breakpoint) {
        try {
            BreakpointManager.save(breakpoint);
            BreakpointWriter.write();
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public static void deleteBreakpoint(Long l) {
        try {
            BreakpointManager.delete(l);
            BreakpointWriter.write();
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public static void clearBreakpoint() {
        try {
            BreakpointManager.clear();
            BreakpointWriter.write();
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public static void toggleDebugger(boolean bl) {
        DesignerDebuggerImpl.setEnable(bl);
    }

    public static void operateDebugger(OperateTypeEnum operateTypeEnum) {
        DesignerDebuggerImpl.operate(operateTypeEnum);
    }
}

