/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.debugger;

import com.bokesoft.erp.webdesigner.language.common.SAXHelper;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.Breakpoint;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.BreakpointManager;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class BreakpointWriter {
    private static final Function<Breakpoint, Attributes> MAPPER = breakpoint -> {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", "OID", "", String.valueOf(breakpoint.getOid()));
        attributesImpl.addAttribute("", "", "Enable", "", String.valueOf(breakpoint.getEnable()));
        attributesImpl.addAttribute("", "", "Type", "", String.valueOf((Object)breakpoint.getType()));
        attributesImpl.addAttribute("", "", "Text", "", breakpoint.getText());
        String string = breakpoint.getCondition();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            attributesImpl.addAttribute("", "", "Condition", "", string);
        }
        return attributesImpl;
    };

    public static void write() throws Exception {
        List<Breakpoint> list = BreakpointManager.getList();
        SAXHelper.transform(Breakpoint.FILE, "Breakpoint", list, MAPPER);
    }
}

