/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.common;

import com.bokesoft.yes.common.log.LogSvr;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.BasicSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.PropertyBuilder;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.json.JSONObject;
import org.springframework.util.ReflectionUtils;

public class JsonMapper {
    private static ObjectMapper instance;
    private static final ToJsonMethodSerializer toJsonMethodSerializer;
    private static final List<String> IGNORE_PROPERTY_LIST;

    static {
        toJsonMethodSerializer = new ToJsonMethodSerializer();
        IGNORE_PROPERTY_LIST = Arrays.asList("cachedb", "dbmanager", "cachedbrequest", "richcontext", "defaultcontext", "parentcontext", "parentcontextensure", "ve", "metafactory", "innermetafactory", "datamigrationlist", "tgtobjectkeys", "documenttrack", "connection", "metadata");
    }

    private JsonMapper() {
    }

    public static synchronized ObjectMapper getInstance() {
        if (instance == null) {
            instance = new ObjectMapper();
            instance.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            instance.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            instance.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Object object = (BasicSerializerFactory)instance.getSerializerFactory();
            object = (BasicSerializerFactory)object.withSerializerModifier(new BeanSerializerModifier(){

                public List<BeanPropertyWriter> changeProperties(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyWriter> list) {
                    for (BeanPropertyWriter beanPropertyWriter : list) {
                        Class clazz = beanPropertyWriter.getType().getRawClass();
                        Method method = ReflectionUtils.findMethod((Class)clazz, (String)"toJSON");
                        if (!Objects.nonNull(method)) continue;
                        beanPropertyWriter.assignSerializer((JsonSerializer)toJsonMethodSerializer);
                    }
                    return super.changeProperties(serializationConfig, beanDescription, list);
                }
            });
            object = new CustomSerializerFactory(object.getFactoryConfig());
            instance.setSerializerFactory((SerializerFactory)object);
        }
        return instance;
    }

    public static synchronized String writeValueAsString(Object object) {
        try {
            String string = JsonMapper.getInstance().writeValueAsString(object);
            string = string.replace("\\\"", "\"");
            string = string.replace("\"{", "{");
            string = string.replace("}\"", "}");
            return string;
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public static class CustomSerializerFactory
    extends BeanSerializerFactory {
        protected CustomSerializerFactory(SerializerFactoryConfig serializerFactoryConfig) {
            super(serializerFactoryConfig);
        }

        public SerializerFactory withConfig(SerializerFactoryConfig serializerFactoryConfig) {
            if (this._factoryConfig == serializerFactoryConfig) {
                return this;
            }
            return new CustomSerializerFactory(serializerFactoryConfig);
        }

        protected List<BeanPropertyWriter> findBeanProperties(SerializerProvider serializerProvider, BeanDescription beanDescription, BeanSerializerBuilder beanSerializerBuilder) throws JsonMappingException {
            List list = beanDescription.findProperties();
            SerializationConfig serializationConfig = serializerProvider.getConfig();
            this.removeIgnorableTypes(serializationConfig, beanDescription, list);
            if (serializationConfig.isEnabled(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS)) {
                this.removeSetterlessGetters(serializationConfig, beanDescription, list);
            }
            if (list.isEmpty()) {
                return null;
            }
            boolean bl = this.usesStaticTyping(serializationConfig, beanDescription, null);
            PropertyBuilder propertyBuilder = this.constructPropertyBuilder(serializationConfig, beanDescription);
            ArrayList<BeanPropertyWriter> arrayList = new ArrayList<BeanPropertyWriter>(list.size());
            for (BeanPropertyDefinition beanPropertyDefinition : list) {
                if (IGNORE_PROPERTY_LIST.contains(beanPropertyDefinition.getName().toLowerCase())) continue;
                AnnotatedMember annotatedMember = beanPropertyDefinition.getAccessor();
                if (beanPropertyDefinition.isTypeId()) {
                    if (annotatedMember == null) continue;
                    beanSerializerBuilder.setTypeId(annotatedMember);
                    continue;
                }
                AnnotationIntrospector.ReferenceProperty referenceProperty = beanPropertyDefinition.findReferenceType();
                if (referenceProperty != null && referenceProperty.isBackReference()) continue;
                if (annotatedMember instanceof AnnotatedMethod) {
                    arrayList.add(this._constructWriter(serializerProvider, beanPropertyDefinition, propertyBuilder, bl, annotatedMember));
                    continue;
                }
                arrayList.add(this._constructWriter(serializerProvider, beanPropertyDefinition, propertyBuilder, bl, annotatedMember));
            }
            return arrayList;
        }
    }

    public static class ToJsonMethodSerializer
    extends JsonSerializer<Object> {
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            Class<?> clazz = object.getClass();
            Method method = ReflectionUtils.findMethod(clazz, (String)"toJSON");
            try {
                assert (method != null);
                JSONObject jSONObject = (JSONObject)method.invoke(object, new Object[0]);
                if (Objects.isNull(jSONObject)) {
                    jsonGenerator.writeNull();
                } else {
                    String string = jSONObject.toString();
                    jsonGenerator.writeString(string);
                }
            }
            catch (Exception exception) {
                LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
                throw new RuntimeException(exception);
            }
        }
    }
}

