﻿(function ($) {
	let yigoflow = {};
	let exchange = false;
	let yigoDataMapflow = {};
	let yigoDataMirationflow = {};
	let _states = {}, _paths = {}, _gprops = {}, _sourceProps = {}, _targetProps = {}, _feedbackProps = {},
		datafeedback = {}, rmap = {}, _datamapPaths = {}, maxId = 0, DataMapDataJson, numberID = 1, str, idFlag = "",
		tableIsNullNumber = 1;
	let DataMapOrMigration, curTr = null, sNodeClone = null, bNodeClone;
	//源单和目标表单
	let sourceFormKey, targetFormKey, feedbackForm, sourceContainer, targetContainer, targetField = "";
	let sourceTableAttr;
	// 用于撤销 保存数据 （数据映射）
	// 操作权限数据
	let operPermArray = [];
	//收集Form
	let formArr = []
	// 组件权限数据
	let compPermArray = [];
	// 是否锁屏，默认：false，不锁屏
	let isLockScreen = false;
	// ajax执行状态，默认：false，未执行；true：执行成功。
	let ajaxStatus = false;
	//目前英语连线信息，反填表单的控制
	let publicFalg = false;
	// 已经选择的元素对象列表
	let selectedEles = [];
	let ctrlEnabled = false;
	// 当前路径及点
	let _bpathCurrent, _bdotsCurrent = {};
	let _dotListCurrent;
	let currentNodeId, currentPathId;
	yigoflow.config = {
		editable: true,
		lineHeight: 15,
		basePath: '',
		cacheFileName: '',
		sourceForm: '',
		targetForm: '',
		sourceCaption: '',
		targetCaption: '',
		filePath: '',
		tableKey: '',
		fieldKey: '',
		targetKey: '',
		formKeyListData: '',
		fileName: '',
		rect: {// 状态
			attr: {
				x: 10, y: 10, width: 100, height: 50, r: 5, fill: '90-#fff-#C0C0C0', stroke: '#000', "stroke-width": 1
			}, showType: 'image&text',// image,text,image&text
			type: 'state', name: {
				text: 'state', 'font-style': 'italic'
			}, text: {
				text: '状态', 'font-size': 13
			}, margin: 5, props: [], img: {}
		},
		SequenceFlow: {// 路径转换-->顺序流
			attr: {
				path: {
					path: 'M10 10L100 100', stroke: '#808080', fill: "none", "stroke-width": 2
				}, arrow: {
					path: 'M10 10L10 10', stroke: '#808080', fill: "#808080", "stroke-width": 2, radius: 4
				}, fromDot: {
					width: 5, height: 5, stroke: '#fff', fill: '#000', cursor: "move", "stroke-width": 2
				}, toDot: {
					width: 5, height: 5, stroke: '#fff', fill: '#000', cursor: "move", "stroke-width": 2
				}, bigDot: {
					width: 5, height: 5, stroke: '#fff', fill: '#000', cursor: "move", "stroke-width": 2
				}, smallDot: {
					width: 5, height: 5, stroke: '#fff', fill: '#000', cursor: "move", "stroke-width": 3
				}, text: {
					cursor: "move", 'background': '#000'
				}
			}, text: {
				patten: 'TO {to}', textPos: {
					x: 0, y: -10
				}
			}, props: {}
		},
		Association: {// 路径转换->关联流
			attr: {
				path: {
					path: 'M10 10L100 100', stroke: '#808080', fill: "none", "stroke-dasharray": "--", "stroke-width": 2
				}, arrow: {
					path: 'M10 10L10 10',
					stroke: '#808080',
					fill: "#808080",
					"stroke-width": 2,
					'arrow-end': 'open-wide-long',
					radius: 4
				}, fromDot: {
					width: 5, height: 5, stroke: '#fff', fill: '#000', cursor: "move", "stroke-width": 2
				}, toDot: {
					width: 5, height: 5, stroke: '#fff', fill: '#000', cursor: "move", "stroke-width": 2
				}, bigDot: {
					width: 5, height: 5, stroke: '#fff', fill: '#000', cursor: "move", "stroke-width": 2
				}, smallDot: {
					width: 5, height: 5, stroke: '#fff', fill: '#000', cursor: "move", "stroke-width": 3
				}, text: {
					cursor: "move", 'background': '#000'
				}
			}, text: {
				patten: 'TO {to}', textPos: {
					x: 0, y: -10
				}
			}, props: {}
		},
		ExceptionFlow: {// 路径转换-->异常流
			attr: {
				path: {
					path: 'M10 10L100 100', stroke: '#ff0000', fill: "none", "stroke-width": 2, 'background': '#fff'
				}, arrow: {
					path: 'M10 10L10 10', stroke: '#ff0000', fill: "#ff0000", "stroke-width": 2, radius: 4
				}, fromDot: {
					width: 5, height: 5, stroke: '#ff0000', fill: '#ff0000', cursor: "move", "stroke-width": 2
				}, toDot: {
					width: 5, height: 5, stroke: '', fill: '', cursor: "move", "stroke-width": 2
				}, bigDot: {
					width: 5, height: 5, stroke: '#ff0000', fill: '#fff', cursor: "move", "stroke-width": 2
				}, smallDot: {
					width: 5, height: 5, stroke: '#ff0000', fill: '#fff', cursor: "move", "stroke-width": 3
				}, text: {
					cursor: "move", stroke: '#ff0000', 'background': '#fff'
				}
			}, text: {
				patten: 'TO {to}', textPos: {
					x: 0, y: -10
				}
			}, props: {}
		},
		tools: {// 工具栏
			attr: {
				left: 10, top: 10
			}, pointer: {}, path: {}, states: {}, save: {
				onclick: function (data) {
					alert(data);
				}
			}, deploy: {
				onclick: function (data) {
					alert(data);
				}
			}
		},
		props: {// 属性编辑器
			attr: {
				top: 10, right: 30
			}, props: {}
		},
		dataMapprops: {// 属性编辑器
			attr: {
				top: 10, right: 30
			}, dataMapprops: {}
		},
		sourceProps: {// 源表单
			attr: {
				top: 10, right: 30
			}, sourceProps: {}
		},
		targetProps: {// 目标表单
			attr: {
				top: 10, right: 30
			}, targetProps: {}
		},
		feedbackProps: {// 反填表单
			attr: {
				top: 10, right: 30
			}, feedbackProps: {}
		},
		DataMigrationprops: {// 数据迁移属性编辑器
			attr: {
				top: 10, right: 30
			}, DataMigrationprops: {}
		},
		MigrationTargetProps: {// 数据表单目标数据对象属性
			attr: {
				top: 10, right: 30
			}, MigrationTargetProps: {}
		},
		restore: '',
		activeRects: {// 当前激活状态
			rects: [], rectAttr: {
				stroke: '#ff0000', "stroke-width": 2
			}
		},
		historyRects: {// 历史激活状态
			rects: [], pathAttr: {
				path: {
					stroke: '#00ff00'
				}, arrow: {
					stroke: '#00ff00', fill: "#00ff00"
				}
			}
		}
	};

	yigoflow.util = {
		isLine: function (p1, p2, p3) {// 三个点是否在一条直线上
			var s, p2y;
			if ((p1.x - p3.x) == 0) s = 1; else s = (p1.y - p3.y) / (p1.x - p3.x);
			p2y = (p2.x - p3.x) * s + p3.y;
			// $('body').append(p2.y+'-'+p2y+'='+(p2.y-p2y)+', ');
			if ((p2.y - p2y) < 10 && (p2.y - p2y) > -10) {
				p2.y = p2y;
				return true;
			}
			return false;
		}, center: function (p1, p2) {// 两个点的中间点
			return {
				x: (p1.x - p2.x) / 2 + p2.x, y: (p1.y - p2.y) / 2 + p2.y
			};
		}, nextId: (function () {
			return function () {
				maxId = parseInt(maxId) + 1;
				return maxId;
			};
		})(),

		connPoint: function (rect, p) {// 计算矩形中心到p的连线与矩形的交叉点
			var start = p, end = {
				x: rect.x + rect.width / 2, y: rect.y + rect.height / 2
			};
			// 计算正切角度
			var tag = (end.y - start.y) / (end.x - start.x);
			tag = isNaN(tag) ? 0 : tag;

			var rectTag = rect.height / rect.width;
			// 计算箭头位置
			var xFlag = start.y < end.y ? -1 : 1, yFlag = start.x < end.x ? -1 : 1, arrowTop, arrowLeft;
			// 按角度判断箭头位置
			if (Math.abs(tag) > rectTag && xFlag == -1) {// top边
				arrowTop = end.y - rect.height / 2;
				arrowLeft = end.x + xFlag * rect.height / 2 / tag;
			} else if (Math.abs(tag) > rectTag && xFlag == 1) {// bottom边
				arrowTop = end.y + rect.height / 2;
				arrowLeft = end.x + xFlag * rect.height / 2 / tag;
			} else if (Math.abs(tag) < rectTag && yFlag == -1) {// left边
				arrowTop = end.y + yFlag * rect.width / 2 * tag;
				arrowLeft = end.x - rect.width / 2;
			} else if (Math.abs(tag) < rectTag && yFlag == 1) {// right边
				arrowTop = end.y + rect.width / 2 * tag;
				arrowLeft = end.x + rect.width / 2;
			}
			return {
				x: arrowLeft, y: arrowTop
			};
		},

		arrow: function (p1, p2, r) {// 画箭头，p1 开始位置,p2 结束位置, r前头的边长
			var atan = Math.atan2(p1.y - p2.y, p2.x - p1.x) * (180 / Math.PI);

			var centerX = p2.x - r * Math.cos(atan * (Math.PI / 180));
			var centerY = p2.y + r * Math.sin(atan * (Math.PI / 180));

			var x2 = centerX + r * Math.cos((atan + 120) * (Math.PI / 180));
			var y2 = centerY - r * Math.sin((atan + 120) * (Math.PI / 180));

			var x3 = centerX + r * Math.cos((atan + 240) * (Math.PI / 180));
			var y3 = centerY - r * Math.sin((atan + 240) * (Math.PI / 180));
			return [p2, {
				x: x2, y: y2
			}, {
				x: x3, y: y3
			}];
		}
	}

	yigoflow.rect = function (o, r, id, uid) {
		var _this = this, _uid = yigoflow.util.nextId(), _o = $.extend(true, {}, yigoflow.config.rect, o), _id, _r = r, // Raphael画笔
			_rect, _img, // 图标
			_name, // 状态名称
			_text, // 显示文本
			_ox, _oy; // 拖动时，保存起点位置;
		_o.text.text = id;
		_o.name.text = "";

		// 如果是新增，那么产生一个新的id
		if (!uid) {
			_id = 'rect' + o.type + _uid;
		} else {
			_id = uid;
		}

		_rect = _r.rect(_o.attr.x, _o.attr.y, _o.attr.width, _o.attr.height, _o.attr.r).hide().attr(_o.attr);
		_img = _r.image(yigoflow.config.basePath + _o.img.src, _o.attr.x + _o.img.width / 2, _o.attr.y + (_o.attr.height - _o.img.height) / 2, _o.img.width, _o.img.height).hide();
		_name = _r.text(_o.attr.x + _o.img.width + (_o.attr.width - _o.img.width) / 2, _o.attr.y + yigoflow.config.lineHeight / 2, _o.name.text).hide().attr(_o.name);
		_text = _r.text(_o.attr.x + _o.img.width + (_o.attr.width - _o.img.width) / 2, _o.attr.y + (_o.attr.height - yigoflow.config.lineHeight) / 2 + yigoflow.config.lineHeight, _o.text.text).hide().attr(_o.text);// 文本

		// 拖动处理----------------------------------------
		_rect.drag(function (dx, dy) {
			dragMove(dx, dy);
		}, function () {
			dragStart()
		}, function () {
			dragUp();
		});
		_img.drag(function (dx, dy) {
			dragMove(dx, dy);
		}, function () {
			dragStart()
		}, function () {
			dragUp();
		});
		_name.drag(function (dx, dy) {
			dragMove(dx, dy);
		}, function () {
			dragStart()
		}, function () {
			dragUp();
		});
		_text.drag(function (dx, dy) {
			dragMove(dx, dy);
		}, function () {
			dragStart()
		}, function () {
			dragUp();
		});

		var dragMove = function (dx, dy) {// 拖动中
			if (!yigoflow.config.editable) return;

			var x = (_ox + dx);// -((_ox+dx)%10);
			var y = (_oy + dy);// -((_oy+dy)%10);

			_bbox.x = x - _o.margin;
			_bbox.y = y - _o.margin;
			resize();
		};

		var dragStart = function () {// 开始拖动
			_ox = _rect.attr("x");
			_oy = _rect.attr("y");
			_rect.attr({
				opacity: 0.5
			});
			_img.attr({
				opacity: 0.5
			});
			_text.attr({
				opacity: 0.5
			});
		};

		var dragUp = function () {// 拖动结束
			_rect.attr({
				opacity: 1
			});
			_img.attr({
				opacity: 1
			});
			_text.attr({
				opacity: 1
			});

			// 下面是矩形移动后，x和y坐标更新到xml中
			// 文件路径
			let filePath = yigoflow.config.filePath;
			let nodeId = sessionStorage.getItem("SrcId");

			// 节点类型为空，不更新节点x,y坐标
			if (!yigoflow.config.restore || !yigoflow.config.restore.states || !yigoflow.config.restore.states[nodeId] || !yigoflow.config.restore.states[nodeId].props || !yigoflow.config.restore.states[nodeId].props.NodeType || !yigoflow.config.restore.states[nodeId].props.NodeType.value) {
				return;
			}
			let nodeType = yigoflow.config.restore.states[nodeId].props.NodeType.value;

			// json数据
			let requestData = getPageData();
			let params = {
				operType: 2,//操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
				filePath: filePath, content: requestData, nodeId: nodeId
			};

			// ajax请求后台操作
			ajaxRequest(params, 2, nodeType, nodeId, _r);
			if (ajaxStatus) {
				// 更新一下sessionStorage
				let data = getPageData();
				// 更新缓存中的内容
				sessionStorage.removeItem(yigoflow.config.cacheFileName);
				sessionStorage.setItem(yigoflow.config.cacheFileName, data);
				isLockScreen = false;
			}
		};

		// 改变大小的边框
		var _bpath, _bdots = {}, _bw = 5, _bbox = {
			x: _o.attr.x - _o.margin, y: _o.attr.y - _o.margin, // width: _o.attr.width + _o.margin * 2,
			// height: _o.attr.height + _o.margin * 2
			width: _o.attr.width + _o.margin, height: _o.attr.height + _o.margin
		};

		_bpath = _r.path('M0 0L1 1').hide();
		_bdots['t'] = _r.rect(0, 0, _bw, _bw).attr({
			fill: '#000', stroke: '#fff', cursor: 's-resize'
		}).hide().drag(function (dx, dy) {
			bdragMove(dx, dy, 't');
		}, function () {
			bdragStart(this.attr('x') + _bw / 2, this.attr('y') + _bw / 2, 't');
		}, function () {
		});// 上
		_bdots['lt'] = _r.rect(0, 0, _bw, _bw).attr({
			fill: '#000', stroke: '#fff', cursor: 'nw-resize'
		}).hide().drag(function (dx, dy) {
			bdragMove(dx, dy, 'lt');
		}, function () {
			bdragStart(this.attr('x') + _bw / 2, this.attr('y') + _bw / 2, 'lt');
		}, function () {
		});// 左上
		_bdots['l'] = _r.rect(0, 0, _bw, _bw).attr({
			fill: '#000', stroke: '#fff', cursor: 'w-resize'
		}).hide().drag(function (dx, dy) {
			bdragMove(dx, dy, 'l');
		}, function () {
			bdragStart(this.attr('x') + _bw / 2, this.attr('y') + _bw / 2, 'l');
		}, function () {
		});// 左
		_bdots['lb'] = _r.rect(0, 0, _bw, _bw).attr({
			fill: '#000', stroke: '#fff', cursor: 'sw-resize'
		}).hide().drag(function (dx, dy) {
			bdragMove(dx, dy, 'lb');
		}, function () {
			bdragStart(this.attr('x') + _bw / 2, this.attr('y') + _bw / 2, 'lb');
		}, function () {
		});// 左下
		_bdots['b'] = _r.rect(0, 0, _bw, _bw).attr({
			fill: '#000', stroke: '#fff', cursor: 's-resize'
		}).hide().drag(function (dx, dy) {
			bdragMove(dx, dy, 'b');
		}, function () {
			bdragStart(this.attr('x') + _bw / 2, this.attr('y') + _bw / 2, 'b');
		}, function () {
		});// 下
		_bdots['rb'] = _r.rect(0, 0, _bw, _bw).attr({
			fill: '#000', stroke: '#fff', cursor: 'se-resize'
		}).hide().drag(function (dx, dy) {
			bdragMove(dx, dy, 'rb');
		}, function () {
			bdragStart(this.attr('x') + _bw / 2, this.attr('y') + _bw / 2, 'rb');
		}, function () {
		});// 右下
		_bdots['r'] = _r.rect(0, 0, _bw, _bw).attr({
			fill: '#000', stroke: '#fff', cursor: 'w-resize'
		}).hide().drag(function (dx, dy) {
			bdragMove(dx, dy, 'r');
		}, function () {
			bdragStart(this.attr('x') + _bw / 2, this.attr('y') + _bw / 2, 'r')
		}, function () {
		});// 右
		_bdots['rt'] = _r.rect(0, 0, _bw, _bw).attr({
			fill: '#000', stroke: '#fff', cursor: 'ne-resize'
		}).hide().drag(function (dx, dy) {
			bdragMove(dx, dy, 'rt');
		}, function () {
			bdragStart(this.attr('x') + _bw / 2, this.attr('y') + _bw / 2, 'rt')
		}, function () {
		});// 右上
		$([_bdots['t'].node, _bdots['lt'].node, _bdots['l'].node, _bdots['lb'].node, _bdots['b'].node, _bdots['rb'].node, _bdots['r'].node, _bdots['rt'].node]).click(function () {
			return false;
		});

		var bdragMove = function (dx, dy, t) {
			if (!yigoflow.config.editable) return;
			var x = _bx + dx, y = _by + dy;
			switch (t) {
				case 't' :
					_bbox.height += _bbox.y - y;
					_bbox.y = y;
					break;
				case 'lt' :
					_bbox.width += _bbox.x - x;
					_bbox.height += _bbox.y - y;
					_bbox.x = x;
					_bbox.y = y;
					break;
				case 'l' :
					_bbox.width += _bbox.x - x;
					_bbox.x = x;
					break;
				case 'lb' :
					_bbox.height = y - _bbox.y;
					_bbox.width += _bbox.x - x;
					_bbox.x = x;
					break;
				case 'b' :
					_bbox.height = y - _bbox.y;
					break;
				case 'rb' :
					_bbox.height = y - _bbox.y;
					_bbox.width = x - _bbox.x;
					break;
				case 'r' :
					_bbox.width = x - _bbox.x;
					break;
				case 'rt' :
					_bbox.width = x - _bbox.x;
					_bbox.height += _bbox.y - y;
					_bbox.y = y;
					break;
			}

			// 开始，结束等图标不可改变大小
			if (_o.type == "Begin" || _o.type == "End" || _o.type == "BranchEnd" || _o.type == "Decision" || _o.type == "State" || _o.type == "Fork" || _o.type == "Join" || _o.type == "ExclusiveFork" || _o.type == "ComplexJoin" || _o.type == "GateWay") return;
			resize();
			// $('body').append(t);
		};
		var bdragStart = function (ox, oy, t) {
			_bx = ox;
			_by = oy;
		};

		// 单击顺序流时，清空已选择的当前节点
		$("#SequenceFlow").click(function () {
			$(_r).data('currNode', null);
		});
		// 单击连接线时，清空已选择的当前节点
		$("#Association").click(function () {
			$(_r).data('currNode', null);
		});
		// 单击异常流时，清空已选择的当前节点
		$("#ExceptionFlow").click(function () {
			$(_r).data('currNode', null);
		});

		// 事件处理--------------------------------
		$([_rect.node, _text.node, _name.node, _img.node]).bind('click', function () {
			if (!yigoflow.config.editable) {
				return;
			}

			showBox();
			var mod = $(_r).data('mod');
			switch (mod) {
				case 'pointer' :
					break;
				case 'SequenceFlow' :
				case 'Association' :
				case 'ExceptionFlow' :
					var pre = $(_r).data('currNode');
					if (pre && pre.getId() != _id) {
						$(_r).trigger('addpath', [pre, _this]);
						return;
					}
					break;
			}
			$(_r).trigger('click', _this);
			$(_r).data('currNode', _this);
			return false;
		});

		// 节点点击事件
		var clickHandler = function (e, src) {
			if (!yigoflow.config.editable) return;
			if (src.getId() == _id) {
				// 如果ctrl按住，那么将当前单击的节点加到已选择的列表中
				if (ctrlEnabled) {
					if (selectedEles && selectedEles.length > 0) {
						let isExist = false;
						for (let i = 0; i < selectedEles.length; i++) {
							if (selectedEles[i].getId() == src.getId()) {
								isExist = true;
								break;
							}
						}
						if (!isExist) {
							selectedEles.push(src);
						}
					} else {
						// 隐藏ctrl键之前选中的元素
						if (_dotListCurrent) {
							_dotListCurrent.hide();
						}
						if (currentNodeId && currentNodeId != src.getId()) {
							_bpathCurrent.hide();
							for (var k in _bdotsCurrent) {
								_bdotsCurrent[k].hide();
							}
						}
						selectedEles.push(src);
					}
				} else {
					if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[_id]) {
						// 改变节点的显示名称
						_text.attr({
							text: yigoflow.config.restore.states[_id].props.Caption.value
						});
						_o.props.NodeType.value = yigoflow.config.restore.states[_id].props.NodeType.value;
						_o.props.ID.value = yigoflow.config.restore.states[_id].props.ID.value;
						_o.props.Key.value = yigoflow.config.restore.states[_id].props.Key.value;
						_o.props.Caption.value = yigoflow.config.restore.states[_id].props.Caption.value;
					}
					// 设置标题为"属性"
					$("#yigoflow_props_handle").text("属性");
					$(_r).trigger('showprops', [_o.props, src]);
				}
				//设置当前元素选中
				_bpathCurrent = _bpath;
				_bdotsCurrent = _bdots;
				currentNodeId = src.getId();
			} else {
				if (!ctrlEnabled) {
					hideBox();
				}
			}
		};
		$(_r).bind('click', clickHandler);

		var textchangeHandler = function (e, text, src) {
			if (src.getId() == _id) {
				_text.attr({
					text: text
				});
			}
		};
		$(_r).bind('textchange', textchangeHandler);

		// 私有函数-----------------------
		// 边框路径
		function getBoxPathString() {
			return 'M' + _bbox.x + ' ' + _bbox.y + 'L' + _bbox.x + ' ' + (_bbox.y + _bbox.height) + 'L' + (_bbox.x + _bbox.width) + ' ' + (_bbox.y + _bbox.height) + 'L' + (_bbox.x + _bbox.width) + ' ' + _bbox.y + 'L' + _bbox.x + ' ' + _bbox.y;
		}

		// 显示边框
		function showBox() {
			_bpath.show();
			for (var k in _bdots) {
				_bdots[k].show();
			}
		}

		// 隐藏
		function hideBox() {
			_bpath.hide();
			for (var k in _bdots) {
				_bdots[k].hide();
			}
		}

		// 根据_bbox，更新位置信息
		function resize() {
			// 设置改变大小时，最小高度
			if (_bbox.height < 48) {
				_bbox.height = 48;
			}

			// 设置改变大小时，最小宽度
			if (_bbox.width < _o.attr.width + _o.margin) {
				_bbox.width = _o.attr.width + _o.margin * 2;
			}

			var rx = _bbox.x + _o.margin, ry = _bbox.y + _o.margin, rw = _bbox.width - _o.margin * 2,
				rh = _bbox.height - _o.margin * 2;

			_rect.attr({
				x: rx, y: ry, width: rw, height: rh
			});

			switch (_o.showType) {
				case 'image' :
					_img.attr({
						x: rx + (rw - _o.img.width) / 2, y: ry + (rh - _o.img.height) / 2
					}).show();
					break;
				case 'text' :
					if (_o.type == "Swimline") {
						_rect.show();
						_text.attr({
							x: rx + rw / 2, y: ry + 20
						}).show();// 文本
					} else {
						_rect.attr({
							fill: "#F6F7FF"
						});
						_rect.show();
						_text.attr({
							x: rx + rw / 2, y: ry + rh / 2
						}).show();// 文本
						_img.attr({
							x: rx + 2, y: ry + 2, width: 15, height: 15
						}).show();
					}
					break;
				case 'image&text' :
					//_rect.show();
					_name.attr({
						x: rx + _o.img.width + (rw - _o.img.width) / 2, y: ry + yigoflow.config.lineHeight / 2
					}).show();
					// _text.attr({
					//     x: rx + _o.img.width + (rw - _o.img.width) / 2,
					//     y: ry + (rh - yigoflow.config.lineHeight) / 2
					//         + yigoflow.config.lineHeight
					// }).show();// 文本
					_text.attr({
						x: rx + rw / 2, y: ry + _o.img.height + 9,
					}).show();// 文本
					_img.attr({
						x: rx + (rw - _o.img.width) / 2 + 1, y: ry + (rh - _o.img.height) / 2
					}).show();
					break;
			}

			_bdots['t'].attr({
				x: _bbox.x + _bbox.width / 2 - _bw / 2, y: _bbox.y - _bw / 2
			});// 上
			_bdots['lt'].attr({
				x: _bbox.x - _bw / 2, y: _bbox.y - _bw / 2
			});// 左上
			_bdots['l'].attr({
				x: _bbox.x - _bw / 2, y: _bbox.y - _bw / 2 + _bbox.height / 2
			});// 左
			_bdots['lb'].attr({
				x: _bbox.x - _bw / 2, y: _bbox.y - _bw / 2 + _bbox.height
			});// 左下
			_bdots['b'].attr({
				x: _bbox.x - _bw / 2 + _bbox.width / 2, y: _bbox.y - _bw / 2 + _bbox.height
			});// 下
			_bdots['rb'].attr({
				x: _bbox.x - _bw / 2 + _bbox.width, y: _bbox.y - _bw / 2 + _bbox.height
			});// 右下
			_bdots['r'].attr({
				x: _bbox.x - _bw / 2 + _bbox.width, y: _bbox.y - _bw / 2 + _bbox.height / 2
			});// 右
			_bdots['rt'].attr({
				x: _bbox.x - _bw / 2 + _bbox.width, y: _bbox.y - _bw / 2
			});// 右上
			_bpath.attr({
				path: getBoxPathString()
			});

			$(_r).trigger('rectresize', _this);

		};

		// 转化json字串
		this.toJson = function (id, type) {
			var data = "{type:'" + _o.type + "',text:{text:'" + _text.attr('text') + "'}, attr:{ x:" + Math.round(_rect.attr('x')) + ", y:" + Math.round(_rect.attr('y')) + ", width:" + Math.round(_rect.attr('width')) + ", height:" + Math.round(_rect.attr('height')) + "}, props:{";
			for (let k in _o.props) {
				let value = _o.props[k].value;
				if (yigoflow.config.restore && yigoflow.config.restore[type] && yigoflow.config.restore[type][id] && yigoflow.config.restore[type][id]["props"] && yigoflow.config.restore[type][id]["props"][k]) {
					value = yigoflow.config.restore[type][id]["props"][k].value;
				}
				data += k + ":{value:'" + value + "'},";
			}
			if (data.substring(data.length - 1, data.length) == ',') {
				data = data.substring(0, data.length - 1);
			}
			data += "}}";
			return data;
		};

		// 转化json更新字串
		this.toJsonForUpdate = function (id, type, _key, _value) {
			var data = "{type:'" + _o.type + "',text:{text:'" + _text.attr('text') + "'}, attr:{ x:" + Math.round(_rect.attr('x')) + ", y:" + Math.round(_rect.attr('y')) + ", width:" + Math.round(_rect.attr('width')) + ", height:" + Math.round(_rect.attr('height')) + "}, props:{";
			for (let k in _o.props) {
				let value = _o.props[k].value;
				if (k == _key) {
					value = _value;
				} else {
					if (yigoflow.config.restore && yigoflow.config.restore[type] && yigoflow.config.restore[type][id] && yigoflow.config.restore[type][id]["props"] && yigoflow.config.restore[type][id]["props"][k]) {
						value = yigoflow.config.restore[type][id]["props"][k].value;
					}
				}
				data += k + ":{value:'" + value + "'},";
			}
			if (data.substring(data.length - 1, data.length) == ',') {
				data = data.substring(0, data.length - 1);
			}
			data += "}}";
			return data;
		};

		// 从数据中恢复图
		this.restore = function (data) {
			var obj = data;
			_o = $.extend(true, _o, data);

			_text.attr({
				text: obj.text.text
			});
			resize();
		};

		this.getBBox = function () {
			return _bbox;
		};
		this.getId = function () {
			return _id;
		};
		this.remove = function () {
			_rect.remove();
			_text.remove();
			_name.remove();
			_img.remove();
			_bpath.remove();
			for (var k in _bdots) {
				_bdots[k].remove();
			}
		};
		this.text = function () {
			return _text.attr('text');
		};
		this.attr = function (attr) {
			if (attr) {
				_rect.attr(attr);
			}
		};

		resize();// 初始化位置
	};

	yigoflow.path = function (o, r, from, to, uid, type) {
		let _o;
		switch (type) {
			case "SequenceFlow":
				_o = $.extend(true, {}, yigoflow.config.SequenceFlow);
				break;
			case "Association":
				_o = $.extend(true, {}, yigoflow.config.Association);
				break;
			case "ExceptionFlow":
				_o = $.extend(true, {}, yigoflow.config.ExceptionFlow);
				break;
			default:
				break;
		}

		var _this = this, _r = r, _path, _arrow, _text, _textPos = _o.text.textPos, _ox, _oy, _from = from, _to = to,
			_id, _dotList, _autoText = true;

		// 如果是新增，那么产生一个新的id
		if (!uid) {
			_id = 'path' + yigoflow.util.nextId();
		} else {
			_id = uid;
		}

		// 点
		function dot(type, pos, left, right) {
			var _this = this, _t = type, _n, _lt = left, _rt = right, _ox, _oy, // 缓存移动前时位置
				_pos = pos;// 缓存位置信息{x,y}, 注意：这是计算出中心点

			switch (_t) {
				case 'from' :
					_n = _r.rect(pos.x - _o.attr.fromDot.width / 2, pos.y - _o.attr.fromDot.height / 2, _o.attr.fromDot.width, _o.attr.fromDot.height)
						.attr(_o.attr.fromDot);
					break;
				case 'big' :
					_n = _r.rect(pos.x - _o.attr.bigDot.width / 2, pos.y - _o.attr.bigDot.height / 2, _o.attr.bigDot.width, _o.attr.bigDot.height)
						.attr(_o.attr.bigDot);
					break;
				case 'small' :
					_n = _r.rect(pos.x - _o.attr.smallDot.width / 2, pos.y - _o.attr.smallDot.height / 2, _o.attr.smallDot.width, _o.attr.smallDot.height)
						.attr(_o.attr.smallDot);
					break;
				case 'to' :
					_n = _r.rect(pos.x - _o.attr.toDot.width / 2, pos.y - _o.attr.toDot.height / 2, _o.attr.toDot.width, _o.attr.toDot.height)
						.attr(_o.attr.toDot);

					break;
			}
			if (_n && (_t == 'big' || _t == 'small')) {
				_n.drag(function (dx, dy) {
					dragMove(dx, dy);
				}, function () {
					dragStart()
				}, function () {
					dragUp();
				});// 初始化拖动
				var dragMove = function (dx, dy) {// 拖动中
					var x = (_ox + dx), y = (_oy + dy);
					_this.moveTo(x, y);
				};

				var dragStart = function () {// 开始拖动
					if (_t == 'big') {
						_ox = _n.attr("x") + _o.attr.bigDot.width / 2;
						_oy = _n.attr("y") + _o.attr.bigDot.height / 2;
					}
					if (_t == 'small') {
						_ox = _n.attr("x") + _o.attr.smallDot.width / 2;
						_oy = _n.attr("y") + _o.attr.smallDot.height / 2;
					}
				};

				var dragUp = function () {// 拖动结束

				};
			}
			$(_n.node).click(function () {
				return false;
			});

			this.type = function (t) {
				if (t) _t = t; else return _t;
			};
			this.node = function (n) {
				if (n) _n = n; else return _n;
			};
			this.left = function (l) {
				if (l) _lt = l; else return _lt;
			};
			this.right = function (r) {
				if (r) _rt = r; else return _rt;
			};
			this.remove = function () {
				_lt = null;
				_rt = null;
				_n.remove();
			};
			this.pos = function (pos) {
				if (pos) {
					_pos = pos;
					_n.attr({
						x: _pos.x - _n.attr('width') / 2, y: _pos.y - _n.attr('height') / 2
					});
					return this;
				} else {
					return _pos
				}
			};

			this.moveTo = function (x, y) {
				this.pos({
					x: x, y: y
				});

				switch (_t) {
					case 'from' :
						if (_rt && _rt.right() && _rt.right().type() == 'to') {
							_rt.right().pos(yigoflow.util.connPoint(_to.getBBox(), _pos));
						}
						if (_rt && _rt.right()) {
							_rt
								.pos(yigoflow.util.center(_pos, _rt.right()
									.pos()));
						}
						break;
					case 'big' :

						if (_rt && _rt.right() && _rt.right().type() == 'to') {
							_rt.right().pos(yigoflow.util.connPoint(_to.getBBox(), _pos));
						}
						if (_lt && _lt.left() && _lt.left().type() == 'from') {
							_lt.left().pos(yigoflow.util.connPoint(_from
								.getBBox(), _pos));
						}
						if (_rt && _rt.right()) {
							_rt
								.pos(yigoflow.util.center(_pos, _rt.right()
									.pos()));
						}
						if (_lt && _lt.left()) {
							_lt.pos(yigoflow.util.center(_pos, _lt.left().pos()));
						}
						// 三个大点在一条线上，移除中间的小点
						var pos = {
							x: _pos.x, y: _pos.y
						};
						if (yigoflow.util.isLine(_lt.left().pos(), pos, _rt
							.right().pos())) {
							_t = 'small';
							_n.attr(_o.attr.smallDot);
							this.pos(pos);
							var lt = _lt;
							_lt.left().right(_lt.right());
							_lt = _lt.left();
							lt.remove();
							var rt = _rt;
							_rt.right().left(_rt.left());
							_rt = _rt.right();
							rt.remove();
							// $('body').append('ok.');
						}
						break;
					case 'small' :// 移动小点时，转变为大点，增加俩个小点
						if (_lt && _rt && !yigoflow.util.isLine(_lt.pos(), {
							x: _pos.x, y: _pos.y
						}, _rt.pos())) {

							_t = 'big';

							_n.attr(_o.attr.bigDot);
							var lt = new dot('small', yigoflow.util.center(_lt
								.pos(), _pos), _lt, _lt
								.right());
							_lt.right(lt);
							_lt = lt;

							var rt = new dot('small', yigoflow.util.center(_rt
								.pos(), _pos), _rt.left(), _rt);
							_rt.left(rt);
							_rt = rt;

						}
						break;
					case 'to' :
						if (_lt && _lt.left() && _lt.left().type() == 'from') {
							_lt.left().pos(yigoflow.util.connPoint(_from
								.getBBox(), _pos));
						}
						if (_lt && _lt.left()) {
							_lt.pos(yigoflow.util.center(_pos, _lt.left().pos()));
						}
						break;
				}

				refreshpath();

			};
		}

		function dotList() {
			// if(!_from) throw '没有from节点!';
			var _fromDot, _toDot, _fromBB = _from.getBBox(), _toBB = _to.getBBox(), _fromPos, _toPos;

			_fromPos = yigoflow.util.connPoint(_fromBB, {
				x: _toBB.x + _toBB.width / 2, y: _toBB.y + _toBB.height / 2
			});
			_toPos = yigoflow.util.connPoint(_toBB, _fromPos);

			_fromDot = new dot('from', _fromPos, null, new dot('small', {
				x: (_fromPos.x + _toPos.x) / 2, y: (_fromPos.y + _toPos.y) / 2
			}));
			_fromDot.right().left(_fromDot);
			_toDot = new dot('to', _toPos, _fromDot.right(), null);
			_fromDot.right().right(_toDot);

			// 转换为path格式的字串
			this.toPathString = function () {
				if (!_fromDot) return '';

				var d = _fromDot, p = 'M' + d.pos().x + ' ' + d.pos().y, arr = '';
				// 线的路径
				while (d.right()) {
					d = d.right();
					p += 'L' + d.pos().x + ' ' + d.pos().y;
				}
				// 箭头路径
				var arrPos = yigoflow.util.arrow(d.left().pos(), d.pos(), _o.attr.arrow.radius);
				arr = 'M' + arrPos[0].x + ' ' + arrPos[0].y + 'L' + arrPos[1].x + ' ' + arrPos[1].y + 'L' + arrPos[2].x + ' ' + arrPos[2].y + 'z';
				return [p, arr];
			};
			this.toJson = function () {
				var data = "[", d = _fromDot;

				while (d) {
					if (d.type() == 'big') data += "{x:" + Math.round(d.pos().x) + ",y:" + Math.round(d.pos().y) + "},";
					d = d.right();
				}
				if (data.substring(data.length - 1, data.length) == ',') data = data.substring(0, data.length - 1);
				data += "]";
				return data;
			};
			this.restore = function (data) {
				var obj = data, d = _fromDot.right();

				for (var i = 0; i < obj.length; i++) {
					d.moveTo(obj[i].x, obj[i].y);
					d.moveTo(obj[i].x, obj[i].y);
					d = d.right();
				}

				this.hide();
			};

			this.fromDot = function () {
				return _fromDot;
			};
			this.toDot = function () {
				return _toDot;
			};
			this.midDot = function () {// 返回中间点
				var mid = _fromDot.right(), end = _fromDot.right().right();
				while (end.right() && end.right().right()) {
					end = end.right().right();
					mid = mid.right();
				}
				return mid;
			};
			this.show = function () {
				var d = _fromDot;
				while (d) {
					d.node().show();
					d = d.right();
				}
			};
			this.hide = function () {
				var d = _fromDot;
				while (d) {
					d.node().hide();
					d = d.right();
				}
			};
			this.remove = function () {
				var d = _fromDot;
				while (d) {
					if (d.right()) {
						d = d.right();
						d.left().remove();
					} else {
						d.remove();
						d = null;
					}
				}
			};
		}

		// 初始化操作
		_o = $.extend(true, _o, o);
		// 设置虚线
		if (type == "Association") {
			_o.attr.path["stroke-dasharray"] = "--";
			_o.attr.path["arrow-end"] = "open-wide-long";
		} else if (type == "ExceptionFlow") { // 设置路径颜色
			_o.attr.path["stroke"] = "#ff0000";
			_o.attr.arrow["stroke"] = "#ff0000";
			_o.attr.arrow["fill"] = "#ff0000";
			_o.attr.fromDot["stroke"] = "#ff0000";
			_o.attr.fromDot["fill"] = "#ff0000";
			_o.attr.toDot["stroke"] = "";
			_o.attr.toDot["fill"] = "";
			_o.attr.bigDot["stroke"] = "#ff0000";
			_o.attr.bigDot["fill"] = "#fff";
			_o.attr.smallDot["stroke"] = "#ff0000";
			_o.attr.smallDot["fill"] = "#fff";
			_o.attr.text["stroke"] = "#ff0000";
			_o.attr.text["background"] = "#fff";
		}
		_path = _r.path(_o.attr.path.path).attr(_o.attr.path);
		_arrow = _r.path(_o.attr.arrow.path).attr(_o.attr.arrow);

		_dotList = new dotList();
		_dotList.hide();

		// _text = _r.text(0, 0, _o.text.text || _o.text.patten.replace('{from}', _from.text()).replace('{to}',
		//     _to.text())).attr(_o.attr.text);
		_text = _r.text(0, 0, _o.text.text || '').attr(_o.attr.text);
		_text.drag(function (dx, dy) {
			if (!yigoflow.config.editable) return;
			_text.attr({
				x: _ox + dx, y: _oy + dy
			});
		}, function () {
			_ox = _text.attr('x');
			_oy = _text.attr('y');
		}, function () {
			var mid = _dotList.midDot().pos();
			_textPos = {
				x: _text.attr('x') - mid.x, y: _text.attr('y') - mid.y
			};
		});

		refreshpath();// 初始化路径

		// 事件处理--------------------
		$([_path.node, _arrow.node, _text.node]).bind('click', function () {
			if (!yigoflow.config.editable) return;
			$(_r).trigger('click', _this);
			$(_r).data('currNode', _this);
			return false;
		});

		// 处理点击事件，线或矩形
		var clickHandler = function (e, src) {
			if (!yigoflow.config.editable) return;
			if (src && src.getId() == _id) {
				_dotList.show();
				if (!ctrlEnabled) {
					// ajax请求后台后，将连线的相关属性写入属性框中
					// 节点id
					let nodeId = _id;

					// 节点类型
					let nodeType = $(_r).data().mod;
					if (!nodeType || nodeType == "point" || nodeType == "pointer") {
						if (yigoflow.config.restore.paths[nodeId] && yigoflow.config.restore.paths[nodeId].props.NodeType) {
							nodeType = yigoflow.config.restore.paths[nodeId].props.NodeType.value;
							$(_r).data('mod', nodeType);
						}
					}
					// 文件路径
					let filePath = yigoflow.config.filePath;
					// json数据
					let requestData = getPageData();
					let params = {
						operType: 1,// 操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
						filePath: filePath, content: requestData, nodeId: nodeId
					};

					// ajax请求后台操作
					ajaxRequest(params, 1, nodeType, nodeId, _r);
					if (ajaxStatus) {
						// 设置路径的属性值
						_o.props.NodeType.value = yigoflow.config.restore.paths[nodeId].props.NodeType.value;
						_o.props.ID.value = yigoflow.config.restore.paths[nodeId].props.ID.value;
						_o.props.Key.value = yigoflow.config.restore.paths[nodeId].props.Key.value;
						_o.props.Caption.value = yigoflow.config.restore.paths[nodeId].props.Caption.value;
						_o.props.TargetNodeKey.value = yigoflow.config.restore.paths[nodeId].props.TargetNodeKey.value;
						if (yigoflow.config.restore.paths[nodeId].props.State && yigoflow.config.restore.paths[nodeId].props.State.value) {
							_o.props.State.value = yigoflow.config.restore.paths[nodeId].props.State.value;
						}
						if (yigoflow.config.restore.paths[nodeId].props.Condition && yigoflow.config.restore.paths[nodeId].props.Condition.value) {
							_o.props.Condition.value = yigoflow.config.restore.paths[nodeId].props.Condition.value;
						}

						// 设置标题为"属性"
						$("#yigoflow_props_handle").text("属性");
						// 显示路径的属性窗口
						$(_r).trigger('showprops', [_o.props, _this]);
						// 清空路径按钮选择样式，避免画不不要的连线
						$('.selected').removeClass('selected');
						$(_r).data('mod', "pointer");

						// 保存数据到浏览器缓存
						// 更新一下sessionStorage
						let data = getPageData();
						// 更新缓存中的内容
						sessionStorage.removeItem(yigoflow.config.cacheFileName);
						sessionStorage.setItem(yigoflow.config.cacheFileName, data);
					}
				} else {
					if (selectedEles && selectedEles.length > 0) {
						let isExist = false;
						for (let i = 0; i < selectedEles.length; i++) {
							if (selectedEles[i].getId() == src.getId()) {
								isExist = true;
								break;
							}
						}
						if (!isExist) {
							selectedEles.push(src);
						}
					} else {
						// 隐藏ctrl键之前选中的元素
						if (currentPathId && currentPathId != src.getId()) {
							_dotListCurrent.hide();
						}
						if (_bpathCurrent) {
							_bpathCurrent.hide();
							for (var k in _bdotsCurrent) {
								_bdotsCurrent[k].hide();
							}
						}
						selectedEles.push(src);
					}
				}
				_dotListCurrent = _dotList;
				currentPathId = src.getId();
			} else {
				if (!ctrlEnabled) {
					_dotList.hide();
				}
			}

			var mod = $(_r).data('mod');
			switch (mod) {
				case 'pointer' :
					break;
				case 'SequenceFlow' :
				case 'Association' :
				case 'ExceptionFlow' :
					break;
			}
		};
		$(_r).bind('click', clickHandler);


		// 删除事件处理
		var removerectHandler = function (e, src) {
			if (!yigoflow.config.editable || true == $('#dialog').dialog('isOpen') || true == $('#processAndBillsDialog').dialog('isOpen') || isLockScreen == true) return;
			if (src && (src.getId() == _from.getId() || src.getId() == _to.getId())) {
				// _this.remove();
				$(_r).trigger('removepath', _this);
			}
		};
		$(_r).bind('removerect', removerectHandler);

		// 矩形移动事件处理
		var rectresizeHandler = function (e, src) {
			sessionStorage.setItem("SrcId", src.getId());
			if (!yigoflow.config.editable) return;
			if (_from && _from.getId() == src.getId()) {
				var rp;
				if (_dotList.fromDot().right().right().type() == 'to') {
					rp = {
						x: _to.getBBox().x + _to.getBBox().width / 2, y: _to.getBBox().y + _to.getBBox().height / 2
					};
				} else {
					rp = _dotList.fromDot().right().right().pos();
				}
				var p = yigoflow.util.connPoint(_from.getBBox(), rp);
				_dotList.fromDot().moveTo(p.x, p.y);
				refreshpath();
			}
			if (_to && _to.getId() == src.getId()) {
				var rp;
				if (_dotList.toDot().left().left().type() == 'from') {
					rp = {
						x: _from.getBBox().x + _from.getBBox().width / 2,
						y: _from.getBBox().y + _from.getBBox().height / 2
					};
				} else {
					rp = _dotList.toDot().left().left().pos();
				}
				var p = yigoflow.util.connPoint(_to.getBBox(), rp);
				_dotList.toDot().moveTo(p.x, p.y);
				refreshpath();
			}
		};
		$(_r).bind('rectresize', rectresizeHandler);

		var textchangeHandler = function (e, v, src) {
			if (src.getId() == _id) {// 改变自身文本
				_text.attr({
					text: v
				});
				_autoText = false;
			}
			// 注释掉连线上TOxxx的文本显示
			// if (_autoText) {
			//     if (_to.getId() == src.getId()) {
			//         _text.attr({
			//             text: _o.text.patten.replace('{from}',
			//                 _from.text()).replace('{to}', v)
			//         });
			//     } else if (_from.getId() == src.getId()) {
			//         _text.attr({
			//             text: _o.text.patten.replace('{from}', v)
			//                 .replace('{to}', _to.text())
			//         });
			//     }
			// }
		};
		$(_r).bind('textchange', textchangeHandler);

		this.from = function () {
			return _from;
		};
		this.to = function () {
			return _to;
		};
		// 转化json数据
		this.toJson = function () {
			var data = "{from:'" + _from.getId() + "',to:'" + _to.getId() + "', dots:" + _dotList.toJson() + ",text:{text:'" + _text.attr('text') + "',textPos:{x:" + Math.round(_textPos.x) + ",y:" + Math.round(_textPos.y) + "}}, props:{";
			for (var k in _o.props) {
				data += k + ":{value:'" + _o.props[k].value + "'},";
			}
			if (data.substring(data.length - 1, data.length) == ',') data = data.substring(0, data.length - 1);
			data += '}}';
			return data;
		};

		// 转化json字串
		this.toJson = function (id, type) {
			let data = "{from:'" + _from.getId() + "',to:'" + _to.getId() + "', dots:" + _dotList.toJson() + ",text:{text:'" + _text.attr('text') + "',textPos:{x:" + Math.round(_textPos.x) + ",y:" + Math.round(_textPos.y) + "}}, props:{";
			for (let k in _o.props) {
				let value = _o.props[k].value;
				if (yigoflow.config.restore && yigoflow.config.restore[type] && yigoflow.config.restore[type][id] && yigoflow.config.restore[type][id]["props"] && yigoflow.config.restore[type][id]["props"][k]) {
					value = yigoflow.config.restore[type][id]["props"][k].value;
				}
				// 设置路径节点类型
				if (k == "NodeType" && !value) {
					value = $(_r).data().mod;
				}
				data += k + ":{value:'" + value + "'},";
			}
			if (data.substring(data.length - 1, data.length) == ',') {
				data = data.substring(0, data.length - 1);
			}
			data += '}}';
			return data;
		};

		// 转化json更新字串
		this.toJsonForUpdate = function (id, type, _key, _value) {
			var data = "{from:'" + _from.getId() + "',to:'" + _to.getId() + "', dots:" + _dotList.toJson() + ",text:{text:'" + _text.attr('text') + "',textPos:{x:" + Math.round(_textPos.x) + ",y:" + Math.round(_textPos.y) + "}}, props:{";
			for (var k in _o.props) {
				let value = _o.props[k].value;
				if (k == _key) {
					value = _value;
				} else {
					if (yigoflow.config.restore && yigoflow.config.restore[type] && yigoflow.config.restore[type][id] && yigoflow.config.restore[type][id]["props"] && yigoflow.config.restore[type][id]["props"][k]) {
						value = yigoflow.config.restore[type][id]["props"][k].value;
					}
				}
				if ("Perm" == k) {
					data += k + ":" + value + ",";
				} else {
					data += k + ":{value:'" + value + "'},";
				}
			}
			if (data.substring(data.length - 1, data.length) == ',') data = data.substring(0, data.length - 1);
			data += '}}';
			return data;
		};

		// 恢复
		this.restore = function (data) {
			let obj = data;

			_o = $.extend(true, _o, data);
			if (_text.attr('text') != _o.text.text) {
				_text.attr({text: _o.text.text});
				_autoText = false;
			}

			_dotList.restore(obj.dots);
		};
		// 删除
		this.remove = function () {
			_dotList.remove();
			_path.remove();
			_arrow.remove();
			_text.remove();
			try {
				$(_r).unbind('click', clickHandler);
			} catch (e) {
			}
			try {
				$(_r).unbind('removerect', removerectHandler);
			} catch (e) {
			}
			try {
				$(_r).unbind('rectresize', rectresizeHandler);
				;
			} catch (e) {
			}
			try {
				$(_r).unbind('textchange', textchangeHandler);
			} catch (e) {
			}
		};

		// 刷新路径
		function refreshpath() {
			var p = _dotList.toPathString(), mid = _dotList.midDot().pos();
			_path.attr({
				path: p[0]
			});
			_arrow.attr({
				path: p[1]
			});
			_text.attr({
				x: mid.x + _textPos.x, y: mid.y + _textPos.y
			});
			// $('body').append('refresh.');
		}

		this.getId = function () {
			return _id;
		};
		this.text = function () {
			return _text.attr('text');
		};
		this.attr = function (attr) {
			if (attr && attr.path) _path.attr(attr.path);
			if (attr && attr.arrow) _arrow.attr(attr.arrow);
			// $('body').append('aaaaaa');
		};

	};

	yigoflow.props = function (o, r) {
		var _this = this, _pdiv = $('#yigoflow_props').hide().draggable({
			handle: '#yigoflow_props_handle'
		}).bind('click', function () {
			return false;
		}), _tb = _pdiv.find('table'), _r = r, _src;

		var showpropsHandler = function (e, props, src) {
			// if (_src && _src.getId() == src.getId()) {// 连续点击不刷新
			//     return;
			// }
			_src = src;
			$(_tb).find('.editor').each(function () {
				var e = $(this).data('editor');
				// if (e)
				// e.destroy();
			});
			_tb.empty();
			_pdiv.show();
			for (var k in props) {
				_tb.append('<tr><th>' + props[k].label + '</th><td><div id="p' + k + '" class="editor" style="margin-right:4px;"></div></td></tr>');
				if (props[k].editor) props[k].editor().init(props, k, 'p' + k, src, _r);
				// $('body').append(props[i].editor+'a');
			}
		};
		$(_r).bind('showprops', showpropsHandler);

	};
	/**数据映射页面构建*/
	yigoflow.dataMapprops = function (o, r) {
		var _this = this, _pdiv = $('#yigoflow_dataMapprops').draggable({
			handle: '#yigoflow_dataMapprops_handle'
		}).resizable().css(yigoflow.config.dataMapprops.attr).bind('click', function () {
			return false;
		}), _tb = _pdiv.find('table'), _r = r, _src;

		var showpropsHandler = function (e, props, src) {
			_src = src;
			_tb.empty();
			_pdiv.show();
			for (var k in props) {
				_tb.append('<tr><th>' + props[k].label + '</th><td><div id="p' + k + '" class="editor" style="margin-right:4px;"></div></td></tr>');
				if (props[k].editor) props[k].editor().init(props, k, 'p' + k, src, _r);
			}
		};
		$(_r).bind('showprops', showpropsHandler);
	};

	/**获取表单字段渲染数据表格*/
	function formField(table, DataMapDataJson, layer) {
		(function (_$) {
			table.render({
				elem: '#formFieldOpen',
				even: true,
				loading: true,
				height: 495,
				limit: Number.MAX_VALUE,
				defaultToolbar: [],
				contentType: "application/x-www-form-urlencoded",
				data: DataMapDataJson,
				cols: [[{
					field: 'checked', type: 'checkbox',
				}, {
					field: 'DataSource', width: 150, title: '所属表'
				}, {
					field: 'Key', title: '字段标识', width: 250
				}, {
					field: 'Caption', title: '字段名称', width: 250
				}, {
					field: 'TableKey', hide: true
				}]],
				done: function (res) {
					//可以自行添加判断的条件是否选中
					//这句才是真正选中，通过设置关键字LAY_CHECKED为true选中，这里只对第一行选
					var data2 = [];
					for (let i = 0; i < res.count; i++) {
						if (res.data[i].checked) {
							res.data[i]["LAY_CHECKED"] = 'true';
							//下面三句是通过更改css来实现选中的效果
							var index = res.data[i]['LAY_TABLE_INDEX'];
							$('tr[data-index =' + index + ']').find("input").prop('checked', true);
							$('tr[data-index =' + index + ']').find("div").addClass('layui-form-checked');
							$('tr[data-index =' + index + ']').find("input").addClass('layui-btn-disabled');
							$('tr[data-index =' + index + ']').find("input").prop('disabled', true);
							$('tr[data-index =' + index + ']').addClass("tr_bj_color");
							data2.push(res.data[i])
						}
					}
					if (data2.length == res.count) {
						$('th[data-field="checked"]').find("input").prop('checked', true);
						$('th[data-field="checked"]').find("input").prop('disabled', true);
						$('th[data-field="checked"]').find("div").addClass('layui-form-checked');
						$('th[data-field="checked"]').find("div").addClass('layui-btn-disabled');
					}


				},
			});
			let data_tr;
			//监听表格复选框选择
			table.on('checkbox(formFieldOpen)', function (obj) {
				data_tr = $(this);
				//全选时
				if (obj.type === "all") {
					$(this).parent().siblings("td").find("inpiut").prop("checked", obj.checked)
					table.render('checkbox');
					if (obj.checked) {//全选中

						var checkStatus = table.checkStatus('formFieldOpen');
						var sdata = checkStatus.data;
						if (sdata.length > 0) {//渲染背景颜色
							_$(".layui-table-body .layui-table tr").each(function () {
								_$(this).addClass("tr_bj_color");
							})
						}
					} else {//全部不选
						$(".layui-table-body .layui-table tr").each(function () {
							if ($(this).find('input')[0].className != 'layui-btn-disabled') {
								_$(this).removeClass("tr_bj_color");
							}
						})
					}
				} else {//单选
					if (obj.checked) {//选中
						obj.tr.addClass('tr_bj_color');
					} else {//取消选中
						if (obj.tr.find('input')[0].className != 'layui-btn-disabled') {
							obj.tr.removeClass("tr_bj_color");
						}
					}
				}
			});
		})(jQuery);
	}

	/**源表单页面构建*/
	yigoflow.sourceprops = function (o, r, sourceFormKey) {
		var _this = this, _pdiv = $('#yigoflow_sourceProps').draggable({
			handle: '#yigoflow_sourceProps_handle'
		}).bind('click', function () {
			return false;
		}), _tb = _pdiv.find('table'), _r = r, _src;

		var showpropsHandler = function (e, props, src) {
			_src = src;
			$(_tb).find('.editor').each(function () {
				var e = $(this).data('editor');
				if (e) e.destroy();
			});

			_tb.empty();
			_pdiv.show();
			for (var k in props) {
				if (k === 'formField') {
					_tb.append('<tr id="tr' + sourceFormKey + '"><td><div id="p' + k + '" class="editor" style="margin-right:4px;"></div></td></tr>');
					if (props[k].editor) props[k].editor().init(props, k, 'p' + k, src, _r);
					//先添加下拉框再添加按钮及其操作
					$("#" + "p" + k).append('<input type="button" id="buttonID" style="width: 10%;height: 29px;border-radius: 10%" name="button" value="..." />');
					$("#buttonID").bind('click', function (e) {
						var table = layui.table;
						var layer = layui.layer;
						let nodeName = PanelJudge(sourceFormKey);
						let dataMapParams = {
							operType: 0, filePath: yigoflow.config.filePath, formKey: sourceFormKey, nodeName: nodeName
						};
						getfinAllFormField(dataMapParams);
						//渲染数据表格显示表单字段
						formField(table, DataMapDataJson, layer);
						$("#operationCollectionId").show();
						$("#dialog").dialog({
							autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
								"确定": function (e) {
									//获取勾选的复选框字段
									var _thisDiag = $(this);
									var checkStatus = table.checkStatus('formFieldOpen'), data = checkStatus.data;
									for (let i = 0; i < data.length; i++) {//移除已经添加的字段
										let datum = data[i];
										if (datum.checked) {
											data.splice(i, 1);//将使后面的元素依次前移，数组长度减1
											i--; // 如果不减，将漏掉一个元素
										}
									}
									if (data.length == 0) {
										_thisDiag.dialog("close");
										return;
									}
									//将数据转换为数组
									var data2 = [];
									for (let i in data) {
										let o = {};
										o[i] = data[i];
										data2.push(o)
									}
									//拼接字符串
									let str = "", arr = [];
									data2.map(function (value, index, data2) {
										var number = value[index].DataSource.replace(/[^0-9]/ig, ""),
											key = value[index].Key, caption = value[index].Caption,
											tablekey = value[index].TableKey;
										var strconcat = str.concat("" + number + "_@_" + "", "" + key + "_@_" + "", "" + caption + "_@_" + "", "" + tablekey + "_@_", "" + sessionStorage.getItem("formKey" + yigoflow.config.cacheFileName) + "");
										arr.push(strconcat);
									});
									let filePath = yigoflow.config.filePath;
									let nodeName = PanelJudge(sourceFormKey);
									//调用ajax进行后台数据处理
									let params = {
										operType: 0,
										filePath: filePath,
										content: "{key:'" + "formField" + "',value:'" + arr + "'}",
										nodeName: nodeName,
										batchAddArr: arr,
										nodeId: 0
									};
									ajaxDataMapUpdateXml(params);
									_thisDiag.dialog("close");
								}, "取消": function (e) {
									var _thisDiag = $(this);
									_thisDiag.dialog("close");
								}
							}
						})
					});
				} else {
					_tb.append('<tr><th>' + props[k].label + '</th><td><div id="p' + k + '" class="editor" style="margin-right:4px;"></div></td></tr>');
				}
			}
		};
		$(_r).bind('showsourceprops', showpropsHandler);
	};
	/**目标表单页面构建*/
	yigoflow.targetprops = function (o, r, targetFormkey) {
		var _this = this, _pdiv = $('#yigoflow_targetProps').draggable({
			handle: '#yigoflow_targetProps_handle'
		}).bind('click', function () {
			return false;
		}), _tb = _pdiv.find('table'), _r = r, _src;

		var showpropsHandler = function (e, props, src) {
			_src = src;
			$(_tb).find('.editor').each(function () {
				var e = $(this).data('editor');
				if (e) e.destroy();
			});

			_tb.empty();
			_pdiv.show();
			for (var k in props) {
				if (k === 'formField' || k === 'targetFormField') {
					_tb.append('<tr id="tr' + targetFormkey + '"><td><div id="p' + k + '" class="editor" style="margin-right:4px;"></div></td></tr>');
					//先添加下拉框再添加按钮及其操作
					if (props[k].editor) props[k].editor().init(props, k, 'p' + k, src, _r);
					$("#" + "p" + k).append('<input type="button" id="targetbuttonID" style="width: 10%;height: 29px;border-radius: 10%" name="button" value="..." />');
					$("#targetbuttonID").bind('click', function (e) {
						var table = layui.table;
						var layer = layui.layer;
						let nodeName = PanelJudge(targetFormkey);
						let dataMapParams = {
							operType: 0, filePath: yigoflow.config.filePath, formKey: targetFormkey, nodeName: nodeName
						};
						getfinAllFormField(dataMapParams);
						//渲染数据表格显示表单字段
						formField(table, DataMapDataJson, layer);
						$("#operationCollectionId").show();
						$("#dialog").dialog({
							autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
								"确定": function (e) {
									//获取勾选的复选框字段
									var _thisDiag = $(this);
									var checkStatus = table.checkStatus('formFieldOpen'), data = checkStatus.data;
									for (let i = 0; i < data.length; i++) {//移除已经添加的字段
										let datum = data[i];
										if (datum.checked) {
											data.splice(i, 1);//将使后面的元素依次前移，数组长度减1
											i--; // 如果不减，将漏掉一个元素
										}
									}
									if (data.length == 0) {
										_thisDiag.dialog("close");
										return;
									}
									//将数据转换为数组
									var data2 = [];
									for (let i in data) {
										let o = {};
										o[i] = data[i];
										data2.push(o)
									}
									//拼接字符串
									let str = "", arr = [];
									data2.map(function (value, index, data2) {
										var number = value[index].DataSource.replace(/[^0-9]/ig, ""),
											key = value[index].Key, caption = value[index].Caption,
											tablekey = value[index].TableKey;
										var strconcat = str.concat("" + number + "_@_" + "", "" + key + "_@_" + "", "" + caption + "_@_" + "", "" + tablekey + "_@_", "" + sessionStorage.getItem("formKey" + yigoflow.config.cacheFileName) + "");
										arr.push(strconcat);
									});
									let filePath = yigoflow.config.filePath;
									let nodeName = PanelJudge(targetFormkey);
									//调用ajax进行后台数据处理
									let params = {
										operType: 0,
										filePath: filePath,
										content: "{key:'" + "formField" + "',value:'" + arr + "'}",
										nodeName: nodeName,
										batchAddArr: arr,
										nodeId: 0
									};
									ajaxDataMapUpdateXml(params);
									_thisDiag.dialog("close");
								}, "取消": function (e) {
									var _thisDiag = $(this);
									_thisDiag.dialog("close");
								}
							}
						})
					});
				} else {
					_tb.append('<tr><th>' + props[k].label + '</th><td><div id="p' + k + '" class="editor" style="margin-right:4px;"></div></td></tr>');
				}
			}
		};
		$(_r).bind('showtargetprops', showpropsHandler);
	};
	/**反填表单页面构建*/
	yigoflow.feedbackprops = function (o, r, feedbackForm) {
		let formKey = undefined;
		if (feedbackForm) {
			formKey = feedbackForm;
		} else {
			formKey = feedbackForm;
		}
		var _this = this, _pdiv = $('#DIV_' + formKey).draggable({
			handle: '#Head_' + formKey
		}).bind('click', function () {
			return false;
		}), _tb = _pdiv.find('table'), _r = r, _src;

		var showpropsHandler = function (e, props, src) {
			_src = src;
			$(_tb).find('.editor').each(function () {
				var e = $(this).data('editor');
				if (e) e.destroy();
			});
			_tb.empty();
			_pdiv.show();
			for (var k in props) {
				if (k.indexOf('feedbackFormField') != -1) {
					// feedbackForm.split("__")[0];
					_tb.append('<tr id="tr' + feedbackForm + '"><td><div id="p' + feedbackForm + '" class="editor" style="margin-right:4px;"></div></td></tr>');
					if (props[k].editor) props[k].editor().init(props, k, 'p' + feedbackForm, src, _r);
					//先添加下拉框再添加按钮及其操作
					$("#" + "p" + feedbackForm).append('<input type="button" id="button_' + feedbackForm + '" style="width:10%;height: 29px;border-radius: 10%" name="button" value="..." />');
					$("#button_" + feedbackForm).bind('click', function (e) {
						var table = layui.table;
						var layer = layui.layer;
						let nodeName = PanelJudge(feedbackForm);
						let dataMapParams = {
							operType: 0, filePath: yigoflow.config.filePath, formKey: feedbackForm, nodeName: nodeName
						};
						getfinAllFormField(dataMapParams);
						//渲染数据表格显示表单字段
						formField(table, DataMapDataJson, layer);
						$("#operationCollectionId").show();
						$("#dialog").dialog({
							autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
								"确定": function (e) {
									//获取勾选的复选框字段
									var _thisDiag = $(this);
									var checkStatus = table.checkStatus('formFieldOpen'), data = checkStatus.data;
									for (let i = 0; i < data.length; i++) {//移除已经添加的字段
										let datum = data[i];
										if (datum.checked) {
											data.splice(i, 1);//将使后面的元素依次前移，数组长度减1
											i--; // 如果不减，将漏掉一个元素
										}
									}
									if (data.length == 0) {
										_thisDiag.dialog("close");
										return;
									}
									//将数据转换为数组
									var data2 = [];
									for (let i in data) {
										let o = {};
										o[i] = data[i];
										data2.push(o)
									}
									//拼接字符串
									let str = "", arr = [];
									data2.map(function (value, index, data2) {
										var number = value[index].DataSource.replace(/[^0-9]/ig, ""),
											key = value[index].Key, caption = value[index].Caption,
											tablekey = value[index].TableKey;
										var strconcat = str.concat("" + number + "_@_" + "", "" + key + "_@_" + "", "" + caption + "_@_" + "", "" + tablekey + "_@_", "" + feedbackForm + "");
										arr.push(strconcat);
									});
									let filePath = yigoflow.config.filePath;
									//调用ajax进行后台数据处理
									let params = {
										operType: 0,
										filePath: filePath,
										content: "{key:'" + "formField" + "',value:'" + arr + "'}",
										nodeName: "FeedbackCollection",
										batchAddArr: arr,
										nodeId: 0
									};
									ajaxDataMapUpdateXml(params);
									_thisDiag.dialog("close");
								}, "取消": function (e) {
									var _thisDiag = $(this);
									_thisDiag.dialog("close");
								}
							}
						})
					});
				} else {
					_tb.append('<tr><th>' + props[k].label + '</th><td><div id="p' + k + '" class="editor" style="margin-right:4px;"></div></td></tr>');
				}
			}
		};
		$(_r).bind('showfeedbackprops' + feedbackForm, showpropsHandler);
	};
	// 属性编辑器
	yigoflow.editors = {
		textEditor: function () {
			var _props, _k, _div, _src, _r;
			this.init = function (props, k, div, src, r) {
				_props = props;
				_k = k;
				_div = div;
				_src = src;
				_r = r;

				//$('<input style="width:100%;"/>').val(_src.text()).change(
				$('<input style="width:100%;"/>').val(props[_k].value).change(function () {
					props[_k].value = $(this).val();
					$(_r).trigger('textchange', [$(this).val(), _src]);
				}).appendTo('#' + _div);
				// $('body').append('aaaa');

				$('#' + _div).data('editor', this);
			};
			this.destroy = function () {
				$('#' + _div + ' input').each(function () {
					_props[_k].value = $(this).val();
					$(_r).trigger('textchange', [$(this).val(), _src]);
				});
				// $('body').append('destroy.');
			};
		}
	};

	function handlePath(data, k, _r, rmap) {
		let pathType = "SequenceFlow";
		if (data.paths[k] && data.paths[k].props && data.paths[k].props.NodeType && data.paths[k].props.NodeType.value) {
			switch (data.paths[k].props.NodeType.value) {
				case "SequenceFlow":
					pathType = "SequenceFlow";
					break;
				case "Association":
					pathType = "Association";
					break;
				case "ExceptionFlow":
					pathType = "ExceptionFlow";
					break;
				default:
					break;
			}
		}

		let p = new yigoflow.path($.extend(true, {}, yigoflow.config.tools.path, data.paths[k]), _r, rmap[data.paths[k].from], rmap[data.paths[k].to], k, pathType);
		p.restore(data.paths[k]);
		_paths[p.getId()] = p;
		// 记录最大的id
		let id = data.paths[k].props.ID.value;
		if (id > maxId) {
			maxId = id;
		}
	}

	function handlePanel(data) {
		if (data.props) {
			for (let k in data.props.props) {
				_gprops[k] = {};
				_gprops[k].value = data.props.props[k].value;
				yigoflow.config.props.props[k].value = data.props.props[k].value;
			}
		}
	}

	/**
	 *工作流数据恢复方法
	 * */
	function dataResume(data, _r) {
		if (data) {
			rmap = {};
			if (data.states) {
				for (let k in data.states) {
					handleNode(data, k, _r);
				}
			}
			if (data.paths) {
				for (let k in data.paths) {
					handlePath(data, k, _r, rmap);
				}
			}
			handlePanel(data);
		}
		// 历史状态
		let hr = yigoflow.config.historyRects, ar = yigoflow.config.activeRects;
		if (hr.rects.length || ar.rects.length) {
			let rmap = {};
			for (let pid in _paths) {// 先组织MAP
				if (!rmap[_paths[pid].from().text()]) {
					rmap[_paths[pid].from().text()] = {
						rect: _paths[pid].from(), paths: {}
					};
				}
				rmap[_paths[pid].from().text()].paths[_paths[pid].text()] = _paths[pid];
				if (!rmap[_paths[pid].to().text()]) {
					rmap[_paths[pid].to().text()] = {
						rect: _paths[pid].to(), paths: {}
					};
				}
			}
			for (let i = 0; i < hr.rects.length; i++) {
				if (rmap[hr.rects[i].name]) {
					rmap[hr.rects[i].name].rect.attr(hr.rectAttr);
				}
				for (let j = 0; j < hr.rects[i].paths.length; j++) {
					if (rmap[hr.rects[i].name].paths[hr.rects[i].paths[j]]) {
						rmap[hr.rects[i].name].paths[hr.rects[i].paths[j]].attr(hr.pathAttr);
					}
				}
			}
			for (let i = 0; i < ar.rects.length; i++) {
				if (rmap[ar.rects[i].name]) {
					rmap[ar.rects[i].name].rect.attr(ar.rectAttr);
				}
				for (let j = 0; j < ar.rects[i].paths.length; j++) {
					if (rmap[ar.rects[i].name].paths[ar.rects[i].paths[j]]) {
						rmap[ar.rects[i].name].paths[ar.rects[i].paths[j]].attr(ar.pathAttr);
					}
				}
			}
		}
	}

	function deleteNode(c, _r) {
		if (c) {
			if (c.getId().substring(0, 4) == 'rect') {
				$(_r).trigger('removerect', c);
			} else if (c.getId().substring(0, 4) == 'path' || c.getId().substring(0, 12) == 'SequenceFlow' || c.getId().substring(0, 11) == 'Association' || c.getId().substring(0, 13) == 'ExceptionFlow') {
				$(_r).trigger('removepath', c);
			} else {
				$(_r).trigger('removerect', c);
			}
			$(_r).removeData('currNode');
		}
	}

	function handleNode(restore, key, _r) {
		let rect = new yigoflow.rect($.extend(true, {}, yigoflow.config.tools.states[restore.states[key].type], restore.states[key]), _r, '', key);
		rect.restore(restore.states[key]);
		rmap[key] = rect;
		_states[rect.getId()] = rect;
		let id = restore.states[key].props.ID.value;
		if (id > maxId) {
			maxId = id;
		}
		return rect;
	}

// 工作流初始化流程
	yigoflow.init = function (c, o) {
		//更新数据
		DataMapOrMigration = false;
		var _w = $(window).width(), _h = $(window)[0].outerHeight, _r = Raphael(c, _w * 0.99, _h * 0.99);
		$.extend(true, yigoflow.config, o);

		ctrlEnabled = false;
		/**
		 * 删除： 删除状态时，触发removerect事件，连接在这个状态上当路径监听到这个事件，触发removepath删除自身；
		 * 删除路径时，触发removepath事件
		 */

		$(document).keydown(function (arg) {
			if (!yigoflow.config.editable) return;
			if (arg.keyCode == 46) {
				layui.layer.confirm('确定删除吗', {icon: 3, title: '删除确认'}, function (index) {
					layui.layer.close(index);
					if (selectedEles && selectedEles.length > 0) {
						for (let i = 0; i < selectedEles.length; i++) {
							var c = selectedEles[i];
							// 删除节点处理方法
							deleteNode(c, _r);
						}
					} else {
						var c = $(_r).data('currNode');
						if (c) {
							if (c.getId().substring(0, 4) == 'rect') {
								$(_r).trigger('removerect', c);
							} else if (c.getId().substring(0, 4) == 'path' || c.getId().substring(0, 12) == 'SequenceFlow' || c.getId().substring(0, 11) == 'Association' || c.getId().substring(0, 13) == 'ExceptionFlow') {
								$(_r).trigger('removepath', c);
							} else {
								$(_r).trigger('removerect', c);
							}
							$(_r).removeData('currNode');
						}
					}
					let data = getPageData();
					// 更新缓存中的内容
					sessionStorage.removeItem(yigoflow.config.cacheFileName);
					sessionStorage.setItem(yigoflow.config.cacheFileName, data);
					isLockScreen = false;
					// 设置ctrl键为"未设置"
					ctrlEnabled = false;
					// 清空数组
					selectedEles = [];
				});
			} else if (arg.keyCode == 17) { // ctrl键
				var mod = $(_r).data('mod');
				switch (mod) {
					case 'SequenceFlow' :
					case 'Association' :
					case 'ExceptionFlow' :
						ctrlEnabled = false;
						break;
					default:
						ctrlEnabled = true;
						break;
				}
			}
			// alert(arg.keyCode);
		});
		$(window.parent.document).keydown(function (arg) {
			if (!yigoflow.config.editable || window.parent.DESIGNER.UI.getActiveERPForm().formKey !== "WebMap") return;
			if (arg.keyCode == 46) {
				layui.layer.confirm('确定删除吗', {icon: 3, title: '删除确认'}, function (index) {
					layui.layer.close(index);
					if (selectedEles && selectedEles.length > 0) {
						for (let i = 0; i < selectedEles.length; i++) {
							var c = selectedEles[i];
							// 删除节点处理方法
							deleteNode(c, _r);
						}
					} else {
						var c = $(_r).data('currNode');
						if (c) {
							if (c.getId().substring(0, 4) == 'rect') {
								$(_r).trigger('removerect', c);
							} else if (c.getId().substring(0, 4) == 'path' || c.getId().substring(0, 12) == 'SequenceFlow' || c.getId().substring(0, 11) == 'Association' || c.getId().substring(0, 13) == 'ExceptionFlow') {
								$(_r).trigger('removepath', c);
							} else {
								$(_r).trigger('removerect', c);
							}
							$(_r).removeData('currNode');
						}
					}
					let data = getPageData();
					// 更新缓存中的内容
					sessionStorage.removeItem(yigoflow.config.cacheFileName);
					sessionStorage.setItem(yigoflow.config.cacheFileName, data);
					isLockScreen = false;
					// 设置ctrl键为"未设置"
					ctrlEnabled = false;
					// 清空数组
					selectedEles = [];
				});
			} else if (arg.keyCode == 17) { // ctrl键
				var mod = $(_r).data('mod');
				switch (mod) {
					case 'SequenceFlow' :
					case 'Association' :
					case 'ExceptionFlow' :
						ctrlEnabled = false;
						break;
					default:
						ctrlEnabled = true;
						break;
				}
			}
			// alert(arg.keyCode);
		});

		$(document).keyup(function (arg) {
			if (window.parent.DESIGNER.UI.getActiveERPForm().formKey !== "WebMap") {
				return;
			}
			if (arg.keyCode == 17) { // ctrl键
				ctrlEnabled = false;
			}
		});
		$(window.parent.documents).keyup(function (arg) {
			if (window.parent.DESIGNER.UI.getActiveERPForm().formKey !== "WebMap") {
				return;
			}
			if (arg.keyCode == 17) { // ctrl键
				ctrlEnabled = false;
			}
		});

		// 单击网格操作
		$(document).click(function () {
			// 如果正在模态操作，那么不可点击网格，切换显示流程属性
			if (true == $('#dialog').dialog('isOpen') || true == $('#processAndBillsDialog').dialog('isOpen') || isLockScreen == true) {
				return;
			}

			// 取消ctrl键的选择
			ctrlEnabled = false;
			// 清空数组
			selectedEles = [];
			// 阻止事件冒泡
			event.stopPropagation();

			$(_r).data('currNode', null);
			$(_r).trigger('click', {
				getId: function () {
					return '00000000';
				}
			});

			// 设置标题为"流程属性"
			$("#yigoflow_props_handle").text("流程属性");

			// 触发显示工作流属性面板操作
			$(_r).trigger('showprops', [yigoflow.config.props.props, {
				getId: function () {
					return '00000000';
				}, Key: {
					name: 'Key', label: '标识', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, Caption: {
					name: 'Caption', label: '名称', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, Version: {
					name: 'Version', label: '版本', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, DMTable: {
					name: 'DMTable', label: '迁移表设置', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, FormKey: {
					name: 'FormKey', label: '设置权限的表单', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, PermCollection: {
					name: 'PermCollection', label: '权限设置', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, IgnoreFormState: {
					name: 'IgnoreFormState', label: '忽略表单状态', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, QueryRetreatWorkitem: {
					name: 'QueryRetreatWorkitem', label: '查询撤销工作项信息', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, TemplateKey: {
					name: 'TemplateKey', label: '表单的反向模板定义', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, KillInstanceTrigger: {
					name: 'KillInstanceTrigger', label: '关闭实例触发器', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, LockWorkitem: {
					name: 'LockWorkitem', label: '驳回后是否锁定工作项', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, BPMGraphInfoPath: {
					name: 'BPMGraphInfoPath', label: '自定义流程图信息拓展类', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, WorkFlowHookPath: {
					name: 'WorkFlowHookPath', label: '自定义流程不同时机触发事件的拓展类', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				},
			}]);

		});

		// 删除事件
		var removeHandler = function (e, src) {
			if (!yigoflow.config.editable || true == $('#dialog').dialog('isOpen') || true == $('#processAndBillsDialog').dialog('isOpen') || isLockScreen == true) {
				return;
			}
			// 节点类型
			let nodeType = eval("(" + src.toJson() + ")").type;
			// 文件路径
			let filePath = yigoflow.config.filePath;
			// json数据
			let requestData = getPageData();
			// 节点id
			let nodeId = src.getId();

			if (!nodeType) {
				nodeType = eval("(" + src.toJson() + ")").props.NodeType.value;
			}
			let params = {
				operType: 3,// 操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
				filePath: filePath, content: requestData, nodeId: nodeId
			};

			// ajax请求后台操作
			ajaxRequest(params, 3, nodeType, nodeId, _r);
			if (ajaxStatus) {
				if (src.getId().substring(0, 4) == 'rect') {
					delete _states[src.getId()];
				} else if (src.getId().substring(0, 4) == 'path' || src.getId().substring(0, 12) == 'SequenceFlow' || src.getId().substring(0, 11) == 'Association' || src.getId().substring(0, 13) == 'ExceptionFlow') {
					delete _paths[src.getId()];
				} else {
					delete _states[src.getId()];
				}

				// 删除节点或路径
				src.remove();
				// 隐藏属性面板
				$("#yigoflow_props").css("display", "none");
			}

		};
		$(_r).bind('removepath', removeHandler);
		$(_r).bind('removerect', removeHandler);

		// 添加状态
		$(_r).bind('addrect', function (e, type, o, id) {
			// $('body').append(type+', ');r
			var rect = new yigoflow.rect($.extend(true, {}, yigoflow.config.tools.states[type], o), _r, id, '');
			_states[rect.getId()] = rect;
			let data = getPageData();
			// 更新缓存中的内容
			sessionStorage.removeItem(yigoflow.config.cacheFileName);
			sessionStorage.setItem(yigoflow.config.cacheFileName, data);
			// 设置当前操作的节点id
			$(_r).attr("currentOperNodeId", rect.getId());
		});
		// 添加路径，添加节点之间连线使用的
		var addpathHandler = function (e, from, to) {
			if (yigoflow.config.restore.states
				&& yigoflow.config.restore.states[from.getId()]
				&& yigoflow.config.restore.states[from.getId()].props
				&& yigoflow.config.restore.states[from.getId()].props.NodeType
				&& yigoflow.config.restore.states[from.getId()].props.NodeType.value
				&& (yigoflow.config.restore.states[from.getId()].props.NodeType.value == "End" || yigoflow.config.restore.states[to.getId()].props.NodeType.value == "Begin")) {
				// 清空路径按钮选择样式，避免画不不要的连线
				$('.selected').removeClass('selected');
				$(_r).data('mod', "pointer");
				return;
			}
			//控制两端节点不能重复画线
			let list = yigoflow.config.restore.paths;
			for (let listKey in list) {
				let to1 = list[listKey].to;
				let from1 = list[listKey].from;
				if ((from.getId().toString() == to1 && to.getId().toString() == from1) || (from.getId().toString() == from1 && to.getId().toString() == to1)) {
					$('.selected').removeClass('selected');
					$(_r).data('mod', "pointer");
					return;
				}
			}
			let pathType = $(_r).data().mod;
			var path = new yigoflow.path({}, _r, from, to, '', pathType);
			_paths[path.getId()] = path;
			// 调用一下点击事件，为了将节点数据写入后台xml文件中
			$(_r).trigger('click', {
				getId() {
					isLockScreen = false;
					event.stopPropagation();
					return path.getId();
				}
			});
		};
		$(_r).bind('addpath', addpathHandler);

		// 模式
		$(_r).data('mod', 'point');
		if (yigoflow.config.editable) {
			// 工具栏
			$("#yigoflow_tools").draggable({
				handle: '#yigoflow_tools_handle'
			}).css(yigoflow.config.tools.attr);

			$('#yigoflow_tools .node').hover(function () {
				$(this).addClass('mover');
			}, function () {
				$(this).removeClass('mover');
			});
			$('#yigoflow_tools .selectable').click(function () {
				$('.selected').removeClass('selected');
				$(this).addClass('selected');
				$(_r).data('mod', this.id);
			});

			$('#yigoflow_tools .state').each(function () {
				$(this).draggable({
					helper: 'clone'
				});
			});

			// 工具栏上按钮拖动处理
			$(c).droppable({
				accept: '.state', drop: function (event, ui) {
					//console.log(ui.helper.context);
					var temp = ui.helper.context.innerHTML;
					var id = temp.substring(temp.indexOf(">") + 1, temp.length);
					$(_r).trigger('addrect', [ui.helper.attr('type'), {
						attr: {
							x: ui.helper.offset().left, y: ui.helper.offset().top
						}
					}, id]);
					// $('body').append($(ui).attr('type')+'drop.');

					// 节点类型
					let nodeType = ui.helper.attr('type');
					// 文件路径
					let filePath = yigoflow.config.filePath;
					// json数据
					let requestData = getPageData();
					// 节点id
					let nodeId = $(_r).attr("currentOperNodeId");

					let params = {
						operType: 1,// 操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
						filePath: filePath, content: requestData, nodeId: nodeId
					};

					// ajax请求后台操作
					ajaxRequest(params, 1, nodeType, nodeId, _r);
					if (ajaxStatus) {
						isLockScreen = false;
					}
				}
			});

			// 新增版本
			$('#yigoflow_new').click(function () {// 新增版本
				// 文件路径
				let filePath = yigoflow.config.filePath;
				let key = yigoflow.config.props.props.Key.value;
				let caption = yigoflow.config.props.props.Caption.value;
				let version = yigoflow.config.props.props.Version.value;
				let params = {
					operType: 0,
					filePath: filePath,
					content: "{Key:'" + key + "',Caption:'" + caption + "',Version:'" + version + "'}",
					nodeId: 0
				};
				ajaxNewVersionBpm(params);
			});
			$('#yigoflow_deploy').click(function () {// 部署
				// 文件路径
				let filePath = yigoflow.config.filePath;
				let key = yigoflow.config.props.props.Key.value;
				let params = {
					operType: 0, filePath: filePath, content: "{Key:'" + key + "'}", nodeId: 0
				};
				ajaxDeployBpm(params);
			});

			// 属性框
			new yigoflow.props({}, _r);
		}
		// 恢复数据重新构建页面
		dataResume(o.restore, _r);
	}
////////////////////////////////////////////////////////////////////工作流结束////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////工作流保存撤销AjAX请求区//////////////////////////////////////////////////////////////////////


	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////数据映射相关/////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function Clearcache() {
		sessionStorage.removeItem("formNumber" + yigoflow.config.cacheFileName);
		sessionStorage.removeItem("tableKey" + yigoflow.config.cacheFileName);
		//更新数据
		DataMapOrMigration = true;
	}

	//构建页面
	function _feedbackProp(feedback) {
		_feedbackProps = {};
		if (feedback) {
			for (const indexKey in feedback) {
				_feedbackProps[indexKey] = {};
				_feedbackProps[indexKey].value = feedback[indexKey];
			}
		}
	}

	function handleDelete(layer, restore, feedbackForm) {
		$("#DIV_" + feedbackForm).mousedown(function (event) {
			if (event.button === 2) {
				//先控制住系统自带的右键，之后再进行清空
				$("#meun").attr("oncontextmenu", "return false");
				$("#meun").attr("ondragstart", "return false");
				$("#meun").attr("onselectstart", "return false");
				layer.open({
					content: "是否删除当前反填表单?", btn: ['是', '否'], btn1: function (index) {
						// 后台处理XML文件中的删除
						let deleteParam = {
							filePath: yigoflow.config.filePath, formKey: feedbackForm
						}
						handleDeleteXML(deleteParam);
						layer.close(index);
					}, btn2: function (index) {//取消和关闭都不会进行任何操作
						layer.close(index);
					}, cancel: function () {
						layer.close(index);
					}
				});
			}
		});
	}

	/**
	 * 处理反填表单页面构建方法
	 * */
	function handleFeedBack(_r, reserveFormKey, reserveCaption, feedbackdata, restore, addfeedbackDiv, feedbackNumber, control) {
		new yigoflow.feedbackprops({}, _r, reserveFormKey, "feedbackFormField" + reserveFormKey);
		new yigoflow.feedbackprops({}, _r, '', '');
		$("#Table__").append('<input style="width:100%;height: 22px;" class="inputClick" id="' + reserveFormKey + '" readonly="readonly" placeholder="单击添加反填表单"/>').click(function (e) {
			var inputID = document.getElementById("" + reserveFormKey);
			if (inputID != null) {
				if (inputID.style.display == '') {
					inputID.style.display = 'none';
					sle = $('<select style="width:100%;height: 26px;" class="form-control" id="selectID_' + reserveFormKey + '" />');
					$("#Table__").append(sle);
					let dataMapParams = {
						operType: 0, filePath: yigoflow.config.filePath,
					};
					getAllFormkey(dataMapParams);
					setTimeout((function () {
						$("#selectID_" + reserveFormKey).select2({
							data: DataMapDataJson
						});
					}), 100);
					var feedbackJson = {};
					$.extend(true, feedbackJson, {
						["feedbackFormField" + reserveFormKey]: {
							name: '' + reserveFormKey, value: '', editor: function () {
								return new yigoflow.editors.selectEditor("getFormField");
							}
						}
					});
					$("#selectID_" + reserveFormKey).change(function () {
						let layer = layui.layer;
						let elementById = document.getElementById("selectID_" + reserveFormKey);
						var index = elementById.selectedIndex;
						let selectValue = elementById.options[index].value;
						let eval1 = eval("(" + sessionStorage.getItem(yigoflow.config.cacheFileName) + ")");
						if (eval1.dataMapprops.dataMapprops.FeedbackForm) {
							feedbackdata = eval1.dataMapprops.dataMapprops.FeedbackForm.value;
						}
						//已经存在就直接返回，不做操作
						for (const key in feedbackdata) {
							if (feedbackdata[key].FeedbackForm === selectValue.split("  ")[0]) {
								let inputId = document.getElementById(reserveFormKey);
								$("#Table__").find("select").remove();
								$("#Table__").find("span").remove();
								inputId ? inputId.style.display = "" : null;
								return layer.msg("当前选中反填表单:" + key + "已经存在,请重新选择", {
									time: 1500
								});
							}
						}
						reserveFormKey = selectValue.split("  ")[0];
						reserveCaption = selectValue.split("  ")[1];
						feedbackForm = reserveFormKey;
						if (reserveFormKey === yigoflow.config.sourceForm || reserveFormKey === yigoflow.config.targetForm) {
							feedbackForm = reserveFormKey + "__Feed"
						} else {
							feedbackForm = reserveFormKey;
						}
						formArr.push(feedbackForm);
						$("#Head_")[0].id = $("#Head_")[0].id + feedbackForm
						$("#DIV_")[0].id = $("#DIV_")[0].id + feedbackForm
						$("#Table__")[0].id = $("#Table__")[0].id + feedbackForm
						$("#Head_" + reserveFormKey).css("color", "blue").text("(反填)" + reserveFormKey + "  " + reserveCaption);
						var div = document.getElementById('DIV_' + feedbackForm);
						var width = div.clientWidth || div.offsetWidth || div.scrollWidth;
						var left = sessionStorage.getItem("backFormtart_x");
						var top = sessionStorage.getItem("backFormtart_y");
						let dataMapParams = {
							operType: 0,
							filePath: yigoflow.config.filePath,
							content: "{key:'" + "FeedbackFormKey" + "',value:'" + reserveFormKey + "',width:'" + width + "',left:'" + left + "',top:'" + top + "'}"
						}
						ajaxDataMapUpdateXml(dataMapParams);
						let eval2 = eval("(" + sessionStorage.getItem(yigoflow.config.cacheFileName) + ")");
						feedbackdata = eval2.dataMapprops.dataMapprops.FeedbackForm.value;
						$.extend(true, datafeedback, {
							[reserveFormKey]: {
								FeedbackForm: reserveFormKey,
								FeedbackCaption: reserveCaption,
								Width: "" + width,
								X: "935",
								Y: "30"
							}
						});
						const __ret = addEvent(reserveFormKey, reserveCaption, _r, restore, feedbackNumber, control);
						feedbackNumber = __ret.feedbackNumber;
						addfeedbackDiv();
						//处理反填表单方法
						const __ret1 = handleFeedBack(_r, reserveFormKey, reserveCaption, feedbackdata, restore, addfeedbackDiv, feedbackNumber, control);
						// 添加完成之后 监听右键的点击事件 用于删除操作
						handleDelete(layer, restore);
						reserveFormKey = __ret1.reserveFormKey;
						reserveCaption = __ret1.reserveCaption;
						return {reserveFormKey, reserveCaption};

					});
				}
			}
		});

		var backFormtart = document.getElementById('DIV_');
		var isMove = false;
		backFormtart.drag = function () {
			isMove = true;
		};
		$('#DIV_').mouseup(function (event) {
			if (isMove) {
				let top = event.currentTarget.offsetTop;
				let left = event.currentTarget.offsetLeft;
				sessionStorage.setItem('backFormtart_x', left);
				sessionStorage.setItem('backFormtart_y', top);
				isMove = false;
			}
		})

		return {reserveFormKey, reserveCaption};
	}

	/**构建基础属性面板，也是默认面板*/
	function basicAttributes(_r, data) {
		// 属性框
		new yigoflow.dataMapprops({}, _r);
		// 填入数据
		if (data) {
			if (data.dataMapprops) {
				for (let k in data.dataMapprops.dataMapprops) {
					_gprops[k] = {};
					_gprops[k].value = data.dataMapprops.dataMapprops[k].value;
					if (yigoflow.config.dataMapprops.dataMapprops[k]) {
						yigoflow.config.dataMapprops.dataMapprops[k].value = data.dataMapprops.dataMapprops[k].value;
					}
				}
			}
		}
		// 设置标题为"基础属性"，"源表单"，"目标表单"
		$("#yigoflow_dataMapprops_handle").text("基础属性");
		$(_r).trigger('showprops', [yigoflow.config.dataMapprops.dataMapprops, {
			Key: {
				name: 'Key', label: '映射标识', value: '', editor: function () {
					return new yigoflow.editors.inputEditor();
				}
			}, Caption: {
				name: 'Caption', label: '映射说明', value: '', editor: function () {
					return new yigoflow.editors.inputEditor();
				}
			}, Description: {
				name: 'Description', label: '映射描述', value: '', editor: function () {
					return new yigoflow.editors.inputEditor();
				}
			}, sourceForm: {
				name: 'sourceForm', label: '映射源表标识', value: '', editor: function () {
					return new yigoflow.editors.inputEditor();
				}
			}, targetForm: {
				name: 'targetForm', label: '映射目标表标识', value: '', editor: function () {
					return new yigoflow.editors.inputEditor();
				}
			}, MapRelationValue: {
				name: 'MapRelationValue', label: '允许关系值下推', value: 'true', editor: function () {
					return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
				}
			}, AllowRemainderPush: {
				name: 'AllowRemainderPush', label: '允许余量下推', value: 'true', editor: function () {
					return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
				}
			}, MarkMapCount: {
				name: 'MarkMapCount', label: '源单上记录数据条数', value: 'true', editor: function () {
					return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
				}
			}, PullDataOnly: {
				name: 'PullDataOnly', label: '仅推动数据', value: 'false', editor: function () {
					return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
				}
			}, RemainderPushValue: {
				name: 'RemainderPushValue', label: '剩余下推量', value: '', editor: function () {
					return new yigoflow.editors.inputEditor();
				}
			}, MinPushValue: {
				name: 'MinPushValue', label: '单次最小下推值', value: '', editor: function () {
					return new yigoflow.editors.inputEditor();
				}
			}, MapCondition: {
				name: 'MapCondition', label: '映射执行条件', value: '', editor: function () {
					return new yigoflow.editors.inputEditor();
				}
			}, PostProcess: {
				name: 'PostProcess', label: '映射执行后事件', value: '', editor: function () {
					return new yigoflow.editors.inputEditor();
				}
			},
		}]);
	}

	//动态创建DIV
	function CreatSourceOrtargetDiv(nodeName) {
		//动态获取坐标
		let dataMapParams2 = {
			filePath: yigoflow.config.filePath, formKey: yigoflow.config.sourceForm, nodeName: nodeName
		};
		ajaxStatus = false;
		let coordinatedata1 = coordinatedata(dataMapParams2)[0];
		let top, left, width;
		if (ajaxStatus) {
			top = coordinatedata1.Y;
			left = coordinatedata1.X;
			width = coordinatedata1.Width;
		}
		if (nodeName === "SourceTableCollection") {
			//动态创建div，动态添加坐标
			$("#SourceAndTarget").append('<!--源表单面板-->\n' + '<div id="yigoflow_sourceProps"\n' + '     style="position: absolute;font-size: 13px;  margin-top: 3px;top: ' + top + 'px; left: ' + left + 'px; background-color: #ffffff; min-width:300px;width:auto;\n' + '      padding: 3px;border-radius: 3px;"\n' + '     class="ui-widget-content">\n' + '    <div id="yigoflow_sourceProps_handle" class="ui-widget-header" style="border-radius: 3px;font-size: 13px;height: 28px !important;text-indent: 6px;"><span style="color: red">*</span></div>\n' + '    <table border="0" width="100%" cellpadding="0" cellspacing="0">\n' + '        <tr>\n' + '            <td></td>\n' + '        </tr>\n' + '        <tr>\n' + '            <td></td>\n' + '        </tr>\n' + '    </table>\n' + '</div>')
		} else if (nodeName === "TargetTableCollection") {
			//动态创建div，动态添加坐标
			$("#SourceAndTarget").append('<!--目标表单-->\n' + '<div id="yigoflow_targetProps"\n' + '     style="position: absolute; margin-top: 3px;  top: ' + top + 'px; left: ' + left + 'px; background-color: #ffffff; min-width:300px;width:auto;\n' + '     padding: 3px;border-radius: 3px;"\n' + '     class="ui-widget-content">\n' + '    <div id="yigoflow_targetProps_handle" class="ui-widget-header" style="border-radius: 3px;font-size: 13px;height: 28px !important; text-indent: 6px;">(目标)</div>\n' + '    <table  border="0" width="100%" cellpadding="0" cellspacing="0">\n' + '        <tr>\n' + '            <td></td>\n' + '        </tr>\n' + '        <tr>\n' + '            <td></td>\n' + '        </tr>\n' + '    </table>\n' + '</div>')
		}
	}

	//创建源单面板方法
	function addSource(_r) {
		$("#Table__" + sourceFormKey).append('<input style="width:100%;height: 22px;" class="inputClick" id="sourceID" readonly="readonly" placeholder="单击添加表单字段"/>').click(function (e) {
			sessionStorage.setItem("formKey" + yigoflow.config.cacheFileName, sourceFormKey);
			str = "source";
			idFlag = sourceFormKey;
			var inputID = document.getElementById("sourceID");
			if (inputID != null) {
				if (inputID.style.display == '') {
					inputID.style.display = 'none';
					$(_r).trigger('showsourceprops', [yigoflow.config.sourceProps.sourceProps, {
						formField: {
							name: 'formField', label: '', value: '', editor: function () {
								return new yigoflow.editors.selectEditor("getFormField");
							}
						}
					}]);
					sessionStorage.setItem("nodeName" + yigoflow.config.cacheFileName, "SourceTableCollection");
				}
			}
		});
	}

	/**
	 * 给源单添加Html,数据处理
	 * */
	function addSourceHtml(source) {
		for (let key in source) {
			//触发文本框点击事件
			$("#sourceID").trigger("click");
			if (source[key]) {
				let value = source[key].Definition;
				if (value) {
					addDataMapHtml(value, false);
				}
			}
		}
	}

	/**
	 * 给目标表单添加Html,数据处理
	 * */
	function addTargetHtml(target) {
		for (let key in target) {
			//触发文本框点击事件
			$("#targetID").trigger("click");
			if (target[key]) {
				let value = target[key].Definition;
				if (value) {
					addDataMapHtml(value, false);
				}
			}
		}
	}

	/**
	 * 给数据迁移目标对象添加Html,数据处理
	 * */
	function addMigrationTargetHtml(target) {
		for (let key in target) {
			//触发文本框点击事件
			$("#targetID").trigger("click");
			if (target[key]) {
				let value = target[key].FieldKey;
				if (value) {
					addDataMapHtml(value, false);
				}
			}
		}
	}

	/**
	 * 构建目标表单页面
	 * */
	function addTarget(_r) {
		$("#Table__" + targetFormKey).append('<input style="width:100%;height: 22px;" class="inputClick" id="targetID" readonly="readonly" placeholder="单击添加表单字段"/>').click(function (e) {
			idFlag = targetFormKey;
			sessionStorage.setItem("formKey" + yigoflow.config.cacheFileName, targetFormKey);
			str = "target";
			var inputID = document.getElementById("targetID");
			if (inputID != null) {
				if (inputID.style.display == '') {
					inputID.style.display = 'none';
					$(_r).trigger('showtargetprops', [yigoflow.config.targetProps.targetProps, {
						targetFormField: {
							name: 'targetFormField', label: '', value: '', editor: function () {
								return new yigoflow.editors.selectEditor("getFormField");
							}
						}
					}]);
					sessionStorage.setItem("nodeName" + yigoflow.config.cacheFileName, "TargetTableCollection");
				}
			}
		});
	}

	/**
	 * 用于获取数据迁移的表单字段
	 * */
	function addMigrationTarget(_r) {
		$("#Table__" + targetFormKey).append('<input style="width:100%;height: 22px;" class="inputClick" id="targetID" readonly="readonly" placeholder="单击添加表单字段"/>').click(function (e) {
			idFlag = targetFormKey;
			sessionStorage.setItem("formKey" + yigoflow.config.cacheFileName, targetFormKey);
			str = "target";
			var inputID = document.getElementById("targetID");
			if (inputID != null) {
				if (inputID.style.display == '') {
					inputID.style.display = 'none';
					$(_r).trigger('showtargetprops', [yigoflow.config.MigrationTargetProps.MigrationTargetProps, {
						targetFormField: {
							name: 'targetFormField', label: '', value: '', editor: function () {
								return new yigoflow.editors.selectEditor("getMigrationField");
							}
						}
					}]);
					sessionStorage.setItem("nodeName" + yigoflow.config.cacheFileName, "TargetTableCollection");
				}
			}
		});
	}

	//创建feedbackHtml
	function addFeedBackHtml(feedback) {
		for (let key in feedback) {
			if (feedback[key]) {
				let value = feedback[key].FeedBack;
				let strings = value.split("_@_");
				if (value && strings.length > 2) {
					Clearcache();
					publicFalg = true;
					_feedbackProps[key] = {};
					_feedbackProps[key].value = feedback[key];
					addDataMapHtml(value, false);
				}
			}
		}
		publicFalg = false;
	}

	function CreatFeedBack(formKey) {
		var feedbackJson = {};
		$.extend(true, feedbackJson, {
			["feedbackFormField" + formKey]: {
				name: '' + formKey, value: '', editor: function () {
					return new yigoflow.editors.selectEditor("getFormField");
				}
			}
		});
		if (feedbackJson) {
			for (let k in feedbackJson) {
				_gprops[k] = {};
				_gprops[k].value = feedbackJson[k].value;
			}
		}
		return {feedbackJson};
	}

	function addInput(restore, _r, feedbackNumber, control) {
		$("#Table__" + feedbackForm).append('<input style="width:100%;height: 22px;" class="inputClick" id="' + feedbackForm + '" readonly="readonly" placeholder="单击添加表单字段"/>');
		$('#' + feedbackForm).click(function (e) {
			let formKey = $(e.target)[0].id;
			idFlag = formKey;
			sessionStorage.setItem("formKey" + yigoflow.config.cacheFileName, formKey);
			str = "feedback";
			var inputID = document.getElementById("" + formKey);
			if (inputID != null) {
				if (inputID.style.display == '') {
					inputID.style.display = 'none';
					//每次进来都创建一个新的对象
					const __ret = CreatFeedBack(formKey);
					var feedbackJson = __ret.feedbackJson;
					if (restore.feedbackJson == null){
						restore = restore.restore;
					}
					let feedback = restore.feedbackJson.feedBack;
					setTimeout((function () {
						addFeedBackHtml(feedback);
					}), 1);
					//反填表单,多个就循环创建
					for (var targetContainerKey in feedbackJson) {
						let formKey = feedbackJson[targetContainerKey].name;
						new yigoflow.feedbackprops({}, _r, formKey, "feedbackFormField" + formKey);
						$(_r).trigger('showfeedbackprops' + formKey, [feedbackJson, {}]);
						feedbackNumber++;
						control = true;
					}
				}
			}
		});
		return feedbackNumber;
	}

	/**
	 * 给节点添加一些事件
	 * */
	function addEvent(feedbackFormKey, feedbackCaption, _r, restore, feedbackNumber, control) {
		//添加头部名称
		$("#Head_" + feedbackForm).css("color", "blue").text("(反填)" + feedbackFormKey + "  " + feedbackCaption);
		//反填表单
		$("#Head_" + feedbackForm).click(function () {
			feedbackJson.Key.value = feedbackFormKey;
			feedbackJson.feedbackCaption.value = feedbackCaption;
			$("#yigoflow_dataMapprops_handle").text("反填属性");
			$(_r).trigger('showprops', [feedbackJson, {}]);
		});
		feedbackNumber = addInput(restore, _r, feedbackNumber, control);
		//触发点击事件,做一个流程控制防止事件发生冲突
		$('#' + feedbackForm).trigger("click");
		var id, isMove;
		if (feedbackForm === undefined) {
			id = "DIV_";
		} else {
			id = "DIV_" + feedbackForm
		}
		var feedbackFormstart = document.getElementById(id);
		feedbackFormstart.drag = function () {
			isMove = true;
		};
		$('#' + id).mouseup(function (event) {
			if (isMove) {
				let formKey = event.currentTarget.id.split("DIV_")[1].split("__")[0];
				let top = event.currentTarget.offsetTop;
				let left = event.currentTarget.offsetLeft;
				let dataMapParams = {
					filePath: yigoflow.config.filePath,
					formKey: formKey,
					top: top,
					left: left,
					nodeName: "FeedbackCollection"
				};
				coordinateupdate(dataMapParams);
				isMove = false;
			}
		})
		return {feedbackNumber, id};
	}

	/**
	 * 构建反填表单页面方法
	 * */
	function feedBackHtml(feedbackdata, formArr, _r, restore, feedbackNumber, control, addfeedbackDiv, reserveFormKey, reserveCaption) {
		datafeedback = {};
		if (typeof (feedbackdata) === 'string') {
			feedbackdata = eval("(" + feedbackdata + ")");
		}
		for (var feedbackIndex in feedbackdata) {
			var feedbackFormKey = feedbackdata[feedbackIndex].FeedbackForm;
			var feedbackCaption = feedbackdata[feedbackIndex].FeedbackCaption;
			let dataMapParams = {
				filePath: yigoflow.config.filePath, formKey: feedbackFormKey, nodeName: "FeedbackCollection"
			};
			ajaxStatus = false;
			let coordinatedata1 = coordinatedata(dataMapParams)[0];
			var X, Y;
			if (ajaxStatus && coordinatedata1) {
				X = coordinatedata1.X;
				Y = coordinatedata1.Y;
			} else {
				if (sessionStorage.getItem("backFormtart_x") && sessionStorage.getItem("backFormtart_y")) {
					X = sessionStorage.getItem("backFormtart_x");
					Y = sessionStorage.getItem("backFormtart_y") - 80;
				} else {
					X = 500;
					Y = 170;
				}

			}
			if (feedbackFormKey === yigoflow.config.sourceForm || feedbackFormKey === yigoflow.config.targetForm) {
				feedbackForm = feedbackFormKey + "__Feed"
			} else {
				feedbackForm = feedbackFormKey;
			}
			formArr.push(feedbackForm);
			//因为反填表单会有多个所以就去动态创建反填表单DIV
			$("#SourceAndTarget").append('<!-反填表单--><div id="DIV_' + feedbackForm + '"\n' + '         style="position: absolute; top: ' + Y + 'px; left: ' + X + 'px; background-color: #ffffff; min-width:250px;' + ';width:auto;\n' + '            padding: 3px;border-radius: 3px;"\n' + '         class="ui-widget-content">\n' + '        <div id="Head_' + feedbackForm + '" class="ui-widget-header" style="border-radius: 3px;font-size: 13px; text-indent: 6px;">(反填)</div>\n' + '        <table  border="0" width="100%" cellpadding="0" cellspacing="0" id = "Table__' + feedbackForm + '">\n' + '            <tr>\n' + '                <td></td>\n' + '            </tr>\n' + '            <tr>\n' + '                <td></td>\n' + '            </tr>\n' + '        </table>\n' + '    </div>')
			const __ret = addEvent(feedbackFormKey, feedbackCaption, _r, restore, feedbackNumber, control);
			let layer = layui.layer;
			handleDelete(layer, restore, feedbackForm);
			feedbackNumber = __ret.feedbackNumber;
		}
		//添加默认反填div
		addfeedbackDiv();
		//处理反填表单方法
		const __ret = handleFeedBack(_r, reserveFormKey, reserveCaption, feedbackdata, restore, addfeedbackDiv, feedbackNumber, control);
		reserveFormKey = __ret.reserveFormKey;
		reserveCaption = __ret.reserveCaption;
		return {reserveFormKey, reserveCaption};
	}

	/**
	 * 获取所有子节点id
	 * */
	function gainNodeID(formArr) {
		//获取id绑定给连线工具,同时给文本框绑定事件用于效果优化
		let sourceInput = $("#Table__" + sourceFormKey).find("input");
		let targetInput = $("#Table__" + targetFormKey).find("input");
		let arrSourceID = [], arrTargetID = [];
		for (let inputID in sourceInput) {
			if (sourceInput[inputID].id && sourceInput[inputID].id.substring(0, 2).indexOf("F_") != -1) {
				arrSourceID.push(sourceInput[inputID].id);
				$("#" + sourceInput[inputID].id).mousedown(function (e) {
					let offsetWidth = e.toElement.offsetWidth;
					let offsetX = e.offsetX;
					if (offsetX > 40 && offsetX < (offsetWidth - 70)) {
						const el = $(e.target);
						el.css("cursor", "move");
					} else {
						const el = $(e.target);
						el.css("cursor", "crosshair");
						curTr = null;
					}
				});
			}
		}
		for (let inputID in targetInput) {
			if (targetInput[inputID].id && targetInput[inputID].id.substring(0, 2).indexOf("F_") != -1) {
				arrTargetID.push(targetInput[inputID].id);
				$("#" + targetInput[inputID].id).mousedown(function (e) {
					let offsetWidth = e.toElement.offsetWidth;
					let offsetX = e.offsetX;
					if (offsetX > 40 && offsetX < (offsetWidth - 70)) {
						const el = $(e.target);
						el.css("cursor", "move");
					} else {
						const el = $(e.target);
						el.css("cursor", "crosshair");
						curTr = null;
					}
				});
			}
		}
		//因为反填表单有多个面板这里就需要循环去拿取数据
		let feedBackID = [];
		for (const feedBackIndex in formArr) {
			let formKey;
			if (formArr[feedBackIndex]) {
				formKey = formArr[feedBackIndex];
			}
			let feedbackInput = $("#DIV_" + formKey).find("input");
			let arr = [];
			for (const index in feedbackInput) {
				if (feedbackInput[index].id && feedbackInput[index].id.substring(0, 2).indexOf("F_") != -1) {
					arr.push(feedbackInput[index].id);
				}
			}
			if (arr.length != 0) {
				feedBackID.push(arr);
			}
		}
		return {arrSourceID, arrTargetID, feedBackID};
	}

	//过滤路径方法
	function filterPath(path) {
		for (let indexpaths in path) {
			if (path[indexpaths].sourceEndpoint != undefined && path[indexpaths].targetEndpoint != undefined && $("#" + path[indexpaths].sourceEndpoint)[0] != undefined && $("#" + path[indexpaths].targetEndpoint)[0] != undefined) {
				continue;
			} else if (path[indexpaths].FeedEndpoint != undefined && $("#" + path[indexpaths].FeedEndpoint).attr("id") != undefined && $("#" + path[indexpaths].TgEndpoint).attr("id")) {
				continue;
			} else {
				delete path[indexpaths];
			}
		}
	}

	/**
	 * 通过路径添加连线
	 * */
	function addPaths(path, formArr, o, config, _r) {
		if (path) {
			//判断当前id是否有效无效就不去创建端点
			filterPath(path);

			for (const key in _datamapPaths) {
				//如果当前更新的数据中没有的话就给删除
				if (!path[key]) {
					delete _datamapPaths[key];
				}
			}
			for (let k in path) {
				_datamapPaths[k] = {};
				_datamapPaths[k].value = path[k];
			}
		}
		loadLigature(path, config, formArr);
		//获取所有子节点id
		let {arrSourceID, arrTargetID, feedBackID} = gainNodeID(formArr);
		//先load连线后绑定连线
		ligature(arrSourceID, arrTargetID, _r, config, path, feedBackID, formArr);
	}

	/**
	 *构建页面
	 * */
	function _source(data) {
		_sourceProps = {};
		data = data.source.source ? data.source.source : data.source;
		if (data) {
			for (let k in data) {
				_sourceProps[k] = {};
				_sourceProps[k] = data[k];
			}
		}
	}

	/**
	 *构建页面
	 * */
	function _targetProp(targetdata) {
		_targetProps = {};
		if (targetdata) {
			for (let k in targetdata) {
				_targetProps[k] = {};
				_targetProps[k] = targetdata[k];
			}
		}
	}

	/**
	 *添加表头信息
	 **/
	function addHeadInfo(restore, Migration) {
		//添加表头信息
		$("#yigoflow_sourceProps_handle").css("color", "blue").text("(源)" + yigoflow.config.sourceForm + "  " + yigoflow.config.sourceCaption);
		$("#yigoflow_targetProps_handle").css("color", "blue").text("(目标)" + yigoflow.config.targetForm + "  " + yigoflow.config.targetCaption);

		//源表单和目标表单相同的情况，要做一个区分
		if (yigoflow.config.sourceForm === yigoflow.config.targetForm) {
			sourceFormKey = yigoflow.config.sourceForm + "__S";
			targetFormKey = yigoflow.config.targetForm + "__T";
		} else {
			sourceFormKey = yigoflow.config.sourceForm;
			targetFormKey = yigoflow.config.targetForm;
		}
	}

	//触发面板拖动改变坐标方法
	function updateXY(coordinateChange) {
		var isMove = false;
		var sourcedragstart = document.getElementById('yigoflow_sourceProps');
		var targetdragstart = document.getElementById('yigoflow_targetProps');
		var yigoflowstart = document.getElementById('yigoflow_dataMapprops');
		//判断是否处于拖拽状态，防止误触
		yigoflowstart.drag = function () {
			isMove = true;
		};
		sourcedragstart.drag = function () {
			isMove = true;
		};
		targetdragstart.drag = function () {
			isMove = true;
		};
		//用于动态更改坐标
		$("#yigoflow_dataMapprops").mouseup(function (event) {
			if (isMove) {
				let top = event.currentTarget.offsetTop;
				let left = event.currentTarget.offsetLeft;
				sessionStorage.setItem("yigoflow_x", left);
				sessionStorage.setItem("yigoflow_y", top);
				isMove = false;
			}
		});//用于动态更改坐标
		$("#yigoflow_sourceProps").mouseup(function (event) {
			if (isMove) {
				coordinateChange(event, "SourceTableCollection");
				isMove = false;
			}
		});
		$("#yigoflow_targetProps").mouseup(function (event) {
			if (isMove) {
				coordinateChange(event, "TargetTableCollection");
				isMove = false;
			}
		});
	}

	//更新位置公共方法
	function coordinateChange(event, nodeName) {
		let top = event.currentTarget.offsetTop;
		let left = event.currentTarget.offsetLeft;
		let width = event.currentTarget.offsetWidth;
		let height = event.currentTarget.offsetHeight;
		let dataMapParams = {
			filePath: yigoflow.config.filePath,
			formKey: yigoflow.config.sourceForm,
			top: top,
			left: left,
			width: width,
			height: height,
			nodeName: nodeName
		};
		coordinateupdate(dataMapParams);
	}


	function reloadPanel(isoperate, _r, restore, feedbackNumber, control, addfeedbackDiv, reserveFormKey, reserveCaption, o, config) {
		// 先删除连线 然后去删除节点操作
		jsPlumb.deleteEveryConnection();
		jsPlumb.sourceEndpointDefinitions = {};
		jsPlumb.targetEndpointDefinitions = {};
		//做一个事件的清空，不然的话就会出现连接一次触发多次连接事件
		jsPlumb._listeners = {};
		// 当数据改变的时候再去删除重新构建
		if (!isoperate) {
			jsPlumb.deleteEveryEndpoint();
			let byId = document.getElementById("yigoflow_sourceProps");
			let bytargetId = document.getElementById("yigoflow_targetProps");
			byId.parentNode.removeChild(byId);
			bytargetId.parentNode.removeChild(bytargetId);
			handleSource(_r, restore);
		}
////////////////////////////////////////////////////////////目标面板回撤构建////////////////////////////////////////////////////////////////////
		if (!isoperate) {
			// 重新构建 目标表单页面
			handleTarget(_r, restore);
		}
////////////////////////////////////////////////////////反填页面面板回撤构建//////////////////////////////////////////////////////////////////////
		let feedData;
		if (restore.dataMapprops.dataMapprops.FeedbackForm) {
			feedData = restore.dataMapprops.dataMapprops.FeedbackForm.value;
		}
		// 先删除再重新构建
		$("#DIV_").remove();
		for (const formKey in formArr) {
			$("#DIV_" + formArr[formKey]).remove();
		}
		// 做一个清空
		formArr = [];
		_feedbackProps = [];
		_feedbackProp(restore.feedbackJson.feedback);
		if (feedData && JSON.stringify(restore.feedbackJson)) {
			//构建反填表单页面
			const __ret = feedBackHtml(feedData, formArr, _r, restore, feedbackNumber, control, addfeedbackDiv, reserveFormKey, reserveCaption);
			reserveFormKey = __ret.reserveFormKey;
			reserveCaption = __ret.reserveCaption;
		} else {
			//添加默认反填div
			addfeedbackDiv();
			//处理反填表单方法
			const __ret = handleFeedBack(_r, reserveFormKey, reserveCaption, feedData, o, addfeedbackDiv, feedbackNumber, control);
			reserveFormKey = __ret.reserveFormKey;
			reserveCaption = __ret.reserveCaption;
		}
/////////////////////////////////////////////////////连线信息回撤构建////////////////////////////////////////////////////////////////////////////
		let path = restore.paths.path;
		//等面板回撤完之后再进行连线的添加操作
		setTimeout((function () {
			//通过路径添加连线
			addPaths(path, formArr, o, config, _r);
			// 进行一个重新绘制的操作
			// jsPlumb.repaintEverything();
		}), 2);
		return {reserveFormKey, reserveCaption};
	}

	function getFeedBackFormList(restore, feedbackdata) {
		if (restore.dataMapprops.dataMapprops.FeedbackForm) {
			feedbackdata = restore.dataMapprops.dataMapprops.FeedbackForm.value
		}
		if (typeof (feedbackdata) === "string") {
			feedbackdata = eval("(" + feedbackdata + ")")
		}
		return feedbackdata;
	}

	function handleSource(_r, restore) {
		/**创建源表单面板*/
		CreatSourceOrtargetDiv("SourceTableCollection");
		/**创建目标表单div*/
		CreatSourceOrtargetDiv("TargetTableCollection");
		//添加表头信息
		addHeadInfo(restore);
		$('#yigoflow_sourceProps_handle').click(function () {
			HandleFocus();
			sourcePanelJson.Key.value = yigoflow.config.sourceForm;
			sourcePanelJson.sourceCaption.value = yigoflow.config.sourceCaption;
			$("#yigoflow_dataMapprops_handle").text("源数据对象属性");
			$(_r).trigger('showprops', [sourcePanelJson, {
				Key: {
					name: 'Key', label: '源表单标识', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, sourceCaption: {
					name: 'sourceCaption', label: '源表单说明', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				},
			}]);
		});
		// 属性框
		new yigoflow.sourceprops({}, _r, sourceFormKey);
		//构建页面
		_source(restore);
		if (yigoflow.config.sourceProps) {
			for (let k in yigoflow.config.sourceProps.sourceProps) {
				_gprops[k] = {};
				_gprops[k].value = yigoflow.config.sourceProps.sourceProps[k].value;
			}
		}
		$("#yigoflow_sourceProps").find("table").attr("id", "Table__" + sourceFormKey);
		//构建源单面板
		addSource(_r);
		let source = restore.source.source;
		sourceTableAttr = restore.source.table;
		//添加源单Html
		addSourceHtml(source);
	}

	/**
	 * 更改下拉框样式
	 * */
	function HandleFocus() {
		let $select2 = $(".select2-container--open");
		for (let i = 0; i < $select2.length; i++) {
			if ($(".select2-container--open")[0].className === "select2-container select2-container--default select2-container--open") {
				$(".select2-container--open")[0].parentNode.removeChild($(".select2-container--open")[0])
			} else {
				$(".select2-container--open")[0].className = "select2 select2-container select2-container--default select2-container--below" + " select2-container--focus";
			}
		}
	}

	function handleTarget(_r, restore) {
		//目标表单
		$('#yigoflow_targetProps_handle').click(function () {
			targetJson.Key.value = yigoflow.config.targetForm;
			targetJson.sourceCaption.value = yigoflow.config.targetCaption;
			$("#yigoflow_dataMapprops_handle").text("目标数据对象属性");
			//获取当前操作的面板
			let nodeName = PanelJudge(idFlag);
			// var _w = $(window).width(), _h = $(window).height(), _r = Raphael(this, _w * 0.99, _h * 0.99);
			let dataMapParams = {
				formKey: yigoflow.config.targetForm,
				filePath: yigoflow.config.filePath,
				nodeName: nodeName,
				operationType: "collection"
			};
			ajaxStatus = false;
			var fieldInfo1 = fieldInfo(dataMapParams);
			if (ajaxStatus) {
				targetJson.StatusFieldKey_Feed.value = fieldInfo1.data[0].StatusFieldKey;
				targetJson.StatusValue_Feed.value = fieldInfo1.data[0].StatusValue;
				targetJson.Condition_Feed.value = fieldInfo1.data[0].Condition;
			}
			$(_r).trigger('showprops', [targetJson, {}]);

			HandleFocus();
		});
		// 属性框
		new yigoflow.targetprops({}, _r, targetFormKey);
		let targetdata = restore.target.target;
		_targetProp(targetdata);
		if (yigoflow.config.targetProps) {
			for (let k in yigoflow.config.targetProps.targetProps) {
				_gprops[k] = {};
				_gprops[k].value = yigoflow.config.targetProps.targetProps[k].value;
			}
		}
		$("#yigoflow_targetProps").find("table").attr("id", "Table__" + targetFormKey);
		//构建目标表单页面
		addTarget(_r);
		Clearcache();
		//给目标表单添加Html
		//初始化数据
		numberID = 1;
		addTargetHtml(targetdata);
		//更新面板坐标方法
		updateXY(coordinateChange);
	}

// 初始化数据映射流程
	yigoDataMapflow.init = function (c, o) {
		// 是否显示关联数据映射按钮
		let extend = o.restore.dataMapprops.dataMapprops.Extend;
		if (extend && extend.value) {
			let linkId = document.getElementById("extend");
			linkId.style.display = "";
			linkId && linkId.addEventListener('click', function (e) {
				var webMapPath = window.parent.DESIGNER.UI.getActiveERPForm().WebMapPath;
				window.parent.openLinkDataMap(webMapPath);
			});
		}
		var control = false, feedbackNumber = 1;
		Clearcache();
		var _w = $(window).width(), _h = $(window).height(), _r = Raphael(c, _w * 0.99, _h * 0.99);
		$.extend(true, yigoflow.config, o);
		ctrlEnabled = false;

		// 获取基本配置
		function getBaseNodeConfig() {
			return Object.assign({}, visoConfig.baseStyle)
		};var config = getBaseNodeConfig();
		// 取消ctrl键的选择
		ctrlEnabled = false;
		// 清空数组
		selectedEles = [];
		// 阻止事件冒泡
		event.stopPropagation();
		//构建基础属性面板
		basicAttributes(_r, o.restore);
		//点击网格的时候也去触发基础属性面板
		$(document).click(function () {
			//防止点击连线和这个冲突
			if (publicFalg) {
				publicFalg = false;
				return;
			}
			idFlag = "";
			//保证数据是实时更新的
			if (sessionStorage.getItem(yigoflow.config.cacheFileName)) {
				workflowJsonStr = sessionStorage.getItem(yigoflow.config.cacheFileName);
				workflowJsonStr = workflowJsonStr.replace(/[\n\r]/g, '<br>');
				_s = eval("(" + workflowJsonStr + ")");
			}
			basicAttributes(_r, _s);
		})
		handleSource(_r, o.restore);
		//=========================================================================
		handleTarget(_r, o.restore);
		//=====================================================================================================================================================================
		//                                                             反填表单页面构建
		//=====================================================================================================================================================================
		let feedbackdata;
		let restore = o.restore;
		feedbackdata = getFeedBackFormList(restore, feedbackdata);
		//默认
		var reserveFormKey = "One", reserveCaption = undefined, reserveX = 750, reserveY = 30;

		//默认DIV构建
		function addfeedbackDiv() {
			if (sessionStorage.getItem("backFormtart_x") && sessionStorage.getItem("backFormtart_y")) {
				reserveX = sessionStorage.getItem("backFormtart_x");
				reserveY = sessionStorage.getItem("backFormtart_y");
			}
			$("#SourceAndTarget").append('<!-反填表单--><div id="DIV_"\n' + '         style="position: absolute; top: ' + reserveY + 'px; left: ' + reserveX + 'px; background-color: #ffffff; min-width:250px;width:auto;' + '*display:inline;*zoom:1;padding: 3px;border-radius: 3px;"\n' + '         class="ui-widget-content">\n' + '        <div id="Head_" class="ui-widget-header" style="border-radius: 3px;font-size: 13px; text-indent: 6px;">(反填)</div>\n' + '        <table  border="0" width="100%" cellpadding="0" cellspacing="0" id = "Table__">\n' + '            <tr>\n' + '                <td></td>\n' + '            </tr>\n' + '            <tr>\n' + '                <td></td>\n' + '            </tr>\n' + '        </table>\n' + '    </div>');

		}

		if (feedbackdata) {
			//构建反填表单页面
			const __ret = feedBackHtml(feedbackdata, formArr, _r, restore, feedbackNumber, control, addfeedbackDiv, reserveFormKey, reserveCaption);
			reserveFormKey = __ret.reserveFormKey;
			reserveCaption = __ret.reserveCaption;
		} else {
			//添加默认反填div
			addfeedbackDiv();
			//处理反填表单方法
			const __ret = handleFeedBack(_r, reserveFormKey, reserveCaption, feedbackdata, restore, addfeedbackDiv, feedbackNumber, control);
			reserveFormKey = __ret.reserveFormKey;
			reserveCaption = __ret.reserveCaption;
		}

		//===============================================================================================================================================================
		let path;
		if (sessionStorage.getItem(yigoflow.config.cacheFileName)) {
			path = eval("(" + sessionStorage.getItem(yigoflow.config.cacheFileName) + ")").paths.path;
		} else {
			path = o.restore.paths.path;
		}
		//添加path
		setTimeout((function () {
			addPaths(path, formArr, o, config, _r);
		}), 2);
		//================================================================================================================================
		//======================================事件监听====================================================================================
		//=================================================================================================================================
		//保存操作,快捷键Ctrl+S
		document.addEventListener("keydown", function (e) {
			if (e.ctrlKey && e.shiftKey && e.keyCode == 90) {//反撤销
				window.parent.ReMakeXmlFile();
			} else if (e.ctrlKey && e.keyCode == 90) {//撤销
				window.parent.UnMakeXmlFile();
			} else {
				return true;
			}
		});
		$("#reload").unbind("click").click(function () {
			setTimeout(function () {
				// 保证数据是实时的
				numberID = 1
				let restore = eval("(" + sessionStorage.getItem(yigoflow.config.cacheFileName) + ")");
				const __ret = reloadPanel(false, _r, restore, feedbackNumber, control, addfeedbackDiv, reserveFormKey, reserveCaption, o, config);
				reserveFormKey = __ret.reserveFormKey;
				reserveCaption = __ret.reserveCaption;
			}, 200)
		})
	}

	//跟据后端的XMLload连线数据，在前端自动连线
	function loadLigature(path, config, formArr) {
		jsPlumb.ready(function () {
			jsPlumb.setContainer('SourceAndTarget');
			for (const pathIndex in path) {

				if (path[pathIndex].sourceEndpoint) {
					if (path[pathIndex].Key) {
						jsPlumb.addEndpoint(path[pathIndex].sourceEndpoint, {
							anchor: 'Right',
							uuid: path[pathIndex].sourceEndpoint,
							maxConnections: -1,
							connectorStyle: {
								strokeWidth: 1.2,
								strokeStyle: 'red',
								joinstyle: 'round',
								outlineStroke: 'red',
								outlineWidth: '',
							},
							connectorHoverStyle: {
								stroke: '#a11e1e',
								strokeStyle: '#a11e1e',
								strokeWidth: 1.2,
								outlineStroke: '#a11e1e',
								outlineColor: '',
							}
						}, config)
					} else {
						jsPlumb.addEndpoint(path[pathIndex].sourceEndpoint, {
							anchor: 'Right',
							uuid: path[pathIndex].sourceEndpoint,
							maxConnections: -1
						}, config)
					}

				}

			}
			for (const pathIndex in path) {
				if (path[pathIndex].targetEndpoint) {
					jsPlumb.addEndpoint(path[pathIndex].targetEndpoint, {
						anchor: 'Left', uuid: path[pathIndex].targetEndpoint, maxConnections: -1
					}, config)
				}
			}
			for (const pathIndex in path) {
				if (!path[pathIndex].EdgeType) {
					jsPlumb.connect({uuids: [path[pathIndex].sourceEndpoint, path[pathIndex].targetEndpoint]});
				}
			}
			//关注映射字段在普通字段连接后再进行添加，防止一个字段出现多条连线都是关注字段样式
			for (const  pathIndex in path){
				//改变关注映射的连线样式
				if (path[pathIndex].EdgeType) {
					if (path[pathIndex].Key) {
						jsPlumb.addEndpoint(path[pathIndex].sourceEndpoint, {
							anchor: 'Right', uuid: path[pathIndex].sourceEndpoint, maxConnections: -1, connectorStyle: {
								strokeWidth: 1.2,
								strokeStyle: 'red',
								joinstyle: 'round',
								fill: 'pink',
								outlineStroke: 'red',
								outlineWidth: '',
								dashstyle: "2 4"
							}, connectorHoverStyle: {
								stroke: '#a11e1e',
								strokeStyle: '#a11e1e',
								strokeWidth: 1.2,
								outlineStroke: '#a11e1e',
								outlineColor: '',
							}
						}, config);
					} else {
						if (path[pathIndex].sourceEndpoint) {
							jsPlumb.addEndpoint(path[pathIndex].sourceEndpoint, {
								anchor: 'Right',
								uuid: path[pathIndex].sourceEndpoint,
								maxConnections: -1,
								connectorStyle: {
									strokeWidth: 1.2,
									strokeStyle: 'blue',
									joinstyle: 'round',
									fill: 'pink',
									outlineStroke: 'blue',
									outlineWidth: '',
									dashstyle: "2 4"
								},
								connectorHoverStyle: {
									stroke: '#a11e1e',
									strokeStyle: '#a11e1e',
									strokeWidth: 1.2,
									outlineStroke: '#a11e1e',
									outlineColor: '',
								}
							}, config);
						}
					}
					jsPlumb.connect({uuids: [path[pathIndex].sourceEndpoint, path[pathIndex].targetEndpoint]});
				}

			}
			//目标表单到反填表单
			for (const pathIndex in path) {
				if (path[pathIndex].FeedEndpoint) {
					jsPlumb.addEndpoint(path[pathIndex].TgEndpoint, {
						anchor: 'Right', uuid: path[pathIndex].TgEndpoint, maxConnections: -1
					}, config);
					jsPlumb.addEndpoint(path[pathIndex].FeedEndpoint, {
						anchor: 'Left', uuid: path[pathIndex].FeedEndpoint, maxConnections: -1
					}, config);
				}
			}
			for (const pathIndex in path) {
				if (path[pathIndex].FeedEndpoint) {
					jsPlumb.connect({uuids: [path[pathIndex].TgEndpoint, path[pathIndex].FeedEndpoint]});
				}
			}
			jsPlumb.draggable('yigoflow_sourceProps');
			jsPlumb.draggable('yigoflow_targetProps');
			for (let formkey in formArr) {
				let formKey;
				if (formArr[formkey]) {
					formKey = formArr[formkey];
				}
				jsPlumb.draggable('DIV_' + formKey);
			}

		})
	}

	/**
	 * 处理连线方法
	 * @param {[]} arrSourceID 储存的是源单所有的字段id
	 * @param {[]} arrTargetID 储存的目标表单所以的字段id
	 */
	let sourceID, targetID;

	function ligature(arrSourceID, arrTargetID, _r, config, path, feedBackID, formArr) {
		window.jsPlumb.ready(function () {
			var jsPlumb = window.jsPlumb;

			//jsPlumb.setContainer('SourceAndTarget');
			for (const SourceIDJSONKey in arrSourceID) {
				jsPlumb.makeSource('' + arrSourceID[SourceIDJSONKey], {}, config);
			}
			jsPlumb.importDefaults({
				ConnectionsDetachable: true
			})
			for (const TargetIDJsonKey in arrTargetID) {
				jsPlumb.makeTarget('' + arrTargetID[TargetIDJsonKey], {}, config);
			}
			///////////////////////////////////////////////////////////////////////
			//////////////////////////////目标表单到反填表单/////////////////////////
			///////////////////////////////////////////////////////////////////////
			for (const TargetIDJsonKey in arrTargetID) {
				jsPlumb.makeSource('' + arrTargetID[TargetIDJsonKey], {}, config);
			}
			for (const feedindex in feedBackID) {
				//这里分两种情况，一种是New一种是Load，即直接添加之后和刷新后的数据获取
				if ($("#" + feedBackID[feedindex]).attr("id") != undefined && typeof (feedBackID[feedindex]) == "string") {
					jsPlumb.makeTarget('' + feedBackID[feedindex], {}, config);
				} else {
					for (const feedbacKey in feedBackID[feedindex]) {
						jsPlumb.makeTarget('' + feedBackID[feedindex][feedbacKey], {}, config);
					}
				}
			}
			jsPlumb.draggable('yigoflow_sourceProps');
			jsPlumb.draggable('yigoflow_targetProps');
			for (const currentNodeIdKey in formArr) {
				jsPlumb.draggable('DIV_' + formArr[currentNodeIdKey]);
			}
			//连线点击事件
			jsPlumb.bind('click', function (connection, e) {
				//防止点击连线和点击网格触发面板冲突
				publicFalg = true;
				new yigoflow.dataMapprops({}, _r);
				$("#yigoflow_dataMapprops_handle").text("连接线属性");
				connectionData = connection
				let sourceID = connection.sourceId
				let targetID = connection.targetId
				//这个是用于在别处设置关联映射的时候设置样式用到
				sourceContainer = sourceID;
				targetContainer = targetID;
				let {
					sourceForm, targetForm, sourceTableKey, targetTableKey, sourceField, targetField, feedback
				} = gainData(sourceID, targetID, formArr);
				let dataMapParams = {
					formKey: sourceForm + "&&" + targetForm,
					fieldKey: sourceField + "&&" + targetField,
					filePath: yigoflow.config.filePath,
					tableKey: sourceTableKey + "&&" + targetTableKey,
					operationType: feedback,
					sourceFieldKey: sourceField,
					targetFieldKey: targetField,
				};
				//这个属性用于获取需要修改的nodename
				idFlag = sourceForm;
				yigoflow.config.tableKey = sourceTableKey;
				yigoflow.config.fieldKey = sourceField;
				yigoflow.config.targetKey = targetField;
				sourceFormsourceForm = sourceForm;
				let ligaturing1 = ligatureinfo(dataMapParams)[0];

				if (ajaxStatus && !feedback && !ligaturing1.Migration) {
					var key = ligaturing1.sourceTypeKey;
					if (key === "canNot") {//控制普通数据映射不显示字段覆盖
						delete ligatureJson.sourceTypeKey;
					} else {
						ligatureJson.sourceTypeKey = {
							name: 'sourceTypeKey', label: '字段覆盖', value: '', editor: function () {
								return new yigoflow.editors.selectEditor("getSourceFieldList");
							}
						}
						if (key.indexOf("merge") != -1) {
							ligatureJson.sourceTypeKey.value = "default";

						} else {
							ligatureJson.sourceTypeKey.value = key;
						}

					}
					idFlag = sourceForm;
					ligatureJson.sourcekey.value = sourceField;
					ligatureJson.sourceCaption.value = ligaturing1.sourceCaption;
					ligatureJson.targetkey.value = ligaturing1.targetkey;
					ligatureJson.targetCaption.value = ligaturing1.targetCaption;
					ligatureJson.targetTableKey.value = ligaturing1.targetTableKey;
					ligatureJson.Editable.value = ligaturing1.Editable;
					ligatureJson.EdgeType.value = ligaturing1.EdgeType;
					ligatureJson.ConditionField.value = ligaturing1.ConditionField;
					yigoflow.config.tableKey = sourceTableKey;
					yigoflow.config.fieldKey = sourceField;
					sessionStorage.setItem("nodeName" + yigoflow.config.cacheFileName, "SourceTableCollection");
					if (ligatureJson) {
						for (let k in ligatureJson) {
							_gprops[k] = {};
							_gprops[k].value = ligatureJson[k].value;
						}
					}
					$(_r).trigger('showprops', [ligatureJson, {}]);
				} else if (feedback && !ligaturing1.Migration) {
					idFlag = sourceForm;
					let ligatureinfo1 = ligatureinfo(dataMapParams)[0];
					ligatureFeedbackJson.DataObjectKey.value = targetForm;
					ligatureFeedbackJson.TableKey.value = targetTableKey;
					ligatureFeedbackJson.FieldKey.value = targetField;
					ligatureFeedbackJson.FieldCaption.value = ligatureinfo1.FieldCaption;
					ligatureFeedbackJson.sourceKey.value = sourceField;
					ligatureFeedbackJson.sourceCaption.value = ligatureinfo1.sourceCaption;
					ligatureFeedbackJson.sourceCaption.value = ligatureinfo1.sourceCaption;
					ligatureFeedbackJson.PostTrigger.value = ligatureinfo1.PostTrigger;
					ligatureFeedbackJson.OpSign.value = ligatureinfo1.OpSign;
					ligatureFeedbackJson.PostFormulaTrigger.value = ligatureinfo1.PostFormulaTrigger;
					ligatureFeedbackJson.FeedCondition.value = ligatureinfo1.Condition;
					if (ligatureFeedbackJson) {
						for (let k in ligatureFeedbackJson) {
							_gprops[k] = {};
							_gprops[k].value = ligatureFeedbackJson[k].value;
						}
					}
					$(_r).trigger('showprops', [ligatureFeedbackJson, {}]);
				} else if (ligaturing1.Migration && ligaturing1.GroupType.indexOf("直接量") != -1) {//数据迁移连线点击
					ligatureMigrationJson.targetKey.value = ligaturing1.targetTableKey;
					ligatureMigrationJson.TargetFieldKey.value = ligaturing1.targetkey;
					ligatureMigrationJson.PeriodValue.value = ligaturing1.PeriodValue;
					ligatureMigrationJson.GroupingPolicy.value = ligaturing1.GroupingPolicy;
					ligatureMigrationJson.MapFormula.value = ligaturing1.MapFormula;
					if (ligatureMigrationJson) {
						for (let k in ligatureMigrationJson) {
							_gprops[k] = {};
							_gprops[k].value = ligatureMigrationJson[k].value;
						}
					}
					$(_r).trigger('showprops', [ligatureMigrationJson, {}]);
				} else if (ligaturing1.GroupType.indexOf("无分组") != -1) {
					ligatureNoGroupingJson.targetKey.value = ligaturing1.targetTableKey;
					ligatureNoGroupingJson.TargetFieldKey.value = ligaturing1.targetkey;
					ligatureNoGroupingJson.MigrationOpSign.value = ligaturing1.OpSign;
					ligatureNoGroupingJson.IsNegtive.value = ligaturing1.IsNegtive;
					ligatureMigrationJson.MapFormula.value = ligaturing1.MapFormula;
					if (ligatureNoGroupingJson) {
						for (let k in ligatureNoGroupingJson) {
							_gprops[k] = {};
							_gprops[k].value = ligatureNoGroupingJson[k].value;
						}
					}
					$(_r).trigger('showprops', [ligatureNoGroupingJson, {}]);
				} else if (ligaturing1.Migration && ligaturing1.GroupType.indexOf("期间分组") != -1) {
					ligatureMigrationJson.targetKey.value = ligaturing1.targetTableKey;
					ligatureMigrationJson.TargetFieldKey.value = ligaturing1.targetkey;
					ligatureMigrationJson.PeriodValue.value = ligaturing1.PeriodValue;
					ligatureMigrationJson.GroupingPolicy.value = ligaturing1.GroupingPolicy;
					ligatureMigrationJson.MapFormula.value = ligaturing1.MapFormula;
					if (ligatureMigrationJson) {
						for (let k in ligatureMigrationJson) {
							_gprops[k] = {};
							_gprops[k].value = ligatureMigrationJson[k].value;
						}
					}
					$(_r).trigger('showprops', [ligatureMigrationJson, {}]);
				}

			});
			//监控鼠标右键事件
			jsPlumb.bind("contextmenu", function (connection) {
				let layer = layui.layer;
				//先控制住系统自带的右键，之后再进行清空
				$("#meun").attr("oncontextmenu", "return false");
				$("#meun").attr("ondragstart", "return false");
				$("#meun").attr("onselectstart", "return false");

				//清除控制
				function deleteControl() {
					$("#meun").attr("oncontextmenu", "");
					$("#meun").attr("ondragstart", "");
					$("#meun").attr("onselectstart", "");
				}

				let sourceID = connection.sourceId;
				let targetID = connection.targetId
				layer.open({
					content: '是否删除当前连接', btn: ['是', '否'], btn1: function () {
						let {
							sourceForm, targetForm, sourceTableKey, targetTableKey, sourceField, targetField, feedback
						} = gainData(sourceID, targetID, formArr);
						let nodeName = PanelJudge(sourceForm);
						let dataMapParams = {
							formKey: sourceForm + "&&" + targetForm,
							fieldKey: sourceField + "&&" + targetField,
							filePath: yigoflow.config.filePath,
							tableKey: sourceTableKey + "&&" + targetTableKey,
							nodeName: nodeName,
							sourceFieldKey: sourceField,
							targetFieldKey: targetField,
						};
						ajaxStatus = false;
						updateLigatureXML(dataMapParams);
						//后端数据处理成功之后再去处理前端数据
						if (ajaxStatus) {
							jsPlumb.deleteConnection(connection);
							//去数组中删除这个连线信息
							for (const index in path) {
								if (path[index].sourceEndpoint === sourceID && path[index].targetEndpoint === targetID || path[index].TgEndpoint === sourceID && path[index].FeedEndpoint === targetID) {
									delete path[index];
								}
							}
							for (const key in _datamapPaths) {
								//如果当前更新的数据中没有的话就给删除
								if (!path[key]) {
									delete _datamapPaths[key];
								}
							}
							//更新一下数据
							for (let k in path) {
								_datamapPaths[k] = {};
								_datamapPaths[k].value = path[k];
							}
						}
						layer.close(layer.index);
						//清除对右键的控制
						deleteControl();
					}, btn2: function () {
						layer.close(layer.index);
						deleteControl();
					}, cancel: function () {
						layer.close(layer.index);
						deleteControl();

					}
				});
			});
			//连接前检查
			jsPlumb.bind("beforeDrop", function (connection) {
				curTr = null;//拖动数据
				let sourceID = connection.sourceId;
				let targetID = connection.targetId;
				//先去判断当前的锚点之间是不是已经存在连线
				let connections = jsPlumb.getAllConnections();
				for (let connection of connections) {
					//一旦当前锚点之间存在连接就拒绝再次连接
					if (connection.sourceId === sourceID && connection.targetId === targetID) return false;
				}
				var obj = $("#" + sourceID);
				var tarobj = $("#" + targetID);
				while (!obj.is("table")) {
					obj = obj.parent();
				}
				while (!tarobj.is("table")) {
					tarobj = tarobj.parent();
				}
				let formKey = obj[0].id.split("Table__")[1];
				let targetkey = tarobj[0].id.split("Table__")[1];
				if (formKey === targetkey) {
					return false;
				}
				//目标表单不可以向源单拉连线，目标表单 可以向反填表单拉连线
				//源表单不能向反填表单拉取连线
				if (targetkey === sourceFormKey && formKey === targetFormKey || formKey === sourceFormKey && formArr && -1 !== formArr.indexOf(targetkey) || obj.attr("id") === tarobj.attr("id")) {
					return false;
				}
				var nodename;
				if (connection.sourceId.indexOf(sourceFormKey) !== -1) {
					nodeName = PanelJudge(sourceFormKey);
				} else if (-1 !== connection.sourceId.indexOf(targetFormKey)) {
					nodeName = PanelJudge(targetFormKey);
				}
				//源单和目标表单字段
				let sourceField = $("#" + connection.sourceId)[0].placeholder.split("  ")[0];
				let targetField = $("#" + connection.targetId)[0].placeholder.split("  ")[0];
				var dataMapParams = {
					filePath: yigoflow.config.filePath,
					nodeName: nodeName,
					fieldKey: sourceField + "&&" + targetField,
					formKey: formKey + "&&" + targetkey,
					sourceFieldKey: sourceField,
					targetFieldKey: targetField,
				};
				//为true就是已经存在  或者不支持连接
				let connected = isConnected(dataMapParams);
				//不能自己连自己
				if (connection.sourceId === connection.targetId || connected) {
					$("#" + connection.sourceId).trigger("mouseup");
					if (!connected) {
						//触发这个文本框的点击事件
						$("#" + connection.sourceId).trigger("click");
					}
					return false;
				}

				return true;
			});

			/**
			 * 添加连线方法
			 * 更新缓存中的数据
			 * */
			function addLigature(nodeName) {
				if (ajaxStatus) {
					let num = 1;
					for (const indexkey in path) {
						num = parseInt(indexkey.replace(/[^0-9]/ig, "")) + 1;
						//如果已经存在只是修改就先删除，下面再添加
						if (path[indexkey].targetEndpoint === targetID && path[indexkey].sourceEndpoint === sourceID || path[indexkey].FeedEndpoint === targetID && path[indexkey].TgEndpoint === sourceID) {
							delete path[indexkey]
						}
					}
					if (nodeName === "SourceTableCollection") {
						//关注映射和普通映射不同
						if (publicFalg) {
							$.extend(true, path, {
								["path" + num]: {targetEndpoint: targetID, sourceEndpoint: sourceID, EdgeType: "Focus"}
							});
						} else {
							$.extend(true, path, {
								["path" + num]: {targetEndpoint: targetID, sourceEndpoint: sourceID}
							});
						}
					} else if (nodeName === "TargetTableCollection") {
						if (publicFalg) {
							$.extend(true, path, {
								["path" + num]: {FeedEndpoint: targetID, TgEndpoint: sourceID, EdgeType: "Focus"}
							});
						} else {
							$.extend(true, path, {
								["path" + num]: {FeedEndpoint: targetID, TgEndpoint: sourceID}
							});
						}
					}
					for (const key in _datamapPaths) {
						//如果当前更新的数据中没有的话就给删除
						if (!path[key]) {
							delete _datamapPaths[key];
						}
					}
					for (const k in path) {
						_datamapPaths[k] = {};
						_datamapPaths[k].value = path[k];
					}
					publicFalg = false;
				}
			}

			//监听连接事件
			jsPlumb.bind("connection", function (connInfo) {
				curTr = null;
				ajaxStatus = false;
				if (connInfo.connection.targetId != connInfo.connection.sourceId) {
					sourceID = connInfo.connection.sourceId
					targetID = connInfo.connection.targetId
					let {
						sourceForm, targetForm, sourceTableKey, targetTableKey, sourceField, targetField, feedback
					} = gainData(sourceID, targetID, formArr);
					let nodeName = PanelJudge(sourceForm);
					let dataMapParams = {
						formKey: sourceForm + "&&" + targetForm,
						fieldKey: sourceField + "&&" + targetField,
						filePath: yigoflow.config.filePath,
						tableKey: sourceTableKey + "&&" + targetTableKey,
						nodeName: nodeName,
						operationType: feedback,
						sourceFieldKey: sourceField,
						targetFieldKey: targetField,
					};
					setTargetField(dataMapParams);
				}
			});
		})
	}

	/**
	 * 数据解析，数据获取
	 * sourceID 源单ID
	 * targetID 目标表单ID
	 * **/
	function gainData(sourceID, targetID, formArr) {
		//解析数据获取formKey和Tablekey,sourcefiled,targetfield
		let sourceForm, targetForm, feedback = false;
		if (!sourceForm && sourceID.indexOf(targetFormKey) !== -1) {
			sourceForm = targetFormKey;
		}
		if ( sourceID.indexOf(sourceFormKey) !== -1) {
			sourceForm = sourceFormKey;
		}
		//数据迁移没有反填表单所以也会是0，就放在上面
		for (const formed in formArr) {
			if (targetID.indexOf(formArr[formed]) !== -1) {
				targetForm = formArr[formed];
				//用于判断目标表单是不是反填表单
				feedback = true;
			}
		}
		//第一次添加的情况下
		if (formArr && formArr.length === 0) {
			targetForm = feedbackForm;
		}
		if (targetID.indexOf(targetFormKey) !== -1) {
			targetForm = targetFormKey;
		}
		let sourceTableKey, targetTableKey;
		//拿到所有表名字段
		let tableArray = $(".inputTable");
		let length = 0;
		let tarlength = 0;
		for (let i = 0; i < tableArray.length; i++) {
			//获取tablekey
			let table = $(".inputTable")[i].placeholder.split("  ")[1];
			if (sourceID.indexOf(table) !== -1 && table.length>length) {
				length = table.length;
				sourceTableKey = table;
			}
			if (targetID.indexOf(table) !== -1 && table.length>tarlength) {
				tarlength = table.length;
				targetTableKey = table;
			}
		}
		let sourceField = $("#" + sourceID)[0].placeholder.split("  ")[0];
		let targetField = $("#" + targetID)[0].placeholder.split("  ")[0];
		return {sourceForm, targetForm, sourceTableKey, targetTableKey, sourceField, targetField, feedback};
	}

	// 获取页面指定id的数据(json格式)
	function getPageDataByNodeId(nodeId, key, value) {
		let data = '{states:{';
		for (let k in _states) {
			if (_states[k]) {
				if (nodeId == _states[k].getId()) {
					data += _states[k].getId() + ':' + _states[k].toJsonForUpdate(_states[k].getId(), "states", key, value) + ',';
				} else {
					data += _states[k].getId() + ':' + _states[k].toJson(_states[k].getId(), "states") + ',';
				}
			}
		}
		if (data.substring(data.length - 1, data.length) == ',') {
			data = data.substring(0, data.length - 1);
		}
		data += '},paths:{';
		for (let k in _paths) {
			if (_paths[k]) {
				if (nodeId == _paths[k].getId()) {
					data += _paths[k].getId() + ':' + _paths[k].toJsonForUpdate(_paths[k].getId(), "paths", key, value) + ',';
				} else {
					data += _paths[k].getId() + ':' + _paths[k].toJson(_paths[k].getId(), "paths") + ',';
				}
			}
		}
		if (data.substring(data.length - 1, data.length) == ',') {
			data = data.substring(0, data.length - 1);
		}
		data += '},props:{props:{';
		for (let k in _gprops) {
			if (_gprops[k]) {
				data += k + ":{value:'" + _gprops[k].value + "'},";
			}
		}
		if (data.substring(data.length - 1, data.length) == ',') {
			data = data.substring(0, data.length - 1);
		}
		data += '}}}';
		return data;
	}

	// 获取页面数据(json格式)
	function getPageData() {
		let data = '{states:{';
		for (let k in _states) {
			if (_states[k]) {
				data += _states[k].getId() + ':' + _states[k].toJson(_states[k].getId(), "states") + ',';
			}
		}
		if (data.substring(data.length - 1, data.length) == ',') {
			data = data.substring(0, data.length - 1);
		}
		data += '},paths:{';
		for (let k in _paths) {
			if (_paths[k]) {
				data += _paths[k].getId() + ':' + _paths[k].toJson(_paths[k].getId(), "paths") + ',';
			}
		}
		if (data.substring(data.length - 1, data.length) == ',') {
			data = data.substring(0, data.length - 1);
		}
		data += '},props:{props:{';
		for (let k in _gprops) {
			if (_gprops[k]) {
				data += k + ":{value:'" + _gprops[k].value + "'},";
			}
		}
		if (data.substring(data.length - 1, data.length) == ',') {
			data = data.substring(0, data.length - 1);
		}
		data += '}}}';
		return data.replaceAll('undefined', "null");
	}

	/**数据映射获取界面的格式（Json）*/
	function getDataMapJson() {
		let formField, targetFormField, feedbackJson = [];
		let data = '{"paths":{"path":{';
		for (let k in _datamapPaths) {
			//解析关注映射的数据
			if (sessionStorage.getItem("EdgeType" + yigoflow.config.cacheFileName) === 'Focus' && _datamapPaths[k].value.sourceEndpoint === sourceContainer && _datamapPaths[k].value.targetEndpoint === targetContainer || _datamapPaths[k].value.EdgeType === "Focus") {
				data += k + ":{sourceEndpoint:'" + _datamapPaths[k].value.sourceEndpoint + "'" + ",targetEndpoint:'" + _datamapPaths[k].value.targetEndpoint + "',EdgeType:'" + "Focus" + "'},";
			} else if (_datamapPaths[k].value.FeedEndpoint) {
				data += k + ":{TgEndpoint:'" + _datamapPaths[k].value.TgEndpoint + "'" + ",FeedEndpoint:'" + _datamapPaths[k].value.FeedEndpoint + "'},";
			} else if (sessionStorage.getItem("EdgeType" + yigoflow.config.cacheFileName) != 'Focus' && _datamapPaths[k].value.sourceEndpoint === sourceContainer && _datamapPaths[k].value.targetEndpoint === targetContainer) {
				data += k + ":{sourceEndpoint:'" + _datamapPaths[k].value.sourceEndpoint + "'" + ",targetEndpoint:'" + _datamapPaths[k].value.targetEndpoint + "'},";
			} else if (_datamapPaths[k] && _datamapPaths[k].value.EdgeType) {
				data += k + ":{sourceEndpoint:'" + _datamapPaths[k].value.sourceEndpoint + "'" + ",targetEndpoint:'" + _datamapPaths[k].value.targetEndpoint + "',EdgeType:'" + _datamapPaths[k].value.EdgeType + "'},";
			} else if (_datamapPaths[k]) {
				data += k + ":{sourceEndpoint:'" + _datamapPaths[k].value.sourceEndpoint + "'" + ",targetEndpoint:'" + _datamapPaths[k].value.targetEndpoint + "'},";
			}
		}
		if (data.substring(data.length - 1, data.length) == ',') {
			data = data.substring(0, data.length - 1);
		}
		data += '}},"dataMapprops":{"dataMapprops":{';
		for (let k in _gprops) {
			//先将数据保存下来备用
			if (k === 'formField') {
				formField = _gprops[k].value
			}
			if (k === 'targetFormField') {
				targetFormField = _gprops[k].value
			}
			if (k.indexOf("feedbackFormField") != -1) {
				if (_gprops[k].value) {
					feedbackJson.push(_gprops[k].value);
				}
			}
			if (_gprops[k].value) {
				_gprops[k].value = _gprops[k].value;
				if (typeof _gprops[k].value === "object") {
					data += k + ":{value:'" + JSON.stringify(_gprops[k].value) + "'},";
				} else {
					data += k + ":{value:'" + _gprops[k].value + "'},";
				}
			}
		}
		if (data.substring(data.length - 1, data.length) == ',') {
			data = data.substring(0, data.length - 1);
		}
		data += '}},"source":{"source":{';
		for (let k in _sourceProps) {
			var num = k.replace(/[^0-9]/ig, "");
			//数据结构不一样所以分两种情况
			if (_sourceProps[k].Definition) {
				data += k + ":{Definition:'" + _sourceProps[k].Definition.replace(/\'/g, "") + "'},";
			}
			//添加刚刚选中的字段标识到数据里面
			if (!(_sourceProps["Definition" + (parseInt(num) + 1)]) && formField) {
				let isContainer = false;
				//防止出现重复数据
				for (const sourceIndex in _sourceProps) {
					if (_sourceProps[sourceIndex].Definition === formField) {
						isContainer = true;
					}
				}
				if (!isContainer) {
					_sourceProps["Definition" + (parseInt(num) + 1)] = {};
					_sourceProps["Definition" + (parseInt(num) + 1)] = {"Definition": formField.replace(/\'/g, "")};
					data += "Definition" + (parseInt(num) + 1) + ":{Definition:'" + formField.replace(/\'/g, "") + "'},";
				}
			}
		}
		//当还没添加过表的情况
		if (!_sourceProps["Definition1"] && formField) {
			_sourceProps["Definition1"] = {};
			_sourceProps["Definition1"] = {"Definition": formField.replace(/\'/g, "")};
			data += "Definition1:{Definition:'" + formField.replace(/\'/g, "") + "'},";
		}
		if (data.substring(data.length - 1, data.length) == ',') {
			data = data.substring(0, data.length - 1);
		}
		data += '}},"target":{"target":{';
		for (let k in _targetProps) {
			var num = k.replace(/[^0-9]/ig, "");
			//数据结构不一样所以分两种情况
			if (_targetProps[k].Definition) {
				data += k + ":{Definition:'" + _targetProps[k].Definition.replace(/\'/g, "") + "'},";
			} else {
				data += k + ":{Definition:'" + _targetProps[k].FieldKey.replace(/\'/g, "") + "'},";
			}
			//添加刚刚选中的字段标识到数据里面
			if (!(_targetProps["Definition" + (parseInt(num) + 1)]) && targetFormField) {
				let isContainer = false;
				//防止出现重复数据
				for (const targetIndex in _targetProps) {
					if (_targetProps[targetIndex].Definition === targetFormField) {
						isContainer = true;
					}
				}
				if (!isContainer) {
					_targetProps["Definition" + (parseInt(num) + 1)] = {};
					_targetProps["Definition" + (parseInt(num) + 1)] = {"Definition": targetFormField};
					data += "Definition" + (parseInt(num) + 1) + ":{Definition:'" + targetFormField.replace(/\'/g, "") + "'},";
				}
			}
		}
		//当还没添加过表的情况
		if (!_targetProps["Definition1"] && targetFormField) {
			_targetProps["Definition1"] = {};
			_targetProps["Definition1"] = {"Definition": targetFormField};
			data += "Definition1:{Definition:'" + targetFormField.replace(/\'/g, "") + "'},";
		}
		if (data.substring(data.length - 1, data.length) == ',') {
			data = data.substring(0, data.length - 1);
		}
		data += '}},"feedbackJson":{"feedBack":{';
		let i = 1;
		for (let k in _feedbackProps) {
			if (_feedbackProps[k]) {
				data += k + ":{FeedBack:'" + _feedbackProps[k].value.FeedBack + "'},";
				i++;
			}
		}
		if (feedbackJson.length != 0) {
			//防止出现重复数据
			//反填表单会有多个就循环更新数据
			for (const feedbackKey in feedbackJson) {
				let isContainer = false;
				for (const feedbackIndex in _feedbackProps) {
					if (_feedbackProps[feedbackIndex].value.FeedBack === feedbackJson[feedbackKey]) {
						isContainer = true;
						break;
					}
				}
				let feedbackJsonData = feedbackJson[feedbackKey];
				if (!isContainer) {
					_feedbackProps["FeedBack" + i] = {};
					_feedbackProps["FeedBack" + i].value = {"FeedBack": feedbackJsonData.replace(/\'/g, "")};
					data += "FeedBack" + i + ":{FeedBack:'" + feedbackJsonData + "'},";
					i++;
				}
			}
		}
		if (data.substring(data.length - 1, data.length) == ',') {
			data = data.substring(0, data.length - 1);
		}
		data += '}}}';
		return data;
	}

	///////////////////////////////////////////////数据迁移相关//////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//基础属性DIV页面构建
	function MigrationDIV(_r, data) {
		// 属性框
		new yigoflow.dataMapprops({}, _r);
		// 填入数据
		if (data) {
			if (data.DataMigrationprops) {
				for (let k in data.DataMigrationprops.DataMigrationprops) {
					_gprops[k] = {};
					_gprops[k].value = data.DataMigrationprops.DataMigrationprops[k].value;
					if (yigoflow.config.DataMigrationprops.DataMigrationprops[k]) {
						yigoflow.config.DataMigrationprops.DataMigrationprops[k].value = data.DataMigrationprops.DataMigrationprops[k].value;
					}
				}
			}
		}
		// 设置标题为"基础属性"，"源表单"，"目标表单"
		$("#yigoflow_dataMapprops_handle").text("迁移属性");
		$(_r).trigger('showprops', [yigoflow.config.DataMigrationprops.DataMigrationprops, {}]);
	}

	/**
	 * 数据迁移添加路径字段
	 * */
	function MigrationPaths(path, config, _r) {
		if (path) {
			//判断当前id是否有效无效就不去创建端点
			for (let indexpaths in path) {
				if (path[indexpaths].sourceEndpoint != undefined && path[indexpaths].targetEndpoint != undefined && $("#" + path[indexpaths].sourceEndpoint)[0] != undefined && $("#" + path[indexpaths].targetEndpoint)[0] != undefined) {
					continue;
				} else {
					delete path[indexpaths];
				}
			}
			for (const key in _datamapPaths) {
				//如果当前更新的数据中没有的话就给删除
				if (!path[key]) {
					delete _datamapPaths[key];
				}
			}
			for (let k in path) {
				_datamapPaths[k] = {};
				_datamapPaths[k].value = path[k];
			}
		}
		//获取id绑定给连线工具,同时给文本框绑定事件用于效果优化
		let sourceInput = $("#Table__" + sourceFormKey).find("input");
		let targetInput = $("#Table__" + targetFormKey).find("input");
		let arrSourceID = [], arrTargetID = [];
		for (let inputID in sourceInput) {
			if (sourceInput[inputID].id && sourceInput[inputID].id.substring(0, 2).indexOf("F_") != -1) {
				arrSourceID.push(sourceInput[inputID].id);
				$("#" + sourceInput[inputID].id).mousedown(function (e) {
					let offsetWidth = e.toElement.offsetWidth;
					let offsetX = e.offsetX;
					if (offsetX > 40 && offsetX < (offsetWidth - 70)) {
						const el = $(e.target);
						el.css("cursor", "move");
					} else {
						const el = $(e.target);
						el.css("cursor", "crosshair");
						curTr = null;
					}
				});
			}
		}
		for (let inputID in targetInput) {
			if (targetInput[inputID].id && targetInput[inputID].id.substring(0, 2).indexOf("F_") != -1) {
				arrTargetID.push(targetInput[inputID].id);
				$("#" + targetInput[inputID].id).mousedown(function (e) {
					let offsetWidth = e.toElement.offsetWidth;
					let offsetX = e.offsetX;
					if (offsetX > 40 && offsetX < (offsetWidth - 70)) {
						const el = $(e.target);
						el.css("cursor", "move");
					} else {
						const el = $(e.target);
						el.css("cursor", "crosshair");
						curTr = null;
					}
				});
			}
		}
		loadLigature(path, config, undefined);
		// 有些东西用不到就设置为undefined
		setTimeout((function () {
			ligature(arrSourceID, arrTargetID, _r, config, path, undefined, undefined);
		}), 1);
	}

	/**
	 * 清除为保存标识
	 * */
	function removeFalg(flag) {
		if (flag) {
			//保存后更改样式
			let hideDiv = document.getElementsByClassName("layui-badge-dot");
			for (const strKey in hideDiv) {
				if (hideDiv[strKey].style) {
					hideDiv[strKey].style.display = "none";
				}
			}
		}
	}

	function reloadPanelMigrate(_r, restore, isoperate, config) {
		// 先进行连线信息的清空操作
		jsPlumb.deleteEveryConnection();
		jsPlumb.sourceEndpointDefinitions = {};
		jsPlumb.targetEndpointDefinitions = {};
		//做一个事件的清空，不然的话就会出现连接一次触发多次连接事件
		jsPlumb._listeners = {};
		/////////////////源单面板回撤构建///////////////
		if (!isoperate) {
			// 删除面板的时候去删除锚点 之后再重新添加
			jsPlumb.deleteEveryEndpoint();
			let byId = document.getElementById("yigoflow_sourceProps");
			let bytargetId = document.getElementById("yigoflow_targetProps");
			byId.parentNode.removeChild(byId);
			bytargetId.parentNode.removeChild(bytargetId);
			handleDataMigrationSource(_r, restore);
		}
		/////////////////////目标面板回撤构建///////////////////
		if (!isoperate) {
			handleDataMigrationTarget(_r, restore);
		}
		/////////////////连线信息回撤构建////////////
		let path = restore.paths.path;
		//保证连线最后一个执行
		setTimeout((function () {
			//通过路径添加连线
			MigrationPaths(path, config, _r);
		}), 1)
	}

	function handleDataMigrationSource(_r, restore) {
		/**创建源表单面板*/
		CreatSourceOrtargetDiv("SourceTableCollection");
		/**创建目标表单div*/
		CreatSourceOrtargetDiv("TargetTableCollection");
		//添加表头信息
		addHeadInfo(restore, "Migration");
		$('#yigoflow_sourceProps_handle').click(function () {
			sourcePanelJson.Key.value = yigoflow.config.sourceForm;
			sourcePanelJson.sourceCaption.value = yigoflow.config.sourceCaption;
			$("#yigoflow_dataMapprops_handle").text("源数据对象属性");
			$(_r).trigger('showprops', [sourcePanelJson, {
				Key: {
					name: 'Key', label: '源表单标识', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				}, sourceCaption: {
					name: 'sourceCaption', label: '源表单说明', value: '', editor: function () {
						return new yigoflow.editors.inputEditor();
					}
				},
			}]);
		});
		// 属性框
		new yigoflow.sourceprops({}, _r, sourceFormKey);
		//构建页面
		_source(restore.source);
		if (yigoflow.config.sourceProps) {
			for (let k in yigoflow.config.sourceProps.sourceProps) {
				_gprops[k] = {};
				_gprops[k].value = yigoflow.config.sourceProps.sourceProps[k].value;
			}
		}
		$("#yigoflow_sourceProps").find("table").attr("id", "Table__" + sourceFormKey);
		//构建源单面板
		addSource(_r);
		let source = restore.source.source;
		sourceTableAttr = restore.source.table;
		//添加源单Html
		addSourceHtml(source);
	}

	function handleDataMigrationTarget(_r, restore) {
		$('#yigoflow_targetProps_handle').click(function () {
			let MigrationtargetJson = {};
			MigrationtargetJson.Key = {
				name: 'Key', label: '目标表单标识', value: '', editor: function () {
					return new yigoflow.editors.inputEditor();
				}
			};
			MigrationtargetJson.sourceCaption = {
				name: 'sourceCaption', label: '目标表单说明', value: '', editor: function () {
					return new yigoflow.editors.inputEditor();
				}
			};
			MigrationtargetJson.Key.value = yigoflow.config.targetForm;
			MigrationtargetJson.sourceCaption.value = yigoflow.config.targetCaption;
			$("#yigoflow_dataMapprops_handle").text("目标数据对象属性");
			$(_r).trigger('showprops', [MigrationtargetJson, {}]);
		});
		// 属性框
		new yigoflow.targetprops({}, _r, targetFormKey);
		let targetdata = restore.target.target;
		_targetProp(targetdata);
		if (yigoflow.config.targetProps) {
			for (let k in yigoflow.config.targetProps.targetProps) {
				_gprops[k] = {};
				_gprops[k].value = yigoflow.config.targetProps.targetProps[k].value;
			}
		}
		$("#yigoflow_targetProps").find("table").attr("id", "Table__" + targetFormKey);
		//构建目标表单页面
		addMigrationTarget(_r);
		//清一下缓存
		Clearcache();
		//给目标表单添加Html
		addMigrationTargetHtml(targetdata);
		//更新面板坐标方法
		updateXY(coordinateChange);
	}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// 初始化数据迁移
	yigoDataMirationflow.init = function (c, o) {
		// 获取基本配置
		function getBaseNodeConfig() {
			return Object.assign({}, visoConfig.baseStyle)
		};var config = getBaseNodeConfig();
		//数据迁移标识
		DataMapOrMigration = true;
		var _w = $(window).width(), _h = $(window).height(), _r = Raphael(c, _w * 0.99, _h * 0.99);
		$.extend(true, yigoflow.config, o);
		ctrlEnabled = false;
		// 取消ctrl键的选择
		ctrlEnabled = false;
		// 清空数组
		selectedEles = [];
		// 阻止事件冒泡
		event.stopPropagation();
		//构建基础属性面板
		let data = eval("(" + sessionStorage.getItem(yigoflow.config.cacheFileName) + ")");
		MigrationDIV(_r, data);
		//点击网格的时候也去触发基础属性面板
		$(document).click(function () {
			//防止点击连线和这个冲突
			if (publicFalg) {
				publicFalg = false;
				return;
			}
			idFlag = "";
			setTimeout((function () {
				let data = eval("(" + sessionStorage.getItem(yigoflow.config.cacheFileName) + ")");
				MigrationDIV(_r, data);
			}), 1)
		});
		handleDataMigrationSource(_r, o.restore);
		handleDataMigrationTarget(_r, o.restore);
		let path = o.restore.paths.path;
		//处理连线数据
		MigrationPaths(path, config, _r);
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////撤销和保存事件监听////////////////////////////////////////////////////////////////////////
		//保存操作,快捷键Ctrl+S
		document.addEventListener("keydown", function (event) {
			if (event.ctrlKey && event.shiftKey && e.keyCode == 90) {//反撤销
				window.parent.ReMakeXmlFile();
			} else if (event.ctrlKey && event.keyCode == 90) {//撤销
				window.parent.UnMakeXmlFile();
			}
		});
		$("#reload").click(function () {
			// 保证数据是实时的
			numberID = 1
			let restore = eval("(" + sessionStorage.getItem(yigoflow.config.cacheFileName) + ")");
			reloadPanelMigrate(_r, restore, false, config);
		})
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////数据迁移结束/////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	window.onbeforeunload = function (e) {
		var n = window.event.screenX - window.screenLeft;
		var b = n > document.documentElement.scrollWidth - 20;
		if (b && window.event.clientY < 0 || window.event.altKey) {
			alert("关闭 ");
			window.event.returnValue = "还未保存是否离开页面"; //这里可以放置你想做的操作代码      
		} else {
			alert("刷新");
		}
	}

	/***
	 * ajax请求后端处理
	 * @param params 请求参数
	 * @param operType 操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
	 * @param nodeType 节点类型：start,end,task等
	 * @param nodeId 当前操作的节点id
	 * @param _r 当前画笔
	 */
	function ajaxRequest(params, operType, nodeType, nodeId, _r) {
		ajaxStatus = false;
		isLockScreen = true;
		var layer = layui.layer;
		let index = layer.load();
		$.ajax({
			type: "post", url: "/erp/bpmAttributes/handleNodesAndPaths", dataType: 'json', async: false,//同步执行
			contentType: 'application/json;charset=utf-8', data: JSON.stringify(params), success: function (res) {
				layer.close(index);
				if (!res) {
					layer.alert("请求响应失败", function (index) {
						isLockScreen = false;
						layer.close(index);
						event.stopImmediatePropagation();
					});
					return;
				}
				if (res.code == 0) {
					let jsonData = res.data;
					if (jsonData) {
						try {
							yigoflow.config.restore = jsonData.restore;
							let data = eval("(" + params.content + ")");
							yigoflow.config.restore.states = data.states;
						} catch (e) {
							yigoflow.config.restore = jsonData.restore;
						}
						// 非路径节点才进行的操作
						if (nodeType != "SequenceFlow" && nodeType != "Association" && nodeType != "ExceptionFlow") {
							// 修改和删除的操作
							if (operType == 2) {
								ajaxStatus = true;
								// 节点类型是泳道，那么更新一下泳道的水平和垂直位置以及宽高
								if (nodeType == "Swimline") {
									$("#pWidth").children("input").eq(0)
										.val(yigoflow.config.restore.states[nodeId].attr.width);
									$("#pHeight").children("input").eq(0)
										.val(yigoflow.config.restore.states[nodeId].attr.height);
									$("#pX").children("input").eq(0)
										.val(yigoflow.config.restore.states[nodeId].attr.x);
									$("#pY").children("input").eq(0)
										.val(yigoflow.config.restore.states[nodeId].attr.y);
								}
								// 自动单击当前节点，显示对应的属性窗口
								$(_r).trigger('click', {
									getId() {
										return nodeId;
									}
								});
								return;
							}
							if (operType == 3) {
								ajaxStatus = true;
								isLockScreen = false;
								return;
							}
							// 新增的操作
							if (operType == 1) {
								if (JSON.stringify(yigoflow.config.restore.states[nodeId].props) === "{}") {
									layer.alert("当前节点的属性值为空，创建节点失败", function (index) {
										isLockScreen = false;
										layer.close(index);
										event.stopImmediatePropagation();
									});
									return;
								}
								// 自动单击当前节点，显示对应的属性窗口
								$(_r).trigger('click', {
									getId() {
										return nodeId;
									}
								});
								ajaxStatus = true;
							}
						} else {
							ajaxStatus = true;
							isLockScreen = false;
						}
					}
				} else {
					isLockScreen = false;
					layer.close(index);
					event.stopImmediatePropagation()
				}
			}, error: function () {
				layer.close(index);
				if (operType == 1) {
					layer.alert("新增节点失败", function (index) {
						isLockScreen = false;
						layer.close(index);
						event.stopImmediatePropagation();
					});
				} else if (operType == 2) {
					layer.alert("修改节点失败", function (index) {
						isLockScreen = false;
					});
				} else if (operType == 3) {
					layer.alert("删除节点失败", function (index) {
						isLockScreen = false;
						layer.close(index);
						event.stopImmediatePropagation();
					});
				} else {
					layer.alert("未知类型操作节点失败", function (index) {
						isLockScreen = false;
						layer.close(index);
						event.stopImmediatePropagation();
					});
				}
			}
		});//更新xml
		window.parent.DESIGNER.Src.reloadXmlSource(params.filePath);
	}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////数据映射AjAx请求方法区/////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/***
	 * ajax请求更新xml的内容
	 * @param params 请求参数
	 */
	function ajaxDataMapUpdateXml(params) {
		isLockScreen = true;
		var layer = layui.layer;
		let index = layer.load();
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/dataMapUpdateXml",
			dataType: 'json',
			async: false,
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(params),
			success: function (res) {
				layer.close(index);
				if (res) {
					if (res.code == 0) {
						sessionStorage.removeItem(yigoflow.config.cacheFileName);
						sessionStorage.setItem(yigoflow.config.cacheFileName, JSON.stringify(res.data[0]));
						isLockScreen = false;
						$("#reload").trigger('click');
					} else {
						layer.alert(res.msg, function (index) {
							isLockScreen = false;
							layer.close(index);
							event.stopImmediatePropagation();
						});
					}
				} else {
					layer.alert("更新xml内容请求响应失败", function (index) {
						isLockScreen = false;
						layer.close(index);
						event.stopImmediatePropagation();
					});
				}
			},
			error: function () {
				layer.close(index);
				layer.alert("更新xml内容失败", function (index) {
					isLockScreen = false;
					layer.close(index);
					event.stopImmediatePropagation();
				});
				isLockScreen = false;
			}
		});

		window.parent.DESIGNER.Src.reloadXmlSource(params.filePath);
	}

	/**
	 * 获取表单字段ajax请求方法
	 * @param {any} dataMapParams
	 * @param {number} _k
	 */
	function getFormField(dataMapParams, sle, _props, _k) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/getFormField",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				sessionStorage.setItem("dataMapData" + yigoflow.config.cacheFileName, JSON.stringify(res.data));
				if (res) {
					if (res.code == 0) {
						var opts = res.data;
						if (opts && opts.length > 0) {
							sle.append('<option value=""></option>');
							for (let idx = 0; idx < opts.length; idx++) {
								sle.append('<option value="' + opts[idx].value + '">' + opts[idx].name + '</option>');
							}
							sle.val(_props[_k].value);
						}
					} else {
						console.error(res.msg);
					}
				} else {
					console.error("获取当前表单字段响应失败");
				}
			},
			error: function () {
				console.error("获取当前表单字段失败");
			}
		});
	}

	function swapTargetProps(source, target) {
		let sourceKey, sourceValue, targetKey;
		for (const targetPropKey in _targetProps) {
			let field = _targetProps[targetPropKey] && _targetProps[targetPropKey].Definition ? _targetProps[targetPropKey].Definition.split("_@_")[1] : _targetProps[targetPropKey].FieldKey ? _targetProps[targetPropKey].FieldKey.split("_@_")[1] : null;
			if (!field) continue;
			if (field === source) {
				sourceKey = targetPropKey;
				// 为了防止随着对象的改变 值会改变 所以先转换为JSON
				sourceValue = JSON.stringify(_targetProps[targetPropKey]);
			}
			if (field === target) {
				targetKey = targetPropKey;
			}
		}
		if (sourceKey && targetKey) {
			// 交换位置  迁移使用的是Filedkey 做一个区分
			if (_targetProps[sourceKey].Definition) {
				_targetProps[sourceKey].Definition = _targetProps[targetKey].Definition;
			} else {
				_targetProps[sourceKey].FieldKey = _targetProps[targetKey].FieldKey;
			}
			_targetProps[targetKey] = JSON.parse(sourceValue);
		}
	}

	function swapSourceProps(source, target) {
		let sourceKey, sourceValue, targetKey;
		for (const sourcePropsKey in _sourceProps) {
			let field = !_sourceProps[sourcePropsKey] ? null : _sourceProps[sourcePropsKey].Definition.split("_@_")[1];
			if (!field) continue;
			if (field === source) {
				sourceKey = sourcePropsKey;
				sourceValue = JSON.stringify(_sourceProps[sourcePropsKey]);
			}
			if (field === target) {
				targetKey = sourcePropsKey;
			}
		}
		if (sourceKey && targetKey) {
			// 交换位置
			_sourceProps[sourceKey].Definition = _sourceProps[targetKey].Definition;
			_sourceProps[targetKey] = JSON.parse(sourceValue);
		}
	}

	function swapFeedBackProps(source, target) {
		let sourceKey, sourceValue, targetKey;
		for (const feedBackPropKey in _feedbackProps) {
			let feedBackValue = !_feedbackProps[feedBackPropKey] ? null : _feedbackProps[feedBackPropKey].value.FeedBack.split("_@_")[1];
			if (!feedBackValue) continue;
			if (feedBackValue === source) {
				sourceKey = feedBackPropKey;
				sourceValue = JSON.stringify(_feedbackProps[feedBackPropKey]);
			}
			if (feedBackValue === target) {
				targetKey = feedBackPropKey;
			}
		}
		if (sourceKey && targetKey) {
			// 交换位置
			_feedbackProps[sourceKey].value.FeedBack = _feedbackProps[targetKey].value.FeedBack;
			_feedbackProps[targetKey] = JSON.parse(sourceValue);
		}
	}

	/**
	 * 处理表格移动方法
	 * */
	function handleSwapTr(data, sourceForm, source, target, feedback, targetFormKey, targetTableKey) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/handleSwapTr",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(data),
			success: function (res) {
				if (res) {
					if (res.code === 0) {
						ajaxStatus = true;
						exchange = true;
						sessionStorage.removeItem(yigoflow.config.cacheFileName);
						sessionStorage.setItem(yigoflow.config.cacheFileName, JSON.stringify(res.data[0]));
						/*if (!feedback && sourceForm === sourceFormKey) {
							swapSourceProps(source, target);
						} else if (!feedback && sourceForm === targetFormKey) {
							swapTargetProps(source, target);
						} else {
							swapFeedBackProps(source, target);
						}*/
					} else {
						layer.msg(res.msg, { time: 2000 });
					}
				} else {
					layer.msg("移动失败", { time: 2000 });
				}
			},
			error: function () {
				layer.msg("移动失败", { time: 2000 });
			}
		});
		window.parent.DESIGNER.Src.reloadXmlSource(data.filePath);
	}

	/**
	 * 删除反填表单 后端Xml 文件的处理方法
	 * @param {any} dataMapParams
	 */
	function handleDeleteXML(data) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/handleDeleteXML",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(data),
			success: function (res) {
				if (res) {
					if (res.code == 0) {
						sessionStorage.removeItem(yigoflow.config.cacheFileName);
						sessionStorage.setItem(yigoflow.config.cacheFileName, JSON.stringify(res.data[0]));
						window.parent.DESIGNER.Src.reloadXmlSource(data.filePath);
						$("#reload").trigger('click');
						isLockScreen = false;
					} else {
						layer.msg(res.msg, { time: 2000 });
					}
				} else {
					layer.msg("删除当前反填表单失败", { time: 2000 });
				}
			},
			error: function () {
				layer.msg("删除当前反填表单失败", { time: 2000 });
			}
		});
	}

	/**
	 * 获取数据迁移字段目标数据对象的字段
	 * @param {any} dataMapParams
	 * @param {number} _k
	 */
	function getMigrationField(dataMapParams, sle, _props, _k) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/getMigrationField",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				sessionStorage.setItem("dataMapData" + yigoflow.config.cacheFileName, JSON.stringify(res.data));
				if (res) {
					if (res.code == 0) {
						var opts = res.data;
						if (opts && opts.length > 0) {
							sle.append('<option value=""></option>');
							for (let idx = 0; idx < opts.length; idx++) {
								sle.append('<option value="' + opts[idx].value + '">' + opts[idx].name + '</option>');
							}
							sle.val(_props[_k].value);
						}
					} else {
						console.error(res.msg);
					}
				} else {
					console.error("获取当前数据对象字段响应失败");
				}
			},
			error: function () {
				console.error("获取当前数据对象字段失败");
			}
		});
	}

	/**
	 * 弹窗获取表单字段ajax请求方法
	 * @param {any} dataMapParams
	 * @param {number} _k
	 */
	function getfinAllFormField(dataMapParams) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/findAllFormField",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			async: false,
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res) {
					if (res.code == 0) {
						DataMapDataJson = res.data;
					} else {
						console.error(res.msg);
					}
				} else {
					console.error("获取当前表单字段响应失败");
				}
			},
			error: function () {
				console.error("获取当前表单字段失败");
			}
		});
	}

	function getTableKeyField(dataMapParams, sle) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/getTableKeyField",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res) {
					if (res.code == 0) {
						var opts = res.data;
						if (opts && opts.length > 0) {
							sle.append('<option value=""></option>');
							for (let idx = 0; idx < opts.length; idx++) {
								sle.append('<option value="' + opts[idx].value + '">' + opts[idx].name + '</option>');
							}
						}
					} else {
						console.error(res.msg);
					}
				} else {
					console.error("获取当前表单字段响应失败");
				}
			},
			error: function () {
				console.error("获取当前表单字段失败");
			}
		});
	}

	//获取所有formKey
	function getAllFormkey(dataMapParams) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/getAllFormkey",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res) {
					if (res.code === 0) {
						DataMapDataJson = res.data;
					} else {
						console.error(res.msg);
					}
				} else {
					console.error(res);
				}
			},
			error: function () {
				console.error("获取表单失败");
			}
		});
	}

	/**根据不同的tableKey去获取字段，并且渲染树*/
	function getfindTabaleKeyField(dataMapParams) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/findTabaleKeyField",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			async: false,
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res) {
					if (res.code == 0) {
						DataMapDataJson = res.data;
					} else {
						console.error(res.msg);
					}
				} else {
					console.error("获取当前表单字段响应失败");
				}
			},
			error: function () {
				console.error("获取当前表单字段失败");
			}
		});
	}

	function deleteField(dataMapParams) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/deleteField",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			async: false,
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res) {
					if (res.code == 0) {
						sessionStorage.removeItem(yigoflow.config.cacheFileName);
						sessionStorage.setItem(yigoflow.config.cacheFileName, JSON.stringify(res.data[0]));
						$("#reload").trigger('click');
					} else {
						console.error(res.msg);
					}
				} else {
					console.error("删除字段失败");
				}
			},
			error: function () {
				console.error("删除字段失败");
			}
		});
		window.parent.DESIGNER.Src.reloadXmlSource(dataMapParams.filePath);
	}

	/**用于获取字段信息*/
	function fieldInfo(dataMapParams) {
		let result = {};
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/fieldInfo",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			async: false,
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res.data) {
					ajaxStatus = true;
					result = res;
				} else {
					console.error("获取当前字段信息失败");
				}
			},

			error: function () {
				console.error("获取当前字段信息失败");
			}
		});
		return result;
	};

	/**获取目标表标识*/
	function getTargetTableList(dataMapParams, sle, _props, _k) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/getTargetTableList",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				sessionStorage.setItem("dataMapData" + yigoflow.config.cacheFileName, JSON.stringify(res.data));
				if (res) {
					if (res.code == 0) {
						var opts = res.data;
						if (opts && opts.length > 0) {
							sle.append('<option value=""></option>');
							for (let idx = 0; idx < opts.length; idx++) {
								sle.append('<option value="' + opts[idx].value + '">' + opts[idx].name + '</option>');
							}
							sle.val(_props[_k].value);
						}
					} else {
						console.error(res.msg);
					}
				} else {
					console.error("获取当前表单字段响应失败");
				}
			},
			error: function () {
				console.error("获取当前表单字段失败");
			}
		});
	}

	/**获取目标表标识*/
	function getSourceFieldList(dataMapParams, sle, _props, _k) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/getSourceFieldList",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				sessionStorage.setItem("dataMapData_SourceField" + yigoflow.config.cacheFileName, JSON.stringify(res.data));
				if (res) {
					if (res.code == 0) {
						var opts = res.data;
						if (opts && opts.length > 0) {
							for (let idx = 0; idx < opts.length; idx++) {
								sle.append('<option value="' + opts[idx].value + '">' + opts[idx].name + '</option>');
							}
							sle.val(_props[_k].value);
						}
					} else {
						console.error(res.msg);
					}
				} else {
					console.error("获取当前表单字段响应失败");
				}
			},
			error: function () {
				console.error("获取当前表单字段失败");
			}
		});
	}

	/**获取参照主表字段标识*/
	function getRefFieldKey(dataMapParams, sle, _props, _k) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/getRefFieldKey",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res) {
					if (res.code == 0) {
						var opts = res.data;
						if (opts && opts.length > 0) {
							sle.append('<option value=""></option>');
							for (let idx = 0; idx < opts.length; idx++) {
								sle.append('<option value="' + opts[idx].value + '">' + opts[idx].name + '</option>');
							}
							sle.val(_props[_k].value);
						}
					} else {
						console.error(res.msg);
					}
				} else {
					console.error("获取参照主表字段失败");
				}
			},
			error: function () {
				console.error("获取参照主表字段失败");
			}
		});
	}

	/**获取状态字段标识*/
	function getStatusFideldKey(dataMapParams, sle, _props, _k) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/getStatusFideldKey",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res) {
					if (res.code == 0) {
						var opts = res.data;
						if (opts && opts.length > 0) {
							sle.append('<option value=""></option>');
							for (let idx = 0; idx < opts.length; idx++) {
								sle.append('<option value="' + opts[idx].value + '">' + opts[idx].name + '</option>');
							}
							sle.val(_props[_k].value);
						}
						sessionStorage.setItem(_props.Key.value + "StatusFideldKey", JSON.stringify(opts));
					} else {
						console.error(res.msg);
					}
				} else {
					console.error("获取参照主表字段失败");
				}
			},
			error: function () {
				console.error("获取参照主表字段失败");
			}
		});
	}

	//连线去添加目标节点
	function setTargetField(dataMapParams) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/setTargetField",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			async: false,
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res) {
					if (res.code == 0) {
						DataMapDataJson = res.data;
						sessionStorage.removeItem(yigoflow.config.cacheFileName);
						sessionStorage.setItem(yigoflow.config.cacheFileName, JSON.stringify(res.data[0]));
						$("#reload").trigger('click');
					} else {
						layer.msg(res.msg, {icon: 1, time: 1500, shade: [0.8, '#393D49']});
					}
				} else {
					layer.msg(res.msg, {icon: 1, time: 1500, shade: [0.8, '#393D49']});
				}
			},
			error: function () {
				layer.msg(res.msg, {icon: 1, time: 1500, shade: [0.8, '#393D49']});
			}
		});

		window.parent.DESIGNER.Src.reloadXmlSource(dataMapParams.filePath);
	}

	//判断当前连接的源单字段和目标表单类型是否相同
	function isConnected(dataMapParams) {
		let boolean;
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/isConnected",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			async: false,
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res) {
					if (res.code === 0) {
						if (res.msg) {
							let layer = layui.layer;
							layer.open({
								content: res.msg, btn: ['关闭'], btn1: function () {
									layer.close(layer.index);
								}, cancel: function () {
									layer.close(layer.index);
								}
							});
						}
						boolean = res.data;
					} else {
						console.error(res.msg);
					}
				} else {
					console.error("判断失败");
				}
			},
			error: function () {
				console.error("判断失败");
			}
		});
		return boolean;
	}

	//连线数据获取
	function ligatureinfo(dataMapParams) {
		let result = {};
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/ligatureinfo",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			async: false,
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res.data) {
					ajaxStatus = true;
					result = res.data;
				} else {
					console.error("获取连线信息失败");
				}
			},

			error: function () {
				console.error("获取连线信息失败");
			}
		});
		return result;
	}

	//在拖动div的时候去修改坐标
	function coordinateupdate(dataMapParams) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/coordinate",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			async: false,
			data: JSON.stringify(dataMapParams),
			success: function () {

			}
		});
		window.parent.DESIGNER.Src.reloadXmlSource(dataMapParams.filePath);
	}

	//动态获取坐标，每次在构建页面之前都去重新获取坐标
	function coordinatedata(dataMapParams) {
		var coordinatedata = "";
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/coordinateData",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			async: false,
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res.code === 0) {
					if (res.data.length != 0) {
						ajaxStatus = true;
					}
					coordinatedata = res.data;
				}
			}
		});
		return coordinatedata;
	}

	/*删除连线后进行后端的XML数据处理*/
	function updateLigatureXML(dataMapParams) {
		$.ajax({
			type: "post",
			url: "/erp/dataMapAttributes/updateLigatureXML",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			async: false,
			data: JSON.stringify(dataMapParams),
			success: function (res) {
				if (res.code === 0) {
					ajaxStatus = true;
				} else {
					console.error("删除删除连线失败");
				}
			},

			error: function () {
				console.error("删除当前连接异常");
			}
		});

		window.parent.DESIGNER.Src.reloadXmlSource(dataMapParams.filePath);
	}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/***
	 * ajax请求更新xml的内容
	 * @param params 请求参数
	 */
	function ajaxUpdateXml(params) {
		isLockScreen = true;
		var layer = layui.layer;
		let index = layer.load();
		$.ajax({
			type: "post",
			url: "/erp/bpmAttributes/updateXml",
			dataType: 'json',
			async: false,
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(params),
			success: function (res) {
				layer.close(index);
				if (res) {
					if (res.code == 0) {
						ajaxStatus = true;
						isLockScreen = false;
					} else {
						layer.alert(res.msg, function (index) {
							isLockScreen = false;
							layer.close(index);
							event.stopImmediatePropagation();
						});
					}
				} else {
					layer.alert("更新xml内容请求响应失败", function (index) {
						isLockScreen = false;
						layer.close(index);
						event.stopImmediatePropagation();
					});
				}
			},
			error: function () {
				layer.close(index);
				layer.alert("更新xml内容失败", function (index) {
					isLockScreen = false;
					layer.close(index);
					event.stopImmediatePropagation();
				});
				isLockScreen = false;
			}
		});
		window.parent.DESIGNER.Src.reloadXmlSource(params.filePath);
	}

	/***
	 * ajax请求新增版本
	 * @param params 请求参数
	 */
	function ajaxNewVersionBpm(params) {
		isLockScreen = true;
		var layer = layui.layer;
		let index = layer.load();
		$.ajax({
			type: "post",
			url: "/erp/bpmAttributes/newVersion",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(params),
			success: function (res) {
				layer.close(index);
				if (res.code == 0) {
					ajaxStatus = true;
					let filePath = res.data.filePath;
					let fileName = res.data.fileName;
					let caption = res.data.caption;
					let version = "V" + res.data.version;

					// 把文件路径filePath放到sessionStorage中
					sessionStorage.removeItem("BPM_" + fileName + "_filePath");
					sessionStorage.setItem("BPM_" + fileName + "_filePath", filePath);
					/* setTimeout(function () {
                        $("li[key='RefreshTree']",parent.document).find('a').unbind('click').click();
                    },100)*/

					// window.parent.document.getElementById('p_nr').innerHTML ='内容';//控制父级页面的元素
					// window.parent.testParent();//调用父级页面的Js函数
					// res.data.uICommands
					window.parent.DESIGNER.UI.ReloadMenuTree();
					window.parent.DESIGNER.UI.reloadFileTree(filePath);
					/*  // 打开新版本窗口
                    window.open('./bpm.html?fileName=' + fileName + '&Caption='
                        + encodeURIComponent(caption) + "&version=" + version, fileName);*/
					layer.msg(res.msg, {icon: 1, time: 1000, shade: [0.8, '#393D49']}, function () {
						isLockScreen = false;
					});

				} else {
					if (res.msg) {
						layer.alert(res.msg, function (index) {
							isLockScreen = false;
							layer.close(index);
							event.stopImmediatePropagation();
						});
					} else {
						layer.alert("新增版本请求响应失败", function (index) {
							isLockScreen = false;
							layer.close(index);
							event.stopImmediatePropagation();
						});
					}
				}
				isLockScreen = false;
			},
			error: function () {
				layer.close(index);
				layer.alert("新增版本失败", function (index) {
					isLockScreen = false;
					layer.close(index);
					event.stopImmediatePropagation();
				});
				isLockScreen = false;
			}
		});
	}

	/***
	 * ajax请求部署工作流
	 * @param params 请求参数
	 */
	function ajaxDeployBpm(params) {
		isLockScreen = true;
		var layer = layui.layer;
		let index = layer.load();
		$.ajax({
			type: "post",
			url: "/erp/bpmAttributes/deployBpm",
			dataType: 'json',
			contentType: 'application/json;charset=utf-8',
			data: JSON.stringify(params),
			success: function (res) {
				layer.close(index);
				if (res.code == 0) {
					ajaxStatus = true;
					layer.msg(res.msg, {icon: 1, time: 1000, shade: [0.8, '#393D49']}, function () {
						isLockScreen = false;
					});
				} else {
					layer.alert("部署工作流请求响应失败", function (index) {
						isLockScreen = false;
						layer.close(index);
						event.stopImmediatePropagation();
					});
				}
				isLockScreen = false;
			},
			error: function () {
				layer.close(index);
				layer.alert("部署工作流失败", function (index) {
					isLockScreen = false;
					layer.close(index);
					event.stopImmediatePropagation();
				});
				isLockScreen = false;
			}
		});
	}

	/*
    * 修改地址栏中的参数值
    * arg 需要替换的参数名称* arg_val 替换后的参数的值* return url 参数替换后的url
    */
	function changeURLArg(url, arg, arg_val) {
		var pattern = arg + '=([^&]*)';
		var replaceText = arg + '=' + arg_val;
		if (url.match(pattern)) {
			var tmp = '/(' + arg + '=)([^&]*)/gi';
			tmp = url.replace(eval(tmp), replaceText);
			return tmp;
		} else {
			if (url.match('[\?]')) {
				return url + '&' + replaceText;
			} else {
				return url + '?' + replaceText;
			}
		}
		return url + '\n' + arg + '\n' + arg_val;
	}

	// 添加jquery方法
	$.fn.yigoflow = function (o) {
		return this.each(function () {
			yigoflow.init(this, o);
		});
	};
	//数据映射添加Jquery
	$.fn.yigoDataMapflow = function (o) {
		return this.each(function () {
			yigoDataMapflow.init(this, o);
		});
	};
	//构建数据迁移页面
	$.fn.yigoDataMirationflow = function (o) {
		return this.each(function () {
			yigoDataMirationflow.init(this, o);
		});
	};

// 下面是yigoflow的拓展方法
	$.extend(true, yigoflow.editors, {
		inputEditor: function () {
			var _props, _k, _div, _src, _r;
			this.init = function (props, k, div, src, r) {
				_props = props;
				_k = k;
				_div = div;
				_src = src;
				_r = r;
				if (props[_k].value == "null") {
					props[_k].value = "";
				}
				// 自有节点状态，默认为"-1"
				if (_k == "BPMState" && !props[_k].value) {
					props[_k].value = "-1";
				}

				/***
				 * 参与者集合-字典设置
				 * @param table
				 * @param dictionaryData
				 * @param layer
				 */
				function participatorDictionaryConfig(table, dictionaryData, layer) {
					//“参与者集合->字典”表格
					table.render({
						elem: '#participator_dictionary',
						toolbar: '#buttonsToolbar',
						even: true,
						height: 440,
						defaultToolbar: [],
						contentType: "application/x-www-form-urlencoded",
						data: dictionaryData,
						cols: [[{type: 'checkbox'}, {
							field: 'id', width: 60, title: '编号'
						}, {
							field: 'dictType', width: 135, title: '字典标识', sort: true, templet: '#dictTypeTpl'
						}, {
							field: 'codeType', width: 135, title: 'Code/ID', sort: true, templet: '#codeTypeTpl'
						}, {
							field: 'codeValue', title: '字典值(code/id)', width: 200
						}, {
							fixed: 'right', title: '操作', width: 113, align: 'center', toolbar: '#lineBtnsBar'
						}]], //设置表头
					});

					let data_tr;
					//监听表格复选框选择
					table.on('checkbox(participator_dictionary)', function (obj) {
						data_tr = $(this);
						//全选时
						if (obj.type == "all") {
							if (obj.checked) {//全选中
								var checkStatus = table.checkStatus('participator_dictionary');
								var sdata = checkStatus.data;
								if (sdata.length > 0) {//渲染背景颜色
									$(".layui-table-body .layui-table tr").each(function () {
										$(this).addClass("tr_bj_color");
									})
								}
							} else {//全部不选
								$(".layui-table-body .layui-table tr").each(function () {
									$(this).removeClass("tr_bj_color");
								})
							}
						} else {//单选
							var checkStatus = table.checkStatus('participator_dictionary');
							var sdata = checkStatus.data;
							if (obj.checked) {//选中
								obj.tr.addClass('tr_bj_color');
							} else {//取消选中
								obj.tr.removeClass('tr_bj_color');
							}
						}
					});

					//监听行工具事件
					//注：tool 是工具条事件名，test 是 table 原始容器的属性 lay-filter="对应的值"
					table.on('tool(participator_dictionary)', function (obj) {
						var data = obj.data //获得当前行数据（json格式的键值对）
							, layEvent = obj.event //获得 lay-event 对应的值（编辑、删除、添加）
							, editList = []; //存放获取到的那条json数据中的value值（不放key）
						$.each(data, function (name, value) {//循环遍历json数据
							editList.push(value);//将json数据中的value放入数组中（下面的子窗口显示的时候要用到）
						});
						if (layEvent === 'edit') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							showEdit(data);
						} else if (layEvent === 'del') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							layer.confirm('确定删除吗', function (index) {
								obj.del();
								let cbList = table.cache.participator_dictionary;
								let finalList = [];
								for (let i = 0; i < cbList.length; i++) {
									if (cbList[i] && cbList[i].length == 0) {
										continue;
									} else {
										finalList.push(cbList[i]);
									}
								}
								//重新对序号编码
								for (var i = 0; i < cbList.length; i++) {
									cbList[i].id = i+1;
								}
								table.reload("participator_dictionary", {
									data: finalList,
								});
								layer.close(index);
							});
						}
					});

					//头工具栏事件
					table.on('toolbar(participator_dictionary)', function (obj) {
						let layEvent = obj.event;
						if (layEvent === 'addDict') {
							addDict();
						} else if (layEvent === 'delCondition') {
							var checkStatus = table.checkStatus('participator_dictionary');
							if (checkStatus.data.length < 1) {
								layer.alert("请选择一条数据操作");
								return false;
							} else {
								layer.confirm('确定删除吗', function (index) {
									let cbList = table.cache.participator_dictionary;
									for (var k = 0; k < checkStatus.data.length; k++) {
										var _delId = checkStatus.data[k].id;
										for (var i = 0; i < cbList.length; i++) {
											var _id = cbList[i].id;
											if (_id == _delId) {
												cbList.splice(i, 1);
												break;
											}
										}
									}
									//重新对序号编码
									for (var i = 0; i < cbList.length; i++) {
										cbList[i].id = i+1;
									}
									table.reload("participator_dictionary", {
										data: cbList,
									});
									layer.close(index);
								});
							}
						}
					});

					function addDict() {
						var addHtml = '<div id="form1" class="layui-form" style="width:400px; margin-top: 20px;">\
                               <div class="layui-form-item">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:120px;padding: 3px 15px;">字典标识</label>\
                                 <div class="layui-input-block">\
                                   <select name="dictType" id="dictType" lay-filter="dictType" \
                                           style="display:block;height:26px;padding-left: 5px;width:200px;\
                                                  border-color: #D2D2D2!important;">\
                                    <option value="Operator">操作员</option>\
                                    <option value="Role">角色</option>\
                                   </select>\
                                 </div>\
                               </div>\
                               <div class="layui-form-item">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:120px;padding: 3px 15px;">Code/ID</label>\
                                 <div class="layui-input-block">\
                                   <select name="codeType" id="codeType" lay-filter="codeType" \
                                           style="display:block;height:26px;padding-left: 5px;width:200px;\
                                                  border-color: #D2D2D2!important;">\
                                    <option value="ItemID">字典ID</option>\
                                    <option value="Code">字典Code</option>\
                                   </select>\
                                 </div>\
                               </div>\
                               <div class="layui-form-item">\
                                 <label class="layui-form-label" style="white-space: nowrap;width:120px;\
                                                                        padding: 3px 15px;">字典值(code/id)</label>\
                                 <div class="layui-input-block">\
                                   <input type="text" name="codeValue" id="codeValue" lay-verify="codeValue" \
                                          value="" autocomplete="off" placeholder="请输入字典值(code/id)" \
                                          class="layui-input" style="height: 26px;width:200px;">\
                                 </div>\
                               </div>\
                            </div>';

						layer.open({
							type: 1,
							title: '新增',
							content: addHtml,
							area: ['400px', '300px'],
							btn: ['确定', '取消'],
							resize: false,
							move: false,
							yes: function (layIndex) {
								if (!$("#codeValue").val()) {
									layer.alert("字典值(code/id)不能为空");
									return;
								}

								let maxId = 0;
								var oldData = table.cache.participator_dictionary;//获得当前页面的原始数据
								if (!oldData) {
									oldData = [];
								} else {
									for (var i = 0; i < oldData.length; i++) {
										if (oldData[i].id > maxId) {
											maxId = oldData[i].id;
										}
									}
								}
								oldData.push({
									id: maxId + 1,
									dictType: $("#dictType").val(),
									codeType: $("#codeType").val(),
									codeValue: $("#codeValue").val()
								});//在原始数据前添加新添加的数据
								table.reload('participator_dictionary', {data: oldData});//把新处理的数据重新加载一下
								layer.msg('新增成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
								layer.close(layIndex);
							}
						});
					}

					function showEdit(data) {
						var editHtml = '<div id="form1" class="layui-form" style="width:400px; margin-top: 20px;">\
                               <div class="layui-form-item">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:120px;padding: 3px 15px;">字典标识</label>\
                                 <div class="layui-input-block">\
                                   <select name="dictType" id="dictType" lay-filter="dictType" \
                                           style="display:block;height:26px;padding-left: 5px;width:200px;\
                                                  border-color: #D2D2D2!important;">\
                                    <option value="Operator">操作员</option>\
                                    <option value="Role">角色</option>\
                                   </select>\
                                 </div>\
                               </div>\
                               <div class="layui-form-item">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:120px;padding: 3px 15px;">Code/ID</label>\
                                 <div class="layui-input-block">\
                                   <select name="codeType" id="codeType" lay-filter="codeType" \
                                           style="display:block;height:26px;padding-left: 5px;width:200px;\
                                                  border-color: #D2D2D2!important;">\
                                    <option value="ItemID">字典ID</option>\
                                    <option value="Code">字典Code</option>\
                                   </select>\
                                 </div>\
                               </div>\
                               <div class="layui-form-item">\
                                 <label class="layui-form-label" style="white-space: nowrap;width:120px;\
                                                                        padding: 3px 15px;">字典值(code/id)</label>\
                                 <div class="layui-input-block">\
                                   <input type="text" name="codeValue" id="codeValue" lay-verify="codeValue" \
                                           value="' + data.codeValue + '" autocomplete="off" \
                                           placeholder="请输入字典值(code/id)" class="layui-input" \
                                           style="height: 26px;width:200px;">\
                                 </div>\
                               </div>\
                            </div>';

						layer.open({
							type: 1,
							title: '编辑',
							content: editHtml,
							area: ['400px', '300px'],
							btn: ['确定', '取消'],
							resize: false,
							move: false,
							success: function (layIndex) {
								$("#dictType").val(data.dictType);
								$("#codeType").val(data.codeType);
							},
							yes: function (layIndex) {
								var oldData = table.cache.participator_dictionary;
								var len = oldData.length;
								data.dictType = $("#dictType").val();
								data.codeType = $("#codeType").val();
								data.codeValue = $("#codeValue").val();
								if (!data.codeValue) {
									layer.alert("字典值(code/id)不能为空");
									return;
								}
								//循环数据，找到更新的数据行，直接更新
								for (var i = 0; i < len; i++) {
									if (i + 1 == data.id) {
										oldData[i] = data;
										break;
									}
								}
								//重新加一下数据
								table.reload('participator_dictionary', {data: oldData});
								layer.msg('修改成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
								layer.close(layIndex);
							}
						});

					}
				}

				/***
				 * 参与者集合-查询集的明细设置
				 * @param table
				 * @param data_tr
				 * @param layer
				 * @param type:新增和修改，new和modify
				 */
				function participatorQueryDetailConfig(table, data_tr, layer, dataSource, type) {
					//“参与者集合->查询集->查询参数集合”表格
					table.render({
						elem: '#queryInner',
						toolbar: '#buttonsToolbarQueryInner',
						even: true,
						loading: true, //width: 705,
						height: 300,
						defaultToolbar: [],
						contentType: "application/x-www-form-urlencoded",
						data: dataSource,
						cols: [[{type: 'checkbox'}, {
							field: 'id', width: 60, title: '编号'
						}, {
							field: 'DataType', title: '查询参数类型', width: 150, templet: function (d) {
								let res = "";
								switch (d.DataType) {
									case "Long":
										res = "长整型";
										break;
									case "Integer":
										res = "整型";
										break;
									case "Varchar":
										res = "字符串";
										break;
									case "Date":
										res = "日期";
										break;
									case "DateTime":
										res = "日期时间";
										break;
									case "Numeric":
										res = "数值类型";
										break;
									case "Double":
										res = "双精度浮点";
										break;
									case "Float":
										res = "单精度浮点";
										break;
									case "Binary":
										res = "二进制";
										break;
									case "Boolean":
										res = "布尔类型";
										break;
									case "Text":
										res = "文本";
										break;
								}
								return res;
							}
						}, {
							field: 'Formula', title: '参数来源公式', width: 310, templet: function (d) {
								return d.Formula.replace(/@br@/g, '\n');
							}
						}, {
							fixed: 'right', title: '操作', width: 113, align: 'center', toolbar: '#lineBtnsBarQueryInner'
						}]], //设置表头
					});

					//监听表格复选框选择
					table.on('checkbox(queryInner)', function (obj) {
						data_tr = $(this);
						//全选时
						if (obj.type == "all") {
							if (obj.checked) {//全选中
								var checkStatus = table.checkStatus('queryInner');
								var sdata = checkStatus.data;
								if (sdata.length > 0) {//渲染背景颜色
									$(".layui-table-body .layui-table tr").each(function () {
										$(this).addClass("tr_bj_color");
									})
								}
							} else {//全部不选
								$(".layui-table-body .layui-table tr").each(function () {
									$(this).removeClass("tr_bj_color");
								})
							}
						} else {//单选
							var checkStatus = table.checkStatus('queryInner');
							var sdata = checkStatus.data;
							if (obj.checked) {//选中
								obj.tr.addClass('tr_bj_color');
							} else {//取消选中
								obj.tr.removeClass('tr_bj_color');
							}
						}
					});

					//监听行工具事件
					//注：tool 是工具条事件名，test 是 table 原始容器的属性 lay-filter="对应的值"
					table.on('tool(queryInner)', function (obj) {
						var data = obj.data //获得当前行数据（json格式的键值对）
							, layEvent = obj.event //获得 lay-event 对应的值（编辑、删除、添加）
							, editList = []; //存放获取到的那条json数据中的value值（不放key）
						$.each(data, function (name, value) {//循环遍历json数据
							editList.push(value);//将json数据中的value放入数组中（下面的子窗口显示的时候要用到）
						});
						if (layEvent === 'edit') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							modiyQueryInner(data);
						} else if (layEvent === 'del') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							layer.confirm('确定删除吗', function (index) {
								obj.del();
								let cbList = table.cache.queryInner;
								let finalList = [];
								for (let i = 0; i < cbList.length; i++) {
									if (cbList[i] && cbList[i].length == 0) {
										continue;
									} else {
										finalList.push(cbList[i]);
									}
								}
								//重新对序号编码
								for (var i = 0; i < cbList.length; i++) {
									cbList[i].id = i+1;
								}
								table.reload("queryInner", {
									data: finalList,
								});
								layer.close(index);
							});
						}
					});

					//头工具栏事件
					table.on('toolbar(queryInner)', function (obj) {
						let layEvent = obj.event;
						if (layEvent === 'addQueryInner') {
							addQueryInner();
						} else if (layEvent === 'delCondition') {
							var checkStatus = table.checkStatus('queryInner');
							if (checkStatus.data.length < 1) {
								layer.alert("请选择一条数据操作");
								return false;
							} else {
								layer.confirm('确定删除吗', function (index) {
									let cbList = table.cache.queryInner;
									for (var k = 0; k < checkStatus.data.length; k++) {
										var _delId = checkStatus.data[k].id;
										for (var i = 0; i < cbList.length; i++) {
											var _id = cbList[i].id;
											if (_id == _delId) {
												cbList.splice(i, 1);
												break;
											}
										}
									}
									//重新对序号编码
									for (var i = 0; i < cbList.length; i++) {
										cbList[i].id = i+1;
									}
									table.reload("queryInner", {
										data: cbList,
									});
									layer.close(index);
								});
							}
						}
					});

					// 新增方法
					function addQueryInner() {
						var addHtml = '<div id="form1" class="layui-form" style="width:600px; margin-top: 20px;">\
                                           <div class="layui-form-item">\
                                             <label class="layui-form-label" \
                                                    style="vertical-align: middle;width:90px;\
                                                           padding: 3px 15px;">查询参数类型</label>\
                                             <div class="layui-input-block">\
                                               <select name="DataType" id="DataType" lay-filter="DataType" \
                                                       style="display:block;height:26px;padding-left: 5px;\
                                                              width:200px;border-color: #D2D2D2!important;">\
                                                    <option value=""></option>\
                                                    <option value="Long">长整型</option>\
                                                    <option value="Integer">整型</option>\
                                                    <option value="Varchar">字符串</option>\
                                                    <option value="Date">日期</option>\
                                                    <option value="DateTime">日期时间</option>\
                                                    <option value="Numeric">数值类型</option>\
                                                    <option value="Double">双精度浮点</option>\
                                                    <option value="Float">单精度浮点</option>\
                                                    <option value="Binary">二进制</option>\
                                                    <option value="Boolean">布尔类型</option>\
                                                    <option value="Text">文本</option>\
                                                   </select>\
                                             </div>\
                                           </div>\
                                           <div class="layui-form-item">\
                                             <label class="layui-form-label" \
                                                    style="white-space: nowrap;width:90px;padding: 3px 15px;">\
                                                    参数来源公式\
                                             </label>\
                                             <div class="layui-input-block">\
                                               <textarea name="Formula" id="Formula" \
                                                         placeholder="请输入参数来源公式" \
                                                         class="layui-textarea" style="resize:none;height: 200px;\
                                                                width: 460px;"></textarea>\
                                             </div>\
                                           </div>\
                                        </div>';

						layer.open({
							type: 1,
							title: '新增',
							content: addHtml,
							area: ['600px', '400px'],
							btn: ['确定', '取消'],
							resize: false,
							move: false,
							yes: function (layIndex) {
								if (!$("#DataType").val()) {
									layer.alert("参数类型不能为空");
									return;
								}
								if (!$("#Formula").val()) {
									layer.alert("参数来源公式不能为空");
									return;
								}

								let maxId = 0;
								var oldData = table.cache.queryInner;//获得当前页面的原始数据
								if (!oldData) {
									oldData = [];
								} else {
									for (var i = 0; i < oldData.length; i++) {
										if (oldData[i].id > maxId) {
											maxId = oldData[i].id;
										}
									}
								}
								oldData.push({
									id: maxId + 1, DataType: $("#DataType").val(), Formula: $("#Formula").val()
								});
								table.reload('queryInner', {data: oldData});//把新处理的数据重新加载一下
								layer.msg('新增成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
								layer.close(layIndex);
							}
						});
					}

					// 编辑方法
					function modiyQueryInner(data) {
						var editHtml = '<div id="form1" class="layui-form" style="width:600px; margin-top: 20px;">\
                                           <div class="layui-form-item">\
                                             <label class="layui-form-label" \
                                                    style="vertical-align: middle;width:90px;padding: 3px 15px;">\
                                                    查询参数类型\
                                             </label>\
                                             <div class="layui-input-block">\
                                               <select name="DataType" id="DataType" lay-filter="DataType" \
                                                       style="display:block;height:26px;padding-left: 5px;width:200px;\
                                                              border-color: #D2D2D2!important;">\
                                                    <option value=""></option>\
                                                    <option value="Long">长整型</option>\
                                                    <option value="Integer">整型</option>\
                                                    <option value="Varchar">字符串</option>\
                                                    <option value="Date">日期</option>\
                                                    <option value="DateTime">日期时间</option>\
                                                    <option value="Numeric">数值类型</option>\
                                                    <option value="Double">双精度浮点</option>\
                                                    <option value="Float">单精度浮点</option>\
                                                    <option value="Binary">二进制</option>\
                                                    <option value="Boolean">布尔类型</option>\
                                                    <option value="Text">文本</option>\
                                                   </select>\
                                             </div>\
                                           </div>\
                                           <div class="layui-form-item">\
                                             <label class="layui-form-label" \
                                                    style="white-space: nowrap;width:90px;padding: 3px 15px;">\
                                                    参数来源公式\
                                             </label>\
                                             <div class="layui-input-block">\
                                               <textarea name="Formula" id="Formula" placeholder="请输入参数来源公式" \
                                                         class="layui-textarea" style="resize:none;height: 200px;\
                                                                width: 460px;">' + data.Formula + '</textarea>\
                                             </div>\
                                           </div>\
                                        </div>';

						layer.open({
							type: 1,
							title: '编辑',
							content: editHtml,
							area: ['600px', '400px'],
							btn: ['确定', '取消'],
							resize: false,
							move: false,
							success: function () {
								// 设置参数类型
								$("#DataType").val(data.DataType);
							},
							yes: function (layIndex) {
								var oldData = table.cache.queryInner;
								var len = oldData.length;
								if (!$("#DataType").val()) {
									layer.alert("参数类型不能为空");
									return;
								}
								if (!$("#Formula").val()) {
									layer.alert("参数来源公式不能为空");
									return;
								}
								data.DataType = $("#DataType").val();
								data.Formula = $("#Formula").val();
								//循环数据，找到更新的数据行，直接更新
								for (var i = 0; i < len; i++) {
									if (i + 1 == data.id) {
										oldData[i] = data;
										break;
									}
								}
								//重新加一下数据
								table.reload('queryInner', {data: oldData});
								layer.msg('修改成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
								layer.close(layIndex);
							}
						});
					}
				}

				/***
				 * 参与者集合-查询集设置
				 * @param table
				 * @param dictionaryData
				 * @param layer
				 */
				function participatorQueryConfig(table, queryData, layer) {
					table.render({
						elem: '#querySql',
						toolbar: '#buttonsToolbarQuerySql',
						even: true,
						loading: true, //width: 705,
						height: 440,
						defaultToolbar: [],
						contentType: "application/x-www-form-urlencoded",
						data: queryData,
						cols: [[{type: 'checkbox'}, {
							field: 'id', width: 60, title: '编号'
						}, {
							field: 'data', title: '查询语句', width: 270, templet: function (d) {
								return d.data.replace(/@br@/g, '\n');
							}
						}, {
							field: 'QueryParameterCollection', title: '查询参数集合', width: 200
						}, {
							fixed: 'right', title: '操作', width: 113, align: 'center', toolbar: '#lineBtnsBarQuerySql'
						}]], //设置表头
					});

					let data_tr;
					//监听表格复选框选择
					table.on('checkbox(querySql)', function (obj) {
						data_tr = $(this);
						//全选时
						if (obj.type == "all") {
							if (obj.checked) {//全选中
								var checkStatus = table.checkStatus('querySql');
								var sdata = checkStatus.data;
								if (sdata.length > 0) {//渲染背景颜色
									$(".layui-table-body .layui-table tr").each(function () {
										$(this).addClass("tr_bj_color");
									})
								}
							} else {//全部不选
								$(".layui-table-body .layui-table tr").each(function () {
									$(this).removeClass("tr_bj_color");
								})
							}
						} else {//单选
							var checkStatus = table.checkStatus('querySql');
							var sdata = checkStatus.data;
							if (obj.checked) {//选中
								obj.tr.addClass('tr_bj_color');
							} else {//取消选中
								obj.tr.removeClass('tr_bj_color');
							}
						}
					});

					//监听行工具事件
					//注：tool 是工具条事件名，test 是 table 原始容器的属性 lay-filter="对应的值"
					table.on('tool(querySql)', function (obj) {
						var data = obj.data //获得当前行数据（json格式的键值对）
							, layEvent = obj.event //获得 lay-event 对应的值（编辑、删除、添加）
							, editList = []; //存放获取到的那条json数据中的value值（不放key）
						$.each(data, function (name, value) {//循环遍历json数据
							editList.push(value);//将json数据中的value放入数组中（下面的子窗口显示的时候要用到）
						});
						if (layEvent === 'edit') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							modifyQuery(data);
						} else if (layEvent === 'del') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							layer.confirm('确定删除吗', function (index) {
								obj.del();
								let cbList = table.cache.querySql;
								let finalList = [];
								for (let i = 0; i < cbList.length; i++) {
									if (cbList[i] && cbList[i].length == 0) {
										continue;
									} else {
										finalList.push(cbList[i]);
									}
								}
								//重新对序号编码
								for (var i = 0; i < cbList.length; i++) {
									cbList[i].id = i+1;
								}
								table.reload("querySql", {
									data: finalList,
								});
								layer.close(index);
							});
						}
					});

					//头工具栏事件
					table.on('toolbar(querySql)', function (obj) {
						let layEvent = obj.event;
						if (layEvent === 'addQuery') {
							addQuery();
						} else if (layEvent === 'delCondition') {
							var checkStatus = table.checkStatus('querySql');
							if (checkStatus.data.length < 1) {
								layer.alert("请选择一条数据操作");
								return false;
							} else {
								layer.confirm('确定删除吗', function (index) {
									let cbList = table.cache.querySql;
									for (var k = 0; k < checkStatus.data.length; k++) {
										var _delId = checkStatus.data[k].id;
										for (var i = 0; i < cbList.length; i++) {
											var _id = cbList[i].id;
											if (_id == _delId) {
												cbList.splice(i, 1);
												break;
											}
										}
									}
									//重新对序号编码
									for (var i = 0; i < cbList.length; i++) {
										cbList[i].id = i+1;
									}
									table.reload("querySql", {
										data: cbList,
									});
									layer.close(index);
								});
							}
						}
					});

					var queryInnerData = [];

					// 新增查询集
					function addQuery() {
						var addHtml = '<div id="form1" class="layui-form" style="width:700px;">\
                               <div class="layui-form-item" style="margin-bottom: 0px;">\
                                 <div><label class="layui-form-label" \
                                             style="width:60px;font-weight:bold;padding:10px;">查询语句</label></div>\
                                 <div class="layui-input-block" style="margin: 5px;">\
                                     <textarea name="querySqlData" id="querySqlData" placeholder="请输入查询语句" \
                                               class="layui-textarea" style="resize:none;height: 150px;"></textarea>\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom:10px;margin-bottom: -5px;">\
                                 <div><label class="layui-form-label" \
                                             style="width:90px;font-weight:bold;padding: 5px;">查询参数集合</label></div>\
                               </div>\
                               <div class="layui-form-item" style="margin-right:5px;">\
                                 <div class="layui-input-block" style="margin-left:5px;">\
                                    <script type="text/html" id="buttonsToolbarQueryInner">\
                                        <div class="layui-btn-container">\
                                            <button class="layui-btn layui-btn-sm layui-btn-primary" \
                                                    style="border-radius: 8px;margin-right:5px;" \
                                                    lay-event="addQueryInner">新增</button>\
                                            <button class="layui-btn layui-btn-sm layui-btn-primary" \
                                                    style="border-radius: 8px;margin-right:5px;" \
                                                    lay-event="delCondition">删除</button>\
                                        </div>\
                                    </script>\
                                    <table id="queryInner" lay-filter="queryInner" class="layui-hide"></table>\
                                    <script type="text/html" id="lineBtnsBarQueryInner">\
                                        <a class="layui-btn layui-btn-normal layui-btn-xs" \
                                           style="border-radius: 5px;margin-left: 0px;" lay-event="edit">编辑</a>\
                                        <a class="layui-btn layui-btn-danger layui-btn-xs" \
                                           style="border-radius: 5px;margin-left: 0px;" lay-event="del">删除</a>\
                                    </script>\
                                 </div>\
                               </div>\
                            </div>';

						layer.open({
							type: 1,
							title: '新增',
							content: addHtml,
							area: ['700px', '650px'],
							btn: ['确定', '取消'],
							resize: false,
							move: false,
							success: function () {
								// 查询集合的明细配置->新增配置
								participatorQueryDetailConfig(table, data_tr, layer, [], "new");
							},
							yes: function (layIndex) {
								if (!$("#querySqlData").val()) {
									layer.alert("查询语句不能为空");
									return;
								}

								let querySqlParams = [];
								// 获取参数数组
								let queryInner = table.cache.queryInner;
								if (queryInner && queryInner.length > 0) {
									let obj = {};
									for (let i = 0; i < queryInner.length; i++) {
										obj["DataType"] = queryInner[i].DataType;
										obj["Formula"] = queryInner[i].Formula;
										obj["id"] = (i + 1);
										querySqlParams.push(obj);
										obj = {};
									}
								}
								// 未设置值，内容为空格
								let finalParams = querySqlParams && querySqlParams.length > 0 ? JSON.stringify(querySqlParams) : " ";

								let maxId = 0;
								var oldData = table.cache.querySql;//获得当前页面的原始数据
								if (!oldData) {
									oldData = [];
								} else {
									for (var i = 0; i < oldData.length; i++) {
										if (oldData[i].id > maxId) {
											maxId = oldData[i].id;
										}
									}
								}

								oldData.push({
									id: maxId + 1, data: $("#querySqlData").val(), QueryParameterCollection: finalParams
								});
								table.reload('querySql', {data: oldData});//把新处理的数据重新加载一下
								layer.msg('新增成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
								layer.close(layIndex);
							},
							btn2: function () {
								layer.closeAll();
							}
						});
					}

					// 编辑查询集
					function modifyQuery(data) {
						var editHtml = '<div id="form1" class="layui-form" style="width:700px;">\
                               <div class="layui-form-item" style="margin-bottom: 0px;">\
                                 <div><label class="layui-form-label" \
                                             style="width:60px;font-weight:bold;padding:10px;">查询语句</label></div>\
                                 <div class="layui-input-block" style="margin: 5px;">\
                                     <textarea name="querySqlData" id="querySqlData" placeholder="请输入查询语句" \
                                               class="layui-textarea" style="resize:none;height: 150px;">' + data.data.replace(/@br@/g, '\n') + '</textarea>\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom:10px;margin-bottom: -5px;">\
                                 <div><label class="layui-form-label" \
                                             style="width:90px;font-weight:bold;padding: 5px;">查询参数集合</label></div>\
                               </div>\
                               <div class="layui-form-item" style="margin-right:5px;">\
                                 <div class="layui-input-block" style="margin-left:5px;">\
                                    <script type="text/html" id="buttonsToolbarQueryInner">\
                                        <div class="layui-btn-container">\
                                            <button class="layui-btn layui-btn-sm layui-btn-primary" \
                                                    style="border-radius: 8px;margin-right:5px;" \
                                                    lay-event="addQueryInner">新增</button>\
                                            <button class="layui-btn layui-btn-sm layui-btn-primary" \
                                                    style="border-radius: 8px;margin-right:5px;" \
                                                    lay-event="delCondition">删除</button>\
                                        </div>\
                                    </script>\
                                    <table id="queryInner" lay-filter="queryInner" class="layui-hide"></table>\
                                    <script type="text/html" id="lineBtnsBarQueryInner">\
                                        <a class="layui-btn layui-btn-normal layui-btn-xs" \
                                           style="border-radius: 5px;margin-left: 0px;" lay-event="edit">编辑</a>\
                                        <a class="layui-btn layui-btn-danger layui-btn-xs" \
                                           style="border-radius: 5px;margin-left: 0px;" lay-event="del">删除</a>\
                                    </script>\
                                 </div>\
                               </div>\
                            </div>';

						queryInnerData = data.QueryParameterCollection;
						if (queryInnerData == " " || !queryInnerData) {
							queryInnerData = [];
						} else {
							if (queryInnerData && typeof (queryInnerData) === "string") {
								queryInnerData = JSON.parse(queryInnerData.replace(/@br@/g, '\\n')
									.replace(/<br>/g, '\\n'));
								if (typeof (queryInnerData) === "string" && queryInnerData.trim()) {
									queryInnerData = JSON.parse(queryInnerData);
								}
							}
						}

						layer.open({
							type: 1,
							title: '编辑',
							content: editHtml,
							area: ['700px', '650px'],
							btn: ['确定', '取消'],
							resize: false,
							move: false,
							success: function () {
								// 查询集合的明细配置->修改配置
								participatorQueryDetailConfig(table, data_tr, layer, queryInnerData, "modify");
							},
							yes: function (layIndex) {
								var oldData = table.cache.querySql;
								var len = oldData.length;
								data.data = $("#querySqlData").val();
								if (!data.data) {
									layer.alert("查询语句不能为空");
									return;
								}

								let querySqlParams = [];
								// 获取参数数组
								let queryInner = table.cache.queryInner;
								if (queryInner && queryInner.length > 0) {
									let obj = {};
									for (let i = 0; i < queryInner.length; i++) {
										obj["DataType"] = queryInner[i].DataType;
										obj["Formula"] = queryInner[i].Formula;
										obj["id"] = (i + 1);
										querySqlParams.push(obj);
										obj = {};
									}
								}
								// 未设置值，内容为空格
								let finalParams = querySqlParams && querySqlParams.length > 0 ? JSON.stringify(querySqlParams) : " ";
								data.QueryParameterCollection = finalParams;

								//循环数据，找到更新的数据行，直接更新
								for (var i = 0; i < len; i++) {
									if (i + 1 == data.id) {
										oldData[i] = data;
										break;
									}
								}
								//重新加一下数据
								table.reload('querySql', {data: oldData});
								layer.msg('修改成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
								layer.close(layIndex);
							},
							btn2: function () {
								layer.closeAll();
							}
						});

					}
				}

				/***
				 * 参与者集合-中间表达式设置
				 * @param table
				 * @param midFormulaData
				 * @param layer
				 */
				function participatorMidFormulaConfig(table, midFormulaData, layer) {
					table.render({
						elem: '#midFormula',
						toolbar: '#buttonsToolbarMidFormula',
						even: true,
						loading: true, //width: 705,
						height: 440,
						defaultToolbar: [],
						contentType: "application/x-www-form-urlencoded",
						data: midFormulaData,
						cols: [[{type: 'checkbox'}, {
							field: 'id', width: 60, title: '编号'
						}, {
							field: 'value', title: '查询参数集合', width: 470, templet: function (d) {
								return d.value.replace(/@br@/g, '\n');
							}
						}, {
							fixed: 'right', title: '操作', width: 113, align: 'center', toolbar: '#lineBtnsBarMidFormula'
						}]], //设置表头
					});

					let data_tr;
					//监听表格复选框选择
					table.on('checkbox(midFormula)', function (obj) {
						data_tr = $(this);
						//全选时
						if (obj.type == "all") {
							if (obj.checked) {//全选中
								var checkStatus = table.checkStatus('midFormula');
								var sdata = checkStatus.data;
								if (sdata.length > 0) {//渲染背景颜色
									$(".layui-table-body .layui-table tr").each(function () {
										$(this).addClass("tr_bj_color");
									})
								}
							} else {//全部不选
								$(".layui-table-body .layui-table tr").each(function () {
									$(this).removeClass("tr_bj_color");
								})
							}
						} else {//单选
							var checkStatus = table.checkStatus('midFormula');
							var sdata = checkStatus.data;
							if (obj.checked) {//选中
								obj.tr.addClass('tr_bj_color');
							} else {//取消选中
								obj.tr.removeClass('tr_bj_color');
							}
						}
					});

					//监听行工具事件
					//注：tool 是工具条事件名，test 是 table 原始容器的属性 lay-filter="对应的值"
					table.on('tool(midFormula)', function (obj) {
						var data = obj.data //获得当前行数据（json格式的键值对）
							, layEvent = obj.event //获得 lay-event 对应的值（编辑、删除、添加）
							, editList = []; //存放获取到的那条json数据中的value值（不放key）
						$.each(data, function (name, value) {//循环遍历json数据
							editList.push(value);//将json数据中的value放入数组中（下面的子窗口显示的时候要用到）
						});
						if (layEvent === 'edit') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							modifyMidFormula(data);
						} else if (layEvent === 'del') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							layer.confirm('确定删除吗', function (index) {
								obj.del();
								let cbList = table.cache.midFormula;
								let finalList = [];
								for (let i = 0; i < cbList.length; i++) {
									if (cbList[i] && cbList[i].length == 0) {
										continue;
									} else {
										finalList.push(cbList[i]);
									}
								}
								//重新对序号编码
								for (var i = 0; i < cbList.length; i++) {
									cbList[i].id = i+1;
								}
								table.reload("midFormula", {
									data: finalList,
								});
								layer.close(index);
							});
						}
					});

					//头工具栏事件
					table.on('toolbar(midFormula)', function (obj) {
						let layEvent = obj.event;
						if (layEvent === 'addDict') {
							addMidFormula();
						} else if (layEvent === 'delCondition') {
							var checkStatus = table.checkStatus('midFormula');
							if (checkStatus.data.length < 1) {
								layer.alert("请选择一条数据操作");
								return false;
							} else {
								layer.confirm('确定删除吗', function (index) {
									let cbList = table.cache.midFormula;
									for (var k = 0; k < checkStatus.data.length; k++) {
										var _delId = checkStatus.data[k].id;
										for (var i = 0; i < cbList.length; i++) {
											var _id = cbList[i].id;
											if (_id == _delId) {
												cbList.splice(i, 1);
												break;
											}
										}
									}
									//重新对序号编码
									for (var i = 0; i < cbList.length; i++) {
										cbList[i].id = i+1;
									}
									table.reload("midFormula", {
										data: cbList,
									});
									layer.close(index);
								});
							}
						}
					});

					function addMidFormula() {
						var addHtml = '<div id="form1" class="layui-form" style="width:500px; margin-top: 5px;">\
                               <div class="layui-form-item">\
                                 <div class="layui-input-block" style="margin: 5px;">\
                                   <textarea name="desc" id="midFormulaCotent" placeholder="请输入内容" \
                                             class="layui-textarea" style="resize:none;height: 280px;"></textarea>\
                                 </div>\
                               </div>\
                            </div>';

						layer.open({
							type: 1,
							title: '新增',
							content: addHtml,
							area: ['500px', '400px'],
							btn: ['确定', '取消'],
							resize: false,
							move: false,
							yes: function (layIndex) {
								if (!$("#midFormulaCotent").val()) {
									layer.alert("内容不能为空");
									return;
								}

								let maxId = 0;
								var oldData = table.cache.midFormula;//获得当前页面的原始数据
								if (!oldData) {
									oldData = [];
								} else {
									for (var i = 0; i < oldData.length; i++) {
										if (oldData[i].id > maxId) {
											maxId = oldData[i].id;
										}
									}
								}
								//在原始数据前添加新添加的数据
								oldData.push({id: maxId + 1, value: $("#midFormulaCotent").val()});
								table.reload('midFormula', {data: oldData});//把新处理的数据重新加载一下
								layer.msg('新增成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
								layer.close(layIndex);
							}
						});
					}

					function modifyMidFormula(data) {
						var editHtml = '<div id="form1" class="layui-form" style="width:500px; margin-top: 5px;">\
                               <div class="layui-form-item">\
                                 <div class="layui-input-block" style="margin: 5px;">\
                                   <textarea name="desc" id="midFormulaCotent" placeholder="请输入内容" \
                                             class="layui-textarea" style="resize:none;height: 280px;">' + data.value.replace(/@br@/g, '\n') + '</textarea>\
                                 </div>\
                               </div>\
                            </div>';

						layer.open({
							type: 1,
							title: '编辑',
							content: editHtml,
							area: ['500px', '400px'],
							btn: ['确定', '取消'],
							resize: false,
							move: false,
							yes: function (layIndex) {
								var oldData = table.cache.midFormula;
								var len = oldData.length;
								data.value = $("#midFormulaCotent").val();
								if (!data.value) {
									layer.alert("内容不能为空");
									return;
								}
								//循环数据，找到更新的数据行，直接更新
								for (var i = 0; i < len; i++) {
									if (i + 1 == data.id) {
										oldData[i] = data;
										break;
									}
								}
								//重新加一下数据
								table.reload('midFormula', {data: oldData});
								layer.msg('修改成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
								layer.close(layIndex);
							}
						});

					}
				}

				/***
				 * 操作集合设置
				 * @param table 表格对象
				 * @param operateCollectionData 操作集合数据
				 * @param layer 提示消息对象
				 */
				function operateCollectionConfig(table, operateCollectionData, layer) {
					table.render({
						elem: '#operateCollection',
						toolbar: '#buttonsToolbarOperateCollection',
						even: true,
						loading: true, //width: 705,
						height: 495,
						defaultToolbar: [],
						contentType: "application/x-www-form-urlencoded",
						data: operateCollectionData,
						cols: [[{type: 'checkbox'}, {
							field: 'id', width: 60, title: '编号'
						}, {
							field: 'Key', title: '操作标识', width: 120
						}, {
							field: 'Caption', title: '操作名称', width: 120
						}, {
							field: 'Enable', title: '可用性', width: 120
						}, {
							field: 'Visible', title: '可见性', width: 80
						}, {
							field: 'Icon', title: '图标', width: 60
						}, {
							field: 'TemplateKey', title: '模板标识', width: 100
						}, {
							field: 'Action', title: '动作', width: 100
						}, {
							fixed: 'right',
							title: '操作',
							width: 113,
							align: 'center',
							toolbar: '#lineBtnsBarOperateCollection'
						}]],
					});

					let data_tr;
					//监听表格复选框选择
					table.on('checkbox(operateCollection)', function (obj) {
						data_tr = $(this);
						//全选时
						if (obj.type == "all") {
							if (obj.checked) {//全选中
								var checkStatus = table.checkStatus('operateCollection');
								var sdata = checkStatus.data;
								if (sdata.length > 0) {//渲染背景颜色
									$(".layui-table-body .layui-table tr").each(function () {
										$(this).addClass("tr_bj_color");
									})
								}
							} else {//全部不选
								$(".layui-table-body .layui-table tr").each(function () {
									$(this).removeClass("tr_bj_color");
								})
							}
						} else {//单选
							var checkStatus = table.checkStatus('operateCollection');
							var sdata = checkStatus.data;
							if (obj.checked) {//选中
								obj.tr.addClass('tr_bj_color');
							} else {//取消选中
								obj.tr.removeClass('tr_bj_color');
							}
						}
					});

					//监听行工具事件
					//注：tool 是工具条事件名，test 是 table 原始容器的属性 lay-filter="对应的值"
					table.on('tool(operateCollection)', function (obj) {
						var data = obj.data //获得当前行数据（json格式的键值对）
							, layEvent = obj.event //获得 lay-event 对应的值（编辑、删除、添加）
							, editList = []; //存放获取到的那条json数据中的value值（不放key）
						$.each(data, function (name, value) {//循环遍历json数据
							editList.push(value);//将json数据中的value放入数组中（下面的子窗口显示的时候要用到）
						});
						if (layEvent === 'edit') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							modify(data);
						} else if (layEvent === 'del') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							layer.confirm('确定删除吗', function (index) {
								obj.del();
								let cbList = table.cache.operateCollection;
								let finalList = [];
								for (let i = 0; i < cbList.length; i++) {
									if (cbList[i] && cbList[i].length == 0) {
										continue;
									} else {
										finalList.push(cbList[i]);
									}
								}
								//重新对序号编码
								for (var i = 0; i < cbList.length; i++) {
									cbList[i].id = i+1;
								}
								table.reload("operateCollection", {
									data: finalList,
								});
								layer.close(index);
							});
						}
					});

					//头工具栏事件
					table.on('toolbar(operateCollection)', function (obj) {
						let layEvent = obj.event;
						if (layEvent === 'add') {
							add();
						} else if (layEvent === 'del') {
							var checkStatus = table.checkStatus('operateCollection');
							if (checkStatus.data.length < 1) {
								layer.alert("请选择一条数据操作");
								return false;
							} else {
								layer.confirm('确定删除吗', function (index) {
									let cbList = table.cache.operateCollection;
									for (var k = 0; k < checkStatus.data.length; k++) {
										var _delId = checkStatus.data[k].id;
										for (var i = 0; i < cbList.length; i++) {
											var _id = cbList[i].id;
											if (_id == _delId) {
												cbList.splice(i, 1);
												break;
											}
										}
									}
									//重新对序号编码
									for (var i = 0; i < cbList.length; i++) {
										cbList[i].id = i+1;
									}
									table.reload("operateCollection", {
										data: cbList,
									});
									layer.close(index);
								});
							}
						}
					});

					function add() {
						var addHtml = '<div id="form1" class="layui-form" \
                                            style="width:600px; margin-top: 5px;overflow: hidden;">\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" style="vertical-align: middle;width:60px;\
                                                                        padding: 3px 15px;">操作标识</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="Key" id="Key" lay-verify="Key" value="" \
                                          autocomplete="off" required placeholder="请输入操作标识" \
                                          class="layui-input" style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;padding: 3px 15px;">操作名称</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="Caption" id="Caption" lay-verify="Caption" value="" \
                                          autocomplete="off" required placeholder="请输入操作名称" \
                                          class="layui-input" style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;padding: 3px 15px;">图标</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="Icon" id="Icon" lay-verify="Icon" value="" \
                                          autocomplete="off" placeholder="请输入图标地址" \
                                          class="layui-input" style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;padding: 3px 15px;">模板标识</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="TemplateKey" id="TemplateKey" \
                                          lay-verify="TemplateKey" value="" autocomplete="off" \
                                          placeholder="请输入模板标识" class="layui-input" \
                                          style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;">可用性</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <textarea name="Enable" id="Enable" placeholder="请输入内容" \
                                             class="layui-textarea" required \
                                             style="resize:none;height: 30px;width: 485px;">ReadOnly()</textarea>\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;">可见性</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <textarea name="Visible" id="Visible" placeholder="请输入内容" \
                                             class="layui-textarea" \
                                             style="resize:none;height: 30px;width: 485px;"></textarea>\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;">动作</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <textarea name="Action" id="Action" placeholder="请输入内容" \
                                             class="layui-textarea" \
                                             style="resize:none;height: 30px;width: 485px;"></textarea>\
                                 </div>\
                               </div>\
                            </div>';

						layer.open({
							type: 1,
							title: '新增',
							content: addHtml,
							area: ['600px', '600px'],
							btn: ['确定', '取消'],
							resize: false,
							move: false,
							success: function () {
								let maxId = 0;
								var oldData = table.cache.operateCollection;//获得当前页面的原始数据
								if (!oldData) {
									oldData = [];
								} else {
									for (var i = 0; i < oldData.length; i++) {
										if (oldData[i].id > maxId) {
											maxId = oldData[i].id;
										}
									}
								}
								if (!oldData || oldData.length == 0) {
									$("#Key").val(yigoflow.config.fileName + "_op1");
									$("#Caption").val("提交");
									$("#Enable").val("ReadOnly()");
									$("#Action").val('CommitWorkitem(-1,1,"")');
								} else {
									$("#Key").val("operation" + maxId);
									$("#Caption").val("operation" + maxId);
									$("#Enable").val("ReadOnly()");
									$("#Action").val("");
								}
							},
							yes: function (layIndex) {
								if (!$("#Key").val()) {
									layer.alert("操作标识不能为空");
									return;
								}
								if (!$("#Caption").val()) {
									layer.alert("可用性不能为空");
									return;
								}
								if (!$("#Enable").val()) {
									layer.alert("可用性不能为空");
									return;
								}

								let maxId = 0;
								var oldData = table.cache.operateCollection;//获得当前页面的原始数据
								if (!oldData) {
									oldData = [];
								} else {
									//循环数据，找到更新的数据行，直接更新
									for (var i = 0; i < oldData.length; i++) {
										if (oldData[i].Key == $("#Key").val()) {
											layer.alert("操作标识已存在");
											return;
										}
									}

									for (var i = 0; i < oldData.length; i++) {
										if (oldData[i].id > maxId) {
											maxId = oldData[i].id;
										}
									}
								}

								let newLineData = {};
								newLineData.id = maxId + 1;

								newLineData.Key = $("#Key").val();
								newLineData.Caption = $("#Caption").val();
								newLineData.Enable = $("#Enable").val();
								newLineData.Visible = $("#Visible").val();
								newLineData.Icon = $("#Icon").val();
								newLineData.TemplateKey = $("#TemplateKey").val();
								newLineData.Action = $("#Action").val();
								oldData.push(newLineData);//在原始数据前添加新添加的数据
								table.reload('operateCollection', {data: oldData});//把新处理的数据重新加载一下
								layer.msg('新增成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
								layer.close(layIndex);
							}
						});
					}

					function modify(data) {
						if (!data.Icon) {
							data.Icon = "";
						}
						if (!data.TemplateKey) {
							data.TemplateKey = "";
						}
						if (!data.Visible) {
							data.Visible = "";
						}
						if (!data.Action) {
							data.Action = "";
						}
						var editHtml = '<div id="form1" class="layui-form" \
                                             style="width:600px; margin-top: 5px;overflow: hidden;">\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;padding: 3px 15px;">操作标识</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="Key" id="Key" lay-verify="Key" \
                                          value="' + data.Key + '" autocomplete="off" required \
                                          placeholder="请输入操作标识" class="layui-input" \
                                          style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;padding: 3px 15px;">操作名称</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="Caption" id="Caption" \
                                          lay-verify="Caption" value="' + data.Caption + '" autocomplete="off" \
                                          required placeholder="请输入操作名称" \
                                          class="layui-input" style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;padding: 3px 15px;">图标</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="Icon" id="Icon" lay-verify="Icon" \
                                          value="' + data.Icon + '" autocomplete="off" placeholder="请输入图标地址" \
                                          class="layui-input" style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;padding: 3px 15px;">模板标识</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="TemplateKey" id="TemplateKey" \
                                          lay-verify="TemplateKey" value="' + data.TemplateKey + '" \
                                          autocomplete="off" placeholder="请输入模板标识" class="layui-input" \
                                          style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;">可用性</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <textarea name="Enable" id="Enable" placeholder="请输入内容" \
                                             class="layui-textarea" required \
                                             style="resize:none;height: 30px;width: 485px;">' + data.Enable.replace(/@br@/g, '\n') + '</textarea>\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;">可见性</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <textarea name="Visible" id="Visible" placeholder="请输入内容" \
                                             class="layui-textarea" \
                                             style="resize:none;height: 30px;width: 485px;">' + data.Visible.replace(/@br@/g, '\n') + '</textarea>\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:60px;">动作</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <textarea name="Action" id="Action" placeholder="请输入内容" \
                                             class="layui-textarea" \
                                             style="resize:none;height: 30px;width: 485px;">' + data.Action.replace(/@br@/g, '\n') + '</textarea>\
                                 </div>\
                               </div>\
                            </div>';

						layer.open({
							type: 1,
							title: '编辑',
							content: editHtml,
							area: ['600px', '600px'],
							btn: ['确定', '取消'],
							resize: false,
							move: false,
							yes: function (layIndex) {
								var oldData = table.cache.operateCollection;
								var len = oldData.length;
								data.Key = $("#Key").val();
								data.Caption = $("#Caption").val();
								data.Enable = $("#Enable").val();
								data.Visible = $("#Visible").val();
								data.Icon = $("#Icon").val();
								data.TemplateKey = $("#TemplateKey").val();
								data.Action = $("#Action").val();
								if (!$("#Key").val()) {
									layer.alert("操作标识不能为空");
									return;
								}
								if (!$("#Caption").val()) {
									layer.alert("可用性不能为空");
									return;
								}
								if (!$("#Enable").val()) {
									layer.alert("可用性不能为空");
									return;
								}

								// 操作标识重复性校验
								for (var i = 0; i < len; i++) {
									if (oldData[i].Key == data.Key && oldData[i].id != data.id) {
										layer.alert("操作标识已存在");
										return;
									}
								}
								//循环数据，找到更新的数据行，直接更新
								for (var i = 0; i < len; i++) {
									if (i + 1 == data.id) {
										oldData[i] = data;
										break;
									}
								}
								//重新加一下数据
								table.reload('operateCollection', {data: oldData});
								layer.msg('修改成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
								layer.close(layIndex);
							}
						});

					}
				}

				/***
				 * 辅助节点设置
				 * @param table 表格对象
				 * @param assistanceCollectionData 辅助节点集合数据
				 * @param layer 提示消息对象
				 */
				function assistanceCollectionConfig(table, assistanceCollectionData, layer) {
					isLockScreen = true;
					table.render({
						elem: '#assistanceCollection',
						toolbar: '#buttonsToolbarAssistanceCollection',
						even: true,
						loading: true,
						width: 799,
						height: 495,
						defaultToolbar: [],
						contentType: "application/x-www-form-urlencoded",
						data: assistanceCollectionData,
						limit: 1000,
						cols: [[{type: 'checkbox'}, {
							field: 'id', width: 60, title: '编号'
						}, {
							field: 'NodeType', title: '节点类型', width: 100, templet: function (d) {
								let nodeTypeDesc = "";
								switch (d.NodeType) {
									case "UserTask":
										nodeTypeDesc = "用户任务";
										break;
									case "Countersign":
										nodeTypeDesc = "会签节点";
										break;
									case "Audit":
										nodeTypeDesc = "审批任务";
										break;
									default:
										break;
								}
								return nodeTypeDesc;
							}
						}, {
							field: 'Key', title: '标识', width: 120
						}, {
							field: 'Caption', title: '名称', width: 150
						}, {
							fixed: 'right',
							title: '操作',
							width: 425,
							align: 'left',
							toolbar: '#lineBtnsBarAssistanceCollection'
						}]],
					});

					let data_tr;
					//监听表格复选框选择
					table.on('checkbox(assistanceCollection)', function (obj) {
						data_tr = $(this);
						//全选时
						if (obj.type == "all") {
							if (obj.checked) {//全选中
								var checkStatus = table.checkStatus('assistanceCollection');
								var sdata = checkStatus.data;
								if (sdata.length > 0) {//渲染背景颜色
									$(".layui-table-body .layui-table tr").each(function () {
										$(this).addClass("tr_bj_color");
									})
								}
							} else {//全部不选
								$(".layui-table-body .layui-table tr").each(function () {
									$(this).removeClass("tr_bj_color");
								})
							}
						} else {//单选
							var checkStatus = table.checkStatus('assistanceCollection');
							var sdata = checkStatus.data;
							if (obj.checked) {//选中
								obj.tr.addClass('tr_bj_color');
							} else {//取消选中
								obj.tr.removeClass('tr_bj_color');
							}
						}
					});

					//监听行工具事件
					//注：tool 是工具条事件名，test 是 table 原始容器的属性 lay-filter="对应的值"
					table.on('tool(assistanceCollection)', function (obj) {
						var data = obj.data //获得当前行数据（json格式的键值对）
							, layEvent = obj.event //获得 lay-event 对应的值（编辑、删除、添加）
							, editList = []; //存放获取到的那条json数据中的value值（不放key）
						$.each(data, function (name, value) {//循环遍历json数据
							editList.push(value);//将json数据中的value放入数组中（下面的子窗口显示的时候要用到）
						});
						if (layEvent === 'permSet') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							modify(data, 'permSet');
						} else if (layEvent === 'operationCollectionSet') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							modify(data, 'operationCollectionSet');
						} else if (layEvent === 'participatorCollectionSet') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							modify(data, 'participatorCollectionSet');
						} else if (layEvent === 'timeSet') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							modify(data, 'timeSet');
						} else if (layEvent === 'otherAttributesSet') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							modify(data, 'otherAttributesSet');
						} else if (layEvent === 'del') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							layer.confirm('确定删除吗', function (index) {
								obj.del();
								let cbList = table.cache.assistanceCollection;
								let finalList = [];
								for (let i = 0; i < cbList.length; i++) {
									if (cbList[i] && cbList[i].length == 0) {
										continue;
									} else {
										finalList.push(cbList[i]);
									}
								}
								//重新对序号编码
								for (var i = 0; i < cbList.length; i++) {
									cbList[i].id = i+1;
								}
								table.reload("assistanceCollection", {
									data: finalList,
								});
								layer.close(index);
							});
						}
					});

					//头工具栏事件
					table.on('toolbar(assistanceCollection)', function (obj) {
						let layEvent = obj.event;
						if (layEvent === 'addUserTask') {
							add('UserTask');
						} else if (layEvent === 'addCountersign') {
							add('Countersign');
						} else if (layEvent === 'addAudit') {
							add('Audit');
						} else if (layEvent === 'del') {
							var checkStatus = table.checkStatus('assistanceCollection');
							if (checkStatus.data.length < 1) {
								layer.alert("请选择一条数据操作");
								return false;
							} else {
								layer.confirm('确定删除吗', function (index) {
									let cbList = table.cache.assistanceCollection;
									for (var k = 0; k < checkStatus.data.length; k++) {
										var _delId = checkStatus.data[k].id;
										for (var i = 0; i < cbList.length; i++) {
											var _id = cbList[i].id;
											if (_id == _delId) {
												cbList.splice(i, 1);
												break;
											}
										}
									}
									//重新对序号编码
									for (var i = 0; i < cbList.length; i++) {
										cbList[i].id = i+1;
									}
									table.reload("assistanceCollection", {
										data: cbList,
									});
									layer.close(index);
								});
							}
						}
					});

					// 新增
					function add(type) {
						let maxId = 0;
						var oldData = table.cache.assistanceCollection;//获得当前页面的原始数据
						if (!oldData) {
							oldData = [];
						} else {
							for (var i = 0; i < oldData.length; i++) {
								if (oldData[i].id > maxId) {
									maxId = oldData[i].id;
								}
							}
						}

						let newLineData = {
							id: 1,
							NodeType: 'Countersign',
							Key: 'task1',
							Caption: 'task1',
							Perm: {VisiblePerm: [], EnablePerm: [], OptPerm: []},
							OperationCollection: [],
							ParticipatorCollection: {},
							TimerItemCollection: [],
							OtherSet: {
								ProcessKey: '',
								TemplateKey: '',
								CreateTrigger: '',
								FinishTrigger: '',
								PassCondition: '',
								ValidCondition: '',
								FinishCondition: '',
								InUse: '',
								AutoIgnoreNoParticipator: '',
								PassType: '',
								ValidType: ''
							}
						};
						newLineData.id = maxId + 1;
						newLineData.NodeType = type;
						newLineData.Key = "task" + (maxId + 1);
						newLineData.Caption = "task" + (maxId + 1);
						oldData.push(newLineData);//在原始数据前添加新添加的数据
						table.reload('assistanceCollection', {data: oldData});//把新处理的数据重新加载一下
						layer.msg('新增成功', {icon: 1, time: 1500});
					}

					// "权限设置"、"操作集合"、"参与者集合"、"超时设置"、"其他属性设置"等配置
					function modify(data, setType) {
						isLockScreen = true;
						let form = layui.form;
						switch (setType) {
							case "permSet":
								var permHtml = '<div id="formPermSet" class="layui-form" \
                                                     style="width:710px;display: block;margin-top:-10px;">\
                                                   <div class="layui-form-item" style="margin-right:5px;">\
                                                     <div class="layui-input-block" style="margin-left:5px;">\
                                                        <table id="permSet" lay-filter="permSet" \
                                                               class="layui-hide"></table>\
                                                     </div>\
                                                   </div>\
                                                </div>';
								layer.open({
									type: 1,
									title: '权限设置',
									scrollbar: false,
									content: permHtml,
									area: ['710px', '650px'],
									btn: ['确定', '取消'],
									resize: false,
									move: false,
									success: function () {
										let permCollection = data.Perm;
										let optArray = permCollection.OptPerm;
										let visibleArray = permCollection.VisiblePerm;
										let enableArray = permCollection.EnablePerm;
										// 权限设置数据源
										let permSetData = [{
											Key: 'root',
											Caption: '',
											VisibleSelect: true,
											EnableSelect: false,
											OptSelect: false
										}, {
											Key: 'status',
											Caption: 'status',
											VisibleSelect: true,
											EnableSelect: false,
											OptSelect: false
										}];
										// 获取数据源
										if (yigoflow.config.props.props["FormKey"].value) {
											$.ajax({
												type: "post",
												url: "/erp/bpmAttributes/getPermListByKey?key=" + yigoflow.config.props.props["FormKey"].value,
												dataType: 'json',
												async: false,//同步执行
												contentType: 'application/json;charset=utf-8',
												data: '',
												success: function (res) {
													if (res) {
														if (res.code == 0) {
															let data = res.data;
															if (data.compPermArray && data.compPermArray.length > 0) {
																permSetData = data.compPermArray;
															}
														} else {
															console.error(res.msg);
														}
													} else {
														console.error("获取权限列表数据失败");
													}
												},
												error: function () {
													console.error("获取权限列表数据失败");
												}
											});
										}
										for (let i = 0; i < permSetData.length; i++) {
											for (let j = 0; j < optArray.length; j++) {
												if (permSetData[i].Key == optArray[j].Key) {
													permSetData[i].OptSelect = true;
													break;
												}
											}
											for (let j = 0; j < visibleArray.length; j++) {
												if (permSetData[i].Key == visibleArray[j].Key) {
													permSetData[i].VisibleSelect = false;
													break;
												}
											}
											for (let j = 0; j < enableArray.length; j++) {
												if (permSetData[i].Key == enableArray[j].Key) {
													permSetData[i].EnableSelect = true;
													break;
												}
											}
										}
										//“参与者集合->查询集->查询参数集合”表格
										table.render({
											elem: '#permSet',
											toolbar: '',
											even: true, //width: 705,
											height: 530,
											limit: 5000,
											defaultToolbar: [],
											contentType: "application/x-www-form-urlencoded",
											data: permSetData,
											cols: [[{type: 'numbers', title: '序号'}, {
												field: 'Key',
												title: '标识',
												width: 150
											}, {field: 'Caption', title: '名称', width: 170}, {
												field: 'VisibleSelect',
												title: '可见性权限',
												width: 111,
												align: 'center',
												templet: function (row) {
													let html = "<input type='checkbox' lay-skin='primary'" + " lay-filter='checkboxVisible' " + "table-index='" + row.LAY_TABLE_INDEX + "' class='checkboxVisible' ";
													if (row.VisibleSelect === true) {
														html += " checked = 'checked' ";
													}
													html += ">";
													return html;
												}
											}, {
												field: 'EnableSelect',
												title: '可用性权限',
												width: 111,
												align: 'center',
												templet: function (row) {
													let html = "<input type='checkbox' lay-skin='primary'" + " lay-filter='checkboxEnable' table-index='" + row.LAY_TABLE_INDEX + "' class='checkboxEnable' ";
													if (row.EnableSelect === true) {
														html += " checked = 'checked' ";
													}
													html += ">";
													return html;
												}
											}, {
												field: 'OptSelect',
												title: '操作权限',
												width: 111,
												align: 'center',
												templet: function (row) {
													let html = "<input type='checkbox' lay-skin='primary' " + "lay-filter='checkboxOpt' table-index='" + row.LAY_TABLE_INDEX + "' class='checkboxOpt' ";
													if (row.OptSelect === true) {
														html += " checked = 'checked' ";
													}
													html += ">";
													return html;
												}
											}]],
											done: function (obj) {
												form.on('checkbox(checkboxVisible)', function (data) {
													let _index = $(data.elem).attr('table-index') || 0;
													if (data.elem.checked) {
														obj.data[_index].VisibleSelect = true;
													} else {
														obj.data[_index].VisibleSelect = false;
													}
												});
												form.on('checkbox(checkboxEnable)', function (data) {
													let _index = $(data.elem).attr('table-index') || 0;
													if (data.elem.checked) {
														obj.data[_index].EnableSelect = true;
													} else {
														obj.data[_index].EnableSelect = false;
													}
												});
												form.on('checkbox(checkboxOpt)', function (data) {
													let _index = $(data.elem).attr('table-index') || 0;
													if (data.elem.checked) {
														obj.data[_index].OptSelect = true;
													} else {
														obj.data[_index].OptSelect = false;
													}
												});
											}
										});
									},
									yes: function (layIndex) {
										let permSetData = table.cache.permSet;
										data.Perm.OptPerm = [];
										data.Perm.VisiblePerm = [];
										data.Perm.EnablePerm = [];
										for (let i = 0; i < permSetData.length; i++) {
											if (permSetData[i].OptSelect) {
												data.Perm.OptPerm.push({Key: permSetData[i].Key});
											}
											if (!permSetData[i].VisibleSelect) {
												data.Perm.VisiblePerm.push({Key: permSetData[i].Key});
											}
											if (permSetData[i].EnableSelect) {
												data.Perm.EnablePerm.push({Key: permSetData[i].Key});
											}
										}

										let oldData = table.cache.assistanceCollection;
										let len = oldData.length;
										//循环数据，找到更新的数据行，直接更新
										for (let i = 0; i < len; i++) {
											if (oldData[i].id == data.id) {
												oldData[i] = data;
												break;
											}
										}
										//重新加一下数据
										table.reload('assistanceCollection', {data: oldData});
										layer.msg('权限设置成功', {icon: 1, time: 1500}, function () {
											layer.close(layIndex);
											isLockScreen = true;
										});
									}
								});
								break;
							case "operationCollectionSet":
								let operateCollectionData = data.OperationCollection ? data.OperationCollection : [];
								if (typeof (operateCollectionData) === "string") {
									operateCollectionData = JSON.parse(operateCollectionData);
								}
								//“操作集合”设置
								operateCollectionConfig(table, operateCollectionData, layer);

								$("#permTabs").hide();
								$("#participatorTabs").hide();
								$("#timerItemCollectionId").hide();
								$("#operationCollectionId").show();
								$("#dmTableId").hide();
								$("#dialog").show();
								// 设置对话框
								$('#dialog').dialog({
									autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
										"确定": function (e) {
											var _thisDiag = $(this);
											// 阻止默认行为，阻止事件冒泡
											e.preventDefault();
											e.stopPropagation();

											// 文件路径
											let filePath = yigoflow.config.filePath;

											let PermValue = "[]";
											if (table.cache.operateCollection && table.cache.operateCollection.length > 0) {
												let operateCollectionTemp = table.cache.operateCollection;
												for (let i = 0; i < operateCollectionTemp.length; i++) {
													if (operateCollectionTemp[i].Action) {
														operateCollectionTemp[i].Action = operateCollectionTemp[i]
															.Action.replace(/[""]/g, "&quot;")
															.replace(/['']/g, "&apos;");
													}
													if (operateCollectionTemp[i].Enable) {
														operateCollectionTemp[i].Enable = operateCollectionTemp[i]
															.Enable.replace(/[""]/g, "&quot;")
															.replace(/['']/g, "&apos;");
													}
													if (operateCollectionTemp[i].Visible) {
														operateCollectionTemp[i].Visible = operateCollectionTemp[i]
															.Visible.replace(/[""]/g, "&quot;")
															.replace(/['']/g, "&apos;");
													}
												}
												PermValue = JSON.stringify(operateCollectionTemp);
											}
											data.OperationCollection = PermValue;

											let oldData = table.cache.assistanceCollection;
											let len = oldData.length;
											//循环数据，找到更新的数据行，直接更新
											for (let i = 0; i < len; i++) {
												if (oldData[i].id == data.id) {
													oldData[i] = data;
													break;
												}
											}
											//重新加一下数据
											table.reload('assistanceCollection', {data: oldData});
											layer.msg('操作集合设置成功', {icon: 1, time: 1500}, function () {
												_thisDiag.dialog("close");
												isLockScreen = true;
											});

										}, "取消": function (e) {
											// 阻止默认行为，阻止事件冒泡
											e.preventDefault();
											e.stopPropagation();
											isLockScreen = true;
											$(this).dialog("close");
										}
									}, close: function () {
										isLockScreen = false;
									}
								});
								break;
							case "participatorCollectionSet":
								let participatorCollection = data.ParticipatorCollection ? data.ParticipatorCollection : {};
								if (participatorCollection && typeof (participatorCollection) === "string") {
									participatorCollection = JSON.parse(participatorCollection);
								}
								let dictionaryData = participatorCollection.Dictionary ? participatorCollection.Dictionary : [];
								let queryData = participatorCollection.Query ? participatorCollection.Query : [];
								let midFormulaData = participatorCollection.MidFormula ? participatorCollection.MidFormula : [];
								// “参与者集合->字典”设置
								participatorDictionaryConfig(table, dictionaryData, layer);

								if (queryData && queryData.length > 0) {
									for (let i = 0; i < queryData.length; i++) {
										if (queryData[i].QueryParameterCollection) {
											queryData[i].QueryParameterCollection = JSON.stringify(queryData[i].QueryParameterCollection);
										}
									}
								}
								//“参与者集合->查询集”设置
								participatorQueryConfig(table, queryData, layer);

								//“参与者集合->中间层表达式”设置
								participatorMidFormulaConfig(table, midFormulaData, layer);

								// Tabs
								$('#participatorTabs').tabs();
								$("#participatorTabs").show();

								$("#permTabs").hide();
								$("#operationCollectionId").hide();
								$("#timerItemCollectionId").hide();
								$("#dmTableId").hide();
								$("#dialog").show();
								// 设置对话框
								$('#dialog').dialog({
									autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
										"确定": function (e) {
											var _thisDiag = $(this);
											// 阻止默认行为，阻止事件冒泡
											e.preventDefault();
											e.stopPropagation();

											let participatorCollection = {};
											participatorCollection.Dictionary = table.cache.participator_dictionary;
											participatorCollection.Query = table.cache.querySql;
											participatorCollection.MidFormula = table.cache.midFormula;

											let PermValue = "";
											if (participatorCollection) {
												PermValue = JSON.stringify(participatorCollection);
											}
											data.ParticipatorCollection = PermValue;

											let oldData = table.cache.assistanceCollection;
											let len = oldData.length;
											//循环数据，找到更新的数据行，直接更新
											for (let i = 0; i < len; i++) {
												if (oldData[i].id == data.id) {
													oldData[i] = data;
													break;
												}
											}
											//重新加一下数据
											table.reload('assistanceCollection', {data: oldData});
											layer.msg('参与者集合设置成功', {icon: 1, time: 1500}, function () {
												_thisDiag.dialog("close");
												isLockScreen = true;
											});

										}, "取消": function (e) {
											// 阻止默认行为，阻止事件冒泡
											e.preventDefault();
											e.stopPropagation();
											isLockScreen = true;
											$(this).dialog("close");
										}
									}, close: function () {
										isLockScreen = false;
									}
								});
								break;
							case "timeSet":
								let timerItemCollectionData = data.TimerItemCollection ? data.TimerItemCollection : [];
								if (typeof (timerItemCollectionData) === "string") {
									timerItemCollectionData = JSON.parse(timerItemCollectionData);
								}
								//“审批超时集合”设置
								timerItemCollectionConfig(table, timerItemCollectionData, layer);

								$("#permTabs").hide();
								$("#participatorTabs").hide();
								$("#operationCollectionId").hide();
								$("#timerItemCollectionId").show();
								$("#dmTableId").hide();
								$("#dialog").show();
								// 设置对话框
								$('#dialog').dialog({
									autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
										"确定": function (e) {
											var _thisDiag = $(this);
											// 阻止默认行为，阻止事件冒泡
											e.preventDefault();
											e.stopPropagation();

											// 文件路径
											let filePath = yigoflow.config.filePath;

											let PermValue = "[]";
											if (table.cache.timerItemCollection && table.cache.timerItemCollection.length > 0) {
												PermValue = JSON.stringify(table.cache.timerItemCollection);
											}
											data.TimerItemCollection = PermValue;

											let oldData = table.cache.assistanceCollection;
											let len = oldData.length;
											//循环数据，找到更新的数据行，直接更新
											for (let i = 0; i < len; i++) {
												if (oldData[i].id == data.id) {
													oldData[i] = data;
													break;
												}
											}
											//重新加一下数据
											table.reload('assistanceCollection', {data: oldData});
											layer.msg('超时设置成功', {icon: 1, time: 1500}, function () {
												_thisDiag.dialog("close");
												isLockScreen = true;
											});

										}, "取消": function (e) {
											// 阻止默认行为，阻止事件冒泡
											e.preventDefault();
											e.stopPropagation();
											isLockScreen = true;
											$(this).dialog("close");
										}
									}, close: function () {
										isLockScreen = false;
									}
								});
								break;
							case "otherAttributesSet":
								var html = '';
								let height = '230px';
								if (data.NodeType == "UserTask" || data.NodeType == "Audit") {
									html = '<div id="form1" class="layui-form" \
                                                 style="width:600px; margin-top: 5px;overflow: hidden;">\
                                               <div class="layui-form-item" \
                                                    style="margin-bottom: 5px;padding-top:10px;">\
                                                 <div class="layui-inline">\
                                                     <label class="layui-form-label" \
                                                            style="text-align:left;vertical-align: middle;\
                                                                   width:100px;padding: 3px 15px;">流程标识</label>\
                                                     <input type="text" name="ProcessKey" id="ProcessKey" \
                                                            lay-verify="ProcessKey" value="' + data.OtherSet.ProcessKey + '" autocomplete="off" required \
                                        placeholder="请输入流程标识" \
                                        class="layui-input" style="height: 26px;width:150px;">\
                                 </div>\
                                 <div class="layui-inline">\
                                     <label class="layui-form-label" \
                                            style="text-align:left;vertical-align: middle;\
                                                   width:100px;padding: 3px 15px;">节点模板标识</label>\
                                     <input type="text" name="TemplateKey" id="TemplateKey" \
                                            lay-verify="TemplateKey" \
                                            value="' + data.OtherSet.TemplateKey + '" autocomplete="off" placeholder="请输入节点模板标识" \
                                  class="layui-input" style="height: 26px;width:150px;">\
                       </div>\
                     </div>\
                     <hr style="margin-left:15px;margin-right: 15px;">\
                     <div class="layui-form-item" \
                          style="margin-bottom: 5px;padding-top:10px;">\
                       <div class="layui-inline">\
                           <label class="layui-form-label" \
                                  style="text-align:left;vertical-align: middle;\
                                         width:100px;padding: 3px 15px;">节点是否启用</label>\
                           <select name="InUse" id="InUse" lay-filter="InUse" \
                                   style="display:block;height:26px;padding-left: 5px;\
                                          width:150px;border-color: #D2D2D2!important;">\
                              <option value="true" selected="selected">是</option>\
                              <option value="false">否</option>\
                           </select>\
                       </div>\
                       <div class="layui-inline">\
                           <label class="layui-form-label" \
                                  style="text-align:left;vertical-align: middle;\
                                         width:100px;padding: 3px 15px;">无参者自动略过</label>\
                           <select name="AutoIgnoreNoParticipator" \
                                   id="AutoIgnoreNoParticipator" \
                                   lay-filter="AutoIgnoreNoParticipator" \
                                   style="display:block;height:26px;padding-left: 5px;\
                                          width:150px;border-color: #D2D2D2!important;">\
                               <option value="true">是</option>\
                               <option value="false" selected="selected">否</option>\
                           </select>\
                       </div>\
                     </div>\
                  </div>';
								} else if (data.NodeType == "Countersign") {
									height = '400px';
									html = '<div id="form1" class="layui-form" \
                                                 style="width:600px; margin-top: 5px;overflow: hidden;">\
                                               <div class="layui-form-item" \
                                                    style="margin-bottom: 5px;padding-top:10px;">\
                                                 <div class="layui-inline">\
                                                     <label class="layui-form-label" \
                                                            style="text-align:left;vertical-align: middle;\
                                                                   width:100px;padding: 3px 15px;">流程标识</label>\
                                                     <input type="text" name="ProcessKey" id="ProcessKey" \
                                                            lay-verify="ProcessKey" \
                                                            value="' + data.OtherSet.ProcessKey + '" a\
                                                            utocomplete="off" required \
                                                            placeholder="请输入流程标识" \
                                                            class="layui-input" style="height: 26px;width:150px;">\
                                                 </div>\
                                                 <div class="layui-inline">\
                                                     <label class="layui-form-label" \
                                                            style="text-align:left;vertical-align: middle;\
                                                                   width:100px;padding: 3px 15px;">节点模板标识</label>\
                                                     <input type="text" name="TemplateKey" id="TemplateKey" \
                                                            lay-verify="TemplateKey" \
                                                            value="' + data.OtherSet.TemplateKey + '" \
                                                            autocomplete="off" placeholder="请输入节点模板标识" \
                                                            class="layui-input" style="height: 26px;width:150px;">\
                                                 </div>\
                                               </div>\
                                               <div class="layui-form-item" \
                                                    style="margin-bottom: 5px;padding-top:10px;">\
                                                    <div class="layui-inline">\
                                                        <label class="layui-form-label" \
                                                               style="text-align:left;vertical-align: middle;\
                                                                      width:100px;padding: 3px 15px;">\
                                                                      工作项创建事件\
                                                        </label>\
                                                        <input type="text" name="CreateTrigger" id="CreateTrigger" \
                                                               lay-verify="CreateTrigger" value="' + data.OtherSet.CreateTrigger + '" \
                                                               autocomplete="off" required \
                                                               placeholder="请输入工作项创建事件" \
                                                               class="layui-input" style="height: 26px;width:150px;">\
                                                    </div>\
                                                    <div class="layui-inline">\
                                                        <label class="layui-form-label" \
                                                               style="text-align:left;vertical-align: middle;\
                                                                      width:100px;padding: 3px 15px;">工作项完成事件\
                                                        </label>\
                                                        <input type="text" name="FinishTrigger" id="FinishTrigger" \
                                                               lay-verify="FinishTrigger" value="' + data.OtherSet.FinishTrigger + '" \
                                                               autocomplete="off" placeholder="请输入工作项完成事件" \
                                                               class="layui-input" style="height: 26px;width:150px;">\
                                                    </div>\
                                               </div>\
                                               <div class="layui-form-item" \
                                                    style="margin-bottom: 5px;padding-top:10px;">\
                                                    <div class="layui-inline">\
                                                        <label class="layui-form-label" \
                                                               style="text-align:left;vertical-align: middle;\
                                                                      width:100px;padding: 3px 15px;">会签通过条件\
                                                        </label>\
                                                        <input type="text" name="PassCondition" id="PassCondition" \
                                                               lay-verify="PassCondition" \
                                                               value="' + data.OtherSet.PassCondition + '" \
                                                               autocomplete="off" required \
                                                               placeholder="请输入会签通过条件" \
                                                               class="layui-input" style="height: 26px;width:150px;">\
                                                    </div>\
                                                    <div class="layui-inline">\
                                                        <label class="layui-form-label" \
                                                               style="text-align:left;vertical-align: middle;\
                                                                     width:100px;padding: 3px 15px;">会签成立条件</label>\
                                                        <input type="text" name="ValidCondition" id="ValidCondition" \
                                                               lay-verify="ValidCondition" \
                                                               value="' + data.OtherSet.ValidCondition + '" \
                                                               autocomplete="off" placeholder="请输入会签成立条件" \
                                                               class="layui-input" style="height: 26px;width:150px;">\
                                                    </div>\
                                               </div>\
                                               <div class="layui-form-item" \
                                                    style="margin-bottom: 5px;padding-top:10px;">\
                                                    <div class="layui-inline">\
                                                        <label class="layui-form-label" \
                                                               style="text-align:left;vertical-align: middle;\
                                                                     width:100px;padding: 3px 15px;">会签完成条件</label>\
                                                        <input type="text" name="FinishCondition" \
                                                               id="FinishCondition" \
                                                               lay-verify="FinishCondition" \
                                                               value="' + data.OtherSet.FinishCondition + '" \
                                                               autocomplete="off" required \
                                                               placeholder="请输入会签完成条件" \
                                                               class="layui-input" style="height: 26px;width:150px;">\
                                                    </div>\
                                               </div>\
                                               <hr style="margin-left:15px;margin-right: 15px;">\
                                               <div class="layui-form-item" \
                                                    style="margin-bottom: 5px;padding-top:10px;">\
                                                 <div class="layui-inline">\
                                                     <label class="layui-form-label" \
                                                            style="text-align:left;vertical-align: middle;\
                                                                  width:100px;padding: 3px 15px;">节点是否启用</label>\
                                                     <select name="InUse" id="InUse" lay-filter="InUse" \
                                                             style="display:block;height:26px;padding-left: 5px;\
                                                                   width:150px;border-color: #D2D2D2!important;">\
                                                        <option value="true" selected="selected">是</option>\
                                                        <option value="false">否</option>\
                                                     </select>\
                                                 </div>\
                                                 <div class="layui-inline">\
                                                     <label class="layui-form-label" \
                                                            style="text-align:left;vertical-align: middle;\
                                                                  width:100px;padding: 3px 15px;">无参者自动略过</label>\
                                                     <select name="AutoIgnoreNoParticipator" \
                                                             id="AutoIgnoreNoParticipator" \
                                                             lay-filter="AutoIgnoreNoParticipator" \
                                                             style="display:block;height:26px;padding-left: 5px;\
                                                                   width:150px;border-color: #D2D2D2!important;">\
                                                         <option value="true">是</option>\
                                                         <option value="false" selected="selected">否</option>\
                                                     </select>\
                                                 </div>\
                                               </div>\
                                               <div class="layui-form-item" \
                                                    style="margin-bottom: 5px;padding-top:10px;">\
                                                    <div class="layui-inline">\
                                                        <label class="layui-form-label" \
                                                               style="text-align:left;vertical-align: middle;\
                                                                     width:100px;padding: 3px 15px;">会签通过类型</label>\
                                                        <select name="PassType" id="PassType" lay-filter="PassType" \
                                                                style="display:block;height:26px;padding-left: 5px;\
                                                                      width:150px;border-color: #D2D2D2!important;">\
                                                            <option value="" selected="selected">无</option>\
                                                            <option value="Number">数量</option>\
                                                            <option value="Proportion">比例</option>\
                                                            <option value="Custom">自定义</option>\
                                                        </select>\
                                                    </div>\
                                                    <div class="layui-inline">\
                                                        <label class="layui-form-label" \
                                                               style="text-align:left;vertical-align: middle;\
                                                                     width:100px;padding: 3px 15px;">会签成立类型</label>\
                                                        <select name="ValidType" id="ValidType" \
                                                                lay-filter="ValidType" \
                                                                style="display:block;height:26px;padding-left: 5px;\
                                                                      width:150px;border-color: #D2D2D2!important;">\
                                                            <option value="" selected="selected">无</option>\
                                                            <option value="Number">数量</option>\
                                                            <option value="Proportion">比例</option>\
                                                            <option value="Custom">自定义</option>\
                                                        </select>\
                                                    </div>\
                                                   </div>\
                                            </div>';
								}

								layer.open({
									type: 1,
									title: '其他属性设置',
									content: html,
									area: ['600px', height],
									btn: ['确定', '取消'],
									resize: false,
									move: false,
									success: function () {
										$("#InUse").val(data.OtherSet.InUse);
										$("#AutoIgnoreNoParticipator").val(data.OtherSet.AutoIgnoreNoParticipator);
										$("#PassType").val(data.OtherSet.PassType);
										$("#ValidType").val(data.OtherSet.ValidType);
									},
									yes: function (layIndex) {
										data.OtherSet.ProcessKey = $("#ProcessKey").val();
										data.OtherSet.TemplateKey = $("#TemplateKey").val();
										data.OtherSet.CreateTrigger = $("#CreateTrigger").val();
										data.OtherSet.FinishTrigger = $("#FinishTrigger").val();
										data.OtherSet.PassCondition = $("#PassCondition").val();
										data.OtherSet.ValidCondition = $("#ValidCondition").val();
										data.OtherSet.FinishCondition = $("#FinishCondition").val();
										data.OtherSet.InUse = $("#InUse").val();
										data.OtherSet.AutoIgnoreNoParticipator = $("#AutoIgnoreNoParticipator").val();
										data.OtherSet.PassType = $("#PassType").val();
										data.OtherSet.ValidType = $("#ValidType").val();

										let oldData = table.cache.assistanceCollection;
										let len = oldData.length;
										//循环数据，找到更新的数据行，直接更新
										for (let i = 0; i < len; i++) {
											if (oldData[i].id == data.id) {
												oldData[i] = data;
												break;
											}
										}
										//重新加一下数据
										table.reload('assistanceCollection', {data: oldData});

										layer.msg('其他属性设置成功', {icon: 1, time: 1500}, function () {
											isLockScreen = true;
										});
										layer.close(layIndex);
									}
								});
								break;
							default:
								break;
						}
					}
				}

				/***
				 * 审批超时合设置
				 * @param table 表格对象
				 * @param timerItemCollectionData 审批超时集合数据
				 * @param layer 提示消息对象
				 */
				function timerItemCollectionConfig(table, timerItemCollectionData, layer) {
					table.render({
						elem: '#timerItemCollection',
						toolbar: '#buttonsToolbarTimerItem',
						even: true,
						loading: true, //width: 705,
						height: 495,
						defaultToolbar: [],
						contentType: "application/x-www-form-urlencoded",
						data: timerItemCollectionData,
						cols: [[{type: 'checkbox'}, {
							field: 'id', width: 60, title: '编号'
						}, {
							field: 'type', title: '超时类型', width: 115
						}, {
							field: 'Key', title: '超时标识', width: 100
						}, {
							field: 'Peroid', title: '时间长度（秒）', width: 130
						}, {
							field: 'CycleInterval', title: '超时循环执行的时间间隔', width: 200
						}, {
							field: 'Suggestion', title: '默认意见', width: 100
						}, {
							fixed: 'right', title: '操作', width: 113, align: 'center', toolbar: '#lineBtnsBarTimerItem'
						}]],
					});

					let data_tr;
					//监听表格复选框选择
					table.on('checkbox(timerItemCollection)', function (obj) {
						data_tr = $(this);
						//全选时
						if (obj.type == "all") {
							if (obj.checked) {//全选中
								var checkStatus = table.checkStatus('timerItemCollection');
								var sdata = checkStatus.data;
								if (sdata.length > 0) {//渲染背景颜色
									$(".layui-table-body .layui-table tr").each(function () {
										$(this).addClass("tr_bj_color");
									})
								}
							} else {//全部不选
								$(".layui-table-body .layui-table tr").each(function () {
									$(this).removeClass("tr_bj_color");
								})
							}
						} else {//单选
							var checkStatus = table.checkStatus('timerItemCollection');
							var sdata = checkStatus.data;
							if (obj.checked) {//选中
								obj.tr.addClass('tr_bj_color');
							} else {//取消选中
								obj.tr.removeClass('tr_bj_color');
							}
						}
					});

					//监听行工具事件
					//注：tool 是工具条事件名，test 是 table 原始容器的属性 lay-filter="对应的值"
					table.on('tool(timerItemCollection)', function (obj) {
						var data = obj.data //获得当前行数据（json格式的键值对）
							, layEvent = obj.event //获得 lay-event 对应的值（编辑、删除、添加）
							, editList = []; //存放获取到的那条json数据中的value值（不放key）
						$.each(data, function (name, value) {//循环遍历json数据
							editList.push(value);//将json数据中的value放入数组中（下面的子窗口显示的时候要用到）
						});
						if (layEvent === 'edit') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							modify(data);
						} else if (layEvent === 'del') {
							if (!data || data.length == 0) {
								layer.alert("没有数据不可编辑");
								return;
							}
							layer.confirm('确定删除吗', function (index) {
								obj.del();
								let cbList = table.cache.timerItemCollection;
								let finalList = [];
								for (let i = 0; i < cbList.length; i++) {
									if (cbList[i] && cbList[i].length == 0) {
										continue;
									} else {
										finalList.push(cbList[i]);
									}
								}
								//重新对序号编码
								for (var i = 0; i < cbList.length; i++) {
									cbList[i].id = i+1;
								}
								table.reload("timerItemCollection", {
									data: finalList,
								});
								layer.close(index);
							});
						}
					});

					//头工具栏事件
					table.on('toolbar(timerItemCollection)', function (obj) {
						let layEvent = obj.event;
						if (layEvent === 'add') {
							add();
						} else if (layEvent === 'del') {
							var checkStatus = table.checkStatus('timerItemCollection');
							if (checkStatus.data.length < 1) {
								layer.alert("请选择一条数据操作");
								return false;
							} else {
								layer.confirm('确定删除吗', function (index) {
									let cbList = table.cache.timerItemCollection;
									for (var k = 0; k < checkStatus.data.length; k++) {
										var _delId = checkStatus.data[k].id;
										for (var i = 0; i < cbList.length; i++) {
											var _id = cbList[i].id;
											if (_id == _delId) {
												cbList.splice(i, 1);
												break;
											}
										}
									}
									//重新对序号编码
									for (var i = 0; i < cbList.length; i++) {
										cbList[i].id = i+1;
									}
									table.reload("timerItemCollection", {
										data: cbList,
									});
									layer.close(index);
								});
							}
						}
					});

					function add() {
						var addHtml = '<div id="form1" class="layui-form" \
                                            style="width:510px; margin-top: 5px;overflow: hidden;">\
                               <div class="layui-form-item" style="margin-bottom: 15px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:160px;padding: 3px 15px;">超时类型</label>\
                                 <select name="type" id="type" lay-filter="type" \
                                         style="display:block;height:26px;padding-left: 5px;width:300px;\
                                               border-color: #D2D2D2!important;">\
                                    <option value="自动通过">自动通过</option>\
                                    <option value="自动驳回">自动驳回</option>\
                                    <option value="循环自动任务">循环自动任务</option>\
                                    <option value="单次自动任务">单次自动任务</option>\
                                 </select>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:160px;padding: 3px 15px;">超时标识</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="Key" id="Key" lay-verify="Key" value="" \
                                          autocomplete="off" required placeholder="请输入超时标识" \
                                          class="layui-input" style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:160px;padding: 3px 15px;">\
                                        时间长度（秒）\
                                 </label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="Peroid" id="Peroid" lay-verify="Peroid" \
                                          value="" autocomplete="off" placeholder="请输入时间长度（秒）" \
                                          class="layui-input" style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:160px;padding: 3px 15px;">\
                                        超时循环执行的时间间隔\
                                 </label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="CycleInterval" id="CycleInterval" \
                                          lay-verify="CycleInterval" value="" autocomplete="off" \
                                          placeholder="请输入超时循环执行的时间间隔" class="layui-input" \
                                          style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:160px;">默认意见</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <textarea name="Suggestion" id="Suggestion" \
                                             placeholder="请输入默认意见" \
                                             class="layui-textarea" required \
                                             style="resize:none;height: 30px;width: 300px;"></textarea>\
                                 </div>\
                               </div>\
                            </div>';

						layer.open({
							type: 1,
							title: '新增',
							content: addHtml,
							area: ['510px', '400px'],
							resize: false,
							move: false,
							btn: ['确定', '取消'],
							success: function () {
								// 用户任务节点|多人任务节点|多人审批节点，超时设置，没有“自动驳回”选项
								if (_props.NodeType.value == "UserTask" || _props.NodeType.value == "MultiUserTask" || _props.NodeType.value == "MultiAudit") {
									$("select[name='type'] option[value='自动驳回']").remove();
								}
								let maxId = 0;
								var oldData = table.cache.timerItemCollection;//获得当前页面的原始数据
								if (oldData && oldData.length > 0) {
									for (var i = 0; i < oldData.length; i++) {
										if (oldData[i].id > maxId) {
											maxId = oldData[i].id;
										}
									}
								}
								$("#Key").val("timer" + (maxId + 1));
							},
							yes: function (layIndex) {
								if (!$("#Key").val()) {
									layer.alert("超时标识不能为空");
									return;
								}

								let maxId = 0;
								var oldData = table.cache.timerItemCollection;//获得当前页面的原始数据
								if (!oldData) {
									oldData = [];
								} else {
									//循环数据，找到更新的数据行，直接更新
									for (var i = 0; i < oldData.length; i++) {
										if (oldData[i].Key == $("#Key").val()) {
											layer.alert("操作标识已存在");
											return;
										}
									}

									for (var i = 0; i < oldData.length; i++) {
										if (oldData[i].id > maxId) {
											maxId = oldData[i].id;
										}
									}
								}

								let newLineData = {};
								newLineData.id = maxId + 1;
								newLineData.type = $("#type").val();
								newLineData.Key = $("#Key").val();
								newLineData.Peroid = $("#Peroid").val();
								newLineData.CycleInterval = $("#CycleInterval").val();
								newLineData.Suggestion = $("#Suggestion").val();
								newLineData.Repeat = newLineData.type == "循环自动任务" ? "true" : "";
								oldData.push(newLineData);//在原始数据前添加新添加的数据
								table.reload('timerItemCollection', {data: oldData});//把新处理的数据重新加载一下
								layer.msg('新增成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
								layer.close(layIndex);
							}
						});
					}

					function modify(data) {
						var editHtml = '<div id="form1" class="layui-form" \
                                             style="width:510px; margin-top: 5px;overflow: hidden;">\
                               <div class="layui-form-item" style="margin-bottom: 15px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:160px;padding: 3px 15px;">超时类型</label>\
                                 <select name="type" id="type" lay-filter="type" \
                                         style="display:block;height:26px;padding-left: 5px;width:\
                                                300px;border-color: #D2D2D2!important;">\
                                    <option value="自动通过">自动通过</option>\
                                    <option value="自动驳回">自动驳回</option>\
                                    <option value="循环自动任务">循环自动任务</option>\
                                    <option value="单次自动任务">单次自动任务</option>\
                                 </select>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:160px;padding: 3px 15px;">超时标识</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="Key" id="Key" lay-verify="Key" value="" \
                                          autocomplete="off" required placeholder="请输入超时标识" \
                                          class="layui-input" style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:160px;padding: 3px 15px;">\
                                        时间长度（秒）\
                                 </label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="Peroid" id="Peroid" lay-verify="Peroid" \
                                          value="" autocomplete="off" placeholder="请输入时间长度（秒）" \
                                          class="layui-input" style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:160px;padding: 3px 15px;">\
                                        超时循环执行的时间间隔\
                                 </label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="CycleInterval" id="CycleInterval" \
                                          lay-verify="CycleInterval" value="" autocomplete="off" \
                                          placeholder="请输入超时循环执行的时间间隔" class="layui-input" \
                                          style="height: 26px;width:300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" \
                                        style="vertical-align: middle;width:160px;">默认意见</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <textarea name="Suggestion" id="Suggestion" \
                                             placeholder="请输入默认意见" class="layui-textarea" required \
                                             style="resize:none;height: 30px;width: 300px;"></textarea>\
                                 </div>\
                               </div>\
                            </div>';

						layer.open({
							type: 1,
							title: '编辑',
							content: editHtml,
							area: ['510px', '400px'],
							btn: ['确定', '取消'],
							resize: false,
							move: false,
							success: function () {
								// 用户任务节点|多人任务节点|多人审批节点，超时设置，没有“自动驳回”选项
								if (_props.NodeType.value == "UserTask" || _props.NodeType.value == "MultiUserTask" || _props.NodeType.value == "MultiAudit") {
									$("select[name='type'] option[value='自动驳回']").remove();
								}
								$("#type").val(data.type);
								$("#Key").val(data.Key);
								$("#Peroid").val(data.Peroid);
								$("#CycleInterval").val(data.CycleInterval);
								$("#Suggestion").val(data.Suggestion);
							},
							yes: function (layIndex) {
								var oldData = table.cache.timerItemCollection;
								var len = oldData.length;

								data.type = $("#type").val();
								data.Key = $("#Key").val();
								data.Peroid = $("#Peroid").val();
								data.CycleInterval = $("#CycleInterval").val();
								data.Suggestion = $("#Suggestion").val();
								data.Repeat = $("#type").val() == "循环自动任务" ? "true" : "";

								// 超时标识重复性校验
								for (var i = 0; i < len; i++) {
									if (oldData[i].Key == data.Key && oldData[i].id != data.id) {
										layer.alert("超时标识已存在");
										return;
									}
								}
								//循环数据，找到更新的数据行，直接更新
								for (var i = 0; i < len; i++) {
									if (i + 1 == data.id) {
										oldData[i] = data;
										break;
									}
								}
								//重新加一下数据
								table.reload('timerItemCollection', {data: oldData});
								layer.msg('修改成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
								layer.close(layIndex);
							}
						});

					}
				}

				///////////////////////////////////////////////////////////////////////////////////////////////////////
				//////////////////////////////////////////字段处理开始///////////////////////////////////////////////////
				//////////////////////////////////////////////////////////////////////////////////////////////////////
				// if：这些字段不可编辑
				if (_k == "NodeType" || _k == "ID" || _k == "Version" || _k == "TargetNodeKey" || _k == "SrcFormKey" || _k == "TgtFormKey"
					|| _k == "sourceCaption" || _k == "sourceFiledType" || _k == "feedbackCaption" || _k == "targetkey" || _k == "targetCaption"
					|| _k == "targetTableKey" || _k == "DataObjectKey" || _k == "TableKey" || _k == "FieldKey" || _k == "FieldCaption" || _k == "sourceKey"
					|| _k == "targetKey" || _k == "TargetFieldKey" || _k == "fieldKey" /*|| _k == "sourceContent"*/) {
					$('<input style="width:100%;border:none;height: 22px;" disabled="disabled"/>')
						.val(props[_k].value).change(function () {
						props[_k].value = $(this).val();
					}).appendTo('#' + _div);
				} else if (_k == "sourcekey") {//字段标识
					$('<input style="width:100%;border:none;height: 22px;"/>')
						.val(props[_k].value).change(function () {
						props[_k].value = $(this).val();
						// 节点及路径属性的数据更新操作
						var oldValue = _gprops[_k].value;
						_gprops[_k].value = props[_k].value;
						// 文件路径
						let filePath = yigoflow.config.filePath;
						let params = {
							operType: 0,
							filePath: filePath,
							content: "{key:'" + _k + "',value:'" + props[_k].value + "'}",
							nodeId: 0
						};
						let nodeName = PanelJudge(idFlag);
						let dataMapParams = {
							operType: 0,
							filePath: filePath,
							content: "{key:'" + _k + "',value:'" + props[_k].value + "',tableKey:'" + yigoflow.config.tableKey + "',Type:'" + sessionStorage.getItem("Type" + yigoflow.config.cacheFileName) + "',fieldKey:'" + yigoflow.config.fieldKey + "',targetField:'" + yigoflow.config.targetKey + "'}",
							nodeId: 0,
							oldValue: oldValue,
							nodeName: nodeName
						}
						ajaxStatus = false;
						//判断是当前操作的是数据映射还是工作流
						if (DataMapOrMigration) {
							ajaxDataMapUpdateXml(dataMapParams);
						} else {
							ajaxUpdateXml(params);
							if (nodeName === 'SourceTableCollection') {
								for (let sourcePropsKey in _sourceProps) {
									var o = _sourceProps[sourcePropsKey]["Definition"];
									var s = o.split("_@_")[1];
									if (s == oldValue) {
										_sourceProps[sourcePropsKey]["Definition"] = o.replace(oldValue, props[_k].value);
									}
								}
							} else if (nodeName === 'TargetTableCollection') {
								for (let targetPropsKey in _targetProps) {
									var o = _targetProps[targetPropsKey]["Definition"];
									var s = o.split("_@_")[1];
									if (s == oldValue) {
										_targetProps[targetPropsKey]["Definition"] = o.replace(oldValue, props[_k].value);
									}
								}
							} else {
								for (let feedPropsKey in _feedbackProps) {
									var o = _feedbackProps[feedPropsKey]["value"]["FeedBack"];
									var s = o.split("_@_")[1];
									if (s == oldValue) {
										_feedbackProps[feedPropsKey]["value"]["FeedBack"] = o.replace(oldValue, props[_k].value);
									}
								}
							}
							let data = getDataMapJson();
							sessionStorage.removeItem("EdgeType" + yigoflow.config.cacheFileName);
							sessionStorage.removeItem(yigoflow.config.cacheFileName);
							sessionStorage.setItem(yigoflow.config.cacheFileName, data);
							setTimeout(function () {
								$("#reload").trigger('click');
							}, 1)
						}


					}).appendTo('#' + _div);
				} else if (_k == "Key") {//表标识//展示关闭不修改
					$('<input style="width:100%;border:none;height: 22px;"disabled="disabled"/>')
						.val(props[_k].value).change(function () {
						props[_k].value = $(this).val();
					}).appendTo('#' + _div);
				} else if (_k == "Condition") {// Condition属性
					// 如果是SequenceFlow的Condition属性，只有当源节点是Audit或MultiAudit，才会显示，并可编辑
					let key = "path" + props["ID"].value;
					if (yigoflow.config.restore.paths[key] && yigoflow.config.restore.paths[key]["props"] && !yigoflow.config.restore.paths[key]["props"]["Condition"]) {
						$("#pCondition").parent("td").parent("tr").hide()
					} else {
						$("#pCondition").parent("td").parent("tr").show();
						$('<input style="width:100%;height: 22px;"/>').val(props[_k].value).change(function () {
							props[_k].value = $(this).val();
							// 节点类型
							let nodeType = props["NodeType"].value;
							// 文件路径
							let filePath = yigoflow.config.filePath;
							// 节点id
							let nodeId = props["Key"].value;
							if (nodeType == "SequenceFlow" || nodeType == "Association" || nodeType == "ExceptionFlow" || nodeType == "path") {
								nodeId = "path" + props["Key"].value;
							}
							//后台 fastjson 识别不了单引号，在前台先进行转换
							if (_k == "Condition") {
								var condition = props[_k].value.replace(/'/g, '"')
							}
							// json数据
							let requestData = getPageDataByNodeId(nodeId, _k, condition);

							// 如果是修改名称，那么图标中间的名称也同时修改
							if (_k == "Caption") {
								$(_r).trigger('textchange', [$(this).val(), _src]);
							}


							let params = {
								operType: 2,//操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
								filePath: filePath, content: requestData, nodeId: nodeId
							};

							// ajax请求后台操作
							ajaxRequest(params, 2, nodeType, nodeId, _r);
							if (ajaxStatus) {
								layer.msg("修改成功", {icon: 1, time: 1500,}, function () {
									isLockScreen = false;
								});
							}
						}).appendTo('#' + _div);
					}
				} else if (_k == "DMTable") {// 迁移表设置
					let dMtableData = [];
					props[_k].value = "";
					if (_gprops && _gprops["DMTable"]) {
						let array = _gprops["DMTable"].value;
						if (array) {
							dMtableData = JSON.parse(array);
							if (null != dMtableData && dMtableData.length > 0) {
								props[_k].value = "已设置";
							} else {
								props[_k].value = "";
							}
						}
					}

					$('<input style="width:100%;height: 22px;" readonly="readonly" placeholder="未设置,请点击进行设置"/>')
						.val(props[_k].value).click(function (e) {
						var table = layui.table;
						var layer = layui.layer;
						var form = layui.form;

						let currentElement = $(this);

						if (_gprops && _gprops["DMTable"]) {
							let array = _gprops["DMTable"].value;
							if (array) {
								dMtableData = JSON.parse(array);
								if (null != dMtableData && dMtableData.length > 0) {
									props[_k].value = "已设置";
								} else {
									props[_k].value = "";
								}
							}
						}

						table.render({
							elem: '#dmTable',
							toolbar: '#buttonsToolbarDmTable',
							even: true,
							loading: true, //width: 705,
							height: 495,
							defaultToolbar: [],
							contentType: "application/x-www-form-urlencoded",
							data: dMtableData,
							limit: 1000,
							cols: [[{type: 'checkbox'}, {
								field: 'id', width: 60, title: '编号'
							}, {
								field: 'Key', title: '迁移字段标识', width: 128
							}, {
								field: 'Caption', title: '迁移字段名称', width: 128
							}, {
								field: 'Type', title: '来源字段类型', width: 120, templet: function (d) {
									return '<select name="Type" ' + 'style="display: block;width:100%;height:38px;padding-left: 5px;' + 'padding-bottom: 10px;margin-top: -5px;padding-top: 7px;' + 'vertical-align: middle;border:hidden;" data-state="' + d.Type + '" data-value="' + d.id + '" >' + '     <option value="Field">字段</option>' + '     <option value="Const">常量</option>' + '</select>';
								}
							}, {
								field: 'Value', title: '来源字段/常量值', width: 220
							}, {
								field: 'Detail', title: '明细', width: 0, hide: true
							},]],
							done: function (res, curr, count) {
								// 类型填充整个单元格
								var tableElem = this.elem.next('.layui-table-view');
								count || tableElem.find('.layui-table-header').css('overflow', 'hidden');
								layui.each(tableElem.find('select[name="Type"]'), function (index, item) {
									var elem = $(item);
									elem.val(elem.attr('data-state')).parents('div.layui-table-cell')
										.css('padding', '0px');

									let curRowData = null;
									let id = elem.attr('data-value');
									for (let i = 0; i < res.data.length; i++) {
										if (res.data[i].id == id) {
											curRowData = res.data[i];
										}
									}

									// 设置"来源字段/常量值"
									fieldSourceSelect(elem, curRowData);

									// 类型change
									elem.change(function () {
										fieldSourceSelect(elem, curRowData);
										// 赋值操作
										let tableData = table.cache["dmTable"];
										if (tableData && tableData.length > 0) {
											for (let i = 0; i < tableData.length; i++) {
												if (tableData[i].id == id) {
													tableData[i].Type = elem.val();
													break;
												}
											}
											table.reload("dmTable", {
												data: tableData,
											});
										}
									});
								});
								form.render();//刷新表单
							}
						});

						/***
						 * 字段来源类型选择
						 * @param elem 组件
						 * @param curRowData 当前行对象
						 */
						function fieldSourceSelect(elem, curRowData) {
							//获取来源字段div
							let valueDiv = elem.parent().parent().parent().find('[data-field="Value"] div');
							valueDiv.empty();
							valueDiv.css('padding', '0px');
							if (elem.val() == "Field") {
								elem.parent().parent().parent().find('[data-field="Value"]').removeAttr("data-edit");
								let select = '<select name="Value" style="display: block;width:100%;height:38px;' + '     padding-left: 5px;padding-bottom: 10px;margin-top: -5px;padding-top: 7px;' + '     vertical-align: middle;border:hidden;" data-value="' + curRowData.id + '">' + '     <option value="">无字段</option>' + '     <option value="OID">OID 对象标识</option>' + '     <option value="SOID">SOID 主对象标识</option>' + '     <option value="POID">POID 父对象标识</option>' + '     <option value="VERID">VERID 对象版本</option>' + '     <option value="DVERID">DVERID 对象明细版本</option>' + '     <option value="BillDate">BillDate 业务日期</option>' + '     <option value="Status">Status 状态</option>' + '     <option value="CreateTime">CreateTime 制单时间</option>' + '     <option value="ModifyTime">ModifyTime 修改时间</option>' + '     <option value="DocumentNumber">DocumentNumber 申请编号</option>' + '     <option value="ClientID">ClientID 集团</option>' + '     <option value="ERPMapCount">ERPMapCount 已映射数量</option>' + '     <option value="Creator">Creator 制单人</option>' + '     <option value="Modifier">Modifier 修改人</option>' + '     <option value="Checker">Checker 审批人</option>' + '     <option value="CheckTime">CheckTime 审批时间</option>' + '     <option value="WorkFlowTypeID">WorkFlowTypeID 流程类型</option>' + '     <option value="Topic">Topic 流程主题</option>' + '     <option value="InstanceID">InstanceID 流程标识</option>' + '     <option value="EmployeeID">EmployeeID 人员</option>' + '     <option value="OrgID">OrgID 组织机构</option>' + '</select>';
								valueDiv.append(select);
								$("select[name='Value'][data-value='" + curRowData.id + "']").val(curRowData.Value)
									.change(function () {
										// 赋值操作
										let tableData = table.cache["dmTable"];
										if (tableData && tableData.length > 0) {
											for (let i = 0; i < tableData.length; i++) {
												if (tableData[i].id == curRowData.id) {
													tableData[i].Value = $(this).val();
													break;
												}
											}
											table.reload("dmTable", {
												data: tableData,
											});
										}
									});
							} else if (elem.val() == "Const") {
								elem.parent().parent().parent().find('[data-field="Value"]').attr("data-edit", "text");
								valueDiv.html(curRowData.Value ? curRowData.Value.replace(/&apos;/g, "'")
									.replace(/&quot;/g, "\"") : "")
									.css("margin-left", "0px").css("padding-left", "10px");
							}
						}

						let data_tr;
						//监听表格复选框选择
						table.on('checkbox(dmTable)', function (obj) {
							data_tr = $(this);
							//全选时
							if (obj.type == "all") {
								if (obj.checked) {//全选中
									var checkStatus = table.checkStatus('dmTable');
									var sdata = checkStatus.data;
									if (sdata.length > 0) {//渲染背景颜色
										$(".layui-table-body .layui-table tr").each(function () {
											$(this).addClass("tr_bj_color");
										})
									}
								} else {//全部不选
									$(".layui-table-body .layui-table tr").each(function () {
										$(this).removeClass("tr_bj_color");
									})
								}
							} else {//单选
								var checkStatus = table.checkStatus('dmTable');
								var sdata = checkStatus.data;
								if (obj.checked) {//选中
									obj.tr.addClass('tr_bj_color');
								} else {//取消选中
									obj.tr.removeClass('tr_bj_color');
								}
							}
						});

						//头工具栏事件
						table.on('toolbar(dmTable)', function (obj) {
							let layEvent = obj.event;
							if (layEvent === 'setDmTable') {
								setDmTableWin();
							} else if (layEvent === 'del') {
								var checkStatus = table.checkStatus('dmTable');
								if (checkStatus.data.length < 1) {
									layer.alert("请选择一条数据操作");
									return false;
								} else {
									layer.confirm('确定删除吗', function (index) {
										let cbList = table.cache.dmTable;
										for (var k = 0; k < checkStatus.data.length; k++) {
											var _delId = checkStatus.data[k].id;
											for (var i = 0; i < cbList.length; i++) {
												var _id = cbList[i].id;
												if (_id == _delId) {
													cbList.splice(i, 1);
													break;
												}
											}
										}
										//重新对序号编码
										for (var i = 0; i < cbList.length; i++) {
											cbList[i].id = i+1;
										}
										table.reload("dmTable", {
											data: cbList,
										});
										layer.close(index);
									});
								}
							}
						});

						// 设置迁移表
						function setDmTableWin() {
							let dmTableDetailData = [];
							let dmTableDetailDataObj = {
								id: 1,
								"Key": "",
								"Caption": "",
								"Type": "",
								"ColumnName": "",
								"DefaultVaue": "",
								"Length": "",
								"Precision": "",
								"Scale": ""
							};
							if (table.cache.dmTable && table.cache.dmTable.length > 0) {
								for (let i = 0; i < table.cache.dmTable.length; i++) {
									dmTableDetailDataObj.id = i + 1;
									dmTableDetailDataObj.Key = table.cache.dmTable[i].Detail.Key;
									dmTableDetailDataObj.Caption = table.cache.dmTable[i].Detail.Caption;
									dmTableDetailDataObj.Type = table.cache.dmTable[i].Detail.Type;
									dmTableDetailDataObj.ColumnName = table.cache.dmTable[i].Detail.ColumnName;
									dmTableDetailDataObj.DefaultVaue = table.cache.dmTable[i].Detail.DefaultVaue
										.replace(/&apos;/g, "'")
										.replace(/&quot;/g, "\"");
									dmTableDetailDataObj.Length = table.cache.dmTable[i].Detail.Length;
									dmTableDetailDataObj.Precision = table.cache.dmTable[i].Detail.Precision;
									dmTableDetailDataObj.Scale = table.cache.dmTable[i].Detail.Scale;
									dmTableDetailData.push(dmTableDetailDataObj);
									dmTableDetailDataObj = {
										id: 1,
										"Key": "",
										"Caption": "",
										"Type": "",
										"ColumnName": "",
										"DefaultVaue": "",
										"Length": "",
										"Precision": "",
										"Scale": ""
									};
								}
							} else {
								dmTableDetailData = [{
									id: 1,
									"Key": "",
									"Caption": "",
									"Type": "",
									"ColumnName": "",
									"DefaultVaue": "",
									"Length": "",
									"Precision": "",
									"Scale": ""
								}];
							}

							table.render({
								elem: '#dmTableDetail',
								toolbar: '#buttonsToolbarDmTableDetail',
								even: true,
								loading: true, //width: 705,
								height: 495,
								defaultToolbar: [],
								contentType: "application/x-www-form-urlencoded",
								data: dmTableDetailData,
								limit: 1000,
								cols: [[{type: 'checkbox'}, {
									field: 'id', width: 60, title: '编号'
								}, {
									field: 'Key', title: '列标识', width: 120, edit: true
								}, {
									field: 'Caption', title: '列名称', width: 120, edit: true
								}, {
									field: 'Type', title: '列类型', width: 120, templet: function (d) {
										return '<select name="TypeDetail" lay-filter="TypeDetailSelect" ' + '     style="display: block;width:100%;height:38px;' + '            padding-left: 5px;padding-bottom: 10px;' + '            margin-top: -5px;padding-top: 7px;' + '            vertical-align: middle;border:hidden;" ' + '     data-state="' + d.Type + '" data-value="' + d.id + '" >' + '     <option value=""></option>' + '     <option value="long">长整型</option>' + '     <option value="int">整型</option>' + '     <option value="varchar">字符串</option>' + '     <option value="date">日期</option>' + '     <option value="dateTime">日期时间</option>' + '     <option value="number">数值类型</option>' + '     <option value="text">文本</option>' + '</select>';
									}
								}, {
									field: 'ColumnName', title: '数据表列名', width: 120, edit: true
								}, {
									field: 'DefaultVaue', title: '默认值', width: 120, edit: true
								}, {
									field: 'Length', title: '字符长度', width: 120
								}, {
									field: 'Precision', title: '数值精度', width: 120
								}, {
									field: 'Scale', title: '小数位数', width: 120
								}]],
								done: function (res, curr, count) {
									var tableElem = this.elem.next('.layui-table-view');
									count || tableElem.find('.layui-table-header').css('overflow', 'hidden');
									layui.each(tableElem.find('select[name="TypeDetail"]'), function (index, item) {
										var elem = $(item);
										elem.val(elem.attr('data-state')).parents('div.layui-table-cell')
											.css('padding', '0px');

										let curRowData = null;
										let id = elem.attr('data-value');
										for (let i = 0; i < res.data.length; i++) {
											if (res.data[i].id == id) {
												curRowData = res.data[i];
											}
										}

										setRelatedAttributes(elem, curRowData);
										// Type change事件
										elem.change(function () {
											let Type = $(this).val();
											elem.val(Type);
											setRelatedAttributes(elem, curRowData);
											// 更新到表格中
											let tableData = table.cache["dmTableDetail"];
											if (tableData && tableData.length > 0) {
												for (let i = 0; i < tableData.length; i++) {
													if (tableData[i].id == curRowData.id) {
														tableData[i].Type = Type;
														break;
													}
												}
												table.reload("dmTableDetail", {
													data: tableData,
												});
											}
										});
									});
									form.render();//刷新表单
								}
							});

							/***
							 * 设置类型关联属性的值
							 * @param elem 类型下拉框
							 * @param curRowData 当前行对象
							 */
							function setRelatedAttributes(elem, curRowData) {
								let valueDiv = null;
								elem.parent().parent().parent().find('[data-field="Length"]').removeAttr("data-edit");
								elem.parent().parent().parent().find('[data-field="Precision"]').removeAttr("data-edit");
								elem.parent().parent().parent().find('[data-field="scale"]').removeAttr("data-edit");
								valueDiv = elem.parent().parent().parent().find('[data-field="Length"] div');
								valueDiv.html("");
								valueDiv = elem.parent().parent().parent().find('[data-field="Precision"] div');
								valueDiv.html("");
								valueDiv = elem.parent().parent().parent().find('[data-field="Scale"] div');
								valueDiv.html("");

								switch (curRowData.Type) {
									case "varchar":
										valueDiv = elem.parent().parent().parent().find('[data-field="Length"] div');
										elem.parent().parent().parent().find('[data-field="Length"]')
											.attr("data-edit", "text");
										valueDiv.html(!curRowData.Length ? 255 : curRowData.Length);
										break;
									case "number":
										valueDiv = elem.parent().parent().parent()
											.find('[data-field="Precision"] div');
										elem.parent().parent().parent().find('[data-field="Precision"]')
											.attr("data-edit", "text");
										valueDiv.html(!curRowData.Precision ? 16 : curRowData.Precision);
										valueDiv = elem.parent().parent().parent().find('[data-field="Scale"] div');
										elem.parent().parent().parent().find('[data-field="Scale"]')
											.attr("data-edit", "text");
										valueDiv.html(!curRowData.Scale ? 2 : curRowData.scale);
										break;
									default:
										break;
								}

							}

							// 编辑表格
							table.on('edit(dmTableDetail)', function (obj) {
								var field = obj.field
								var value = obj.value //得到修改后的值
								var data = obj.data //得到所在行所有键值

								if (field == "Key") {
									let cbList = table.cache.dmTableDetail;
									if (cbList && cbList.length > 0) {
										for (let i = 0; i < cbList.length; i++) {
											if (value == cbList[i].Key && data.id != cbList[i].id) {
												layer.alert("该列标识'" + value + "'已存在，不能重复添加");
												break;
											}
										}
									}
								}
							});

							let data_tr;
							//监听表格复选框选择
							table.on('checkbox(dmTableDetail)', function (obj) {
								data_tr = $(this);
								//全选时
								if (obj.type == "all") {
									if (obj.checked) {//全选中
										var checkStatus = table.checkStatus('dmTableDetail');
										var sdata = checkStatus.data;
										if (sdata.length > 0) {//渲染背景颜色
											$(".layui-table-body .layui-table tr").each(function () {
												$(this).addClass("tr_bj_color");
											})
										}
									} else {//全部不选
										$(".layui-table-body .layui-table tr").each(function () {
											$(this).removeClass("tr_bj_color");
										})
									}
								} else {//单选
									var checkStatus = table.checkStatus('dmTableDetail');
									var sdata = checkStatus.data;
									if (obj.checked) {//选中
										obj.tr.addClass('tr_bj_color');
									} else {//取消选中
										obj.tr.removeClass('tr_bj_color');
									}
								}
							});

							//头工具栏事件
							table.on('toolbar(dmTableDetail)', function (obj) {
								let layEvent = obj.event;
								if (layEvent === 'add') {
									add();
								} else if (layEvent === 'del') {
									var checkStatus = table.checkStatus('dmTableDetail');
									if (checkStatus.data.length < 1) {
										layer.alert("请选择一条数据操作");
										return false;
									} else {
										layer.confirm('确定删除吗', function (index) {
											let cbList = table.cache.dmTableDetail;
											for (var k = 0; k < checkStatus.data.length; k++) {
												var _delId = checkStatus.data[k].id;
												for (var i = 0; i < cbList.length; i++) {
													var _id = cbList[i].id;
													if (_id == _delId) {
														cbList.splice(i, 1);
														break;
													}
												}
											}
											//重新对序号编码
											for (var i = 0; i < cbList.length; i++) {
												cbList[i].id = i+1;
											}
											table.reload("dmTableDetail", {
												data: cbList,
											});
											layer.close(index);
										});
									}
								}
							});

							// 新增一条记录
							function add() {
								let maxId = 0;
								var oldData = table.cache.dmTableDetail;//获得当前页面的原始数据
								if (!oldData) {
									oldData = [];
								} else {
									for (var i = 0; i < oldData.length; i++) {
										if (oldData[i].id > maxId) {
											maxId = oldData[i].id;
										}
									}
								}

								let newLineData = {};
								newLineData.id = maxId + 1;
								newLineData.Key = "";
								newLineData.Caption = "";
								newLineData.Type = "";
								newLineData.ColumnName = "";
								newLineData.DefaultVaue = '';
								newLineData.Length = '';
								newLineData.Precision = '';
								newLineData.scale = '';
								oldData.push(newLineData);//在原始数据前添加新添加的数据
								table.reload('dmTableDetail', {data: oldData});//把新处理的数据重新加载一下
								layer.msg('新增成功', {icon: 1, time: 1500}, function () {
									isLockScreen = false;
								});
							}

							// 显示对话框
							$("#dmTableDetailId").show();
							$("#dialogDetail").show();
							// 设置对话框
							$('#dialogDetail').dialog({
								autoOpen: true, width: 800, height: 600, modal: true, resizable: false, buttons: {
									"确定": function (e) {
										var _thisDiag = $(this);
										// 阻止默认行为，阻止事件冒泡
										e.preventDefault();
										e.stopPropagation();

										// 将数据写回主窗口中
										let dmTableData = [];
										let dmTableDataObj = {};
										let dmTableDetail = table.cache.dmTableDetail;
										let dmTableOld = table.cache.dmTable;
										if (dmTableDetail && dmTableDetail.length > 0) {
											for (let i = 0; i < dmTableDetail.length; i++) {
												dmTableDataObj.id = i + 1;
												dmTableDataObj.Key = dmTableDetail[i].Key;
												dmTableDataObj.Caption = dmTableDetail[i].Caption;
												if (dmTableOld && dmTableOld.length > 0) {
													for (let j = 0; j < dmTableOld.length; j++) {
														if (dmTableOld[j].Key == dmTableDetail[i].Key) {
															dmTableDataObj.Type = dmTableOld[j].Type;
															dmTableDataObj.Value = dmTableOld[j].Value;
															break;
														}
													}
												}
												if (!dmTableDataObj.Type) {
													dmTableDataObj.Type = "Field";
												}
												if (!dmTableDataObj.Value) {
													dmTableDataObj.Value = "";
												}
												dmTableDataObj.Detail = {
													"Key": "",
													"Caption": "",
													"Type": "",
													"ColumnName": "",
													"DefaultVaue": "",
													"Length": "",
													"Precision": "",
													"Scale": ""
												};
												dmTableDataObj.Detail.Key = dmTableDetail[i].Key;
												dmTableDataObj.Detail.Caption = dmTableDetail[i].Caption;
												dmTableDataObj.Detail.Type = dmTableDetail[i].Type;
												dmTableDataObj.Detail.ColumnName = dmTableDetail[i].ColumnName;
												dmTableDataObj.Detail.DefaultVaue = dmTableDetail[i].DefaultVaue ? dmTableDetail[i].DefaultVaue
													.replace(/'/g, "&apos;")
													.replace(/"/g, "&quot;") : "";
												dmTableDataObj.Detail.Length = dmTableDetail[i].Length;
												dmTableDataObj.Detail.Precision = dmTableDetail[i].Precision;
												dmTableDataObj.Detail.Scale = dmTableDetail[i].Scale;
												dmTableData.push(dmTableDataObj);
												dmTableDataObj = {};
											}
										}
										// 更新到主表
										table.reload("dmTable", {
											data: dmTableData,
										});
										layer.msg('设置成功', {icon: 1, time: 1500}, function () {
											_thisDiag.dialog("close");
										});
									}, "取消": function (e) {
										// 阻止默认行为，阻止事件冒泡
										e.preventDefault();
										e.stopPropagation();
										$(this).dialog("close");
									}
								}, close: function (e) {
									e.preventDefault();
									e.stopPropagation();
								}
							});

						}

						// Tabs
						$('#permTabs').tabs();
						$("#permTabs").hide();
						$("#participatorTabs").hide();
						$("#operationCollectionId").hide();
						$("#timerItemCollectionId").hide();
						$("#dmTableDetailId").hide();
						$("#dmTableId").show();
						$("#dialog").show();
						// 设置对话框
						$('#dialog').dialog({
							autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
								"确定": function (e) {
									var _thisDiag = $(this);
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();

									// Perm对应的value
									let PermValue = {};
									var dmTable = table.cache.dmTable;
									PermValue = dmTable;
									// 清空Perm输入框中的值
									if (!PermValue) {
										currentElement.val("");
										PermValue = "";
									} else {
										for (let i = 0; i < dmTable.length; i++) {
											if (dmTable[i].Type == "Const" && dmTable[i].Value) {
												dmTable[i].Value = dmTable[i].Value.replace(/'/g, "&apos;")
													.replace(/"/g, "&quot;");
											}
										}
										PermValue = JSON.stringify(dmTable);
									}

									// ajax提交到后台处理
									_gprops[_k].value = PermValue;

									// 文件路径
									let filePath = yigoflow.config.filePath;
									let params = {
										operType: 0,
										filePath: filePath,
										content: "{key:'" + _k + "',value:'" + PermValue + "'}",
										nodeId: 0
									};

									ajaxStatus = false;
									ajaxUpdateXml(params);
									if (ajaxStatus) {
										_thisDiag.dialog("close");
										if ((!dmTable || dmTable.length == 0)) {
											currentElement.val("");
										} else {
											currentElement.val("已设置");
										}
										// 更新一下sessionStorage
										let data = getPageData();
										// 更新缓存中的内容
										sessionStorage.removeItem(yigoflow.config.cacheFileName);
										sessionStorage.setItem(yigoflow.config.cacheFileName, data);
										isLockScreen = false;
									}
								}, "取消": function (e) {
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();
									isLockScreen = false;
									$(this).dialog("close");
								}
							}, close: function (e) {
								e.preventDefault();
								e.stopPropagation();
								isLockScreen = false;
							}
						});

					}).appendTo('#' + _div);
				} else if (_k == "PermCollection") {// 流程属性权限设置
					let OptPermArray, VisiblePermArray, EnablePermArray;
					if (_gprops && _gprops["PermCollection"]) {
						let PermCollection = _gprops["PermCollection"].value;
						if (PermCollection && PermCollection != "null" && typeof (PermCollection) == 'string' && PermCollection != "{}") {
							PermCollection = JSON.parse(PermCollection);
							OptPermArray = PermCollection.OptPerm;
							VisiblePermArray = PermCollection.VisiblePerm;
							EnablePermArray = PermCollection.EnablePerm;
						}
					}

					if (OptPermArray && OptPermArray.length > 0 || VisiblePermArray && VisiblePermArray.length > 0 || EnablePermArray && EnablePermArray.length > 0) {
						props[_k].value = "已设置";
					} else {
						props[_k].value = "";
					}

					$('<input style="width:100%;height: 22px;" readonly="readonly" placeholder="未设置,请点击进行设置"/>')
						.val(props[_k].value).click(function (e) {
						// 当前元素
						var currentElement = $(this);
						// 定义操作、组件、表格权限的相关变量
						let operPermArrayData = [], compPermArrayData = [], gridPermArrayData = [], OptPermArray,
							VisiblePermArray, EnablePermArray;
						// 存储动态表格数组
						let dynamicTableNameArray = [];
						let table = layui.table, layer = layui.layer, form = layui.form;

						// 阻止默认行为，阻止事件冒泡
						e.preventDefault();
						e.stopPropagation();

						if (_gprops && _gprops["PermCollection"]) {
							let PermCollection = _gprops["PermCollection"].value;
							if (PermCollection && typeof (PermCollection) == 'string' && PermCollection != "{}") {
								PermCollection = JSON.parse(PermCollection);
								OptPermArray = PermCollection.OptPerm;
								VisiblePermArray = PermCollection.VisiblePerm;
								EnablePermArray = PermCollection.EnablePerm;
							}
						}

						if (OptPermArray && OptPermArray.length > 0 || VisiblePermArray && VisiblePermArray.length > 0 || EnablePermArray && EnablePermArray.length > 0) {
							currentElement.val("已设置");
						} else {
							currentElement.val("");
						}

						// 重置权限tab选项卡
						let permTab = '<div id="permTabs" style="position:absolute;border-radius:3px;' + '     display: none;width: 99%;left: 1px;top: 1px;margin-right: 2px;' + '     padding-right: 2px;margin-bottom: 0px;">' + '  <ul>' + '      <li><a href="#tabs-1">操作权限</a></li>' + '      <li><a href="#tabs-2">组件权限</a></li>' + '  </ul>' + '  <div id="tabs-1" class="layui-form"  ' + '       style="position:absolute;height:450px;padding:0px;left:0px;' + '              padding-bottom: 15px;overflow:hidden;margin-top: -5px;">' + '      <table class="layui-hide" lay-filter="optTable" id="optTable"></table>' + '  </div>' + '  <div id="tabs-2" class="layui-form"  ' + '       style="position:absolute;height:450px;padding:0px;left:0px;' + '              padding-bottom: 15px;overflow:hidden;margin-top: -5px;">' + '      <table class="layui-hide" lay-filter="compTable" id="compTable"></table>' + '  </div>' + '</div>';
						$("#permTabs").remove();
						$("#dialog").append(permTab);

						if (props["FormKey"].value) {
							$.ajax({
								type: "post",
								url: "/erp/bpmAttributes/getPermListByKey?key=" + props["FormKey"].value,
								dataType: 'json',
								async: false,//同步执行
								contentType: 'application/json;charset=utf-8',
								data: '',
								success: function (res) {
									if (res) {
										if (res.code == 0) {
											let data = res.data;
											if (data.operPermArray && data.operPermArray.length > 0) {
												operPermArrayData = data.operPermArray;
											}
											if (data.compPermArray && data.compPermArray.length > 0) {
												compPermArrayData = data.compPermArray;
											}
											if (data.gridPermArray && data.gridPermArray.length > 0) {
												gridPermArrayData = data.gridPermArray;
											}
										} else {
											console.error(res.msg);
										}
									} else {
										console.error("获取权限列表数据失败");
									}
								},
								error: function () {
									console.error("获取权限列表数据失败");
								}
							});
						}

						// 设置已经设置的操作权限
						if (OptPermArray && OptPermArray.length > 0 && operPermArrayData && operPermArrayData.length > 0) {
							for (let i = 0; i < operPermArrayData.length; i++) {
								for (let j = 0; j < OptPermArray.length; j++) {
									if (operPermArrayData[i].Key == OptPermArray[j].Key) {
										operPermArrayData[i].OptSelect = true;
										break;
									}
								}
							}
						}

						// 设置已经设置的组件权限
						if (compPermArrayData && compPermArrayData.length > 0) {
							for (let i = 0; i < compPermArrayData.length; i++) {
								if (null != VisiblePermArray && VisiblePermArray.length > 0) {
									for (let j = 0; j < VisiblePermArray.length; j++) {
										if (compPermArrayData[i].Key == VisiblePermArray[j].Key) {
											compPermArrayData[i].VisibleSelect = false;
											break;
										}
									}
								}
								if (null != EnablePermArray && EnablePermArray.length > 0) {
									for (let j = 0; j < EnablePermArray.length; j++) {
										if (compPermArrayData[i].Key == EnablePermArray[j].Key) {
											compPermArrayData[i].EnableSelect = true;
											break;
										}
									}
								}
							}
						}

						// 设置已经设置的表格权限
						if (gridPermArrayData && gridPermArrayData.length > 0 && EnablePermArray && EnablePermArray.length > 0) {
							for (let i = 0; i < gridPermArrayData.length; i++) {
								let GridDataArray = gridPermArrayData[i].GridDataArray;
								if (GridDataArray && GridDataArray.length > 0) {
									for (let k = 0; k < GridDataArray.length; k++) {
										for (let j = 0; j < EnablePermArray.length; j++) {
											if (gridPermArrayData[i].GridDataArray[k].Key == EnablePermArray[j].Key) {
												gridPermArrayData[i].GridDataArray[k].EnableSelect = true;
												break;
											}
										}
									}
								}
							}
						}

						// 动态增加表格tab
						if (gridPermArrayData && gridPermArrayData.length > 0) {
							for (let i = 0; i < gridPermArrayData.length; i++) {
								let id = "tabs-" + (2 + i + 1);
								let tableName = gridPermArrayData[i].GridName;
								dynamicTableNameArray.push(tableName);
								let tab = '<div id="' + id + '" class="layui-form"  ' + 'style="position:absolute;height:450px;padding:0px;left:0px;' + 'padding-bottom: 15px;overflow:hidden;margin-top:-5px;">';
								tab += '<table class="layui-hide" lay-filter="' + tableName + '" id="' + tableName + '"></table>';
								tab += '</div>';

								// 不存在表格标签就新增；否则不新增
								let isExist = false;
								$('#permTabs').find("ul").find("li").each(function () {
									if ($(this).attr("id") == "li" + id) {
										isExist = true;
									}
								});
								if (!isExist) {
									$('#permTabs').find("ul").append('<li id="li' + id + '"><a href="#' + id + '">' + tableName + '表格权限</a></li>');
									$('#permTabs').append(tab);
								}

								let gridData = gridPermArrayData[i].GridDataArray;
								let limit = 0;
								if (!gridData || gridData.length == 0) {
									gridData = [];
								} else {
									limit = gridPermArrayData[i].GridDataArray.length;
								}

								table.render({
									elem: '#' + tableName,
									data: gridData,
									width: 709,
									height: 430,
									cellMinWidth: 80,
									even: true,
									limit: limit,
									cols: [[{type: 'numbers', title: '序号'}, {
										field: 'Key',
										title: '标识',
										width: 275
									}, {field: 'Caption', title: '名称', width: 275}, {
										field: 'EnableSelect',
										title: '可用性权限',
										width: 111,
										align: 'center',
										templet: function (row) {
											let html = "<input type='checkbox' lay-skin='primary' " + "lay-filter='" + tableName + "_checkboxEnabled' " + "table-index='" + row.LAY_TABLE_INDEX + "' class='" + tableName + "_checkboxEnabled' ";
											if (row.EnableSelect === true) {
												html += " checked = 'checked' ";
											}
											html += ">";
											return html;
										}
									}]],
									done: function (obj) {
										layer.closeAll();
										form.on('checkbox(' + tableName + '_checkboxEnabled)', function (data) {
											let _index = $(data.elem).attr('table-index') || 0;
											if (data.elem.checked) {
												obj.data[_index].EnableSelect = true;
											} else {
												obj.data[_index].EnableSelect = false;
											}
										});
									}
								});
							}
						}

						table.render({
							elem: '#optTable',
							data: operPermArrayData,
							width: 709,
							height: 430,
							cellMinWidth: 80,
							even: true,
							limit: operPermArrayData.length,
							cols: [[{type: 'numbers', title: '序号'}, {
								field: 'Key',
								title: '标识',
								width: 275
							}, {field: 'Caption', title: '名称', width: 275}, {
								field: 'OptSelect',
								title: '操作权限',
								width: 111,
								align: 'center',
								templet: function (row) {
									let html = "<input type='checkbox' lay-skin='primary' " + "lay-filter='checkboxOpt' table-index='" + row.LAY_TABLE_INDEX + "' class='checkboxOpt' ";
									if (row.OptSelect === true) {
										html += " checked = 'checked' ";
									}
									html += ">";
									return html;
								}
							}]],
							done: function (obj) {
								form.on('checkbox(checkboxOpt)', function (data) {
									let _index = $(data.elem).attr('table-index') || 0;
									if (data.elem.checked) {
										obj.data[_index].OptSelect = true;
									} else {
										obj.data[_index].OptSelect = false;
									}
								});
							}
						});

						table.render({
							elem: '#compTable',
							data: compPermArrayData,
							width: 709,
							height: 430,
							cellMinWidth: 80,
							even: true,
							limit: compPermArrayData.length,
							cols: [[{type: 'numbers', title: '序号'}, {
								field: 'Key',
								title: '标识',
								width: 218
							}, {field: 'Caption', title: '名称', width: 218}, {
								field: 'VisibleSelect',
								title: '可见性权限',
								width: 111,
								align: 'center',
								templet: function (row) {
									let html = "<input type='checkbox' lay-skin='primary' " + "lay-filter='checkboxVisible' table-index='" + row.LAY_TABLE_INDEX + "' class='checkboxVisible' ";
									if (row.VisibleSelect === true) {
										html += " checked = 'checked' ";
									}
									html += ">";
									return html;
								}
							}, {
								field: 'EnableSelect',
								title: '可用性权限',
								width: 111,
								align: 'center',
								templet: function (row) {
									let html = "<input type='checkbox' lay-skin='primary' " + "lay-filter='checkboxEnable' table-index='" + row.LAY_TABLE_INDEX + "' class='checkboxEnable' ";
									if (row.EnableSelect === true) {
										html += " checked = 'checked' ";
									}
									html += ">";
									return html;
								}
							}]],
							done: function (obj) {
								layer.closeAll();
								form.on('checkbox(checkboxVisible)', function (data) {
									let _index = $(data.elem).attr('table-index') || 0;
									if (data.elem.checked) {
										obj.data[_index].VisibleSelect = true;
									} else {
										obj.data[_index].VisibleSelect = false;
									}
								});
								form.on('checkbox(checkboxEnable)', function (data) {
									let _index = $(data.elem).attr('table-index') || 0;
									if (data.elem.checked) {
										obj.data[_index].EnableSelect = true;
									} else {
										obj.data[_index].EnableSelect = false;
									}
								});
							}
						});

						// Tabs
						$('#permTabs').tabs();
						$("#permTabs").show();
						$("#participatorTabs").hide();
						$("#operationCollectionId").hide();
						$("#timerItemCollectionId").hide();
						$("#dmTableId").hide();
						$("#dialog").show();
						// 设置对话框
						$('#dialog').dialog({
							autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
								"确定": function (e) {
									var _thisDiag = $(this);
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();

									var selectedOpt = table.cache.optTable;
									var selectedComp = table.cache.compTable;

									/*Perm:{VisiblePerm:[{Key:'ToolBar1'},{Key:'Inner_Status'}],
                                        EnablePerm:[{Key:'ToolBar1'},{Key:'Inner_Status'}],
                                        OptPerm:[{Key:'ToolBar1'},{Key:'Inner_Status'}]
                                    }*/
									// Perm对应的value
									let PermValue = {};
									let OptPerm = [];
									if (selectedOpt && selectedOpt.length > 0) {
										let optPermObj = {};
										for (let i = 0; i < selectedOpt.length; i++) {
											if (selectedOpt[i].OptSelect) {
												optPermObj.Key = selectedOpt[i].Key;
												OptPerm.push(optPermObj);
												optPermObj = {};
											}
										}
										PermValue.OptPerm = OptPerm;
									}

									let VisiblePerm = [];
									let EnablePerm = [];
									// 设置可见性和可用性
									if (selectedComp && selectedComp.length > 0) {
										let visiblePermObj = {};
										let enablePermObj = {};
										for (let i = 0; i < selectedComp.length; i++) {
											if (!selectedComp[i].VisibleSelect) {
												visiblePermObj.Key = selectedComp[i].Key;
												VisiblePerm.push(visiblePermObj);
												visiblePermObj = {};
											}
											if (selectedComp[i].EnableSelect) {
												enablePermObj.Key = selectedComp[i].Key;
												EnablePerm.push(enablePermObj);
												enablePermObj = {};
											}
										}
										PermValue.VisiblePerm = VisiblePerm;
										PermValue.EnablePerm = EnablePerm;
									}

									// 设置表格权限
									if (dynamicTableNameArray && dynamicTableNameArray.length > 0) {
										for (let i = 0; i < dynamicTableNameArray.length; i++) {
											let selectedGrid = table.cache[dynamicTableNameArray[i]];
											if (selectedGrid && selectedGrid.length > 0) {
												for (let j = 0; j < selectedGrid.length; j++) {
													let enablePermObj = {};
													if (selectedGrid[j].EnableSelect) {
														enablePermObj.Key = selectedGrid[j].Key;
														PermValue.EnablePerm.push(enablePermObj);
														enablePermObj = {};
													}
												}
											}
										}
									}

									// 清空Perm输入框中的值
									if (!PermValue) {
										currentElement.val("");
										PermValue = "";
									} else {
										PermValue = JSON.stringify(PermValue);
									}

									// ajax提交到后台处理
									_gprops[_k].value = PermValue;

									// 文件路径
									let filePath = yigoflow.config.filePath;
									let params = {
										operType: 0,
										filePath: filePath,
										content: "{key:'" + _k + "',value:'" + PermValue + "'}",
										nodeId: 0
									};
									ajaxStatus = false;
									ajaxUpdateXml(params);

									setTimeout(function () {
										_thisDiag.dialog("close");
										if ((!OptPerm || OptPerm.length == 0) && (!VisiblePerm || VisiblePerm.length == 0) && (!EnablePerm || EnablePerm.length == 0)) {
											currentElement.val("");
										} else {
											currentElement.val("已设置");
										}
										// 更新一下sessionStorage
										let data = getPageData();
										// 更新缓存中的内容
										sessionStorage.removeItem(yigoflow.config.cacheFileName);
										sessionStorage.setItem(yigoflow.config.cacheFileName, data);
										isLockScreen = false;
									}, 200);

								}, "取消": function (e) {
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();
									isLockScreen = false;
									$(this).dialog("close");
								}
							}, close: function () {
								isLockScreen = false;
							}
						});

					}).appendTo('#' + _div);
				} else if (_k == "Perm") {// 节点属性权限设置
					// 节点类型
					var nodeType = props["NodeType"].value;
					// 节点id
					var nodeId = props["Key"].value;
					if (nodeType == "SequenceFlow" || nodeType == "Association" || nodeType == "ExceptionFlow" || nodeType == "path") {
						nodeId = "path" + props["Key"].value;
					}

					let OptPermArray, VisiblePermArray, EnablePermArray;
					if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId]["props"] && yigoflow.config.restore.states[nodeId]["props"]["Perm"]) {
						let Perm = yigoflow.config.restore.states[nodeId]["props"]["Perm"].value;
						if (Perm && typeof (Perm) == 'string' && Perm != "{}") {
							Perm = JSON.parse(Perm);
						}
						OptPermArray = Perm.OptPerm;
						VisiblePermArray = Perm.VisiblePerm;
						EnablePermArray = Perm.EnablePerm;
					}

					// 设置已经设置的操作权限
					if (null != OptPermArray && OptPermArray.length > 0) {
						for (let i = 0; i < operPermArray.length; i++) {
							for (let j = 0; j < OptPermArray.length; j++) {
								if (operPermArray[i].Key == OptPermArray[j].Key) {
									operPermArray[i].OptSelect = true;
									break;
								}
							}
						}
					}

					// 设置已经设置的组件权限
					for (let i = 0; i < compPermArray.length; i++) {
						if (null != VisiblePermArray && VisiblePermArray.length > 0) {
							for (let j = 0; j < VisiblePermArray.length; j++) {
								if (compPermArray[i].Key == VisiblePermArray[j].Key) {
									compPermArray[i].VisibleSelect = false;
									break;
								}
							}
						}
						if (null != EnablePermArray && EnablePermArray.length > 0) {
							for (let j = 0; j < EnablePermArray.length; j++) {
								if (compPermArray[i].Key == EnablePermArray[j].Key) {
									compPermArray[i].EnableSelect = true;
									break;
								}
							}
						}
					}

					if (OptPermArray && OptPermArray.length > 0 || VisiblePermArray && VisiblePermArray.length > 0 || EnablePermArray && EnablePermArray.length > 0) {
						props[_k].value = "已设置";
					} else {
						props[_k].value = "";
					}

					$('<input style="width:100%;height: 22px;" readonly="readonly" placeholder="未设置,请点击进行设置"/>')
						.val(props[_k].value).click(function (e) {
						// 设置网格不可单击，锁住当前属性窗口
						isLockScreen = true;
						props[_k].value = $(this).val();
						// 当前元素
						var currentElement = $(this);
						// 定义操作、组件、表格权限的相关变量
						let operPermArrayData = [], compPermArrayData = [], gridPermArrayData = [], OptPermArray,
							VisiblePermArray, EnablePermArray;
						// 存储动态表格数组
						let dynamicTableNameArray = [];
						let table = layui.table, layer = layui.layer, form = layui.form;

						// 阻止默认行为，阻止事件冒泡
						e.preventDefault();
						e.stopPropagation();
						if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId]["props"] && yigoflow.config.restore.states[nodeId]["props"]["Perm"]) {
							let Perm = yigoflow.config.restore.states[nodeId]["props"]["Perm"].value;
							if (Perm && typeof (Perm) == 'string') {
								Perm = JSON.parse(Perm);
							}
							OptPermArray = Perm.OptPerm;
							VisiblePermArray = Perm.VisiblePerm;
							EnablePermArray = Perm.EnablePerm;
						}

						if (OptPermArray && OptPermArray.length > 0 || VisiblePermArray && VisiblePermArray.length > 0 || EnablePermArray && EnablePermArray.length > 0) {
							currentElement.val("已设置");
						} else {
							currentElement.val("");
						}

						// 重置权限tab选项卡
						let permTab = '<div id="permTabs" style="position:absolute;border-radius:3px;' + '     display: none;width: 99%;left: 1px;top: 1px;margin-right: 2px;' + '     padding-right: 2px;margin-bottom: 0px;">' + '  <ul>' + '      <li><a href="#tabs-1">操作权限</a></li>' + '      <li><a href="#tabs-2">组件权限</a></li>' + '  </ul>' + '  <div id="tabs-1" class="layui-form"  ' + '       style="position:absolute;height:450px;padding:0px;left:0px;' + '              padding-bottom: 15px;overflow:hidden;margin-top: -5px;">' + '      <table class="layui-hide" lay-filter="optTable" id="optTable"></table>' + '  </div>' + '  <div id="tabs-2" class="layui-form"  ' + '       style="position:absolute;height:450px;padding:0px;left:0px;' + '              padding-bottom: 15px;overflow:hidden;margin-top: -5px;">' + '      <table class="layui-hide" lay-filter="compTable" id="compTable"></table>' + '  </div>' + '</div>';
						$("#permTabs").remove();
						$("#dialog").append(permTab);

						if (yigoflow.config.props.props["FormKey"].value) {
							$.ajax({
								type: "post",
								url: "/erp/bpmAttributes/getPermListByKey?key=" + yigoflow.config.props.props["FormKey"].value,
								dataType: 'json',
								async: false,//同步执行
								contentType: 'application/json;charset=utf-8',
								data: '',
								success: function (res) {
									if (res) {
										if (res.code == 0) {
											let data = res.data;
											if (data.operPermArray && data.operPermArray.length > 0) {
												operPermArrayData = data.operPermArray;
											}
											if (data.compPermArray && data.compPermArray.length > 0) {
												compPermArrayData = data.compPermArray;
											}
											if (data.gridPermArray && data.gridPermArray.length > 0) {
												gridPermArrayData = data.gridPermArray;
											}
										} else {
											console.error(res.msg);
										}
									} else {
										console.error("获取权限列表数据失败");
									}
								},
								error: function () {
									console.error("获取权限列表数据失败");
								}
							});
						}

						// 设置已经设置的操作权限
						if (OptPermArray && OptPermArray.length > 0 && operPermArrayData && operPermArrayData.length > 0) {
							for (let i = 0; i < operPermArrayData.length; i++) {
								for (let j = 0; j < OptPermArray.length; j++) {
									if (operPermArrayData[i].Key == OptPermArray[j].Key) {
										operPermArrayData[i].OptSelect = true;
										break;
									}
								}
							}
						}

						// 设置已经设置的组件权限
						if (compPermArrayData && compPermArrayData.length > 0) {
							for (let i = 0; i < compPermArrayData.length; i++) {
								if (null != VisiblePermArray && VisiblePermArray.length > 0) {
									for (let j = 0; j < VisiblePermArray.length; j++) {
										if (compPermArrayData[i].Key == VisiblePermArray[j].Key) {
											compPermArrayData[i].VisibleSelect = false;
											break;
										}
									}
								}
								if (null != EnablePermArray && EnablePermArray.length > 0) {
									for (let j = 0; j < EnablePermArray.length; j++) {
										if (compPermArrayData[i].Key == EnablePermArray[j].Key) {
											compPermArrayData[i].EnableSelect = true;
											break;
										}
									}
								}
							}
						}

						// 设置已经设置的表格权限
						if (gridPermArrayData && gridPermArrayData.length > 0 && EnablePermArray && EnablePermArray.length > 0) {
							for (let i = 0; i < gridPermArrayData.length; i++) {
								let GridDataArray = gridPermArrayData[i].GridDataArray;
								if (GridDataArray && GridDataArray.length > 0) {
									for (let k = 0; k < GridDataArray.length; k++) {
										for (let j = 0; j < EnablePermArray.length; j++) {
											if (gridPermArrayData[i].GridDataArray[k].Key == EnablePermArray[j].Key) {
												gridPermArrayData[i].GridDataArray[k].EnableSelect = true;
												break;
											}
										}
									}
								}
							}
						}

						// 动态增加表格tab
						if (gridPermArrayData && gridPermArrayData.length > 0) {
							for (let i = 0; i < gridPermArrayData.length; i++) {
								let id = "tabs-" + (2 + i + 1);
								let tableName = gridPermArrayData[i].GridName;
								dynamicTableNameArray.push(tableName);
								let tab = '<div id="' + id + '" class="layui-form"  ' + 'style="position:absolute;height:450px;padding:0px;left:0px;' + 'padding-bottom: 15px;overflow:hidden;margin-top:-5px;">';
								tab += '<table class="layui-hide" lay-filter="' + tableName + '" id="' + tableName + '"></table>';
								tab += '</div>';

								// 不存在表格标签就新增；否则不新增
								let isExist = false;
								$('#permTabs').find("ul").find("li").each(function () {
									if ($(this).attr("id") == "li" + id) {
										isExist = true;
									}
								});
								if (!isExist) {
									$('#permTabs').find("ul").append('<li id="li' + id + '"><a href="#' + id + '">' + tableName + '表格权限</a></li>');
									$('#permTabs').append(tab);
								}

								let gridData = gridPermArrayData[i].GridDataArray;
								let limit = 0;
								if (!gridData || gridData.length == 0) {
									gridData = [];
								} else {
									limit = gridPermArrayData[i].GridDataArray.length;
								}

								table.render({
									elem: '#' + tableName,
									data: gridData,
									width: 709,
									height: 430,
									cellMinWidth: 80,
									even: true,
									limit: limit,
									cols: [[{type: 'numbers', title: '序号'}, {
										field: 'Key',
										title: '标识',
										width: 275
									}, {field: 'Caption', title: '名称', width: 275}, {
										field: 'EnableSelect',
										title: '可用性权限',
										width: 111,
										align: 'center',
										templet: function (row) {
											let html = "<input type='checkbox' lay-skin='primary' " + "lay-filter='" + tableName + "_checkboxEnabled' " + "table-index='" + row.LAY_TABLE_INDEX + "' class='" + tableName + "_checkboxEnabled' ";
											if (row.EnableSelect === true) {
												html += " checked = 'checked' ";
											}
											html += ">";
											return html;
										}
									}]],
									done: function (obj) {
										layer.closeAll();
										form.on('checkbox(' + tableName + '_checkboxEnabled)', function (data) {
											let _index = $(data.elem).attr('table-index') || 0;
											if (data.elem.checked) {
												obj.data[_index].EnableSelect = true;
											} else {
												obj.data[_index].EnableSelect = false;
											}
										});
									}
								});
							}
						}

						table.render({
							elem: '#optTable',
							data: operPermArrayData,
							width: 709,
							height: 430,
							cellMinWidth: 80,
							even: true,
							limit: operPermArrayData.length,
							cols: [[{type: 'numbers', title: '序号'}, {
								field: 'Key',
								title: '标识',
								width: 275
							}, {field: 'Caption', title: '名称', width: 275}, {
								field: 'OptSelect',
								title: '操作权限',
								width: 111,
								align: 'center',
								templet: function (row) {
									let html = "<input type='checkbox' lay-skin='primary' " + "lay-filter='checkboxOpt' table-index='" + row.LAY_TABLE_INDEX + "' class='checkboxOpt' ";
									if (row.OptSelect === true) {
										html += " checked = 'checked' ";
									}
									html += ">";
									return html;
								}
							}]],
							done: function (obj) {
								form.on('checkbox(checkboxOpt)', function (data) {
									let _index = $(data.elem).attr('table-index') || 0;
									if (data.elem.checked) {
										obj.data[_index].OptSelect = true;
									} else {
										obj.data[_index].OptSelect = false;
									}
								});
							}
						});

						table.render({
							elem: '#compTable',
							data: compPermArrayData,
							width: 709,
							height: 430,
							cellMinWidth: 80,
							even: true,
							limit: compPermArrayData.length,
							cols: [[{type: 'numbers', title: '序号'}, {
								field: 'Key',
								title: '标识',
								width: 218
							}, {field: 'Caption', title: '名称', width: 218}, {
								field: 'VisibleSelect',
								title: '可见性权限',
								width: 111,
								align: 'center',
								templet: function (row) {
									let html = "<input type='checkbox' lay-skin='primary' " + "lay-filter='checkboxVisible' table-index='" + row.LAY_TABLE_INDEX + "' class='checkboxVisible' ";
									if (row.VisibleSelect === true) {
										html += " checked = 'checked' ";
									}
									html += ">";
									return html;
								}
							}, {
								field: 'EnableSelect',
								title: '可用性权限',
								width: 111,
								align: 'center',
								templet: function (row) {
									let html = "<input type='checkbox' lay-skin='primary' " + "lay-filter='checkboxEnable' table-index='" + row.LAY_TABLE_INDEX + "' class='checkboxEnable' ";
									if (row.EnableSelect === true) {
										html += " checked = 'checked' ";
									}
									html += ">";
									return html;
								}
							}]],
							done: function (obj) {
								layer.closeAll();
								form.on('checkbox(checkboxVisible)', function (data) {
									let _index = $(data.elem).attr('table-index') || 0;
									if (data.elem.checked) {
										obj.data[_index].VisibleSelect = true;
									} else {
										obj.data[_index].VisibleSelect = false;
									}
								});
								form.on('checkbox(checkboxEnable)', function (data) {
									let _index = $(data.elem).attr('table-index') || 0;
									if (data.elem.checked) {
										obj.data[_index].EnableSelect = true;
									} else {
										obj.data[_index].EnableSelect = false;
									}
								});
							}
						});

						// Tabs
						$('#permTabs').tabs();
						$("#permTabs").show();
						$("#participatorTabs").hide();
						$("#operationCollectionId").hide();
						$("#timerItemCollectionId").hide();
						$("#dmTableId").hide();
						$("#dialog").show();
						// 设置对话框
						$('#dialog').dialog({
							autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
								"确定": function (e) {
									var _thisDiag = $(this);
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();

									var selectedOpt = table.cache.optTable;
									var selectedComp = table.cache.compTable;

									/*Perm:{VisiblePerm:[{Key:'ToolBar1'},{Key:'Inner_Status'}],
                                        EnablePerm:[{Key:'ToolBar1'},{Key:'Inner_Status'}],
                                        OptPerm:[{Key:'ToolBar1'},{Key:'Inner_Status'}]
                                    }*/
									// Perm对应的value
									let PermValue = {};
									let OptPerm = [];
									if (selectedOpt && selectedOpt.length > 0) {
										let optPermObj = {};
										for (let i = 0; i < selectedOpt.length; i++) {
											if (selectedOpt[i].OptSelect) {
												optPermObj.Key = selectedOpt[i].Key;
												OptPerm.push(optPermObj);
												optPermObj = {};
											}
										}
										PermValue.OptPerm = OptPerm;
									}

									let VisiblePerm = [];
									let EnablePerm = [];
									// 设置可见性和可用性
									if (selectedComp && selectedComp.length > 0) {
										let visiblePermObj = {};
										let enablePermObj = {};
										for (let i = 0; i < selectedComp.length; i++) {
											if (!selectedComp[i].VisibleSelect) {
												visiblePermObj.Key = selectedComp[i].Key;
												VisiblePerm.push(visiblePermObj);
												visiblePermObj = {};
											}
											if (selectedComp[i].EnableSelect) {
												enablePermObj.Key = selectedComp[i].Key;
												EnablePerm.push(enablePermObj);
												enablePermObj = {};
											}
										}
										PermValue.VisiblePerm = VisiblePerm;
										PermValue.EnablePerm = EnablePerm;
									}

									// 设置表格权限
									if (dynamicTableNameArray && dynamicTableNameArray.length > 0) {
										for (let i = 0; i < dynamicTableNameArray.length; i++) {
											let selectedGrid = table.cache[dynamicTableNameArray[i]];
											if (selectedGrid && selectedGrid.length > 0) {
												for (let j = 0; j < selectedGrid.length; j++) {
													let enablePermObj = {};
													if (selectedGrid[j].EnableSelect) {
														enablePermObj.Key = selectedGrid[j].Key;
														PermValue.EnablePerm.push(enablePermObj);
														enablePermObj = {};
													}
												}
											}
										}
									}

									// 清空Perm输入框中的值
									if (!PermValue) {
										currentElement.val("");
									} else {
										PermValue = JSON.stringify(PermValue);
									}

									// ajax提交到后台处理
									// 节点及路径属性的数据更新操作
									if (nodeType) {
										// 文件路径
										let filePath = yigoflow.config.filePath;

										// json数据
										let requestData = getPageDataByNodeId(nodeId, _k, PermValue);

										let params = {
											operType: 2,//操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
											filePath: filePath, content: requestData, nodeId: nodeId
										};

										// ajax请求后台操作
										ajaxRequest(params, 2, nodeType, nodeId, _r);

									} else {
										_gprops[_k].value = PermValue;

										// 文件路径
										let filePath = yigoflow.config.filePath;
										let params = {
											operType: 0,
											filePath: filePath,
											content: "{key:'" + _k + "',value:'" + PermValue + "'}",
											nodeId: 0
										};
										ajaxStatus = false;
										ajaxUpdateXml(params);
									}

									setTimeout(function () {
										_thisDiag.dialog("close");
										if ((!OptPerm || OptPerm.length == 0) && (!VisiblePerm || VisiblePerm.length == 0) && (!EnablePerm || EnablePerm.length == 0)) {
											currentElement.val("");
										} else {
											currentElement.val("已设置");
										}
										// 更新一下sessionStorage
										let data = getPageData();
										// 更新缓存中的内容
										sessionStorage.removeItem(yigoflow.config.cacheFileName);
										sessionStorage.setItem(yigoflow.config.cacheFileName, data);
										isLockScreen = false;
									}, 200);

								}, "取消": function (e) {
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();
									isLockScreen = false;
									$(this).dialog("close");
								}
							}, close: function () {
								isLockScreen = false;
							}
						});

					}).appendTo('#' + _div);
				} else if (_k == "ParticipatorCollection") {//参与者集合
					// 节点类型
					var nodeType = props["NodeType"].value;
					// 节点id
					var nodeId = props["Key"].value;
					if (nodeType == "SequenceFlow" || nodeType == "Association" || nodeType == "ExceptionFlow" || nodeType == "path") {
						nodeId = "path" + props["Key"].value;
					}

					// 当前元素
					var currentElement = $(this);

					props[_k].value = "";
					if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId]["props"] && yigoflow.config.restore.states[nodeId]["props"]["ParticipatorCollection"] && yigoflow.config.restore.states[nodeId]["props"]["ParticipatorCollection"].value) {
						let participatorCollectionJson = JSON.parse(yigoflow.config.restore.states[nodeId].props["ParticipatorCollection"].value.replace(/[\n\r]/g, '@br@')
							.replace(/\"\[/g, "[").replace(/\]\"/g, "]").replace(/\\"/g, "\""));
						if (participatorCollectionJson && participatorCollectionJson.Dictionary && participatorCollectionJson.Dictionary.length > 0 || participatorCollectionJson.MidFormula && participatorCollectionJson.MidFormula.length > 0 || participatorCollectionJson.Query && participatorCollectionJson.Query.length > 0) {
							props[_k].value = "已设置";
						}
					}

					$('<input style="width:100%;height: 22px;" readonly="readonly" placeholder="未设置,请点击进行设置"/>')
						.val(props[_k].value).click(function (e) {
						props[_k].value = $(this).val();
						//当前元素
						var currentElement = $(this);

						// 阻止默认行为，阻止事件冒泡
						e.preventDefault();
						e.stopPropagation();

						// 参与者集合，字典数组
						let dictionaryData = [];
						let queryData = [];
						let midFormulaData = [];
						if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId].props && yigoflow.config.restore.states[nodeId].props["ParticipatorCollection"] && yigoflow.config.restore.states[nodeId].props["ParticipatorCollection"].value) {
							let participatorCollection = JSON.parse(yigoflow.config.restore.states[nodeId].props["ParticipatorCollection"].value.replace(/[\n\r]/g, '@br@')
								.replace(/\"\[/g, "[").replace(/\]\"/g, "]").replace(/\\"/g, "\""));
							if (participatorCollection && participatorCollection.Dictionary) {
								dictionaryData = participatorCollection.Dictionary;
							}
							if (participatorCollection && participatorCollection.Query) {
								queryData = participatorCollection.Query;
								if (queryData && queryData.length > 0) {
									for (let i = 0; i < queryData.length; i++) {
										if (queryData[i].QueryParameterCollection == " ") {
											queryData.QueryParameterCollection = "";
										} else {
											queryData[i].QueryParameterCollection = JSON.stringify(queryData[i].QueryParameterCollection);
										}
										if (queryData[i].data) {
											queryData[i].data = queryData[i].data.replace(/@br@/g, '\n')
												.replace(/\<br\>/g, '\n');
										}
									}
								} else {
									queryData.QueryParameterCollection = "";
								}
							}
							if (participatorCollection && participatorCollection.MidFormula) {
								midFormulaData = participatorCollection.MidFormula;
								if (midFormulaData && midFormulaData.length > 0) {
									for (let i = 0; i < midFormulaData.length; i++) {
										midFormulaData[i].value = midFormulaData[i].value ? midFormulaData[i].value.replace(/@br@/g, '\n') : midFormulaData[i].value;
									}
								}
							}
						}

						var table = layui.table;
						var layer = layui.layer;

						// “参与者集合->字典”设置
						participatorDictionaryConfig(table, dictionaryData, layer);

						//“参与者集合->查询集”设置
						participatorQueryConfig(table, queryData, layer);

						//“参与者集合->中间层表达式”设置
						participatorMidFormulaConfig(table, midFormulaData, layer);

						// Tabs
						$('#participatorTabs').tabs();
						$("#participatorTabs").show();

						$("#permTabs").hide();
						$("#operationCollectionId").hide();
						$("#timerItemCollectionId").hide();
						$("#dmTableId").hide();
						$("#dialog").show();
						// 设置对话框
						$('#dialog').dialog({
							autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
								"确定": function (e) {
									var _thisDiag = $(this);
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();

									// 文件路径
									let filePath = yigoflow.config.filePath;

									let participatorCollection = {};
									if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId].props && yigoflow.config.restore.states[nodeId].props["ParticipatorCollection"] && yigoflow.config.restore.states[nodeId].props["ParticipatorCollection"].value) {
										participatorCollection = JSON.parse(yigoflow.config.restore.states[nodeId].props["ParticipatorCollection"].value.replace(/(\r\n)|(\n)/g, '@br@')
											.replace(/\"\[/g, "[").replace(/\]\"/g, "]"));
									}
									participatorCollection.Dictionary = table.cache.participator_dictionary;
									participatorCollection.Query = table.cache.querySql;
									participatorCollection.MidFormula = table.cache.midFormula;

									let PermValue = "";
									if (participatorCollection) {
										PermValue = JSON.stringify(participatorCollection);
									}

									// json数据
									let requestData = getPageDataByNodeId(nodeId, _k, PermValue);

									let params = {
										operType: 2,//操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
										filePath: filePath, content: requestData, nodeId: nodeId
									};

									// ajax请求后台操作
									ajaxRequest(params, 2, nodeType, nodeId, _r);
									if (ajaxStatus) {
										_thisDiag.dialog("close");

										if (participatorCollection.Dictionary && participatorCollection.Dictionary.length > 0 || participatorCollection.Query && participatorCollection.Query.length > 0 || participatorCollection.MidFormula && participatorCollection.MidFormula.length > 0) {
											currentElement.val("已设置");
										} else {
											currentElement.val("");
										}
										// 更新缓存中的内容
										sessionStorage.removeItem(yigoflow.config.cacheFileName);
										sessionStorage.setItem(yigoflow.config.cacheFileName, requestData);
										isLockScreen = false;
									}
								}, "取消": function (e) {
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();
									isLockScreen = false;
									$(this).dialog("close");
								}
							}, close: function () {
								isLockScreen = false;
							}
						});

					}).appendTo('#' + _div);

				} else if (_k == "OperationCollection") {//操作集合
					// 节点类型
					var nodeType = props["NodeType"].value;
					// 节点id
					var nodeId = props["Key"].value;
					if (nodeType == "SequenceFlow" || nodeType == "Association" || nodeType == "ExceptionFlow" || nodeType == "path") {
						nodeId = "path" + props["Key"].value;
					}

					// 当前元素
					var currentElement = $(this);

					props[_k].value = "";
					if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId]["props"] && yigoflow.config.restore.states[nodeId]["props"]["OperationCollection"] && yigoflow.config.restore.states[nodeId]["props"]["OperationCollection"].value) {
						let operationArrayJson = JSON.parse(yigoflow.config.restore.states[nodeId].props["OperationCollection"].value.replace(/[\r\n]/g, '@br@')
							.replace(/\"\"\[/g, '[').replace(/\]\"\"/g, ']'));
						if (operationArrayJson && operationArrayJson.length) {
							props[_k].value = "已设置";
						}
					}

					$('<input style="width:100%;height: 22px;" readonly="readonly" placeholder="未设置,请点击进行设置"/>')
						.val(props[_k].value).click(function (e) {
						props[_k].value = $(this).val();
						//当前元素
						var currentElement = $(this);

						// 阻止默认行为，阻止事件冒泡
						e.preventDefault();
						e.stopPropagation();

						// 操作集合
						let operateCollectionData = [];
						if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId].props && yigoflow.config.restore.states[nodeId].props["OperationCollection"] && yigoflow.config.restore.states[nodeId].props["OperationCollection"].value) {
							let operationArrayJson = JSON.parse(yigoflow.config.restore.states[nodeId].props["OperationCollection"].value.replace(/[\r\n]/g, '@br@')
								.replace(/\"\"\[/g, '[').replace(/\]\"\"/g, ']'));
							if (operationArrayJson && operationArrayJson.length > 0) {
								operateCollectionData = operationArrayJson;
								for (let i = 0; i < operationArrayJson.length; i++) {
									if (operationArrayJson[i].Enable) {
										operationArrayJson[i].Enable = operationArrayJson[i].Enable
											.replace(/@br@/g, '\n');
									}
									if (operationArrayJson[i].Visible) {
										operationArrayJson[i].Visible = operationArrayJson[i].Visible
											.replace(/@br@/g, '\n');
									}
									if (operationArrayJson[i].Action) {
										operationArrayJson[i].Action = operationArrayJson[i].Action
											.replace(/@br@/g, '\n').replace(/&quot;/g, '"');
									}
								}
							}
						}

						var table = layui.table;
						var layer = layui.layer;

						//“操作集合”设置
						operateCollectionConfig(table, operateCollectionData, layer);

						$("#permTabs").hide();
						$("#participatorTabs").hide();
						$("#timerItemCollectionId").hide();
						$("#operationCollectionId").show();
						$("#dmTableId").hide();
						$("#dialog").show();
						// 设置对话框
						$('#dialog').dialog({
							autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
								"确定": function (e) {
									var _thisDiag = $(this);
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();

									// 文件路径
									let filePath = yigoflow.config.filePath;

									let PermValue = "[]";
									if (table.cache.operateCollection && table.cache.operateCollection.length > 0) {
										let operateCollectionTemp = table.cache.operateCollection;
										for (let i = 0; i < operateCollectionTemp.length; i++) {
											if (operateCollectionTemp[i].Action) {
												operateCollectionTemp[i].Action = operateCollectionTemp[i].Action
													.replace(/[""]/g, "&quot;")
													.replace(/['']/g, "&apos;");
											}
											if (operateCollectionTemp[i].Enable) {
												operateCollectionTemp[i].Enable = operateCollectionTemp[i].Enable
													.replace(/[""]/g, "&quot;").replace(/['']/g, "&apos;");
											}
											if (operateCollectionTemp[i].Visible) {
												operateCollectionTemp[i].Visible = operateCollectionTemp[i].Visible
													.replace(/[""]/g, "&quot;")
													.replace(/['']/g, "&apos;");
											}
										}
										PermValue = JSON.stringify(operateCollectionTemp);
									}

									// json数据
									let requestData = getPageDataByNodeId(nodeId, _k, PermValue);
									let params = {
										operType: 2,//操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
										filePath: filePath, content: requestData, nodeId: nodeId
									};
									// ajax请求后台操作
									ajaxRequest(params, 2, nodeType, nodeId, _r);
									if (ajaxStatus) {
										_thisDiag.dialog("close");

										if (table.cache.operateCollection && table.cache.operateCollection.length > 0) {
											currentElement.val("已设置");
										} else {
											currentElement.val("");
										}
										// 更新缓存中的内容
										sessionStorage.removeItem(yigoflow.config.cacheFileName);
										sessionStorage.setItem(yigoflow.config.cacheFileName, requestData);
										isLockScreen = false;
									}
								}, "取消": function (e) {
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();
									isLockScreen = false;
									$(this).dialog("close");
								}
							}, close: function () {
								isLockScreen = false;
							}
						});

					}).appendTo('#' + _div);
				} else if (_k == "TimerItemCollection") {// 审批超时集合设置
					// 节点类型
					var nodeType = props["NodeType"].value;
					// 节点id
					var nodeId = props["Key"].value;
					if (nodeType == "SequenceFlow" || nodeType == "Association" || nodeType == "ExceptionFlow" || nodeType == "path") {
						nodeId = "path" + props["Key"].value;
					}

					// 当前元素
					var currentElement = $(this);

					props[_k].value = "";
					if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId]["props"] && yigoflow.config.restore.states[nodeId]["props"]["TimerItemCollection"] && yigoflow.config.restore.states[nodeId]["props"]["TimerItemCollection"].value) {
						let timerItemArrayJson = JSON.parse(yigoflow.config.restore.states[nodeId].props["TimerItemCollection"].value.replace(/[\r\n]/g, '@br@')
							.replace(/\"\"\[/g, '[').replace(/\]\"\"/g, ']'));
						if (timerItemArrayJson && timerItemArrayJson.length) {
							props[_k].value = "已设置";
						}
					}
					$('<input style="width:100%;height: 22px;" readonly="readonly" placeholder="未设置,请点击进行设置"/>')
						.val(props[_k].value).click(function (e) {
						props[_k].value = $(this).val();
						//当前元素
						var currentElement = $(this);

						// 阻止默认行为，阻止事件冒泡
						e.preventDefault();
						e.stopPropagation();

						// 审批超时集合
						let timerItemCollectionData = [];
						if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId].props && yigoflow.config.restore.states[nodeId].props["TimerItemCollection"] && yigoflow.config.restore.states[nodeId].props["TimerItemCollection"].value) {
							let timerItemArrayJson = JSON.parse(yigoflow.config.restore.states[nodeId].props["TimerItemCollection"].value.replace(/[\r\n]/g, '@br@')
								.replace(/\"\"\[/g, '[').replace(/\]\"\"/g, ']'));
							if (timerItemArrayJson && timerItemArrayJson.length > 0) {
								timerItemCollectionData = timerItemArrayJson;
								for (let i = 0; i < timerItemCollectionData.length; i++) {
									timerItemCollectionData[i].Suggestion = timerItemCollectionData[i]
										.Suggestion.replace(/@br@/g, '\n');
								}
							}
						}

						var table = layui.table;
						var layer = layui.layer;

						//“审批超时集合”设置
						timerItemCollectionConfig(table, timerItemCollectionData, layer);

						$("#permTabs").hide();
						$("#participatorTabs").hide();
						$("#operationCollectionId").hide();
						$("#timerItemCollectionId").show();
						$("#dmTableId").hide();
						$("#dialog").show();
						// 设置对话框
						$('#dialog').dialog({
							autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
								"确定": function (e) {
									var _thisDiag = $(this);
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();

									// 文件路径
									let filePath = yigoflow.config.filePath;

									let PermValue = "[]";
									if (table.cache.timerItemCollection && table.cache.timerItemCollection.length > 0) {
										PermValue = JSON.stringify(table.cache.timerItemCollection);
									}

									// json数据
									let requestData = getPageDataByNodeId(nodeId, _k, PermValue);

									let params = {
										operType: 2,//操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
										filePath: filePath, content: requestData, nodeId: nodeId
									};

									// ajax请求后台操作
									ajaxRequest(params, 2, nodeType, nodeId, _r);
									if (ajaxStatus) {
										_thisDiag.dialog("close");

										if (table.cache.timerItemCollection && table.cache.timerItemCollection.length > 0) {
											currentElement.val("已设置");
										} else {
											currentElement.val("");
										}
										// 更新缓存中的内容
										sessionStorage.removeItem(yigoflow.config.cacheFileName);
										sessionStorage.setItem(yigoflow.config.cacheFileName, requestData);
										isLockScreen = false;
									}
								}, "取消": function (e) {
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();
									isLockScreen = false;
									$(this).dialog("close");
								}
							}, close: function () {
								isLockScreen = false;
							}
						});

					}).appendTo('#' + _div);
				} else if (_k == "AssistanceCollection") {//辅助节点集合设置
					// 节点类型
					var nodeType = props["NodeType"].value;
					// 节点id
					var nodeId = props["Key"].value;
					if (nodeType == "SequenceFlow" || nodeType == "Association" || nodeType == "ExceptionFlow" || nodeType == "path") {
						nodeId = "path" + props["Key"].value;
					}

					// 当前元素
					var currentElement = $(this);

					props[_k].value = "";
					if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId]["props"] && yigoflow.config.restore.states[nodeId]["props"]["AssistanceCollection"] && yigoflow.config.restore.states[nodeId]["props"]["AssistanceCollection"].value) {
						let assistanceCollectionArrayJson = JSON.parse(yigoflow.config.restore.states[nodeId].props["AssistanceCollection"].value.replace(/(\\r\\n)|\\n/g, '@br@')
							.replace(/\"\"\[/g, '[').replace(/\]\"\"/g, ']').replace(/\"\[/g, '[')
							.replace(/]\"/g, ']').replace(/\"\{/g, '{').replace(/\}\"/g, '}')
							.replace(/\"\[\{/g, "[{").replace(/}]\\"/g, "}]").replace(/\\/g, ''));
						if (assistanceCollectionArrayJson && assistanceCollectionArrayJson.length) {
							props[_k].value = "已设置";
						}
					}

					$('<input style="width:100%;height: 22px;" readonly="readonly" placeholder="未设置,请点击进行设置"/>')
						.val(props[_k].value).click(function (e) {
						props[_k].value = $(this).val();
						//当前元素
						var currentElement = $(this);

						// 阻止默认行为，阻止事件冒泡
						e.preventDefault();
						e.stopPropagation();

						// 辅助节点集合
						let assistanceCollectionData = [{
							id: 1,
							NodeType: 'Countersign',
							Key: 'task1',
							Caption: 'task1',
							Perm: {VisiblePerm: [], EnablePerm: [], OptPerm: []},
							OperationCollection: [],
							ParticipatorCollection: {},
							TimerItemCollection: [],
							OtherSet: {
								ProcessKey: '',
								TemplateKey: '',
								CreateTrigger: '',
								FinishTrigger: '',
								PassCondition: '',
								ValidCondition: '',
								FinishCondition: '',
								InUse: '',
								AutoIgnoreNoParticipator: '',
								PassType: '',
								ValidType: ''
							}
						}];
						if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId].props && yigoflow.config.restore.states[nodeId].props["AssistanceCollection"] && yigoflow.config.restore.states[nodeId].props["AssistanceCollection"].value) {
							let assistanceCollectionArrayJson = JSON.parse(yigoflow.config.restore.states[nodeId].props["AssistanceCollection"].value.replace(/(\\r\\n)|\\n/g, '@br@')
								.replace(/\"\"\[/g, '[').replace(/\]\"\"/g, ']')
								.replace(/\"\[/g, '[').replace(/]\"/g, ']').replace(/\"\{/g, '{')
								.replace(/\}\"/g, '}').replace(/\"\[\{/g, "[{").replace(/}]\\"/g, "}]").replace(/\\/g, ''));
							if (assistanceCollectionArrayJson && assistanceCollectionArrayJson.length > 0) {
								if (assistanceCollectionArrayJson[0].Perm)
									if (JSON.stringify(assistanceCollectionArrayJson[0].Perm.VisiblePerm) == null) {
										assistanceCollectionArrayJson[0].Perm.VisiblePerm = [];
									}
								if (JSON.stringify(assistanceCollectionArrayJson[0].Perm.EnablePerm) == null) {
									assistanceCollectionArrayJson[0].Perm.EnablePerm = [];
								}
								if (JSON.stringify(assistanceCollectionArrayJson[0].Perm.OptPerm) == null) {
									assistanceCollectionArrayJson[0].Perm.OptPerm = [];
								}
								assistanceCollectionData = assistanceCollectionArrayJson;
							}
						}

						var table = layui.table;
						var layer = layui.layer;

						//“操作集合”设置
						assistanceCollectionConfig(table, assistanceCollectionData, layer);

						$("#dialogAssistanceCollection").show();
						// 设置对话框
						$('#dialogAssistanceCollection').dialog({
							autoOpen: true, width: 800, height: 600, modal: true, resizable: false, buttons: {
								"确定": function (e) {
									var _thisDiag = $(this);
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();

									// 文件路径
									let filePath = yigoflow.config.filePath;

									let PermValue = "[]";
									if (table.cache.assistanceCollection && table.cache.assistanceCollection.length > 0) {
										PermValue = JSON.stringify(table.cache.assistanceCollection);
									}

									// json数据
									let requestData = getPageDataByNodeId(nodeId, _k, PermValue);

									let params = {
										operType: 2,//操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
										filePath: filePath, content: requestData, nodeId: nodeId
									};

									// ajax请求后台操作
									ajaxRequest(params, 2, nodeType, nodeId, _r);
									if (ajaxStatus) {
										_thisDiag.dialog("close");

										if (table.cache.assistanceCollection && table.cache.assistanceCollection.length > 0) {
											currentElement.val("已设置");
										} else {
											currentElement.val("");
										}
										// 更新缓存中的内容
										sessionStorage.removeItem(yigoflow.config.cacheFileName);
										sessionStorage.setItem(yigoflow.config.cacheFileName, requestData);
										isLockScreen = false;
									}
								}, "取消": function (e) {
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();
									isLockScreen = false;
									$(this).dialog("close");
								}
							}, close: function () {
								isLockScreen = false;
							}
						});

					}).appendTo('#' + _div);
				} else if (_k == "BillDataMapInfoCollection") {//映射集合
					// 节点类型
					var nodeType = props["NodeType"].value;
					// 节点id
					var nodeId = props["Key"].value;
					if (nodeType == "SequenceFlow" || nodeType == "Association" || nodeType == "ExceptionFlow" || nodeType == "path") {
						nodeId = "path" + props["Key"].value;
					}

					// 当前元素
					var currentElement = $(this);

					props[_k].value = "";
					if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId]["props"] && yigoflow.config.restore.states[nodeId]["props"]["BillDataMapInfoCollection"] && yigoflow.config.restore.states[nodeId]["props"]["BillDataMapInfoCollection"].value) {
						let billDataMapInfoCollectionJson = JSON.parse(yigoflow.config.restore.states[nodeId].props["BillDataMapInfoCollection"].value.replace(/[\r\n]/g, '@br@')
							.replace(/\"\"\[/g, '[').replace(/\]\"\"/g, ']'));
						if (billDataMapInfoCollectionJson && billDataMapInfoCollectionJson.length) {
							props[_k].value = "已设置";
						}
					}

					$('<input style="width:100%;height: 22px;" readonly="readonly" placeholder="未设置,请点击进行设置"/>')
						.val(props[_k].value).click(function (e) {
						props[_k].value = $(this).val();
						//当前元素
						var currentElement = $(this);

						// 阻止默认行为，阻止事件冒泡
						e.preventDefault();
						e.stopPropagation();

						// 映射集合
						let billDataMapInfoCollectionData = [];
						if (yigoflow.config.restore && yigoflow.config.restore.states && yigoflow.config.restore.states[nodeId] && yigoflow.config.restore.states[nodeId].props && yigoflow.config.restore.states[nodeId].props["BillDataMapInfoCollection"] && yigoflow.config.restore.states[nodeId].props["BillDataMapInfoCollection"].value) {
							billDataMapInfoCollectionData = JSON.parse(yigoflow.config.restore.states[nodeId].props["BillDataMapInfoCollection"].value.replace(/[\r\n]/g, '@br@')
								.replace(/\"\"\[/g, '[').replace(/\]\"\"/g, ']'));
						}

						var table = layui.table;
						var layer = layui.layer;

						//“映射集合”设置
						table.render({
							elem: '#dataMapCollection',
							toolbar: '#buttonsToolbarDataMapCollection',
							even: true,
							width: '99%',
							height: 500,
							defaultToolbar: [],
							contentType: "application/x-www-form-urlencoded",
							data: billDataMapInfoCollectionData,
							limit: 1000,
							cols: [[{
								type: 'checkbox', fixed: 'left'
							}, {
								field: 'id', width: 60, title: '编号'
							}, {
								field: 'DataMapKey', title: '映射标识', width: 100
							}, {
								field: 'Caption', title: '映射名称', width: 100
							}, {
								field: 'AutoStart',
								title: '是否自启动',
								width: 100,
								align: 'center',
								templet: function (row) {
									let html = "<input type='checkbox' lay-skin='primary' " + "lay-filter='checkboxAutoStart' " + "disabled='disabled' table-index='" + row.LAY_TABLE_INDEX + "' " + "class='checkboxAutoStart' ";
									if (row.AutoStart === true) {
										html += " checked = 'checked' ";
									}
									html += ">";
									return html;
								}
							}, {
								field: 'FormKey', title: '目标单据标识', width: 180
							}, {
								fixed: 'right',
								title: '操作',
								width: 113,
								align: 'center',
								toolbar: '#lineBtnsBarDataMapCollection'
							}]],
							done: function (res, curr, count) {
								// 类型填充整个单元格
								var tableElem = this.elem.next('.layui-table-view');
								count || tableElem.find('.layui-table-header').css('overflow', 'hidden');
							}
						});

						let data_tr;
						//监听表格复选框选择
						table.on('checkbox(dataMapCollection)', function (obj) {
							data_tr = $(this);
							//全选时
							if (obj.type == "all") {
								if (obj.checked) {//全选中
									var checkStatus = table.checkStatus('dataMapCollection');
									var sdata = checkStatus.data;
									if (sdata.length > 0) {//渲染背景颜色
										$(".layui-table-body .layui-table tr").each(function () {
											$(this).addClass("tr_bj_color");
										})
									}
								} else {//全部不选
									$(".layui-table-body .layui-table tr").each(function () {
										$(this).removeClass("tr_bj_color");
									})
								}
							} else {//单选
								var checkStatus = table.checkStatus('dataMapCollection');
								var sdata = checkStatus.data;
								if (obj.checked) {//选中
									obj.tr.addClass('tr_bj_color');
								} else {//取消选中
									obj.tr.removeClass('tr_bj_color');
								}
							}
						});

						//头工具栏事件
						table.on('toolbar(dataMapCollection)', function (obj) {
							let layEvent = obj.event;
							if (layEvent === 'add') {
								add();
							} else if (layEvent === 'del') {
								var checkStatus = table.checkStatus('dataMapCollection');
								if (checkStatus.data.length < 1) {
									layer.alert("请选择一条数据操作");
									return false;
								} else {
									layer.confirm('确定删除吗', function (index) {
										let cbList = table.cache.dataMapCollection;
										for (var k = 0; k < checkStatus.data.length; k++) {
											var _delId = checkStatus.data[k].id;
											for (var i = 0; i < cbList.length; i++) {
												var _id = cbList[i].id;
												if (_id == _delId) {
													cbList.splice(i, 1);
													break;
												}
											}
										}
										//重新对序号编码
										for (var i = 0; i < cbList.length; i++) {
											cbList[i].id = i+1;
										}
										table.reload("dataMapCollection", {
											data: cbList,
										});
										layer.close(index);
									});
								}
							}
						});

						//监听行工具事件
						//注：tool 是工具条事件名，test 是 table 原始容器的属性 lay-filter="对应的值"
						table.on('tool(dataMapCollection)', function (obj) {
							var data = obj.data //获得当前行数据（json格式的键值对）
								, layEvent = obj.event //获得 lay-event 对应的值（编辑、删除、添加）
								, editList = []; //存放获取到的那条json数据中的value值（不放key）
							$.each(data, function (name, value) {//循环遍历json数据
								editList.push(value);//将json数据中的value放入数组中（下面的子窗口显示的时候要用到）
							});
							if (layEvent === 'edit') {
								if (!data || data.length == 0) {
									layer.alert("没有数据不可编辑");
									return;
								}
								edit(data);
							}
						});

						// 新增
						function add() {
							let maxId = 0;
							var oldData = table.cache.dataMapCollection;//获得当前页面的原始数据
							if (!oldData) {
								oldData = [];
							} else {
								for (var i = 0; i < oldData.length; i++) {
									if (oldData[i].id > maxId) {
										maxId = oldData[i].id;
									}
								}
							}

							let newLineData = {};
							newLineData.id = maxId + 1;
							newLineData.DataMapKey = "map" + (maxId + 1);
							newLineData.Caption = "map" + (maxId + 1);
							newLineData.AutoStart = false;
							newLineData.FormKey = '';
							oldData.push(newLineData);//在原始数据前添加新添加的数据
							table.reload('dataMapCollection', {data: oldData});//把新处理的数据重新加载一下
							layer.msg('新增成功', {icon: 1, time: 1500});
						}

						// 编辑
						function edit(data) {
							var editHtml = '<div id="formEdit" class="layui-form" \
                                         style="width:470px; margin-top: 5px;overflow: hidden;">\
                               <div class="layui-form-item" style="margin-bottom: 15px;">\
                                 <label class="layui-form-label" style="vertical-align: middle;\
                                                                        width:120px;padding: 3px 15px;">映射标识</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="DataMapKey" id="DataMapKey" \
                                            placeholder="请输入映射标识" autocomplete="off" \
                                            class="layui-input" style="width: 300px;">\
                                 </div>\
                               </div>\
                               <div id="KeyDiv" class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" style="vertical-align: middle;width:120px;\
                                                                        padding: 3px 15px;">映射名称</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="Caption" id="Caption" \
                                            placeholder="请输入映射名称" autocomplete="off" \
                                            class="layui-input" style="width: 300px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 5px;">\
                                 <label class="layui-form-label" style="vertical-align: middle;width:120px;\
                                                                        padding: 3px 15px;">是否自启动</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="checkbox" name="AutoStart" id="AutoStart" \
                                          lay-skin="primary" title="是否自启动" style="display:block;margin-top: 15px;\
                                                                                    width: 18px;height: 18px;">\
                                 </div>\
                               </div>\
                               <div class="layui-form-item" style="margin-bottom: 15px;">\
                                 <label class="layui-form-label" \
                                 style="vertical-align: middle;width:120px;">目标单据标识</label>\
                                 <div class="layui-input-block" style="margin-left: 90px;">\
                                   <input type="text" name="FormKey" id="FormKey" \
                                            placeholder="请输入目标单据标识" autocomplete="off" \
                                            class="layui-input" style="width: 300px;">\
                                 </div>\
                               </div>\
                            </div>';

							layer.open({
								type: 1,
								title: '编辑',
								content: editHtml,
								area: ['470px', '430px'],
								btn: ['确定', '取消'],
								resize: false,
								move: false,
								shade: [0.1, '#000'],
								success: function () {
									$("#DataMapKey").val(data.DataMapKey);
									$("#Caption").val(data.Caption);
									if (data.AutoStart) {
										$("#AutoStart").attr("checked", true);
										$("#AutoStart").css("background-color", "#5FB878");
									} else {
										$("#AutoStart").attr("checked", false);
									}
									$("#FormKey").val(data.FormKey);
								},
								yes: function (layIndex) {
									var oldData = table.cache.dataMapCollection;
									var len = oldData.length;

									data.DataMapKey = $("#DataMapKey").val();
									data.Caption = $("#Caption").val();
									if ($("#AutoStart").is(':checked')) {
										data.AutoStart = true;
									} else {
										data.AutoStart = false;
									}
									data.FormKey = $("#FormKey").val();

									//循环数据，找到更新的数据行，直接更新
									for (var i = 0; i < len; i++) {
										if (i + 1 == data.id) {
											oldData[i] = data;
											break;
										}
									}
									//重新加一下数据
									table.reload('dataMapCollection', {data: oldData});
									layer.msg('修改成功', {icon: 1, time: 1500});
									layer.close(layIndex);
								},
								cancel: function (layIndex) {
									layer.close(layIndex);
								}
							});
						}

						// 隐藏其他tab及表格
						$("#permTabs").hide();
						$("#participatorTabs").hide();
						$("#timerItemCollectionId").hide();
						$("#operationCollectionId").hide();
						$("#dmTableId").hide();
						// 显示数据映射表格
						$("#dataMapCollectionId").show();
						// 显示对话框
						$("#dialog").show();
						// 设置对话框
						$('#dialog').dialog({
							autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
								"确定": function (e) {
									var _thisDiag = $(this);
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();

									// 文件路径
									let filePath = yigoflow.config.filePath;

									let dataMapCollection = table.cache.dataMapCollection;
									let PermValue = "[]";
									if (dataMapCollection && dataMapCollection.length > 0) {
										PermValue = JSON.stringify(dataMapCollection);
									}

									// json数据
									let requestData = getPageDataByNodeId(nodeId, _k, PermValue);

									let params = {
										operType: 2,//操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
										filePath: filePath, content: requestData, nodeId: nodeId
									};

									// ajax请求后台操作
									ajaxRequest(params, 2, nodeType, nodeId, _r);
									if (ajaxStatus) {
										_thisDiag.dialog("close");

										if (dataMapCollection && dataMapCollection.length > 0) {
											currentElement.val("已设置");
										} else {
											currentElement.val("");
										}

										// 更新一下sessionStorage
										let data = getPageData();
										// 更新缓存中的内容
										sessionStorage.removeItem(yigoflow.config.cacheFileName);
										sessionStorage.setItem(yigoflow.config.cacheFileName, data);
										isLockScreen = false;
									}
								}, "取消": function (e) {
									// 阻止默认行为，阻止事件冒泡
									e.preventDefault();
									e.stopPropagation();
									isLockScreen = false;
									$(this).dialog("close");
								}
							}, close: function () {
								isLockScreen = false;
							}
						});

					}).appendTo('#' + _div);
				} else if (_k == "Width" || _k == "Height" || _k == "X" || _k == "Y") {
					$('<input style="width:100%;height: 22px;" readonly="readonly"/>')
						.val(props[_k].value).appendTo('#' + _div);
				} else {
					$('<input style="width:100%;height: 22px;"/>').val(props[_k].value).change(function (e) {
						props[_k].value = $(this).val();
						if ($(this).offsetParent()[0].outerText.indexOf("基础属性") != -1) {
							idFlag = "";
						}
						let nodeId = null;
						var formKey;
						// 节点及路径属性的数据更新操作
						if (props["NodeType"]) {
							// 节点类型
							let nodeType = props["NodeType"].value;
							// 文件路径
							let filePath = yigoflow.config.filePath;
							// 节点id
							nodeId = props["Key"].value;
							if (nodeType == "SequenceFlow" || nodeType == "Association" || nodeType == "ExceptionFlow" || nodeType == "path") {
								nodeId = "path" + props["Key"].value;
							}
							// json数据
							let requestData = getPageDataByNodeId(nodeId, _k, props[_k].value);

							// 如果是修改名称，那么图标中间的名称也同时修改
							if (_k == "Caption") {
								$(_r).trigger('textchange', [$(this).val(), _src]);
							}

							let params = {
								operType: 2,//操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
								filePath: filePath, content: requestData, nodeId: nodeId
							};

							// ajax请求后台操作
							ajaxRequest(params, 2, nodeType, nodeId, _r);
							if (ajaxStatus) {
								// 更新缓存中的内容
								sessionStorage.removeItem(yigoflow.config.cacheFileName);
								sessionStorage.setItem(yigoflow.config.cacheFileName, requestData);
							}

						} else {
							var oldValue = _gprops[_k].value;
							_gprops[_k].value = props[_k].value;
							if (_k == "Caption") {
								try {
									$(".aria-selected", $(".ui-tabs-header", window.parent.document)).find('a').find('label')[0].innerText = props[_k].value;
								} catch (e) {

								}
								/*
								// 改变浏览器中的type值
								let url = window.location.href;
								url = changeURLArg(url, "Caption", encodeURIComponent(props[_k].value));
								window.location.href = url;*/

							}

							// 文件路径
							let filePath = yigoflow.config.filePath;
							let params = {
								operType: 0,
								filePath: filePath,
								content: "{key:'" + _k + "',value:'" + props[_k].value + "'}",
								nodeId: 0
							};
							let nodeName = PanelJudge(idFlag);
							formKey = idFlag;
							var keyID = "";
							let prop = props["fieldKey"];
							if (prop != null){
								keyID = prop.value;
							}
							var item1 = sessionStorage.getItem("Type" + yigoflow.config.cacheFileName);
							var content = {
								key:_k,
								keyID:keyID,
								value:props[_k].value,
								tableKey:yigoflow.config.tableKey,
								Type:item1,
								fieldKey:yigoflow.config.fieldKey,
								targetField:yigoflow.config.targetKey
							}
							let dataMapParams = {
								operType: 0,
								filePath: filePath,
								content: JSON.stringify(content),
								nodeId: 0,
								oldValue: oldValue,
								nodeName: nodeName,
								targetField: yigoflow.config.targetKey
							}
							ajaxStatus = false;
							//判断是当前操作的是数据映射还是工作流
							if (DataMapOrMigration) {
								ajaxDataMapUpdateXml(dataMapParams);
							} else {
								ajaxUpdateXml(params);
							}
						}
						if (_k == 'TargetTableKey'||_k == 'RowTrigger') {
							$("#"+formKey + yigoflow.config.tableKey).trigger("click");
						}
						// ajax响应后的处理
						if (ajaxStatus) {
							sessionStorage.removeItem("TableKey" + yigoflow.config.cacheFileName);
							sessionStorage.removeItem("Type" + yigoflow.config.cacheFileName);
							sessionStorage.removeItem("nodeName" + yigoflow.config.cacheFileName);
							if (nodeId) {
								$(_r).trigger('click', {
									getId() {
										isLockScreen = false;
										return nodeId;
									}
								});
							}
							//用于回填,公式字段和常量字段
							if (_k === 'sourceContent') {
								sessionStorage.removeItem("oldValue" + yigoflow.config.cacheFileName);
								sessionStorage.setItem("oldValue" + yigoflow.config.cacheFileName, oldValue);
								//公式字段 和常量字段如果传入的新值是空，就去删除这条数据
								if (props[_k].value === "") {
									//触发删除按钮这个数据前端数据删除，后端也会对应删除
									$("#B_" + sessionStorage.getItem("ConstAndFormulaID" + yigoflow.config.cacheFileName)).trigger("click");
								} else {
									$("#" + sessionStorage.getItem("ConstAndFormulaID" + yigoflow.config.cacheFileName))[0].placeholder = props[_k].value;
									//触发面板中的被回填文本框的值变化事件
									$("#" + sessionStorage.getItem("ConstAndFormulaID" + yigoflow.config.cacheFileName)).trigger("change");
								}
								//清除缓存
								sessionStorage.removeItem("ConstAndFormulaID" + yigoflow.config.cacheFileName);
							}
						}

					}).appendTo('#' + _div);
				}
				///////////////////////////////////////////////////////////////////////////////////////////////////////
				//////////////////////////////////////////字段处理结束////////////////////////////////////////////////////
				////////////////////////////////////////////////////////////////////////////////////////////////////////
				$('#' + _div).data('editor', this);
			}
			this.destroy = function () {
				$('#' + _div + ' input').each(function () {
					_props[_k].value = $(this).val();
				});
			}
		}, selectEditor: function (arg) {
			var _props, _k, _div, _src, _r;
			this.init = function (props, k, div, src, r) {
				_props = props;
				_k = k;
				_div = div;
				_src = src;
				_r = r;
				let sle;
				if (k === 'formField' || k === 'targetFormField' || _k.indexOf('feedbackFormField') != -1) {
					maxId++;
					sle = $('<select id="Select__' + maxId + '" style="width:90%;height: 25px;" class="form-control"/> ');
				} else {
					sle = $('<select style="width:100%;height: 26px;"/>');
				}
				if (typeof arg === 'string') {
					let params = {
						operType: 0,//操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
						filePath: yigoflow.config.filePath, content: '', nodeId: ''
					};
					let dataMapParams = {
						operType: 0, filePath: yigoflow.config.filePath, formKey: idFlag
					};
					if (arg == "getAllNodes") {
						$.ajax({
							type: "post",
							url: "/erp/bpmAttributes/getAllNodes",
							dataType: 'json',
							contentType: 'application/json;charset=utf-8',
							data: JSON.stringify(params),
							success: function (res) {
								if (res) {
									if (res.code == 0) {
										var opts = res.data;
										if (opts && opts.length > 0) {
											sle.append('<option value=""></option>');
											for (let idx = 0; idx < opts.length; idx++) {
												sle.append('<option value="' + opts[idx].value + '">' + opts[idx].name + '</option>');
											}
											sle.val(_props[_k].value);
										}
									} else {
										console.error(res.msg);
									}
								} else {
									console.error("获取当前文件的所有节点元素请求响应失败");
								}
							},
							error: function () {
								console.error("获取当前文件的所有节点元素失败");
							}
						});
					} else if (arg == "getInline") {
						$.ajax({
							type: "post",
							url: "/erp/bpmAttributes/getInline",
							dataType: 'json',
							contentType: 'application/json;charset=utf-8',
							data: null,
							success: function (res) {
								if (res) {
									if (res.code == 0) {
										var opts = res.data;
										if (opts && opts.length > 0) {
											sle.append('<option value=""></option>');
											for (let idx = 0; idx < opts.length; idx++) {
												sle.append('<option value="' + opts[idx].value + '">' + opts[idx].name + '</option>');
											}
											sle.val(_props[_k].value);
										}
									} else {
										console.error(res.msg);
									}
								} else {
									console.error("获取当前文件的所有节点元素请求响应失败");
								}
							},
							error: function () {
								console.error("获取当前文件的所有节点元素失败");
							}
						});
					} else if (arg == "getStatusList") {
						$.ajax({
							type: "post",
							url: "/erp/bpmAttributes/getStatusList",
							dataType: 'json',
							contentType: 'application/json;charset=utf-8',
							data: JSON.stringify(params),
							success: function (res) {
								if (res) {
									if (res.code == 0) {
										var opts = res.data;
										if (opts && opts.length > 0) {
											sle.append('<option value=""></option>');
											for (let idx = 0; idx < opts.length; idx++) {
												sle.append('<option value="' + opts[idx].value + '">' + opts[idx].name + '</option>');
											}
											sle.val(_props[_k].value);
										}
										sessionStorage.setItem(_props.Key.value + "StatusList", JSON.stringify(opts));
									} else {
										console.error(res.msg);
									}
								} else {
									console.error("获取当前文件的所有节点元素请求响应失败");
								}
							},
							error: function () {
								console.error("获取当前文件的所有节点元素失败");
							}
						});

					} else if (arg == "getFormField") {
						dataMapParams.operationType = str;
						getFormField(dataMapParams, sle, _props, _k);
					} else if (arg == "getMigrationField") {
						getMigrationField(dataMapParams, sle, _props, _k);
					} else if (arg == "getTargetTableList") {
						getTargetTableList(dataMapParams, sle, _props, _k);
					} else if (arg == "getRefFieldKey") {
						getRefFieldKey(dataMapParams, sle, _props, _k);
					} else if (arg == "getStatusFideldKey") {
						getStatusFideldKey(dataMapParams, sle, _props, _k)
					} else if (arg == "getSourceFieldList") {
						let dataMapParams = {
							filePath: yigoflow.config.filePath, tableKey: yigoflow.config.tableKey
						};
						getSourceFieldList(dataMapParams, sle, _props, _k)
					}
				} else {
					for (let idx = 0; idx < arg.length; idx++) {
						if (((_k == "WorkitemRevoke" || _k == "QueryRetreatWorkitem" || _k == "Direction") && idx == 0) || ((_k == "LockWorkitem" || _k == "IsSync" || _k == "AutoIgnoreNoParticipator" || _k == "DenyToLastNode" || _k == "InOrder" || _k == "MidDataMap") && idx == 1)) {
							sle.append('<option value="' + arg[idx].value + '" selected="selected">' + arg[idx].name + '</option>');
						} else {
							sle.append('<option value="' + arg[idx].value + '">' + arg[idx].name + '</option>');
						}
					}
					sle.val(_props[_k].value);
				}

				sle.val(props[_k].value).change(function () {
					var formKey;
					props[_k].value = $(this).val();
					if ($(this).offsetParent()[0].outerText.indexOf("基础属性") != -1) {
						idFlag = "";
					}
					// 设置"驳回目标节点"显示/隐藏效果
					if (_k == "DenyToLastNode" && props[_k].value == "true") {
						$("#pDenyNodeKey").val("");
						$("#pDenyNodeKey").parent().parent().hide();
					} else {
						$("#pDenyNodeKey").val("");
						$("#pDenyNodeKey").parent().parent().show();
					}

					// 节点及路径属性的数据更新操作
					if (props["NodeType"]) {
						// 节点类型
						let nodeType = props["NodeType"].value;
						// 文件路径
						let filePath = yigoflow.config.filePath;
						// 节点id
						let nodeId = props["Key"].value;
						if (nodeType == "SequenceFlow" || nodeType == "Association" || nodeType == "ExceptionFlow" || nodeType == "path") {
							nodeId = "path" + props["Key"].value;
						}
						// json数据
						let requestData = getPageDataByNodeId(nodeId, _k, props[_k].value);

						// 如果是修改名称，那么图标中间的名称也同时修改
						if (_k == "Caption") {
							$(_r).trigger('textchange', [$(this).val(), _src]);
						}

						let params = {
							operType: 2,//操作类型，1:节点和路径的新增和修改；2：属性的修改；3：删除
							filePath: filePath, content: requestData, nodeId: nodeId
						};

						// ajax请求后台操作
						ajaxRequest(params, 2, nodeType, nodeId, _r);
						if (ajaxStatus) {
							layer.msg("修改成功", {icon: 1, time: 1500,}, function () {
								isLockScreen = false;
							});
						}

					} else {
						_gprops[_k].value = props[_k].value;
						if (props["TargetFieldKey"]) {
							targetField = props["TargetFieldKey"].value;
						}
						if (_k == "Caption") {
							// 改变浏览器中的type值
							let url = window.location.href;
							url = changeURLArg(url, "Caption", encodeURIComponent(props[_k].value));
							window.location.href = url;
						}

						// 文件路径
						let filePath = yigoflow.config.filePath;
						let params = {
							operType: 0,
							filePath: filePath,
							content: "{key:'" + _k + "',value:'" + props[_k].value + "'}",
							nodeName: sessionStorage.getItem("nodeName" + yigoflow.config.cacheFileName),
							nodeId: 0
						};
						if (idFlag === "" && props[_k].value.split("_@_")[4]) {
							idFlag = props[_k].value.split("_@_")[4];
						}
						let nodeName = PanelJudge(idFlag);
						formKey = idFlag;
						var keyID = "";
						let prop = props["fieldKey"];
						if (prop != null){
							keyID = prop.value;
						}
						var content = {
							key:_k,
							value:props[_k].value,
							keyID:keyID,
							tableKey:yigoflow.config.tableKey,
							fieldKey:yigoflow.config.fieldKey,
							targetField:yigoflow.config.targetKey
						}
						let dataMapParams = {
							operType: 0,
							filePath: filePath,
							content:  JSON.stringify(content),
							nodeName: nodeName,
							formKey: idFlag,
							targetField: targetField,
							nodeId: 0
						}
						//还原操作
						targetField = "";
						ajaxStatus = false;
						//判断是当前操作的是数据映射还是工作流
						if (DataMapOrMigration) {
							ajaxDataMapUpdateXml(dataMapParams);
						} else {
							ajaxUpdateXml(params);
						}
					}
				}).dblclick(function () {
					return false;
				}).appendTo('#' + _div).parent("div").removeAttr("style");
				$('#Select__' + maxId).select2({
					placeholder: '请选择'//默认文字提示
				});
				$('#' + _div).data('editor', this);
			};
			this.destroy = function () {
				$('#' + _div + ' input').each(function () {
					_props[_k].value = $(this).val();
				});
			};
		}
	});

	/***还原文本框样式*/
	function reductionType() {
		var inputID = document.getElementById("" + sessionStorage.getItem("selectID" + yigoflow.config.cacheFileName));
		var buttonID = document.getElementById("B_" + sessionStorage.getItem("selectID" + yigoflow.config.cacheFileName));
		if (inputID && buttonID) {
			inputID.style.width = "100%";
			buttonID.style.display = "none";
		}
	}

	//在面板中修改当前连线的信息，当修改的是关注映射时就去改变连线的样式
	function updateStyle(_k, props) {
		let arr = [];
		if (_k === 'EdgeType') {
			// 获取基本配置
			function getBaseNodeConfig() {
				return Object.assign({}, visoConfig.baseStyle)
			};var config = getBaseNodeConfig();
			if (props[_k].value === 'Focus') {
				publicFalg = true;
				jsPlumb.ready(function () {
					jsPlumb.setContainer('SourceAndTarget');
					var connections = jsPlumb.getAllConnections();
					//先删除连线重新添加新样式的连线
					for (var i in connections) {
						// connections 是线数据数组
						connections[i].sourceId;    // 线的起始html元素的ID
						if (connections[i].sourceId === sourceContainer) {
							arr.push(i);
						}
					}
					let number = 0;
					for (const i in arr) {
						//让储存的数据跟着数据的数据量减少而减少对应数值
						if (number >= 1) {
							arr[i] = parseInt(arr[i]) - number;
						}
						jsPlumb.deleteConnection(connections[arr[i]]); // deleteConnection(@) 删除链接线  @线对象
						number++;
					}
					jsPlumb.addEndpoint(sourceContainer, {
						anchors: ['Right'], uuid: sourceContainer, maxConnections: -1, connectorStyle: {
							strokeWidth: 1.2,
							strokeStyle: 'blue',
							joinstyle: 'round',
							fill: 'pink',
							outlineStroke: 'blue',
							outlineWidth: '',
							dashstyle: "2 4"
						}, connectorHoverStyle: {
							stroke: '#a11e1e',
							strokeStyle: '#a11e1e',
							strokeWidth: 1.2,
							outlineStroke: '#a11e1e',
							outlineColor: ''
						}
					}, config);
					jsPlumb.addEndpoint(targetContainer, {
						anchor: 'Left', uuid: targetContainer, maxConnections: -1
					}, config);
					jsPlumb.connect({uuids: [sourceContainer, targetContainer]});
				})
			} else if (props[_k].value === 'common') {
				publicFalg = false;
				jsPlumb.ready(function () {
					jsPlumb.setContainer('SourceAndTarget');
					var connections = jsPlumb.getAllConnections();
					for (var i in connections) {
						// connections 是线数据数组
						connections[i].sourceId;    // 线的起始html元素的ID
						if (connections[i].sourceId === sourceContainer) {
							arr.push(i);
						}
					}
					let number = 0;
					for (const i in arr) {
						if (number >= 1) {
							arr[i] = parseInt(arr[i]) - number;
						}
						jsPlumb.deleteConnection(connections[arr[i]]); // deleteConnection(@) 删除链接线  @线对象
						number++;
					}
					jsPlumb.addEndpoint(sourceContainer, {
						anchors: ['Right'], uuid: sourceContainer, maxConnections: -1,
					}, config);
					jsPlumb.addEndpoint(targetContainer, {
						anchor: 'Left', uuid: targetContainer, maxConnections: -1
					}, config);
					jsPlumb.connect({uuids: [sourceContainer, targetContainer]});
				})
			}
		}
	}

	/**
	 * 字段面板切换
	 * @param {string} fieldKey
	 * @param {string} fieldCaption
	 */
	function panelSwitching(fieldKey, tableKey, idFlag) {
		yigoflow.config.tableKey = tableKey;
		yigoflow.config.fieldKey = fieldKey;
		//获取操作的面板
		let nodeName = PanelJudge(idFlag);
		//idFlag保存的当前操作的Formkey,可以直接使用
		var _w = $(window).width(), _h = $(window).height(), _r = Raphael(this, _w * 0.99, _h * 0.99);
		new yigoflow.dataMapprops({}, _r);
		$("#yigoflow_dataMapprops_handle").text("字段属性");
		let dataMapParams = {
			formKey: idFlag,
			fieldKey: fieldKey,
			filePath: yigoflow.config.filePath,
			tableKey: tableKey,
			nodeName: nodeName,
			operationType: "field"
		};
		ajaxStatus = false;
		var fieldInfo1 = fieldInfo(dataMapParams);
		if (ajaxStatus) {
			//这两个属性不是公共的有的需要有的不需要所以每次都默认添加不需要的就进行删除
			fieldJson.sourceType = {
				name: 'sourceType', label: '源字段类型', value: 'Field', editor: function () {
					return new yigoflow.editors.selectEditor([{name: '字段', value: "Field"}, {
						name: '常量',
						value: "Const"
					}, {name: '公式', value: "Formula"}]);
				}
			}, fieldJson.sourceFiledType = {
				name: 'sourceFiledType', label: '源字段数据类型', value: '', editor: function () {
					return new yigoflow.editors.inputEditor();
				}
			};
			//当现在点击的字段是目标表单,就去改变lable
			delete fieldJson.fieldKey;
			if (targetFormKey === idFlag) {
				fieldJson.sourceType.label = "目标字段类型";
				fieldJson.sourcekey.label = "目标字段标识";
				fieldJson.sourceCaption.label = "目标字段说明";
				fieldJson.sourceFiledType.label = "目标字段数据类型";
			} else if (sourceFormKey === idFlag) {
				fieldJson.sourceType.label = "源字段类型";
				fieldJson.sourcekey.label = "源字段标识";
				fieldJson.sourceCaption.label = "源字段说明";
				fieldJson.sourceFiledType.label = "源字段数据类型";
				let key = fieldInfo1.data[0].Key;
				if (key){
					fieldJson.fieldKey = {
						name: 'fieldKey', label: '字段标识(Key)', value: '', editor: function () {
							return new yigoflow.editors.inputEditor();
						}
					};
					fieldJson.fieldKey.value = fieldInfo1.data[0].Key;
				}
			} else if (feedbackForm === idFlag) {
				fieldJson.sourcekey.label = "反填字段标识";
				fieldJson.sourceCaption.label = "反填字段说明";
				fieldJson.sourceFiledType.label = "反填字段数据类型";
			}
			fieldJson.sourcekey.value = fieldKey;
			fieldJson.sourceCaption.value = fieldInfo1.data[0].Caption;
			fieldJson.sourceFiledType.value = fieldInfo1.data[0].DataType;
			if (fieldInfo1.data[0].IsPrimary === "true") {
				delete fieldJson.RefFieldKey;
			} else if ((fieldInfo1.data[0].IsPrimary == null || fieldInfo1.data[0].IsPrimary === "false") && targetFormKey != idFlag) {
				fieldJson.RefFieldKey = {
					name: 'RefFieldKey', label: '参照的主表字段标识', value: '', editor: function () {
						return new yigoflow.editors.selectEditor("getRefFieldKey");
					}
				};
				fieldJson.RefFieldKey.value = fieldInfo1.data[0].refFieldKey;
			}
		}
		//删除多余部分
		if (targetFormKey != idFlag && sourceFormKey != idFlag) {
			delete fieldJson.sourceType;
			delete fieldJson.RefFieldKey;
		}
		if (sourceFormKey != idFlag) {
			delete fieldJson.sourceTypeKey;
		}
		//数据迁移不需要数据类型
		if (fieldInfo1.data[0].isMigration === "DataMigration") {
			if ("TargetTableCollection" === nodeName) {
				delete fieldJson.sourceType;
				delete fieldJson.RefFieldKey;
			}
		}
		//用于替换值变化
		if (fieldJson) {
			for (let k in fieldJson) {
				_gprops[k] = {};
				_gprops[k].value = fieldJson[k].value;
			}
		}
		$(_r).trigger('showprops', [fieldJson, {}]);
		var elementById = document.getElementById("psourceType");
		if (elementById) {
			elementById.children[0].disabled = "disabled"
		}
	}

	//判断当前操作的面板是目标面板还是源单面板
	function PanelJudge(idFlag) {
		let nodeName;
		if (sourceFormKey === idFlag) {
			nodeName = "SourceTableCollection";
		} else if (targetFormKey === idFlag) {
			nodeName = "TargetTableCollection";
		} else if (idFlag) {
			nodeName = "FeedbackCollection";
		}
		return nodeName;
	}

	/**
	 * 触发删除按钮方法
	 * @param {string} fieldKey
	 * @param {string} strID
	 * @param {string} formNumber
	 */
	function isEnableDeleteButton(fieldKey, formulaID, tableKey, strID, formNumber, value, idFlag, fieldFlag) {
		let nodeName = PanelJudge(idFlag);
		let dataMapParams = {
			operType: 3,
			filePath: yigoflow.config.filePath,
			tableKey: tableKey,
			fieldKey: fieldKey,
			formKey: idFlag,
			nodeName: nodeName
		};
		deleteField(dataMapParams);
	}

	/**是否显示删除按钮*/
	function isShowdeleteButton(strID) {
		var inputID = document.getElementById("" + strID);
		var buttonID = document.getElementById("B_" + strID);
		if (inputID && buttonID) {
			inputID.style.width = "94%";
			buttonID.style.display = '';
		}
		$("#" + strID).css("background-color", "#5FB878");
		//还原上一个文本框的样式
		if (sessionStorage.getItem("selectID" + yigoflow.config.cacheFileName) != null && strID !== sessionStorage.getItem("selectID" + yigoflow.config.cacheFileName)) {
			reductionType();
		}
		sessionStorage.setItem("selectID" + yigoflow.config.cacheFileName, strID);
	}

	//交换2个DOM节点
	function swapNode(sNode, bNode, bTable) {
		var parent = sNode.parentNode;//父节点
		var swapNode = sNode.nextSibling;//两节点的相对位置
		var beExchangedNode = bNode.nextSibling;
		//如果是插入到最后就用appendChild
		if (swapNode) parent.insertBefore(bNode, swapNode); else parent.appendChild(bNode);
		if (beExchangedNode) parent.insertBefore(sNode, beExchangedNode); else parent.appendChild(sNode);
		let {
			sourceForm, targetForm, sourceTableKey, targetTableKey, sourceField, targetField, feedback
		} = gainData(bNodeClone.id, sNodeClone.id, formArr);
		let dataMapParams = {
			formKey: sourceForm,
			fieldKey: sourceField + "&&" + targetField,
			filePath: yigoflow.config.filePath,
			tableKey: sourceTableKey,
			operationType: feedback,
			targetFormKey: targetForm,
			targetTableKey: targetTableKey
		};
		handleSwapTr(dataMapParams, sourceForm, sourceField, targetField, feedback, targetForm, targetTableKey);
	}

	function swapTr(bNode) {
		bNode.onmousemove = function (e) {
			let offsetWidth = e.toElement.offsetWidth;
			let offsetX = e.offsetX;
			if (offsetX > 40 && offsetX < (offsetWidth - 70)) {
				const el = $(e.target);
				el.css("cursor", "move");
			} else {
				const el = $(e.target);
				el.css("cursor", "crosshair");
				curTr = null;
			}
		}
		bNode.onmouseup = function (e) {
			if (exchange) {
				exchange = false;
				$("#reload").trigger('click');
			}
			const el = $(e.target);
			el.css("cursor", "");
			curTr = null;
		};
		bNode.onmouseover = function (e) {
			let sNode = this;
			sNodeClone = this;
			while (sNode.tagName !== "TR") {
				sNode = sNode.parentNode;
			}
			if (curTr) {
				let sTable = sNode, bTable = curTr;
				while (curTr.tagName !== "TR") {
					curTr = curTr.parentNode;
				}
				while (sTable.nodeName && sTable.nodeName !== "TABLE") {
					sTable = sTable.parentNode;
				}
				while (bTable.nodeName && bTable.nodeName !== "TABLE") {
					bTable = bTable.parentNode;
				}
				// 获取所有TableKey所在的下标位置
				let rows = bTable.rows, arrIndex = [];
				for (let i = 0; i < rows.length; i++) {
					if (rows[i].className) {
						arrIndex.push(rows[i].rowIndex);
					}
				}
				// 最后一个表的区间内就是这个表下标到row的长度
				arrIndex.push(rows.length + 1);
				let isInTheSameTableKey = false;
				if (arrIndex.length > 1) {
					for (let i = 0; i < arrIndex.length; i++) {
						if (i + 1 <= arrIndex.length) {
							// 保证两个在同一个tablekey 里面移动
							if (parseInt(arrIndex[i]) < parseInt(sNode.rowIndex) && parseInt(arrIndex[i]) < parseInt(curTr.rowIndex) && parseInt(sNode.rowIndex) < parseInt(arrIndex[i + 1]) && parseInt(curTr.rowIndex) < parseInt(arrIndex[i + 1])) {
								isInTheSameTableKey = true;
								break;
							}
						}
					}
				} else {
					isInTheSameTableKey = true;
				}
				// 不能跨面板  要在同一个tablekey里面移动   没有变化也不触发
				if (sTable.id === bTable.id && isInTheSameTableKey && curTr.id !== sNode.id) {
					swapNode(sNode, curTr, bTable);
				}
			}
		}
	}

	/**
	 * 判断是否清除连线样式
	 * */
	function cleanStyle(e) {
		let offsetWidth = e.toElement.offsetWidth;
		let offsetX = e.offsetX;
		if (offsetX > 40 && offsetX < (offsetWidth - 70)) {
			bNodeClone = this;
			curTr = this;
			this.onmousemove = function () {
				let byId = $("div[elid='" + this.id + "']")[0];
				if (byId) {
					// 删除默认添加的连线样式
					byId.nextSibling.nextSibling.nextSibling.parentNode.removeChild(byId.nextSibling.nextSibling);
					byId.nextSibling.nextSibling.parentNode.removeChild(byId.nextSibling.nextSibling);
					byId.nextSibling.parentNode.removeChild(byId.nextSibling);
					byId.parentNode.removeChild(byId);
				}
			}
		} else {
			// 清除事件防止多次触发
			this.onmousemove = null;
		}
	}

	/**
	 * 删除操作处理方法
	 * @param {*} fieldKey 当前操作的字段
	 * @param {*} tableKey 当前操作的table
	 * @param {number|string} formNumber
	 * @param {*} value
	 */
	function deleteOperation(fieldKey, tableKey, formNumber, value, formulaID, idFlag, fieldFlag, FormulaOrCoustfiled) {
		//当点击文本框的时候显示删除按钮
		$("#" + fieldFlag + fieldKey + tableKey).unbind('mousedown').mousedown(function (e) {
			panelSwitching.call(this, fieldKey, tableKey, idFlag);
			let strID = fieldFlag + fieldKey + tableKey;
			isShowdeleteButton(strID);
			cleanStyle.call(this, e);
		});
		//给删除按钮增加点击事件
		$("#B_" + fieldFlag + fieldKey + tableKey).unbind('click').click(function () {
			let strID = fieldFlag + fieldKey + tableKey;
			isEnableDeleteButton(fieldKey, undefined, tableKey, strID, formNumber, value, idFlag, fieldFlag);
		});
		//移动到文本框上方改变文本框颜色(普通字段)
		$("#" + fieldFlag + fieldKey + tableKey).unbind('mouseenter').mouseenter(function () {
			$("#" + fieldFlag + fieldKey + tableKey).css("background-color", "#1E9FFF");
		});
		//离开清除背景颜色(普通字段)
		$("#" + fieldFlag + fieldKey + tableKey).unbind('mouseleave').mouseleave(function () {
			$("#" + fieldFlag + fieldKey + tableKey).css("background-color", "");
		});
		//公式字段和常量字段处理方法，和普通字段有点不同所一另做处理    公式字段和常量字段的点击事件
		if (formulaID) {
			let key;
			$("#" + formulaID).unbind('mousedown').mousedown(function (e) {
				curTr = this;
				bNodeClone = this;
				cleanStyle.call(this, e);
				let nodeName = PanelJudge(idFlag);
				let str = "";
				let strConcat = str.concat("" + formNumber + "_@_" + "", "" + $("#" + formulaID)[0].placeholder + "_@_" + "", "" + "  " + "_@_" + "", "" + tableKey + "_@_", "" + idFlag + "");
				fieldKey = $("#" + formulaID)[0].placeholder;
				//获取当前点击的公式或者常量在对象中的位置
				for (let _k in _sourceProps) {
					if (_sourceProps[_k].Definition === strConcat) {
						key = _k;
					}
				}
				let strID = formulaID;
				sessionStorage.setItem("ConstAndFormulaID" + yigoflow.config.cacheFileName, strID);
				yigoflow.config.tableKey = tableKey;
				yigoflow.config.fieldKey = fieldKey;
				isShowdeleteButton(strID);
				var _w = $(window).width(), _h = $(window).height(), _r = Raphael(this, _w * 0.99, _h * 0.99);
				$("#yigoflow_dataMapprops_handle").text("字段属性");
				let dataMapParams = {
					formKey: idFlag,
					fieldKey: fieldKey,
					filePath: yigoflow.config.filePath,
					tableKey: tableKey,
					nodeName: nodeName,
					operationType: "ConstAndFormula"
				};
				ajaxStatus = false;
				var fieldInfo1 = fieldInfo(dataMapParams);
				if (ajaxStatus) {
					//根据不同面板去改变Lable
					if (nodeName === "TargetTableCollection") {
						delete ConstAndFormula.fieldKey;
						delete ConstAndFormula.sourceTypeKey;
						delete ConstAndFormula.RefFieldKey;
						ConstAndFormula.sourceType.label = "目标字段类型";
						ConstAndFormula.sourceContent.label = "目标字段内容";
					} else if (nodeName === "SourceTableCollection") {
						delete ConstAndFormula.fieldKey;
						let key1 = fieldInfo1.data[0].Key;
						if (key1){
							ConstAndFormula.fieldKey = {
								name: 'fieldKey', label: '字段标识(Key)', value: '', editor: function () {
									return new yigoflow.editors.inputEditor();
								}
							};
							ConstAndFormula.fieldKey.value = fieldInfo1.data[0].Key;
						}
						ConstAndFormula.sourceType.label = "源字段类型";
						ConstAndFormula.sourceContent.label = "源字段内容";
					}
					ConstAndFormula.sourceType.value = fieldInfo1.data[0].type;
					ConstAndFormula.sourceContent.value = fieldKey;

					if ((fieldInfo1.data[0].IsPrimary === "false" || fieldInfo1.data[0].IsPrimary === null) && nodeName === "SourceTableCollection") {
						ConstAndFormula.RefFieldKey = {
							name: 'RefFieldKey', label: '参照的主表字段标识', value: '', editor: function () {
								return new yigoflow.editors.selectEditor("getRefFieldKey");
							}
						};
						ConstAndFormula.RefFieldKey.value = fieldInfo1.data[0].refFieldKey;
					}else if (fieldInfo1.data[0].IsPrimary === "true"){
						delete ConstAndFormula.RefFieldKey;
					}
				}
				if (ConstAndFormula) {
					for (let k in ConstAndFormula) {
						_gprops[k] = {};
						_gprops[k].value = ConstAndFormula[k].value;
					}
				}
				new yigoflow.dataMapprops({}, _r);
				$(_r).trigger('showprops', [ConstAndFormula, {}]);
				var elementById = document.getElementById("psourceType");
				elementById.children[0].disabled = "disabled"
			});
			//公式和常量字段因为回填的原因所以需要监听值变化事件
			$("#" + formulaID).unbind('change').change(function () {
				let str = "";
				let strConcat = str.concat("" + formNumber + "_@_" + "", "" + $("#" + formulaID)[0].placeholder + "_@_" + "", "" + "  " + "_@_" + "", "" + tableKey + "_@_", "" + idFlag + "");
				// 源表单公式修改
				for (const key in _sourceProps) {
					if (sessionStorage.getItem("oldValue" + yigoflow.config.cacheFileName) && _sourceProps[key].Definition.indexOf(sessionStorage.getItem("oldValue")) !== -1) {
						_sourceProps[key].Definition = strConcat;
					}
				}
				// 目标表单公式修改
				for (const targetKey in _targetProps) {
					let MapValue = _targetProps[targetKey].Definition;
					let Value = _targetProps[targetKey].FieldKey;
					let b = MapValue !== undefined ? MapValue.indexOf(sessionStorage.getItem("oldValue" + yigoflow.config.cacheFileName)) !== -1 : Value.indexOf(sessionStorage.getItem("oldValue" + yigoflow.config.cacheFileName)) !== -1;
					if (sessionStorage.getItem("oldValue" + yigoflow.config.cacheFileName) && b) {
						_targetProps[targetKey].Definition = strConcat;
					}
				}
			});
			$("#B_" + formulaID).unbind('click').click(function () {
				let strID = formulaID;
				isEnableDeleteButton(FormulaOrCoustfiled, formulaID, tableKey, strID, formNumber, value, idFlag, fieldFlag);
			});
			//移动到文本框上方改变文本框颜色(公式或常量字段)
			$("#" + formulaID).unbind('mouseenter').mouseenter(function () {
				$("#" + formulaID).css("background-color", "#1E9FFF");
			});
			//离开清除背景颜色(公式或常量字段)
			$("#" + formulaID).unbind('mouseleave').mouseleave(function () {
				$("#" + formulaID).css("background-color", "");
			});
		}
		// 增加移动tr
		let bNode = document.getElementById(fieldFlag + fieldKey + tableKey);
		if (bNode) {
			swapTr(bNode);
		} else {
			bNode = document.getElementById(formulaID);
			if (bNode) {
				swapTr(bNode);
			}
		}
	}

	/**添加文本框（追加的字段，即当前table在页面上已经显示）*/
	function getS(formNumber, fieldKey, tableKey, fieldCaption, formulaID, fieldFlag, isSpecialField, FormulaOrCoustfiled, tableIsNullNumber) {
		if (formulaID && formNumber != -1) {
			return '<tr id="F_' + formulaID + '"><td><input style="Float:left;width:100%;height: 22px;" ' + 'id= "' + formulaID + '" class ="inputField" readonly="readonly" placeholder="' + FormulaOrCoustfiled + '">' + '<button type="button" id="B_' + formulaID + '" class = "buttonStyle" style="Float:left;width:6%;height: 24px;display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>';
		} else if (isSpecialField) {
			return '<tr id="F_' + idFlag + fieldKey + '"><td><input style="Float:left;width:100%;height: 22px;" ' + 'id= "' + fieldFlag + fieldKey + tableKey + '" class ="SpecialinputField" readonly="readonly" placeholder="' + fieldKey + "  " + fieldCaption + '">' + '<button type="button" id="B_' + fieldFlag + fieldKey + tableKey + '" class = "buttonStyle" style="Float:left;width:6%;height: 24px;' + 'display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>';
		} else if (formNumber === -1) {
			return '<tr id="' + fieldFlag + tableIsNullNumber + '"><td><input style="Float:left;width:100%;height: 22px;background-color: RGB(255,245,225)" ' + 'id= "' + fieldFlag + fieldKey + '" class ="inputField" readonly="readonly" placeholder="' + fieldKey + '">' + '<button type="button" id="B_' + fieldFlag + fieldKey + '" class = "buttonStyle" style="Float:left;width:6%;height: 24px;' + 'display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>';
		} else {
			return '<tr id="F_' + idFlag + fieldKey + '"><td><input style="Float:left;width:100%;height: 22px;" ' + 'id= "' + fieldFlag + fieldKey + tableKey + '" class ="inputField" readonly="readonly" placeholder="' + fieldKey + "  " + fieldCaption + '">' + '<button type="button" id="B_' + fieldFlag + fieldKey + tableKey + '" class = "buttonStyle"style="Float:left;width:6%;height: 24px;' + 'display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>';
		}
	}

	/**添加文本框（当前tablekey在页面上还未添加，在同时添加字段的时候去添加tablekey）*/
	function getS1(formNumber, fieldKey, tableKey, fieldCaption, fieldFlag, formulaID, isSpecialField, FormulaOrCoustfiled) {
		if (formulaID) {
			return '<tr id="' + fieldFlag + formNumber + '"><td><input style="Float:left;width:100%;height: 22px;" ' + 'id= "' + formulaID + '" class ="inputField" readonly="readonly" placeholder="' + FormulaOrCoustfiled + '">' + '<button type="button" id="B_' + formulaID + '" class = "buttonStyle" style="Float:left;width:6%;height: 24px;' + 'display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>';
		} else if (isSpecialField) {
			return '<tr id="' + fieldFlag + formNumber + '"><td><input style="Float:left;width:100%;height: 22px;" ' + 'id= "' + fieldFlag + fieldKey + tableKey + '" class ="SpecialinputField" readonly="readonly" placeholder="' + fieldKey + "  " + fieldCaption + '">' + '<button type="button" id="B_' + fieldFlag + fieldKey + tableKey + '" class = "buttonStyle" style="Float:left;width:6%;height: 24px;' + 'display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>';
		} else if (formNumber === -1) {
			return '<tr id="' + fieldFlag + formNumber + '"><td><input style="Float:left;width:100%;height: 22px;background-color: RGB(255,245,225)" ' + 'id= "' + fieldFlag + fieldKey + '" class ="inputField" readonly="readonly" placeholder="' + fieldKey + '">' + '<button type="button" id="B_' + fieldFlag + fieldKey + '" class = "buttonStyle" style="Float:left;width:6%;height: 24px;' + 'display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>';
		} else {
			return '<tr id="' + fieldFlag + formNumber + '"><td><input style="Float:left;width:100%;height: 22px;" ' + 'id= "' + fieldFlag + fieldKey + tableKey + '" class ="inputField" readonly="readonly" placeholder="' + fieldKey + "  " + fieldCaption + '">' + '<button type="button" id="B_' + fieldFlag + fieldKey + tableKey + '" class = "buttonStyle" style="Float:left;width:6%;height: 24px;' + 'display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>';
		}
	}

	/**切换效果过度*/
	function transitionEffect(tableKey, elementById) {
		if (sessionStorage.getItem("tableKey" + yigoflow.config.cacheFileName) != null && tableKey !== sessionStorage.getItem("tableKey" + yigoflow.config.cacheFileName)) {
			let inputID = document.getElementById("add" + sessionStorage.getItem("tableKey" + yigoflow.config.cacheFileName));
			let selectID = document.getElementById("selectID" + sessionStorage.getItem("tableKey" + yigoflow.config.cacheFileName));
			let buttonID = document.getElementById("buttonID" + sessionStorage.getItem("tableKey" + yigoflow.config.cacheFileName));
			if (inputID && elementById && buttonID) {
				inputID.style.display = "";
				selectID.style.display = "none";
				buttonID.style.display = "none";
				$("#add" + sessionStorage.getItem("tableKey" + yigoflow.config.cacheFileName)).next().next().css("display", "none");
			}
		}
	}

	/**
	 * 文本框，按钮等一些点击事件处理方法
	 * */
	function eventHandling(tableKey, idFlag) {
		//给文本框绑定点击事件
		$("#add" + idFlag + tableKey).click(function () {
			reductionType();
			var inputID = document.getElementById("add" + idFlag + tableKey);
			if (inputID != null) {
				if (inputID.style.display == '') {
					sle = $('<select style="width:90%;height: 26px;display: none;" class="form-control" id="selectID' + idFlag + tableKey + '"/>' + '<input type="button" id="buttonID' + idFlag + tableKey + '"  ' + 'style="width: 10%;height: 29px;border-radius: 10%" name="button" value="..." />');
					selectEdit("getTableKeyField", sle, tableKey, idFlag);
					$("#add" + idFlag + tableKey).after(sle);
					$("#selectID" + idFlag + tableKey).select2();
					let elementById = document.getElementById("selectID" + idFlag + tableKey);
					//给下拉框绑定值变化事件
					$("#selectID" + idFlag + tableKey).change(function () {
						//获取当前选中的下拉框值
						var index = elementById.selectedIndex;
						let selectValue = elementById.options[index].value;
						// 文件路径
						let filePath = yigoflow.config.filePath;
						let nodeName = PanelJudge(idFlag);
						//调用ajax进行后台数据处理
						let params = {
							operType: 0,
							filePath: filePath,
							content: "{key:'" + "formField" + "',value:'" + selectValue + "'}",
							nodeName: nodeName,
							nodeId: 0
						};
						ajaxDataMapUpdateXml(params);
					});
					//给按钮绑定点击事件
					$("#buttonID" + idFlag + tableKey).click(function () {
						var table = layui.table;
						var layer = layui.layer;
						let nodeName = PanelJudge(idFlag);
						var dataMapParams = {
							operType: 0,
							filePath: yigoflow.config.filePath,
							formKey: idFlag,
							nodeName: nodeName,
							tableKey: tableKey
						};
						getfindTabaleKeyField(dataMapParams);
						//渲染数据表格显示表单字段
						formField(table, DataMapDataJson, layer);
						$("#operationCollectionId").show();
						$("#dialog").dialog({
							autoOpen: true, width: 713, height: 600, modal: true, resizable: false, buttons: {
								"确定": function (e) {
									var _thisDiag = $(this);
									var checkStatus = table.checkStatus('formFieldOpen'), data = checkStatus.data;
									for (let i = 0; i < data.length; i++) {//移除已经添加的字段
										let datum = data[i];
										if (datum.checked) {
											data.splice(i, 1);//将使后面的元素依次前移，数组长度减1
											i--; // 如果不减，将漏掉一个元素
										}
									}
									if (data.length == 0) {
										_thisDiag.dialog("close");
										return;
									}
									//将数据转换为数组
									var data2 = [];
									for (let i in data) {
										let o = {};
										o[i] = data[i];
										data2.push(o)
									}
									//拼接字符串
									let str = "", arr = [];
									data2.map(function (value, index, data2) {
										var number = value[index].DataSource.replace(/[^0-9]/ig, ""),
											key = value[index].Key, caption = value[index].Caption;
										var strconcat = str.concat("" + number + "_@_" + "", "" + key + "_@_" + "", "" + caption + "_@_" + "", "" + tableKey + "_@_", "" + sessionStorage.getItem("formKey" + yigoflow.config.cacheFileName) + "");
										arr.push(strconcat);
									});
									let filePath = yigoflow.config.filePath;
									let nodeName = PanelJudge(sessionStorage.getItem("formKey" + yigoflow.config.cacheFileName));
									//调用ajax进行后台数据处理
									let params = {
										operType: 0,
										filePath: filePath,
										content: "{key:'" + "formField" + "',value:'" + arr + "'}",
										nodeName: nodeName,
										batchAddArr: arr,
										nodeId: 0
									};
									ajaxDataMapUpdateXml(params);
									_thisDiag.dialog("close");
								}, "取消": function (e) {
									var _thisDiag = $(this);
									_thisDiag.dialog("close");
								}
							}
						})
					});
					elementById.style.display = '';
					inputID.style.display = 'none';
					transitionEffect(idFlag + tableKey, elementById);
					sessionStorage.setItem("tableKey" + yigoflow.config.cacheFileName, idFlag + tableKey);
					sessionStorage.setItem("nodeName" + yigoflow.config.cacheFileName, "SourceTableCollection");
				}
			}
		});
		//给表文本框添加点击事件
		$("#" + idFlag + tableKey).click(function () {
			//保存当前点击的tableKey
			yigoflow.config.tableKey = tableKey;
			//获取当前操作的面板
			let nodeName = PanelJudge(idFlag);
			var formKey = $("#" + idFlag + tableKey)[0].parentNode.offsetParent.id.split("__")[1];
			var _w = $(window).width(), _h = $(window).height(), _r = Raphael(this, _w * 0.99, _h * 0.99);
			$("#yigoflow_dataMapprops_handle").text("表属性");
			let dataMapParams = {
				formKey: formKey,
				filePath: yigoflow.config.filePath,
				tableKey: tableKey,
				nodeName: nodeName,
				operationType: "table"
			};
			ajaxStatus = false;
			var fieldInfo1 = fieldInfo(dataMapParams);
			if (ajaxStatus) {
				tableJson.IsPrimary = {
					name: 'IsPrimary', label: '是否为主表', value: 'false', editor: function () {
						return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {
							name: '否',
							value: "false"
						}]);
					}
				};
				if (targetFormKey === idFlag) {
					tableJson.Key.label = "目标表标识";
					tableJson.sourceCaption.label = "目标表说明";
					tableJson.IsPrimary.label = "是否主表";
					tableJson.RowTrigger = {
						name: 'RowTrigger', label: '行触发', value: '', editor: function () {
							return new yigoflow.editors.inputEditor();
						}
					};
					delete tableJson.TargetTableKey;
				} else if (sourceFormKey === idFlag) {
					tableJson.Key.label = "源表标识";
					tableJson.sourceCaption.label = "源表说明";
					tableJson.TargetTableKey = {
						name: 'TargetTableKey', label: '目标表标识', value: '', editor: function () {
							return new yigoflow.editors.selectEditor("getTargetTableList");
						}
					};
					tableJson.TargetTableKey.value = fieldInfo1.data[0].TargetTableKey;
					tableJson.IsPrimary.label = "是否主表";
					delete tableJson.RowTrigger;
				} else if (feedbackForm === idFlag) {
					tableJson.Key.label = "反填表标识";
					tableJson.sourceCaption.label = "反填表说明";
				}
				tableJson.Key.value = fieldInfo1.data[0].tableKey;
				tableJson.sourceCaption.value = fieldInfo1.data[0].tableCaption;
				if (feedbackForm != idFlag) {
					tableJson.IsPrimary.value = fieldInfo1.data[0].IsPrimary;
				}
				//当是主表的时候就多添加一个属性，不是的话就将这个属性删除
				if (targetFormKey === idFlag) {
					tableJson.RowTrigger.value = fieldInfo1.data[0].RowTrigger;
				}
				if (fieldInfo1.data[0].IsPrimary === 'true' && sourceFormKey === idFlag) {
					tableJson.DataMapCondition = {
						name: 'DataMapCondition', label: '下推执行条件', value: '', editor: function () {
							return new yigoflow.editors.inputEditor();
						}
					};
					tableJson.DataMapCondition.value = fieldInfo1.data[0].Condition;
				} else {
					delete tableJson.DataMapCondition
				}
			}
			//去删除多余的部分
			if (feedbackForm === idFlag) {
				delete tableJson.IsPrimary;
				delete tableJson.TargetTableKey;
				delete tableJson.RowTrigger;
			}
			//删除数据迁移不需要的字段
			if (fieldInfo1.data[0].isMigration === "DataMigration") {
				delete tableJson.DataMapCondition;
				delete tableJson.TargetTableKey;
				delete tableJson.RowTrigger;
				if ("TargetTableCollection" === nodeName) {
					delete tableJson.IsPrimary;
				}
			}
			new yigoflow.dataMapprops({}, _r);
			if (tableJson) {
				for (let k in tableJson) {
					_gprops[k] = {};
					_gprops[k].value = tableJson[k].value;
				}
			}
			$(_r).trigger('showprops', [tableJson, {}]);
		});
	}

	/**表名文本框添加**/
	function getS2(formNumber, tableKey, idFlag) {
		//反填表单不需要公式字段和常量字段
		if (!publicFalg && formNumber != -1) {
			return '<tr class = "' + idFlag + '" id="' + idFlag + formNumber + '"><td><input' +
				' style="Float:left;width:94%;height: 24px;" ' + 'id= "' + idFlag + tableKey + '" class' +
				' ="inputTable" readonly="readonly" placeholder="表(' + formNumber + ")  " + tableKey + '">' + '<select id="Select_' + idFlag + tableKey + '" class = "selectStyle" style="Float:left;width:6%;height: 26px;">' + '<option></option>' + '<option value="Const">添加Const类型字段</option>' + '<option value="Formula">添加Formula类型字段</option>'  + '</select></input>' + '</td></tr>';//+ '<option value="CustomField">添加自定义字段</option>'
		} else if (formNumber === -1) {
			return '<tr class = "' + idFlag + '" id="' + idFlag + formNumber + '"><td><input' +
				' style="Float:left;width:94%;height: 24px" ' + 'id= "' + idFlag + tableKey + '" class ="noTableKey"' +
				' readonly="readonly" placeholder="表(' + formNumber + ')">' + '<select id="Select_' + idFlag + tableKey + '" class = "selectStyle"  style="Float:left;width:6%;height: 26px;">' + '<option></option>' + '<option value="Const">添加Const类型字段</option>' + '<option value="Formula">添加Formula类型字段</option>'  + '</select></input>' + '</td></tr>';//+ '<option value="CustomField">添加自定义字段</option>'
		} else {
			return '<tr class = "' + idFlag + '" id="' + idFlag + formNumber + '"><td><input style="Float:left;width:100%;height: 24px;" ' + 'id= "' + idFlag + tableKey + '" class ="inputTable" readonly="readonly" placeholder="表(' + formNumber + ")  " + tableKey + '">' + '</td></tr>';
			publicFalg = false;
		}
	}

	/**处理常量字段和公式字段*/
	function constAndFormula(tableKey, formNumber, idFlag, FormulaOrCoustfiled) {
		let id;
		if(sourceTableAttr && sourceTableAttr[tableKey] && sourceTableAttr[tableKey]["Type"] == "SERVICE"){
			$("#Select_" + idFlag + tableKey).children("option[value='Formula']").remove();
		}
		$("#Select_" + idFlag + tableKey).change(function () {
			let number = 1;
			var elementById = document.getElementById("Select_" + idFlag + tableKey);
			var index = elementById.selectedIndex;
			let selectValue = elementById.options[index].value;
			if (selectValue) {
				let rows = $("#Table__" + idFlag)[0].rows, arr = [], K_arr = [], isadded = false;
				while ($("#F_" + tableKey + idFlag + number)[0] && $("#F_" + tableKey + idFlag + number)[0].id) {
					number++;
				}
				id = "F_" + tableKey + idFlag + number;
				for (var key in rows) {
					arr.push(rows[key]);
				}
				//获取页面上现在有几张表
				for (index in arr) {
					if (arr[index].id && arr[index].id.indexOf('' + idFlag) !== -1 && (arr[index].id.indexOf("F_") && arr[index].id.indexOf("i_") && arr[index].id.indexOf("F_")) === -1) {
						//有些表单中是数字结尾
						K_arr.push(parseInt(arr[index].id.split(idFlag)[1].replace(/[^0-9]/ig, "")));
					}
				}
				if (selectValue === "Const") {
					if (K_arr.length === 1) {
						$("#Table__" + idFlag).append('<tr id="F_' + selectValue + rowIndex + '"><td><input style="Float:left;width:100%;height: 22px;" id="' + id + '" class ="inputField" readonly="readonly">' + '<button type="button" id="B_' + id + '"  class = "buttonStyle" style="Float:left;width:6%;height: 24px;display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>');
					} else {
						for (var num in K_arr) {
							if (K_arr[num] > formNumber) {
								//使用下标来做唯一标识
								rowIndex = rows["" + idFlag + K_arr[num]].rowIndex;
								$("#" + idFlag + K_arr[num]).before('<tr id="F_' + id + '"><td><input style="Float:left;width:100%;height: 22px;" id="' + id + '" class ="inputField" readonly="readonly">' + '<button type="button" id="B_' + id + '" class = "buttonStyle" style="Float:left;width:6%;height: 24px;display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>');
								isadded = true;
								break;
							}
						}
						//上述条件都不满足的话就加在最后面
						if (!isadded) {
							$("#Table__" + idFlag).append('<tr id="F_' + id + '"><td><input style="Float:left;width:100%;height: 22px;" id="' + id + '" class ="inputField" readonly="readonly">' + '<button type="button" id="B_' + id + '" class = "buttonStyle" style="Float:left;width:6%;height: 24px;display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>');
						}
					}
				} else if (selectValue === "Formula") {
					if (K_arr.length === 1) {
						$("#Table__" + idFlag).append('<tr><td><input style="Float:left;width:100%;height: 22px;" id="' + id + '" class ="inputField" readonly="readonly">' + '<button type="button" id="B_' + id + '" class = "buttonStyle" style="Float:left;width:6%;height: 24px;display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>');
					} else {
						for (var num in K_arr) {
							if (K_arr[num] > formNumber) {
								rowIndex = rows["" + idFlag + K_arr[num]].rowIndex;
								$("#" + idFlag + K_arr[num]).before('<tr id="F_' + id + '"><td><input style="Float:left;width:100%;height: 22px;" id="' + id + '" class ="inputField" readonly="readonly">' + '<button type="button" id="B_' + id + '" class = "buttonStyle"  style="Float:left;width:6%;height: 24px;display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>');
								isadded = true;
								break;
							}
						}
						if (!isadded) {
							$("#Table__" + idFlag).append('<tr id="F_' + id + '"><td><input style="Float:left;width:100%;height: 22px;" id="' + id + '" class ="inputField" readonly="readonly">' + '<button type="button" id="B_' + id + '"  class = "buttonStyle" style="Float:left;width:6%;height: 24px;display: none" class="layui-btn layui-btn-primary layui-btn-sm">\n' + '    <i class="layui-icon">&#xe640;</i>\n' + '  </button></input></td></tr>');
						}
					}
				} else if (selectValue == "CustomField") {
					let avr = formNumber + "_@_" + "NewCustomField" + "_@_" + "自定义字段" + "_@_" + tableKey + "_@_" + idFlag;
					// 文件路径
					let filePath = yigoflow.config.filePath;
					let nodeName = PanelJudge(idFlag);
					let dataMapParams = {
						operType: 0,
						filePath: filePath,
						content: "{key:'" + "targetFormField" + "',value:'" + avr + "',tableKey:'" + yigoflow.config.tableKey + "'" + ",fieldKey:'" + yigoflow.config.fieldKey + "'" + ",targetField:'" + yigoflow.config.targetKey + "'}",
						nodeName: nodeName,
						formKey: idFlag,
						targetField: targetField,
						nodeId: 0
					}
					//还原操作
					targetField = "";
					ajaxDataMapUpdateXml(dataMapParams);
				}
			}
			//给公式和常量字段添加点击事件
			$("#F_" + tableKey + idFlag + number).mousedown(function () {
				if ($("#F_" + tableKey + idFlag + number)[0].placeholder != "") {
					isShowdeleteButton("F_" + tableKey + idFlag + number);
				}
				//获取当前操作的面板
				let nodeName = PanelJudge(idFlag);
				yigoflow.config.tableKey = tableKey;
				sessionStorage.setItem("nodeName" + yigoflow.config.cacheFileName, nodeName);
				sessionStorage.setItem("Type" + yigoflow.config.cacheFileName, selectValue);
				sessionStorage.setItem("ConstAndFormulaID" + yigoflow.config.cacheFileName, "F_" + tableKey + idFlag + number);
				var _w = $(window).width(), _h = $(window).height(), _r = Raphael(this, _w * 0.99, _h * 0.99);
				$("#yigoflow_dataMapprops_handle").text("字段属性");
				let dataMapParams = {
					formKey: idFlag,
					fieldKey: FormulaOrCoustfiled,
					filePath: yigoflow.config.filePath,
					tableKey: tableKey,
					nodeName: nodeName,
					operationType: "ConstAndFormula"
				};
				ajaxStatus = false;
				var fieldInfo1 = fieldInfo(dataMapParams);
				//如果是目标表单面板就去改变Lable
				delete ConstAndFormula.fieldKey;
				delete ConstAndFormula.RefFieldKey;
				if (nodeName === "TargetTableCollection") {
					ConstAndFormula.sourceType.label = "目标字段类型";
					ConstAndFormula.sourceContent.label = "目标字段内容";
				} else if (nodeName === "SourceTableCollection") {
					ConstAndFormula.sourceType.label = "源字段类型";
					ConstAndFormula.sourceContent.label = "源字段内容";
				}
				if (ajaxStatus) {
					if (fieldInfo1.data[0].IsPrimary === "false" && nodeName === "SourceTableCollection") {
						ConstAndFormula.RefFieldKey = {
							name: 'RefFieldKey', label: '参照的主表字段标识', value: '', editor: function () {
								return new yigoflow.editors.selectEditor("getRefFieldKey");
							}
						};
					}
				}
				ConstAndFormula.sourceType.value = selectValue;
				ConstAndFormula.sourceContent.value = $("#" + "F_" + tableKey + idFlag + number)[0].placeholder;
				new yigoflow.dataMapprops({}, _r);
				if (ConstAndFormula) {
					for (let k in ConstAndFormula) {
						_gprops[k] = {};
						_gprops[k].value = ConstAndFormula[k].value;
					}
				}
				$(_r).trigger('showprops', [ConstAndFormula, {}]);
				var elementById = document.getElementById("psourceType");
				elementById.children[0].disabled = "disabled"
			});
			let str = "";
			$("#" + "F_" + tableKey + idFlag + number).change(function () {
				//移动到文本框上方改变文本框颜色(普通字段)
				$("#" + "F_" + tableKey + idFlag + number).mouseenter(function () {
					$("#" + "F_" + tableKey + idFlag + number).css("background-color", "#1E9FFF");
				});
				//离开清除背景颜色(普通字段)
				$("#" + "F_" + tableKey + idFlag + number).mouseleave(function () {
					$("#" + "F_" + tableKey + idFlag + number).css("background-color", "");
				});
				let strConcat = str.concat("" + formNumber + "_@_" + "", "" + $("#" + "F_" + tableKey + idFlag + number)[0].placeholder + "_@_" + "", "" + "  " + "_@_" + "", "" + tableKey + "_@_" + "", "" + idFlag + "");
				let nodeName = PanelJudge(idFlag);
				let oldValue;
				// 更新一下sessionStorage
				if (nodeName === "SourceTableCollection") {
					//里面有值的话就是更新操作，先删除原来的再添加新的
					oldValue = sessionStorage.getItem("oldValue" + yigoflow.config.cacheFileName);
					if (oldValue) {
						for (const Key in _sourceProps) {
							let key = _sourceProps[Key].Definition.split("_@_")[1];
							if (key === oldValue) {
								delete _sourceProps[Key];
							}
						}
					}
					_gprops["formField"].value = strConcat;
				} else if (nodeName === "TargetTableCollection") {
					oldValue = _gprops["targetFormField"].value;
					//里面有值的话就是更新操作，先删除原来的再添加新的
					if (oldValue != "" || oldValue != null) {
						for (const Key in _targetProps) {
							if (_targetProps[Key].Definition === oldValue) {
								delete _targetProps[Key];
							}
						}
					}
					_gprops["targetFormField"].value = strConcat;
				}
				//增加按钮点击事件
				$("#B_" + "F_" + tableKey + idFlag + number).click(function () {
					let fieldKey = $("#" + "F_" + tableKey + idFlag + number)[0].placeholder;
					let formulaID = "F_" + tableKey + idFlag + number;
					isEnableDeleteButton(fieldKey, formulaID, tableKey, formulaID, formNumber, strConcat, idFlag);
				});
				setTimeout(function () {
					$("#reload").trigger('click');
				}, 1);
				//清空
				sessionStorage.removeItem("oldValue" + yigoflow.config.cacheFileName);
			});
			// 清空值
			$("#Select_" + idFlag + tableKey)[0].value = "";
		});
	}

	function appendInput(fieldFlag, fieldKey, tableKey, formNumber, fieldCaption, formulaID, isSpecialField, FormulaOrCoustfiled) {
		let tableLength = $("." + idFlag).length;
		if (!$("#" + fieldFlag + fieldKey + tableKey).attr("id")) {
			if (tableLength <= 1) {
				$("#Table__" + idFlag).append(getS(formNumber, fieldKey, tableKey, fieldCaption, formulaID, fieldFlag, isSpecialField, FormulaOrCoustfiled, tableIsNullNumber))
			} else {
				let arr = $("." + idFlag);
				for (const arrKey in arr) {
					if (idFlag + formNumber === arr[arrKey].id) {
						let nextId = !arr[parseInt(arrKey) + 1] ? null : arr[parseInt(arrKey) + 1].id;
						// 当前table 是否是最后一个
						if (nextId) {
							if (formulaID && !$("#" + fieldFlag + formulaID).attr("id")) {//当fieldKey相同时只添加一个
								$("#" + nextId).before(getS(formNumber, fieldKey, tableKey, fieldCaption, formulaID, fieldFlag, isSpecialField, FormulaOrCoustfiled, tableIsNullNumber));
							} else {
								$("#" + nextId).before(getS(formNumber, fieldKey, tableKey, fieldCaption, formulaID, fieldFlag, isSpecialField, FormulaOrCoustfiled, tableIsNullNumber))
							}
						} else {
							if (formulaID && !$("#" + fieldFlag + formulaID).attr("id")) {//当fieldKey相同时只添加一个
								$("#Table__" + idFlag).append(getS(formNumber, fieldKey, tableKey, fieldCaption, formulaID, fieldFlag, isSpecialField, FormulaOrCoustfiled, tableIsNullNumber));
							} else {
								$("#Table__" + idFlag).append(getS(formNumber, fieldKey, tableKey, fieldCaption, formulaID, fieldFlag, isSpecialField, FormulaOrCoustfiled, tableIsNullNumber))
							}
						}
					}
				}
			}
		}
	}

	/**动态添加文本框*/
	function addDataMapHtml(value, isNew) {
		let formNumber = value.split("_@_")[0], tableKey = value.split("_@_")[3], fieldKey = value.split("_@_")[1],
			fieldCaption = value.split("_@_")[2], formulaID = undefined, inputFlag = "", fieldFlag = "",
			FormulaOrCoustfiled = "", isAdded = false, isSpecialField = false;
		//用于生成动态id保证每一个id不重复的同时，面板之间id也不重复
		if (formNumber) {
			formNumber = parseInt(formNumber);
			idFlag = value.split("_@_")[4];
			inputFlag = "i_" + idFlag;
			fieldFlag = "F_" + idFlag;
			sessionStorage.setItem("ID" + yigoflow.config.cacheFileName, idFlag);
		}
		//用于公式或者常量字段的ID,防止id重复导致事件绑定错乱
		if (fieldCaption === "  " && formNumber != -1) {
			fieldCaption = "";
			formulaID = "F_" + tableKey + idFlag + numberID;
			//公式字段和常量字段中有特殊字段，编译不通过，用到fieldKey作为ID的字段编译不通过
			fieldKey = "";
			//这个用于代替fieldKey进行显示
			FormulaOrCoustfiled = value.split("_@_")[1];
			FormulaOrCoustfiled = value.replaceAll("\"","'").split("_@_")[1];
			numberID++;
		} else if ("SpecialField" === fieldCaption) {
			isSpecialField = true;
			fieldCaption = "";
		}
		if (formNumber === -1) {
			tableIsNullNumber++;
		}
		//数据迁移目标数据对象不需要公式字段会常量字段
		if (value.split("_@_")[5] === "Migration") {
			publicFalg = true;
		}
		//判断当前tablekey是否已经添加了,如果已经添加之后就只进行追加文本框
		if (!$("#" + idFlag + formNumber).attr("id")) {
			let tableLength = $("." + idFlag).length;
			// 等于零就是添加的第一个
			if (tableLength === 0) {
				$("#tr" + idFlag).after(getS2(formNumber, tableKey, idFlag));
				if (formNumber === -1) {
					$("#" + idFlag + formNumber).after('<tr  id="' + inputFlag + formNumber + '"><td><input style="width:100%;height: 22px;background-color: RGB(255,245,225)" ' + 'id= "add' + idFlag + tableKey + '" class="inputClick" readonly="readonly" placeholder="单击添加表单字段"/></td>' + '</tr>');
				} else {
					$("#" + idFlag + formNumber).after('<tr id="' + inputFlag + formNumber + '"><td><input style="width:100%;height: 22px;" ' + 'id= "add' + idFlag + tableKey + '" class="inputClick" readonly="readonly" placeholder="单击添加表单字段"/></td>' + '</tr>');
				}
				$("#" + inputFlag + formNumber).after(getS1(formNumber, fieldKey, tableKey, fieldCaption, fieldFlag, formulaID, isSpecialField, FormulaOrCoustfiled));
			} else if (tableLength >= 1) {
				let arr = $("." + idFlag);
				for (let i = 0; i < arr.length; i++) {
					// 下面还有的话就加载那个tr的上面
					if (parseInt(arr[i].id.split(idFlag)[1]) > formNumber) {
						$("#" + arr[i].id).before(getS2(formNumber, tableKey, idFlag));
						$("#" + idFlag + formNumber).after('<tr id="' + inputFlag + formNumber + '"><td><input style="width:100%;height: 22px;" ' + 'id= "add' + idFlag + tableKey + '" class="inputClick" readonly="readonly" placeholder="单击添加表单字段"/></td>' + '</tr>');
						$("#" + inputFlag + formNumber).after(getS1(formNumber, fieldKey, tableKey, fieldCaption, fieldFlag, formulaID, isSpecialField, FormulaOrCoustfiled));
						isAdded = true;
						break;
					}
				}
				//  否则就追加到最后面
				if (!isAdded) {
					$("#Table__" + idFlag).append(getS2(formNumber, tableKey, idFlag));
					$("#Table__" + idFlag).append('<tr id="' + inputFlag + formNumber + '"><td><input style="width:100%;height: 22px;" ' + 'id= "add' + idFlag + tableKey + '" class="inputClick" readonly="readonly" placeholder="单击添加表单字段"/></td>' + '</tr>');
					$("#Table__" + idFlag).append(getS1(formNumber, fieldKey, tableKey, fieldCaption, fieldFlag, formulaID, isSpecialField, FormulaOrCoustfiled));
				}
			}
			//一些事件的处理
			eventHandling(tableKey, idFlag);
			//更新缓存
			sessionStorage.removeItem(idFlag + yigoflow.config.cacheFileName);
			sessionStorage.setItem(idFlag + yigoflow.config.cacheFileName, formNumber);
			//常量和公式字段处理
			constAndFormula(tableKey, formNumber, idFlag, FormulaOrCoustfiled);
		} else if ($("#" + idFlag + formNumber).attr("id")) {
			while (true) {
				if (formNumber < parseInt(sessionStorage.getItem(idFlag + yigoflow.config.cacheFileName))) {
					if ($("#" + idFlag + (formNumber + 1)).attr("id") && !$("#" + fieldFlag + fieldKey + tableKey).attr("id")) {
						$("#" + idFlag + (formNumber + 1)).before(getS(formNumber, fieldKey, tableKey, fieldCaption, formulaID, fieldFlag, isSpecialField, FormulaOrCoustfiled, tableIsNullNumber));
						break;
					} else {
						if (formNumber < parseInt(sessionStorage.getItem(idFlag + yigoflow.config.cacheFileName))) {
							formNumber++;
						} else {
							continue;
						}
					}
				} else if (formNumber > parseInt(sessionStorage.getItem(idFlag + yigoflow.config.cacheFileName))) {
					appendInput(fieldFlag, fieldKey, tableKey, formNumber, fieldCaption, formulaID, isSpecialField, FormulaOrCoustfiled);
					break;
				} else {
					appendInput(fieldFlag, fieldKey, tableKey, formNumber, fieldCaption, formulaID, isSpecialField, FormulaOrCoustfiled);
					break;
				}
			}
		} else {
			$("#" + idFlag).append(getS(formNumber, fieldKey, tableKey, fieldCaption, formulaID, fieldFlag, isSpecialField, FormulaOrCoustfiled, tableIsNullNumber));

		}
		/**字段删除操作*/
		deleteOperation(fieldKey, tableKey, formNumber, value, formulaID, idFlag, fieldFlag, FormulaOrCoustfiled);
		let nodeName = PanelJudge(idFlag);
		//只有在新增的情况下才会去再次获取
		if (isNew) {
			//重新获取连线
			if ($("#" + fieldFlag + fieldKey + tableKey).attr("id") != undefined) {
				setTimeout(function () {
					$("#reload").trigger('click');
				}, 1)
			} else if ($("#" + fieldFlag + formulaID).attr("id") != undefined) {
				setTimeout(function () {
					$("#reload").trigger('click');
				}, 1)
			}
		}
		publicFalg = false;
	};

	function selectEdit(arg, sle, tableKey, idFlag) {
		if (typeof arg === 'string') {
			let nodeName = PanelJudge(idFlag);
			let dataMapParams = {
				operType: 0, filePath: yigoflow.config.filePath, formKey: idFlag, tableKey: tableKey, nodeName: nodeName
			};
			if (arg == "getTableKeyField") {
				getTableKeyField(dataMapParams, sle);
			}

		}

	}

	// 流程属性拓展
	$.extend(true, yigoflow.config.rect, {
		attr: {
			r: 4, fill: 'none', stroke: '#000000', "stroke-width": 1
		}
	});
	$.extend(true, yigoflow.config.props.props, {
		Key: {
			name: 'Key', label: '标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Caption: {
			name: 'Caption', label: '名称', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Version: {
			name: 'Version', label: '版本', value: '1', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, DMTable: {
			name: 'DMTable', label: '迁移表设置', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, FormKey: {
			name: 'FormKey', label: '设置权限的表单', value: '', editor: function () {
				return new yigoflow.editors.selectEditor(yigoflow.config.formKeyListData);
			}
		}, PermCollection: {
			name: 'PermCollection', label: '权限设置', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, IgnoreFormState: {
			name: 'IgnoreFormState', label: '忽略表单状态', value: '', editor: function () {
				return new yigoflow.editors.selectEditor([{name: '', value: ""}, {name: '是', value: "true"}, {
					name: '否',
					value: "false"
				}]);
			}
		}, QueryRetreatWorkitem: {
			name: 'QueryRetreatWorkitem', label: '查询撤销工作项信息', value: 'true', editor: function () {
				return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
			}
		}, TemplateKey: {
			name: 'TemplateKey', label: '表单的反向模板定义', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, KillInstanceTrigger: {
			name: 'KillInstanceTrigger', label: '关闭实例触发器', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, LockWorkitem: {
			name: 'LockWorkitem', label: '驳回后是否锁定工作项', value: 'false', editor: function () {
				return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
			}
		}, BPMGraphInfoPath: {
			name: 'BPMGraphInfoPath', label: '自定义流程图信息拓展类', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, WorkFlowHookPath: {
			name: 'WorkFlowHookPath', label: '自定义流程不同时机触发事件的拓展类', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}
	});
	// 数据映射属性扩展
	$.extend(true, yigoflow.config.dataMapprops.dataMapprops, {
		Key: {
			name: 'Key', label: '映射标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Caption: {
			name: 'Caption', label: '映射说明', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Description: {
			name: 'Description', label: '映射描述', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, SrcFormKey: {
			name: 'SrcFormKey', label: '映射源表标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, TgtFormKey: {
			name: 'TgtFormKey', label: '映射目标表标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, MapRelationValue: {
			name: 'MapRelationValue', label: '允许关系值下推', value: 'true', editor: function () {
				return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
			}
		}, AllowRemainderPush: {
			name: 'AllowRemainderPush', label: '允许余量下推', value: 'true', editor: function () {
				return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
			}
		}, MarkMapCount: {
			name: 'MarkMapCount', label: '源单上记录数据条数', value: 'true', editor: function () {
				return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
			}
		}, PullDataOnly: {
			name: 'PullDataOnly', label: '仅推动数据', value: 'false', editor: function () {
				return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
			}
		}, RemainderPushValue: {
			name: 'RemainderPushValue', label: '剩余下推量', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, MinPushValue: {
			name: 'MinPushValue', label: '单次最小下推值', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, MapCondition: {
			name: 'MapCondition', label: '映射执行条件', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, PostProcess: {
			name: 'PostProcess', label: '映射执行后事件', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}
	});
	//数据迁移基础属性面板
	$.extend(true, yigoflow.config.DataMigrationprops.DataMigrationprops, {
		Key: {
			name: 'Key', label: '迁移标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Caption: {
			name: 'Caption', label: '迁移说明', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Description: {
			name: 'Description', label: '迁移描述', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, sourceForm: {
			name: 'sourceForm', label: '源表单标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, targetForm: {
			name: 'targetForm', label: '目标对象标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, StatusFieldKey: {
			name: 'StatusFieldKey', label: '状态字段标识', value: '', editor: function () {
				return new yigoflow.editors.selectEditor("getStatusFideldKey");
			}
		}, StatusValue: {
			name: 'StatusValue', label: '状态字段标值', value: '', editor: function () {
				return new yigoflow.editors.selectEditor("getStatusList");
			}
		}, DetailCondition: {
			name: 'DetailCondition', label: '明细迁移条件', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, HeadCondition: {
			name: 'HeadCondition', label: '迁移总条件', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}
	});
	//源单
	$.extend(true, yigoflow.config.sourceProps.sourceProps, {
		formField: {
			name: 'formField', value: '', editor: function () {
				return new yigoflow.editors.selectEditor("getFormField");
			}
		}
	});
	//目标表单
	$.extend(true, yigoflow.config.targetProps.targetProps, {
		targetFormField: {
			name: 'targetFormField', value: '', editor: function () {
				return new yigoflow.editors.selectEditor("getFormField");
			}
		}
	});
	//数据迁移目标对象页面构建
	$.extend(true, yigoflow.config.MigrationTargetProps.MigrationTargetProps, {
		targetFormField: {
			name: 'targetFormField', value: '', editor: function () {
				return new yigoflow.editors.selectEditor("getMigrationField");
			}
		}
	});
	//源表单表单属性
	let sourcePanelJson = {};
	sourcePanelJson.Key = {
		name: 'Key', label: '源表单标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	sourcePanelJson.sourceCaption = {
		name: 'sourceCaption', label: '源表单说明', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	//目标表单JSon数据
	let targetJson = {};
	targetJson.Key = {
		name: 'Key', label: '目标表单标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	targetJson.sourceCaption = {
		name: 'sourceCaption', label: '目标表单说明', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	targetJson.StatusFieldKey_Feed = {
		name: 'StatusFieldKey_Feed', label: '反填状态字段标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	targetJson.StatusValue_Feed = {
		name: 'StatusValue_Feed', label: '反填状态值', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	targetJson.Condition_Feed = {
		name: 'Condition_Feed', label: '反填数据条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	//反填表单面板数据
	let feedbackJson = {};
	feedbackJson.Key = {
		name: 'Key', label: '反填表单标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	feedbackJson.feedbackCaption = {
		name: 'sourceCaption', label: '反填表单说明', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	//字段属性Json数据
	let fieldJson = {};
	fieldJson.sourcekey = {
		name: 'sourceType', label: '源字段标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	fieldJson.sourceCaption = {
		name: 'sourceCaption', label: '源字段说明', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	//连线数据,源单到目标表单
	let ligatureJson = {};
	ligatureJson.sourcekey = {
		name: 'sourceType', label: '源字段标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureJson.sourceCaption = {
		name: 'sourceCaption', label: '源字段说明', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureJson.targetkey = {
		name: 'targetkey', label: '目标字段标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureJson.targetCaption = {
		name: 'targetCaption', label: '目标字段说明', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureJson.targetTableKey = {
		name: 'targetTableKey', label: '目标表标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureJson.Editable = {
		name: 'Editable', label: '下推目标是否可编辑', value: 'true', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
		}
	};
	ligatureJson.EdgeType = {
		name: 'EdgeType', label: '关系线类型', value: 'common', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '普通映射', value: "common"}, {name: '关注映射', value: "Focus"}]);
		}
	};
	ligatureJson.ConditionField = {
		name: 'ConditionField', label: '字段下推条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	//连线数据，目标表单到反填表单
	let ligatureFeedbackJson = {};
	ligatureFeedbackJson.DataObjectKey = {
		name: 'DataObjectKey', label: '反填目标表单标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureFeedbackJson.TableKey = {
		name: 'TableKey', label: '反填目标表标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureFeedbackJson.FieldKey = {
		name: 'FieldKey', label: '反填目标字段标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureFeedbackJson.FieldCaption = {
		name: 'FieldCaption', label: '反填目标字段说明', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureFeedbackJson.sourceKey = {
		name: 'sourceKey', label: '反填目标源字段标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureFeedbackJson.sourceCaption = {
		name: 'sourceCaption', label: '反填目标源字段说明', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureFeedbackJson.OpSign = {
		name: 'OpSign', label: '映射数据的处理方式', value: '', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '赋直接量', value: "Assign"}, {name: '加变化值', value: "AddDelta"}]);
		}
	};
	ligatureFeedbackJson.PostTrigger = {
		name: 'PostTrigger', label: '反填后期处理类', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureFeedbackJson.PostFormulaTrigger = {
		name: 'PostFormulaTrigger', label: '反填后期处理公式', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureFeedbackJson.FeedCondition = {
		name: 'FeedCondition', label: '反填条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	// 数据迁移连线页面(直接量)
	let ligatureMigrationJson = {};
	ligatureMigrationJson.targetKey = {
		name: 'targetKey', label: '目标表标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureMigrationJson.TargetFieldKey = {
		name: 'TargetFieldKey', label: '目标定义', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureMigrationJson.GroupingPolicy = {
		name: 'GroupingPolicy', label: '分组策略', value: '', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '直接量', value: ""}, {name: '期间分组', value: "Period"}]);
		}
	};
	ligatureMigrationJson.PeriodValue = {
		name: 'PeriodValue', label: '期间取值方式', value: '', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '默认', value: ""}, {
				name: '直接取值',
				value: "Value"
			}, {name: '值映射', value: "Map"}]);
		}
	};
	ligatureMigrationJson.MapFormula = {
		name: 'MapFormula', label: '分组映射公式', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	// 数据迁移连线页面(无分组)
	let ligatureNoGroupingJson = {};
	ligatureNoGroupingJson.targetKey = {
		name: 'targetKey', label: '目标表标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureNoGroupingJson.TargetFieldKey = {
		name: 'TargetFieldKey', label: '目标定义', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ligatureNoGroupingJson.MigrationOpSign = {
		name: 'MigrationOpSign', label: '值处理方式', value: '', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '加变化值', value: ""}, {
				name: '加直接量',
				value: "AddValue"
			}, {name: '赋直接量', value: "Assign"}]);
		}
	};
	ligatureNoGroupingJson.IsNegtive = {
		name: 'IsNegtive', label: '是否负向迁移', value: '', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: ""}]);
		}
	};
	//表属性面板构建(非主表)
	let tableJson = {};
	tableJson.Key = {
		name: 'Key', label: '源表标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	tableJson.sourceCaption = {
		name: 'sourceCaption', label: '源表说明', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	//常量和公式字段
	let ConstAndFormula = {};
	ConstAndFormula.sourceType = {
		name: 'sourceType', label: '源字段类型', value: 'Field', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '字段', value: "Field"}, {
				name: '常量',
				value: "Const"
			}, {name: '公式', value: "Formula"}]);
		}
	};

	ConstAndFormula.sourceContent = {
		name: 'sourceContent', label: '源字段内容', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	// 节点公共属性JSON
	let nodeCommonProperties = {
		NodeType: {
			name: 'NodeType', label: '节点类型', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, ID: {
			name: 'ID', label: '数字编号', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Key: {
			name: 'Key', label: '标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Caption: {
			name: 'Caption', label: '名称', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Image: {
			name: 'Image', label: '默认图片', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, PastImage: {
			name: 'PastImage', label: '已通过状态图片', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, LastImage: {
			name: 'LastImage', label: '当前状态节点图片', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, BPMState: {
			name: 'BPMState', label: '自有节点状态', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, WorkitemRevoke: {
			name: 'WorkitemRevoke', label: '是否可以撤销工作项', value: 'true', editor: function () {
				return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
			}
		}, RetreatCaption: {
			name: 'RetreatCaption', label: '撤销工作项通用名称', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, RevokeTrigger: {
			name: 'RevokeTrigger', label: '节点撤销事件', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, IsSync: {
			name: 'IsSync', label: '是否同步', value: 'false', editor: function () {
				return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
			}
		}
	};

	// Begin节点属性JSON
	let BeginJSON = $.extend(true, {}, nodeCommonProperties);
	BeginJSON.Status = {
		name: 'Status', label: '开始状态', value: '', editor: function () {
			return new yigoflow.editors.selectEditor("getStatusList");
		}
	};
	// End节点属性JSON
	let EndJSON = $.extend(true, {}, nodeCommonProperties);
	EndJSON.Status = {
		name: 'Status', label: '结束状态', value: '', editor: function () {
			return new yigoflow.editors.selectEditor("getStatusList");
		}
	};
	// Audit节点属性JSON
	let AuditJSON = $.extend(true, {}, nodeCommonProperties);
	AuditJSON.TimerItemCollection = {
		name: 'TimerItemCollection', label: '审批超时集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	AuditJSON.RevokeCondition = {
		name: 'RevokeCondition', label: '工作项撤销条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	AuditJSON.CreateTrigger = {
		name: 'CreateTrigger', label: '工作项创建事件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	AuditJSON.FinishTrigger = {
		name: 'FinishTrigger', label: '工作项完成事件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	AuditJSON.AutoIgnoreNoParticipator = {
		name: 'AutoIgnoreNoParticipator', label: '无参者自动略过', value: 'false', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
		}
	};
	AuditJSON.Perm = {
		name: 'Perm', label: '权限设置', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	AuditJSON.OperationCollection = {
		name: 'OperationCollection', label: '操作集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	AuditJSON.AssistanceCollection = {
		name: 'AssistanceCollection', label: '辅助节点集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	AuditJSON.ParticipatorCollection = {
		name: 'ParticipatorCollection', label: '参与者集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	AuditJSON.DenyToLastNode = {
		name: 'DenyToLastNode', label: '是否驳回上一步', value: 'false', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
		}
	};
	AuditJSON.DenyNodeKey = {
		name: 'DenyNodeKey', label: '驳回目标节点', value: '', editor: function () {
			return new yigoflow.editors.selectEditor("getAllNodes");
		}
	};
	// Decision节点属性JSON
	let DecisionJSON = $.extend(true, {}, nodeCommonProperties);
	DecisionJSON.Condition = {
		name: 'Condition', label: '选择条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	// State节点属性JSON
	let StateJSON = $.extend(true, {}, nodeCommonProperties);
	StateJSON.Status = {
		name: 'Status', label: '状态标识', value: '', editor: function () {
			return new yigoflow.editors.selectEditor("getStatusList");
		}
	};
	StateJSON.CreateTrigger = {
		name: 'CreateTrigger', label: '工作项创建事件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateJSON.FinishTrigger = {
		name: 'FinishTrigger', label: '工作项完成事件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateJSON.Perm = {
		name: 'Perm', label: '权限设置', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateJSON.FieldKey = {
		name: 'FieldKey', label: '绑定字段标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateJSON.FieldValue = {
		name: 'FieldValue', label: '绑定字段值', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateJSON.ParticipatorCollection = {
		name: 'ParticipatorCollection', label: '参与者集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateJSON.RevokeCondition = {
		name: 'RevokeCondition', label: '工作项撤销条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	// 用户任务
	let UserTaskJSON = $.extend(true, {}, nodeCommonProperties);
	UserTaskJSON.TimerItemCollection = {
		name: 'TimerItemCollection', label: '用户超时集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	UserTaskJSON.RevokeCondition = {
		name: 'RevokeCondition', label: '工作项撤销条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	UserTaskJSON.CreateTrigger = {
		name: 'CreateTrigger', label: '工作项创建事件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	UserTaskJSON.FinishTrigger = {
		name: 'FinishTrigger', label: '工作项完成事件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	UserTaskJSON.AutoIgnoreNoParticipator = {
		name: 'AutoIgnoreNoParticipator', label: '无参者自动略过', value: 'false', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
		}
	};
	UserTaskJSON.Perm = {
		name: 'Perm', label: '权限设置', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	UserTaskJSON.OperationCollection = {
		name: 'OperationCollection', label: '操作集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	UserTaskJSON.AssistanceCollection = {
		name: 'AssistanceCollection', label: '辅助节点集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	UserTaskJSON.ParticipatorCollection = {
		name: 'ParticipatorCollection', label: '参与者集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	// 系统任务
	let ServiceTaskJSON = $.extend(true, {}, nodeCommonProperties);
	ServiceTaskJSON.Action = {
		name: 'Action', label: '操作', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	// 多人任务节点
	let MultiUserTaskJSON = $.extend(true, {}, UserTaskJSON);
	MultiUserTaskJSON.InOrder = {
		name: 'InOrder', label: '是否顺序执行', value: 'false', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
		}
	};
	// 多人审批节点
	let ComplexJoinJSON = $.extend(true, {}, nodeCommonProperties);
	ComplexJoinJSON.JoinCount = {
		name: 'JoinCount', label: '合并数据流数量', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	ComplexJoinJSON.JoinCondition = {
		name: 'JoinCondition', label: '合并条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	// 数据映射->节点属性JSON
	let DataMapJSON = $.extend(true, {}, UserTaskJSON);
	DataMapJSON.MidDataMap = {
		name: 'MidDataMap', label: '是否中间映射', value: 'false', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
		}
	};
	DataMapJSON.SyncTriggerType = {
		name: 'SyncTriggerType', label: '同步触发机制', value: '', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '无操作', value: ""}, {
				name: '数据保存',
				value: "BillSave"
			}, {name: '实例启动', value: "InstanceStart"}, {name: '实例结束', value: "Async"}]);
		}
	};
	DataMapJSON.DataMapCondition = {
		name: 'DataMapCondition', label: '映射完成条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	DataMapJSON.BillDataMapInfoCollection = {
		name: 'BillDataMapInfoCollection', label: '映射集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	//GateWay节点属性JSON
	let GateWayJSON = $.extend(true, {}, nodeCommonProperties);//添加公共标识
	GateWayJSON.Condition = {
		name: 'Condition', label: '流转条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};//添加独有的标识
	//Countersign会签节点属性
	let CountersignJSON = $.extend(true, {}, nodeCommonProperties);//添加公共标识
	CountersignJSON.TimerItemCollection = {
		name: 'TimerItemCollection', label: '会签超时集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	CountersignJSON.CreateTrigger = {
		name: 'CreateTrigger', label: '工作项创建事件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	CountersignJSON.FinishTrigger = {
		name: 'FinishTrigger', label: '工作项完成事件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	CountersignJSON.AutoIgnoreNoParticipator = {
		name: 'AutoIgnoreNoParticipator', label: '无参者自动略过', value: 'false', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
		}
	};
	CountersignJSON.Perm = {
		name: 'Perm', label: '权限设置', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	CountersignJSON.OperationCollection = {
		name: 'OperationCollection', label: '操作集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	CountersignJSON.AssistanceCollection = {
		name: 'AssistanceCollection', label: '辅助节点集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	CountersignJSON.ParticipatorCollection = {
		name: 'ParticipatorCollection', label: '参与者集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	CountersignJSON.FinishType = {
		name: 'FinishType', label: '会签完成类型', value: 'false', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '无', value: "false"}, {
				name: '数量',
				value: "Number"
			}, {name: '比例', value: 'Proportion'}, {name: '自定义', value: 'Custom'}]);
		}
	};
	CountersignJSON.FinishCondition = {
		name: 'FinishCondition', label: '会签完成条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	CountersignJSON.ValidType = {
		name: 'ValidType', label: '会签成立类型', value: 'false', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '无', value: "false"}, {
				name: '数量',
				value: "Number"
			}, {name: '比例', value: 'Proportion'}, {name: '自定义', value: 'Custom'}]);
		}
	};
	CountersignJSON.ValidCondition = {
		name: 'ValidCondition', label: '会签成立条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	CountersignJSON.PassType = {
		name: 'PassType', label: '会签通过类型', value: 'false', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '无', value: "false"}, {
				name: '数量',
				value: "Number"
			}, {name: '比例', value: 'Proportion'}, {name: '自定义', value: 'Custom'}]);
		}
	};
	CountersignJSON.PassCondition = {
		name: 'PassCondition', label: '会签通过条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	//状态机节点属性
	let StateActionJSON = $.extend(true, {}, nodeCommonProperties);
	StateActionJSON.OperationKey = {
		name: 'OperationKey', label: '操作标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateActionJSON.OperationCaption = {
		name: 'OperationCaption', label: '操作名称', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateActionJSON.Enable = {
		name: 'Enable', label: '可用性', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateActionJSON.Visible = {
		name: 'Visible', label: '可见性', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateActionJSON.Icon = {
		name: 'Icon', label: '图标', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateActionJSON.TemplateKey = {
		name: 'TemplateKey', label: '模板标识', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateActionJSON.Action = {
		name: 'Action', label: '动作', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateActionJSON.ParticipatorCollection = {
		name: 'ParticipatorCollection', label: '参与者集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	StateActionJSON.RevokeCondition = {
		name: 'RevokeCondition', label: '工作项撤销条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	//内联流程
	let InlineJSON = $.extend(true, {}, nodeCommonProperties);
	InlineJSON.InlineProcessKey = {
		name: 'InlineProcessKey', label: '内联流程标识', value: 'false', editor: function () {
			return new yigoflow.editors.selectEditor("getInline");
		}
	};
	//子流程
	let SubProcessJSON = $.extend(true, {}, nodeCommonProperties);
	SubProcessJSON.TimerItemCollection = {
		name: 'TimerItemCollection', label: '用户超时集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	SubProcessJSON.RevokeCondition = {
		name: 'RevokeCondition', label: '工作项撤销条件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	SubProcessJSON.CreateTrigger = {
		name: 'CreateTrigger', label: '工作项创建事件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	SubProcessJSON.FinishTrigger = {
		name: 'FinishTrigger', label: '工作项完成事件', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	SubProcessJSON.AutoIgnoreNoParticipator = {
		name: 'AutoIgnoreNoParticipator', label: '无参者自动略过', value: 'false', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '是', value: "true"}, {name: '否', value: "false"}]);
		}
	};
	SubProcessJSON.Perm = {
		name: 'Perm', label: '权限设置', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	SubProcessJSON.OperationCollection = {
		name: 'OperationCollection', label: '操作集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	SubProcessJSON.AssistanceCollection = {
		name: 'AssistanceCollection', label: '辅助节点集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	SubProcessJSON.ParticipatorCollection = {
		name: 'ParticipatorCollection', label: '参与者集合', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	SubProcessJSON.SyncMode = {
		name: 'SyncMode', label: '同步模式', value: 'Synchronized', editor: function () {
			return new yigoflow.editors.selectEditor([{name: '同步模式', value: "Synchronized"}, {
				name: '异步模式',
				value: "Async"
			}]);
		}
	};
	SubProcessJSON.AutoStartAction = {
		name: 'AutoStartAction', label: '自动创建子流程', value: '', editor: function () {
			return new yigoflow.editors.inputEditor();
		}
	};
	SubProcessJSON.SubProcessKey = {
		name: 'SubProcessKey', label: '子流程标识', value: 'false', editor: function () {
			return new yigoflow.editors.selectEditor("getInline");
		}
	};
	//泳道节点属性
	let SwimlineCollectionJSON = {
		NodeType: {
			name: 'NodeType', label: '节点类型', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, ID: {
			name: 'ID', label: '数字编号', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Key: {
			name: 'Key', label: '标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Caption: {
			name: 'Caption', label: '名称', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Direction: {
			name: 'Direction', label: '泳道方向', value: 'Vertical', editor: function () {
				return new yigoflow.editors.selectEditor([{name: '垂直方向', value: "Vertical"}, {
					name: '水平方向',
					value: "Horizontal"
				}]);
			}
		}, X: {
			name: 'X', label: '泳道水平位置', value: '300', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Y: {
			name: 'Y', label: '泳道垂直位置', value: '500', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Width: {
			name: 'Width', label: '泳道宽度', value: '80', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Height: {
			name: 'Height', label: '泳道高度', value: '50', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}
	}
	// 节点属性的拓展
	$.extend(true, yigoflow.config.tools.states, {
		Begin: {
			showType: 'image&text',
			type: 'Begin',
			name: {text: '<<Begin>>'},
			text: {text: '开始'},
			img: {src: '../img/48/Begin.png', width: 48, height: 48},
			attr: {width: 48, height: 48},
			props: BeginJSON
		}, End: {
			showType: 'image&text',
			type: 'End',
			name: {text: '<<End>>'},
			text: {text: '结束'},
			img: {src: '../img/48/End.png', width: 48, height: 48},
			attr: {width: 48, height: 48},
			props: EndJSON
		}, BranchEnd: {
			showType: 'image&text',
			type: 'BranchEnd',
			name: {text: '<<BranchEnd>>'},
			text: {text: '分支结束'},
			img: {src: '../img/48/BranchEnd.png', width: 48, height: 48},
			attr: {width: 48, height: 48},
			props: nodeCommonProperties
		}, UserTask: {
			showType: 'text',
			type: 'UserTask',
			name: {text: '<<UserTask>>'},
			text: {text: '用户任务'},
			img: {src: '../img/bpmtools_16/UserTask.png', width: 48, height: 48},
			props: UserTaskJSON
		}, ServiceTask: {
			showType: 'text',
			type: 'ServiceTask',
			name: {text: '<<ServiceTask>>'},
			text: {text: '系统任务'},
			img: {src: '../img/bpmtools_16/ServiceTask.png', width: 48, height: 48},
			props: ServiceTaskJSON
		}, ManualTask: {
			showType: 'text',
			type: 'ManualTask',
			name: {text: '<<ManualTask>>'},
			text: {text: '人工任务'},
			img: {src: '../img/bpmtools_16/ManualTask.png', width: 48, height: 48},
			props: nodeCommonProperties
		}, Audit: {
			showType: 'text',
			type: 'Audit',
			name: {text: '<<Audit>>'},
			text: {text: '审批任务'},
			img: {src: '../img//bpmtools_16/Audit.png', width: 48, height: 48},
			props: AuditJSON
		}, Decision: {
			showType: 'image&text',
			type: 'Decision',
			name: {text: '<<Decision>>'},
			text: {text: '选择节点'},
			img: {src: '../img/48/Decision.png', width: 50, height: 50},
			attr: {width: 50, height: 50},
			props: DecisionJSON
		}, State: {
			showType: 'image&text',
			type: 'State',
			name: {text: '<<State>>'},
			text: {text: '状态节点'},
			img: {src: '../img/48/State.png', width: 48, height: 48},
			attr: {width: 48, height: 48},
			props: StateJSON
		}, Fork: {
			showType: 'image&text',
			type: 'Fork',
			name: {text: '<<Fork>>'},
			text: {text: '分支节点'},
			img: {src: '../img/48/Fork.png', width: 48, height: 48},
			attr: {width: 50, height: 50},
			props: nodeCommonProperties
		}, Join: {
			showType: 'image&text',
			type: 'Join',
			name: {text: '<<Join>>'},
			text: {text: '合并节点'},
			img: {src: '../img/48/Join.png', width: 48, height: 48},
			attr: {width: 50, height: 50},
			props: nodeCommonProperties
		}, ExclusiveFork: {
			showType: 'image&text',
			type: 'ExclusiveFork',
			name: {text: '<<ExclusiveFork>>'},
			text: {text: '互斥分支'},
			img: {src: '../img/48/ExclusiveFork.png', width: 48, height: 48},
			attr: {width: 50, height: 50},
			props: nodeCommonProperties
		}, ComplexJoin: {
			showType: 'image&text',
			type: 'ComplexJoin',
			name: {text: '<<ComplexJoin>>'},
			text: {text: '复杂合并'},
			img: {src: '../img/48/ComplexJoin.png', width: 48, height: 48},
			attr: {width: 50, height: 50},
			props: ComplexJoinJSON
		}, DataMap: {
			showType: 'text',
			type: 'DataMap',
			name: {text: '<<DataMap>>'},
			text: {text: '数据映射'},
			img: {src: '../img/bpmtools_16/DataMap.png', width: 48, height: 48},
			props: DataMapJSON
		}, MultiUserTask: {
			showType: 'text',
			type: 'MultiUserTask',
			name: {text: '<<MultiUserTask>>'},
			text: {text: '多人任务节点'},
			img: {src: '../img/bpmtools_16/MultiUserTask.png', width: 48, height: 48},
			props: MultiUserTaskJSON
		}, MultiAudit: {
			showType: 'text',
			type: 'MultiAudit',
			name: {text: '<<MultiAudit>>'},
			text: {text: '多人审批节点'},
			img: {src: '../img/bpmtools_16/MultiAudit.png', width: 48, height: 48},
			props: AuditJSON
		}, GateWay: {
			showType: 'image&text',
			type: 'GateWay',
			name: {text: '<<GateWay>>'},
			text: {text: '路由节点'},
			img: {src: '../img/48/GateWay.png', width: 48, height: 48},
			attr: {width: 50, height: 50},
			props: GateWayJSON
		}, Countersign: {
			showType: 'text',
			type: 'Countersign',
			name: {text: '<<Countersign>>'},
			text: {text: '会签节点'},
			img: {src: '../img/bpmtools_16/Countersign.png', width: 48, height: 48},
			props: CountersignJSON
		}, StateAction: {
			showType: 'text',
			type: 'StateAction',
			name: {text: '<<StateAction>>'},
			text: {text: '状态机操作'},
			img: {src: '../img/bpmtools_16/StateAction.png', width: 48, height: 48},
			props: StateActionJSON
		}, Swimline: {
			showType: 'text',
			type: 'Swimline',
			name: {text: '<<Swimline>>'},
			text: {text: '泳道'},
			img: {src: '../img/bpmtools_16/Swimline.png', width: 48, height: 48},
			props: SwimlineCollectionJSON
		}, Inline: {
			showType: 'text',
			type: 'Inline',
			name: {text: '<<Inline>>'},
			text: {text: '内联流程'},
			img: {src: '../img/bpmtools_16/Inline.png', width: 48, height: 48},
			props: InlineJSON
		}, SubProcess: {
			showType: 'text',
			type: 'SubProcess',
			name: {text: '<<SubProcess>>'},
			text: {text: '子流程'},
			img: {src: '../img/bpmtools_16/SubProcess.png', width: 48, height: 48},
			props: SubProcessJSON
		}

	});

	// 顺序流属性的拓展
	$.extend(true, yigoflow.config.SequenceFlow.props, {
		//text: {name: 'text',label: '名称',value: '',editor: function () {return new yigoflow.editors.textEditor();}}
		NodeType: {
			name: 'NodeType', label: '节点类型', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, ID: {
			name: 'ID', label: '数字编号', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Key: {
			name: 'Key', label: '标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Caption: {
			name: 'Caption', label: '名称', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, TargetNodeKey: {
			name: 'TargetNodeKey', label: '目标节点标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, State: {
			name: 'State', label: '状态', value: '', editor: function () {
				return new yigoflow.editors.selectEditor("getStatusList");
			}
		}, Condition: {
			name: 'Condition', label: '条件', value: 'True', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}
	});

	// 关联流属性的拓展
	$.extend(true, yigoflow.config.Association.props, {
		//text: {name: 'text',label: '名称',value: '',editor: function () {return new yigoflow.editors.textEditor();}}
		NodeType: {
			name: 'NodeType', label: '节点类型', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, ID: {
			name: 'ID', label: '数字编号', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Key: {
			name: 'Key', label: '标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Caption: {
			name: 'Caption', label: '名称', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, TargetNodeKey: {
			name: 'TargetNodeKey', label: '目标节点标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}
	});

	// 异常流属性的拓展
	$.extend(true, yigoflow.config.ExceptionFlow.props, {
		//text: {name: 'text',label: '名称',value: '',editor: function () {return new yigoflow.editors.textEditor();}}
		NodeType: {
			name: 'NodeType', label: '节点类型', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, ID: {
			name: 'ID', label: '数字编号', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Key: {
			name: 'Key', label: '标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, Caption: {
			name: 'Caption', label: '名称', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}, TargetNodeKey: {
			name: 'TargetNodeKey', label: '目标节点标识', value: '', editor: function () {
				return new yigoflow.editors.inputEditor();
			}
		}
	});
	//暂时先用这个做一个页面关闭提示
	window.onbeforeunload = function (event) {
		event.returnValue = "请确认是否保存";
	};
})(jQuery);