/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tool;

import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.SyntaxTree;
import com.bokesoft.yes.tool.FormulaUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FormulaFormat {
    private final String content;
    private final List<Item> items;
    private final List<Integer> itemIndexes;
    private final List<String> formats = new ArrayList<String>();
    private final int length;
    private int pos = 0;
    private int start = 0;
    private char c;
    private boolean b_skip = false;
    private boolean c_skip = false;
    private boolean semicolon_skip = false;

    public FormulaFormat(String formula, List<Item> leafItems) {
        this.content = formula;
        this.items = leafItems;
        this.itemIndexes = new ArrayList<Integer>(leafItems.size());
        this.length = formula.length();
    }

    public static FormulaFormat parse(String formula, SyntaxTree syntaxTree) {
        List<Item> leafItems = FormulaUtil.getLeafItems(syntaxTree.getRoot());
        FormulaFormat result = new FormulaFormat(formula, leafItems);
        result.parse();
        return result;
    }

    private void parse() {
        int index = 0;
        int lastPos = 0;
        int indexIndex = 0;
        do {
            this.c = this.content.charAt(this.pos);
            ++this.pos;
            do {
                this.c = this.skipBlank(this.c);
                this.c = this.skipComments(this.c);
            } while (this.c_skip || this.b_skip);
            String tokenString = FormulaFormat.getItemLexValue(this.items.get(indexIndex));
            if (tokenString.equals("}") && this.c == ';') {
                do {
                    this.c = this.skipBlank(this.c);
                    this.c = this.skipComments(this.c);
                    this.c = this.skipSemicolon(this.c);
                } while (this.c_skip || this.b_skip || this.semicolon_skip);
            }
            if (tokenString.length() > 0 && this.content.substring(this.pos - 1, this.pos + tokenString.length() - 1).equals(tokenString)) {
                this.formats.add(this.pos > lastPos + 1 ? this.content.substring(lastPos, this.pos - 1) : "");
                this.formats.add(this.content.substring(this.pos - 1, this.pos + tokenString.length() - 1));
                this.pos += tokenString.length() - 1;
            } else if (tokenString.equals("<>") && this.content.substring(this.pos - 1, this.pos + tokenString.length() - 1).equals("!=")) {
                this.formats.add(this.pos > lastPos + 1 ? this.content.substring(lastPos, this.pos - 1) : "");
                this.formats.add(this.content.substring(this.pos - 1, this.pos + tokenString.length() - 1));
                this.pos += tokenString.length() - 1;
            } else if ((tokenString.equalsIgnoreCase("true") || tokenString.equalsIgnoreCase("false")) && this.content.substring(this.pos - 1, this.pos + tokenString.length() - 1).equalsIgnoreCase(tokenString)) {
                this.formats.add(this.pos > lastPos + 1 ? this.content.substring(lastPos, this.pos - 1) : "");
                this.formats.add(this.content.substring(this.pos - 1, this.pos + tokenString.length() - 1));
                this.pos += tokenString.length() - 1;
            } else if (this.content.substring(this.pos, this.pos + tokenString.length()).equals(tokenString)) {
                this.formats.add(this.pos > lastPos + 1 ? this.content.substring(lastPos, this.pos - 1) : "");
                this.formats.add(this.content.substring(this.pos - 1, this.pos + tokenString.length() + 1));
                this.pos += tokenString.length() + 1;
            } else {
                throw new RuntimeException("ERROR!");
            }
            lastPos = this.pos;
            this.itemIndexes.add(index + 2);
            index += 2;
        } while (++indexIndex != this.items.size());
        this.formats.add(this.pos < this.length ? this.content.substring(this.pos, this.length) : "");
    }

    private static String getItemLexValue(Item item) {
        String fullLexValue = item.getFullLexValue();
        return StringUtils.isBlank((CharSequence)fullLexValue) ? item.getLexValue() : fullLexValue;
    }

    private char skipBlank(char c) {
        char result = c;
        this.b_skip = false;
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            this.b_skip = true;
            if (this.pos >= this.length) {
                return result;
            }
            c = this.content.charAt(this.pos);
            result = c;
            ++this.pos;
            ++this.start;
        }
        return result;
    }

    private char skipSemicolon(char c) {
        char result = c;
        this.semicolon_skip = false;
        while (c == ';') {
            this.semicolon_skip = true;
            if (this.pos >= this.length) {
                return result;
            }
            c = this.content.charAt(this.pos);
            result = c;
            ++this.pos;
            ++this.start;
        }
        return result;
    }

    private char skipComments(char c) {
        int result = c;
        this.c_skip = false;
        if (this.pos < this.length) {
            int oldPos = this.pos;
            int oldStart = this.start++;
            boolean found = false;
            if (c == 47 && this.pos < this.length) {
                c = this.content.charAt(this.pos);
                ++this.pos;
                if (c == 47) {
                    if (this.pos < this.length) {
                        c = this.content.charAt(this.pos);
                        ++this.pos;
                        ++this.start;
                        while (c != 10 && this.pos < this.length) {
                            if (this.pos >= this.length) continue;
                            c = this.content.charAt(this.pos);
                            ++this.pos;
                            ++this.start;
                        }
                        if (this.pos < this.length) {
                            c = this.content.charAt(this.pos);
                            ++this.pos;
                            ++this.start;
                            result = c;
                        } else {
                            result = 36;
                        }
                        found = true;
                    }
                } else if (c == 42 && this.pos < this.length) {
                    c = this.content.charAt(this.pos);
                    ++this.pos;
                    ++this.start;
                    while (true) {
                        if (c == 42 && this.pos < this.length && this.content.charAt(this.pos) == '/') {
                            ++this.pos;
                            ++this.start;
                            found = true;
                            break;
                        }
                        if (this.pos >= this.length) break;
                        c = this.content.charAt(this.pos);
                        ++this.pos;
                        ++this.start;
                    }
                    if (found) {
                        if (this.pos < this.length) {
                            c = this.content.charAt(this.pos);
                            ++this.pos;
                            ++this.start;
                            result = c;
                        } else {
                            result = 36;
                        }
                    }
                }
            }
            if (!found) {
                this.pos = oldPos;
                this.start = oldStart;
            } else {
                this.c_skip = true;
            }
        }
        return (char)result;
    }

    public String getPreFormat(Item item) {
        int index = this.items.indexOf(item);
        if (index < 0) {
            throw new RuntimeException("ERROR!");
        }
        return this.formats.get(index * 2);
    }

    public String getLastFormat() {
        return this.formats.get(this.formats.size() - 1);
    }

    public String getOrgText(Item item) {
        int index = this.items.indexOf(item);
        if (index < 0) {
            throw new RuntimeException("ERROR!");
        }
        return this.formats.get(index * 2 + 1);
    }

    public String toString() {
        return this.formats.toString();
    }
}

