/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tool;

import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.Rule;
import com.bokesoft.yes.parser.SyntaxTree;
import org.apache.commons.lang3.NotImplementedException;

public class FormulaDeparser {
    public static final int RuleIndex_0_Statement = 0;
    public static final int RuleIndex_1_Statements = 1;
    public static final int RuleIndex_2_Addition = 2;
    public static final int RuleIndex_3_Subtraction = 3;
    public static final int RuleIndex_4_Multiplication = 4;
    public static final int RuleIndex_5_Division = 5;
    public static final int RuleIndex_6_Concat = 6;
    public static final int RuleIndex_7_Parenthesis = 7;
    public static final int RuleIndex_8_Not = 8;
    public static final int RuleIndex_9_Or = 9;
    public static final int RuleIndex_10_And = 10;
    public static final int RuleIndex_11_EqualsTo = 11;
    public static final int RuleIndex_12_NotEqualsTo = 12;
    public static final int RuleIndex_13_GreaterThan = 13;
    public static final int RuleIndex_14_GreaterThanEquals = 14;
    public static final int RuleIndex_15_MinorThan = 15;
    public static final int RuleIndex_16_MinorThanEquals = 16;
    public static final int RuleIndex_17_Const = 17;
    public static final int RuleIndex_18_ID = 18;
    public static final int RuleIndex_19_Function = 19;
    public static final int RuleIndex_20_ = 20;
    public static final int RuleIndex_21_ = 21;
    public static final int RuleIndex_22_ = 22;
    public static final int RuleIndex_23_ = 23;
    public static final int RuleIndex_24_ = 24;
    public static final int RuleIndex_25_Var = 25;
    public static final int RuleIndex_26_IfHead = 26;
    public static final int RuleIndex_27_IfElse = 27;
    public static final int RuleIndex_28_IfHead = 28;
    public static final int RuleIndex_29_ = 29;
    public static final int RuleIndex_30_While = 30;
    public static final int RuleIndex_31_SetValue = 31;
    public static final int RuleIndex_32_Return = 32;
    public static final int RuleIndex_33_ = 33;
    public static final int RuleIndex_34_ = 34;
    public static final int RuleIndex_35_ = 35;
    public static final int RuleIndex_36_ = 36;
    public static final int RuleIndex_37_ = 37;
    public static final int RuleIndex_38_ = 38;
    public static final int RuleIndex_39_ = 39;
    public static final FormulaDeparser instance = new FormulaDeparser();

    public static String deParse(SyntaxTree syntaxTree) {
        StringBuilder sb = new StringBuilder(128);
        return instance.deParse(syntaxTree.getRoot(), sb).toString();
    }

    public static String deParse(Item item) {
        StringBuilder sb = new StringBuilder(128);
        return instance.deParse(item, sb).toString();
    }

    private StringBuilder deParse(Item item, StringBuilder sb) {
        Rule rule = item.getRule();
        if (rule != null) {
            int ruleIndex = rule.getIndex();
            switch (ruleIndex) {
                case 0: {
                    return this.deParse0Statement(item, sb);
                }
                case 1: {
                    return this.deParse1Statements(item, sb);
                }
                case 2: {
                    return this.deParse2Addition(item, sb);
                }
                case 3: {
                    return this.deparse3Subtraction(item, sb);
                }
                case 4: {
                    return this.deParse4Multiplication(item, sb);
                }
                case 5: {
                    return this.deParse5Division(item, sb);
                }
                case 6: {
                    return this.deParse6Concat(item, sb);
                }
                case 7: {
                    return this.deParse7Parenthesis(item, sb);
                }
                case 8: {
                    return this.deParse8Not(item, sb);
                }
                case 9: {
                    return this.deParse9Or(item, sb);
                }
                case 10: {
                    return this.deParse10And(item, sb);
                }
                case 11: {
                    return this.deParse11EqualsTo(item, sb);
                }
                case 12: {
                    return this.deParse12NotEqualsTo(item, sb);
                }
                case 13: {
                    return this.deParse13GreaterThan(item, sb);
                }
                case 14: {
                    return this.deParse14GreaterThanEquals(item, sb);
                }
                case 15: {
                    return this.deParse15MinorThan(item, sb);
                }
                case 16: {
                    return this.deParse16MinorThanEquals(item, sb);
                }
                case 17: {
                    return this.deParse17Const(item, sb);
                }
                case 18: {
                    return this.deParse18ID(item, sb);
                }
                case 19: {
                    return this.deParse19Function(item, sb);
                }
                case 20: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 21: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 22: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 23: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 24: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 25: {
                    return this.deParse25Var(item, sb);
                }
                case 26: {
                    return this.deParse26IfHead(item, sb);
                }
                case 27: {
                    return this.deParse27IfElse(item, sb);
                }
                case 28: {
                    return this.deParse26IfHead(item, sb);
                }
                case 29: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 30: {
                    return this.deParse30While(item, sb);
                }
                case 31: {
                    return this.deParse31SetValue(item, sb);
                }
                case 32: {
                    return this.deParse32Return(item, sb);
                }
                case 33: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 34: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 35: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 36: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 37: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 38: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 39: {
                    throw new NotImplementedException("Code is not implemented");
                }
            }
        }
        throw new NotImplementedException("Code is not implemented");
    }

    private StringBuilder deParse0Statement(Item factor, StringBuilder sb) {
        return this.deParse(factor.getFactor(0), sb);
    }

    private StringBuilder deParse1Statements(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb);
        int i = 2;
        int size = factor.getChildCount();
        while (i < size) {
            sb.append("; ");
            this.deParse(factor.getFactor(i), sb);
            i += 2;
        }
        return sb;
    }

    private StringBuilder deParse2Addition(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" + ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deparse3Subtraction(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" - ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse4Multiplication(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" * ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse5Division(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" / ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse6Concat(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" & ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse7Parenthesis(Item factor, StringBuilder sb) {
        sb.append("(");
        this.deParse(factor.getFactor(1), sb);
        return sb.append(")");
    }

    private StringBuilder deParse8Not(Item factor, StringBuilder sb) {
        sb.append("!");
        return this.deParse(factor.getFactor(1), sb);
    }

    private StringBuilder deParse9Or(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" || ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse10And(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" && ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse11EqualsTo(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" == ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse12NotEqualsTo(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" <> ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse13GreaterThan(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" > ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse14GreaterThanEquals(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" >= ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse15MinorThan(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" < ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse16MinorThanEquals(Item factor, StringBuilder sb) {
        this.deParse(factor.getFactor(0), sb).append(" <= ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse17Const(Item factor, StringBuilder sb) {
        Object value = factor.getFactor(0).getValue();
        if (value instanceof String) {
            return sb.append("'").append(value).append("'");
        }
        return sb.append(value);
    }

    private StringBuilder deParse18ID(Item factor, StringBuilder sb) {
        return sb.append(factor.getFactor(0).getFullLexValue());
    }

    private StringBuilder deParse19Function(Item factor, StringBuilder sb) {
        sb.append(factor.getFactor(0).getFullLexValue()).append("(");
        int size = factor.getChildCount();
        if (size >= 4) {
            this.deParse(factor.getFactor(2), sb);
        }
        int i = 4;
        while (i < size) {
            sb.append(", ");
            this.deParse(factor.getFactor(i), sb);
            i += 2;
        }
        return sb.append(")");
    }

    private StringBuilder deParse25Var(Item factor, StringBuilder sb) {
        sb.append(factor.getFactor(0).getFullLexValue()).append(" ");
        sb.append(factor.getFactor(1).getFullLexValue()).append(" = ");
        return this.deParse(factor.getFactor(3), sb);
    }

    private StringBuilder deParse26IfHead(Item factor, StringBuilder sb) {
        sb.append(factor.getFactor(0).getFullLexValue()).append("(");
        this.deParse(factor.getFactor(2), sb).append(") {");
        return this.deParse(factor.getFactor(5), sb).append("}");
    }

    private StringBuilder deParse27IfElse(Item factor, StringBuilder sb) {
        sb.append(factor.getFactor(0).getFullLexValue()).append("(");
        this.deParse(factor.getFactor(2), sb).append(") {");
        this.deParse(factor.getFactor(5), sb).append("} ");
        sb.append(factor.getFactor(7).getFullLexValue()).append(" {");
        return this.deParse(factor.getFactor(9), sb).append("}");
    }

    private StringBuilder deParse30While(Item factor, StringBuilder sb) {
        sb.append(factor.getFactor(0).getFullLexValue()).append(" (");
        this.deParse(factor.getFactor(2), sb).append(") {");
        return this.deParse(factor.getFactor(5), sb).append("}");
    }

    private StringBuilder deParse31SetValue(Item factor, StringBuilder sb) {
        sb.append(factor.getFactor(0).getFullLexValue()).append(" = ");
        return this.deParse(factor.getFactor(2), sb);
    }

    private StringBuilder deParse32Return(Item factor, StringBuilder sb) {
        sb.append(factor.getFactor(0).getFullLexValue()).append(" ");
        return this.deParse(factor.getFactor(1), sb);
    }
}

