/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.helper;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public final class XmlHelper {
    public static String format(TagNode tagNode, int level) {
        StringBuilder strBuilder = new StringBuilder();
        if (level == 0) {
            strBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n");
            XmlHelper.appendPreComment(strBuilder, (AbstractNode)tagNode, level);
        }
        XmlHelper.appendLevelBlank(strBuilder, level);
        String sAttrs = XmlHelper.getAttrsString(tagNode.getAttributes());
        strBuilder.append("<").append(tagNode.getTagName());
        if (!StringUtil.isEmptyStr((String)sAttrs)) {
            strBuilder.append(" ");
        }
        strBuilder.append(sAttrs);
        List nodes = tagNode.getChildren();
        if (nodes.size() > 0) {
            strBuilder.append(">").append("\r\n");
            for (AbstractNode node : nodes) {
                XmlHelper.appendPreComment(strBuilder, node, level + 1);
                if (node instanceof TagNode) {
                    strBuilder.append(XmlHelper.format((TagNode)node, level + 1)).append("\r\n");
                } else {
                    strBuilder.append(node.toXml(level + 1)).append("\r\n");
                }
                XmlHelper.appendLastComment(strBuilder, node, level + 1);
            }
            XmlHelper.appendLevelBlank(strBuilder, level);
            strBuilder.append("</").append(tagNode.getTagName()).append(">");
        } else {
            strBuilder.append("/>");
        }
        if (level == 0) {
            strBuilder.append("\r\n");
            XmlHelper.appendLastComment(strBuilder, (AbstractNode)tagNode, level);
        }
        return strBuilder.toString();
    }

    private static void appendPreComment(StringBuilder strBuilder, AbstractNode node, int level) {
        List listPreComment = node.getPreComment();
        if (CollectionUtils.isEmpty((Collection)listPreComment)) {
            return;
        }
        for (AbstractNode comment : listPreComment) {
            strBuilder.append(comment.toXml(level)).append("\r\n");
        }
    }

    public static void appendLevelBlank(StringBuilder strBuilder, int level) {
        int i = 0;
        while (i < level) {
            strBuilder.append("    ");
            ++i;
        }
    }

    private static String getAttrsString(Map<String, String> attributes) {
        StringBuilder sAttrs = new StringBuilder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (sAttrs.length() == 0) {
                sAttrs = new StringBuilder(String.valueOf(entry.getKey()) + "=\"" + entry.getValue() + "\"");
                continue;
            }
            sAttrs.append(" ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        return sAttrs.toString();
    }

    private static void appendLastComment(StringBuilder strBuilder, AbstractNode node, int level) {
        List listLastComment = node.getLastComment();
        if (CollectionUtils.isEmpty((Collection)listLastComment)) {
            return;
        }
        for (AbstractNode comment : listLastComment) {
            strBuilder.append(comment.toXml(level)).append("\r\n");
        }
    }
}

