/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.helper;

import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import org.apache.commons.lang3.StringUtils;

class ProfileInfo {
    private String key;
    private String caption;
    private String resource;
    private String extend = "";
    private String mainTableKey;
    private int primaryType = 0;
    private IMetaProject project;

    ProfileInfo() {
    }

    public static ProfileInfo getInstance(MetaForm metaForm) {
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.key = metaForm.getKey();
        profileInfo.mainTableKey = metaForm.getKey();
        profileInfo.caption = metaForm.getKey();
        profileInfo.project = metaForm.getProject();
        if (metaForm.getFormType() == 8) {
            profileInfo.primaryType = 1;
        }
        return profileInfo;
    }

    public static ProfileInfo getInstance(String key, String caption, String projectKey) throws Throwable {
        return ProfileInfo.getInstance(key, caption, projectKey, null, null);
    }

    public static ProfileInfo getInstance(String key, String caption, String projectKey, String mainTableKey, String parentKey) throws Throwable {
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.key = key;
        profileInfo.caption = caption;
        profileInfo.resource = "DataObject/" + key + ".xml";
        profileInfo.mainTableKey = StringUtils.isNotBlank((CharSequence)mainTableKey) ? mainTableKey : key;
        if (StringUtils.isNotBlank((CharSequence)parentKey)) {
            profileInfo.extend = parentKey;
        }
        profileInfo.project = MetaFactory.getGlobalInstance().getMetaProject(projectKey);
        return profileInfo;
    }

    public String getKey() {
        return this.key;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getResource() {
        return this.resource;
    }

    public String getExtend() {
        return this.extend;
    }

    public String getMainTableKey() {
        return this.mainTableKey;
    }

    public int getPrimaryType() {
        return this.primaryType;
    }

    public int getSecondaryType() {
        return 2;
    }

    public IMetaProject getProject() {
        return this.project;
    }
}

