/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.helper;

import com.bokesoft.yes.mid.base.CoreSetting;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public final class FilePathHelper {
    private static String workspacePath;
    private static String coreSolutionPath;
    private static String targetSolutionPath;

    public static final void setTargetSolutionPath(String targetSolutionPath) {
        FilePathHelper.targetSolutionPath = targetSolutionPath;
    }

    public static String toBackFilePath(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return "";
        }
        return filePath.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
    }

    public static String toFrontFilePath(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return "";
        }
        return filePath.replace("/", File.separator).replace("\\\\", File.separator).replace(File.separator, "\\");
    }

    public static String getCoreSolutionPath() throws IOException {
        if (StringUtils.isBlank((CharSequence)coreSolutionPath)) {
            FilePathHelper.initPath();
        }
        return coreSolutionPath;
    }

    public static String getWorkspacePath() throws IOException {
        if (StringUtils.isBlank((CharSequence)workspacePath)) {
            FilePathHelper.initPath();
        }
        return workspacePath;
    }

    private static void initPath() throws IOException {
        String solutionPath = targetSolutionPath == null ? FilePathHelper.toBackFilePath(CoreSetting.getInstance().getSolutionPath()) : targetSolutionPath;
        File solutionFile = FileUtils.getFile((String[])new String[]{solutionPath});
        coreSolutionPath = solutionFile.getCanonicalPath();
        workspacePath = solutionFile.getParentFile().getCanonicalPath();
    }
}

