/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.helper;

import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.xml.node.Xml4jUtil;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.helper.ProfileInfo;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaDataObjectLoad;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaDataObjectSave;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

public final class DataObjectHelper {
    public static final String MODULE_KEY = "D_DataObjectModule";
    public static final BiConsumer<ProfileInfo, MetaTableCollection> tableHandler = (targetProfileInfo, tableCollection) -> {
        for (MetaTable table : tableCollection) {
            table.setKey(targetProfileInfo.getKey());
            table.setCaption(targetProfileInfo.getCaption());
            table.setPersist(Boolean.valueOf(true));
        }
    };

    public static MetaDataObjectProfile getProfile(String dataObjectKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        return (MetaDataObjectProfile)dataObjectList.get(dataObjectKey);
    }

    public static MetaDataObject loadByKey(String dataObjectKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObjectProfile dataObjectProfile = (MetaDataObjectProfile)metaFactory.getDataObjectList().get(dataObjectKey);
        String resource = dataObjectProfile.getResource();
        IMetaProject project = dataObjectProfile.getProject();
        IMetaResolver resolver = metaFactory.getProjectResolver(project.getKey());
        MetaDataObjectLoad load = new MetaDataObjectLoad(2);
        load.load(resolver, resource);
        MetaDataObject metaDataObject = (MetaDataObject)load.getRootMetaObject();
        metaDataObject.setProject(project);
        return metaDataObject;
    }

    public static String createXml(MetaDataObject dataObject) throws Throwable {
        MetaDataObjectSave metaDataObjectSave = new MetaDataObjectSave((AbstractMetaObject)dataObject);
        Document document = metaDataObjectSave.getDocument();
        XmlCreator creator = new XmlCreator(document, null);
        String extend = dataObject.getExtend();
        if (StringUtils.isBlank((CharSequence)extend)) {
            return creator.createXml();
        }
        String extendFilePath = LoadFileTree.getPathByDataObject(extend);
        String tmpFilePath = XmlFileProcessor.instance.getTmpFile(extendFilePath);
        String realFilePath = StringUtils.isNotBlank((CharSequence)tmpFilePath) ? tmpFilePath : extendFilePath;
        XmlTree xmlTree = Xml4jUtil.parseTree(realFilePath);
        TagNode rootNode = DataObjectHelper.createVestNode(creator.createXmlTree().getRoot(), xmlTree);
        assert (rootNode != null);
        rootNode.setAttribute("Caption", dataObject.getCaption());
        rootNode.setAttribute("Extend", extend);
        rootNode.setAttribute("PrimaryTableKey", dataObject.getMainTableKey());
        rootNode.setAttribute("Version", "1");
        return rootNode.toXml(0);
    }

    public static MetaDataObjectProfile createInsideProfile(MetaForm metaForm) throws Throwable {
        MetaDataObject sourceDataObject = DataObjectHelper.getProfile(MODULE_KEY).getDataObject();
        ProfileInfo targetProfileInfo = ProfileInfo.getInstance(metaForm);
        return DataObjectHelper.createProfile(sourceDataObject, targetProfileInfo);
    }

    public static MetaDataObjectProfile createOutsideProfile(String key, String caption, String projectKey, String parentKey) throws Throwable {
        if (StringUtils.isBlank((CharSequence)parentKey)) {
            MetaDataObjectProfile sourceProfile = DataObjectHelper.getProfile(MODULE_KEY);
            MetaDataObject sourceDataObject = sourceProfile.getDataObject();
            ProfileInfo targetProfileInfo = ProfileInfo.getInstance(key, caption, projectKey);
            return DataObjectHelper.createProfile(sourceDataObject, targetProfileInfo);
        }
        MetaDataObjectProfile sourceProfile = DataObjectHelper.getProfile(parentKey);
        MetaDataObject sourceDataObject = sourceProfile.getDataObject();
        String mainTableKey = sourceDataObject.getMainTableKey();
        ProfileInfo targetProfileInfo = ProfileInfo.getInstance(key, caption, projectKey, mainTableKey, parentKey);
        MetaDataObjectProfile targetProfile = DataObjectHelper.createProfile(sourceDataObject, targetProfileInfo);
        return targetProfile;
    }

    public static List<MetaFormProfile> reload(DefaultContext context, String dataObjectKey, String dataObjectFilePath, String formFilePath) throws Throwable {
        return DataObjectHelper.reload(context, dataObjectKey, dataObjectFilePath, formFilePath, null);
    }

    public static List<MetaFormProfile> reload(DefaultContext context, String dataObjectKey, String dataObjectFilePath, String formFilePath, String snapshotFilePath) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(dataObjectKey);
        String mergeToSourceMapKey = "";
        HashSet<MetaFormProfile> allMetaFormProfiles = new HashSet<MetaFormProfile>();
        if (Objects.nonNull(metaDataObjectProfile)) {
            if (StringUtils.isNotBlank((CharSequence)metaDataObjectProfile.getExtend())) {
                Object extendPath = LoadFileTree.loadFilePathByDataObjectFieldKey(metaDataObjectProfile.getExtend());
                String tempPath = XmlFileProcessor.instance.getTmpFile((String)extendPath);
                extendPath = StringUtils.isNotBlank((CharSequence)tempPath) ? tempPath : extendPath;
                List<MetaFormProfile> metaFormProfiles = DesignReloadMetaObject.reloadMetaDataObjectRollbackError(metaDataObjectProfile.getExtend(), (String)extendPath);
                allMetaFormProfiles.addAll(metaFormProfiles);
            } else {
                for (MetaDataObjectProfile dataObjectProfile : dataObjectList) {
                    if (!StringUtils.equals((CharSequence)dataObjectProfile.getExtend(), (CharSequence)dataObjectKey)) continue;
                    mergeToSourceMapKey = dataObjectProfile.getKey();
                    break;
                }
            }
        }
        List<MetaFormProfile> metaFormProfiles = DesignReloadMetaObject.reloadMetaDataObjectRollbackError(dataObjectKey, dataObjectFilePath, formFilePath, snapshotFilePath);
        allMetaFormProfiles.addAll(metaFormProfiles);
        if (StringUtils.isNotBlank((CharSequence)mergeToSourceMapKey) && Objects.nonNull(dataObjectList.get(mergeToSourceMapKey))) {
            String vestPath = LoadFileTree.loadFilePathByDataObjectFieldKey(mergeToSourceMapKey);
            String tempVestPath = XmlFileProcessor.instance.getTmpFile(vestPath);
            vestPath = StringUtils.isNotBlank((CharSequence)tempVestPath) ? tempVestPath : vestPath;
            List<MetaFormProfile> metaFormProfiles3 = DesignReloadMetaObject.reloadMetaDataObjectRollbackError(mergeToSourceMapKey, vestPath);
            allMetaFormProfiles.addAll(metaFormProfiles3);
        }
        Map profileMap = allMetaFormProfiles.stream().collect(Collectors.toMap(MetaFormProfile::getKey, Function.identity(), (itemA, itemB) -> itemB));
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        ArrayList<String> resultKeyList = new ArrayList<String>();
        ArrayList<MetaFormProfile> resultProfileList = new ArrayList<MetaFormProfile>();
        for (Map.Entry entry : profileMap.entrySet()) {
            MetaFormProfile profile;
            String formKey = entry.getKey();
            if (resultKeyList.contains(formKey) || (profile = (MetaFormProfile)entry.getValue()).getResource() == null) continue;
            String parentKey = profile.getExtend();
            if (StringUtils.isNotBlank((CharSequence)parentKey) && !resultKeyList.contains(parentKey)) {
                resultKeyList.add(parentKey);
                MetaFormProfile parentProfile = profileMap.getOrDefault(parentKey, (MetaFormProfile)metaFormList.get(parentKey));
                resultProfileList.add(parentProfile);
            }
            resultKeyList.add(formKey);
            resultProfileList.add(profile);
        }
        List<MetaFormProfile> sortedReloadFormList = DataObjectHelper.sortNeedReloadFormList(metaFormList, resultProfileList);
        DesignReloadMetaObject.postReloadMetaDataObject(context, dataObjectKey, sortedReloadFormList, formFilePath);
        return resultProfileList;
    }

    public static Set<MetaFormProfile> getAllMetaFormProfilesByDataObjectKey(String dataObjectKey) throws Throwable {
        List<MetaFormProfile> metaFormProfiles;
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(dataObjectKey);
        String mergeToSourceMapKey = "";
        HashSet<MetaFormProfile> allMetaFormProfiles = new HashSet<MetaFormProfile>();
        if (Objects.nonNull(metaDataObjectProfile)) {
            if (StringUtils.isNotBlank((CharSequence)metaDataObjectProfile.getExtend())) {
                metaFormProfiles = DesignReloadMetaObject.getReloadMetaFormProfiles(metaDataObjectProfile.getExtend(), metaFactory);
                allMetaFormProfiles.addAll(metaFormProfiles);
            } else {
                for (MetaDataObjectProfile dataObjectProfile : dataObjectList) {
                    if (!StringUtils.equals((CharSequence)dataObjectProfile.getExtend(), (CharSequence)dataObjectKey)) continue;
                    mergeToSourceMapKey = dataObjectProfile.getKey();
                    break;
                }
            }
        }
        metaFormProfiles = DesignReloadMetaObject.getReloadMetaFormProfiles(dataObjectKey, metaFactory);
        allMetaFormProfiles.addAll(metaFormProfiles);
        if (StringUtils.isNotBlank((CharSequence)mergeToSourceMapKey) && Objects.nonNull(dataObjectList.get(mergeToSourceMapKey))) {
            List<MetaFormProfile> metaFormProfiles3 = DesignReloadMetaObject.getReloadMetaFormProfiles(mergeToSourceMapKey, metaFactory);
            allMetaFormProfiles.addAll(metaFormProfiles3);
        }
        return allMetaFormProfiles;
    }

    private static MetaDataObjectProfile createProfile(MetaDataObject sourceDataObject, ProfileInfo targetProfileInfo) throws Throwable {
        MetaDataObject dataObject = (MetaDataObject)sourceDataObject.depthClone();
        dataObject.setKey(targetProfileInfo.getKey());
        dataObject.setExtend(targetProfileInfo.getExtend());
        dataObject.setCaption(targetProfileInfo.getCaption());
        dataObject.setMainTableKey(targetProfileInfo.getMainTableKey());
        dataObject.setProject(targetProfileInfo.getProject());
        dataObject.setPrimaryType(Integer.valueOf(targetProfileInfo.getPrimaryType()));
        dataObject.setVersion(Integer.valueOf(1));
        if (targetProfileInfo.getPrimaryType() == 1) {
            dataObject.setPrimaryType(Integer.valueOf(2));
        }
        if (StringUtils.isNotBlank((CharSequence)targetProfileInfo.getExtend())) {
            sourceDataObject.setMergeToSourceMapKey(targetProfileInfo.getKey());
        } else {
            MetaTableCollection tableCollection = dataObject.getTableCollection();
            MetaTableCollection collection = new MetaTableCollection();
            dataObject.setTableCollection(collection);
            for (MetaTable table : tableCollection) {
                table.setKey(targetProfileInfo.getKey());
                table.setCaption(targetProfileInfo.getCaption());
                table.setPersist(Boolean.valueOf(true));
                collection.add((KeyPairMetaObject)table);
            }
        }
        dataObject.doPostProcess(0, null);
        MetaDataObjectProfile dataObjectProfile = new MetaDataObjectProfile();
        dataObjectProfile.setKey(targetProfileInfo.getKey());
        dataObjectProfile.setExtend(targetProfileInfo.getExtend());
        dataObjectProfile.setCaption(targetProfileInfo.getCaption());
        dataObjectProfile.setResource(targetProfileInfo.getResource());
        dataObjectProfile.setDataObject(dataObject);
        dataObjectProfile.setProject(targetProfileInfo.getProject());
        dataObjectProfile.setPrimaryType(Integer.valueOf(targetProfileInfo.getPrimaryType()));
        dataObjectProfile.setSecondaryType(Integer.valueOf(targetProfileInfo.getSecondaryType()));
        return dataObjectProfile;
    }

    private static TagNode createVestNode(TagNode node, XmlTree xmlTree) {
        String key;
        String tagName = node.getTagName();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)tagName, (CharSequence[])new CharSequence[]{"EmbedTableCollection", "PreLoadProcess", "PostLoadProcess", "PreSaveProcess", "PostSaveProcess", "PreDeleteProcess", "TableCollection", "PostDeleteProcess", "StatusCollection", "StatusTriggerCollection", "ExtendCollection", "CheckRuleCollection", "MacroCollection"})) {
            return null;
        }
        if (StringUtils.equals((CharSequence)tagName, (CharSequence)"Table") && !xmlTree.containKey("Table@" + (key = (String)node.getAttributes().get("Key")))) {
            return null;
        }
        String attrName = node.getPrimaryAttrName();
        TagNode vestNode = new TagNode(tagName);
        if (StringUtils.isNotBlank((CharSequence)attrName)) {
            vestNode.setAttribute(attrName, (String)node.getAttributes().get(attrName));
        }
        if (StringUtils.equals((CharSequence)tagName, (CharSequence)"Table")) {
            return vestNode;
        }
        List childNodeList = node.getChildren();
        for (AbstractNode childNode : childNodeList) {
            TagNode vestChildNode;
            if (!(childNode instanceof TagNode) || Objects.isNull(vestChildNode = DataObjectHelper.createVestNode((TagNode)childNode, xmlTree))) continue;
            vestNode.addNode((AbstractNode)vestChildNode);
        }
        return vestNode;
    }

    private static List<MetaFormProfile> sortNeedReloadFormList(MetaFormList metaFormList, List<MetaFormProfile> resultProfileList) {
        List<MetaFormProfile> templateFormList = resultProfileList.stream().filter(item -> item.getFormType() == 8).sorted(Comparator.comparing(MetaFormProfile::getKey)).collect(Collectors.toList());
        List<MetaFormProfile> templateSortFormList = DataObjectHelper.getNeedReloadFormList(metaFormList, templateFormList);
        List<MetaFormProfile> notTemplateFormList = resultProfileList.stream().filter(item -> item.getFormType() != 8).sorted(Comparator.comparing(MetaFormProfile::getKey)).collect(Collectors.toList());
        List<MetaFormProfile> notTemplateSortFormList = DataObjectHelper.getNeedReloadFormList(metaFormList, notTemplateFormList);
        ArrayList<MetaFormProfile> sortedReloadFormList = new ArrayList<MetaFormProfile>();
        sortedReloadFormList.addAll(templateSortFormList);
        sortedReloadFormList.addAll(notTemplateSortFormList);
        return sortedReloadFormList;
    }

    private static List<MetaFormProfile> getNeedReloadFormList(MetaFormList metaFormList, List<MetaFormProfile> resultProfileList) {
        List firstReloadFormList = resultProfileList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getExtend())).map(item -> (MetaFormProfile)metaFormList.get(item.getExtend())).distinct().sorted(Comparator.comparing(MetaFormProfile::getKey)).collect(Collectors.toList());
        List secondReloadFormList = resultProfileList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getExtend()) && item.getMergeToSource() != false).sorted(Comparator.comparing(MetaFormProfile::getKey)).collect(Collectors.toList());
        List thirdReloadFormList = resultProfileList.stream().filter(item -> !firstReloadFormList.contains(item) && !secondReloadFormList.contains(item)).sorted(Comparator.comparing(MetaFormProfile::getKey)).collect(Collectors.toList());
        ArrayList<MetaFormProfile> sortedReloadFormList = new ArrayList<MetaFormProfile>();
        sortedReloadFormList.addAll(firstReloadFormList);
        sortedReloadFormList.addAll(secondReloadFormList);
        sortedReloadFormList.addAll(thirdReloadFormList);
        return sortedReloadFormList;
    }
}

