/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.xml.parse;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.xml.parse.Element;
import com.bokesoft.yes.design.xml.parse.Ignorer;
import com.bokesoft.yes.design.xml.parse.PrivateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Util {
    public static int getBeginIndex(String xml) {
        return Ignorer.getXmlBeginIndex(xml);
    }

    public static String deleteXmlHead(String xml) {
        if (Objects.isNull(xml)) {
            return null;
        }
        int c = Util.getBeginIndex(xml);
        if (c > 0) {
            return xml.substring(c);
        }
        return xml;
    }

    public static List<Element> getElements(String xml) {
        if (Objects.isNull(xml)) {
            return null;
        }
        ArrayList<Element> list = new ArrayList<Element>();
        int ix = Util.getBeginIndex(xml);
        int maxIndex = xml.length();
        while (ix < maxIndex) {
            Element ele = Util.getNextElement(xml, ix);
            list.add(ele);
            ix = ele.getEndIndex() + 1;
        }
        return list;
    }

    public static Element getNextElement(String xml, int bg) {
        int i = bg;
        while (i < xml.length()) {
            char c = xml.charAt(i);
            if (c == '<') {
                if (i != bg) {
                    Element ele = new Element();
                    ele.setBgIndex(bg);
                    ele.setType(1);
                    ele.setText(xml.substring(bg, i));
                    ele.setEndIndex(i - 1);
                    return ele;
                }
                if (StringUtil.isString((String)xml, (String)"</", (int)i)) {
                    return PrivateUtil.getEndTag(xml, i);
                }
                if (StringUtil.isString((String)xml, (String)"<!--", (int)i)) {
                    return PrivateUtil.getComment(xml, i);
                }
                if (StringUtil.isString((String)xml, (String)"<![CDATA[", (int)i)) {
                    return PrivateUtil.getCDATA(xml, i);
                }
                if (StringUtil.isString((String)xml, (String)"<!DOCTYPE", (int)i)) {
                    return PrivateUtil.getDTD(xml, i);
                }
                return PrivateUtil.getStartTag(xml, i);
            }
            ++i;
        }
        Element ele = new Element();
        ele.setBgIndex(bg);
        ele.setType(1);
        ele.setEndIndex(xml.length() - 1);
        ele.setText(xml.substring(bg));
        return ele;
    }

    public String deleteNotUse(String xml) {
        return xml;
    }
}

