/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.xml.node;

import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.CommentNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.parse.Element;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNodeDefine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class XmlTree {
    private final TagNode root;
    private final List<AbstractNode> allNodeWithCommnet = new Vector<AbstractNode>();
    private HashMap<String, AbstractNode> mapNodes = new HashMap();
    private final HashMap<String, AbstractNode> relativelyMapNodes = new HashMap();
    private String orgXml;
    private List<Integer> lines = null;

    public XmlTree(TagNode root) {
        this.root = root;
    }

    public TagNode getRoot() {
        return this.root;
    }

    public void addPreComment(List<AbstractNode> comments) {
        this.root.addPreComment(comments);
    }

    public void addLastComment(List<AbstractNode> comments) {
        this.root.addLastComment(comments);
    }

    public HashMap<String, AbstractNode> getMapNodes() {
        return this.mapNodes;
    }

    public void updateMap(boolean isExamination) throws Throwable {
        ArrayList<AbstractNode> commentList = new ArrayList<AbstractNode>();
        this.updateMap(this.root, commentList, isExamination);
    }

    private void updateMap(TagNode tagNode, List<AbstractNode> commentList) throws Throwable {
        if (Objects.isNull(tagNode)) {
            return;
        }
        tagNode.addPreComment(commentList);
        this.recordNodeWithComment(commentList, tagNode);
        commentList.clear();
        this.assertUniqueKey(tagNode);
        if (tagNode.getPrimaryKey() != null) {
            String parentPrimaryKey = "";
            TagNode parent = tagNode.getParent();
            parentPrimaryKey = this.getParentPrimaryKey(parentPrimaryKey, parent);
            this.relativelyMapNodes.put(String.valueOf(parentPrimaryKey) + "->" + tagNode.getPrimaryKey(), tagNode);
            this.mapNodes.put(tagNode.getPrimaryKey(), tagNode);
        }
        List<AbstractNode> children = tagNode.getChildren();
        AbstractNode node = null;
        AbstractNode tmpTagNode = null;
        int size = children.size();
        int n = 0;
        while (n < size) {
            node = children.get(n);
            if (node instanceof TagNode) {
                this.updateMap((TagNode)node, commentList);
                tmpTagNode = node;
            } else if (node instanceof CommentNode) {
                commentList.add(node);
            } else if (node instanceof CDataNode) {
                node.addPreComment(commentList);
                this.recordNodeWithComment(commentList, node);
                commentList.clear();
                tmpTagNode = node;
            }
            ++n;
        }
        if (tmpTagNode != null) {
            tmpTagNode.addLastComment(commentList);
            this.recordNodeWithComment(commentList, tmpTagNode);
            commentList.clear();
        }
    }

    private void updateMap(TagNode tagNode, List<AbstractNode> commentList, boolean isExamination) throws Throwable {
        if (isExamination) {
            this.mapNodes = new HashMap();
            this.updateMap(tagNode, commentList);
        } else {
            if (Objects.isNull(tagNode)) {
                return;
            }
            tagNode.addPreComment(commentList);
            this.recordNodeWithComment(commentList, tagNode);
            commentList.clear();
            String parentPrimaryKey = "";
            TagNode parent = tagNode.getParent();
            parentPrimaryKey = this.getParentPrimaryKey(parentPrimaryKey, parent);
            this.relativelyMapNodes.put(String.valueOf(parentPrimaryKey) + "->" + tagNode.getPrimaryKey(), tagNode);
            this.mapNodes.put(tagNode.getPrimaryKey(), tagNode);
            List<AbstractNode> children = tagNode.getChildren();
            AbstractNode node = null;
            AbstractNode tmpTagNode = null;
            int size = children.size();
            int n = 0;
            while (n < size) {
                node = children.get(n);
                if (node instanceof TagNode) {
                    this.updateMap((TagNode)node, commentList, isExamination);
                    tmpTagNode = node;
                } else if (node instanceof CommentNode) {
                    commentList.add(node);
                } else if (node instanceof CDataNode) {
                    node.addPreComment(commentList);
                    this.recordNodeWithComment(commentList, node);
                    commentList.clear();
                    tmpTagNode = node;
                }
                ++n;
            }
            if (tmpTagNode != null) {
                tmpTagNode.addLastComment(commentList);
                this.recordNodeWithComment(commentList, tmpTagNode);
                commentList.clear();
            }
        }
    }

    private void assertUniqueKey(TagNode tagNode) throws Throwable {
        boolean flag;
        if (Objects.isNull(tagNode.getPrimaryKey())) {
            return;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)tagNode.getTagName(), (CharSequence[])new CharSequence[]{"Item", "Var", "GridRow", "Column", "Field", "SourceField", "Entry", "EntryItem", "Operation", "OptPermItem", "CustomConditionPara", "DropdownItem", "ExtraLayout", "Collapsible", "Item", "EmbedTableCollection", "PreLoadProcess", "PostLoadProcess", "PreSaveProcess", "PostSaveProcess", "PreDeleteProcess", "PostDeleteProcess", "StatusCollection", "StatusTriggerCollection", "ExtendCollection", "CheckRuleCollection", "MacroCollection", "SysColumn", "ItemFilter", "Filter", "FilterValue", "EnablePermItem", "VisiblePermItem", "TimerItem", "TimerAutoDeny", "TimerAutoPass", "Audit"})) {
            return;
        }
        Set panelType = Stream.of("Grid", "SubDetail", "GridLayoutPanel", "FlexFlowLayoutPanel", "SplitPanel", "TabPanel", "FlowLayoutPanel", "ColumnLayoutPanel", "ListView", "Embed").collect(Collectors.toCollection(HashSet::new));
        HashSet intersection = new HashSet();
        if (panelType.contains(tagNode.getTagName())) {
            String key = tagNode.getAttributes().get("Key");
            Set collect = panelType.stream().filter(m -> !StringUtils.equals((CharSequence)tagNode.getTagName(), (CharSequence)m)).map(m -> String.valueOf(m) + "@" + key).collect(Collectors.toSet());
            intersection.clear();
            intersection.addAll(collect);
            intersection.retainAll(this.mapNodes.keySet());
        }
        boolean bl = flag = this.mapNodes.containsKey(tagNode.getPrimaryKey()) || intersection.size() != 0;
        if (flag) {
            throw new Throwable("\u5b58\u5728\u91cd\u590dKey:" + tagNode.getPrimaryKey());
        }
    }

    private void recordNodeWithComment(List<AbstractNode> commnetList, AbstractNode node) {
        if (commnetList.size() > 0 && !this.allNodeWithCommnet.contains(node)) {
            this.allNodeWithCommnet.add(node);
        }
    }

    public List<CDataNode> findCDataNodes() {
        ArrayList<CDataNode> list = new ArrayList<CDataNode>();
        this.relativelyMapNodes.forEach((a, Node2) -> {
            if (Node2 instanceof CDataNode) {
                list.add((CDataNode)Node2);
            } else if (Node2 instanceof TagNode) {
                ((TagNode)Node2).findCDataNodesByTagName(list);
            }
        });
        return list;
    }

    private String getParentPrimaryKey(String parentPrimaryKey, TagNode parent) {
        if (parent != null) {
            String attrKey = DefaultNodeDefine.getInstance().getPrimaryKey(parent.getTagName());
            String primaryValue = parent.getAttributes().get(attrKey);
            parentPrimaryKey = StringUtils.isEmpty((CharSequence)primaryValue) ? parentPrimaryKey.concat(this.getParentPrimaryKey(parentPrimaryKey, parent.getParent())) : parent.getPrimaryKey();
        }
        return parentPrimaryKey;
    }

    public List<AbstractNode> getNodesWithComment() {
        return this.allNodeWithCommnet;
    }

    public TagNode getTagNode(String key) {
        return (TagNode)this.mapNodes.get(key);
    }

    public TagNode getTagNodeByRelatively(String key) {
        return (TagNode)this.relativelyMapNodes.get(key);
    }

    public boolean containKey(String key) {
        return this.mapNodes.containsKey(key);
    }

    public void setOrgXml(String xml) {
        this.orgXml = xml;
    }

    public String getOrgXml() {
        return this.orgXml;
    }

    private void initLines() {
        if (Objects.isNull(this.lines)) {
            this.lines = new ArrayList<Integer>();
            this.lines.add(0);
            int pos = -1;
            while ((pos = this.orgXml.indexOf("\n", pos + 1)) >= 0) {
                this.lines.add(pos);
            }
        }
    }

    public int getLineCount() {
        this.initLines();
        return this.lines.size();
    }

    public int getLineByIndex(int index) {
        this.initLines();
        int left = 0;
        int size = this.lines.size();
        int right = size - 1;
        while (left <= right) {
            int mid = left + right >> 1;
            if (this.lines.get(mid) < index) {
                if (mid < size && this.lines.get(mid + 1) > index) {
                    return mid;
                }
                left = mid + 1;
                continue;
            }
            if (this.lines.get(mid) > index) {
                if (mid > 0 && this.lines.get(mid - 1) <= index) {
                    return mid - 1;
                }
                right = mid - 1;
                continue;
            }
            return mid;
        }
        return size;
    }

    public String getLineString(int line) {
        this.initLines();
        if (line + 1 <= this.lines.size() - 1) {
            return this.orgXml.substring(this.lines.get(line) + 1, this.lines.get(line + 1) + 1);
        }
        return null;
    }

    public int getLineStartPos(int line) {
        this.initLines();
        if (line > this.lines.size() - 1) {
            line = this.lines.size() - 1;
        }
        return this.lines.get(line) + 1;
    }

    public String getNodeString(int nodeStratLine) {
        int startPos = this.getLineStartPos(nodeStratLine);
        int nodeEndLine = this.getNodeEndLine(nodeStratLine);
        int endPos = this.getLineStartPos(nodeEndLine + 1);
        return this.orgXml.substring(startPos, endPos).trim();
    }

    public int getNodeEndLine(int nodeStartLine) {
        String lineString = this.getLineString(nodeStartLine).trim();
        if (lineString.endsWith("/>")) {
            return nodeStartLine;
        }
        String tagName = XmlTree.getSubString(lineString, "<([A-Za-z_]\\w*)[\\s>]");
        Stack<String> stack = new Stack<String>();
        stack.push(tagName);
        int endLine = nodeStartLine + 1;
        boolean isCDATA = false;
        boolean isComment = false;
        boolean isDataBingContent = false;
        while (endLine < this.getLineCount()) {
            if (this.getLineString(endLine) == null) break;
            String nextLineString = this.getLineString(endLine).trim();
            if (!StringUtils.isEmpty((CharSequence)nextLineString)) {
                if (isCDATA) {
                    if (nextLineString.endsWith("]]>")) {
                        isCDATA = false;
                    }
                } else if (nextLineString.startsWith("<![CDATA[")) {
                    if (!nextLineString.endsWith("]]>")) {
                        isCDATA = true;
                    }
                } else if (isComment) {
                    if (nextLineString.endsWith("-->")) {
                        isComment = false;
                    }
                } else if (nextLineString.startsWith("<!--")) {
                    if (!nextLineString.endsWith("-->")) {
                        isComment = true;
                    }
                } else if (isDataBingContent) {
                    if (nextLineString.endsWith("/>") || nextLineString.endsWith("</DataBinding>") || nextLineString.endsWith("</DataBinding>\n")) {
                        isDataBingContent = false;
                    }
                } else if (nextLineString.startsWith("<DataBinding")) {
                    if (!nextLineString.endsWith("/>") || !nextLineString.endsWith(">")) {
                        isDataBingContent = true;
                    }
                    if (nextLineString.endsWith("</DataBinding>")) {
                        isDataBingContent = false;
                    }
                } else if (nextLineString.startsWith("</")) {
                    String closeTagName = XmlTree.getSubString(nextLineString, "</([A-Za-z_]\\w*)>");
                    if (!closeTagName.equals(stack.peek())) {
                        throw new RuntimeException("XML\u8282\u70b9\u5173\u7cfb\u4e0d\u5bf9\u3002");
                    }
                    stack.pop();
                    if (stack.isEmpty()) {
                        break;
                    }
                } else if (!nextLineString.endsWith("/>")) {
                    String nextTagName = XmlTree.getSubString(nextLineString, "<([A-Za-z_]\\w*)[\\s>]");
                    stack.push(nextTagName);
                }
            }
            ++endLine;
        }
        return endLine;
    }

    public List<AbstractNode> getDetailNodeByLine(int startPos, int endPos) {
        ArrayList<AbstractNode> result = new ArrayList<AbstractNode>();
        this.getDetailNodeByLine(startPos, endPos, this.root, result);
        return result;
    }

    private void getDetailNodeByLine(int startPos, int endPos, AbstractNode node, List<AbstractNode> detailNodes) {
        int nodeEndPos;
        Element element = node.getElement();
        int nodeStartPos = element.getBgIndex();
        List<AbstractNode> children = node instanceof TagNode ? ((TagNode)node).getChildren() : null;
        int size = Objects.isNull(children) ? 0 : children.size();
        int n = nodeEndPos = size == 0 ? element.getBgIndex() : children.get(size - 1).getElement().getEndIndex();
        if (!(nodeStartPos < startPos && nodeEndPos > endPos || nodeStartPos >= startPos && nodeStartPos <= endPos || nodeEndPos >= startPos && nodeEndPos <= endPos)) {
            return;
        }
        if (nodeStartPos < startPos && nodeEndPos > endPos && size == 0 || nodeStartPos >= startPos && nodeStartPos <= endPos || nodeEndPos >= startPos && nodeEndPos <= endPos) {
            detailNodes.add(node);
        }
        int i = 0;
        while (i < size) {
            AbstractNode child = children.get(i);
            this.getDetailNodeByLine(startPos, endPos, child, detailNodes);
            ++i;
        }
    }

    private static String getSubString(String s, String pattern) {
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        throw new RuntimeException("\u5b57\u7b26\u4e32" + s + "\u4e2d\u6ca1\u6709\u627e\u5230" + pattern);
    }
}

