/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.xml.node;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.parse.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractNode {
    protected String text = null;
    private TagNode parent = null;
    private final Element ele;
    private List<AbstractNode> preCommnetList = null;
    private List<AbstractNode> lastCommnetList = null;

    public AbstractNode(String text, Element ele) {
        this.text = text;
        this.ele = ele;
    }

    public String getText() {
        return this.text;
    }

    public Element getElement() {
        return this.ele;
    }

    public void appendLevelBlank(StringBuilder strBuilder, int level) {
        int i = 0;
        while (i < level) {
            strBuilder.append("    ");
            ++i;
        }
    }

    public abstract String toXml(int var1);

    public String toXml(int level, boolean escape) {
        return this.toXml(level);
    }

    public abstract AbstractNode clone();

    public abstract boolean hasPrimaryAttribute();

    public TagNode getParent() {
        return this.parent;
    }

    public void setParent(TagNode parent) {
        this.parent = parent;
    }

    public boolean isRoot() {
        return Objects.isNull(this.parent);
    }

    public void addPreComment(List<AbstractNode> comments) {
        if (CollectionUtils.isEmpty(comments)) {
            return;
        }
        if (Objects.isNull(this.preCommnetList)) {
            this.preCommnetList = new ArrayList<AbstractNode>();
        }
        for (AbstractNode node : comments) {
            this.preCommnetList.add(node);
        }
    }

    public void addLastComment(List<AbstractNode> comments) {
        if (CollectionUtils.isEmpty(comments)) {
            return;
        }
        if (Objects.isNull(this.lastCommnetList)) {
            this.lastCommnetList = new ArrayList<AbstractNode>();
        }
        for (AbstractNode node : comments) {
            this.lastCommnetList.add(node);
        }
    }

    public List<AbstractNode> getPreComment() {
        return this.preCommnetList;
    }

    public List<AbstractNode> getLastComment() {
        return this.lastCommnetList;
    }

    protected String convertSpecialChars(String str, boolean escape) {
        if (escape) {
            str = StringUtil.replaceAll((String)str, (String)"&", (String)"&amp;");
            str = StringUtil.replaceAll((String)str, (String)"<", (String)"&lt;");
            str = StringUtil.replaceAll((String)str, (String)">", (String)"&gt;");
            str = StringUtil.replaceAll((String)str, (String)"\"", (String)"&quot;");
        }
        return str;
    }
}

