/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.xml.dom;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.common.util.DebugUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.xml.dom.IFileResolver;
import com.bokesoft.yes.design.xml.dom.IXMLPropertyBag;
import com.bokesoft.yes.design.xml.dom.KeyPairBaseObject;
import com.bokesoft.yes.design.xml.dom.XMLItem;
import com.bokesoft.yes.design.xml.dom.XMLPropertyBagBaseObject;
import com.bokesoft.yes.util.HashMapKeyIgnoreCase;
import com.bokesoft.yes.util.LinkedHashMapKeyIgnoreCase;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLPropertyBag {
    private static final String vartype = "VARTYPE";
    private static final String nothing = "NOTHING";
    public static final boolean THROW_EX = true;

    public static void readProperties(Document doc, String key, Element element, Class<?> cls, XMLPropertyBagBaseObject parent, ArrayList arr, int flag) throws Throwable {
        arr.clear();
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Node node = children.item(i);
            if (node instanceof Element) {
                Element elm = (Element)node;
                if (key.length() == 0 || node.getNodeName().equalsIgnoreCase(key)) {
                    Object o = null;
                    if (elm.getAttributes().getLength() != 1 || !elm.hasAttribute(vartype) || !elm.getAttribute(vartype).equals(nothing)) {
                        try {
                            o = cls.newInstance();
                        }
                        catch (Throwable e) {
                            LogSvr.getInstance().error(e.getMessage(), e);
                        }
                        if (Objects.isNull(o)) {
                            return;
                        }
                        XMLPropertyBagBaseObject bag = (XMLPropertyBagBaseObject)o;
                        bag.setParentItem(parent);
                        bag.ReadProperties(doc, elm, flag);
                    }
                    arr.add(o);
                }
            }
            ++i;
        }
    }

    public static List<Element> enumChildren(Document doc, Element element, String tagName) {
        ArrayList<Element> arrChild = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Element elm;
            Node node = children.item(i);
            if (node instanceof Element && (elm = (Element)node).getTagName().equalsIgnoreCase(tagName)) {
                arrChild.add(elm);
            }
            ++i;
        }
        return arrChild;
    }

    public static void readProperties(Document doc, Element element, HashMapKeyIgnoreCase<Class> metaNameToClass, XMLPropertyBagBaseObject parent, LinkedHashMapKeyIgnoreCase map, int flag) throws Throwable {
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Node node = children.item(i);
            if (node instanceof Element) {
                Element elm = (Element)node;
                Object o = null;
                try {
                    Class cls = (Class)metaNameToClass.get(node.getNodeName());
                    o = cls.newInstance();
                }
                catch (InstantiationException e) {
                    throw new InstantiationException();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessException();
                }
                catch (Throwable e) {
                    throw new Exception();
                }
                if (Objects.isNull(o)) {
                    return;
                }
                KeyPairBaseObject ko = o;
                XMLPropertyBagBaseObject bag = o;
                bag.setParentItem(parent);
                bag.ReadProperties(doc, elm, flag);
                map.put(ko.getKey(), (Object)ko);
            }
            ++i;
        }
    }

    public static void readProperties(Document doc, String key, Element element, Class<?> cls, XMLPropertyBagBaseObject parent, LinkedHashMapKeyIgnoreCase map, int flag) throws Throwable {
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            block8: {
                Node node = children.item(i);
                if (node instanceof Element) {
                    Element elm = (Element)node;
                    Object o = null;
                    try {
                        String nodeName = node.getNodeName();
                        if (key.length() != 0 && !nodeName.equalsIgnoreCase(key)) break block8;
                        o = cls.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new InstantiationException();
                    }
                    catch (IllegalAccessException e) {
                        throw new Exception();
                    }
                    catch (Throwable e) {
                        throw new Exception();
                    }
                    if (Objects.isNull(o)) {
                        return;
                    }
                    KeyPairBaseObject ko = o;
                    XMLPropertyBagBaseObject bag = o;
                    bag.setParentItem(parent);
                    bag.ReadProperties(doc, elm, flag);
                    if (map.containsKey(ko.getKey())) {
                        throw new Exception("\u914d\u7f6e\u5bf9\u8c61Key\u91cd\u590d,\u5bf9\u8c61" + map.get(ko.getKey()) + "\u548c\u5bf9\u8c61" + ko + "\u7684Key\u503c" + ko.getKey() + "\u91cd\u590d,\u8bf7\u68c0\u67e5\u914d\u7f6e.");
                    }
                    map.put(ko.getKey(), (Object)ko);
                }
            }
            ++i;
        }
    }

    public static IXMLPropertyBag readProperties(Document doc, int key, Element element, IXMLPropertyBag bag, int flag) throws Throwable {
        if (Objects.isNull(bag)) {
            return null;
        }
        NodeList children = element.getChildNodes();
        if (key >= children.getLength()) {
            throw new RuntimeException("\u6570\u636e\u8bfb\u53d6\u9519\u8bef");
        }
        Node node = children.item(key);
        if (node instanceof Element) {
            Element elm = (Element)node;
            if (elm.getAttributes().getLength() == 1 && elm.hasAttribute(vartype) && elm.getAttribute(vartype).equals(nothing)) {
                return null;
            }
            bag.ReadProperties(doc, elm, flag);
            return bag;
        }
        return null;
    }

    public static void readProperties(Document doc, String key, Element element, IXMLPropertyBag bag, int flag) throws Throwable {
        if (Objects.isNull(bag)) {
            return;
        }
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Element elm;
            Node node = children.item(i);
            if (node instanceof Element && (elm = (Element)node).getNodeName().equalsIgnoreCase(key)) {
                bag.ReadProperties(doc, elm, flag);
            }
            ++i;
        }
    }

    public static IXMLPropertyBag readProperties(Document doc, String key, Element element, Class<?> cls, XMLPropertyBagBaseObject parentItem, int flag) throws Throwable {
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Element elm;
            Node node = children.item(i);
            if (node instanceof Element && (elm = (Element)node).getNodeName().equalsIgnoreCase(key)) {
                XMLPropertyBagBaseObject bag;
                try {
                    bag = (XMLPropertyBagBaseObject)cls.newInstance();
                }
                catch (InstantiationException e) {
                    throw new InstantiationException();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessException();
                }
                bag.setParentItem(parentItem);
                bag.ReadProperties(doc, elm, flag);
                return bag;
            }
            ++i;
        }
        return null;
    }

    public static void readPropertie(Document doc, String key, Element element, Class<?> cls, XMLPropertyBagBaseObject parent, XMLPropertyBagBaseObject o, int flag) throws Throwable {
        ArrayList arr = new ArrayList();
        XMLPropertyBag.readProperties(doc, key, element, cls, parent, arr, flag);
    }

    public static void writeProperties(Document doc, String key, Element element, ArrayList<?> arr, int flag) throws Throwable {
        Iterator<?> it = arr.iterator();
        int index = 0;
        while (it.hasNext()) {
            Element el = doc.createElement(key);
            Object o = it.next();
            if (o != null) {
                IXMLPropertyBag bag = (IXMLPropertyBag)o;
                bag.WriteProperties(doc, el, flag);
            } else {
                el.setAttribute(vartype, nothing);
            }
            if (!(key.equalsIgnoreCase("RichDocument") || key.equalsIgnoreCase("Menu") || key.equalsIgnoreCase("Command"))) {
                el.setAttribute("Index", "" + index);
            }
            ++index;
            element.appendChild(el);
        }
    }

    public static void writeProperties(Document doc, Element element, LinkedHashMapKeyIgnoreCase<?> map, int flag) throws Throwable {
        Collection col = map.values();
        for (Object o : col) {
            XMLPropertyBagBaseObject bag = (XMLPropertyBagBaseObject)o;
            Element el = doc.createElement(bag.getMetaName());
            bag.WriteProperties(doc, el, flag);
            element.appendChild(el);
        }
    }

    public static void writeProperties(Document doc, String key, Element element, IXMLPropertyBag bag, int flag) throws Throwable {
        if (Objects.isNull(bag)) {
            return;
        }
        Element elm = doc.createElement(key);
        bag.WriteProperties(doc, elm, flag);
        element.appendChild(elm);
    }

    public static <T> void writePropertie(Document doc, String key, Element element, T o, int flag) throws Throwable {
        ArrayList<T> arr = new ArrayList<T>();
        arr.add(o);
        XMLPropertyBag.writeProperties(doc, key, element, arr, flag);
    }

    public static String getCachedString(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.intern();
    }

    public static String readAttribute(Element element, String name, String defaultValue) {
        String s = XMLPropertyBag.readAttributeNoCache(element, name, defaultValue);
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return XMLPropertyBag.getCachedString(s);
    }

    public static String readTextCDataOrAttribute(Element element, String name, String defaultValue) {
        String s = XMLPropertyBag.readNamedCDATAContent(element, name, defaultValue);
        if (StringUtils.isBlank((CharSequence)s) || s.equalsIgnoreCase(defaultValue)) {
            s = XMLPropertyBag.readAttributeNoCache(element, name, defaultValue);
        }
        return s;
    }

    public static String readNamedCDATAContent(Element element, String name, String defaultValue) {
        String value = defaultValue;
        NodeList childList = element.getChildNodes();
        int length = childList.getLength();
        int i = 0;
        while (i < length) {
            Element elementChild;
            Node child = childList.item(i);
            if (child instanceof Element && (elementChild = (Element)child).getTagName().equalsIgnoreCase(name)) {
                value = elementChild.getTextContent();
                break;
            }
            ++i;
        }
        return value;
    }

    public static void writeNamedCDATAContent(Document doc, Element element, String name, String value, String defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equalsIgnoreCase(defaultValue)) {
            return;
        }
        Element dataElement = doc.createElement(name);
        element.appendChild(dataElement);
        CDATASection attrElement = doc.createCDATASection(value);
        dataElement.appendChild(attrElement);
    }

    public static String readAttributeNoCache(Element element, String name, String defaultValue) {
        Attr attr = element.getAttributeNode(name);
        if (Objects.isNull(attr)) {
            return defaultValue;
        }
        String attrValue = attr.getNodeValue();
        if (StringUtils.isBlank((CharSequence)defaultValue)) {
            return attrValue;
        }
        return StringUtil.isBlankOrNull((String)attrValue) ? defaultValue : attrValue;
    }

    public static String readAttribute(Element element, String name, String defaultValue, boolean allowBlank) {
        return XMLPropertyBag.getCachedString(XMLPropertyBag.readAttributeNoCache(element, name, defaultValue, allowBlank));
    }

    public static String readAttributeNoCache(Element element, String name, String defaultValue, boolean allowBlank) {
        String value;
        Attr attr = element.getAttributeNode(name);
        if (StringUtils.isBlank((CharSequence)defaultValue) && Objects.isNull(attr)) {
            return null;
        }
        if (attr != null && attr.getNodeValue().length() == 0 && allowBlank) {
            return "";
        }
        String string = value = Objects.isNull(attr) || StringUtil.isBlankOrNull((String)attr.getNodeValue()) ? defaultValue : attr.getNodeValue();
        if (StringUtils.isBlank((CharSequence)value) && attr != null) {
            value = Objects.isNull(attr.getNodeValue()) ? defaultValue : attr.getNodeValue();
        }
        return value;
    }

    public static String readElementNoCache(Element element, String name, String defaultValue) {
        String value = XMLPropertyBag.readElementNoCache(element, name);
        if (Objects.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    private static String readElementNoCache(Element element, String name) {
        String value = "";
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Element elm;
            Node node = children.item(i);
            if (node instanceof Element && (elm = (Element)node).getNodeName().equalsIgnoreCase(name)) {
                value = elm.getTextContent();
                break;
            }
            ++i;
        }
        return value;
    }

    public static String readElement(Element element, String name, String defaultValue) {
        return XMLPropertyBag.getCachedString(XMLPropertyBag.readElementNoCache(element, name, defaultValue));
    }

    public static Integer readElement(Element element, String name, Integer defaultValue) {
        String sValue = XMLPropertyBag.readElementNoCache(element, name);
        if (Objects.isNull(sValue)) {
            return defaultValue;
        }
        return Integer.parseInt(sValue);
    }

    public static Boolean readElement(Element element, String name, Boolean defaultValue) {
        String sValue = XMLPropertyBag.readElementNoCache(element, name);
        if (Objects.isNull(sValue)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(sValue);
    }

    public static int readAttributeInt(Element element, String name, int defaultValue) {
        Attr attr = element.getAttributeNode(name);
        if (Objects.isNull(attr)) {
            return defaultValue;
        }
        if (StringUtil.isBlankOrNull((String)attr.getNodeValue())) {
            return 0;
        }
        return Integer.parseInt(attr.getNodeValue());
    }

    public static int readElement(Element element, String name, int defaultValue) {
        String sValue = XMLPropertyBag.readElementNoCache(element, name);
        if (StringUtils.isBlank((CharSequence)sValue)) {
            return defaultValue;
        }
        return Integer.parseInt(sValue);
    }

    public static Short readAttribute(Element element, String name, Short defaultValue) {
        Attr attr = element.getAttributeNode(name);
        if (Objects.isNull(defaultValue) && Objects.isNull(attr)) {
            return null;
        }
        Short value = Objects.isNull(attr) ? defaultValue : Short.parseShort(attr.getNodeValue());
        return value;
    }

    public static Short readElement(Element element, String name, Short defaultValue) {
        Short value = null;
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Element elm;
            Node node = children.item(i);
            if (node instanceof Element && (elm = (Element)node).getNodeName().equalsIgnoreCase(name)) {
                value = Short.parseShort(elm.getNodeValue());
            }
            ++i;
        }
        if (Objects.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    public static BigDecimal readAttribute(Element element, String name, BigDecimal defaultValue) {
        Attr attr = element.getAttributeNode(name);
        if (Objects.isNull(defaultValue) && Objects.isNull(attr)) {
            return null;
        }
        BigDecimal value = Objects.isNull(attr) ? defaultValue : new BigDecimal(attr.getNodeValue());
        return value;
    }

    public static BigDecimal readElement(Element element, String name, BigDecimal defaultValue) {
        BigDecimal value = null;
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Element elm;
            Node node = children.item(i);
            if (node instanceof Element && (elm = (Element)node).getNodeName().equalsIgnoreCase(name)) {
                value = new BigDecimal(elm.getNodeValue());
            }
            ++i;
        }
        if (Objects.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    public static Float readAttribute(Element element, String name, Float defaultValue) {
        Attr attr = element.getAttributeNode(name);
        if (Objects.isNull(defaultValue) && Objects.isNull(attr)) {
            return null;
        }
        Float value = Float.valueOf(Objects.isNull(attr) ? defaultValue.floatValue() : Float.parseFloat(attr.getNodeValue()));
        return value;
    }

    public static Float readElement(Element element, String name, Float defaultValue) {
        Float value = null;
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Element elm;
            Node node = children.item(i);
            if (node instanceof Element && (elm = (Element)node).getNodeName().equalsIgnoreCase(name)) {
                value = Float.valueOf(Float.parseFloat(elm.getNodeValue()));
            }
            ++i;
        }
        if (Objects.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    public static Double readAttribute(Element element, String name, Double defaultValue) {
        Attr attr = element.getAttributeNode(name);
        if (Objects.isNull(defaultValue) && Objects.isNull(attr)) {
            return null;
        }
        Double value = Objects.isNull(attr) ? defaultValue : Double.parseDouble(attr.getNodeValue());
        return value;
    }

    public static Double readElement(Element element, String name, Double defaultValue) {
        Double value = null;
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Element elm;
            Node node = children.item(i);
            if (node instanceof Element && (elm = (Element)node).getNodeName().equalsIgnoreCase(name)) {
                value = Double.parseDouble(elm.getNodeValue());
            }
            ++i;
        }
        if (Objects.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    public static Boolean readAttribute(Element element, String name, Boolean defaultValue) {
        Attr attr = element.getAttributeNode(name);
        if (Objects.isNull(defaultValue) && Objects.isNull(attr)) {
            return false;
        }
        Boolean value = Objects.isNull(attr) ? defaultValue : Boolean.parseBoolean(attr.getNodeValue());
        return value;
    }

    public static Date readAttribute(Element element, String name, Date defaultValue) {
        Date value;
        Attr attr = element.getAttributeNode(name);
        if (Objects.isNull(defaultValue) && Objects.isNull(attr)) {
            return null;
        }
        try {
            value = Objects.isNull(attr) ? defaultValue : DateUtil.getDate((String)attr.getNodeValue());
        }
        catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
            return null;
        }
        return value;
    }

    public static Date readElement(Element element, String name, Date defaultValue) {
        Date value = null;
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Element elm;
            Node node = children.item(i);
            if (node instanceof Element && (elm = (Element)node).getNodeName().equalsIgnoreCase(name)) {
                try {
                    value = DateFormat.getInstance().parse(elm.getNodeValue());
                }
                catch (DOMException e) {
                    LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
                }
                catch (ParseException e) {
                    LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
                }
            }
            ++i;
        }
        if (Objects.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    public static void writeAttribute(Element element, String name, String value, String defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equalsIgnoreCase(defaultValue)) {
            return;
        }
        element.setAttribute(name, value);
    }

    public static void writeAttributeCase(Element element, String name, String value, String defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        element.setAttribute(name, value);
    }

    public static void writeTextCDataOrAttribute(Document doc, Element element, String name, String value, String defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equalsIgnoreCase(defaultValue)) {
            return;
        }
        if (StringUtils.containsAny((CharSequence)value, (CharSequence)"\n\t<>&;\"'")) {
            Element dataElement = doc.createElement(name);
            element.appendChild(dataElement);
            CDATASection attrElement = doc.createCDATASection(value);
            dataElement.appendChild(attrElement);
        } else {
            element.setAttribute(name, value);
        }
    }

    public static void writeAttribute(Element element, String name, String value) {
        if (Objects.isNull(value)) {
            value = "";
        }
        element.setAttribute(name, value);
    }

    public static void writeElement(Document doc, Element element, String name, String value, String defaultValue) {
        if (value != null && value.equalsIgnoreCase(defaultValue)) {
            return;
        }
        XMLPropertyBag.writeElement(doc, element, name, value);
    }

    public static void writeElement(Document doc, Element element, String name, String value) {
        if (Objects.isNull(value)) {
            value = "";
        }
        Element el = doc.createElement(name);
        if (value.indexOf(60) > 0 || value.indexOf(62) > 0) {
            CDATASection cdata = doc.createCDATASection(value);
            el.appendChild(cdata);
        } else {
            el.setTextContent(value);
        }
        element.appendChild(el);
    }

    public static void writeAttribute(Element element, String name, Integer value, Integer defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (defaultValue != null && value.equals(defaultValue)) {
            return;
        }
        element.setAttribute(name, value.toString());
    }

    public static void writeElement(Document doc, Element element, String name, Integer value, Integer defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        Element el = doc.createElement(name);
        el.setTextContent(value.toString());
        element.appendChild(el);
    }

    public static void writeAttribute(Element element, String name, Long value, Long defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        element.setAttribute(name, value.toString());
    }

    public static void writeElement(Document doc, Element element, String name, int value, int defaultValue) {
        if (value == defaultValue) {
            return;
        }
        XMLPropertyBag.writeElement(doc, element, name, value);
    }

    public static void writeElement(Document doc, Element element, String name, int value) {
        Element el = doc.createElement(name);
        el.setTextContent(String.valueOf(value));
        element.appendChild(el);
    }

    public static void writeAttribute(Element element, String name, Short value, Short defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        element.setAttribute(name, value.toString());
    }

    public static void writeElement(Document doc, Element element, String name, Short value, Short defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        Element el = doc.createElement(name);
        el.setTextContent(value.toString());
        element.appendChild(el);
    }

    public static void writeAttribute(Element element, String name, BigDecimal value, BigDecimal defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        element.setAttribute(name, value.toString());
    }

    public static void writeElement(Document doc, Element element, String name, BigDecimal value, BigDecimal defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        Element el = doc.createElement(name);
        el.setTextContent(value.toString());
        element.appendChild(el);
    }

    public static void writeAttribute(Element element, String name, Float value, Float defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        element.setAttribute(name, value.toString());
    }

    public static void writeElement(Document doc, Element element, String name, Float value, Float defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        Element el = doc.createElement(name);
        el.setTextContent(value.toString());
        element.appendChild(el);
    }

    public static void writeAttribute(Element element, String name, Double value, Double defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        element.setAttribute(name, value.toString());
    }

    public static void writeElement(Document doc, Element element, String name, Double value, Double defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        Element el = doc.createElement(name);
        el.setTextContent(value.toString());
        element.appendChild(el);
    }

    public static void writeAttribute(Element element, String name, Boolean value, Boolean defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        String ret = value != false ? "True" : "False";
        element.setAttribute(name, ret);
    }

    public static void writeElement(Document doc, Element element, String name, boolean value, boolean defaultValue) {
        if (value == defaultValue) {
            return;
        }
        XMLPropertyBag.writeElement(doc, element, name, value);
    }

    public static void writeElement(Document doc, Element element, String name, boolean value) {
        Element el = doc.createElement(name);
        el.setTextContent(String.valueOf(value));
        element.appendChild(el);
    }

    public static void writeAttribute(Element element, String name, Date value, Date defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        element.setAttribute(name, value.toString());
    }

    public static void writeElement(Document doc, Element element, String name, Date value, Date defaultValue) {
        if (Objects.isNull(value)) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        Element el = doc.createElement(name);
        el.setTextContent(value.toString());
        element.appendChild(el);
    }

    public static boolean readLocalProperties(String fileName, String rootNode, String key, IXMLPropertyBag bag, int flag) throws Throwable {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ParserConfigurationException();
        }
        Document doc = null;
        File f = new File(fileName);
        if (!f.exists()) {
            DebugUtil.debug((Object)">resolver==null.2");
            return false;
        }
        try (FileInputStream in = null;){
            try {
                in = new FileInputStream(f);
                doc = builder.parse(in);
            }
            catch (SAXException e) {
                DebugUtil.debug((Object)(">error.xml:" + fileName));
                LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
                if (in != null) {
                    ((InputStream)in).close();
                }
                return false;
            }
            catch (Throwable e) {
                DebugUtil.debug((Object)(">error.xml:" + fileName));
                throw new Exception();
            }
        }
        Element root = doc.getDocumentElement();
        XMLPropertyBag.readProperties(doc, key, root, bag, flag);
        return true;
    }

    public static boolean readProperties(IFileResolver resolver, String fileName, String rootNode, String key, IXMLPropertyBag bag, int flag, int resourceType) throws Throwable {
        XMLItem root = XMLPropertyBag.readRoot(resolver, fileName, rootNode, key, bag, flag, resourceType);
        if (root != null) {
            XMLPropertyBag.readProperties(root.document, key, root.root, bag, flag);
            return true;
        }
        return false;
    }

    public static boolean readObject(IFileResolver resolver, String fileName, String rootNode, String key, IXMLPropertyBag bag, int flag, int resourceType) throws Throwable {
        XMLItem root = XMLPropertyBag.readRoot(resolver, fileName, rootNode, key, bag, flag, resourceType);
        if (root != null) {
            bag.ReadProperties(root.document, root.root, flag);
            return true;
        }
        return false;
    }

    public static Document readDocument(String sFileName) throws Throwable {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ParserConfigurationException();
        }
        Document doc = null;
        try (FileInputStream in = null;){
            try {
                in = new FileInputStream(sFileName);
                doc = builder.parse(in);
            }
            catch (SAXException e) {
                DebugUtil.debug((Object)(">error.xml:" + sFileName));
                LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
                throw new SAXException("xml\u6587\u4ef6" + sFileName + "\u89e3\u6790\u9519\u8bef,\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f.", e);
            }
            catch (Throwable e) {
                DebugUtil.debug((Object)(">error.xml:" + sFileName));
                throw new Exception("xml\u6587\u4ef6" + sFileName + "\u89e3\u6790\u9519\u8bef,\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f.", e);
            }
        }
        return doc;
    }

    private static XMLItem readRoot(IFileResolver resolver, String sFileName, String rootNode, String key, IXMLPropertyBag bag, int flag, int resourceType) throws Throwable {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ParserConfigurationException();
        }
        Document doc = null;
        if (Objects.isNull(resolver)) {
            DebugUtil.debug((Object)">resolver==null.3");
            return null;
        }
        try (InputStream in = null;){
            in = resolver.getInputStream(sFileName, resourceType);
            if (Objects.isNull(in)) {
                DebugUtil.debug((Object)(">Cannot resolver resource read.5. " + sFileName));
                return null;
            }
            try {
                doc = builder.parse(in);
            }
            catch (SAXException e) {
                DebugUtil.debug((Object)(">error.xml:" + sFileName));
                throw new SAXException("xml\u6587\u4ef6" + sFileName + "\u89e3\u6790\u9519\u8bef,\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f.", e);
            }
            catch (Throwable e) {
                DebugUtil.debug((Object)(">error.xml:" + sFileName));
                throw new Exception("xml\u6587\u4ef6" + sFileName + "\u89e3\u6790\u9519\u8bef,\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f.", e);
            }
        }
        Element root = doc.getDocumentElement();
        return new XMLItem(doc, root);
    }

    public static boolean writeLocalProperties(String fileName, String rootNode, String key, IXMLPropertyBag bag, int flag) throws Throwable {
        Document newDoc = XMLPropertyBag.createDocument();
        Element root = null;
        if (StringUtils.isBlank((CharSequence)rootNode)) {
            rootNode = "PropertyBag";
        }
        root = newDoc.createElement(rootNode);
        newDoc.appendChild(root);
        XMLPropertyBag.writeProperties(newDoc, key, root, bag, 0);
        return XMLPropertyBag.writeLocalDocument(fileName, newDoc);
    }

    public static boolean writeProperties(IFileResolver resolver, String fileName, String rootNode, String key, IXMLPropertyBag bag, int flag, int resourceType) throws Throwable {
        Document newDoc = XMLPropertyBag.createDocument();
        Element root = null;
        if (StringUtils.isBlank((CharSequence)rootNode)) {
            rootNode = "PropertyBag";
        }
        root = newDoc.createElement(rootNode);
        newDoc.appendChild(root);
        XMLPropertyBag.writeProperties(newDoc, key, root, bag, 0);
        return XMLPropertyBag.writeDocument(resolver, fileName, newDoc, resourceType);
    }

    public static boolean writeObject(IFileResolver resolver, String fileName, String rootNode, String key, IXMLPropertyBag bag, int flag, int resourceType) throws Throwable {
        Document newDoc = XMLPropertyBag.createDocument();
        Element root = null;
        if (StringUtils.isBlank((CharSequence)rootNode)) {
            rootNode = "PropertyBag";
        }
        root = newDoc.createElement(rootNode);
        newDoc.appendChild(root);
        bag.WriteProperties(newDoc, root, flag);
        return XMLPropertyBag.writeDocument(resolver, fileName, newDoc, resourceType);
    }

    private static Document createDocument() throws Throwable {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ParserConfigurationException();
        }
        Document newDoc = builder.newDocument();
        return newDoc;
    }

    private static boolean writeDocument(IFileResolver resolver, String fileName, Document document, int resourceType) throws Throwable {
        if (Objects.isNull(resolver)) {
            return false;
        }
        Transformer trans = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            trans = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerConfigurationException();
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new TransformerFactoryConfigurationError();
        }
        try {
            trans.transform(new DOMSource(document), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new Exception();
        }
        try {
            resolver.write(fileName, out.toByteArray(), resourceType);
        }
        catch (Throwable e) {
            throw new Exception();
        }
        return true;
    }

    private static boolean writeLocalDocument(String fileName, Document document) throws Throwable {
        Transformer trans = null;
        try {
            trans = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerConfigurationException();
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new TransformerFactoryConfigurationError();
        }
        String uri = fileName;
        File f = new File(uri);
        try {
            trans.transform(new DOMSource(document), new StreamResult(new FileOutputStream(f)));
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException();
        }
        catch (TransformerException e) {
            throw new Exception();
        }
        return true;
    }
}

