/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.xml;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.utils.XmlFormat;
import com.bokesoft.yes.design.xml.ex.XmlSyntaxException;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.CommentNode;
import com.bokesoft.yes.design.xml.node.DTDNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.TextNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.design.xml.parse.Element;
import com.bokesoft.yes.design.xml.parse.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public class XmlParser {
    private static boolean useComment = true;

    public static void setUseComment(boolean bool) {
        useComment = bool;
    }

    public static XmlTree parse(String xml) throws Throwable {
        return XmlParser.parse(xml, false, true);
    }

    public static XmlTree parse(String xml, boolean trimText, boolean isCheck) throws Throwable {
        Element endEle;
        List<Element> list = Util.getElements(xml = XmlFormat.formatXML_str(xml));
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        int idx = -1;
        ArrayList<AbstractNode> listPreComment = new ArrayList<AbstractNode>();
        ArrayList<AbstractNode> listLastComment = new ArrayList<AbstractNode>();
        int i = 0;
        while (i < list.size()) {
            Element e = list.get(i);
            if (e.getType() != 4) {
                if (e.getType() == 2) {
                    listPreComment.add(new CommentNode(e.getText(), e));
                } else if (e.getType() == 1) {
                    if (!StringUtil.isEmptyStr((String)e.getText())) {
                        throw new XmlSyntaxException("\u6807\u7b7e\u5f00\u59cb\u4e4b\u524d\u4e0d\u80fd\u6709\u6587\u672c[" + e.getText().trim() + "]");
                    }
                } else {
                    if (e.getType() == 0) {
                        idx = i;
                        break;
                    }
                    throw new XmlSyntaxException("\u6807\u7b7e\u5f00\u59cb\u4e4b\u524d\u4e0d\u80fd\u6709CDATA[" + e.getText().trim() + "]");
                }
            }
            ++i;
        }
        if (idx == -1) {
            return null;
        }
        Element ele = list.get(idx);
        TagNode node = new TagNode(ele.getTagName(), ele);
        if (ele.getAttrs() != null) {
            node.setAttributes(ele.getAttrs());
        }
        if (Objects.isNull(endEle = XmlParser.getEndTagElement(list, idx, ele, node, trimText))) {
            throw new XmlSyntaxException("root: <" + ele.getTagName() + "> \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684endTag");
        }
        int i2 = endEle.getIndexInTheList() + 1;
        while (i2 < list.size()) {
            Element e = list.get(i2);
            if (e.getType() == 2) {
                listLastComment.add(new CommentNode(e.getText(), e));
            }
            if (e.getType() == 0) {
                throw new XmlSyntaxException("root: </" + ele.getTagName() + "> \u6839\u6807\u7b7e\u7684\u540e\u9762\u4e0d\u80fd\u518d\u6709\u6570\u636e<" + e.getTagName() + ">");
            }
            if (e.getType() == 3) {
                throw new XmlSyntaxException("root: </" + ele.getTagName() + "> \u6839\u6807\u7b7e\u7684\u540e\u9762\u4e0d\u80fd\u518d\u6709\u6570\u636eCDATA[" + e.getText() + "]");
            }
            if (e.getType() == 1 && !StringUtil.isEmptyStr((String)e.getText())) {
                throw new XmlSyntaxException("root: </" + ele.getTagName() + "> \u6839\u6807\u7b7e\u7684\u540e\u9762\u4e0d\u80fd\u518d\u6709\u6570\u636etext[" + e.getText().trim() + "]");
            }
            ++i2;
        }
        XmlTree tree = new XmlTree(node);
        String substring = xml.substring(xml.lastIndexOf("\n") + 1);
        if (!substring.isEmpty()) {
            xml = String.valueOf(xml) + "\r\n";
        }
        tree.setOrgXml(xml);
        tree.addPreComment(listPreComment);
        tree.addLastComment(listLastComment);
        if ("Process".equals(tree.getRoot().getTagName()) || "CommonDefVestCollection".equals(tree.getRoot().getTagName())) {
            isCheck = false;
        }
        tree.updateMap(isCheck);
        return tree;
    }

    private static Element getEndTagElement(List<Element> list, int bg, Element ele, TagNode node, boolean trimText) {
        if (ele.getTagType() == 3) {
            ele.setIndexInTheList(bg);
            return ele;
        }
        if (ele.getTagType() == 2) {
            throw new XmlSyntaxException("\u7ed3\u5c3e\u6807\u7b7e</" + ele.getTagName() + "> \u4e4b\u524d\u6ca1\u6709\u5f00\u59cb\u6807\u7b7e");
        }
        int i = bg + 1;
        while (i < list.size()) {
            Element tem = list.get(i);
            if (tem.getType() == 1 || tem.getType() == 2 || tem.getType() == 3) {
                if (tem.getType() != 2 || useComment) {
                    if (trimText) {
                        String txt = tem.getText().trim();
                        if (txt.length() > 0) {
                            node.appendNode(XmlParser.makeNotTagNode(txt, tem));
                        }
                    } else {
                        node.appendNode(XmlParser.makeNotTagNode(tem.getText(), tem));
                    }
                }
            } else if (tem.getTagType() == 3) {
                node.appendNode(XmlParser.makeTagNode(tem));
            } else {
                if (tem.getTagType() == 2) {
                    if (tem.getTagName().equals(ele.getTagName())) {
                        tem.setIndexInTheList(i);
                        TagNode endNode = XmlParser.makeTagNode(tem);
                        node.appendNode(endNode);
                        return tem;
                    }
                    throw new XmlSyntaxException("endTag </" + tem.getTagName() + " \u4e4b\u524d\u6ca1\u6709\u5f00\u59cb\u8282\u70b9");
                }
                TagNode newNode = XmlParser.makeTagNode(tem);
                node.appendNode(newNode);
                Element newEd = XmlParser.getEndTagElement(list, i, tem, newNode, trimText);
                if (Objects.isNull(newEd)) {
                    throw new XmlSyntaxException("Tag <" + tem.getTagName() + "> \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684endTag");
                }
                i = newEd.getIndexInTheList();
            }
            ++i;
        }
        return null;
    }

    private static TagNode makeTagNode(Element ele) {
        TagNode node = new TagNode(ele);
        node.setTagName(ele.getTagName());
        if (ele.getAttrs() != null) {
            node.setAttributes(ele.getAttrs());
        }
        return node;
    }

    private static AbstractNode makeNotTagNode(String text, Element element) {
        int elemType = element.getType();
        if (1 == elemType) {
            return new TextNode(text, element);
        }
        if (2 == elemType) {
            return new CommentNode(text, element);
        }
        if (3 == elemType) {
            return new CDataNode(text, element);
        }
        if (4 == elemType) {
            return new DTDNode(text, element);
        }
        throw new XmlSyntaxException("\u8282\u70b9\u7c7b\u578b:" + elemType + " \u4e0d\u5b58\u5728\uff01");
    }
}

