/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.vest;

import com.bokesoft.yes.design.vest.DynamicVestExtendTagDefine;
import com.bokesoft.yes.design.vest.VestUtil;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Document;

public class DynamicVestCreator {
    private Document sourceDocument = null;
    private Document curDocument = null;
    private HashMap<String, TagNode> sourceNodeMap = null;

    public DynamicVestCreator(Document srcDocument, Document extendedDocument) {
        this.sourceDocument = srcDocument;
        this.curDocument = extendedDocument;
    }

    public String createVestXml() throws Exception {
        TagNode vestRootNode = this.createVest(null);
        return vestRootNode.toXml(0);
    }

    public TagNode createVest(XmlTree orgTree) throws Exception {
        XmlCreator createor = new XmlCreator(this.curDocument, orgTree);
        XmlTree xmlTree = createor.createXmlTree();
        TagNode curRootNode = xmlTree.getRoot();
        createor = new XmlCreator(this.sourceDocument, orgTree);
        xmlTree = createor.createXmlTree();
        this.sourceNodeMap = createor.getTagNodeMap();
        TagNode sourceRootNode = xmlTree.getRoot();
        String par = "";
        if (curRootNode.getParent() != null) {
            par = curRootNode.getParent().getPrimaryKey();
            if (curRootNode.getParent().getParent() != null) {
                par = String.valueOf(curRootNode.getParent().getParent().getPrimaryKey()) + "->" + par;
            }
        }
        String sourceKey = String.valueOf(par) + "->" + curRootNode.getPrimaryKey();
        this.sourceNodeMap.put(sourceKey, sourceRootNode);
        TagNode vestRootNode = this.createNode(curRootNode, sourceRootNode);
        return vestRootNode;
    }

    private TagNode createNode(TagNode curNode, TagNode parentSourceNode) {
        TagNode parentNode;
        TagNode vestNode = null;
        String tagName = curNode.getTagName();
        if (DynamicVestExtendTagDefine.isTagCanNotExtend(tagName)) {
            return null;
        }
        if (!curNode.hasPrimaryAttribute() && DynamicVestExtendTagDefine.isPanelNode(parentNode = curNode.getParent())) {
            vestNode = (TagNode)curNode.clone();
            return vestNode;
        }
        if (curNode.hasPrimaryAttribute()) {
            String sourceKey;
            TagNode sourceNode;
            String par = "";
            if (curNode.getParent() != null) {
                par = curNode.getParent().getPrimaryKey();
                if (curNode.getParent().getParent() != null) {
                    par = String.valueOf(curNode.getParent().getParent().getPrimaryKey()) + "->" + par;
                }
            }
            if ((sourceNode = this.sourceNodeMap.get(sourceKey = String.valueOf(par) + "->" + curNode.getPrimaryKey())) != null) {
                vestNode = this.createVestNode(curNode, sourceNode);
            } else if (parentSourceNode != null && parentSourceNode.findChildByTagNode(curNode) != null) {
                vestNode = this.createVestNode(curNode, parentSourceNode.findChildByTagNode(curNode));
            } else if (DynamicVestExtendTagDefine.isPanelNode(curNode)) {
                vestNode = DynamicVestExtendTagDefine.cloneWithoutChildren(curNode);
                List<AbstractNode> children = this.createChildTagNodes(curNode, null);
                if (children != null && children.size() > 0) {
                    for (AbstractNode node : children) {
                        vestNode.addNode(node);
                    }
                }
            } else {
                vestNode = (TagNode)curNode.clone();
            }
        } else if (parentSourceNode != null) {
            TagNode sourceNode = parentSourceNode.findFirstTagNodeByTagName(curNode.getTagName());
            vestNode = sourceNode != null ? this.createVestNode(curNode, sourceNode) : (TagNode)curNode.clone();
        }
        return vestNode;
    }

    private TagNode createVestNode(TagNode curNode, TagNode srcNode) {
        TagNode vestNode = null;
        String tagName = curNode.getTagName();
        if (curNode.hasPrimaryAttribute()) {
            vestNode = new TagNode(tagName);
            String primaryName = curNode.getPrimaryAttrName();
            vestNode.setAttribute(primaryName, (String)curNode.getAttributes().get(primaryName));
            VestUtil.dealSpecialAttrs(vestNode, srcNode, new String[]{"CellType", "ColumnType"});
            VestUtil.dealOptRefKey(vestNode, srcNode);
        }
        for (Map.Entry entry : curNode.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String sourceValue = (String)srcNode.getAttributes().get(key);
            if (TypeConvertor.toString((Object)value).equals(sourceValue)) continue;
            if (Objects.isNull(vestNode)) {
                vestNode = new TagNode(tagName);
            }
            vestNode.setAttribute(key, value);
        }
        List<AbstractNode> children = this.createChildTagNodes(curNode, srcNode);
        if (children != null && children.size() > 0) {
            if (Objects.isNull(vestNode)) {
                vestNode = new TagNode(tagName);
            }
            for (AbstractNode node : children) {
                vestNode.addNode(node);
            }
        }
        if (vestNode != null && vestNode.getTagName().equalsIgnoreCase("Column") && vestNode.getAttributes().size() == 1) {
            return null;
        }
        return vestNode;
    }

    private List<AbstractNode> createChildTagNodes(TagNode curNode, TagNode srcNode) {
        AbstractNode otherNode = null;
        TagNode tmpNode = null;
        TagNode vestNode = null;
        ArrayList<TagNode> children = null;
        for (AbstractNode node : curNode.getChildren()) {
            if (node instanceof TagNode) {
                tmpNode = (TagNode)node;
                vestNode = this.createNode(tmpNode, srcNode);
                if (vestNode == null) continue;
                if (Objects.isNull(children)) {
                    children = new ArrayList();
                }
                children.add(vestNode);
                continue;
            }
            otherNode = this.createOtherNode(node, srcNode);
            if (otherNode == null) continue;
            if (Objects.isNull(children)) {
                children = new ArrayList<TagNode>();
            }
            children.add((TagNode)otherNode);
        }
        return children;
    }

    private AbstractNode createOtherNode(AbstractNode curNode, TagNode parentSourceNode) {
        String srcContent;
        if (Objects.isNull(parentSourceNode)) {
            return null;
        }
        AbstractNode srcNode = parentSourceNode.getFirst();
        String curContent = TypeConvertor.toString((Object)curNode.getText());
        if (!curContent.equals(srcContent = TypeConvertor.toString((Object)srcNode.getText()))) {
            return curNode.clone();
        }
        return null;
    }
}

