/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.vest;

import com.bokesoft.yes.design.vest.VestUtil;
import com.bokesoft.yes.helper.XmlHelper;
import com.bokesoft.yes.meta.persist.dom.xml.XmlParser;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yigo.common.util.FileUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultVestCreator {
    private final String vestKey;
    private final String vestCaption;
    private final String sourceResource;

    public DefaultVestCreator(String vestKey, String vestCaption, String sourceResource) {
        this.vestKey = vestKey;
        this.vestCaption = vestCaption;
        this.sourceResource = sourceResource;
    }

    public String createVestXml(String sourceKey, boolean mergeToSource) throws IOException {
        XmlTree xmlTree = XmlParser.parse((String)FileUtil.File2String((String)this.sourceResource), (boolean)true);
        TagNode rootNode = xmlTree.getRoot();
        TagNode vestRootNode = this.createVestNode(rootNode);
        Objects.requireNonNull(vestRootNode);
        vestRootNode.setAttribute("Key", this.vestKey);
        vestRootNode.setAttribute("Caption", this.vestCaption);
        vestRootNode.setAttribute("Extend", sourceKey);
        if (mergeToSource) {
            vestRootNode.setAttribute("MergeToSource", String.valueOf(mergeToSource));
        }
        return XmlHelper.format(vestRootNode, 0);
    }

    private TagNode createVestNode(TagNode node) {
        if (node.getTagName().endsWith("Collection") || StringUtils.equalsAny((CharSequence)node.getTagName(), (CharSequence[])new CharSequence[]{"SplitSize", "Var", "Item", "ItemFilter", "CustomConditionPara"})) {
            return null;
        }
        TagNode layoutNode = this.createVestLayoutNode(node);
        if (Objects.nonNull(layoutNode)) {
            return layoutNode;
        }
        TagNode panelNode = this.createVestPanelNode(node);
        if (Objects.nonNull(panelNode)) {
            return panelNode;
        }
        return this.createVestFormNode(node);
    }

    private TagNode createVestLayoutNode(TagNode node) {
        Pair<String, String> pair = this.getPrimaryAttr(node);
        if (Objects.nonNull(pair)) {
            return null;
        }
        TagNode parentNode = node.getParent();
        if (Objects.isNull(parentNode)) {
            return null;
        }
        if (!StringUtils.endsWith((CharSequence)parentNode.getTagName(), (CharSequence)"Panel")) {
            return null;
        }
        return (TagNode)node.clone();
    }

    private TagNode createVestPanelNode(TagNode node) {
        if (!StringUtils.endsWith((CharSequence)node.getTagName(), (CharSequence)"Panel")) {
            return null;
        }
        Pair<String, String> pair = this.getPrimaryAttr(node);
        TagNode vestNode = new TagNode(node.getTagName());
        if (Objects.nonNull(pair)) {
            vestNode = new TagNode(node.getTagName());
            String[] needCopy2VestAttrs = new String[]{"X", "Y", "XSpan", "YSpan"};
            vestNode.setAttribute((String)pair.getLeft(), (String)pair.getValue());
            VestUtil.dealSpecialAttrs(vestNode, node, needCopy2VestAttrs);
        }
        List<TagNode> childTagNodes = this.createVestChildNode(node);
        for (TagNode next : childTagNodes) {
            vestNode.addNode((AbstractNode)next);
        }
        return vestNode;
    }

    private TagNode createVestFormNode(TagNode node) {
        TagNode vestNode = null;
        Pair<String, String> pair = this.getPrimaryAttr(node);
        if (Objects.nonNull(pair)) {
            vestNode = new TagNode(node.getTagName());
            String[] needCopy2VestAttrs = new String[]{"X", "Y", "XSpan", "YSpan"};
            vestNode.setAttribute((String)pair.getLeft(), (String)pair.getValue());
            VestUtil.dealSpecialAttrs(vestNode, node, needCopy2VestAttrs);
            VestUtil.dealOptRefKey(vestNode, node);
        }
        List<TagNode> childTagNodes = this.createVestChildNode(node);
        for (TagNode next : childTagNodes) {
            if (Objects.isNull(vestNode)) {
                vestNode = new TagNode(node.getTagName());
            }
            vestNode.addNode((AbstractNode)next);
        }
        return vestNode;
    }

    private List<TagNode> createVestChildNode(TagNode node) {
        List childNodeList = node.getChildren();
        if (CollectionUtils.isEmpty((Collection)childNodeList)) {
            return Collections.emptyList();
        }
        ArrayList<TagNode> vestChildNodeList = new ArrayList<TagNode>();
        for (AbstractNode childNode : childNodeList) {
            TagNode vestChildNode;
            boolean b = childNode instanceof TagNode;
            if (!b || !Objects.nonNull(vestChildNode = this.createVestNode((TagNode)childNode))) continue;
            vestChildNodeList.add(vestChildNode);
        }
        return vestChildNodeList;
    }

    private Pair<String, String> getPrimaryAttr(TagNode node) {
        String attrName = node.getPrimaryAttrName();
        if (StringUtils.isBlank((CharSequence)attrName)) {
            return null;
        }
        Map attrMap = node.getAttributes();
        String attrVal = (String)attrMap.get(attrName);
        if (StringUtils.isBlank((CharSequence)attrVal)) {
            return null;
        }
        return Pair.of((Object)attrName, (Object)attrVal);
    }
}

