/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.utils;

import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.utils.XMLWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class XmlFormat {
    public static String formatXML_file(String inputXML_URL) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new FileReader(inputXML_URL));
        String requestXML = null;
        XMLWriter writer = null;
        if (document != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
                writer = new XMLWriter(stringWriter, format);
                writer.write(document);
                requestXML = stringWriter.getBuffer().toString();
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return requestXML;
    }

    public static String formatXML_str(String inputXMLString) throws Exception {
        String UTF8_BOM = "\ufeff";
        if (inputXMLString.startsWith("\ufeff")) {
            inputXMLString = StringUtils.substring((String)inputXMLString, (int)1);
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(inputXMLString), "");
        String requestXML = null;
        XMLWriter writer = null;
        if (document != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
                writer = new XMLWriter(stringWriter, format);
                writer.write(document);
                requestXML = stringWriter.getBuffer().toString();
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return requestXML;
    }
}

