/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.utils;

import com.bokesoft.yes.design.utils.CheckXSDUtils;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XSDErrorHandler
implements ErrorHandler {
    public static final String WARN = "Warn";
    public static final String ERROR = "Error";
    public static final String FATALERROR = "FatalError";
    public HashMap<String, LinkedHashSet<String>> infoMap = new HashMap();

    XSDErrorHandler() {
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        String message = new String(exception.getMessage().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        String errorInfo = String.valueOf(exception.getLineNumber()) + "\u884c" + exception.getColumnNumber() + "\u5217:\t" + message;
        if (this.infoMap.containsKey(WARN)) {
            this.infoMap.get(WARN).add(errorInfo);
        } else {
            LinkedHashSet<String> errorList = new LinkedHashSet<String>();
            errorList.add(errorInfo);
            this.infoMap.put(WARN, errorList);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        String message = new String(exception.getMessage().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        if (CheckXSDUtils.skipMsgSet.contains(message)) {
            return;
        }
        String errorInfo = String.valueOf(exception.getLineNumber()) + "\u884c" + exception.getColumnNumber() + "\u5217:\t" + message;
        if (this.infoMap.containsKey(ERROR)) {
            this.infoMap.get(ERROR).add(errorInfo);
        } else {
            LinkedHashSet<String> errorList = new LinkedHashSet<String>();
            errorList.add(errorInfo);
            this.infoMap.put(ERROR, errorList);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        String message = new String(exception.getMessage().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        if (CheckXSDUtils.skipMsgSet.contains(message)) {
            return;
        }
        String errorInfo = String.valueOf(exception.getLineNumber()) + "\u884c" + exception.getColumnNumber() + "\u5217:\t" + message;
        if (this.infoMap.containsKey(FATALERROR)) {
            this.infoMap.get(FATALERROR).add(errorInfo);
        } else {
            LinkedHashSet<String> errorList = new LinkedHashSet<String>();
            errorList.add(errorInfo);
            this.infoMap.put(FATALERROR, errorList);
        }
    }
}

