/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.utils;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.util.ArrayList;
import java.util.Iterator;

public class WebDesignerDataTableUtil {
    public static void appendAll(DataTable src, DataTable tgt) {
        WebDesignerDataTableUtil.appendAll(src, tgt, null);
    }

    public static void appendAll(DataTable src, DataTable tgt, String ignoreColKeys) {
        ignoreColKeys = "," + ignoreColKeys + ",";
        DataTableMetaData srcMetaData = src.getMetaData();
        DataTableMetaData tgtMetaData = tgt.getMetaData();
        ArrayList<Integer> srcIndexArray = new ArrayList<Integer>();
        ArrayList<Integer> tgtIndexArray = new ArrayList<Integer>();
        int size = srcMetaData.getColumnCount();
        int i = 0;
        while (i < size) {
            ColumnInfo colInfo = srcMetaData.getColumnInfo(i);
            int tgtIndex = tgtMetaData.findColumnIndexByKey(colInfo.getColumnKey());
            if (tgtIndex != -1) {
                srcIndexArray.add(i);
                tgtIndexArray.add(tgtIndex);
            }
            ++i;
        }
        size = srcIndexArray.size();
        int length = src.size();
        int index = 0;
        while (index < length) {
            tgt.append();
            int i2 = 0;
            while (i2 < size) {
                if (StringUtil.isBlankOrNull((String)ignoreColKeys) || !ignoreColKeys.contains("," + srcMetaData.getColumnInfo(i2).getColumnKey() + ",")) {
                    tgt.setObject(((Integer)tgtIndexArray.get(i2)).intValue(), src.getObject(index, ((Integer)srcIndexArray.get(i2)).intValue()));
                }
                ++i2;
            }
            ++index;
        }
    }

    public static void setSequence(DataTable dataTable) {
        int sequenceColumnIndex = dataTable.getMetaData().findColumnIndexByKey("Sequence");
        if (sequenceColumnIndex >= 0) {
            int i = 0;
            while (i < dataTable.size()) {
                dataTable.setObject(i, "Sequence", (Object)(i + 1));
                ++i;
            }
        }
    }

    public static DataTable generateDataTable(MetaTable metaTable) {
        DataTable table = new DataTable();
        table.setKey(metaTable.getKey());
        table.setCheckLength(metaTable.isPersist().booleanValue());
        Iterator it = metaTable.iterator();
        int index = 0;
        while (it.hasNext()) {
            MetaColumn metaColumn = (MetaColumn)it.next();
            if (metaColumn.isHidden().booleanValue()) continue;
            String columnKey = metaColumn.getKey();
            ColumnInfo columnInfo = new ColumnInfo(columnKey, metaColumn.getDataType().intValue());
            columnInfo.setAccessControl(metaColumn.isAccessControl());
            columnInfo.setPrimary(metaColumn.getIsPrimary());
            columnInfo.setDefaultValue(metaColumn.getDefaultValue());
            columnInfo.setScale(metaColumn.getScale());
            columnInfo.setLength(metaColumn.getLength());
            table.addColumn(index, columnInfo);
            ++index;
        }
        return table;
    }
}

