/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.utils;

import com.bokesoft.erp.mid.schema.ERPSchemaCheck;
import com.bokesoft.erp.mid.schema.ERPSchemaMaintance;
import com.bokesoft.erp.mid.schema.ERPSchemaProcess;
import com.bokesoft.erp.mid.schema.ERPSchemaViewDependSchemaTable;
import com.bokesoft.erp.mid.util.EnsureSingleDBStruct;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.mid.schemamgr.SchemaProProcess;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.schemamgr.ISchemaCreate;
import com.bokesoft.yigo.mid.schemamgr.SchemaCreateFactory;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RebuildTableUtil {
    private static final Map<String, Set<String>> dataObjectViewCacheMap = new HashMap<String, Set<String>>();

    public static void rebuildTable(DefaultContext defaultContext, String filePath) throws Throwable {
        String content = FileUtils.readFileToString((File)new File(filePath), (String)"UTF-8");
        String newSecondLine = DesignIOMetaUtil.getSecondLine(content);
        if (newSecondLine.contains("<CommonDef>")) {
            return;
        }
        String formKey = DesignIOMetaUtil.getSubString(newSecondLine, "Key=\"([A-Za-z_]\\w*)\"");
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(filePath));
        Element root = document.getRootElement();
        String name = root.getQName().getName();
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"DataObject")) {
            for (MetaFormProfile profile : metaFormList) {
                String mergeToSourceMapKey;
                String extend;
                String key;
                MetaDataObject dataObject;
                MetaDataSource dataSource;
                MetaForm form = profile.getForm();
                if (!Objects.nonNull(form) || !Objects.nonNull(dataSource = form.getDataSource()) || !Objects.nonNull(dataObject = dataSource.getDataObject()) || !StringUtils.equalsAny((CharSequence)formKey, (CharSequence[])new CharSequence[]{key = dataObject.getKey(), extend = dataObject.getExtend(), mergeToSourceMapKey = dataObject.getMergeToSourceMapKey()})) continue;
                return;
            }
            MetaDataObject dataObject = metaFactory.getDataObject(formKey);
            if (Objects.nonNull(dataObject)) {
                RebuildTableUtil.rebuildTable4VestDiff(defaultContext, dataObject);
            }
        } else {
            MetaFormProfile metaFormProfile = (MetaFormProfile)metaFormList.get(formKey);
            if (metaFormProfile == null) {
                metaFormProfile = (MetaFormProfile)metaFactory.getExtFormList().get(formKey);
            }
            if (metaFormProfile != null) {
                MetaForm form = metaFormProfile.getForm();
                if (metaFormProfile.getMergeToSource().booleanValue()) {
                    RebuildTableUtil.rebuildTable4VestDiff(defaultContext, form);
                } else if (!newSecondLine.contains("Extend") && form != null) {
                    RebuildTableUtil.rebuildTable4VestDiff(defaultContext, form);
                }
            }
        }
    }

    public static void rebuildTable4VestDiff(DefaultContext context, MetaForm metaForm) throws Throwable {
        MetaDataSource dataSource = metaForm.getDataSource();
        if (Objects.isNull(dataSource)) {
            return;
        }
        MetaDataObject dataObject = dataSource.getDataObject();
        if (Objects.isNull(dataObject)) {
            return;
        }
        RebuildTableUtil.rebuildTable4VestDiff(context, dataObject);
    }

    public static void rebuildTable4VestDiff(DefaultContext context, MetaDataObject dataObject) throws Throwable {
        block18: {
            LogSvr.getInstance().info("rebuildTable4VestDiff\uff1a" + dataObject.getKey() + "\u5f00\u59cb");
            DefaultContext newContext = null;
            try {
                newContext = new DefaultContext(context.getVE());
                MetaTableCollection tableCollection = dataObject.getTableCollection();
                HashMap<String, MetaTable> metaTableMap = new HashMap<String, MetaTable>();
                for (MetaTable metaTable : tableCollection) {
                    metaTableMap.put(metaTable.getKey(), metaTable);
                }
                ArrayList schemaTableList = dataObject.getSchemeTableList();
                if (schemaTableList == null) break block18;
                IDBManager dbManager = newContext.getDBManager();
                int secondaryType = dataObject.getSecondaryType();
                ERPSchemaProcess schemaProcess = RebuildTableUtil.getSchemaProcess(dbManager);
                DataBaseInfo info = schemaProcess.getInfo();
                for (MetaSchemaTable table : schemaTableList) {
                    SchemaProProcess.dataObjectProProcess((IDBManager)dbManager, (MetaSchemaTable)table);
                    try {
                        RebuildTableUtil.tableRebuild(dbManager, table, schemaProcess, info, metaTableMap);
                    }
                    catch (Throwable e) {
                        LogSvr.getInstance().error("tableRebuild\uff1a" + dataObject.getKey() + "\u51fa\u9519", e);
                    }
                }
                if (secondaryType == 6 && dataObject.getMigrationUpdateStrategy() == 5 && Objects.nonNull(dataObject.getErpMigrationKeysTable())) {
                    MetaTable mainMetaTable = dataObject.getMainTable();
                    try {
                        ERPSchemaMaintance.generateUnionIndex((IDBManager)dbManager, (MetaDataObject)dataObject, (ERPSchemaProcess)schemaProcess);
                    }
                    catch (Throwable e) {
                        LogSvr.getInstance().error("generateUnionIndex\uff1a" + dataObject.getKey() + "\u51fa\u9519", e);
                    }
                    Set<String> dataObjectViewCacheSet = dataObjectViewCacheMap.getOrDefault(dataObject.getKey(), Collections.emptySet());
                    ERPSchemaViewDependSchemaTable views = new ERPSchemaViewDependSchemaTable(dataObject);
                    List viewNames = views.getViewNames();
                    try {
                        Set<String> newDataObjectViewCacheSet = RebuildTableUtil.rebuildView(dbManager, mainMetaTable, views, viewNames, info, dataObjectViewCacheSet);
                        dataObjectViewCacheMap.put(dataObject.getKey(), newDataObjectViewCacheSet);
                    }
                    catch (Throwable e) {
                        LogSvr.getInstance().error("rebuildView\uff1a" + dataObject.getKey() + "\u51fa\u9519", e);
                    }
                }
                if (dbManager instanceof MultiDBManager) {
                    EnsureSingleDBStruct.buildTablesDataObject((MetaDataObject)dataObject, (MultiDBManager)((MultiDBManager)dbManager));
                }
                newContext.commit();
                LogSvr.getInstance().info("rebuildTable4VestDiff\uff1a" + dataObject.getKey() + "\u7ed3\u675f");
            }
            finally {
                if (newContext != null) {
                    try {
                        newContext.close();
                    }
                    catch (Throwable e) {
                        LogSvr.getInstance().error("RebuildTable\u51fa\u9519", e);
                    }
                }
            }
        }
    }

    private static List<MetaIndex> getiMetaIndexList(MetaSchemaTable table, ERPSchemaProcess schemaProcess) {
        ArrayList<MetaIndex> indexList = new ArrayList<MetaIndex>();
        for (MetaIndex metaIndex : table.getIndexCollection()) {
            indexList.add(metaIndex);
        }
        return indexList;
    }

    public static boolean tableRebuild(IDBManager dbManager, MetaSchemaTable table, ERPSchemaProcess schemaProcess, DataBaseInfo info, Map<String, MetaTable> metaTableMap) throws Throwable {
        if (dbManager instanceof MultiDBManager) {
            ((MultiDBManager)dbManager).setIgnoreXA(true);
        }
        boolean result = false;
        if (info.checkViewExist(table.getKey())) {
            return result;
        }
        ISchemaCreate schemaCreate = SchemaCreateFactory.getInstance().create();
        if (!info.checkTableExist(table.getKey())) {
            schemaCreate.createTable(dbManager, table);
            if (dbManager.getDBType() == 14) {
                dbManager.commit();
            }
            result = true;
            MetaIndexCollection indexCollection = table.getIndexCollection();
            MetaIndex metaIndex = RebuildTableUtil.acceptTableIndexs(table, metaTableMap, (Iterable<MetaIndex>)indexCollection);
            if (Objects.nonNull(metaIndex)) {
                indexCollection.add((KeyPairMetaObject)metaIndex);
            }
            if (indexCollection != null) {
                for (MetaIndex index : indexCollection) {
                    schemaProcess.createIndex(dbManager, schemaCreate, table, index);
                    schemaProcess.updateIndexColumns(table.getKey(), index);
                }
            }
        } else {
            LogSvr.getInstance().info("rebuildTable4VestDiff\uff1a\u66f4\u65b0\u8868" + table.getKey());
            ERPSchemaCheck schemaCheck = new ERPSchemaCheck(dbManager, table, info);
            List columns = schemaCheck.checkTable();
            if (columns.size() != 0) {
                String alterTableStr = dbManager.getAlterTableStr(table, columns);
                dbManager.execPrepareUpdate(alterTableStr, new Object[0]);
                if (dbManager.getDBType() == 14) {
                    dbManager.commit();
                }
                result = true;
            }
            try {
                List<MetaIndex> indexList = RebuildTableUtil.getiMetaIndexList(table, schemaProcess);
                MetaIndex metaIndex = RebuildTableUtil.acceptTableIndexs(table, metaTableMap, indexList);
                if (Objects.nonNull(metaIndex)) {
                    indexList.add(metaIndex);
                }
                RebuildTableUtil.checkAndUpdateDeleteIndex(dbManager, table, schemaProcess, indexList, metaTableMap);
                schemaProcess.checkUpdateIndex(dbManager, table, indexList, schemaCreate);
            }
            catch (Exception e) {
                LogSvr.getInstance().error("checkUpdateIndex\uff1a" + table.getKey() + "\u51fa\u9519", (Throwable)e);
                throw e;
            }
        }
        if (info != null) {
            info.updateInfo(table);
        }
        return result;
    }

    private static synchronized ERPSchemaProcess getSchemaProcess(IDBManager dbManager) throws Throwable {
        ERPSchemaProcess schemaProcess = ERPSchemaMaintance.getSchemaProcess();
        if (schemaProcess == null) {
            schemaProcess = new ERPSchemaProcess(dbManager);
            ERPSchemaMaintance.setSchemaProcess((ERPSchemaProcess)schemaProcess);
        }
        return schemaProcess;
    }

    private static Set<String> rebuildView(IDBManager dbManager, MetaTable mainMetaTable, ERPSchemaViewDependSchemaTable views, List<String> viewNames, DataBaseInfo info, Set<String> dataObjectViewCacheSet) throws Throwable {
        for (String viewName : viewNames) {
            if (!info.checkViewExist(viewName) && !dataObjectViewCacheSet.contains(viewName)) continue;
            String sql = new SqlString().append(new Object[]{"drop view "}).append(new Object[]{viewName}).getSql();
            if (dbManager.getDBType() == 14) {
                sql = new SqlString().append(new Object[]{"drop view "}).append(new Object[]{viewName}).append(new Object[]{" CASCADE"}).getSql();
            }
            dbManager.execPrepareUpdate(sql, new Object[0]);
            if (dbManager.getDBType() != 14) continue;
            dbManager.commit();
        }
        RebuildTableUtil.changeTableName(dbManager, mainMetaTable.getBindingDBTableName());
        LinkedHashMap createViewSqls = (LinkedHashMap)views.generateViewSqls(dbManager);
        if (!createViewSqls.isEmpty()) {
            for (Map.Entry entry : createViewSqls.entrySet()) {
                String viewSql = (String)entry.getValue();
                dbManager.execPrepareUpdate(viewSql, new Object[0]);
                if (dbManager.getDBType() != 14) continue;
                dbManager.commit();
            }
        }
        return createViewSqls.keySet();
    }

    private static void changeTableName(IDBManager dbManager, String tableName) throws Throwable {
        if (dbManager.checkTableExist(tableName)) {
            String oldTableName = String.valueOf(tableName) + "_old";
            if (dbManager.checkTableExist(oldTableName)) {
                RebuildTableUtil.renameTable(dbManager, oldTableName, String.valueOf(oldTableName) + System.currentTimeMillis());
            }
            RebuildTableUtil.renameTable(dbManager, tableName, oldTableName);
        }
    }

    private static void renameTable(IDBManager dbManager, String sourceTable, String targetTable) throws Throwable {
        SqlString sql = new SqlString();
        switch (dbManager.getDBType()) {
            case 4: {
                sql.append(new Object[]{"rename table ", sourceTable, " to ", targetTable});
                break;
            }
            case 2: 
            case 8: 
            case 14: {
                sql.append(new Object[]{"alter table ", sourceTable, " rename to ", targetTable});
                break;
            }
            case 1: {
                sql.append(new Object[]{"exec sp_rename ", sourceTable, ",", targetTable});
                break;
            }
        }
        dbManager.execPrepareUpdate(sql.getSql(), new Object[0]);
        if (dbManager.getDBType() == 14) {
            dbManager.commit();
        }
    }

    private static MetaIndex acceptTableIndexs(MetaSchemaTable table, Map<String, MetaTable> metaTableMap, Iterable<MetaIndex> indexList) {
        MetaTable metaTable = metaTableMap.get(table.getKey());
        if (Objects.isNull(metaTable)) {
            return null;
        }
        String soidIndexKey = String.valueOf(metaTable.getIndexPrefix4Create()) + "_SOID";
        boolean existFlag = false;
        for (MetaIndex metaIndex : indexList) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)metaIndex.getKey(), (CharSequence)soidIndexKey)) continue;
            existFlag = true;
            metaIndex.setUnique(Boolean.valueOf(false));
        }
        if (!existFlag && table.getColumnCollection().containsKey("SOID")) {
            MetaIndex metaIndex;
            metaIndex = new MetaIndex();
            metaIndex.setKey(soidIndexKey);
            metaIndex.setUnique(Boolean.valueOf(false));
            metaIndex.setColumns("SOID");
            return metaIndex;
        }
        return null;
    }

    private static void checkAndUpdateDeleteIndex(IDBManager dbManager, MetaSchemaTable table, ERPSchemaProcess schemaProcess, List<MetaIndex> indexList, Map<String, MetaTable> metaTableMap) {
        String tableKey = table.getKey();
        MetaTable metaTable = metaTableMap.get(tableKey);
        if (metaTable == null || Objects.isNull(metaTable.getIndexCollection()) || metaTable.getIndexCollection().isEmpty()) {
            return;
        }
        List indexKeyList = indexList.stream().map(m -> m.getKey().toLowerCase()).collect(Collectors.toList());
        HashMap indexColumnSet = schemaProcess.getInfo().getIndexColumnSet(tableKey);
        HashMap diff_indexColumnSet = new HashMap();
        indexColumnSet.forEach((key, value) -> {
            if (!indexKeyList.contains(key.toLowerCase()) && !"PRIMARY".equalsIgnoreCase((String)key)) {
                diff_indexColumnSet.put(key, value);
            }
        });
        if (diff_indexColumnSet.size() == 0) {
            return;
        }
        try {
            MetaIndex metaIndex = new MetaIndex();
            for (Map.Entry entry : diff_indexColumnSet.entrySet()) {
                String indexKey = (String)entry.getKey();
                String columns = (String)entry.getValue();
                metaIndex.setKey(indexKey);
                metaIndex.setColumns(columns);
                Field indexTableMapField = ERPSchemaProcess.class.getDeclaredField("indexTableMap");
                Field columnsIndexMapField = ERPSchemaProcess.class.getDeclaredField("columnsIndexMap");
                String indexName = indexKey.toUpperCase();
                String key2 = String.valueOf(tableKey.toUpperCase()) + "." + columns.toUpperCase();
                indexTableMapField.setAccessible(true);
                columnsIndexMapField.setAccessible(true);
                Map indexTableMap = (Map)indexTableMapField.get(schemaProcess);
                Map columnsIndexMap = (Map)columnsIndexMapField.get(schemaProcess);
                if (Objects.isNull(indexTableMap.get(indexName)) && Objects.isNull(columnsIndexMap.get(key2))) continue;
                Method privateMethod = ERPSchemaProcess.class.getDeclaredMethod("dropExistsIndex", IDBManager.class, String.class, MetaIndex.class);
                privateMethod.setAccessible(true);
                privateMethod.invoke((Object)schemaProcess, dbManager, tableKey, metaIndex);
                indexTableMap.remove(indexName);
                columnsIndexMap.remove(key2);
                indexTableMapField.set(schemaProcess, indexTableMap);
                columnsIndexMapField.set(schemaProcess, columnsIndexMap);
            }
        }
        catch (Exception e) {
            LogSvr.getInstance().error("checkAndUpdateDeleteIndex\uff1a" + table.getKey() + "\u51fa\u9519", (Throwable)e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

