/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.utils;

import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectMetaResolverUtils {
    private static final Logger log = LoggerFactory.getLogger(ProjectMetaResolverUtils.class);

    private static IMetaResolver getProjectMetaResolver(String projectKey) {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        IMetaResolver pResolver = metaFactory.getProjectResolver(projectKey);
        if (pResolver == null) {
            throw new IllegalArgumentException("Project 'projectKey' \u65e0\u6548: \u627e\u4e0d\u5230\u76f8\u5e94\u7684 MetaResolver");
        }
        return pResolver;
    }

    public static String tryGetProjectFilePath(String projectKey, String resourcePath) {
        IMetaResolver pResolver = ProjectMetaResolverUtils.getProjectMetaResolver(projectKey);
        try {
            return pResolver.getPath(resourcePath);
        }
        catch (Exception ex) {
            log.warn("Project '" + projectKey + "' \u83b7\u53d6\u8d44\u6e90\u6587\u4ef6 '" + resourcePath + "' \u8def\u5f84\u51fa\u9519, \u5c06\u8fd4\u56de null", (Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readProjectFile(String projectKey, String resourcePath) {
        IMetaResolver pResolver = ProjectMetaResolverUtils.getProjectMetaResolver(projectKey);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream ins = pResolver.read(resourcePath, 0);){
                String result = IOUtils.toString((InputStream)ins, (String)"UTF-8");
                if (ins != null) return result;
                log.info("\u5728 Project '" + projectKey + "' \u4e2d\u8bfb\u53d6 '" + resourcePath + "' \u8fd4\u56de null, \u539f\u56e0: \u83b7\u53d6\u7684 InputStream \u4e3a\u7a7a");
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception ex) {
            log.error("\u5728 Project '" + projectKey + "' \u4e2d\u8bfb\u53d6 '" + resourcePath + "' \u8fd4\u56de null, \u539f\u56e0: " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static void writeProjectFile(String projectKey, String resourcePath, String content) throws Exception {
        IMetaResolver pResolver = ProjectMetaResolverUtils.getProjectMetaResolver(projectKey);
        pResolver.write(resourcePath, content.getBytes("UTF-8"));
    }
}

