/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.utils;

import com.bokesoft.yes.design.cmd.CommonDefProcessor;
import com.bokesoft.yes.design.cmd.EntryProcessor;
import com.bokesoft.yes.design.cmd.SaveFileContentCmd;
import com.bokesoft.yes.design.cmd.SaveFilesByFormKeyCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.CheckXSDUtils;
import com.bokesoft.yes.design.utils.MetaDataObjectActionMapEx;
import com.bokesoft.yes.design.utils.MetaFormActionMapEx;
import com.bokesoft.yes.design.utils.RebuildTableUtil;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefSave;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaDataObjectSave;
import com.bokesoft.yes.meta.persist.dom.entry.MetaEntrySave;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormSave;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.meta.persist.dom.xml.node.Xml4jUtil;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaActionMap;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;

public class MetaUtils {
    public static void saveMetaCommonDef(IMetaFactory metaFactory, MetaCommonDef metaCommonDef, String filePath, String fileName, String projectKey, String solutionKey, List<UICommand> result, String content) throws Throwable {
        File file = new File(filePath);
        MetaCommonDefSave save = new MetaCommonDefSave((AbstractMetaObject)metaCommonDef);
        Document newDocument = save.getDocument();
        String newXml = MetaUtils.getNewXml(file.getAbsolutePath(), newDocument);
        CheckXSDUtils.checkXSD(metaFactory, "CommonDef", "", fileName, newXml, "", metaCommonDef, null);
        FileUtils.writeStringToFile((File)file, (String)newXml, (String)"UTF-8");
        XmlFileProcessor.instance.clearTmpFile(filePath);
        CommonDefProcessor.getInstance().reloadCommonDef(projectKey, solutionKey);
        result.add(UICommand.reloadMenuTree());
    }

    public static void saveMetaForm(IMetaFactory metaFactory, MetaForm metaForm, String filePath, String formKey, String cmd, String oldContent, String fileName, List<UICommand> result, DefaultContext context) throws Throwable {
        String newXml = MetaUtils.getNewXml(filePath, metaForm, null);
        CheckXSDUtils.checkXSD(metaFactory, "Form", formKey, fileName, newXml, "", null, null);
        FileUtils.writeStringToFile((File)new File(filePath), (String)newXml, (String)"UTF-8");
        SaveFileContentCmd.reloadForm(metaFactory, formKey, result);
        if (metaForm.getDataSource() != null) {
            RebuildTableUtil.rebuildTable(context, filePath);
        }
        XmlFileProcessor.recycleToTmpFormAndFileMap.remove("Entry@Entry" + formKey);
        result.add(UICommand.reloadXmlSource(filePath));
        SaveFileContentCmd.reloadDataObjects(result, metaFactory, filePath);
        SaveFilesByFormKeyCmd.removeScopeCache(metaForm, metaFactory, result);
        XmlFileProcessor.instance.clearTmpFile(filePath);
    }

    public static void saveMetaDataObject(IMetaFactory metaFactory, MetaDataObject metaDataObject, String filePath, String formKey, String cmd, String oldContent, String fileName, List<UICommand> result, DefaultContext context) throws Throwable {
        File file = new File(filePath);
        MetaDataObjectSave save = new MetaDataObjectSave((AbstractMetaObject)metaDataObject){

            protected IMetaActionMap getActionMap() {
                return MetaDataObjectActionMapEx.getInstance();
            }
        };
        Document newDocument = save.getDocument();
        String newXml = MetaUtils.getNewXml(file.getAbsolutePath(), newDocument);
        CheckXSDUtils.checkXSD(metaFactory, "DataObject", formKey, fileName, newXml, "", null, null);
        FileUtils.writeStringToFile((File)file, (String)newXml, (String)"UTF-8");
        if ("SaveFileContent".equals(cmd)) {
            SaveFileContentCmd.reloadDataObject(metaFactory, formKey, result, filePath, context);
        } else {
            SaveFilesByFormKeyCmd.reloadDataObject(metaFactory, formKey, result, filePath);
        }
        SaveFilesByFormKeyCmd.removeScopeCache(null, metaFactory, result);
        XmlFileProcessor.instance.clearTmpFile(filePath);
        result.add(UICommand.reloadXmlSource(filePath));
    }

    public static void saveMetaEntry(IMetaFactory metaFactory, MetaEntry metaEntry, String filePath, String projectKey, String fileName, List<UICommand> result) throws Throwable {
        File file = new File(filePath);
        MetaEntrySave save = new MetaEntrySave((AbstractMetaObject)metaEntry);
        Document newDocument = save.getDocument();
        String newXml = MetaUtils.getNewXml(file.getAbsolutePath(), newDocument);
        CheckXSDUtils.checkXSD(metaFactory, "Entry", "", fileName, newXml, projectKey, null, metaEntry);
        FileUtils.writeStringToFile((File)file, (String)newXml, (String)"UTF-8");
        XmlFileProcessor.instance.clearTmpFile(filePath);
        projectKey = LoadFileTree.getProjectKey(filePath);
        EntryProcessor.instance.reloadEntry(projectKey);
        result.add(UICommand.reloadMenuTree());
    }

    private static String getNewXml(String filePath, Document newDocument) throws Throwable {
        XmlTree oldXmlTree = Xml4jUtil.parseTree((String)filePath);
        CheckXSDUtils.resortAttrPosition(oldXmlTree.getRoot(), filePath);
        XmlCreator creator = new XmlCreator(newDocument, oldXmlTree);
        String xml = creator.createXml();
        String newContent = xml.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
        return newContent;
    }

    public static String getNewXml(String filePath, MetaForm form, final IMetaActionMap metaActionMap) throws Throwable {
        MetaFormSave save = new MetaFormSave((AbstractMetaObject)form){

            protected IMetaActionMap getActionMap() {
                if (metaActionMap == null) {
                    return MetaFormActionMapEx.getInstance();
                }
                return metaActionMap;
            }
        };
        Document newDocument = save.getDocument();
        return MetaUtils.getNewXml(filePath, newDocument);
    }
}

