/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.sql;

import com.bokesoft.yes.design.sql.TransmitConditions;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormLoad;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaCheckListBox;
import com.bokesoft.yigo.meta.form.component.control.MetaComboBox;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CalcColumnItemKey {
    public static IMetaFactory metaFactory;

    public static void main(String[] args) throws Throwable {
        String solutionPath = CalcColumnItemKey.getSolutionPath(args);
        CalcColumnItemKey.loadSolution(solutionPath);
        for (MetaDataObjectProfile dataObjectProfile : metaFactory.getDataObjectList()) {
            MetaDataObject dataObject = dataObjectProfile.getDataObject();
            CalcColumnItemKey.calcColumnItem(dataObject);
        }
    }

    private static void calcColumnItem(MetaDataObject metaDataObject) {
        if (Objects.isNull(metaDataObject)) {
            return;
        }
        MetaTableCollection metaTableCollection = metaDataObject.getTableCollection();
        if (metaTableCollection != null) {
            for (MetaTable metaTable : metaTableCollection) {
                CalcColumnItemKey.calcColumnItem(metaDataObject, metaTable);
            }
        }
    }

    private static void calcColumnItem(MetaDataObject metaDataObject, MetaTable metaTable) {
        for (MetaColumn metaColumn : metaTable) {
            try {
                String string = CalcColumnItemKey.calcColumnItem(metaFactory, metaDataObject, metaTable, metaColumn);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static String calcColumnItem(IMetaFactory metaFactory, MetaDataObject metaDataObject, MetaTable metaTable, MetaColumn metaColumn) throws Throwable {
        String itemKey = metaColumn.getItemKey();
        if (itemKey != null && itemKey.length() > 0) {
            return itemKey;
        }
        String columnKey = metaColumn.getKey();
        if (columnKey.equalsIgnoreCase("SOID") || columnKey.equalsIgnoreCase("ParentID")) {
            return null;
        }
        ArrayList<String> itemKeys = new ArrayList<String>();
        for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
            IDLookup idLookup;
            String fieldKey;
            MetaForm metaForm = metaFormProfile.getForm();
            if (Objects.isNull(metaForm) || (fieldKey = (idLookup = IDLookup.getIDLookup(metaForm)).getFieldKeyByTableColumnKey(metaTable.getKey(), metaColumn.getKey())) == null) continue;
            MetaComponent component = idLookup.getComponentByKey(fieldKey);
            if (component != null) {
                if (component.getControlType() == 206) {
                    MetaDict metaDict = (MetaDict)component;
                    itemKey = metaDict.getItemKey();
                    if (itemKeys.contains(itemKey)) continue;
                    itemKeys.add(itemKey);
                    continue;
                }
                if (component.getControlType() != 241) continue;
                throw new RuntimeException("\u8868" + metaTable.getBindingDBTableName() + "\u5b57\u6bb5" + metaColumn.getBindingDBColumnName() + "\u662f\u4e00\u4e2a\u52a8\u6001\u5b57\u5178\uff0c\u5355\u5143\u683c\u7ef4\u5ea6\u62a5\u8868\u4e2d\u4e0d\u652f\u6301\u3002");
            }
            MetaGridCell gridCell = idLookup.getGridCellByKey(fieldKey);
            if (gridCell == null) continue;
            if (gridCell.getCellType() == 206) {
                MetaDictProperties dicProperties = (MetaDictProperties)gridCell.getProperties();
                itemKey = dicProperties.getItemKey();
                if (itemKeys.contains(itemKey)) continue;
                itemKeys.add(itemKey);
                continue;
            }
            if (gridCell.getCellType() != 241) continue;
            throw new RuntimeException("\u8868" + metaTable.getBindingDBTableName() + "\u5b57\u6bb5" + metaColumn.getBindingDBColumnName() + "\u662f\u4e00\u4e2a\u52a8\u6001\u5b57\u5178\uff0c\u5355\u5143\u683c\u7ef4\u5ea6\u62a5\u8868\u4e2d\u4e0d\u652f\u6301\u3002");
        }
        int size = itemKeys.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (String)itemKeys.get(0);
        }
        throw new RuntimeException("\u8868" + metaTable.getBindingDBTableName() + "\u5b57\u6bb5" + metaColumn.getBindingDBColumnName() + "\u662f\u6709\u591a\u4e2aItemKey\u503c\uff0c" + itemKeys + "\u3002");
    }

    public static HashMap<MetaForm, String> getMetaFormByTableKey(IMetaFactory metaFactory, String metaTableKey) throws Throwable {
        HashMap<MetaForm, String> metaFormList = new HashMap<MetaForm, String>();
        for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
            MetaForm metaForm = metaFormProfile.getForm();
            if (Objects.isNull(metaForm) || Objects.isNull(metaForm.getDataSource())) continue;
            IDLookup idLookup = IDLookup.getIDLookup(metaForm);
            List<String> metaTableKeys = idLookup.getMetaTableKeys();
            for (String tableKey : metaTableKeys) {
                if (!tableKey.equalsIgnoreCase(metaTableKey)) continue;
                metaTableKey = tableKey;
                break;
            }
            MetaTable metaTable = null;
            try {
                metaTable = metaForm.getMetaTable(metaTableKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Objects.isNull(metaTable)) continue;
            String tableKey = metaFormList.get(metaForm);
            if (StringUtils.isNotEmpty((CharSequence)tableKey) && !tableKey.equalsIgnoreCase(metaTableKey)) {
                metaFormList.put(MetaObjectHelper.deptClone(metaForm), metaTable.getKey());
                continue;
            }
            metaFormList.put(metaForm, metaTable.getKey());
        }
        return metaFormList;
    }

    public static HashMap<String, TransmitConditions> getMetaComponentByfileKey(MetaForm metaForm, String metaTableKey, List<Pair<String, String>> list, HashMap<String, TransmitConditions> list1) throws Throwable {
        for (Pair<String, String> columnKey : list) {
            String columnKeyValue = (String)columnKey.getValue();
            String key = (String)columnKey.getKey();
            if (metaForm == null) continue;
            IDLookup idLookup = IDLookup.getIDLookup(metaForm);
            String componentFieldKey = idLookup.getFieldKeyByTableColumnKey(metaTableKey, columnKeyValue);
            MetaColumn metaColumn = (MetaColumn)metaForm.getDataSource().getDataObject().getMetaTable(metaTableKey).get(columnKeyValue);
            if (componentFieldKey != null) {
                MetaComboBoxProperties gridCell1;
                MetaComponent component = idLookup.getComponentByKey(componentFieldKey);
                if (component != null) {
                    MetaDict component1;
                    TransmitConditions transmitConditions = TransmitConditions.TransmitConditionsInit(key);
                    transmitConditions.setMetaColumn(metaColumn);
                    transmitConditions.setCellType(component.getControlType());
                    transmitConditions.setFiledKey(key);
                    transmitConditions.setComponentFieldCaption(component.getCaption());
                    transmitConditions.setColumnKey(columnKeyValue);
                    if (component.getControlType() == 206) {
                        component1 = (MetaDict)component;
                        transmitConditions.setItemColumnKey(component1.getItemKey());
                    } else if (component.getControlType() == 204) {
                        component1 = (MetaComboBox)component;
                        if (component1.getSourceType() == 1) {
                            transmitConditions.setFormulaItems(MetaObjectHelper.deptClone(component1.getFormulaItems()));
                        } else if (component1.getSourceType() == 2) {
                            transmitConditions.setMetaQueryDef(MetaObjectHelper.deptClone(component1.getQueryDef()));
                            transmitConditions.setItemsDependency(component1.getItemsDependency());
                        }
                        transmitConditions.setSourceType(component1.getSourceType());
                    } else if (component.getControlType() == 202) {
                        component1 = (MetaCheckListBox)component;
                        if (component1.getSourceType() == 1) {
                            transmitConditions.setFormulaItems(MetaObjectHelper.deptClone(component1.getFormulaItems()));
                        } else if (component1.getSourceType() == 2) {
                            transmitConditions.setMetaQueryDef(MetaObjectHelper.deptClone(component1.getQueryDef()));
                            transmitConditions.setItemsDependency(component1.getItemsDependency());
                        }
                        transmitConditions.setSourceType(component1.getSourceType());
                    }
                    list1.put(key, transmitConditions);
                    continue;
                }
                MetaGridCell gridCell = idLookup.getGridCellByKey(componentFieldKey);
                if (gridCell == null) continue;
                TransmitConditions transmitConditions = TransmitConditions.TransmitConditionsInit(key);
                transmitConditions.setMetaColumn(metaColumn);
                transmitConditions.setCellType(gridCell.getCellType());
                transmitConditions.setComponentFieldCaption(gridCell.getCaption());
                transmitConditions.setFiledKey(key);
                transmitConditions.setColumnKey(columnKeyValue);
                if (gridCell.getCellType() == 206) {
                    MetaDictProperties properties = (MetaDictProperties)gridCell.getProperties();
                    transmitConditions.setItemColumnKey(properties.getItemKey());
                } else if (gridCell.getCellType() == 204) {
                    gridCell1 = (MetaComboBoxProperties)gridCell.getProperties();
                    if (gridCell1.getSourceType() == 1) {
                        transmitConditions.setFormulaItems(MetaObjectHelper.deptClone(gridCell1.getFormulaItems()));
                    } else if (gridCell1.getSourceType() == 2) {
                        transmitConditions.setMetaQueryDef(MetaObjectHelper.deptClone(gridCell1.getQueryDef()));
                        transmitConditions.setDependentFields(gridCell1.getDependedFields());
                    }
                    transmitConditions.setSourceType(gridCell1.getSourceType());
                } else if (gridCell.getCellType() == 202) {
                    gridCell1 = (MetaComboBoxProperties)gridCell.getProperties();
                    if (gridCell1.getSourceType() == 1) {
                        transmitConditions.setFormulaItems(MetaObjectHelper.deptClone(gridCell1.getFormulaItems()));
                    } else if (gridCell1.getSourceType() == 2) {
                        transmitConditions.setMetaQueryDef(MetaObjectHelper.deptClone(gridCell1.getQueryDef()));
                        transmitConditions.setDependentFields(gridCell1.getDependedFields());
                    }
                    transmitConditions.setSourceType(gridCell1.getSourceType());
                }
                list1.put(key, transmitConditions);
                continue;
            }
            TransmitConditions transmitConditions = TransmitConditions.TransmitConditionsInit(key);
            transmitConditions.setMetaColumn(metaColumn);
            if (transmitConditions.getCellType() == 0) {
                transmitConditions.setCellType(215);
            }
            transmitConditions.setFiledKey(key);
            transmitConditions.setComponentFieldCaption(componentFieldKey);
            transmitConditions.setColumnKey(columnKeyValue);
            list1.put(key, transmitConditions);
        }
        return list1;
    }

    public static String getSolutionPath(String[] args) throws IOException {
        String solutionPath = FilePathHelper.getCoreSolutionPath();
        if (args != null && args.length > 0) {
            solutionPath = args[0];
        }
        return Paths.get(solutionPath, new String[0]).toAbsolutePath().toString();
    }

    private static void loadSolution(String solutionPath) throws Throwable {
        DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
        metaFactory = new DefaultMetaFactory((IMetaResolverFactory)metaResolverFactory);
        metaFactory.getSolution();
        CalcColumnItemKey.preLoadMetaFormNoVestNoTemplate(metaFactory);
    }

    private static void preLoadMetaFormNoVestNoTemplate(IMetaFactory metaFactory) throws Throwable {
        for (MetaFormProfile profile : metaFactory.getMetaFormList()) {
            MetaProject metaProject = (MetaProject)profile.getProject();
            IMetaResolver projectResourceResolver = metaFactory.getProjectResolver(metaProject.getKey());
            if (Objects.isNull(projectResourceResolver)) {
                throw new MetaException(89, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"ProjectResolverUndefined"), (Object[])new Object[]{metaProject.getKey()}));
            }
            MetaForm parentForm = null;
            MetaFormLoad formLoad = new MetaFormLoad(1, parentForm);
            formLoad.load(projectResourceResolver, profile.getResource());
            MetaForm metaForm = (MetaForm)formLoad.getRootMetaObject();
            metaForm.setMergeToSource(profile.getMergeToSource());
            metaForm.setProject((IMetaProject)metaProject);
            metaForm.setResource(profile.getResource());
            MetaDataSource metaDataSource = metaForm.getDataSource();
            if (metaDataSource != null) {
                MetaDataObject metaDataObject = metaDataSource.getDataObject();
                if (Objects.isNull(metaDataObject)) {
                    String refObjectKey = metaDataSource.getRefObjectKey();
                    if (refObjectKey != null && !refObjectKey.isEmpty()) {
                        metaDataObject = metaFactory.getDataObject(refObjectKey);
                        metaDataSource.setDataObject(metaDataObject);
                    }
                } else {
                    metaDataObject.setProject((IMetaProject)metaProject);
                }
            }
            profile.setForm(metaForm);
        }
    }
}

