/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.resolver.DesignSettingMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.setting.MetaSettingLoad;
import com.bokesoft.yes.meta.persist.dom.setting.MetaSettingSave;
import com.bokesoft.yigo.common.def.TreeMenuBarType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.setting.ClusterType;
import com.bokesoft.yigo.meta.setting.MetaBPMSetting;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SettingOperJsonUtil
extends HandleSettingImpl {
    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
        String xml = this.genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument((String)xml);
        MetaSettingLoad settingLoad = new MetaSettingLoad(1);
        settingLoad.load(document);
        MetaSetting metaSetting = (MetaSetting)settingLoad.getRootMetaObject();
        DesignSettingMetaResolver designSettingMetaResolver = new DesignSettingMetaResolver();
        this.dealMetaSetting(metaSetting);
        new MetaSettingSave((AbstractMetaObject)metaSetting).save((IMetaResolver)designSettingMetaResolver, filePath);
    }

    private void dealMetaSetting(MetaSetting metaSetting) throws Throwable {
        MetaBPMSetting bpmSetting = metaSetting.getBPMSetting();
        if (bpmSetting != null) {
            if (bpmSetting.getBPMMTable().size() == 0) {
                bpmSetting.setBPMMTable(null);
            }
            this.nullifyEmptyMetaBaseScriptFields(bpmSetting);
        }
    }

    public void nullifyEmptyMetaBaseScriptFields(Object obj) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Field[] fields;
        Class<?> clazz = obj.getClass();
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            MetaBaseScript metaBaseScript;
            Method getContentMethod;
            String content;
            Field field = fieldArray[n2];
            field.setAccessible(true);
            Object value = field.get(obj);
            if (value != null && MetaBaseScript.class.isAssignableFrom(field.getType()) && ((content = (String)(getContentMethod = (metaBaseScript = (MetaBaseScript)value).getClass().getMethod("getContent", new Class[0])).invoke((Object)metaBaseScript, new Object[0])) == null || content.isEmpty())) {
                String setName = "set" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
                Method setMethod = clazz.getMethod(setName, field.getType());
                setMethod.invoke(obj, new Object[]{null});
            }
            ++n2;
        }
    }

    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        DataTable settingDataTable = document.get("ED_Setting");
        DataTable attachmentServiceDataTable = document.get("ED_AttachmentService");
        DataTable dtsDataTable = document.get("ED_DTS");
        DataTable iOServiceDataTable = document.get("ED_IOService");
        DataTable hbeaParasDataTable = document.get("ED_hbea_paras");
        DataTable rightsProxyDataTable = document.get("ED_RightsProxy");
        DataTable sessionParaDataTable = document.get("ED_SessionPara");
        DataTable tagNameDataTable = document.get("ED_TagName");
        DataTable tagParaDataTable = document.get("ED_TagPara");
        DataTable bpmmDataTable = document.get("ED_BPMMGrid");
        this.dealSettingData(rootNode, settingDataTable);
        this.dealBPMSetting(rootNode, settingDataTable);
        this.dealBPMM(rootNode, bpmmDataTable);
        this.dealAttachmentOrDts(rootNode, settingDataTable, attachmentServiceDataTable, false);
        this.dealAttachmentOrDts(rootNode, settingDataTable, dtsDataTable, true);
        this.dealIoService(rootNode, iOServiceDataTable, hbeaParasDataTable);
        this.dealRightsProxyTable(rootNode, rightsProxyDataTable);
        this.dealSessionTable(rootNode, sessionParaDataTable);
        this.dealSimpleSettings(rootNode, tagNameDataTable, tagParaDataTable);
        xmlTree.xmlTree.setOrgXml(xmlTree.xmlTree.getOrgXml().replaceAll("></SysTopic>", "/>"));
    }

    private void dealSettingData(TagNode rootNode, DataTable settingDataTable) {
        String entryStyle;
        boolean isDbCluster;
        if (settingDataTable.size() == 0) {
            return;
        }
        int state = settingDataTable.getState(0);
        if (state == 0) {
            return;
        }
        boolean bl = isDbCluster = settingDataTable.getLong(0, "IsDbCluster") == 1L;
        if (isDbCluster) {
            rootNode.setAttribute("DbCluster", "true");
        } else {
            rootNode.deleteAttribute("DbCluster");
        }
        this.dealSession(rootNode, settingDataTable);
        TagNode entry = rootNode.getOrCreateChildByTagName("Entry");
        String entryStyle1 = settingDataTable.getString(0, "EntryStyle");
        String string = entryStyle = StringUtils.isEmpty((CharSequence)entryStyle1) ? "" : TreeMenuBarType.toString((Integer)Integer.parseInt(entryStyle1));
        if (!"GroupTree".equals(entryStyle) && TreeMenuBarType.parse((String)entryStyle) != -1) {
            entry.setAttribute("Style", entryStyle);
        } else {
            entry.deleteAttribute("Style");
        }
        this.dealCluster(rootNode, settingDataTable);
        this.dealLogin(rootNode, settingDataTable);
        this.dealForm(rootNode, settingDataTable);
        boolean isUseOptimization = settingDataTable.getInt("IsUseOptimization") == 1;
        TagNode migrationSetting = rootNode.getOrCreateChildByTagName("MigrationSetting");
        if (!isUseOptimization) {
            migrationSetting.setAttribute("UseOptimization", "false");
        } else {
            migrationSetting.deleteAttribute("UseOptimization");
        }
    }

    private void dealSession(TagNode rootNode, DataTable settingDataTable) {
        int timeout = settingDataTable.getNumeric(0, "Timeout").intValue();
        int mobileTimeout = settingDataTable.getNumeric(0, "MobileTimeout").intValue();
        int maxLoginCount = settingDataTable.getNumeric(0, "MaxLoginCount").intValue();
        String authenticateProvider = settingDataTable.getString(0, "AuthenticateProvider");
        String guestAuthenticateProvider = settingDataTable.getString(0, "GuestAuthenticateProvider");
        boolean isEnableLock = settingDataTable.getLong(0, "IsEnableLock") == 1L;
        boolean isSessionParaAsCluster = settingDataTable.getLong(0, "IsSessionParaAsCluster") == 1L;
        TagNode session = rootNode.getOrCreateChildByTagName("Session");
        if (timeout > 0 && timeout != 3600) {
            session.setAttribute("Timeout", String.valueOf(timeout));
        } else {
            session.deleteAttribute("Timeout");
        }
        if (mobileTimeout > 0) {
            session.setAttribute("MobileTimeout", String.valueOf(mobileTimeout));
        } else {
            session.deleteAttribute("MobileTimeout");
        }
        if (maxLoginCount > 0) {
            session.setAttribute("MaxLoginCount", String.valueOf(maxLoginCount));
        } else {
            session.deleteAttribute("MaxLoginCount");
        }
        if (StringUtils.isNotEmpty((CharSequence)authenticateProvider)) {
            session.setAttribute("AuthenticateProvider", authenticateProvider);
        } else {
            session.deleteAttribute("AuthenticateProvider");
        }
        if (StringUtils.isNotEmpty((CharSequence)authenticateProvider)) {
            session.setAttribute("GuestAuthenticateProvider", guestAuthenticateProvider);
        } else {
            session.deleteAttribute("GuestAuthenticateProvider");
        }
        if (isEnableLock) {
            session.setAttribute("EnableLock", "true");
        } else {
            session.deleteAttribute("EnableLock");
        }
        if (isSessionParaAsCluster) {
            session.setAttribute("SessionParaAsCluster", "true");
        } else {
            session.deleteAttribute("SessionParaAsCluster");
        }
        String sessionParaKey = settingDataTable.getString(0, "SessionParaKey");
        String sessionParaItemsProvider = settingDataTable.getString(0, "SessionParaItemsProvider");
        String sessionParaProcess = settingDataTable.getString(0, "SessionParaProcess");
        if (StringUtils.isNotEmpty((CharSequence)sessionParaKey)) {
            session.setAttribute("SessionParaKey", sessionParaKey);
        } else {
            session.deleteAttribute("SessionParaKey");
        }
        if (StringUtils.isNotEmpty((CharSequence)sessionParaItemsProvider)) {
            session.setAttribute("SessionParaItemsProvider", sessionParaItemsProvider);
        } else {
            session.deleteAttribute("SessionParaItemsProvider");
        }
        if (StringUtils.isNotEmpty((CharSequence)sessionParaProcess)) {
            session.setAttribute("SessionParaProcess", sessionParaProcess);
        } else {
            session.deleteAttribute("SessionParaProcess");
        }
        if (session.getAttributes().size() == 0) {
            rootNode.deleteChildByTagName("Session");
        }
    }

    private void dealCluster(TagNode rootNode, DataTable settingDataTable) {
        String clusterType1 = settingDataTable.getString(0, "ClusterType");
        String clusterType = StringUtils.isEmpty((CharSequence)clusterType1) ? "" : ClusterType.toString((Integer)Integer.parseInt(clusterType1));
        String clusterImpl = settingDataTable.getString(0, "ClusterImpl");
        String refItemKey = settingDataTable.getString(0, "RefItemKey");
        TagNode cluster = rootNode.getOrCreateChildByTagName("Cluster");
        if (StringUtils.isNotEmpty((CharSequence)clusterType)) {
            cluster.setAttribute("Type", clusterType);
        } else {
            cluster.deleteAttribute("Type");
        }
        if (StringUtils.isNotEmpty((CharSequence)clusterImpl)) {
            cluster.setAttribute("Impl", clusterImpl);
        } else {
            cluster.deleteAttribute("Impl");
        }
        if (StringUtils.isNotEmpty((CharSequence)refItemKey)) {
            cluster.setAttribute("RefItemKey", refItemKey);
        } else {
            cluster.deleteAttribute("RefItemKey");
        }
        if (cluster.getAttributes().size() == 0) {
            rootNode.deleteChildByTagName("Cluster");
        }
    }

    private void dealLogin(TagNode rootNode, DataTable settingDataTable) {
        boolean isSessionPara = settingDataTable.getInt(0, "IsSessionPara") == 1;
        boolean isMultiLang = settingDataTable.getInt(0, "IsMultiLang") == 1;
        String loginProcess = settingDataTable.getString(0, "LoginProcess");
        String logoutProcess = settingDataTable.getString(0, "LogoutProcess");
        String ssoProvider = settingDataTable.getString(0, "SSOProvider");
        TagNode login = rootNode.getOrCreateChildByTagName("Login");
        if (isSessionPara) {
            login.setAttribute("SessionPara", "true");
        } else {
            login.deleteAttribute("SessionPara");
        }
        if (isMultiLang) {
            login.setAttribute("MultiLang", "true");
        } else {
            login.deleteAttribute("MultiLang");
        }
        if (StringUtils.isNotEmpty((CharSequence)loginProcess)) {
            login.setAttribute("LoginProcess", loginProcess);
        } else {
            login.deleteAttribute("LoginProcess");
        }
        if (StringUtils.isNotEmpty((CharSequence)logoutProcess)) {
            login.setAttribute("LogoutProcess", logoutProcess);
        } else {
            login.deleteAttribute("LogoutProcess");
        }
        if (StringUtils.isNotEmpty((CharSequence)ssoProvider)) {
            login.setAttribute("SSOProvider", ssoProvider);
        } else {
            login.deleteAttribute("SSOProvider");
        }
        if (login.getAttributes().size() == 0) {
            rootNode.deleteChildByTagName("Login");
        }
    }

    private void dealForm(TagNode rootNode, DataTable settingDataTable) {
        boolean initFocus = settingDataTable.getInt("IsInitFocus") == 1;
        String rightsProvider = settingDataTable.getString(0, "RightsProvider");
        String dimValueProvider = settingDataTable.getString(0, "DimValueProvider");
        TagNode form = rootNode.getOrCreateChildByTagName("Form");
        if (!initFocus) {
            form.setAttribute("InitFocus", "false");
        } else {
            form.deleteAttribute("InitFocus");
        }
        if (StringUtils.isNotEmpty((CharSequence)rightsProvider)) {
            form.setAttribute("Provider", rightsProvider);
        } else {
            form.deleteAttribute("Provider");
        }
        if (StringUtils.isNotEmpty((CharSequence)dimValueProvider)) {
            form.setAttribute("DimValueProvider", dimValueProvider);
        } else {
            form.deleteAttribute("DimValueProvider");
        }
    }

    private void dealBPMSetting(TagNode rootNode, DataTable settingDataTable) {
        TagNode tagNode;
        boolean isRecalculateActiveWorkItem;
        TagNode bmpSetting = rootNode.getOrCreateChildByTagName("BPMSetting");
        boolean isQueryRetreatWorkItem = settingDataTable.getInt(0, "IsQueryRetreatWorkItem") == 1;
        boolean isQueryActiveWorkItem = settingDataTable.getInt(0, "IsQueryActiveWorkItem") == 1;
        boolean isQueryActiveStateWorkItem = settingDataTable.getInt(0, "IsQueryActiveStateWorkItem") == 1;
        boolean isRecordFormRights = settingDataTable.getInt(0, "IsRecordFormRights") == 1;
        boolean isIgnoreFormState = settingDataTable.getInt(0, "IsIgnoreFormState") == 1;
        boolean isQueryTransitTo = settingDataTable.getInt(0, "IsQueryTransitTo") == 1;
        boolean isCreateLog4EndNode = settingDataTable.getInt(0, "IsCreateLog4EndNode") == 1;
        boolean isCreateLog4BeginNode = settingDataTable.getInt(0, "IsCreateLog4BeginNode") == 1;
        boolean bl = isRecalculateActiveWorkItem = settingDataTable.getInt(0, "IsRecalculateActiveWorkItem") == 1;
        if (!isQueryRetreatWorkItem) {
            bmpSetting.setAttribute("QueryRetreatWorkitem", "false");
        } else {
            bmpSetting.deleteAttribute("QueryRetreatWorkitem");
        }
        if (isQueryActiveWorkItem) {
            bmpSetting.setAttribute("QueryActiveWorkitem", "true");
        } else {
            bmpSetting.deleteAttribute("QueryActiveWorkitem");
        }
        if (!isQueryActiveStateWorkItem) {
            bmpSetting.setAttribute("QueryActiveStateWorkitem", "false");
        } else {
            bmpSetting.deleteAttribute("QueryActiveStateWorkitem");
        }
        if (isRecordFormRights) {
            bmpSetting.setAttribute("RecordFormRights", "true");
        } else {
            bmpSetting.deleteAttribute("RecordFormRights");
        }
        if (isIgnoreFormState) {
            bmpSetting.setAttribute("IgnoreFormState", "true");
        } else {
            bmpSetting.deleteAttribute("IgnoreFormState");
        }
        if (isQueryTransitTo) {
            bmpSetting.setAttribute("QueryTransitTo", "true");
        } else {
            bmpSetting.deleteAttribute("QueryTransitTo");
        }
        if (isCreateLog4EndNode) {
            bmpSetting.setAttribute("CreateLog4EndNode", "true");
        } else {
            bmpSetting.deleteAttribute("CreateLog4EndNode");
        }
        if (isCreateLog4BeginNode) {
            bmpSetting.setAttribute("CreateLog4BeginNode", "true");
        } else {
            bmpSetting.deleteAttribute("CreateLog4BeginNode");
        }
        if (isRecalculateActiveWorkItem) {
            bmpSetting.setAttribute("RecalculateActiveWorkitem", "true");
        } else {
            bmpSetting.deleteAttribute("RecalculateActiveWorkitem");
        }
        String defaultBatchStateAction = settingDataTable.getString(0, "DefaultBatchStateAction");
        String defaultStateAction = settingDataTable.getString(0, "DefaultStateAction");
        String defaultAuditAction = settingDataTable.getString(0, "DefaultAuditAction");
        String defaultTaskAction = settingDataTable.getString(0, "DefaultTaskAction");
        String defaultCountersignAction = settingDataTable.getString(0, "DefaultCountersignAction");
        if (StringUtils.isNotEmpty((CharSequence)defaultBatchStateAction)) {
            tagNode = new TagNode("DefaultBatchStateAction", null);
            tagNode.setCDataValue(defaultBatchStateAction);
            bmpSetting.addNode(tagNode);
        } else {
            bmpSetting.deleteChildByTagName("DefaultBatchStateAction");
        }
        if (StringUtils.isNotEmpty((CharSequence)defaultStateAction)) {
            tagNode = new TagNode("DefaultStateAction", null);
            tagNode.setCDataValue(defaultStateAction);
            bmpSetting.addNode(tagNode);
        } else {
            bmpSetting.deleteChildByTagName("DefaultStateAction");
        }
        if (StringUtils.isNotEmpty((CharSequence)defaultAuditAction)) {
            tagNode = new TagNode("DefaultAuditAction", null);
            tagNode.setCDataValue(defaultAuditAction);
            bmpSetting.addNode(tagNode);
        } else {
            bmpSetting.deleteChildByTagName("DefaultAuditAction");
        }
        if (StringUtils.isNotEmpty((CharSequence)defaultTaskAction)) {
            tagNode = new TagNode("DefaultTaskAction", null);
            tagNode.setCDataValue(defaultTaskAction);
            bmpSetting.addNode(tagNode);
        } else {
            bmpSetting.deleteChildByTagName("DefaultTaskAction");
        }
        if (StringUtils.isNotEmpty((CharSequence)defaultCountersignAction)) {
            tagNode = new TagNode("DefaultCountersignAction", null);
            tagNode.setCDataValue(defaultCountersignAction);
            bmpSetting.addNode(tagNode);
        } else {
            bmpSetting.deleteChildByTagName("DefaultCountersignAction");
        }
        String bpmNodeAction = settingDataTable.getString(0, "BPMNodeAction");
        String workFlowHookPath = settingDataTable.getString(0, "WorkFlowHookPath");
        String bpmGraphInfoPath = settingDataTable.getString(0, "BPMGraphInfoPath");
        String bpmRightsProvider = settingDataTable.getString(0, "BPMRightsProvider");
        String retreatCaption = settingDataTable.getString(0, "RetreatCaption");
        String templateKey = settingDataTable.getString(0, "TemplateKey");
        String delegateCheck = settingDataTable.getString(0, "DelegateCheck");
        if (StringUtils.isNotEmpty((CharSequence)bpmNodeAction)) {
            bmpSetting.setAttribute("BPMNodeAction", bpmNodeAction);
        } else {
            bmpSetting.deleteAttribute("BPMNodeAction");
        }
        if (StringUtils.isNotEmpty((CharSequence)workFlowHookPath)) {
            bmpSetting.setAttribute("WorkFlowHookPath", workFlowHookPath);
        } else {
            bmpSetting.deleteAttribute("WorkFlowHookPath");
        }
        if (StringUtils.isNotEmpty((CharSequence)bpmGraphInfoPath)) {
            bmpSetting.setAttribute("BPMGraphInfoPath", bpmGraphInfoPath);
        } else {
            bmpSetting.deleteAttribute("BPMGraphInfoPath");
        }
        if (StringUtils.isNotEmpty((CharSequence)bpmRightsProvider)) {
            bmpSetting.setAttribute("RightsProvider", bpmRightsProvider);
        } else {
            bmpSetting.deleteAttribute("RightsProvider");
        }
        if (StringUtils.isNotEmpty((CharSequence)retreatCaption)) {
            bmpSetting.setAttribute("RetreatCaption", retreatCaption);
        } else {
            bmpSetting.deleteAttribute("RetreatCaption");
        }
        if (StringUtils.isNotEmpty((CharSequence)templateKey)) {
            bmpSetting.setAttribute("TemplateKey", templateKey);
        } else {
            bmpSetting.deleteAttribute("TemplateKey");
        }
        if (StringUtils.isNotEmpty((CharSequence)delegateCheck)) {
            bmpSetting.setAttribute("DelegateCheck", delegateCheck);
        } else {
            bmpSetting.deleteAttribute("DelegateCheck");
        }
    }

    private void dealBPMM(TagNode rootNode, DataTable bpmmDataTable) {
        if (!this.isTableChange(bpmmDataTable)) {
            return;
        }
        TagNode bmpSettingNode = rootNode.getOrCreateChildByTagName("BPMSetting");
        TagNode tableNode = bmpSettingNode.getOrCreateChildByTagName("Table");
        tableNode.deleteChildByTagName("Column");
        String key = "";
        String caption = "";
        String defaultValue = "";
        String dataType = "";
        String dbColumnName = "";
        Integer length = 0;
        Integer precision = 0;
        Integer scale = 0;
        int i = 0;
        while (i < bpmmDataTable.size()) {
            TagNode tagNode = new TagNode("Column", null);
            key = bpmmDataTable.getString(i, "ColumnKey");
            caption = bpmmDataTable.getString(i, "ColumnCaption");
            dataType = bpmmDataTable.getString(i, "DataType");
            dbColumnName = bpmmDataTable.getString(i, "DbColumnName");
            defaultValue = bpmmDataTable.getString(i, "DefaultValue");
            length = bpmmDataTable.getInt(i, "Length");
            precision = bpmmDataTable.getInt(i, "ColumnPrecision");
            scale = bpmmDataTable.getInt(i, "ColumnScale");
            tagNode.setAttribute("Key", key);
            tagNode.setAttribute("Caption", caption);
            tagNode.setAttribute("DataType", dataType);
            tagNode.setAttribute("DbColumnName", dbColumnName);
            if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                tagNode.setAttribute("DefaultValue", defaultValue);
            }
            if ("Varchar".equalsIgnoreCase(dataType) && length != null && length != 0 && length != 255) {
                tagNode.setAttribute("Length", length.toString());
            }
            if ("Numeric".equalsIgnoreCase(dataType) && precision != null && precision != 0 && precision != 16) {
                tagNode.setAttribute("Precision", precision.toString());
            }
            if ("Numeric".equalsIgnoreCase(dataType) && scale != null && scale != 0 && scale != 2) {
                tagNode.setAttribute("Scale", scale.toString());
            }
            tableNode.addNode(tagNode);
            ++i;
        }
    }

    private void dealAttachmentOrDts(TagNode rootNode, DataTable settingDataTable, DataTable dataTable, boolean isDts) throws Throwable {
        int settingState = settingDataTable.getState(0);
        String mainTagName = isDts ? "DTS" : "AttachmentService";
        int index = isDts ? 1 : 0;
        TagNode mainNode = rootNode.getChildByTagName(mainTagName);
        if (Objects.isNull(mainNode)) {
            mainNode = new TagNode(mainTagName, null);
            rootNode.addNode(mainNode, index);
        }
        if (settingDataTable.size() > 0 && settingState != 0) {
            String columnKey = isDts ? "DTSDefaultProvider" : "AttachmentDefaultProvider";
            String defaultProvider = settingDataTable.getString(0, columnKey);
            if (StringUtils.isNotEmpty((CharSequence)defaultProvider)) {
                mainNode.setAttribute("DefaultProvider", defaultProvider);
            } else {
                mainNode.deleteAttribute("DefaultProvider");
            }
        }
        dataTable.setShowDeleted(true);
        if (dataTable.size() == 0) {
            if (mainNode.getAttributes().size() == 0) {
                rootNode.deleteChildByTagName(mainTagName);
            }
            return;
        }
        if (!this.isTableChange(dataTable)) {
            return;
        }
        dataTable.setShowDeleted(false);
        String tagName = isDts ? "DTSProvider" : "AttachmentProvider";
        mainNode.deleteChildByTagName(tagName);
        String columnKey = isDts ? "DTSKey" : "AttachmentProviderKey";
        String columnDriver = isDts ? "DTSDriver" : "AttProviderDriver";
        String columnExternalConfig = isDts ? "DTSExternalConfig" : "AttExternalConfig";
        int i = 0;
        while (i < dataTable.size()) {
            String providerKey = Optional.ofNullable(dataTable.getString(i, columnKey)).orElse("");
            String driver = Optional.ofNullable(dataTable.getString(i, columnDriver)).orElse("");
            String externalConfig = Optional.ofNullable(dataTable.getString(i, columnExternalConfig)).orElse("");
            TagNode provider = new TagNode(tagName, null);
            provider.setAttribute("Key", providerKey);
            provider.setAttribute("Driver", driver);
            provider.setAttribute("ExternalConfig", externalConfig);
            mainNode.addNode(provider);
            ++i;
        }
        if (mainNode.getAttributes().size() == 0 && mainNode.getChildrenByTagName(tagName).size() == 0) {
            rootNode.deleteChildByTagName(mainTagName);
        }
    }

    private void dealSessionTable(TagNode rootNode, DataTable sessionParaDataTable) throws Throwable {
        sessionParaDataTable.setShowDeleted(true);
        if (sessionParaDataTable.size() == 0 || !this.isTableChange(sessionParaDataTable)) {
            return;
        }
        sessionParaDataTable.setShowDeleted(false);
        TagNode session = rootNode.getOrCreateChildByTagName("Session");
        session.deleteChildByTagName("SessionPara");
        int i = 0;
        while (i < sessionParaDataTable.size()) {
            String sessionParaKey = Optional.ofNullable(sessionParaDataTable.getString(i, "SessionParaKey")).orElse("");
            String sessionParaItemsProvider = Optional.ofNullable(sessionParaDataTable.getString(i, "SessionParaItemsProvider")).orElse("");
            boolean isAsCluster = Optional.ofNullable(sessionParaDataTable.getInt(i, "IsAsCluster")).orElse(0) == 1;
            TagNode sessionPara = new TagNode("SessionPara", null);
            sessionPara.setAttribute("ParaKey", sessionParaKey);
            sessionPara.setAttribute("Provider", sessionParaItemsProvider);
            if (isAsCluster) {
                sessionPara.setAttribute("AsCluster", "true");
            }
            session.addNode(sessionPara);
            ++i;
        }
    }

    private void dealRightsProxyTable(TagNode rootNode, DataTable rightsProxyDataTable) throws Throwable {
        rightsProxyDataTable.setShowDeleted(true);
        if (rightsProxyDataTable.size() == 0 || !this.isTableChange(rightsProxyDataTable)) {
            return;
        }
        rightsProxyDataTable.setShowDeleted(false);
        TagNode rightsProxyCollection = rootNode.getOrCreateChildByTagName("RightsProxyCollection");
        rightsProxyCollection.deleteChildByTagName("RightsProxy");
        int i = 0;
        while (i < rightsProxyDataTable.size()) {
            String rightsProxyKey = Optional.ofNullable(rightsProxyDataTable.getString(i, "RightsProxyKey")).orElse("");
            String rightsProxyDriver = Optional.ofNullable(rightsProxyDataTable.getString(i, "RightsProxyDriver")).orElse("");
            TagNode rightsProxy = new TagNode("RightsProxy", null);
            rightsProxy.setAttribute("Key", rightsProxyKey);
            rightsProxy.setAttribute("Driver", rightsProxyDriver);
            rightsProxyCollection.addNode(rightsProxy);
            ++i;
        }
    }

    private void dealIoService(TagNode rootNode, DataTable iOServiceDataTable, DataTable hbeaParasDataTable) throws Throwable {
        iOServiceDataTable.setShowDeleted(true);
        hbeaParasDataTable.setShowDeleted(true);
        if (iOServiceDataTable.size() == 0 || !this.isTableChange(iOServiceDataTable) && !this.isTableChange(hbeaParasDataTable)) {
            return;
        }
        iOServiceDataTable.setShowDeleted(false);
        hbeaParasDataTable.setShowDeleted(false);
        TagNode ioService = rootNode.getOrCreateChildByTagName("IOService");
        ioService.deleteChildByTagName("IOProvider");
        int i = 0;
        while (i < iOServiceDataTable.size()) {
            String ioServiceKey = Optional.ofNullable(iOServiceDataTable.getString(i, "IOServiceKey")).orElse("");
            String ioServiceDriver = Optional.ofNullable(iOServiceDataTable.getString(i, "IOServiceDriver")).orElse("");
            TagNode ioProvider = new TagNode("IOProvider", null);
            ioProvider.setAttribute("Driver", ioServiceDriver);
            ioProvider.setAttribute("Key", ioServiceKey);
            ioService.addNode(ioProvider);
            long pid = iOServiceDataTable.getLong(i, "OID");
            TagNode paras = new TagNode("Paras", null);
            ioProvider.addNode(paras);
            int j = 0;
            while (j < hbeaParasDataTable.size()) {
                long oid = hbeaParasDataTable.getLong(j, "POID");
                if (oid == pid) {
                    String paraKey = Optional.ofNullable(hbeaParasDataTable.getString(j, "ParaKey")).orElse("");
                    String paraValue = Optional.ofNullable(hbeaParasDataTable.getString(j, "ParaValue")).orElse("");
                    TagNode para = new TagNode("Para", null);
                    para.setAttribute("Value", paraValue);
                    para.setAttribute("Key", paraKey);
                    paras.addNode(para);
                }
                ++j;
            }
            if (paras.getChildrenByTagName("Para").size() == 0) {
                ioProvider.deleteChildByTagName("Paras");
            }
            ++i;
        }
    }

    private void dealSimpleSettings(TagNode rootNode, DataTable tagNameDataTable, DataTable tagParaDataTable) throws Throwable {
        tagNameDataTable.setShowDeleted(true);
        tagParaDataTable.setShowDeleted(true);
        if (tagNameDataTable.size() == 0 || !this.isTableChange(tagNameDataTable) && !this.isTableChange(tagParaDataTable)) {
            return;
        }
        tagParaDataTable.setShowDeleted(false);
        int i = 0;
        while (i < tagNameDataTable.size()) {
            String tagName = tagNameDataTable.getString(i, "TagName");
            if (tagNameDataTable.getState(i) == 3) {
                rootNode.deleteChildByTagName(tagName);
            } else {
                TagNode tag = rootNode.getOrCreateChildByTagName(tagName);
                tag.setAttributes(new HashMap<String, String>());
                long pid = tagNameDataTable.getLong(i, "OID");
                int j = 0;
                while (j < tagParaDataTable.size()) {
                    long oid = tagParaDataTable.getLong(j, "POID");
                    if (oid == pid) {
                        String tagParaKey = Optional.ofNullable(tagParaDataTable.getString(j, "TagParaKey")).orElse("");
                        String tagParaValue = Optional.ofNullable(tagParaDataTable.getString(j, "TagParaValue")).orElse("");
                        tag.setAttribute(tagParaKey, tagParaValue);
                    }
                    ++j;
                }
                if (tag.getAttributes().size() == 0) {
                    rootNode.deleteChildByTagName(tagName);
                }
            }
            ++i;
        }
    }

    @Override
    public void reload(String solutionPath) throws Exception {
        if ((solutionPath = StringUtils.substringBeforeLast((String)solutionPath, (String)File.separator)).endsWith("erp-solution-core")) {
            DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
            IMetaResolver iMetaResolver = metaResolverFactory.newMetaResolver("");
            MetaSettingLoad settingLoad = new MetaSettingLoad(1);
            settingLoad.load(iMetaResolver, "setting.xml");
            MetaSetting metaSetting = (MetaSetting)settingLoad.getRootMetaObject();
            MetaFactory.getGlobalInstance().setSetting(metaSetting);
        }
    }
}

