/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.CheckXMLChanged;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.FilePathHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;

public class SettingCommonUtils {
    public static List<Diff> getDiffsByJson(String jsonDiff) throws Throwable {
        JSONArray array = new JSONArray(jsonDiff);
        int len = array.length();
        ArrayList<Diff> diffs = new ArrayList<Diff>(len);
        int i = 0;
        while (i < len) {
            Diff diff = Diff.fromJson(array.getJSONObject(i));
            diffs.add(diff);
            ++i;
        }
        return diffs;
    }

    public static String saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
        String oldXml;
        XmlDiffProcessor.genXmlDiff(xmlTree, rootNode, diff, true);
        String orgXml = oldXml = xmlTree.xmlTree.getOrgXml();
        String path = diff.getFilePath();
        String orgXmlFragment = diff.getOrgXmlFragment();
        String newXmlFragment = diff.getNewXmlFragment();
        int startLine = diff.getStartLine();
        boolean insertIndent = diff.isPropertyDiff() && !diff.isGridColumnDrag();
        orgXml = CheckXMLChanged.mergeXML(orgXml, startLine, orgXmlFragment, newXmlFragment, null, insertIndent);
        if (diff.getNewXmlFragment() == null) {
            FileUtils.writeStringToFile((File)new File(path), (String)xmlTree.xmlTree.getOrgXml(), (String)"UTF-8");
        } else {
            FileUtils.writeStringToFile((File)new File(path), (String)orgXml, (String)"UTF-8");
        }
        if (diff.getNewXmlFragment() != null) {
            jsonObject.put("newXml", (Object)diff.getNewXmlFragment());
        } else {
            jsonObject.put("newXml", (Object)xmlTree.xmlTree.getOrgXml());
        }
        jsonObject.put("xmlPath", (Object)(StringUtil.isBlankOrNull((String)path) ? path : FilePathHelper.toFrontFilePath(path)));
        return oldXml;
    }
}

