/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.resolver.DesignSettingMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.paratable.MetaParaTableLoad;
import com.bokesoft.yes.meta.persist.dom.paratable.MetaParaTableSave;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.paratable.MetaParaGroup;
import com.bokesoft.yigo.meta.paratable.MetaParaTable;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ParaTableOperUtil
extends HandleSettingImpl {
    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
        String xml = this.genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument((String)xml);
        MetaParaTableLoad metaParaTableLoad = new MetaParaTableLoad(1);
        metaParaTableLoad.load(document);
        MetaParaTable paraTable = (MetaParaTable)metaParaTableLoad.getRootMetaObject();
        DesignSettingMetaResolver designSettingMetaResolver = new DesignSettingMetaResolver();
        new MetaParaTableSave((AbstractMetaObject)paraTable).save((IMetaResolver)designSettingMetaResolver, filePath);
    }

    @Override
    public void reload(String filePath) throws Throwable {
        String projectKey = LoadFileTree.getProjectKey(filePath);
        TreeNode treeNode = LoadFileTree.getTreeNode(filePath);
        String solutionKey = treeNode.solutionKey;
        boolean isVest = new File(filePath).getName().endsWith("Vest.xml");
        if (isVest) {
            this.reloadParaTableVest(projectKey, solutionKey);
        } else {
            this.reloadParaTable(projectKey, solutionKey);
        }
    }

    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode tagNode = xmlTree.xmlTree.getRoot();
        DataTable paraGroupList = document.get("ED_ParaItem");
        DataTable D_ParaTable = document.get("ED_ParaTable");
        tagNode.getChildren().clear();
        if (!D_ParaTable.isEmpty()) {
            this.dealParaList(paraGroupList, D_ParaTable, tagNode);
        }
    }

    public void reloadParaTable(String ProjectKey, String solutionKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        String key = metaFactory.getSolution().getKey();
        if (ProjectKey.isEmpty() && !key.equals(solutionKey)) {
            MetaParaTable paraTable = metaFactory.getParaTable();
            String solutionPath = LoadFileTree.getSolutionPath(solutionKey);
            DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
            IMetaResolver iMetaResolver = metaResolverFactory.newMetaResolver("");
            MetaParaTableLoad metaParaTableLoad = new MetaParaTableLoad(1);
            metaParaTableLoad.load(iMetaResolver, "ParaTable.xml");
            MetaParaTable metaParaGroups = (MetaParaTable)metaParaTableLoad.getRootMetaObject();
            for (MetaParaGroup metaParaGroup : metaParaGroups) {
                metaParaGroup.setSolution(solutionKey);
                metaParaGroup.setExtend(false);
                String key1 = metaParaGroup.getKey();
                if (!paraTable.containsKey(key1)) {
                    paraTable.add((KeyPairMetaObject)metaParaGroup);
                    continue;
                }
                if (((MetaParaGroup)paraTable.get(key1)).isExtend() || ((MetaParaGroup)paraTable.get(key1)).getSolution().equals(solutionKey)) continue;
                throw new MetaException(4227, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"RepeatParaGroupDefined"), (Object[])new Object[]{key1}));
            }
        } else if (StringUtils.isEmpty((CharSequence)ProjectKey)) {
            String solutionPath = metaFactory.getSolutionPath();
            DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
            IMetaResolver iMetaResolver = metaResolverFactory.newMetaResolver("");
            MetaParaTableLoad metaParaTableLoad = new MetaParaTableLoad(1);
            metaParaTableLoad.load(iMetaResolver, "ParaTable.xml");
            MetaParaTable metaParaGroups = (MetaParaTable)metaParaTableLoad.getRootMetaObject();
            MetaParaTable paraTable = metaFactory.getParaTable();
            for (MetaParaGroup metaParaGroup : metaParaGroups) {
                metaParaGroup.setSolution(solutionKey);
                metaParaGroup.setExtend(false);
                String key1 = metaParaGroup.getKey();
                if (!paraTable.containsKey(key1)) {
                    paraTable.add((KeyPairMetaObject)metaParaGroup);
                    continue;
                }
                if (((MetaParaGroup)paraTable.get(key1)).isExtend() || ((MetaParaGroup)paraTable.get(key1)).getSolution().equals(solutionKey)) continue;
                throw new MetaException(4227, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"RepeatParaGroupDefined"), (Object[])new Object[]{key1}));
            }
        } else {
            throw new Exception("\u6682\u4e0d\u652f\u6301\u53c2\u6570\u8868\u5b58\u5728\u4e8e\u9879\u76ee\u4e2d");
        }
    }

    public void reloadParaTableVest(String ProjectKey, String solutionKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        String key = metaFactory.getSolution().getKey();
        if (ProjectKey.isEmpty() && !key.equals(solutionKey)) {
            MetaParaTable paraTable = metaFactory.getParaTable();
            String solutionPath = LoadFileTree.getSolutionPath(solutionKey);
            DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
            IMetaResolver iMetaResolver = metaResolverFactory.newMetaResolver("");
            MetaParaTableLoad metaParaTableLoad = new MetaParaTableLoad(1);
            metaParaTableLoad.load(iMetaResolver, "ParaTable_Vest.xml");
            MetaParaTable metaParaGroups = (MetaParaTable)metaParaTableLoad.getRootMetaObject();
            for (MetaParaGroup metaParaGroup : metaParaGroups) {
                metaParaGroup.setSolution(solutionKey);
                metaParaGroup.setExtend(true);
                String key1 = metaParaGroup.getKey();
                if (paraTable.containsKey(key1) && ((MetaParaGroup)paraTable.get(key1)).isExtend() && !((MetaParaGroup)paraTable.get(key1)).getSolution().equals(solutionKey)) {
                    throw new MetaException(4227, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"RepeatParaGroupDefined"), (Object[])new Object[]{key1}));
                }
                if (paraTable.containsKey(key1)) {
                    metaParaGroup.merge((MetaParaGroup)paraTable.get(key1));
                    paraTable.add((KeyPairMetaObject)metaParaGroup);
                    continue;
                }
                paraTable.add((KeyPairMetaObject)metaParaGroup);
            }
        } else if (StringUtils.isEmpty((CharSequence)ProjectKey)) {
            String solutionPath = metaFactory.getSolutionPath();
            DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
            IMetaResolver iMetaResolver = metaResolverFactory.newMetaResolver("");
            MetaParaTableLoad metaParaTableLoad = new MetaParaTableLoad(1);
            metaParaTableLoad.load(iMetaResolver, "ParaTable_Vest.xml");
            MetaParaTable metaParaGroups = (MetaParaTable)metaParaTableLoad.getRootMetaObject();
            MetaParaTable paraTable = metaFactory.getParaTable();
            for (MetaParaGroup metaParaGroup : metaParaGroups) {
                metaParaGroup.setSolution(solutionKey);
                metaParaGroup.setExtend(true);
                String key1 = metaParaGroup.getKey();
                if (paraTable.containsKey(key1) && ((MetaParaGroup)paraTable.get(key1)).isExtend() && !((MetaParaGroup)paraTable.get(key1)).getSolution().equals(solutionKey)) {
                    throw new MetaException(4227, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"RepeatParaGroupDefined"), (Object[])new Object[]{key1}));
                }
                if (paraTable.containsKey(key1)) {
                    metaParaGroup.merge((MetaParaGroup)paraTable.get(key1));
                    paraTable.add((KeyPairMetaObject)metaParaGroup);
                    continue;
                }
                paraTable.add((KeyPairMetaObject)metaParaGroup);
            }
        } else {
            throw new Exception("\u6682\u4e0d\u652f\u6301\u53c2\u6570\u8868\u5b58\u5728\u4e8e\u9879\u76ee\u4e2d");
        }
    }

    public void dealParaList(DataTable paraGroupList, DataTable d_paraTable, TagNode paraList) {
        int j = 0;
        while (j < d_paraTable.size()) {
            String keyDetail = d_paraTable.getString(j, "GroupKey");
            String queryDescription = d_paraTable.getString(j, "GroupCaption");
            Long queryOid = d_paraTable.getLong(j, "OID");
            int state = d_paraTable.getState(j);
            if (state == 1 || state == 2 || state == 0) {
                TagNode paraGroup = new TagNode("ParaGroup", null);
                paraGroup.setAttribute("Key", keyDetail);
                paraGroup.setAttribute("Caption", queryDescription);
                if (paraGroupList.size() != 0) {
                    int i = 0;
                    while (i < paraGroupList.size()) {
                        if (paraGroupList.getLong(i, "POID").equals(queryOid)) {
                            TagNode paraItem = new TagNode("Item", null);
                            paraItem.setAttribute("Key", paraGroupList.getString(i, "ItemKey"));
                            paraItem.setAttribute("Caption", paraGroupList.getString(i, "ItemCaption"));
                            paraItem.setAttribute("Value", paraGroupList.getString(i, "ItemValue"));
                            paraGroup.addNode(paraItem);
                        }
                        ++i;
                    }
                }
                paraList.addNode(paraGroup);
            } else if (state == 3) {
                List<AbstractNode> childrenDelete = paraList.getChildren();
                Iterator<AbstractNode> iterator = childrenDelete.iterator();
                while (iterator.hasNext()) {
                    String chridrenName;
                    AbstractNode dren = iterator.next();
                    if (!(dren instanceof TagNode) || !"Item".equalsIgnoreCase(chridrenName = ((TagNode)dren).getTagName()) || !((TagNode)dren).getAttributes().get("Key").equalsIgnoreCase(keyDetail)) continue;
                    iterator.remove();
                }
            }
            ++j;
        }
    }
}

