/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.resolver.DesignSettingMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.rights.MetaRightsDefinitionLoad;
import com.bokesoft.yes.meta.persist.dom.rights.MetaRightsDefinitionSave;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.rights.MetaRightsDefinition;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class NoRightsOperJsonUtil
extends HandleSettingImpl {
    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        int i;
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        DataTable formRightsDataTable = document.get("ED_FormRights");
        DataTable dictRightsDataTable = document.get("ED_DictRights");
        if (formRightsDataTable.size() > 0) {
            formRightsDataTable.setShowDeleted(true);
        }
        if (dictRightsDataTable.size() > 0) {
            dictRightsDataTable.setShowDeleted(true);
        }
        if (formRightsDataTable.size() == 0) {
            rootNode.deleteChildByTagName("FormRightsCollection");
        } else if (this.isTableChange(formRightsDataTable)) {
            formRightsDataTable.setShowDeleted(false);
            rootNode.deleteChildByTagName("FormRightsCollection");
            TagNode formRightsCollection = new TagNode("FormRightsCollection", null);
            i = 0;
            while (i < formRightsDataTable.size()) {
                TagNode formDefinition = new TagNode("FormDefinition", null);
                String formKey = formRightsDataTable.getString(i, "FormKey");
                formDefinition.setAttribute("FormKey", formKey);
                formRightsCollection.addNode(formDefinition);
                ++i;
            }
            rootNode.addNode(formRightsCollection);
        }
        if (dictRightsDataTable.size() == 0) {
            rootNode.deleteChildByTagName("DictRightsCollection");
        } else if (this.isTableChange(dictRightsDataTable)) {
            dictRightsDataTable.setShowDeleted(false);
            rootNode.deleteChildByTagName("DictRightsCollection");
            TagNode dictRightsCollection = new TagNode("DictRightsCollection", null);
            i = 0;
            while (i < dictRightsDataTable.size()) {
                TagNode dictDefinition = new TagNode("DictDefinition", null);
                String dictKey = dictRightsDataTable.getString(i, "DictKey");
                dictDefinition.setAttribute("ItemKey", dictKey);
                dictRightsCollection.addNode(dictDefinition);
                ++i;
            }
            rootNode.addNode(dictRightsCollection);
        }
    }

    @Override
    public void reload(String path) throws Exception {
        String solutionPath = StringUtils.substringBeforeLast((String)path, (String)File.separator);
        String coreSolutionDir = "erp-solution-core";
        String coreSolutionPath = String.valueOf(StringUtils.substringBeforeLast((String)solutionPath, (String)File.separator)) + File.separator + coreSolutionDir;
        DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(coreSolutionPath);
        MetaRightsDefinition metaRightsDefinition = this.loadNoRights((IMetaResolverFactory)metaResolverFactory);
        Collection metaSolutions = MetaFactory.getGlobalInstance().getMetaSolutions();
        for (MetaSolution solution : metaSolutions) {
            IMetaResolverFactory resolverFactory = MetaFactory.getGlobalInstance().getMetaResolverFactoryBySolution(solution.getKey());
            if (Objects.isNull(resolverFactory)) continue;
            MetaRightsDefinition rightsDefinition = this.loadNoRights(resolverFactory);
            metaRightsDefinition = metaRightsDefinition.toMerge(rightsDefinition);
        }
        MetaFactory.getGlobalInstance().setRightsDefinition(metaRightsDefinition);
    }

    private MetaRightsDefinition loadNoRights(IMetaResolverFactory metaResolverFactory) throws Exception {
        IMetaResolver solutionResourceResolver = metaResolverFactory.newMetaResolver("");
        MetaRightsDefinitionLoad rightsDefinitionLoad = new MetaRightsDefinitionLoad(1);
        rightsDefinitionLoad.load(solutionResourceResolver, "NoRights.xml");
        MetaRightsDefinition rightsDefinition = (MetaRightsDefinition)rightsDefinitionLoad.getRootMetaObject();
        if (rightsDefinition != null) {
            rightsDefinition.doPostProcess(0, null);
        }
        return rightsDefinition;
    }

    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
        String xml = this.genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument((String)xml);
        MetaRightsDefinitionLoad rightsDefinitionLoad = new MetaRightsDefinitionLoad(1);
        rightsDefinitionLoad.load(document);
        MetaRightsDefinition rightsDefinition = (MetaRightsDefinition)rightsDefinitionLoad.getRootMetaObject();
        DesignSettingMetaResolver designSettingMetaResolver = new DesignSettingMetaResolver();
        new MetaRightsDefinitionSave((AbstractMetaObject)rightsDefinition).save((IMetaResolver)designSettingMetaResolver, filePath);
    }
}

