/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.resolver.DesignSettingMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.erp.config.ERPDataElementInit;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDataElementDefLoad;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDataElementDefSave;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;

public class DataElementDefOperJsonUtil
extends HandleSettingImpl {
    @Override
    public void reload(String filePath) throws Throwable {
        String projectKey = LoadFileTree.getProjectKey(filePath);
        TreeNode treeNode = LoadFileTree.getTreeNode(filePath);
        if (StringUtils.isEmpty((CharSequence)projectKey)) {
            String solutionKey = treeNode.solutionKey;
            IMetaResolverFactory metaResolverFactoryBySolution = MetaFactory.getGlobalInstance().getMetaResolverFactoryBySolution(solutionKey);
            IMetaResolver iMetaResolver = metaResolverFactoryBySolution.newMetaResolver("");
            String solutionPath = LoadFileTree.getSolutionPath(solutionKey);
            String fileRelationPath = StringUtils.replace((String)filePath, (String)(String.valueOf(solutionPath) + File.separator), (String)"");
            MetaDataElementDef metaDataElementDef = MetaUtil.loadDataElementDef((IMetaFactory)MetaFactory.getGlobalInstance(), (IMetaResolver)iMetaResolver, (String)solutionKey, null, (String)fileRelationPath);
            DataElementDefOperJsonUtil.reloadMetaDataElement(solutionKey, metaDataElementDef);
        }
    }

    private static void reloadMetaDataElement(String solutionKey, MetaDataElementDef metaDataElementDef) throws Throwable {
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        MetaDataElementDef metaDataElement = MetaUtil.loadDataElementDef((IMetaFactory)globalInstance, (String)solutionKey);
        globalInstance.getSolutionDataElementDefMap().put(solutionKey, metaDataElement);
        globalInstance.reloadDataElementDef();
        MetaDataElementDef elementDef = globalInstance.getDataElementDef();
        ERPDataElementInit.initSystemDataElement((IMetaFactory)globalInstance, (String)solutionKey, (MetaDataElementCollection)elementDef.getDataElementCollection());
        globalInstance.getSolutionDataElementDefMap().forEach((key, element) -> elementDef.toMerge(element));
        LinkedHashSet abstractMetaObjects = MetaUtil.reloadMetaDataElement((IMetaFactory)MetaFactory.getGlobalInstance(), (MetaDataElementDef)metaDataElementDef);
        for (AbstractMetaObject abstractMetaObject : abstractMetaObjects) {
            if (!(abstractMetaObject instanceof MetaFormProfile)) continue;
            MetaFormProfile metaObject = (MetaFormProfile)abstractMetaObject;
            MetaForm form = metaObject.getForm();
            try {
                String refObjectKey = form.getDataSource().getRefObjectKey();
                if (StringUtils.isNotEmpty((CharSequence)refObjectKey)) {
                    String pathByDataObject = LoadFileTree.getPathByDataObject(refObjectKey);
                    DataObjectHelper.reload(null, refObjectKey, pathByDataObject, null);
                    continue;
                }
                DesignReloadMetaObject.reloadMetaFormRollbackError(null, metaObject.getKey());
            }
            catch (Throwable e) {
                System.out.println(String.valueOf(metaObject.getKey()) + "\u91cd\u65b0\u52a0\u8f7d\u5931\u8d25");
            }
        }
    }

    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        DataTable edFieldLabelCollection = document.get("ED_FieldLabelCollection");
        DataTable edDataElementDef = document.get("ED_DataElementDef");
        edDataElementDef.setShowDeleted(true);
        TagNode dataElementCollectionNode = rootNode.getOrCreateChildByTagName("DataElementCollection");
        dataElementCollectionNode.deleteChildByTagName("DataElement");
        ArrayList<String> dataElementKeyList = new ArrayList<String>();
        int i = 0;
        while (i < edDataElementDef.size()) {
            block13: {
                String key;
                String domainKey;
                block12: {
                    if (edDataElementDef.getState(i) != 3 && edDataElementDef.getState(i) != 2) break block12;
                    TreeNode treeNode = LoadFileTree.getTreeNode(diff.filePath);
                    String solutionKey = treeNode.solutionKey;
                    MetaDataElementCollection domainCollection = MetaFactory.getGlobalInstance().getDataElementDef(solutionKey).getDataElementCollection();
                    domainKey = edDataElementDef.getString(i, "Key");
                    if (domainCollection != null && domainCollection.containsKey(domainKey)) {
                        domainCollection.remove(domainKey);
                    }
                    if (edDataElementDef.getState(i) == 3) break block13;
                }
                if (dataElementKeyList.contains(key = edDataElementDef.getString(i, "Key"))) {
                    throw new RuntimeException("\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u5143\u7d20\u6807\u8bc6\uff1a" + key);
                }
                dataElementKeyList.add(key);
                String oid = String.valueOf(edDataElementDef.getLong(i, "OID"));
                String caption = edDataElementDef.getString(i, "Caption");
                domainKey = edDataElementDef.getString(i, "DomainKey");
                String dataType = edDataElementDef.getString(i, "DataType");
                Integer precision = edDataElementDef.getInt(i, "Precision");
                Integer scale = edDataElementDef.getInt(i, "Scale");
                Integer length = edDataElementDef.getInt(i, "Length");
                String paramID = edDataElementDef.getString(i, "ParamID");
                String defaultCaption = edDataElementDef.getString(i, "DefaultCaption");
                String dataDiffLog = (String)StringUtils.defaultIfEmpty((CharSequence)edDataElementDef.getString(i, "DataDiffLog"), (CharSequence)"false");
                String noHistory = (String)StringUtils.defaultIfEmpty((CharSequence)edDataElementDef.getString(i, "NoHistory"), (CharSequence)"false");
                TagNode dataElementNode = new TagNode("DataElement", null);
                dataElementCollectionNode.addNode(dataElementNode);
                dataElementNode.setAttribute("Key", key);
                dataElementNode.setAttribute("Caption", caption);
                dataElementNode.setAttribute("DomainKey", domainKey);
                if (StringUtils.isNotEmpty((CharSequence)domainKey)) {
                    MetaDomain domain = MetaUtil.getDomain((IMetaFactory)MetaFactory.getGlobalInstance(), (String)domainKey);
                    if (domain == null) {
                        throw new RuntimeException(String.valueOf(domainKey) + " domain is not exist");
                    }
                } else {
                    dataElementNode.setAttribute("DataType", dataType);
                    dataElementNode.setAttribute("Precision", precision.toString(), "0");
                    dataElementNode.setAttribute("Scale", scale.toString(), "0");
                    dataElementNode.setAttribute("Length", length.toString(), "0");
                }
                dataElementNode.setAttribute("ParamID", paramID);
                dataElementNode.setAttribute("DefaultCaption", defaultCaption);
                dataElementNode.setAttribute("DataDiffLog", dataDiffLog, "false");
                dataElementNode.setAttribute("NoHistory", noHistory, "false");
                TagNode fieldLabelCollection = dataElementNode.getChildByTagName("FieldLabelCollection");
                if (fieldLabelCollection != null) {
                    fieldLabelCollection.deleteChildByTagName("FieldLabel");
                }
                int j = 0;
                while (j < edFieldLabelCollection.size()) {
                    String subOid = String.valueOf(edFieldLabelCollection.getLong(j, "POID"));
                    if (oid.equalsIgnoreCase(subOid)) {
                        fieldLabelCollection = dataElementNode.getOrCreateChildByTagName("FieldLabelCollection");
                        String key1 = edFieldLabelCollection.getString(j, "Key");
                        String length1 = edFieldLabelCollection.getString(j, "Length");
                        String text = edFieldLabelCollection.getString(j, "Text");
                        TagNode fieldLabel = new TagNode("FieldLabel", null);
                        fieldLabelCollection.addNode(fieldLabel);
                        fieldLabel.setAttribute("Key", key1);
                        fieldLabel.setAttribute("Length", length1, "0");
                        fieldLabel.setAttribute("Text", text);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
        String xml = this.genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument((String)xml);
        MetaDataElementDefLoad dataElementDefLoad = new MetaDataElementDefLoad(1);
        dataElementDefLoad.load(document);
        MetaDataElementDef dataElementDef = (MetaDataElementDef)dataElementDefLoad.getRootMetaObject();
        DesignSettingMetaResolver designSettingMetaResolver = new DesignSettingMetaResolver();
        new MetaDataElementDefSave((AbstractMetaObject)dataElementDef).save((IMetaResolver)designSettingMetaResolver, filePath);
    }
}

