/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.CommonDefProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.mergesingle.common.MergeSingleDiffUtil;
import com.bokesoft.yes.design.mergesingle.util.FormToolOperUtil;
import com.bokesoft.yes.design.newproject.DesignCommonDefMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefLoad;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefSave;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CommonDefOperJsonUtil
extends HandleSettingImpl {
    @Override
    public void reload(String filePath) throws Throwable {
        String projectKey = LoadFileTree.getProjectKey(filePath);
        TreeNode treeNode = LoadFileTree.getTreeNode(filePath);
        String solutionKey = treeNode.solutionKey;
        CommonDefProcessor.getInstance().reloadCommonDef(projectKey, solutionKey);
    }

    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        DataTable collecTable = document.get("ED_OperationToolbarDetail");
        DataTable fieldTable = document.get("ED_Operations");
        DataTable macroDetail = document.get("ED_MacroFormula");
        DataTable scriptList = document.get("ED_ScriptList");
        DataTable queryStatement = document.get("ED_QueryStatement");
        DataTable parameterCollection = document.get("ED_QueryParameterCollection");
        DataTable queryCollection = document.get("ED_QueryCollection");
        DataTable statusCollection = document.get("ED_StatusList");
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        if (statusCollection.size() != 0) {
            TagNode tagNode = xmlTree.xmlTree.getRoot().getOrCreateChildByTagName("StatusCollection");
            if (tagNode == null) {
                tagNode = new TagNode("StatusCollection", null);
                xmlTree.xmlTree.getRoot().addNode(tagNode, 4);
            } else {
                tagNode.deleteChildByTagName("Status");
            }
            this.dealStatusList(statusCollection, tagNode);
        } else {
            xmlTree.xmlTree.getRoot().deleteChildByTagName("StatusCollection");
        }
        CommonDefOperJsonUtil.dealOperationToobar(xmlTree, collecTable, fieldTable, macroDetail, scriptList, queryStatement, parameterCollection, queryCollection, diff);
        MergeSingleDiffUtil.genSingleXmlDiff(xmlTree.xmlTree.getRoot(), diff);
    }

    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
        String xml = this.genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument((String)xml);
        MetaCommonDefLoad metaCommonDefLoad = new MetaCommonDefLoad(1);
        metaCommonDefLoad.load(document);
        MetaCommonDef metaCommonDef = (MetaCommonDef)metaCommonDefLoad.getRootMetaObject();
        this.dealMetaCommonDef(metaCommonDef);
        DesignCommonDefMetaResolver designCommonDefMetaResolver = new DesignCommonDefMetaResolver();
        new MetaCommonDefSave((AbstractMetaObject)metaCommonDef).save((IMetaResolver)designCommonDefMetaResolver, filePath);
        if (diff.getNewXmlFragment() != null) {
            jsonObject.put("newXml", (Object)diff.getNewXmlFragment());
        } else {
            jsonObject.put("newXml", (Object)xmlTree.xmlTree.getOrgXml());
        }
        jsonObject.put("xmlPath", (Object)(StringUtil.isBlankOrNull((String)filePath) ? filePath : FilePathHelper.toFrontFilePath(filePath)));
    }

    private void dealMetaCommonDef(MetaCommonDef metaCommonDef) {
        if (metaCommonDef.getScriptCollection() == null) {
            return;
        }
        for (MetaScript metaScript : metaCommonDef.getScriptCollection()) {
            if (metaScript.getVerb() != -1) continue;
            metaScript.setVerb(Integer.valueOf(100));
        }
    }

    public void dealStatusList(DataTable statusCollection, TagNode tagNode) {
        int j = 0;
        while (j < statusCollection.size()) {
            String keyDetail = statusCollection.getString(j, "Key");
            String statusCaption = statusCollection.getString(j, "Caption");
            Integer statusValue = statusCollection.getInt(j, "StatusValue");
            boolean standalone = statusCollection.getBoolean(j, "IsStandalone");
            int state = statusCollection.getState(j);
            if (state == 1 || state == 2 || state == 0) {
                TagNode script = new TagNode("Status", null);
                script.setAttribute("Key", keyDetail);
                if (StringUtils.isNotEmpty((CharSequence)statusCaption)) {
                    script.setAttribute("Caption", statusCaption);
                }
                if (statusValue != -1) {
                    script.setAttribute("Value", String.valueOf(statusValue));
                }
                script.setAttribute("Standalone", String.valueOf(standalone));
                tagNode.addNode(script);
            } else if (state == 3) {
                List<AbstractNode> childrenDelete = tagNode.getChildren();
                Iterator<AbstractNode> iterator = childrenDelete.iterator();
                while (iterator.hasNext()) {
                    String chridrenName;
                    AbstractNode dren = iterator.next();
                    if (!(dren instanceof TagNode) || !"Status".equalsIgnoreCase(chridrenName = ((TagNode)dren).getTagName()) || !((TagNode)dren).getAttributes().get("Key").equalsIgnoreCase(keyDetail)) continue;
                    iterator.remove();
                }
            }
            ++j;
        }
    }

    public static void dealOperationToobar(XmlTreeWithPath xmlTree, DataTable collecTable, DataTable fieldTable, DataTable marcoTable, DataTable scriptList, DataTable queryStatement, DataTable parameterCollection, DataTable queryCollection, Diff diff) throws Throwable {
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        FormToolOperUtil.dealOperationCollection(collecTable, fieldTable, rootNode, false, false, null, null);
        FormToolOperUtil.dealMacroCollection(marcoTable, rootNode, false, null);
        FormToolOperUtil.dealScriptNode(scriptList, rootNode, false, null);
        FormToolOperUtil.dealParameterCollection(queryCollection, rootNode, queryStatement, parameterCollection, false, null);
    }
}

