/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.search.text;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.design.search.FileSearchResult;
import com.bokesoft.yes.design.search.text.FileMatch;
import com.bokesoft.yes.design.search.text.Match;
import java.io.File;
import java.util.ArrayList;
import org.json.JSONObject;

public class LineElement {
    private final File fParent;
    private final int fLineNumber;
    private final int fLineStartOffset;
    private final String fLineContents;

    public LineElement(File parent, int lineNumber, int lineStartOffset, String lineContents) {
        this.fParent = parent;
        this.fLineNumber = lineNumber;
        this.fLineStartOffset = lineStartOffset;
        this.fLineContents = lineContents;
    }

    public File getParent() {
        return this.fParent;
    }

    public int getLine() {
        return this.fLineNumber;
    }

    public String getContents() {
        return this.fLineContents;
    }

    public int getOffset() {
        return this.fLineStartOffset;
    }

    public boolean contains(int offset) {
        return this.fLineStartOffset <= offset && offset < this.fLineStartOffset + this.fLineContents.length();
    }

    public int getLength() {
        return this.fLineContents.length();
    }

    public FileMatch[] getMatchs(FileSearchResult result) {
        Match[] matches;
        ArrayList<FileMatch> res = new ArrayList<FileMatch>();
        Match[] matchArray = matches = result.getMatches(this.fParent);
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            FileMatch curr = (FileMatch)match;
            if (curr.getLineElement() == this) {
                res.add(curr);
            }
            ++n2;
        }
        return res.toArray(new FileMatch[res.size()]);
    }

    public int getNumberOfMatches(FileSearchResult result) {
        Match[] matches;
        int count = 0;
        Match[] matchArray = matches = result.getMatches(this.fParent);
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            FileMatch curr = (FileMatch)match;
            if (curr.getLineElement() == this) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public String toString() {
        JSONObject jsonObj = new JSONObject();
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"Content", (Object)this.getContents());
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"Length", (Object)this.getLength());
        return jsonObj.toString();
    }
}

