/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.search;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternConstructor {
    private PatternConstructor() {
    }

    public static Pattern createPattern(String pattern, boolean isRegex, boolean isCaseSensitive, boolean isWholeWord) throws PatternSyntaxException {
        if (pattern == null || pattern.length() == 0) {
            throw new RuntimeException("Cannot create regex from empty string");
        }
        if (!isRegex) {
            pattern = PatternConstructor.escapeRegExpCharacters(pattern);
        }
        if (isWholeWord) {
            int len = pattern.length();
            if (PatternConstructor.isWordChar(pattern.charAt(0))) {
                pattern = "\\b" + pattern;
            }
            if (PatternConstructor.isWordChar(pattern.charAt(len - 1))) {
                pattern = String.valueOf(pattern) + "\\b";
            }
        }
        int regexOptions = 8;
        if (!isCaseSensitive) {
            regexOptions |= 0x42;
        }
        return Pattern.compile(pattern, regexOptions);
    }

    public static Pattern createPattern(String pattern, boolean isRegex, boolean isStringMatcher, boolean isCaseSensitive, boolean isWholeWord) throws PatternSyntaxException {
        if (isRegex) {
            if (isWholeWord) {
                throw new RuntimeException("isWholeWord unsupported together with isRegex");
            }
            pattern = PatternConstructor.substituteLinebreak(pattern);
        } else {
            int len = pattern.length();
            StringBuilder buffer = new StringBuilder(len + 10);
            if (isWholeWord && len > 0 && PatternConstructor.isWordChar(pattern.charAt(0))) {
                buffer.append("\\b");
            }
            PatternConstructor.appendAsRegEx(isStringMatcher, pattern, buffer);
            if (isWholeWord && len > 0 && PatternConstructor.isWordChar(pattern.charAt(len - 1))) {
                buffer.append("\\b");
            }
            pattern = buffer.toString();
        }
        int regexOptions = 8;
        if (!isCaseSensitive) {
            regexOptions |= 0x42;
        }
        return Pattern.compile(pattern, regexOptions);
    }

    private static String substituteLinebreak(String findString) throws PatternSyntaxException {
        int length = findString.length();
        StringBuilder buf = new StringBuilder(length);
        int inCharGroup = 0;
        int inBraces = 0;
        boolean inQuote = false;
        int i = 0;
        while (i < length) {
            char ch = findString.charAt(i);
            switch (ch) {
                case '[': {
                    buf.append(ch);
                    if (inQuote) break;
                    ++inCharGroup;
                    break;
                }
                case ']': {
                    buf.append(ch);
                    if (inQuote) break;
                    --inCharGroup;
                    break;
                }
                case '{': {
                    buf.append(ch);
                    if (inQuote || inCharGroup != 0) break;
                    ++inBraces;
                    break;
                }
                case '}': {
                    buf.append(ch);
                    if (inQuote || inCharGroup != 0) break;
                    --inBraces;
                    break;
                }
                case '\\': {
                    if (i + 1 < length) {
                        char ch1 = findString.charAt(i + 1);
                        if (inQuote) {
                            if (ch1 == 'E') {
                                inQuote = false;
                            }
                            buf.append(ch).append(ch1);
                            ++i;
                            break;
                        }
                        if (ch1 == 'R') {
                            if (inCharGroup > 0 || inBraces > 0) {
                                throw new PatternSyntaxException("Illegal position for \\\\R", findString, i);
                            }
                            buf.append("(?>\\r\\n?|\\n)");
                            ++i;
                            break;
                        }
                        if (ch1 == 'Q') {
                            inQuote = true;
                        }
                        buf.append(ch).append(ch1);
                        ++i;
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    private static boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c);
    }

    public static String escapeRegExpCharacters(String pattern) {
        int len = pattern.length();
        StringBuilder buffer = new StringBuilder(len + 10);
        boolean isEscaped = false;
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '\\': {
                    if (!isEscaped) {
                        isEscaped = true;
                        break;
                    }
                    buffer.append("\\\\");
                    isEscaped = false;
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (isEscaped) {
                        buffer.append("\\\\");
                        isEscaped = false;
                    }
                    buffer.append("\\");
                    buffer.append(c);
                    break;
                }
                case '?': {
                    if (!isEscaped) {
                        buffer.append('.');
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    isEscaped = false;
                    break;
                }
                case '*': {
                    if (!isEscaped) {
                        buffer.append(".*");
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    isEscaped = false;
                    break;
                }
                default: {
                    if (isEscaped) {
                        buffer.append("\\\\");
                        isEscaped = false;
                    }
                    buffer.append(c);
                }
            }
            ++i;
        }
        if (isEscaped) {
            buffer.append("\\\\");
            isEscaped = false;
        }
        return buffer.toString();
    }

    public static StringBuilder appendAsRegEx(boolean isStringMatcher, String pattern, StringBuilder buffer) {
        boolean isEscaped = false;
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '\\': {
                    if (isStringMatcher && !isEscaped) {
                        isEscaped = true;
                        break;
                    }
                    buffer.append("\\\\");
                    isEscaped = false;
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (isEscaped) {
                        buffer.append("\\\\");
                        isEscaped = false;
                    }
                    buffer.append("\\");
                    buffer.append(c);
                    break;
                }
                case '?': {
                    if (isStringMatcher && !isEscaped) {
                        buffer.append('.');
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    isEscaped = false;
                    break;
                }
                case '*': {
                    if (isStringMatcher && !isEscaped) {
                        buffer.append(".*");
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    isEscaped = false;
                    break;
                }
                default: {
                    if (isEscaped) {
                        buffer.append("\\\\");
                        isEscaped = false;
                    }
                    buffer.append(c);
                }
            }
            ++i;
        }
        if (isEscaped) {
            buffer.append("\\\\");
            isEscaped = false;
        }
        return buffer;
    }
}

