/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.search;

import com.bokesoft.yes.design.search.text.Match;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileSearchResult {
    private static final Match[] EMPTY_ARRAY = new Match[0];
    private final Map<Object, List<Match>> fElementsToMatches = new HashMap<Object, List<Match>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMatch(Match match) {
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            this.doAddMatch(match);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMatches(Match[] matches) {
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            Match[] matchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                this.doAddMatch(match);
                ++n2;
            }
        }
    }

    private boolean doAddMatch(Match match) {
        List<Match> matches = this.fElementsToMatches.get(match.getElement());
        if (matches == null) {
            matches = new ArrayList<Match>();
            this.fElementsToMatches.put(match.getElement(), matches);
            matches.add(match);
            return true;
        }
        if (!matches.contains(match)) {
            FileSearchResult.insertSorted(matches, match);
            return true;
        }
        return false;
    }

    private static void insertSorted(List<Match> matches, Match match) {
        int insertIndex = FileSearchResult.getInsertIndex(matches, match);
        matches.add(insertIndex, match);
    }

    private static int getInsertIndex(List<Match> matches, Match match) {
        int count = matches.size();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Match data = matches.get(mid);
            int compare = FileSearchResult.compare(match, data);
            if (compare > 0) {
                max = mid - 1;
                continue;
            }
            min = mid + 1;
        }
        return min;
    }

    private static int compare(Match match1, Match match2) {
        int diff = match2.getOffset() - match1.getOffset();
        if (diff != 0) {
            return diff;
        }
        return match2.getLength() - match1.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            this.doRemoveAll();
        }
    }

    private void doRemoveAll() {
        this.fElementsToMatches.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatch(Match match) {
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            this.doRemoveMatch(match);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatches(Match[] matches) {
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            Match[] matchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                this.doRemoveMatch(match);
                ++n2;
            }
        }
    }

    private boolean doRemoveMatch(Match match) {
        boolean existed = false;
        List<Match> matches = this.fElementsToMatches.get(match.getElement());
        if (matches != null) {
            existed = matches.remove(match);
            if (matches.isEmpty()) {
                this.fElementsToMatches.remove(match.getElement());
            }
        }
        return existed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMatchCount() {
        int count = 0;
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            for (List<Match> element : this.fElementsToMatches.values()) {
                if (element == null) continue;
                count += element.size();
            }
        }
        return count;
    }

    public int getMatchCount(Object element) {
        List<Match> matches = this.fElementsToMatches.get(element);
        if (matches != null) {
            return matches.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getElements() {
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            return this.fElementsToMatches.keySet().toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Match[] getMatches(Object element) {
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            List<Match> matches = this.fElementsToMatches.get(element);
            if (matches != null) {
                return matches.toArray(new Match[matches.size()]);
            }
            return EMPTY_ARRAY;
        }
    }
}

