/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.search;

import com.bokesoft.yes.design.search.FileSearchResult;
import com.bokesoft.yes.design.search.FileTextSearchScope;
import com.bokesoft.yes.design.search.PatternConstructor;
import com.bokesoft.yes.design.search.TextSearchEngine;
import com.bokesoft.yes.design.search.TextSearchRequestor;
import com.bokesoft.yes.design.search.text.FileMatch;
import com.bokesoft.yes.design.search.text.FileMatchResource;
import com.bokesoft.yes.design.search.text.LineElement;
import com.bokesoft.yes.design.search.text.Match;
import com.bokesoft.yes.design.search.text.TextSearchMatchAccess;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class FileSearchQuery {
    private final String fSearchText;
    private final boolean fIsRegEx;
    private final boolean fIsCaseSensitive;
    private final boolean fIsWholeWord;
    private final String fFileTypes;
    private final FileTextSearchScope fScope;
    private FileSearchResult fResult;

    public FileSearchQuery(String searchText, boolean isRegEx, boolean isCaseSensitive, FileTextSearchScope scope) {
        this(searchText, isRegEx, isCaseSensitive, false, "", scope);
    }

    public FileSearchQuery(String searchText, boolean isRegEx, boolean isCaseSensitive, boolean isWholeWord, String fileTypes, FileTextSearchScope scope) {
        this.fSearchText = searchText;
        this.fIsRegEx = isRegEx;
        this.fIsCaseSensitive = isCaseSensitive;
        this.fIsWholeWord = isWholeWord;
        this.fFileTypes = fileTypes;
        this.fScope = scope;
    }

    public FileTextSearchScope getSearchScope() {
        return this.fScope;
    }

    public String getSearchString() {
        return this.fSearchText;
    }

    public boolean isRegexSearch() {
        return this.fIsRegEx;
    }

    public boolean isCaseSensitive() {
        return this.fIsCaseSensitive;
    }

    public boolean isWholeWord() {
        return this.fIsWholeWord;
    }

    public boolean isFileNameSearch() {
        return this.fSearchText.length() == 0;
    }

    public void run() {
        FileSearchResult textResult = this.getSearchResult();
        textResult.removeAll();
        Pattern searchPattern = this.getSearchPattern();
        TextSearchResultCollector collector = new TextSearchResultCollector(textResult, this.isFileNameSearch(), this.fFileTypes);
        TextSearchEngine.createDefault().search(collector, searchPattern);
    }

    protected Pattern getSearchPattern() {
        return PatternConstructor.createPattern(this.fSearchText, this.fIsRegEx, this.fIsCaseSensitive, this.fIsWholeWord);
    }

    public FileSearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new FileSearchResult();
        }
        return this.fResult;
    }

    private static final class TextSearchResultCollector
    extends TextSearchRequestor {
        private final FileSearchResult fResult;
        private final boolean fIsFileSearchOnly;
        private final String fileTypes;
        private int remainingResultQuota;
        private Map<FileMatchResource, ArrayList<FileMatch>> fCachedMatches;
        private Object fLock = new Object();

        private TextSearchResultCollector(FileSearchResult result, boolean isFileSearchOnly, String fTypes) {
            this.fResult = result;
            this.fIsFileSearchOnly = isFileSearchOnly;
            this.fileTypes = fTypes;
        }

        @Override
        public void beginReporting() {
            this.fCachedMatches = new HashMap<FileMatchResource, ArrayList<FileMatch>>();
            this.remainingResultQuota = 2000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endReporting() {
            this.flushMatches();
            Object object = this.fLock;
            synchronized (object) {
                this.fCachedMatches = null;
            }
        }

        @Override
        public boolean acceptFile(File file, File sfile) {
            if (!file.exists()) {
                return false;
            }
            if (!file.getName().endsWith(".xml")) {
                return false;
            }
            this.flushMatches();
            return true;
        }

        @Override
        public boolean acceptFileType(String type) {
            if (this.fileTypes == null || this.fileTypes.length() == 0) {
                return true;
            }
            return this.fileTypes.contains(type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) {
            ArrayList<FileMatch> matches;
            Object object = this.fLock;
            synchronized (object) {
                block12: {
                    block11: {
                        if (this.remainingResultQuota >= 0) break block11;
                        return false;
                    }
                    if (this.fCachedMatches != null) break block12;
                    return false;
                }
                matches = this.fCachedMatches.get(matchRequestor.getFile());
            }
            int matchOffset = matchRequestor.getMatchOffset();
            LineElement lineElement = this.getLineElement(matchOffset, matchRequestor, matches);
            if (lineElement != null) {
                FileMatch fileMatch = new FileMatch(matchRequestor.getFile(), matchOffset, matchRequestor.getMatchLength(), lineElement);
                Object object2 = this.fLock;
                synchronized (object2) {
                    block13: {
                        if (this.fCachedMatches != null) break block13;
                        return false;
                    }
                    matches = this.fCachedMatches.get(matchRequestor.getFile());
                    if (matches == null) {
                        matches = new ArrayList();
                        this.fCachedMatches.put(matchRequestor.getFile(), matches);
                    }
                    matches.add(fileMatch);
                    --this.remainingResultQuota;
                }
            }
            return true;
        }

        private LineElement getLineElement(int offset, TextSearchMatchAccess matchRequestor, ArrayList<FileMatch> matches) {
            int lineNumber = 1;
            int lineStart = 0;
            if (matches != null) {
                FileMatch last = matches.get(matches.size() - 1);
                LineElement lineElement = last.getLineElement();
                if (lineElement.contains(offset)) {
                    return lineElement;
                }
                lineStart = lineElement.getOffset() + lineElement.getLength();
                lineNumber = lineElement.getLine() + 1;
            }
            int i = lineStart;
            int contentLength = matchRequestor.getFileContentLength();
            while (i < contentLength) {
                char ch;
                if ((ch = matchRequestor.getFileContentChar(i++)) != '\n' && ch != '\r') continue;
                if (ch == '\r' && i < contentLength && matchRequestor.getFileContentChar(i) == '\n') {
                    ++i;
                }
                if (offset < i) {
                    String lineContent = TextSearchResultCollector.getContents(matchRequestor, lineStart, i);
                    return new LineElement(matchRequestor.getFile().getFile(), lineNumber, lineStart, lineContent);
                }
                ++lineNumber;
                lineStart = i;
            }
            if (offset < i) {
                String lineContent = TextSearchResultCollector.getContents(matchRequestor, lineStart, i);
                return new LineElement(matchRequestor.getFile().getFile(), lineNumber, lineStart, lineContent);
            }
            return null;
        }

        private static String getContents(TextSearchMatchAccess matchRequestor, int start, int end) {
            StringBuilder buf = new StringBuilder();
            int i = start;
            while (i < end) {
                char ch = matchRequestor.getFileContentChar(i);
                if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
                    buf.append(' ');
                } else {
                    buf.append(ch);
                }
                ++i;
            }
            return buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushMatches() {
            Object object = this.fLock;
            synchronized (object) {
                if (this.fCachedMatches != null && !this.fCachedMatches.isEmpty()) {
                    for (ArrayList<FileMatch> matches : this.fCachedMatches.values()) {
                        this.fResult.addMatches(matches.toArray(new Match[matches.size()]));
                    }
                    this.fCachedMatches.clear();
                }
            }
        }
    }
}

