/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.metaobjecttype;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.io.IOMetaObject;
import com.bokesoft.yes.design.io.loader.IODataObjectLoadable;
import com.bokesoft.yes.design.utils.WebDesignerDataTableUtil;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.ParameterSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaParameter;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaCheckListBox;
import com.bokesoft.yigo.meta.form.component.control.MetaComboBox;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

public class MetaQueryDefType
extends MetaObjectType
implements IODataObjectLoadable {
    private static final String NAME = "QueryDef";
    private static final String D_ComboBoxQueryDefHead = "D_ComboBoxQueryDefHead";
    private static final String ED_ParameterCollection = "ED_ParameterCollection";
    private static final String ED_New_FieldTable = "ED_New_FieldTable";

    public MetaQueryDefType() {
        super(NAME);
    }

    @Override
    public void mergeDiff(MetaForm metaForm, Diff diff, Document document) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        DataTable headTable = document.get(D_ComboBoxQueryDefHead);
        DataTable paraTable = document.get(ED_ParameterCollection);
        String componentKey = diff.getKey();
        MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());
        String tagName = metaComponent.getTagName();
        String xmlTreeKey = this.getXmlTreeKey(diff, tagName, componentKey);
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        parentNode.deleteChildByTagName(NAME);
        TagNode queryDef = new TagNode(NAME, null);
        if (headTable.size() > 0) {
            TagNode statement = new TagNode("Statement", null);
            statement.setCDataValue(headTable.getString(0, "Statement"));
            queryDef.addNode(statement);
            String dependField = headTable.getString(0, "ItemsDependency");
            parentNode.setAttribute("ItemsDependency", dependField);
            TagNode parameterCollection = new TagNode("ParameterCollection", null);
            int i = 0;
            while (i < paraTable.size()) {
                String dataType = paraTable.getString(i, "DataType");
                String sourceType = paraTable.getString(i, "SourceType");
                String description = paraTable.getString(i, "Description");
                String value = paraTable.getString(i, "Value");
                TagNode parameter = new TagNode("Parameter", null);
                parameter.setAttribute("DataType", dataType);
                if (!"Formula".equals(sourceType)) {
                    parameter.setAttribute("SourceType", sourceType);
                }
                parameter.setAttribute("Description", description);
                parameter.setAttribute("Value", value);
                parameterCollection.addNode(parameter);
                ++i;
            }
            queryDef.addNode(parameterCollection);
        }
        parentNode.addNode(queryDef);
        this.genXmlDiff(xmlTree, parentNode, diff, true);
    }

    @Override
    public Document load(Document document, DefaultContext context, MetaDataObject metaDataObject) throws Throwable {
        String ownerFormKey = (String)context.getPara("OwnerFormKey");
        String fieldKey = (String)context.getPara("compKey");
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(ownerFormKey);
        MetaForm containerForm = this.getContainerForm(context);
        metaForm = IOMetaObject.isThisForm(metaForm, containerForm, fieldKey);
        MetaComponent componentByKey = IOMetaObject.getComponentByKey(metaForm, fieldKey);
        this.loadD_ComboBoxQueryDefHead(document, metaDataObject, (AbstractMetaObject)componentByKey);
        this.loadED_ParameterCollection(document, metaDataObject, (AbstractMetaObject)componentByKey);
        document.add(ED_New_FieldTable, WebDesignerDataTableUtil.generateDataTable(metaDataObject.getTable(ED_New_FieldTable)));
        return document;
    }

    private void loadD_ComboBoxQueryDefHead(Document document, MetaDataObject metaDataObject, AbstractMetaObject comboBox) {
        MetaTable metaTable = metaDataObject.getTable(D_ComboBoxQueryDefHead);
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);
        dataTable.clear();
        dataTable.append();
        dataTable.setString(0, "ItemsDependency", this.getItemsDependency(comboBox));
        MetaQueryDef queryDef = this.getQueryDef(comboBox);
        if (queryDef != null) {
            dataTable.setString(0, "Statement", queryDef.getStatement().getContent());
        }
        document.add(D_ComboBoxQueryDefHead, dataTable);
    }

    private void loadED_ParameterCollection(Document document, MetaDataObject metaDataObject, AbstractMetaObject comboBox) {
        MetaTable metaTable = metaDataObject.getTable(ED_ParameterCollection);
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);
        dataTable.clear();
        MetaQueryDef queryDef = this.getQueryDef(comboBox);
        if (queryDef != null && queryDef.getParameterCollection() != null) {
            MetaParameterCollection parameterCollection = queryDef.getParameterCollection();
            int i = 0;
            while (i < parameterCollection.size()) {
                MetaParameter parameter = (MetaParameter)parameterCollection.get(i);
                int append = dataTable.append();
                dataTable.setString(append, "DataType", DataType.toString((Integer)parameter.getDataType()));
                dataTable.setString(append, "SourceType", ParameterSourceType.format((Integer)parameter.getSourceType()));
                dataTable.setString(append, "Description", parameter.getDescription());
                dataTable.setString(append, "Value", parameter.getValue());
                ++i;
            }
        }
        document.add(ED_ParameterCollection, dataTable);
    }

    private MetaForm getContainerForm(DefaultContext ctx) throws Throwable {
        String containerKey = (String)ctx.getPara("ContainerKey");
        if (containerKey != null && !containerKey.isEmpty()) {
            return MetaFactory.getGlobalInstance().getMetaForm(containerKey);
        }
        return null;
    }

    private String getItemsDependency(AbstractMetaObject component) {
        if (component instanceof MetaComboBox) {
            return ((MetaComboBox)component).getItemsDependency();
        }
        if (component instanceof MetaCheckListBox) {
            return ((MetaCheckListBox)component).getItemsDependency();
        }
        return null;
    }

    private MetaQueryDef getQueryDef(AbstractMetaObject component) {
        if (component instanceof MetaComboBox) {
            return ((MetaComboBox)component).getQueryDef();
        }
        if (component instanceof MetaCheckListBox) {
            return ((MetaCheckListBox)component).getQueryDef();
        }
        return null;
    }
}

