/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.mergesingle.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.NewFormCmd;
import com.bokesoft.yes.design.mergesingle.impl.SingleSettingImpl;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormLoad;
import com.bokesoft.yes.util.ERPStringUtil;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.FormVerb;
import com.bokesoft.yigo.common.def.ScriptRange;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaQuery;
import com.bokesoft.yigo.meta.common.MetaQueryCollection;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.common.MetaScriptCollection;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormToolOperUtil
extends SingleSettingImpl {
    private static final Logger log = LoggerFactory.getLogger(FormToolOperUtil.class);

    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        DataTable collecTable = document.get("ED_OperationToolbarDetail");
        DataTable fieldTable = document.get("ED_Operations");
        DataTable macroDetail = document.get("ED_MacroFormula");
        DataTable spcritList = document.get("ED_ScriptList");
        DataTable queryStatement = document.get("ED_QueryStatement");
        DataTable parameterCollection = document.get("ED_QueryParameterCollection");
        DataTable queryCollection = document.get("ED_QueryCollection");
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        FormToolOperUtil.dealOperationToobar(xmlTree, collecTable, fieldTable, macroDetail, spcritList, queryStatement, parameterCollection, queryCollection, diff);
        TagNode ptagNode = diff.getXmlTree().xmlTree.getRoot();
        this.setTagNode(ptagNode);
    }

    private static void processOperationRef(MetaForm metaForm, KeyPairCompositeObject metaItem) throws Throwable {
        if (metaForm == null || metaItem == null) {
            return;
        }
        int objectType = metaItem.getObjectType();
        if (objectType == 0) {
            MetaOperation metaOperation = (MetaOperation)metaItem;
            String refKey = metaOperation.getRefKey();
            if (refKey == null || refKey.isEmpty()) {
                return;
            }
            String oldEnable = metaOperation.getEnable();
            String caption = metaOperation.getCaption();
            MetaBaseScript action = metaOperation.getAction();
            String oldEnableDependency = metaOperation.getEnableDependency();
            String oldVisible = metaOperation.getVisible();
            String oldVisibleDependency = metaOperation.getVisibleDependency();
            MetaUtil.processOperationRefKey((IMetaFactory)MetaFactory.getGlobalInstance(), (MetaForm)metaForm, (MetaOperation)metaOperation);
            if (!ERPStringUtil.isBlankOrNull((Object)oldEnable)) {
                metaOperation.setEnable(oldEnable);
            }
            if (!ERPStringUtil.isBlankOrNull((Object)caption)) {
                metaOperation.setCaption(caption);
            }
            if (!ERPStringUtil.isBlankOrNull((Object)action)) {
                metaOperation.setAction(action);
            }
            if (!ERPStringUtil.isBlankOrNull((Object)oldEnableDependency)) {
                metaOperation.setEnableDependency(oldEnableDependency);
            }
            if (!ERPStringUtil.isBlankOrNull((Object)oldVisible)) {
                metaOperation.setVisible(oldVisible);
            }
            if (!ERPStringUtil.isBlankOrNull((Object)oldVisibleDependency)) {
                metaOperation.setVisibleDependency(oldVisibleDependency);
            }
        } else if (objectType == 1) {
            MetaOperationCollection metaOperationCollection = (MetaOperationCollection)metaItem;
            for (KeyPairCompositeObject subMetaItem : metaOperationCollection) {
                FormToolOperUtil.processOperationRef(metaForm, subMetaItem);
            }
        }
    }

    public static void dealOperationToobar(XmlTreeWithPath xmlTree, DataTable collecTable, DataTable fieldTable, DataTable marcoTable, DataTable scriptList, DataTable queryStatement, DataTable parameterCollection, DataTable queryCollection, Diff diff) throws Throwable {
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        boolean vestFlag = false;
        boolean specVestFlag = false;
        MetaOperationCollection operationCollection = null;
        HashMap<String, KeyPairCompositeObject> operationCollectionMap = new HashMap<String, KeyPairCompositeObject>();
        MetaOperationCollection operationCollectionSrc = null;
        HashMap<String, KeyPairCompositeObject> operationCollectionSrcMap = new HashMap<String, KeyPairCompositeObject>();
        MetaMacroCollection macroCollection = null;
        MetaScriptCollection metaScriptCollection = null;
        MetaQueryCollection metaQueryCollection = null;
        Map<String, String> attributes = rootNode.getAttributes();
        String extend = attributes.get("Extend");
        String formKey = attributes.get("Key");
        vestFlag = StringUtils.isNotBlank((CharSequence)extend);
        specVestFlag = StringUtils.equalsAnyIgnoreCase((CharSequence)attributes.get("MergeToSource"), (CharSequence[])new CharSequence[]{"1", "true"});
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaForm metaForm = null;
        if (formKey != null) {
            metaForm = NewFormCmd.loadMetaForm(formKey);
            operationCollection = metaForm.getOperationCollection();
            macroCollection = metaForm.getMacroCollection();
            metaScriptCollection = metaForm.getScriptCollection();
            metaQueryCollection = metaForm.getQueryCollection();
        }
        MetaScriptCollection metaScriptCollectionSrc = new MetaScriptCollection();
        MetaQueryCollection metaQueryCollectionSrc = new MetaQueryCollection();
        MetaMacroCollection macroCollectionSrc = new MetaMacroCollection();
        if (vestFlag) {
            MetaForm metaFormSrc = metaFactory.getMetaForm(extend);
            operationCollectionSrc = metaFormSrc.getOperationCollection();
            macroCollectionSrc = metaFormSrc.getMacroCollection();
            metaQueryCollectionSrc = metaFormSrc.getQueryCollection();
            metaScriptCollectionSrc = metaFormSrc.getScriptCollection();
            if (specVestFlag) {
                String extendFilePath = StringUtils.isNotBlank((CharSequence)diff.getVestXmlTree().tmpFilePath) ? diff.getVestXmlTree().tmpFilePath : diff.getVestXmlTree().orgFilePath;
                MetaFormLoad extendFormLoad = new MetaFormLoad(2);
                extendFormLoad.load((InputStream)FileUtils.openInputStream((File)new File(extendFilePath)));
                MetaForm extendMetaForm = (MetaForm)extendFormLoad.getRootMetaObject();
                extendMetaForm.setProject(metaFormSrc.getProject());
                FormToolOperUtil.processOperationRef(extendMetaForm, (KeyPairCompositeObject)extendMetaForm.getOperationCollection());
                operationCollectionSrc = extendMetaForm.getOperationCollection();
                if (operationCollection != null) {
                    operationCollection.merge(operationCollectionSrc);
                    FormToolOperUtil.processOperationRef(metaForm, (KeyPairCompositeObject)operationCollection);
                }
                macroCollectionSrc = extendMetaForm.getMacroCollection();
                if (macroCollection != null && macroCollectionSrc != null) {
                    for (MetaMacro metaMacro : macroCollectionSrc) {
                        if (macroCollection.containsKey(metaMacro.getKey())) {
                            ((MetaMacro)macroCollection.get(metaMacro.getKey())).merge(metaMacro);
                            continue;
                        }
                        macroCollection.add((KeyPairMetaObject)metaMacro);
                    }
                }
                metaScriptCollectionSrc = extendMetaForm.getScriptCollection();
                if (metaScriptCollection != null && metaScriptCollectionSrc != null) {
                    for (MetaScript metaScript : metaScriptCollectionSrc) {
                        if (metaScriptCollection.containsKey(metaScript.getKey())) {
                            ((MetaScript)metaScriptCollection.get(metaScript.getKey())).merge((MetaBaseScript)metaScript);
                            continue;
                        }
                        metaScriptCollection.add((KeyPairMetaObject)metaScript);
                    }
                }
                metaQueryCollectionSrc = extendMetaForm.getQueryCollection();
                if (metaQueryCollection != null && metaQueryCollectionSrc != null) {
                    for (MetaQuery metaQuery : metaQueryCollectionSrc) {
                        if (metaQueryCollection.containsKey(metaQuery.getKey())) {
                            ((MetaQuery)metaQueryCollection.get(metaQuery.getKey())).merge(metaQuery);
                            continue;
                        }
                        metaQueryCollection.add((KeyPairMetaObject)metaQuery);
                    }
                }
            }
        }
        FormToolOperUtil.getOperation(operationCollectionSrc, operationCollectionSrcMap);
        FormToolOperUtil.getOperation(operationCollection, operationCollectionMap);
        FormToolOperUtil.dealOperationCollection(collecTable, fieldTable, rootNode, vestFlag, specVestFlag, operationCollectionMap, operationCollectionSrcMap);
        FormToolOperUtil.dealMacroCollection(marcoTable, rootNode, vestFlag, macroCollectionSrc);
        FormToolOperUtil.dealScriptNode(scriptList, rootNode, vestFlag, metaScriptCollectionSrc);
        FormToolOperUtil.dealParameterCollection(queryCollection, rootNode, queryStatement, parameterCollection, vestFlag, metaQueryCollectionSrc);
    }

    public static void dealParameterCollection(DataTable queryCollection, TagNode rootNode, DataTable statementDataTable, DataTable parameterDataTable, boolean vestFlag, MetaQueryCollection parentCollectionSrc) throws Throwable {
        if (queryCollection.size() < 1) {
            rootNode.deleteChildByTagName("QueryCollection");
            return;
        }
        TagNode queryNode = rootNode.findFirstTagNodeByTagName("QueryCollection");
        if (Objects.isNull(queryNode)) {
            queryNode = new TagNode("QueryCollection", null);
            rootNode.addNode(queryNode, 4);
        } else {
            queryNode.deleteChildByTagName("Query");
        }
        queryCollection.setShowDeleted(true);
        int j = 0;
        while (j < queryCollection.size()) {
            String dataSourceType = queryCollection.getString(j, "DataSourceType");
            if (dataSourceType.isEmpty() || dataSourceType.equalsIgnoreCase("xml")) {
                String keyDetail;
                int state = queryCollection.getState(j);
                if (state == 3) {
                    keyDetail = queryCollection.getString(j, "Key");
                    queryNode.deleteChildByTagKey(keyDetail);
                } else {
                    keyDetail = queryCollection.getString(j, "Key");
                    String queryDescription = queryCollection.getString(j, "Query");
                    Long queryOid = queryCollection.getLong(j, "OID");
                    MetaQuery metaQuery = null;
                    if (parentCollectionSrc != null) {
                        metaQuery = (MetaQuery)parentCollectionSrc.get(keyDetail);
                    }
                    TagNode query = new TagNode("Query", null);
                    queryNode.addNode(query);
                    query.setAttribute("Key", keyDetail);
                    if (!statementDataTable.isEmpty()) {
                        int i = 0;
                        while (i < statementDataTable.size()) {
                            if (statementDataTable.getLong(i, "POID").equals(queryOid)) {
                                TagNode Statement = new TagNode("Statement", null);
                                Statement.setAttribute("DBType", StringUtils.trim((String)statementDataTable.getString(i, "DBType")));
                                String contextText = StringUtils.trim((String)statementDataTable.getString(i, "Context"));
                                if (StringUtils.isNotEmpty((CharSequence)contextText)) {
                                    CDataNode cNode = new CDataNode(contextText, null);
                                    Statement.addNode(cNode);
                                    query.addNode(Statement);
                                }
                            }
                            ++i;
                        }
                    }
                    if (!parameterDataTable.isEmpty()) {
                        TagNode parameterCollection = new TagNode("ParameterCollection", null);
                        int a = 0;
                        while (a < parameterDataTable.size()) {
                            if (parameterDataTable.getLong(a, "POID").equals(queryOid)) {
                                TagNode parameter = new TagNode("Parameter", null);
                                if (StringUtils.isNotEmpty((CharSequence)parameterDataTable.getString(a, "Parameter"))) {
                                    String type = DataType.toString((Integer)Integer.parseInt(parameterDataTable.getString(a, "Parameter")));
                                    parameter.setAttribute("DataType", type);
                                    parameterCollection.addNode(parameter);
                                }
                            }
                            ++a;
                        }
                        query.addNode(parameterCollection);
                    }
                    if (!vestFlag || metaQuery == null) {
                        query.setAttribute("Description", queryDescription);
                    } else if (StringUtils.isNotEmpty((CharSequence)queryDescription) && !StringUtils.equals((CharSequence)metaQuery.getDescription(), (CharSequence)queryDescription)) {
                        query.setAttribute("Description", queryDescription);
                    }
                }
            }
            ++j;
        }
    }

    public static void dealScriptNode(DataTable scriptList, TagNode rootNode, boolean vestFlag, MetaScriptCollection parentCollectionSrc) throws Throwable {
        if (scriptList.size() < 1) {
            rootNode.deleteChildByTagName("ScriptCollection");
            return;
        }
        TagNode scriptNode = rootNode.findFirstTagNodeByTagName("ScriptCollection");
        if (Objects.isNull(scriptNode)) {
            scriptNode = new TagNode("ScriptCollection", null);
            rootNode.addNode(scriptNode, 4);
        } else {
            scriptNode.deleteChildByTagName("Script");
        }
        scriptList.setShowDeleted(true);
        int j = 0;
        while (j < scriptList.size()) {
            String dataSourceType = scriptList.getString(j, "DataSourceType");
            if (dataSourceType.isEmpty() || dataSourceType.equalsIgnoreCase("xml")) {
                String keyDetail;
                int state = scriptList.getState(j);
                if (state == 3) {
                    keyDetail = scriptList.getString(j, "Key");
                    scriptNode.deleteChildByTagKey(keyDetail);
                } else {
                    CDataNode cNode;
                    TagNode script;
                    keyDetail = scriptList.getString(j, "Key");
                    String scriptCaption = scriptList.getString(j, "Caption");
                    String scriptRange = scriptList.getString(j, "Range");
                    String scriptVerb = scriptList.getString(j, "Verb");
                    String spcritDetail = scriptList.getString(j, "ScriptDetail");
                    String scriptDescription = scriptList.getString(j, "Description");
                    MetaScript metaScript = null;
                    if (parentCollectionSrc != null) {
                        metaScript = (MetaScript)parentCollectionSrc.get(keyDetail);
                    }
                    if (!vestFlag || metaScript == null) {
                        script = new TagNode("Script", null);
                        script.setAttribute("Key", keyDetail);
                        if (StringUtils.isNotEmpty((CharSequence)scriptCaption)) {
                            script.setAttribute("Caption", scriptCaption);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)scriptRange)) {
                            script.setAttribute("Range", scriptRange);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)scriptVerb)) {
                            script.setAttribute("Verb", scriptVerb);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)scriptDescription)) {
                            script.setAttribute("Description", scriptDescription);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)spcritDetail)) {
                            cNode = new CDataNode(spcritDetail, null);
                            script.addNode(cNode);
                        }
                        scriptNode.addNode(script);
                    } else {
                        script = new TagNode("Script", null);
                        scriptNode.addNode(script);
                        script.setAttribute("Key", keyDetail);
                        if (StringUtils.isNotEmpty((CharSequence)scriptCaption) && !StringUtils.equals((CharSequence)metaScript.getCaption(), (CharSequence)scriptCaption)) {
                            script.setAttribute("Caption", scriptCaption);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)spcritDetail) && !StringUtils.equals((CharSequence)metaScript.getContent(), (CharSequence)spcritDetail)) {
                            cNode = new CDataNode(spcritDetail, null);
                            script.addNode(cNode);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)scriptRange) && !StringUtils.equals((CharSequence)ScriptRange.toString((Integer)metaScript.getRange()), (CharSequence)scriptRange)) {
                            script.setAttribute("Range", scriptRange);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)scriptVerb) && !StringUtils.equals((CharSequence)FormVerb.toString((Integer)metaScript.getVerb()), (CharSequence)scriptVerb)) {
                            script.setAttribute("Verb", scriptVerb);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)scriptDescription) && !StringUtils.equals((CharSequence)metaScript.getDescription(), (CharSequence)scriptDescription)) {
                            script.setAttribute("Description", scriptDescription);
                        }
                    }
                }
            }
            ++j;
        }
    }

    public static void getOperation(MetaOperationCollection operationCollectionSrc, HashMap<String, KeyPairCompositeObject> operationCollectionMap) {
        if (operationCollectionSrc != null) {
            for (KeyPairCompositeObject keyPairCompositeObject : operationCollectionSrc) {
                operationCollectionMap.put(keyPairCompositeObject.getKey(), keyPairCompositeObject);
                if (!(keyPairCompositeObject instanceof MetaOperationCollection)) continue;
                MetaOperationCollection keyPairC = (MetaOperationCollection)keyPairCompositeObject;
                FormToolOperUtil.getOperation(keyPairC, operationCollectionMap);
            }
        }
    }

    public static void dealOperationCollection(DataTable collecTable, DataTable fieldTable, TagNode rootNode, boolean vestFlag, boolean specVestFlag, HashMap<String, KeyPairCompositeObject> operationCollectionMap, HashMap<String, KeyPairCompositeObject> operationCollectionSrcMap) throws Throwable {
        TagNode parentNode;
        List<TagNode> operationCollectionNodeList = rootNode.findNodesByTagName("OperationCollection");
        if (CollectionUtils.isNotEmpty(operationCollectionNodeList)) {
            parentNode = operationCollectionNodeList.get(0);
        } else {
            parentNode = new TagNode("OperationCollection", null);
            rootNode.addNode(parentNode, 2);
        }
        parentNode.getParent().deleteChildByTagName("OperationCollection");
        TagNode operationCollectionNode = new TagNode("OperationCollection", null);
        rootNode.addNode(operationCollectionNode, 2);
        collecTable.setShowDeleted(true);
        fieldTable.setShowDeleted(true);
        int i = 0;
        while (i < collecTable.size()) {
            int rowState = collecTable.getState(i);
            String dataSourceType = collecTable.getString(i, "DataSourceType");
            if ((dataSourceType.isEmpty() || dataSourceType.equalsIgnoreCase("xml")) && 3 != rowState) {
                Long oid = collecTable.getLong(i, "OID");
                fieldTable.setFilter("POID==" + oid);
                fieldTable.filter();
                String tableMark = collecTable.getString(i, "TableMark");
                if (vestFlag) {
                    boolean extendFlag;
                    KeyPairCompositeObject compositeObjectSrc = operationCollectionSrcMap.get(tableMark);
                    if (Objects.isNull(compositeObjectSrc) && !specVestFlag) {
                        throw new RuntimeException("\u754c\u9762\u9a6c\u7532\u4e0d\u80fd\u6dfb\u52a0\u754c\u9762\u64cd\u4f5c\uff01");
                    }
                    boolean bl = extendFlag = !Objects.isNull(compositeObjectSrc);
                    if (extendFlag) {
                        String tableType = collecTable.getString(i, "TableType");
                        if (!StringUtils.equals((CharSequence)tableType, (CharSequence)"1")) {
                            MetaOperation metaOperationSrc = (MetaOperation)compositeObjectSrc;
                            TagNode tagNode = FormToolOperUtil.toExtendOperationNode(collecTable, i, metaOperationSrc);
                            operationCollectionNode.addNode(tagNode);
                        } else {
                            MetaOperationCollection metaOperationCollectionSrc = (MetaOperationCollection)compositeObjectSrc;
                            TagNode tagNode = FormToolOperUtil.toExtendOperationNode(collecTable, i, metaOperationCollectionSrc);
                            operationCollectionNode.addNode(tagNode);
                            int j = 0;
                            while (j < fieldTable.size()) {
                                if (fieldTable.getState(j) != 3) {
                                    String subTableMark = fieldTable.getString(j, "TableMark");
                                    KeyPairCompositeObject subCompositeObjectSrc = operationCollectionSrcMap.get(subTableMark);
                                    KeyPairCompositeObject subCompositeObject = operationCollectionMap.get(subTableMark);
                                    if (Objects.isNull(subCompositeObjectSrc) && !specVestFlag) {
                                        throw new RuntimeException("\u754c\u9762\u9a6c\u7532\u4e0d\u80fd\u6dfb\u52a0\u754c\u9762\u64cd\u4f5c\uff01");
                                    }
                                    if (Objects.nonNull(subCompositeObject)) {
                                        MetaOperation subMetaOperation = (MetaOperation)subCompositeObject;
                                        MetaOperation metaOperationCollectionSrcSub = (MetaOperation)subCompositeObjectSrc;
                                        TagNode tagNode1 = FormToolOperUtil.toExtendOperationDetailNode(fieldTable, j, subMetaOperation, metaOperationCollectionSrcSub);
                                        tagNode.addNode(tagNode1);
                                    } else {
                                        TagNode tagNode1 = FormToolOperUtil.toOperationDetailNode(fieldTable, j, vestFlag);
                                        tagNode.addNode(tagNode1);
                                    }
                                }
                                ++j;
                            }
                        }
                    } else {
                        TagNode tagNode;
                        String tableType = collecTable.getString(i, "TableType");
                        if ("1".equals(tableType)) {
                            tagNode = FormToolOperUtil.toOperationNode(collecTable, i, vestFlag);
                            operationCollectionNode.addNode(tagNode);
                            int j = 0;
                            while (j < fieldTable.size()) {
                                if (3 != fieldTable.getState(j)) {
                                    TagNode tagNode1 = FormToolOperUtil.toOperationDetailNode(fieldTable, j, vestFlag);
                                    tagNode.addNode(tagNode1);
                                }
                                ++j;
                            }
                        } else {
                            tagNode = FormToolOperUtil.toOperationNode(collecTable, i, vestFlag);
                            String refKey = tagNode.getAttributes().get("RefKey");
                            String Key = tagNode.getAttributes().get("Key");
                            String Caption = tagNode.getAttributes().get("Caption");
                            if (StringUtils.isNotEmpty((CharSequence)refKey)) {
                                tagNode = new TagNode(tagNode.getTagName(), null);
                                tagNode.setAttribute("Key", Key);
                                tagNode.setAttribute("Caption", Caption);
                                tagNode.setAttribute("RefKey", refKey);
                                operationCollectionNode.addNode(tagNode);
                            } else {
                                operationCollectionNode.addNode(tagNode);
                            }
                        }
                    }
                } else {
                    String tableType = collecTable.getString(i, "TableType");
                    if ("1".equals(tableType)) {
                        TagNode tagNode = FormToolOperUtil.toOperationNode(collecTable, i, vestFlag);
                        operationCollectionNode.addNode(tagNode);
                        int j = 0;
                        while (j < fieldTable.size()) {
                            if (3 != fieldTable.getState(j)) {
                                TagNode tagNode1 = FormToolOperUtil.toOperationDetailNode(fieldTable, j, vestFlag);
                                tagNode.addNode(tagNode1);
                            }
                            ++j;
                        }
                    } else {
                        TagNode tagNode = FormToolOperUtil.toOperationNode(collecTable, i, vestFlag);
                        String refKey = tagNode.getAttributes().get("RefKey");
                        String Key = tagNode.getAttributes().get("Key");
                        String Caption = tagNode.getAttributes().get("Caption");
                        if (StringUtils.isNotEmpty((CharSequence)refKey)) {
                            tagNode = new TagNode(tagNode.getTagName(), null);
                            tagNode.setAttribute("Key", Key);
                            tagNode.setAttribute("Caption", Caption);
                            tagNode.setAttribute("RefKey", refKey);
                            operationCollectionNode.addNode(tagNode);
                        } else {
                            operationCollectionNode.addNode(tagNode);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public static void dealMacroCollection(DataTable marcoTable, TagNode rootNode, boolean vestFlag, MetaMacroCollection parentMacroCollectionSrc) throws Throwable {
        if (marcoTable.isEmpty()) {
            rootNode.deleteChildByTagName("MacroCollection");
            return;
        }
        TagNode macroCollection = rootNode.findFirstTagNodeByTagName("MacroCollection");
        if (Objects.nonNull(macroCollection)) {
            macroCollection.deleteChildByTagName("Macro");
        } else {
            macroCollection = new TagNode("MacroCollection", null);
            rootNode.addNode(macroCollection);
        }
        marcoTable.setShowDeleted(true);
        int j = 0;
        while (j < marcoTable.size()) {
            int state = marcoTable.getState(j);
            String dataSourceType = marcoTable.getString(j, "DataSourceType");
            if (dataSourceType.isEmpty() || dataSourceType.equalsIgnoreCase("xml")) {
                String keyDetail;
                if (state == 3) {
                    keyDetail = marcoTable.getString(j, "Key");
                    macroCollection.deleteChildByTagKey(keyDetail);
                } else {
                    CDataNode cNode;
                    TagNode macro;
                    keyDetail = marcoTable.getString(j, "Key");
                    String argsDetail = marcoTable.getString(j, "Args");
                    String formulaDetail = marcoTable.getString(j, "Formula");
                    MetaMacro metaMacroSrc = null;
                    if (parentMacroCollectionSrc != null) {
                        metaMacroSrc = (MetaMacro)parentMacroCollectionSrc.get(keyDetail);
                    }
                    if (!vestFlag || metaMacroSrc == null) {
                        macro = new TagNode("Macro", null);
                        macroCollection.addNode(macro);
                        macro.setAttribute("Key", keyDetail);
                        if (StringUtils.isNotEmpty((CharSequence)argsDetail)) {
                            macro.setAttribute("Args", argsDetail);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)formulaDetail)) {
                            cNode = new CDataNode(formulaDetail, null);
                            macro.addNode(cNode);
                        }
                    } else {
                        macro = new TagNode("Macro", null);
                        macroCollection.addNode(macro);
                        macro.setAttribute("Key", keyDetail);
                        if (StringUtils.isNotEmpty((CharSequence)argsDetail) && !StringUtils.equals((CharSequence)metaMacroSrc.getArgs(), (CharSequence)argsDetail)) {
                            macro.setAttribute("Args", argsDetail);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)formulaDetail) && !StringUtils.equals((CharSequence)metaMacroSrc.getContent(), (CharSequence)formulaDetail)) {
                            cNode = new CDataNode(formulaDetail, null);
                            macro.addNode(cNode);
                        }
                    }
                }
            }
            ++j;
        }
    }

    private static TagNode toOperationNode(DataTable collecTable, int i, boolean vestFlag) {
        String tableType = collecTable.getString(i, "TableType");
        String tagName = StringUtils.equals((CharSequence)tableType, (CharSequence)"1") ? "OperationCollection" : "Operation";
        TagNode tagNode = new TagNode(tagName, null);
        String tableMark = collecTable.getString(i, "TableMark");
        String tableCaption = collecTable.getString(i, "TableCaption");
        String tableEnable = collecTable.getString(i, "TableEnable");
        String tableVisible = collecTable.getString(i, "TableVisible");
        String tableRefKey = collecTable.getString(i, "TableRefKey");
        String EnableDependency = collecTable.getString(i, "EnableDependency");
        String VisibleDependency = collecTable.getString(i, "VisibleDependency");
        String tableTag = collecTable.getString(i, "TableTag");
        String tableAction = collecTable.getString(i, "TableAction");
        String shortCuts = collecTable.getString(i, "ShortCuts");
        String needAccessLog = collecTable.getString(i, "NeedAccessLog");
        String activity = collecTable.getString(i, "GetActivity");
        String tCode = collecTable.getString(i, "GetTCode");
        String expand = collecTable.getString(i, "Expand");
        String expandSource = collecTable.getString(i, "ExpandSource");
        String selfDisable = collecTable.getString(i, "SelfDisable");
        String isTransfer = collecTable.getString(i, "IsTransfer");
        tagNode.setAttribute("Key", tableMark);
        if (!StringUtils.isEmpty((CharSequence)tableCaption)) {
            tagNode.setAttribute("Caption", tableCaption);
        }
        if (!StringUtils.isEmpty((CharSequence)shortCuts)) {
            tagNode.setAttribute("ShortCuts", shortCuts);
        }
        if (!StringUtils.isEmpty((CharSequence)tableEnable)) {
            tagNode.setAttribute("Enable", tableEnable);
        }
        if (!StringUtils.isEmpty((CharSequence)tableVisible)) {
            tagNode.setAttribute("Visible", tableVisible);
        }
        if (!StringUtils.isEmpty((CharSequence)tableRefKey)) {
            tagNode.setAttribute("RefKey", tableRefKey);
        }
        if (!StringUtils.isEmpty((CharSequence)tableTag)) {
            tagNode.setAttribute("Tag", tableTag);
        }
        if (!StringUtils.isEmpty((CharSequence)EnableDependency)) {
            tagNode.setAttribute("EnableDependency", EnableDependency);
        }
        if (!StringUtils.isEmpty((CharSequence)VisibleDependency)) {
            tagNode.setAttribute("VisibleDependency", VisibleDependency);
        }
        if (!StringUtils.isEmpty((CharSequence)needAccessLog)) {
            tagNode.setAttribute("NeedAccessLog", needAccessLog);
        }
        if (!StringUtils.isEmpty((CharSequence)activity)) {
            tagNode.setAttribute("Activity", activity);
        }
        if (!StringUtils.isEmpty((CharSequence)tCode)) {
            tagNode.setAttribute("TCode", tCode);
        }
        if (!StringUtils.isEmpty((CharSequence)expandSource)) {
            tagNode.setAttribute("ExpandSource", expandSource);
        }
        if (!StringUtils.isEmpty((CharSequence)expand)) {
            tagNode.setAttribute("Expand", expand);
        }
        if (!StringUtils.isEmpty((CharSequence)selfDisable)) {
            tagNode.setAttribute("SelfDisable", selfDisable);
        }
        if (!StringUtils.isEmpty((CharSequence)tableAction)) {
            TagNode action = new TagNode("Action", null);
            CDataNode cDataNode = new CDataNode(tableAction, null);
            action.addNode(cDataNode);
            tagNode.addNode(action);
        }
        tagNode.setAttribute("IsTransfer", isTransfer);
        if (vestFlag) {
            Integer TC_IsFirst = collecTable.getInt(i, "TC_IsFirst");
            Integer TC_IsLast = collecTable.getInt(i, "TC_IsLast");
            boolean TC_IsFirstorTC_IsFirst = false;
            if (TC_IsFirst == 1) {
                tagNode.setAttribute("First", String.valueOf(true));
                TC_IsFirstorTC_IsFirst = true;
            }
            if (TC_IsLast == 1) {
                tagNode.setAttribute("Last", String.valueOf(true));
                TC_IsFirstorTC_IsFirst = true;
            }
            if (!TC_IsFirstorTC_IsFirst) {
                if (i + 1 < collecTable.size()) {
                    String key = collecTable.getString(i + 1, "TableMark");
                    tagNode.setAttribute("SideKey", key);
                    tagNode.setAttribute("InsertAfter", "false");
                } else if (i == collecTable.size() - 1) {
                    String key = collecTable.getString(i - 1, "TableMark");
                    tagNode.setAttribute("SideKey", key);
                    tagNode.setAttribute("InsertAfter", "true");
                }
            }
        }
        return tagNode;
    }

    private static TagNode toExtendOperationNode(DataTable collecTable, int i, MetaOperation metaOperationSrc) {
        TagNode tagNode = new TagNode("Operation", null);
        String tableMark = collecTable.getString(i, "TableMark");
        tagNode.setAttribute("Key", tableMark);
        String tableCaption = collecTable.getString(i, "TableCaption");
        if (!StringUtils.equals((CharSequence)tableCaption, (CharSequence)metaOperationSrc.getCaption())) {
            tagNode.setAttribute("Caption", tableCaption);
        }
        String tableVisible = collecTable.getString(i, "TableVisible");
        if (!StringUtils.equals((CharSequence)metaOperationSrc.getVisible(), (CharSequence)tableVisible)) {
            tagNode.setAttribute("Visible", tableVisible);
            String visibleDependency = collecTable.getString(i, "VisibleDependency");
            if (StringUtils.isNotEmpty((CharSequence)visibleDependency)) {
                tagNode.setAttribute("VisibleDependency", visibleDependency);
            }
        }
        String tableEnable = collecTable.getString(i, "TableEnable");
        if (!StringUtils.equals((CharSequence)metaOperationSrc.getEnable(), (CharSequence)tableEnable)) {
            tagNode.setAttribute("Enable", tableEnable);
            String enableDependency = collecTable.getString(i, "EnableDependency");
            if (StringUtils.isNotEmpty((CharSequence)enableDependency)) {
                tagNode.setAttribute("EnableDependency", enableDependency);
            }
        }
        String tableAction = collecTable.getString(i, "TableAction");
        MetaBaseScript actionSrc = metaOperationSrc.getAction();
        if (actionSrc == null) {
            actionSrc = new MetaBaseScript("");
        }
        if (!StringUtils.equals((CharSequence)actionSrc.getContent(), (CharSequence)tableAction)) {
            TagNode actionTagNode = new TagNode("Action", null);
            actionTagNode.setCDataValue(tableAction);
            tagNode.addNode(actionTagNode);
        }
        Integer TC_IsFirst = collecTable.getInt(i, "TC_IsFirst");
        Integer TC_IsLast = collecTable.getInt(i, "TC_IsLast");
        boolean TC_IsFirstorTC_IsFirst = false;
        if (TC_IsFirst == 1) {
            tagNode.setAttribute("First", String.valueOf(true));
            TC_IsFirstorTC_IsFirst = true;
        }
        if (TC_IsLast == 1) {
            tagNode.setAttribute("Last", String.valueOf(true));
            TC_IsFirstorTC_IsFirst = true;
        }
        if (!TC_IsFirstorTC_IsFirst) {
            if (i + 1 < collecTable.size()) {
                String key = collecTable.getString(i + 1, "TableMark");
                tagNode.setAttribute("SideKey", key);
                tagNode.setAttribute("InsertAfter", "false");
            } else if (i == collecTable.size() - 1) {
                String key = collecTable.getString(i - 1, "TableMark");
                tagNode.setAttribute("SideKey", key);
                tagNode.setAttribute("InsertAfter", "true");
            }
        }
        return tagNode;
    }

    private static TagNode toExtendOperationNode(DataTable collecTable, int i, MetaOperationCollection metaOperationSrc) {
        String key;
        TagNode tagNode = new TagNode("OperationCollection", null);
        String tableMark = collecTable.getString(i, "TableMark");
        tagNode.setAttribute("Key", tableMark);
        String tableCaption = collecTable.getString(i, "TableCaption");
        if (!StringUtils.equals((CharSequence)tableCaption, (CharSequence)metaOperationSrc.getCaption())) {
            tagNode.setAttribute("Caption", tableCaption);
        }
        String tableVisible = collecTable.getString(i, "TableVisible");
        if (!StringUtils.equals((CharSequence)metaOperationSrc.getVisible(), (CharSequence)tableVisible)) {
            tagNode.setAttribute("Visible", tableVisible);
            String visibleDependency = collecTable.getString(i, "VisibleDependency");
            if (StringUtils.isNotEmpty((CharSequence)visibleDependency)) {
                tagNode.setAttribute("VisibleDependency", visibleDependency);
            }
        }
        String tableEnable = collecTable.getString(i, "TableEnable");
        if (!StringUtils.equals((CharSequence)metaOperationSrc.getEnable(), (CharSequence)tableEnable)) {
            tagNode.setAttribute("Enable", tableEnable);
            String enableDependency = collecTable.getString(i, "EnableDependency");
            if (StringUtils.isNotEmpty((CharSequence)enableDependency)) {
                tagNode.setAttribute("EnableDependency", enableDependency);
            }
        }
        String tableAction = collecTable.getString(i, "TableAction");
        MetaBaseScript actionSrc = metaOperationSrc.getAction();
        if (actionSrc == null) {
            actionSrc = new MetaBaseScript("");
        }
        if (!StringUtils.equals((CharSequence)actionSrc.getContent(), (CharSequence)tableAction)) {
            TagNode actionTagNode = new TagNode("Action", null);
            actionTagNode.setCDataValue(tableAction);
            tagNode.addNode(actionTagNode);
        }
        if (i + 1 < collecTable.size()) {
            key = collecTable.getString(i + 1, "TableMark");
            tagNode.setAttribute("SideKey", key);
            tagNode.setAttribute("InsertAfter", "false");
        } else if (i == collecTable.size() - 1) {
            key = collecTable.getString(i - 1, "TableMark");
            tagNode.setAttribute("SideKey", key);
            tagNode.setAttribute("InsertAfter", "true");
        }
        return tagNode;
    }

    private static TagNode toOperationDetailNode(DataTable fieldTable, int j, boolean vestFlag) {
        TagNode tagNode1 = new TagNode("Operation", null);
        String tableMark1 = fieldTable.getString(j, "TableMark");
        String tableCaption1 = fieldTable.getString(j, "TableCaption");
        String tableEnable1 = fieldTable.getString(j, "TableEnable");
        String tableVisible1 = fieldTable.getString(j, "TableVisible");
        String enableDependency = fieldTable.getString(j, "EnableDependency");
        String visibleDependency = fieldTable.getString(j, "VisibleDependency");
        String tableRefKey1 = fieldTable.getString(j, "TableRefKey");
        String tableTag1 = fieldTable.getString(j, "TableTag");
        String tableAction1 = fieldTable.getString(j, "TableAction");
        String subShortCuts = fieldTable.getString(j, "ShortCuts");
        String subNeedAccessLog = fieldTable.getString(j, "NeedAccessLog");
        String tCode = fieldTable.getString(j, "GetTCode");
        String activity = fieldTable.getString(j, "GetActivity");
        String subExpand = fieldTable.getString(j, "Expand");
        String subExpandSource = fieldTable.getString(j, "ExpandSource");
        String isTransfer = fieldTable.getString(j, "IsTransfer");
        tagNode1.setAttribute("Key", tableMark1);
        if (!StringUtils.isEmpty((CharSequence)tableCaption1)) {
            tagNode1.setAttribute("Caption", tableCaption1);
        }
        if (!StringUtils.isEmpty((CharSequence)subShortCuts)) {
            tagNode1.setAttribute("ShortCuts", subShortCuts);
        }
        tagNode1.setAttribute("IsTransfer", isTransfer);
        if (!StringUtils.isEmpty((CharSequence)tableEnable1)) {
            tagNode1.setAttribute("Enable", tableEnable1);
        }
        if (!StringUtils.isEmpty((CharSequence)enableDependency)) {
            tagNode1.setAttribute("EnableDependency", enableDependency);
        }
        if (!StringUtils.isEmpty((CharSequence)visibleDependency)) {
            tagNode1.setAttribute("VisibleDependency", visibleDependency);
        }
        if (!StringUtils.isEmpty((CharSequence)tableVisible1)) {
            tagNode1.setAttribute("Visible", tableVisible1);
        }
        if (!StringUtils.isEmpty((CharSequence)tableRefKey1)) {
            tagNode1.setAttribute("RefKey", tableRefKey1);
        }
        if (!StringUtils.isEmpty((CharSequence)tableTag1)) {
            tagNode1.setAttribute("Tag", tableTag1);
        }
        if (!StringUtils.isEmpty((CharSequence)subNeedAccessLog)) {
            tagNode1.setAttribute("NeedAccessLog", subNeedAccessLog);
        }
        if (!StringUtils.isEmpty((CharSequence)activity)) {
            tagNode1.setAttribute("Activity", activity);
        }
        if (!StringUtils.isEmpty((CharSequence)tCode)) {
            tagNode1.setAttribute("TCode", tCode);
        }
        if (!StringUtils.isEmpty((CharSequence)subExpand)) {
            tagNode1.setAttribute("Expand", subExpand);
        }
        if (!StringUtils.isEmpty((CharSequence)subExpandSource)) {
            tagNode1.setAttribute("ExpandSource", subExpandSource);
        }
        if (!StringUtils.isEmpty((CharSequence)tableAction1)) {
            TagNode subAction = new TagNode("Action", null);
            CDataNode cDataNode = new CDataNode(tableAction1, null);
            subAction.addNode(cDataNode);
            tagNode1.addNode(subAction);
        }
        if (vestFlag) {
            String key;
            if (j + 1 < fieldTable.size()) {
                key = fieldTable.getString(j + 1, "TableMark");
                tagNode1.setAttribute("SideKey", key);
                tagNode1.setAttribute("InsertAfter", "false");
            } else if (j == fieldTable.size() - 1 && !tableMark1.equalsIgnoreCase(key = fieldTable.getString(j - 1 < 0 ? 0 : j - 1, "TableMark"))) {
                tagNode1.setAttribute("SideKey", key);
                tagNode1.setAttribute("InsertAfter", "true");
            }
        }
        return tagNode1;
    }

    private static TagNode toExtendOperationDetailNode(DataTable fieldTable, int i, MetaOperation metaOperation, MetaOperation metaOperationSrc) {
        TagNode tagNode = new TagNode("Operation", null);
        String subTableMark = fieldTable.getString(i, "TableMark");
        tagNode.setAttribute("Key", subTableMark);
        String subTableCaption = fieldTable.getString(i, "TableCaption");
        String caption = metaOperation.getCaption();
        if (!StringUtils.equals((CharSequence)subTableCaption, (CharSequence)metaOperationSrc.getCaption())) {
            tagNode.setAttribute("Caption", subTableCaption);
        }
        String subTableVisible = fieldTable.getString(i, "TableVisible");
        String visible = metaOperation.getVisible();
        if (!StringUtils.equals((CharSequence)metaOperationSrc.getVisible(), (CharSequence)subTableVisible)) {
            tagNode.setAttribute("Visible", subTableVisible);
            String subTableVisibleDependency = fieldTable.getString(i, "VisibleDependency");
            if (StringUtils.isNotEmpty((CharSequence)subTableVisibleDependency)) {
                tagNode.setAttribute("VisibleDependency", subTableVisibleDependency);
            }
        }
        String subTableEnable = fieldTable.getString(i, "TableEnable");
        String enable = metaOperation.getEnable();
        if (!StringUtils.equals((CharSequence)metaOperationSrc.getEnable(), (CharSequence)subTableEnable)) {
            tagNode.setAttribute("Enable", subTableEnable);
            String subTableEnableDependency = fieldTable.getString(i, "EnableDependency");
            if (StringUtils.isNotEmpty((CharSequence)subTableEnableDependency)) {
                tagNode.setAttribute("EnableDependency", subTableEnableDependency);
            }
        }
        String tableAction = fieldTable.getString(i, "TableAction");
        MetaBaseScript action1 = metaOperation.getAction();
        if (action1 == null) {
            action1 = new MetaBaseScript("");
        }
        String action = action1.getContent();
        MetaBaseScript actionSrc = metaOperationSrc.getAction();
        if (actionSrc == null) {
            actionSrc = new MetaBaseScript("");
        }
        if (!StringUtils.equals((CharSequence)actionSrc.getContent(), (CharSequence)tableAction)) {
            TagNode actionTagNode = new TagNode("Action", null);
            actionTagNode.setCDataValue(tableAction);
            tagNode.addNode(actionTagNode);
        }
        return tagNode;
    }
}

