/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.mergesingle.common;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.CheckXMLChanged;
import com.bokesoft.yes.design.cmd.ReplaceStringEntry;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;

public class MergeSingleDiffUtil {
    public static void genSingleXmlDiff(TagNode node, Diff diff) {
        if (node == null) {
            throw new RuntimeException("TagNode\u672a\u8d4b\u503c");
        }
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        int startLine = xmlTree.xmlTree.getLineByIndex(node.getElement().getBgIndex());
        String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment = DesignIOMetaUtil.getXml(node);
        diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
    }

    public static Diff getDiffByJson(String jsonDiff) throws Throwable {
        JSONArray array = new JSONArray(jsonDiff);
        Diff diff = Diff.fromJson(array.getJSONObject(0));
        return diff;
    }

    public static Map<String, String> processSingleXmlDiff(Diff diff) throws Throwable {
        String xmlFilePath;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> orgXmls = new LinkedHashMap<String, String>();
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        if (xmlTree != null && (xmlFilePath = xmlTree.orgFilePath) != null && !orgXmls.containsKey(xmlFilePath)) {
            orgXmls.put(xmlFilePath, xmlTree.xmlTree.getOrgXml());
        }
        String orgFilePath = diff.getXmlTree().orgFilePath;
        String orgXml = diff.getXmlTree().xmlTree.getOrgXml();
        orgXml = MergeSingleDiffUtil.mergeSingleDiff(orgXml, diff);
        orgXmls.put(orgFilePath, orgXml);
        for (Map.Entry entry : orgXmls.entrySet()) {
            String filePath = (String)entry.getKey();
            String newContent = (String)entry.getValue();
            boolean isPropertyDiff = true;
            String key = StringUtils.isNotBlank((CharSequence)filePath) ? LoadFileTree.getProjectKey(filePath) : ((MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(diff.formKey)).getProject().getKey();
            String tmpFilePath = XmlFileProcessor.instance.saveTempFile(filePath, newContent, key);
            result.put(tmpFilePath, newContent);
        }
        return result;
    }

    public static String mergeSingleDiff(String xml, Diff diff) throws Throwable {
        String result = xml;
        ReplaceStringEntry entry = diff.isPropertyDiff() ? new ReplaceStringEntry() : null;
        int startLine = diff.getStartLine();
        String orgXmlFragment = diff.getOrgXmlFragment();
        String newXmlFragment = diff.getNewXmlFragment();
        boolean insertIndent = diff.isPropertyDiff() && !diff.isGridColumnDrag();
        result = CheckXMLChanged.mergeXML(result, startLine, orgXmlFragment, newXmlFragment, entry, insertIndent);
        int startLine2 = diff.getStartLine2();
        if (startLine2 != -1) {
            ReplaceStringEntry entry2 = diff.isPropertyDiff() ? new ReplaceStringEntry() : null;
            result = CheckXMLChanged.mergeXML(result, startLine2, diff.getOrgXmlFragment2(), diff.getNewXmlFragment2(), entry2, insertIndent);
        }
        return result;
    }
}

