/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.io;

import com.bokesoft.yes.design.io.Tree;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeNode {
    private final Map<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
    public static final String TYPE_Root = "root";
    public static final String TYPE_Project = "project";
    public static final String TYPE_SOLUTION = "solution";
    public static final String TYPE_Fold = "fold";
    public static final String TYPE_File = "file";
    public String key;
    public final String type;
    public String parentKey = null;
    public String name;
    public String description;
    public String namePath;
    public String focusRowChangedFormula;
    public int allChildrenCount = 0;
    public String projectKey = null;
    public String solutionKey = null;
    public boolean isInJar;
    public static final Map<String, String> actionFileReflection = ImmutableMap.builder().put((Object)"CommonDef", (Object)"D_CommonDef").put((Object)"Entry", (Object)"D_Entry").build();
    public List<TreeNode> children;

    public TreeNode(String key) {
        this.key = key;
        this.type = TYPE_Root;
        this.namePath = null;
    }

    public TreeNode(String name, String type, String description, String key, String parentKey, String projectKey, String solutionKey) {
        this.key = key.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
        this.type = type;
        this.parentKey = parentKey.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
        this.name = name;
        this.description = description;
        this.projectKey = projectKey;
        this.solutionKey = solutionKey;
    }

    public void addChild(TreeNode node) {
        if (!node.isInJar) {
            node.isInJar = this.isInJar;
        }
        node.key = node.key.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
        node.parentKey = node.parentKey.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
        Tree.map.put(node.key, node);
        this.nodeMap.put(node.key, node);
        String parentKey = node.parentKey;
        TreeNode parent = Tree.map.get(parentKey);
        if (parent != null) {
            node.namePath = parent.namePath == null ? node.name : String.valueOf(parent.namePath) + File.separator + node.name;
        }
        Tree.setNodeFocusRowChangedFormula(node, parentKey);
        if (this.children == null) {
            this.children = new ArrayList<TreeNode>();
        }
        this.children.add(node);
        ++this.allChildrenCount;
    }

    public TreeNode getChildNode(String key) {
        return this.nodeMap.get(key);
    }

    public void removeChild(TreeNode node) {
        this.children.remove(node);
        --this.allChildrenCount;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TreeNode)) {
            return false;
        }
        return this.key.equals(((TreeNode)other).key);
    }
}

