/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.io;

import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.helper.FilePathHelper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Tree {
    public TreeNode root;
    public static Map<String, TreeNode> map = new HashMap<String, TreeNode>();

    public Tree(String rootKey) {
        this.root = new TreeNode(rootKey);
        map.put(rootKey, this.root);
    }

    public void addTreeNode(TreeNode node) {
        node.key = FilePathHelper.toBackFilePath(node.key);
        node.parentKey = FilePathHelper.toBackFilePath(node.parentKey);
        if (map.containsKey(node.key)) {
            return;
        }
        map.put(node.key, node);
        TreeNode parent = map.get(node.parentKey);
        parent.children.add(node);
        ++parent.allChildrenCount;
    }

    public void addTreeNode(TreeNode node, boolean create) {
        node.key = FilePathHelper.toBackFilePath(node.key);
        node.parentKey = FilePathHelper.toBackFilePath(node.parentKey);
        map.put(node.key, node);
        String parentKey = node.parentKey;
        if (!map.containsKey(parentKey)) {
            throw new RuntimeException("\u5efa\u6811\u4e0d\u5bf9\uff0c\u627e\u4e0d\u5230" + parentKey + "\u7684\u7236\u8282\u70b9\u3002");
        }
        TreeNode parent = map.get(parentKey);
        if (create && (CollectionUtils.isEmpty(parent.children) || !parent.children.contains(node))) {
            parent.addChild(node);
        }
        String parentParentKey = parent.parentKey;
        while (parentParentKey != null) {
            TreeNode parentParent = map.get(parentParentKey);
            parentParentKey = parentParent.parentKey;
        }
        node.namePath = StringUtils.isBlank((CharSequence)parent.namePath) ? node.name : String.valueOf(parent.namePath) + File.separator + node.name;
        Tree.setNodeFocusRowChangedFormula(node, parentKey);
    }

    static void setNodeFocusRowChangedFormula(TreeNode node, String parentKey) {
        if (Objects.equals(node.type, "file")) {
            String key = node.name.substring(0, node.name.length() - ".xml".length());
            node.focusRowChangedFormula = "showSource('" + node.key + "', '" + node.namePath + "', '" + TreeNode.actionFileReflection.getOrDefault(key, key) + "', '" + parentKey + "')";
        }
    }

    public void removeTreeNode(TreeNode node) {
        map.remove(node.key);
        String parentKey = node.parentKey;
        if (!map.containsKey(parentKey)) {
            throw new RuntimeException("\u5efa\u6811\u4e0d\u5bf9\uff0c\u627e\u4e0d\u5230" + parentKey + "\u7684\u7236\u8282\u70b9\u3002");
        }
        TreeNode parent = map.get(parentKey);
        parent.removeChild(node);
        String parentParentKey = parent.parentKey;
        while (parentParentKey != null) {
            TreeNode parentParent = map.get(parentParentKey);
            parentParentKey = parentParent.parentKey;
        }
    }

    public TreeNode getNode(String key) {
        return map.get(key);
    }
}

