/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.function;

import com.bokesoft.erp.entity.util.EntityDesigerContextAction;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.design.bpm.util.GetDataUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.tools.document.DataTableUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class WebDesignBPMUtil
extends EntityDesigerContextAction {
    private static final String ProcessKey = "ProcessKey";
    private static final String IsDynamic = "IsDynamic";
    private static final String StartAction = "StartAction";
    private static final String StartCaption = "StartCaption";
    private static final String Perm = "Perm";
    private static final String ProcessKeyFormula = "ProcessKeyFormula";
    private static final String ProcessMapCollection = "ProcessMapCollection";
    private static final String ProcessMap = "ProcessMap";

    public WebDesignBPMUtil(RichDocumentContext _context) {
        super(_context);
    }

    public String getFormList() throws Throwable {
        StringBuilder sb = new StringBuilder(256);
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        if (metaFormList != null && !metaFormList.isEmpty()) {
            int i = 0;
            while (i < metaFormList.size()) {
                MetaFormProfile metaFormProfile = (MetaFormProfile)metaFormList.get(i);
                if (metaFormProfile != null) {
                    String formKey = metaFormProfile.getKey();
                    String formCaption = metaFormProfile.getCaption();
                    if (GetDataUtil.instance.hasMainTable(formKey, 1)) {
                        sb.append(";");
                        sb.append(formKey).append(",").append(" ").append(formCaption.replaceAll(",", " "));
                    }
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public String getDataObjectList() throws Throwable {
        StringBuilder sb = new StringBuilder(256);
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        if (dataObjectList != null && !dataObjectList.isEmpty()) {
            int i = 0;
            while (i < dataObjectList.size()) {
                MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(i);
                if (metaDataObjectProfile != null) {
                    String dataObjeectKey = metaDataObjectProfile.getKey();
                    String dataObjeectCaption = metaDataObjectProfile.getCaption();
                    int secondType = metaDataObjectProfile.getSecondaryType();
                    if (GetDataUtil.instance.hasMainTable(dataObjeectKey, 2) && secondType == 2) {
                        sb.append(";");
                        sb.append(dataObjeectKey).append(",").append(" ").append(dataObjeectCaption.replaceAll(",", " "));
                    }
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public String getProcessKeyList(String filePath) throws Throwable {
        filePath = FilePathHelper.toBackFilePath(filePath);
        StringBuilder sb = new StringBuilder(256);
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return sb.toString();
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(filePath));
        Element root = document.getRootElement();
        List elements = root.elements();
        if (CollectionUtils.isEmpty((Collection)elements) || root.element("DeployInfoCollection") == null || root.element("DeployInfoCollection").elements("DeployInfo") == null) {
            return sb.toString();
        }
        List deployInfoList = root.element("DeployInfoCollection").elements("DeployInfo");
        for (Element ele : deployInfoList) {
            if (ele.attributeValue("Key") == null) continue;
            sb.append(";");
            sb.append(ele.attributeValue("Key"));
        }
        return sb.toString();
    }

    public DataTable getWorkflowData(String filePath) throws Throwable {
        RichDocumentContext context = this.getMidContext();
        filePath = FilePathHelper.toBackFilePath(filePath);
        MetaForm metaFormKeyDialog = context.getMetaFactory().getMetaForm("BPM_Setting");
        MetaTable gridMetaTable = metaFormKeyDialog.getDataSource().getDataObject().getMetaTable("EBPM_Setting");
        DataTable dataTable = DataTableUtil.newEmptyDataTable((MetaTable)gridMetaTable);
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return dataTable;
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(filePath));
        Element root = document.getRootElement();
        if (!CollectionUtils.isEmpty((Collection)root.element(ProcessMapCollection).elements(ProcessMap))) {
            List elements = root.element(ProcessMapCollection).elements(ProcessMap);
            int i = 0;
            while (i < elements.size()) {
                Element ele = (Element)elements.get(i);
                dataTable.append();
                if (StringUtils.isNotEmpty((CharSequence)ele.attributeValue("Type"))) {
                    dataTable.setString("Type", "2");
                } else {
                    dataTable.setString("Type", "1");
                }
                dataTable.setString("Key", ele.attributeValue("Key"));
                dataTable.setBoolean(IsDynamic, Boolean.valueOf(StringUtils.isNotEmpty((CharSequence)ele.attributeValue(IsDynamic))));
                if (StringUtils.isNotEmpty((CharSequence)ele.attributeValue(ProcessKey))) {
                    dataTable.setString(ProcessKey, ele.attributeValue(ProcessKey));
                }
                if (StringUtils.isNotEmpty((CharSequence)ele.attributeValue(ProcessKeyFormula))) {
                    dataTable.setString(ProcessKey, ele.attributeValue(ProcessKeyFormula));
                }
                dataTable.setString(StartAction, ele.attributeValue(StartAction));
                dataTable.setString(StartCaption, ele.attributeValue(StartCaption));
                Element perm = ele.element(Perm);
                if (perm != null) {
                    String permXml = perm.asXML();
                    dataTable.setString(Perm, permXml);
                }
                ++i;
            }
        }
        return dataTable;
    }

    public void workflowAndBillsConfig(String filePath) throws Throwable {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return;
        }
        filePath = FilePathHelper.toBackFilePath(filePath);
        RichDocumentContext context = this.getMidContext();
        RichDocument richDocument = context.getRichDocument();
        DataTable ebpm_setting = richDocument.getDataTable("EBPM_Setting");
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(filePath));
        Element root = document.getRootElement();
        if (root.element(ProcessMapCollection) != null) {
            root.remove(root.element(ProcessMapCollection));
        }
        root.addElement(ProcessMapCollection);
        int i = 0;
        while (i < ebpm_setting.size()) {
            if (!StringUtils.isEmpty((CharSequence)ebpm_setting.getString(i, "Key"))) {
                Element processMapEle = root.element(ProcessMapCollection).addElement(ProcessMap);
                String type = ebpm_setting.getString(i, "Type");
                String processKey = ebpm_setting.getString(i, ProcessKey);
                if ("1".equals(type)) {
                    processMapEle.addAttribute(ProcessKey, processKey);
                } else {
                    processMapEle.addAttribute("Type", type);
                    processMapEle.addAttribute(ProcessKeyFormula, processKey);
                }
                Boolean isDynamic = ebpm_setting.getBoolean(i, IsDynamic);
                if (isDynamic.booleanValue()) {
                    processMapEle.addAttribute(IsDynamic, isDynamic.toString());
                    processKey = ebpm_setting.getString(i, ProcessKey);
                    processMapEle.addAttribute(ProcessKey, processKey);
                    processMapEle.addAttribute(ProcessKeyFormula, processKey);
                }
                processMapEle.addAttribute("InitDate", String.valueOf(DateUtil.getDateFormatText(null, (String)"yyyy-MM-dd HH:mm:ss")) + " CST").addAttribute("Key", ebpm_setting.getString(i, "Key")).addAttribute(StartAction, ebpm_setting.getString(i, StartAction)).addAttribute(StartCaption, ebpm_setting.getString(i, StartCaption));
                String perm = ebpm_setting.getString(i, Perm);
                if (!StringUtils.isEmpty((CharSequence)perm)) {
                    Document document1 = DocumentHelper.parseText((String)perm);
                    processMapEle.add(document1.getRootElement());
                }
            }
            ++i;
        }
        this.writeStringToFile(filePath, document);
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        globalInstance.reloadMetaBPM();
    }

    private void writeStringToFile(String filePath, Document document) {
        block5: {
            OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
            FileOutputStream fileOutputStream = null;
            XMLWriter writer = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(filePath);
                    writer = new XMLWriter(fileOutputStream, format);
                    writer.write(document);
                    DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
                throw throwable;
            }
            DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
        }
    }
}

