/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.function;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.erp.entity.util.EntityDesigerContextAction;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.Breakpoint;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.DebuggerContext;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.DebuggerFacade;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.OperateTypeEnum;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.SyntaxTreeWrapper;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.ExpAutoCompleteCmd;
import com.bokesoft.yes.design.cmd.NewFormCmd;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.IOMetaObject;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.WebDesignerDataTableUtil;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.Xml4jUtil;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.richdocument.strut.ComboxStringBuilder;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.xml.XmlParser;
import com.bokesoft.yes.xml.node.TagNode;
import com.bokesoft.yes.xml.node.XmlTree;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.common.def.ChartSourceType;
import com.bokesoft.yigo.common.def.ColumnType;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.common.MetaFieldLabel;
import com.bokesoft.yigo.meta.common.MetaFieldLabelCollection;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.MetaLabel;
import com.bokesoft.yigo.meta.form.component.control.MetaRadioButton;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowCollection;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.intf.IMetaSolution;
import com.bokesoft.yigo.meta.parameter.MetaParameter;
import com.bokesoft.yigo.meta.parameter.MetaParameterID;
import com.bokesoft.yigo.meta.paratable.MetaParaGroup;
import com.bokesoft.yigo.meta.paratable.MetaParaItem;
import com.bokesoft.yigo.meta.paratable.MetaParaTable;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.web.util.ExtensionUtil;
import com.bokesoft.yigo.parser.IEvalContext;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.io.File;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class DesignActionUtil
extends EntityDesigerContextAction {
    public static Map<String, String> DataMap = new HashMap<String, String>();
    public static Map<Integer, String> associatedTableMap = new HashMap<Integer, String>();
    public static Map<Integer, String> bindingGridKeyMap = new HashMap<Integer, String>();
    private static final Logger logger = Logger.getLogger(ExpAutoCompleteCmd.class.getName());
    private static ICache<Object> cache;
    private static final Pattern PATTERN;
    private static final Pattern azAZ;

    static {
        PATTERN = Pattern.compile("[a-zA-Z0-9_.,\\-/;\\[\\]\u2018\\\\${}^|~\\n\\r\\t ]{1,35}");
        azAZ = Pattern.compile("[a-zA-Z]*$");
    }

    public DesignActionUtil(RichDocumentContext _context) {
        super(_context);
    }

    public String getAllProjects() throws Throwable {
        IMetaFactory metaFactory = this.getMidContext().getMetaFactory();
        StringBuilder sb = new StringBuilder(256);
        MetaProjectCollection projectCollection = metaFactory.getSolution().getProjectCollection();
        for (MetaProjectProfile metaProjectProfile : projectCollection) {
            MetaSolution metaSolution;
            IMetaSolution solution;
            boolean flag;
            MetaProject metaProject = metaProjectProfile.getProject();
            if (Objects.isNull(metaProject) || !(flag = (solution = metaProject.getSolution()) instanceof MetaSolution) || !LoadFileTree.isDesignableSolution((metaSolution = (MetaSolution)solution).getKey())) continue;
            String key = metaProjectProfile.getKey();
            String caption = metaProjectProfile.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(key).append(",").append(key).append(" ").append(caption);
        }
        return sb.toString();
    }

    public String getChildDirToForm(String projectKey) throws Throwable {
        if (StringUtils.isEmpty((CharSequence)projectKey)) {
            return "";
        }
        List projectKeys = this.getMidContext().getMetaFactory().getProjectKeys();
        if (!projectKeys.contains(projectKey)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(256);
        TreeNode projectNode = LoadFileTree.getProjectNode(projectKey);
        TreeNode formFold = LoadFileTree.getChildFoldNode(projectNode, "Form", projectKey, projectNode.solutionKey);
        List<TreeNode> children = formFold.children;
        String x = DesignActionUtil.geFiletNameString("", sb, children);
        if (x != null) {
            return x;
        }
        return sb.toString().length() > 0 ? sb.toString().substring(0, sb.toString().length() - 1) : sb.toString();
    }

    private static String geFiletNameString(String pName, StringBuilder sb, List<TreeNode> children) {
        if (children == null) {
            return "";
        }
        int i = 0;
        while (i < children.size()) {
            TreeNode treeNode = children.get(i);
            if (azAZ.matcher(treeNode.name).matches() && treeNode.type != "file") {
                String treeNodeName = treeNode.name;
                if (!pName.isEmpty()) {
                    treeNodeName = String.valueOf(pName) + "/" + treeNode.name;
                }
                sb.append(treeNodeName).append(",").append(treeNodeName).append(";");
                DesignActionUtil.geFiletNameString(treeNodeName, sb, treeNode.children);
            }
            ++i;
        }
        return null;
    }

    public boolean checkExtend(String columnKey) throws Throwable {
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        if (StringUtils.isBlank((CharSequence)para)) {
            return true;
        }
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        String extend = metaForm.getExtend();
        if (StringUtils.isEmpty((CharSequence)extend)) {
            return true;
        }
        MetaForm metaForm1 = NewFormCmd.loadMetaForm(extend);
        return !metaForm1.getAllUIComponents().containsKey(columnKey);
    }

    public boolean checkGridKeyEnable(String key) throws Throwable {
        List collect;
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String pathByFormKey = LoadFileTree.getPathByFormKey(para);
        HashMap<Object, Object> mapNodes = new HashMap();
        XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(pathByFormKey);
        if (Objects.nonNull(xmlTree) && Objects.isNull(xmlTree.xmlTree)) {
            mapNodes = xmlTree.xmlTree.getMapNodes();
        }
        return (collect = mapNodes.values().stream().filter(m -> m.getElement().getTagName().equals("SubDetail")).map(m -> (com.bokesoft.yes.design.xml.node.TagNode)m).filter(c -> c.getAttributes().get("BindingGridKey").equals(key)).collect(Collectors.toList())).size() == 0;
    }

    public String getStatusCollectionKey() throws Throwable {
        RichDocument doc = this.getMidContext().getRichDocument();
        DataTable statusCollection = doc.getDataTable("ED_StatusCollection");
        ArrayList<String> statusKeys = new ArrayList<String>();
        int i = 0;
        while (i < statusCollection.size()) {
            String statusKey = statusCollection.getString(i, "Key");
            statusKeys.add(String.valueOf(statusKey) + "," + statusKey);
            ++i;
        }
        return StringUtils.join(statusKeys, (String)";");
    }

    public String getAllForms() throws Throwable {
        IMetaFactory metaFactory = this.getMidContext().getMetaFactory();
        ArrayList<String> itemList = new ArrayList<String>();
        for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
            MetaForm metaForm = metaFormProfile.getForm();
            if (Objects.isNull(metaForm)) continue;
            String caption = metaForm.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            String key = metaForm.getKey();
            String item = String.valueOf(key) + "," + key + " " + caption;
            itemList.add(item);
        }
        return StringUtils.join(itemList, (String)";");
    }

    public String getAllFormsByProjectKey(String projectKey) throws Throwable {
        IMetaFactory metaFactory = this.getMidContext().getMetaFactory();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        ArrayList<String> itemList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)projectKey)) {
            for (MetaFormProfile metaFormProfile : metaFormList) {
                if (StringUtils.isNotBlank((CharSequence)metaFormProfile.getExtend())) continue;
                String caption = metaFormProfile.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                String item = String.valueOf(metaFormProfile.getKey()) + "," + metaFormProfile.getKey() + " " + caption;
                itemList.add(item);
            }
        } else {
            String selectSolution = ((MetaSolution)metaFactory.getMetaProject(projectKey).getSolution()).getKey();
            String mainSolution = metaFactory.getSolution().getKey();
            boolean flag = StringUtils.equals((CharSequence)selectSolution, (CharSequence)mainSolution);
            for (MetaFormProfile metaFormProfile : metaFormList) {
                if (StringUtils.isNotBlank((CharSequence)metaFormProfile.getExtend()) || flag && !StringUtils.equals((CharSequence)metaFormProfile.getProject().getKey(), (CharSequence)projectKey)) continue;
                String caption = metaFormProfile.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                String item = String.valueOf(metaFormProfile.getKey()) + "," + metaFormProfile.getKey() + " " + caption;
                itemList.add(item);
            }
        }
        return StringUtils.join(itemList, (String)";");
    }

    public String getAllFormsByFormType(int type) throws Throwable {
        if (type != 3 && type != 253) {
            return this.getAllForms();
        }
        ArrayList<String> itemList = new ArrayList<String>();
        IMetaFactory metaFactory = this.getMidContext().getMetaFactory();
        if (type == 253) {
            for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
                int formType;
                if (metaFormProfile.getProject().getKey().equalsIgnoreCase("webconfig") || metaFormProfile.getFormType() != 8 && (!StringUtils.isNotEmpty((CharSequence)metaFormProfile.getExtend()) || (formType = ((MetaFormProfile)metaFactory.getMetaFormList().get(metaFormProfile.getExtend())).getFormType()) != 8)) continue;
                String caption = metaFormProfile.getForm().getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                String key = metaFormProfile.getForm().getKey();
                String item = String.valueOf(key) + "," + key + " " + caption;
                itemList.add(item);
            }
        } else {
            for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
                if (metaFormProfile.getFormType() == 6 || metaFormProfile.getFormType() == 2 || metaFormProfile.getFormType() == 7 || metaFormProfile.getFormType() == 3) continue;
                String caption = metaFormProfile.getForm().getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                String key = metaFormProfile.getForm().getKey();
                String item = String.valueOf(key) + "," + key + " " + caption;
                itemList.add(item);
            }
        }
        return StringUtils.join(itemList, (String)";");
    }

    public String getAllComponent(String formKey, String dataObjectKey) throws Throwable {
        MetaDataObject dataObject;
        MetaTable mainTable;
        StringBuilder str = new StringBuilder(256);
        if (!formKey.isEmpty() && "\u65b0\u5efa\u6570\u636e\u5bf9\u8c61".equals(dataObjectKey)) {
            try {
                MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(formKey);
                List allComponents = metaForm.getAllComponents();
                for (MetaComponent allComponent : allComponents) {
                    int controlType;
                    String mainTableKey;
                    String tableKey;
                    String key = allComponent.getKey();
                    if (StringUtils.isEmpty((CharSequence)key) || "ResetPattern".equals(key) || "SequenceValue".equals(key) || Objects.isNull(allComponent.getDataBinding()) || allComponent instanceof MetaLabel || allComponent.getDataBinding().getTableKey().isEmpty() || !(tableKey = allComponent.getDataBinding().getTableKey()).equals(mainTableKey = metaForm.getDataSource().getDataObject().getMainTableKey()) || !allComponent.getParentGridKey().isEmpty() || (controlType = allComponent.getControlType()) != 254 && controlType != 205 && controlType != 210 && controlType != 206 && controlType != 202 && controlType != 204 && controlType != 215) continue;
                    String caption = allComponent.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                    StringBuilder rowStr = new StringBuilder().append(key).append(",").append(key).append(" ").append(caption).append(";");
                    str = str.append((CharSequence)rowStr);
                }
            }
            catch (Exception metaForm) {}
        } else if (!"\u65b0\u5efa\u6570\u636e\u5bf9\u8c61".equals(dataObjectKey) && StringUtils.isNotEmpty((CharSequence)dataObjectKey) && (mainTable = (dataObject = this.getMidContext().getMetaFactory().getDataObject(dataObjectKey)).getMainTable()) != null) {
            for (MetaColumn metaColumn : mainTable) {
                String key = metaColumn.getKey();
                if (key.equals("OID") || "SOID".equals(key) || "POID".equals(key) || "VERID".equals(key) || "DVERID".equals(key)) continue;
                String caption = metaColumn.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                StringBuilder rowStr = new StringBuilder().append(key).append(",").append(key).append(" ").append(caption).append(";");
                str = str.append((CharSequence)rowStr);
            }
        }
        if (StringUtils.isEmpty((CharSequence)str.toString())) {
            return str.toString();
        }
        return str.substring(0, str.toString().length() - 1);
    }

    public String getAllGridCellByGridKey(String formKey, String gridKey) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        MetaGrid metaGrid = (MetaGrid)metaForm.componentByKey(gridKey);
        List<MetaGridCell> metaGridCells = idLookup.getGridCellsByTableKey(metaGrid.getTableKey());
        for (MetaGridCell metaGridCell : metaGridCells) {
            String key = metaGridCell.getKey();
            String caption = metaGridCell.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            StringBuilder rowStr = new StringBuilder().append(key).append(",").append(key).append(" ").append(caption).append(";");
            str = str.append((CharSequence)rowStr);
        }
        if (StringUtils.isEmpty((CharSequence)str.toString())) {
            return str.toString();
        }
        return str.substring(0, str.toString().length() - 1);
    }

    public String getAllGridLayoutPanelByFormKey(String formKey) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        String pathByFormKey = LoadFileTree.getPathByFormKey(formKey);
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePathNotLoadTmp(pathByFormKey);
        HashMap<String, AbstractNode> mapNodes = xmlTreeWithPath.xmlTree.getMapNodes();
        List<MetaGridLayoutPanel> gridLayoutPanels = idLookup.getGridLayoutPanels();
        for (MetaGridLayoutPanel gridLayoutPanel : gridLayoutPanels) {
            String key = gridLayoutPanel.getKey();
            if (!mapNodes.containsKey("GridLayoutPanel@" + key)) continue;
            String caption = gridLayoutPanel.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            StringBuilder rowStr = new StringBuilder().append(key).append(",").append(key).append(" ").append(caption).append(";");
            str = str.append((CharSequence)rowStr);
        }
        if (StringUtils.isEmpty((CharSequence)str.toString())) {
            return str.toString();
        }
        return str.substring(0, str.toString().length() - 1);
    }

    public String getAllDataObjects(int formType) throws Throwable {
        int dataObjectSecondaryType = 0;
        StringBuilder sb = new StringBuilder(256);
        sb.append("\u65b0\u5efa\u6570\u636e\u5bf9\u8c61").append(",").append("\u65b0\u5efa\u6570\u636e\u5bf9\u8c61").append(" ");
        if (formType == 2) {
            dataObjectSecondaryType = 3;
            this.getAllDataObject(dataObjectSecondaryType, sb);
        } else if (formType == 1) {
            dataObjectSecondaryType = 2;
            this.getAllDataObject(dataObjectSecondaryType, sb);
        } else if (formType == 6) {
            dataObjectSecondaryType = 5;
            this.getAllDataObject(dataObjectSecondaryType, sb);
        } else if (formType == 10) {
            sb = new StringBuilder(256);
            MetaDataObjectList projectCollection = this.getMidContext().getMetaFactory().getDataObjectList();
            for (MetaDataObjectProfile metaDataObjectProfile : projectCollection) {
                MetaDataObject dataObject = metaDataObjectProfile.getDataObject();
                if (!StringUtils.isNotEmpty((CharSequence)metaDataObjectProfile.getResource())) continue;
                if (dataObject == null) {
                    dataObject = MetaFactory.getGlobalInstance().getDataObject(metaDataObjectProfile.getKey());
                }
                if (dataObject.getSecondaryType() == 6) continue;
                String key = metaDataObjectProfile.getKey();
                String caption = metaDataObjectProfile.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(key).append(",").append(key).append(" ").append(caption);
            }
        } else {
            this.setDataObjectList(sb);
        }
        return sb.toString();
    }

    private void setDataObjectList(StringBuilder sb) throws Throwable {
        MetaDataObjectList projectCollection = this.getMidContext().getMetaFactory().getDataObjectList();
        for (MetaDataObjectProfile metaDataObjectProfile : projectCollection) {
            if (metaDataObjectProfile.getResource() == null) continue;
            String key = metaDataObjectProfile.getKey();
            String caption = metaDataObjectProfile.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(key).append(",").append(key).append(" ").append(caption);
        }
    }

    private void getAllDataObject(int dataObjectSecondaryType, StringBuilder sb) throws Throwable {
        MetaDataObjectList projectCollection = this.getMidContext().getMetaFactory().getDataObjectList();
        for (MetaDataObjectProfile metaDataObjectProfile : projectCollection) {
            if (Objects.isNull(metaDataObjectProfile.getDataObject()) || metaDataObjectProfile.getResource() == null || metaDataObjectProfile.getDataObject().getSecondaryType() != dataObjectSecondaryType) continue;
            String key = metaDataObjectProfile.getKey();
            String caption = metaDataObjectProfile.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(key).append(",").append(key).append(" ").append(caption);
        }
    }

    public String getAllDataObjects() throws Throwable {
        StringBuilder sb = new StringBuilder(256);
        MetaDataObjectList projectCollection = this.getMidContext().getMetaFactory().getDataObjectList();
        for (MetaDataObjectProfile metaDataObjectProfile : projectCollection) {
            if (Objects.isNull(metaDataObjectProfile.getDataObject()) || metaDataObjectProfile.getResource() == null || !metaDataObjectProfile.getResource().contains("DataObject")) continue;
            String key = metaDataObjectProfile.getKey();
            String caption = metaDataObjectProfile.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(key).append(",").append(key).append(" ").append(caption);
        }
        return sb.toString();
    }

    public String getNoVestDataObject() throws Throwable {
        Function<MetaDataObjectProfile, String> function = profile -> {
            String extend = profile.getExtend();
            if (StringUtils.isNotBlank((CharSequence)extend)) {
                return null;
            }
            MetaDataObject dataObject = profile.getDataObject();
            if (Objects.isNull(dataObject)) {
                return null;
            }
            String resource = profile.getResource();
            if (StringUtils.isEmpty((CharSequence)resource)) {
                return null;
            }
            String vestKey = dataObject.getMergeToSourceMapKey();
            if (StringUtils.isNotBlank((CharSequence)vestKey)) {
                return null;
            }
            String key = profile.getKey();
            String caption = profile.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            return StringUtils.join((Object[])new String[]{key, ",", key, " ", caption});
        };
        ArrayList<String> dataObjectStrList = new ArrayList<String>();
        IMetaFactory metaFactory = this.getMidContext().getMetaFactory();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        for (MetaDataObjectProfile profile2 : dataObjectList) {
            String dataObjectStr = function.apply(profile2);
            if (StringUtils.isBlank((CharSequence)dataObjectStr)) continue;
            dataObjectStrList.add(dataObjectStr);
        }
        return StringUtils.join(dataObjectStrList, (String)";");
    }

    public String getAllDataObjectTables(String objectKey) throws Throwable {
        if (StringUtils.isEmpty((CharSequence)objectKey)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(256);
        MetaDataObject dataObject = this.getMidContext().getMetaFactory().getDataObject(objectKey);
        MetaTableCollection tableCollection = dataObject.getTableCollection();
        if (tableCollection != null && tableCollection.size() > 0) {
            for (MetaTable metaTable : tableCollection) {
                String key = metaTable.getKey();
                String caption = metaTable.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(key).append(",").append(key).append(" ").append(caption);
            }
        }
        return sb.toString();
    }

    private boolean isSetKeyAndCaption() {
        File file = new File(String.valueOf(WebDesignerConfiguration.getDesignerDataPath()) + File.separator + "DesignerData.xml");
        boolean value = true;
        if (!file.exists()) {
            return true;
        }
        try {
            String s = FileUtils.readFileToString((File)file);
            XmlTree parse = XmlParser.parse((String)s);
            TagNode node = parse.getRoot().findFirstTagNodeByTagName("IsSetKeyAndCaption");
            if (node != null) {
                value = Boolean.parseBoolean((String)node.getAttributes().get("Value"));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    public void setDefaultKeyAndCaption(int type) throws Throwable {
        isSetKeyAndCaption = this.isSetKeyAndCaption();
        controlType = ControlType.toString((Integer)type);
        midContext = this.getMidContext();
        document = midContext.getRichDocument();
        para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        i = 1;
        while (i < 20) {
            block33: {
                block36: {
                    block35: {
                        block34: {
                            block32: {
                                metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
                                if (!"SubDetail".equalsIgnoreCase(controlType)) break block32;
                                idLoopup = IDLookup.getIDLookup(metaForm);
                                dataTable = document.getDataTable("D_NewSubDetailHead");
                                if (!idLoopup.containFieldKey(String.valueOf(controlType) + i)) {
                                    if (isSetKeyAndCaption) {
                                        dataTable.setString("Key", String.valueOf(controlType) + i);
                                        dataTable.setString("Caption", String.valueOf(controlType) + i);
                                    }
                                    document.addDirtyTableFlag("D_NewSubDetailHead");
                                    return;
                                }
                                if (isSetKeyAndCaption) {
                                    dataTable.setString("Key", String.valueOf(controlType) + i + 1);
                                    dataTable.setString("Caption", String.valueOf(controlType) + i + 1);
                                }
                                document.addDirtyTableFlag("D_NewSubDetailHead");
                                break block33;
                            }
                            if (!"Grid".equalsIgnoreCase(controlType)) break block34;
                            idLoopup = IDLookup.getIDLookup(metaForm);
                            dataTable = document.getDataTable("D_NewGridHead");
                            if (!idLoopup.containFieldKey(String.valueOf(controlType) + i)) {
                                if (isSetKeyAndCaption) {
                                    dataTable.setString("Key", String.valueOf(controlType) + i);
                                    dataTable.setString("Caption", String.valueOf(controlType) + i);
                                }
                                document.addDirtyTableFlag("D_NewGridHead");
                                return;
                            }
                            if (isSetKeyAndCaption) {
                                dataTable.setString("Key", String.valueOf(controlType) + i + 1);
                                dataTable.setString("Caption", String.valueOf(controlType) + i + 1);
                            }
                            document.addDirtyTableFlag("D_NewGridHead");
                            break block33;
                        }
                        allGridCells = metaForm.getAllGridCells();
                        loopUp = IDLookup.getIDLookup(metaForm);
                        dataTable = document.getDataTable("ED_NewCompModal");
                        if (dataTable == null) break block35;
                        gridKey = loopUp.getGridKeyByFieldKey(String.valueOf(controlType) + i);
                        map = new HashMap<Integer, String>();
                        b = 0;
                        allFieldKey2MetaGridColumnInfo_oldKey = loopUp.getAllFieldKey2MetaGridColumnInfo_oldKey();
                        keylist = new ArrayList<String>();
                        for (Map.Entry entries : allFieldKey2MetaGridColumnInfo_oldKey.entrySet()) {
                            keylist.add((String)entries.getKey());
                        }
                        for (String key : keylist) {
                            if (key.indexOf("Detail" + controlType) != -1) {
                                ++i;
                            }
                            map.put(++b, key);
                        }
                        if (StringUtils.isBlank((CharSequence)gridKey)) {
                            if (map.containsValue("Detail" + controlType + i)) {
                                if (isSetKeyAndCaption) {
                                    dataTable.setString("Key", "Detail" + controlType + (i + 1));
                                    dataTable.setString("Caption", "Detail" + controlType + (i + 1));
                                    dataTable.setString("ColumnKey", "Detail" + controlType + i);
                                }
                            } else if (isSetKeyAndCaption) {
                                dataTable.setString("Key", "Detail" + controlType + i);
                                dataTable.setString("Caption", "Detail" + controlType + i);
                                dataTable.setString("ColumnKey", "Detail" + controlType + i);
                            }
                            document.addDirtyTableFlag("ED_NewCompModal");
                            return;
                        }
                        if (isSetKeyAndCaption) {
                            dataTable.setString("Key", "Detail" + controlType + i + 1);
                            dataTable.setString("Caption", "Detail" + controlType + i + 1);
                        }
                        document.addDirtyTableFlag("ED_NewCompModal");
                        break block33;
                    }
                    if (document.getDataTable("ED_NewSonComp") == null) break block36;
                    dataTable = document.getDataTable("ED_NewSonComp");
                    gridKey = loopUp.getGridKeyByFieldKey(String.valueOf(controlType) + i);
                    map = new HashMap<K, V>();
                    b = 0;
                    idLoopup = IDLookup.getIDLookup(metaForm);
                    allFieldKey2MetaGridColumnInfo_oldKey = idLoopup.getAllFieldKey2MetaGridColumnInfo_oldKey();
                    keylist = new ArrayList<String>();
                    for (Map.Entry entries : allFieldKey2MetaGridColumnInfo_oldKey.entrySet()) {
                        keylist.add((String)entries.getKey());
                    }
                    for (String key : keylist) {
                        if (key.indexOf("Detail" + controlType) != -1) {
                            ++i;
                        }
                        map.put(++b, key);
                    }
                    if (StringUtils.isBlank((CharSequence)gridKey)) {
                        if (map.containsValue("Detail" + controlType + i)) {
                            if (isSetKeyAndCaption) {
                                dataTable.setString("Key", "Detail" + controlType + (i + 1));
                                dataTable.setString("Caption", "Detail" + controlType + (i + 1));
                                dataTable.setString("ColumnKey", "Detail" + controlType + i);
                            }
                        } else if (isSetKeyAndCaption) {
                            dataTable.setString("Key", "Detail" + controlType + i);
                            dataTable.setString("Caption", "Detail" + controlType + i);
                            dataTable.setString("ColumnKey", "Detail" + controlType + i);
                        }
                        document.addDirtyTableFlag("ED_NewSonComp");
                        return;
                    }
                    if (isSetKeyAndCaption) {
                        dataTable.setString("Key", "Detail" + controlType + i + 1);
                        dataTable.setString("Caption", "Detail" + controlType + i + 1);
                        dataTable.setString("ColumnKey", "Detail" + controlType + i);
                    }
                    document.addDirtyTableFlag("ED_NewSonComp");
                    break block33;
                }
                if (document.getDataTable("ED_NewRow") != null) break block33;
                dataTable = document.getDataTable("D_NewColumn");
                controlType = ColumnType.toString((int)type);
                gridKey = loopUp.getGridKeyByFieldKey(String.valueOf(controlType) + i);
                map = new HashMap<K, V>();
                b = 0;
                for (MetaGridCell all : allGridCells) {
                    key = all.getKey();
                    if (key.indexOf("Detail" + controlType) != -1) {
                        ++i;
                    }
                    map.put(++b, key);
                }
                if (!StringUtils.isBlank((CharSequence)gridKey)) ** GOTO lbl137
                if (map.containsValue("Detail" + controlType + i)) {
                    if (isSetKeyAndCaption) {
                        dataTable.setString("Key", String.valueOf(controlType) + (i + 1));
                    }
                } else {
                    if (isSetKeyAndCaption) {
                        dataTable.setString("Key", String.valueOf(controlType) + i);
                    }
                    document.addDirtyTableFlag("D_NewColumn");
                    return;
lbl137:
                    // 1 sources

                    if (isSetKeyAndCaption) {
                        dataTable.setString("Key", String.valueOf(controlType) + i + 1);
                    }
                }
                document.addDirtyTableFlag("D_NewColumn");
            }
            ++i;
        }
    }

    public void setDefaultKeyAndCaption() throws Throwable {
        boolean isSetKeyAndCaption = this.isSetKeyAndCaption();
        RichDocumentContext midContext = this.getMidContext();
        RichDocument document = midContext.getRichDocument();
        DataTable dataTable = document.getDataTable("ED_NewForm");
        int formType = dataTable.getInt("FormType");
        if (formType == 9) {
            formType = 0;
        }
        if (formType != 10) {
            String sFormType = FormType.toString((Integer)formType);
            MetaFormList metaFormList = midContext.getMetaFactory().getMetaFormList();
            Integer i = 0;
            while (true) {
                String tmp;
                if (!metaFormList.containsKey(tmp = sFormType.concat(i.toString()))) {
                    if (isSetKeyAndCaption) {
                        dataTable.setString("Key", tmp);
                        dataTable.setString("Caption", tmp);
                    }
                    dataTable.setString("InDataObject", "\u65b0\u5efa\u6570\u636e\u5bf9\u8c61");
                    document.addDirtyTableFlag("ED_NewForm");
                    return;
                }
                i = i + 1;
            }
        }
    }

    public void setExpandDefaultKeyAndCaption(int type) throws Throwable {
        boolean isSetKeyAndCaption = this.isSetKeyAndCaption();
        RichDocumentContext midContext = this.getMidContext();
        RichDocument document = midContext.getRichDocument();
        DataTable dataTable = document.getDataTable("ED_NewForm");
        String associationForm = dataTable.getString("AssociationForm");
        if (StringUtils.isEmpty((CharSequence)associationForm)) {
            return;
        }
        IMetaFactory iMetaFactory = this.getMidContext().getMetaFactory();
        MetaForm metaForm = iMetaFactory.getMetaForm(associationForm);
        String associationCaption = String.valueOf(metaForm.getCaption()) + "\u9a6c\u7532";
        String sFormType = String.valueOf(associationForm) + "_Vest";
        if (type == 3) {
            associationCaption = String.valueOf(metaForm.getCaption()) + "\u89c6\u56fe";
            sFormType = String.valueOf(associationForm) + "_View";
        }
        MetaFormList metaFormList = midContext.getMetaFactory().getMetaFormList();
        Integer i = 0;
        while (true) {
            String tmp = sFormType.concat(i.toString());
            String Caption = associationCaption.concat(i.toString());
            if (!metaFormList.containsKey(tmp)) {
                if (isSetKeyAndCaption) {
                    dataTable.setString("Key", tmp);
                    dataTable.setString("Caption", Caption);
                }
                document.addDirtyTableFlag("ED_NewForm");
                return;
            }
            i = i + 1;
        }
    }

    private void addDetailCompToList(MetaComponent component, List<MetaComponent> allDetailComps) {
        if (!allDetailComps.contains(component)) {
            allDetailComps.add(component);
        }
        if (component.getComponentCount() > 0) {
            int i = 0;
            while (i < component.getComponentCount()) {
                MetaComponent subComp = component.getComponent(i);
                this.addDetailCompToList(subComp, allDetailComps);
                ++i;
            }
        }
    }

    public void setMoudelPanel(int panel, String panelKey) throws Throwable {
        boolean isSetKeyAndCaption = this.isSetKeyAndCaption();
        if (String.valueOf(panel).length() == 4) {
            panel = Integer.parseInt(String.valueOf(panel).substring(0, 3));
        }
        String controlType = ControlType.toString((Integer)panel);
        RichDocumentContext midContext = this.getMidContext();
        RichDocument document = midContext.getRichDocument();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        int i = 1;
        while (i < 20) {
            MetaForm form = this.getMidContext().getMetaFactory().getMetaForm(para);
            form.doPostProcess(-1, null);
            List allComponents = form.getAllComponents();
            ArrayList<MetaComponent> allDetailComps = new ArrayList<MetaComponent>();
            int j = 0;
            while (j < form.getAllDetailComponents().size()) {
                MetaComponent component = (MetaComponent)form.getAllDetailComponents().get(j);
                this.addDetailCompToList(component, allDetailComps);
                ++j;
            }
            allComponents.addAll(allDetailComps);
            DataTable dataTable = document.getDataTable(panelKey);
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            int b = 1;
            for (MetaComponent all : allComponents) {
                String key = all.getKey();
                if (key.equalsIgnoreCase("Head" + controlType + i)) {
                    ++i;
                }
                map.put(++b, key);
            }
            if (!map.containsValue("Head" + controlType + i)) {
                if (isSetKeyAndCaption) {
                    dataTable.setString("Key", "Head" + controlType + i);
                    dataTable.setString("Caption", "Head" + controlType + i);
                }
                document.addDirtyTableFlag(panelKey);
                return;
            }
            if (isSetKeyAndCaption) {
                dataTable.setString("Key", "Head" + controlType + i + 1);
                dataTable.setString("Caption", "Head" + controlType + i + 1);
            }
            ++i;
        }
        document.addDirtyTableFlag(panelKey);
    }

    public boolean isMergeToSource() throws Throwable {
        RichDocumentContext midContext = this.getMidContext();
        RichDocument document = midContext.getRichDocument();
        DataTable dataTable = document.getDataTable("ED_NewForm");
        String associationForm = dataTable.getString("AssociationForm");
        MetaFormList metaFormList = midContext.getMetaFactory().getMetaFormList();
        for (MetaFormProfile metaFormProfile : metaFormList) {
            if (!metaFormProfile.getMergeToSource().booleanValue() || !associationForm.equalsIgnoreCase(metaFormProfile.getExtend())) continue;
            return false;
        }
        return true;
    }

    public String getAllItems() throws Throwable {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("\u8bf7\u9009\u62e9\u521b\u5efa\u8def\u5f84", "\u8bf7\u9009\u62e9\u521b\u5efa\u8def\u5f84");
        MetaEntry metaEntry = this.getMidContext().getMetaFactory().getEntryList("");
        String pEntryKey = "";
        String pEntryCaption = "";
        DesignActionUtil.getEntryItems(linkedHashMap, metaEntry, pEntryKey, pEntryCaption);
        return linkedHashMap.toString().replaceAll(",", ";").replaceAll("=", ",").replaceAll(" ", "").replaceAll("\\{", "").replaceAll("\\}", "").replaceAll("\\+", "=");
    }

    public static void getEntryItems(LinkedHashMap<String, String> linkedHashMap, MetaEntry metaEntry, String pEntryKey, String pEntryCaption) throws Throwable {
        int i = 0;
        while (i < metaEntry.size()) {
            AbstractCompositeObject abstractCompositeObject = metaEntry.get(i);
            if (abstractCompositeObject instanceof MetaEntry) {
                DesignActionUtil.findItems(linkedHashMap, (MetaEntry)abstractCompositeObject, pEntryCaption, pEntryKey);
            }
            ++i;
        }
    }

    public String getSideKeys(String parentKey, String filePath) throws Throwable {
        if (StringUtils.isBlank((CharSequence)parentKey) || StringUtils.isBlank((CharSequence)filePath)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("last").append(",").append("last").append(" ").append("\u672b\u5c3e\u8ffd\u52a0").append(";");
        sb.append("first").append(",").append("first").append(" ").append("\u8d77\u9996\u8ffd\u52a0");
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePathNotLoadTmp(filePath);
        com.bokesoft.yes.design.xml.node.TagNode tagNode = xmlTreeWithPath.xmlTree.getTagNode("Entry@" + parentKey);
        for (AbstractNode child : tagNode.getChildren()) {
            com.bokesoft.yes.design.xml.node.TagNode child1;
            String key;
            if (!(child instanceof com.bokesoft.yes.design.xml.node.TagNode) || StringUtils.isEmpty((CharSequence)(key = (child1 = (com.bokesoft.yes.design.xml.node.TagNode)child).getAttributes().get("Key")))) continue;
            String caption = child1.getAttributes().get("Caption");
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(key).append(",").append(key).append(" ").append(String.valueOf(caption) + "\u7684\u540e\u9762");
        }
        return sb.toString();
    }

    public static void findItems(LinkedHashMap<String, String> linkedHashMap, MetaEntry metaEntry, String pEntryCaption, String pEntryKey) throws Throwable {
        String pEntryKeys = String.valueOf(pEntryKey) + "/Entry[@Key+'" + metaEntry.getKey() + "']";
        String pEntryCaptions = String.valueOf(pEntryCaption) + "/" + metaEntry.getCaption();
        linkedHashMap.put(pEntryKeys, pEntryCaptions);
        if (metaEntry.size() != 0) {
            int j = 0;
            while (j < metaEntry.size()) {
                if (metaEntry.get(j) instanceof MetaEntry) {
                    DesignActionUtil.findItems(linkedHashMap, (MetaEntry)metaEntry.get(j), pEntryCaptions, pEntryKeys);
                }
                ++j;
            }
        }
    }

    public String getAllTableKey() throws Throwable {
        StringBuilder str = new StringBuilder(256).append("\u65e0\u6570\u636e\u8868,\u65e0\u6570\u636e\u8868");
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSource = metaForm.getDataSource();
        MetaTableCollection tableCollection = null;
        if (dataSource != null) {
            tableCollection = dataSource.getDataObject().getTableCollection();
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        }
        if (tableCollection != null) {
            for (MetaTable metaTable : tableCollection) {
                String tableKey = metaTable.getKey();
                if (DesignActionUtil.hasEmbedTable(metaForm, metaTable, "")) continue;
                String caption = metaTable.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                StringBuilder rowStr = new StringBuilder().append(";").append(tableKey).append(",").append(tableKey).append(" ").append(caption);
                str = str.append((CharSequence)rowStr);
            }
            return str.toString();
        }
        return str.toString();
    }

    public String getTableKey() throws Throwable {
        StringBuilder str = new StringBuilder(256);
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSource = metaForm.getDataSource();
        MetaTableCollection tableCollection = null;
        if (dataSource != null) {
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        }
        if (tableCollection != null) {
            for (MetaTable metaTable : tableCollection) {
                String tableKey = metaTable.getKey();
                if (DesignActionUtil.hasEmbedTable(metaForm, metaTable, "")) continue;
                String caption = metaTable.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                StringBuilder rowStr = new StringBuilder().append(";").append(tableKey).append(",").append(tableKey).append(" ").append(caption);
                str = str.append((CharSequence)rowStr);
            }
            return str.toString();
        }
        return str.toString();
    }

    public String getTableKey(String parentCompKey) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getPara("OwnerFormKey");
        String containerKey = (String)midContext.getPara("ContainerKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSource = metaForm.getDataSource();
        MetaTableCollection tableCollection = null;
        if (dataSource != null) {
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        }
        if (tableCollection != null) {
            for (MetaTable metaTable : tableCollection) {
                if (metaTable.getKey().endsWith("_NODB")) continue;
                String tableKey = metaTable.getKey();
                if (DesignActionUtil.hasEmbedTable(metaForm, metaTable, parentCompKey)) continue;
                String caption = metaTable.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                StringBuilder rowStr = new StringBuilder().append(";").append(tableKey).append(",").append(tableKey).append(" ").append(caption);
                str = str.append((CharSequence)rowStr);
            }
            return str.toString();
        }
        return str.toString();
    }

    public static boolean hasEmbedTable(MetaForm metaForm, MetaTable metaTable, String parentCompKey) throws Throwable {
        return false;
    }

    public String getRootKey(String formKey) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        if (StringUtils.isEmpty((CharSequence)formKey) || "continue".equalsIgnoreCase(formKey)) {
            return str.toString();
        }
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(formKey);
        IDLookup idLookup = IDLookup.reloadIDLookup(metaForm);
        StringHashMap<String> panelKeys = idLookup.getPanelKeys();
        for (Map.Entry stringStringEntry : panelKeys.entrySet()) {
            String key = (String)stringStringEntry.getKey();
            String caption = (String)stringStringEntry.getValue();
            if (StringUtils.isEmpty((CharSequence)caption)) {
                caption = key;
            }
            StringBuilder rowStr = new StringBuilder().append(";").append(key).append(",").append(key).append("   ").append(caption);
            str.append((CharSequence)rowStr);
        }
        return str.toString();
    }

    public boolean showNewColumnButton() throws Throwable {
        RichDocumentContext midContext = this.getMidContext();
        String ownerFormKey = (String)midContext.getPara("OwnerFormKey");
        String gridKey = (String)midContext.getPara("GridKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(ownerFormKey);
        MetaGrid metaGrid = (MetaGrid)metaForm.getAllUIComponents().get(gridKey);
        return !metaGrid.getTableKey().contains("_NODB");
    }

    public String getAllColumnKey(String tableKey, boolean isDataObject) throws Throwable {
        StringBuilder str = new StringBuilder(256).append("\u65e0\u5b57\u6bb5,\u65e0\u5b57\u6bb5");
        if (StringUtils.isBlank((CharSequence)tableKey)) {
            return str.toString();
        }
        String formKey = this.getMidContext().getFormKey();
        if (formKey.equals("D_DataObject")) {
            DataTable dataTable = this.getMidContext().getRichDocument().get("ED_TableFields");
            DataTable ed_tableCollection = this.getMidContext().getRichDocument().get("ED_TableCollection");
            Long OID = 0L;
            int i = 0;
            while (i < ed_tableCollection.size()) {
                String tableMark = ed_tableCollection.getString(i, "TableMark");
                if (tableMark.equalsIgnoreCase(tableKey)) {
                    OID = ed_tableCollection.getLong(i, "OID");
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < dataTable.size()) {
                String columnKey = dataTable.getString(i, "ColumnKey");
                Long poid = dataTable.getLong(i, "POID");
                if (Objects.equals(poid, OID) && !"MapCount".equals(columnKey) && !"SelectField".equals(columnKey)) {
                    String caption = dataTable.getString(i, "ColumnName");
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                    StringBuilder columnStr = new StringBuilder().append(";").append(columnKey).append(",").append(columnKey).append(" ").append(caption);
                    str = str.append((CharSequence)columnStr);
                }
                ++i;
            }
        } else {
            RichDocumentContext midContext = this.getMidContext();
            String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
            String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
            MetaTable table = null;
            if (isDataObject) {
                table = this.getMidContext().getMetaFactory().getDataObject(para).getMetaTable(tableKey);
            } else {
                MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
                MetaDataSource dataSourse = metaForm.getDataSource();
                if (dataSourse != null) {
                    table = dataSourse.getDataObject().getTable(tableKey);
                } else if (containerKey != null && !containerKey.isEmpty()) {
                    String OtherKey = containerKey;
                    metaForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
                    table = metaForm.getDataSource().getDataObject().getTable(tableKey);
                }
            }
            if (Objects.isNull(table)) {
                return str.toString();
            }
            DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(table);
            DataTableMetaData dataTableMetaData = dataTable.getMetaData();
            int i = 0;
            int len = dataTableMetaData.getColumnCount();
            while (i < len) {
                MetaColumn metaColumn;
                ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
                String columnKey = columnInfo.getColumnKey();
                if (!"MapCount".equals(columnKey) && !"SelectField".equals(columnKey) && (metaColumn = (MetaColumn)table.get(columnKey)) != null) {
                    String caption = metaColumn.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                    StringBuilder columnStr = new StringBuilder().append(";").append(columnKey).append(",").append(columnKey).append(" ").append(caption);
                    str = str.append((CharSequence)columnStr);
                }
                ++i;
            }
        }
        return str.toString();
    }

    public String getAllColumnKey(String tableKey) throws Throwable {
        return this.getAllColumnKey(tableKey, false);
    }

    public String getExpandAllColumnKey() throws Throwable {
        String gridTableKey;
        StringBuilder result = new StringBuilder(256).append("\u65e0\u5b57\u6bb5,\u65e0\u5b57\u6bb5");
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
        String OtherKey = null;
        if (containerKey != null && containerKey.length() > 0 && !"null".equals(containerKey)) {
            OtherKey = containerKey;
        }
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        MetaForm containerForm = null;
        if (OtherKey != null) {
            containerForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
        }
        if (!StringUtils.isBlank((CharSequence)(gridTableKey = IOMetaObject.getGridTableKey())) && !gridTableKey.endsWith("_NODB")) {
            MetaTable metaTable = null;
            if (Objects.isNull(metaForm.getDataSource()) || containerForm != null) {
                metaTable = containerForm.getDataSource().getDataObject().getTable(gridTableKey);
            } else if (Objects.isNull(metaTable)) {
                metaTable = metaForm.getDataSource().getDataObject().getTable(gridTableKey);
            }
            for (MetaColumn metaColumn : metaTable) {
                String caption = metaColumn.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                String columnKey = metaColumn.getKey();
                if ("MapCount".equals(columnKey) || "SelectField".equals(columnKey) || columnKey.endsWith("_NODB")) continue;
                result.append(";").append(columnKey).append(",").append(columnKey).append(" ").append(caption);
            }
        }
        return result.toString();
    }

    public String getDropField(String ItemKey) throws Throwable {
        if (StringUtils.isEmpty((CharSequence)ItemKey)) {
            return "";
        }
        HashMap<String, String> siftout = new HashMap<String, String>(64);
        siftout.put("SOID", "SOID");
        siftout.put("POID", "POID");
        siftout.put("VERID", "VERID");
        siftout.put("DVERID", "DVERID");
        siftout.put("ERPMapCount", "ERPMapCount");
        siftout.put("MapCount", "MapCount");
        StringBuilder dropData = new StringBuilder(512);
        MetaDataObject metaForm = this.getMidContext().getMetaFactory().getDataObject(ItemKey);
        if (Objects.isNull(metaForm)) {
            return "";
        }
        MetaTableCollection metatablecollection = metaForm.getTableCollection();
        MetaTable metatable = (MetaTable)metatablecollection.get(0);
        Iterator iterator = metatable.entryIterator();
        DataMap.clear();
        int x = 0;
        while (x < metatable.size()) {
            Map.Entry entry;
            String key;
            if (iterator.hasNext() && !siftout.containsKey(key = (String)(entry = (Map.Entry)iterator.next()).getKey())) {
                String caption = ((MetaColumn)entry.getValue()).getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                dropData.append(key).append(",").append(key).append(" ").append(caption).append(";");
                DataMap.put(key, key);
            }
            ++x;
        }
        return dropData.toString();
    }

    public String getGridFiled(String gridKey) throws Throwable {
        StringBuilder str = new StringBuilder(256).append(", ");
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String compKey = (String)midContext.getDefaultContext().getPara("compKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        MetaGrid metaGrid = (MetaGrid)metaForm.getAllUIComponents().get(compKey);
        MetaTable metaColumns = metaForm.getDataSource().getDataObject().getTable(metaGrid.getTableKey());
        for (MetaColumn metaColumn : metaColumns) {
            String caption = metaColumn.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            StringBuilder columnStr = new StringBuilder().append(";").append(metaColumn.getKey()).append(",").append(metaColumn.getKey()).append(" ").append(caption);
            str = str.append((CharSequence)columnStr);
        }
        return str.toString();
    }

    public String getItemKey() throws Throwable {
        return this.getItemKey(false);
    }

    public String getItemKey(boolean excludeBillItemKey) throws Throwable {
        StringBuilder rowStr;
        String caption;
        MetaFormList metaForm = this.getMidContext().getMetaFactory().getMetaFormList();
        StringBuilder str = new StringBuilder(256);
        for (MetaFormProfile meta : metaForm) {
            if (meta.getFormType() != 2 && meta.getFormType() != 6 && meta.getFormType() != 7) continue;
            if (meta.getForm() == null) {
                this.getMidContext().getMetaFactory().getMetaForm(meta.getKey());
            }
            MetaDataSource metadatasource = meta.getForm().getDataSource();
            caption = meta.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            if (metadatasource != null) {
                String refobjectkey = metadatasource.getRefObjectKey();
                if (refobjectkey == "") {
                    rowStr = new StringBuilder().append(";").append(metadatasource.getDataObject().getKey()).append(",").append(metadatasource.getDataObject().getKey()).append(" ").append(caption);
                    str = str.append((CharSequence)rowStr);
                    continue;
                }
                rowStr = new StringBuilder().append(";").append(refobjectkey).append(",").append(refobjectkey).append(" ").append(caption);
                str = str.append((CharSequence)rowStr);
                continue;
            }
            rowStr = new StringBuilder().append(";").append(meta.getKey()).append(",").append(meta.getKey()).append(" ").append(caption);
            str = str.append((CharSequence)rowStr);
        }
        MetaDataObjectList metaDataObjectProfiles = this.getMidContext().getMetaFactory().getDataObjectList();
        for (MetaDataObjectProfile metaDataObjectProfile : metaDataObjectProfiles) {
            if (metaDataObjectProfile.getSecondaryType() != 5 && metaDataObjectProfile.getSecondaryType() != 3 || excludeBillItemKey && metaDataObjectProfile.getSecondaryType() == 5 && !metaForm.containsKey(metaDataObjectProfile.getKey())) continue;
            caption = metaDataObjectProfile.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            rowStr = new StringBuilder().append(";").append(metaDataObjectProfile.getKey()).append(",").append(metaDataObjectProfile.getKey()).append(" ").append(caption);
            if (str.indexOf(rowStr.toString()) != -1) continue;
            str = str.append((CharSequence)rowStr);
        }
        return str.toString();
    }

    public String getParentItemKey() throws Throwable {
        String key = "";
        if (this.getDocument().getDataTable("ED_Component") != null && this.getDocument().getDataTable("ED_Component").size() != 0) {
            key = this.getDocument().getDataTable("ED_Component").getString(0, "getKey");
        }
        StringBuilder str = new StringBuilder(256).append(", ");
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        Collection<String> fieldKeys = idLookup.getFieldKeys();
        for (String fieldKey : fieldKeys) {
            String columnKeyByFieldKey;
            int fieldControlType;
            if (fieldKey.isEmpty()) continue;
            MetaGridCell cell = null;
            MetaComponent component = idLookup.getComponentByKey(fieldKey);
            if (Objects.isNull(component)) {
                cell = idLookup.getGridCellByKey(fieldKey);
            } else {
                fieldControlType = component.getControlType();
                if (206 == fieldControlType && !fieldKey.equals(key)) {
                    columnKeyByFieldKey = idLookup.getFieldCaption(fieldKey);
                    str.append(";").append(fieldKey).append(",").append(fieldKey).append(" ").append(columnKeyByFieldKey);
                }
            }
            if (Objects.isNull(cell) || 206 != (fieldControlType = cell.getCellType().intValue()) || fieldKey.equals(key)) continue;
            columnKeyByFieldKey = idLookup.getFieldCaption(fieldKey);
            str.append(";").append(fieldKey).append(",").append(fieldKey).append(" ").append(columnKeyByFieldKey);
        }
        return str.toString();
    }

    public String getDictItem(String Key2) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        String gridKey = idLookup.getGridKeyByFieldKey(Key2);
        if (StringUtils.isNotEmpty((CharSequence)gridKey)) {
            MetaGrid metaGrid = idLookup.getMetaGridByGridKey(gridKey);
            MetaGridRowCollection rowCollection = metaGrid.getRowCollection();
            for (MetaGridRow metaGridRow : rowCollection) {
                for (MetaGridCell metaGridCell : metaGridRow) {
                    if (206 != metaGridCell.getCellType() && 241 != metaGridCell.getCellType()) continue;
                    String caption = metaGridCell.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                    str.append(metaGridCell.getKey()).append(",").append(caption).append(";");
                }
            }
        }
        return StringUtils.isBlank((CharSequence)str) ? str.toString() : str.substring(0, str.length() - 1);
    }

    public String getRadioGourpKey() throws Throwable {
        StringBuilder str = new StringBuilder(256);
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        List<MetaComponent> allComponent = idLookup.getAllComponent();
        for (MetaComponent metaComponent : allComponent) {
            if (!(metaComponent instanceof MetaRadioButton) || !((MetaRadioButton)metaComponent).isGroupHead().booleanValue()) continue;
            String key = ((MetaRadioButton)metaComponent).getGroupKey();
            StringBuilder columnStr = new StringBuilder().append(";").append(key).append(",").append(key);
            str = str.append((CharSequence)columnStr);
        }
        return str.toString();
    }

    public String getAllGridCellKey() throws Throwable {
        StringBuilder str = new StringBuilder(256).append(",");
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        List metaGridCells = metaForm.getAllGridCells();
        for (MetaGridCell metaGridCell : metaGridCells) {
            if ("\u5220\u9664".equals(metaGridCell.getCaption()) || "\u9009\u62e9".equals(metaGridCell.getCaption())) continue;
            String key = metaGridCell.getKey();
            StringBuilder columnStr = new StringBuilder().append(";").append(key).append(",").append(key);
            str = str.append((CharSequence)columnStr);
        }
        return str.toString();
    }

    public String getRowGroupGridCellKey() throws Throwable {
        StringBuilder str = new StringBuilder(256).append(",");
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        List metaGridCells = metaForm.getAllGridCells();
        for (MetaGridCell metaGridCell : metaGridCells) {
            if ("\u5220\u9664".equals(metaGridCell.getCaption()) || "\u9009\u62e9".equals(metaGridCell.getCaption()) || metaGridCell.getCellGroupType() != 1) continue;
            String key = metaGridCell.getKey();
            StringBuilder columnStr = new StringBuilder().append(";").append(key).append(",").append(key);
            str = str.append((CharSequence)columnStr);
        }
        return str.toString();
    }

    public String getTreeGridCell() throws Throwable {
        StringBuilder str = new StringBuilder(256).append(",");
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String selectComKey = (String)midContext.getDefaultContext().getPara("parentKey");
        String rowKey = (String)midContext.getDefaultContext().getPara("compKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        MetaGrid metaGrid = (MetaGrid)metaForm.componentByKey(selectComKey);
        MetaGridRow metaGridRow = null;
        for (MetaGridRow metaGridCells : metaGrid.getRowCollection()) {
            if (!metaGridCells.getKey().equalsIgnoreCase(rowKey)) continue;
            metaGridRow = metaGridCells;
            break;
        }
        for (MetaGridCell metaGridCell : metaGridRow) {
            if ("\u5220\u9664".equals(metaGridCell.getCaption())) continue;
            String key = metaGridCell.getKey();
            StringBuilder columnStr = new StringBuilder().append(";").append(key).append(",").append(key);
            str = str.append((CharSequence)columnStr);
        }
        return str.toString();
    }

    public String getColumns() throws Throwable {
        StringBuilder str = new StringBuilder(256).append("\u65e0,\u65e0");
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String selectComKey = (String)midContext.getDefaultContext().getPara("parentKey");
        String rowKey = (String)midContext.getDefaultContext().getPara("compKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        MetaGrid metaGrid = (MetaGrid)metaForm.componentByKey(selectComKey);
        MetaGridRow metaGridRow = null;
        for (MetaGridRow metaGridCells : metaGrid.getRowCollection()) {
            if (!metaGridCells.getKey().equalsIgnoreCase(rowKey)) continue;
            metaGridRow = metaGridCells;
            break;
        }
        String tableKey = metaGridRow.getTableKey();
        if (StringUtils.isBlank((CharSequence)tableKey)) {
            return str.toString();
        }
        MetaTable table = metaForm.getDataSource().getDataObject().getTable(tableKey);
        if (Objects.isNull(table)) {
            return str.toString();
        }
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(table);
        DataTableMetaData dataTableMetaData = dataTable.getMetaData();
        int i = 0;
        int len = dataTableMetaData.getColumnCount();
        while (i < len) {
            MetaColumn metaColumn;
            ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
            String columnKey = columnInfo.getColumnKey();
            if (!"MapCount".equals(columnKey) && !"SelectField".equals(columnKey) && (metaColumn = (MetaColumn)table.get(columnKey)) != null) {
                String caption = metaColumn.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                StringBuilder columnStr = new StringBuilder().append(";").append(columnKey).append(",").append(columnKey).append(" ").append(caption);
                str = str.append((CharSequence)columnStr);
            }
            ++i;
        }
        return str.toString();
    }

    public String getDynamicDictItemKey(String key) throws Throwable {
        StringBuilder columnStr;
        int i;
        StringBuilder str = new StringBuilder(256).append(", ");
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        Collection<String> fieldKeys = idLookup.getFieldKeys();
        MetaGridRow gridCells = null;
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            block0: for (MetaGrid metaGrid : idLookup.getMetaGrids()) {
                MetaGridCell gridCellByKey = idLookup.getGridCellByKey(key);
                i = 0;
                while (i < metaGrid.getRowCollection().size()) {
                    if (((MetaGridRow)metaGrid.getRowCollection().get(i)).indexOf((AbstractMetaObject)gridCellByKey) != -1) {
                        gridCells = (MetaGridRow)metaGrid.getRowCollection().get(i);
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        if (gridCells != null) {
            for (MetaGridCell gridCell : gridCells) {
                String caption = gridCell.getCaption();
                if ((!StringUtils.isNotEmpty((CharSequence)gridCell.getColumnKey()) || !gridCell.getColumnKey().endsWith("ItemKey")) && !gridCell.getKey().endsWith("ItemKey")) continue;
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                columnStr = new StringBuilder().append(";").append(gridCell.getKey()).append(",").append(gridCell.getKey()).append(" ").append(caption);
                str = str.append((CharSequence)columnStr);
            }
        }
        Object gridKey = midContext.getDefaultContext().getPara("GridKey");
        Object parentCompKey = midContext.getDefaultContext().getPara("ParentCompKey");
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)gridKey)) && StringUtils.isEmpty((CharSequence)((CharSequence)parentCompKey))) {
            MetaGrid metaGrid = (MetaGrid)metaForm.componentByKey((String)gridKey);
            i = 0;
            while (i < metaGrid.getRowCollection().size()) {
                MetaGridRow metaGridRow = (MetaGridRow)metaGrid.getRowCollection().get(i);
                if (metaGridRow.getRowType() == 2) {
                    for (MetaGridCell metaGridCell : metaGridRow) {
                        String caption = metaGridCell.getCaption();
                        if ((!StringUtils.isNotEmpty((CharSequence)metaGridCell.getColumnKey()) || !metaGridCell.getColumnKey().endsWith("ItemKey")) && !metaGridCell.getKey().endsWith("ItemKey")) continue;
                        caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                        caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                        columnStr = new StringBuilder().append(";").append(metaGridCell.getKey()).append(",").append(metaGridCell.getKey()).append(" ").append(caption);
                        str = str.append((CharSequence)columnStr);
                    }
                }
                ++i;
            }
        }
        for (String fieldKey : fieldKeys) {
            MetaComponent componentByKey = idLookup.getComponentByKey(fieldKey);
            if (Objects.isNull(componentByKey) || (!StringUtils.isNotEmpty((CharSequence)componentByKey.getColumnKey()) || !componentByKey.getColumnKey().endsWith("ItemKey")) && !componentByKey.getKey().endsWith("ItemKey") || componentByKey.getControlType() != 206 && componentByKey.getControlType() != 204 && componentByKey.getControlType() != 201 && componentByKey.getControlType() != 213 && componentByKey.getControlType() != 215) continue;
            String columnKeyByFieldKey = idLookup.getFieldCaption(fieldKey);
            columnStr = new StringBuilder().append(";").append(fieldKey).append(",").append(fieldKey).append(" ").append(columnKeyByFieldKey);
            str = str.append((CharSequence)columnStr);
        }
        return str.toString();
    }

    public Boolean setEnable(String compKey, String cellType) throws Throwable {
        String para = (String)this.getMidContext().getDefaultContext().getPara("OwnerFormKey");
        IMetaFactory globalInstance = this.getMidContext().getMetaFactory();
        MetaFormProfile metaFormProfile = (MetaFormProfile)globalInstance.getMetaFormList().get(para);
        MetaForm metaForm = globalInstance.getMetaForm(para);
        Boolean isMerge = metaFormProfile.getMergeToSource();
        if (StringUtils.isNotEmpty((CharSequence)metaForm.getExtend())) {
            if (isMerge.booleanValue()) {
                MetaForm extendMetaForm = globalInstance.getMetaForm(metaForm.getExtend());
                String filePath = LoadFileTree.getPathByFormKey(extendMetaForm.getKey());
                XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(filePath);
                com.bokesoft.yes.design.xml.node.TagNode tagNode = xmlTree.xmlTree.getTagNode(String.valueOf(cellType) + "@" + compKey);
                if (tagNode != null) {
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void returnRowGap() throws Throwable {
        RichDocument doc = this.getMidContext().getRichDocument();
        DataTable table = doc.getDataTable("ED_RowHead");
        DataTable Dtable = doc.getDataTable("ED_RowDetail");
        int Num = table.getInt(0, "RowNum");
        int size = Dtable.size();
        if (Num < Dtable.size()) {
            int i = 0;
            while (i < size - Num) {
                Dtable.delete(size - i - 1);
                doc.addDirtyTableFlag("ED_RowDetail");
                ++i;
            }
        } else {
            int i = 0;
            while (i < Num) {
                if (i >= Dtable.size()) {
                    int newRowIndex = Dtable.insert(i);
                    Dtable.setString(newRowIndex, "RowDefHeight", "30");
                    Dtable.setString(newRowIndex, "Type", "0");
                    Dtable.setNumeric(newRowIndex, "RowNum", BigDecimal.valueOf(1L));
                    Dtable.setNumeric(newRowIndex, "SumNum", BigDecimal.valueOf(i + 1));
                    doc.addDirtyTableFlag("ED_RowDetail");
                }
                ++i;
            }
        }
    }

    public void returnColumnGap() throws Throwable {
        RichDocument doc = this.getMidContext().getRichDocument();
        DataTable table = doc.getDataTable("ED_ColumnHead");
        DataTable Dtable = doc.getDataTable("ED_ColumnDetail");
        int Num = table.getInt(0, "ColumnNum");
        int size = Dtable.size();
        if (Num < Dtable.size()) {
            int i = 0;
            while (i < size - Num) {
                Dtable.delete(size - i - 1);
                doc.addDirtyTableFlag("ED_ColumnDetail");
                ++i;
            }
        } else {
            int i = 0;
            while (i < Num) {
                if (i >= Dtable.size()) {
                    int newRowIndex = Dtable.insert(i);
                    Dtable.setString(newRowIndex, "Width", "80");
                    Dtable.setString(newRowIndex, "Type", "0");
                    Dtable.setNumeric(newRowIndex, "RowNum", BigDecimal.valueOf(1L));
                    Dtable.setNumeric(newRowIndex, "SumNum", BigDecimal.valueOf(i + 1));
                    doc.addDirtyTableFlag("ED_ColumnDetail");
                }
                ++i;
            }
        }
    }

    public String setBindingCellKey() throws Throwable {
        String fieldKey = (String)this.getMidContext().getDefaultContext().getPara("compKey");
        return this.setBindingCellKey(fieldKey);
    }

    public String setBindingCellKey(String fieldKey) throws Throwable {
        MetaTableRow metaTableRow;
        StringBuilder columnStr;
        StringBuilder str = new StringBuilder(256).append(",").append("\u65e0\u5173\u8054\u8868");
        String currentFormKey = IOMetaObject.currentFormKey;
        String para = (String)this.getMidContext().getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)this.getMidContext().getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLoopup = IDLookup.getIDLookup(metaForm);
        MetaComponent metaComponent = null;
        if (idLoopup.containFieldKey(fieldKey)) {
            metaComponent = idLoopup.getComponentByKey(fieldKey);
        } else if (Objects.isNull(metaComponent) && containerKey != null) {
            String OtherKey = containerKey;
            metaForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
            idLoopup = IDLookup.getIDLookup(metaForm);
            metaComponent = idLoopup.getComponentByKey(fieldKey);
        }
        String parentGridKeyLU = IOMetaObject.FindSubDetail(metaForm, metaComponent);
        MetaGrid metaGrid = idLoopup.getMetaGridByGridKey(parentGridKeyLU);
        if (StringUtils.isNotEmpty((CharSequence)currentFormKey) && !currentFormKey.equalsIgnoreCase(para)) {
            MetaForm parenMetaForm = this.getMidContext().getMetaFactory().getMetaForm(currentFormKey);
            IDLookup parenLookup = IDLookup.getIDLookup(parenMetaForm);
            MetaGrid metaGridByGridKey = parenLookup.getMetaGridByGridKey(parentGridKeyLU);
            if (Objects.isNull(metaGridByGridKey)) {
                List embeds = parenMetaForm.getEmbeds();
                for (MetaEmbed embed : embeds) {
                    String formKey = embed.getFormKey();
                    MetaForm metaForm1 = this.getMidContext().getMetaFactory().getMetaForm(formKey);
                    IDLookup embedLookup = IDLookup.getIDLookup(metaForm1);
                    MetaGrid metaGridByGridKey1 = embedLookup.getMetaGridByGridKey(parentGridKeyLU);
                    if (metaGridByGridKey1 == null) continue;
                    metaGrid = metaGridByGridKey1;
                    break;
                }
            } else {
                metaGrid = metaGridByGridKey;
            }
        }
        if (metaGrid != null) {
            MetaGridColumnCollection columnCollection = metaGrid.getColumnCollection();
            int j = 0;
            while (j < columnCollection.size()) {
                String key1 = ((MetaGridColumn)columnCollection.get(j)).getKey();
                String caption = ((MetaGridColumn)columnCollection.get(j)).getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                columnStr = new StringBuilder().append(";").append(key1).append(",").append(key1).append(" ").append(caption);
                str.append((CharSequence)columnStr);
                ++j;
            }
        }
        if ((metaTableRow = idLoopup.getMetaTableDetailRowByRowKey(parentGridKeyLU)) != null) {
            ArrayList<MetaComponent> compListInRow = new ArrayList<MetaComponent>();
            this.addCompToList(metaTableRow.getRoot(), compListInRow);
            for (MetaComponent comp : compListInRow) {
                if (comp.isPanel()) continue;
                String key1 = comp.getKey();
                String caption = comp.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                columnStr = new StringBuilder().append(";").append(key1).append(",").append(key1).append(" ").append(caption);
                str.append((CharSequence)columnStr);
            }
        }
        return str.toString();
    }

    private void addCompToList(MetaComponent metaComponent, ArrayList<MetaComponent> list) {
        list.add(metaComponent);
        if (metaComponent.isPanel() && metaComponent.getComponentCount() > 0) {
            int i = 0;
            while (i < metaComponent.getComponentCount()) {
                MetaComponent subComp = metaComponent.getComponent(i);
                this.addCompToList(subComp, list);
                ++i;
            }
        }
    }

    public void setMacro() throws Throwable {
        int b = 0;
        RichDocument document = this.getMidContext().getRichDocument();
        DataTable dataTable = document.getDataTable("ED_MacroFormula");
        dataTable.append();
        int i = 0;
        while (i < dataTable.size()) {
            String keyDetail = dataTable.getString(i, "Key");
            if (keyDetail != null && keyDetail.indexOf("MacroKey") != -1) {
                dataTable.setString("Key", "MacroKey" + ++b);
            } else if (keyDetail == null) {
                dataTable.setString("Key", "MacroKey" + (b + 1));
            } else {
                dataTable.setString("Key", "MacroKey" + b);
            }
            ++i;
        }
        document.addDirtyTableFlag("ED_NewMacroDetail");
    }

    public Boolean isHaveDataSource() throws Throwable {
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String gridKey = (String)midContext.getDefaultContext().getPara("GridKey");
        MetaForm form = this.getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLookup = IDLookup.getIDLookup(form);
        MetaGrid parentGrid = idLookup.getMetaGridByGridKey(gridKey);
        if (StringUtils.isNotEmpty((CharSequence)parentGrid.getTableKey()) && !parentGrid.getTableKey().contains("_NODB")) {
            return true;
        }
        return false;
    }

    public void setSelect() throws Throwable {
        int b = 0;
        RichDocument document = this.getMidContext().getRichDocument();
        DataTable dataTable = document.getDataTable("ED_ComboBoxDetail");
        dataTable.append();
        int i = 0;
        while (i < dataTable.size()) {
            String key = dataTable.getString(i, "Key");
            if (key != null && key.indexOf("Line") != -1) {
                dataTable.setString("Key", "Line" + ++b);
            } else if (key == null) {
                dataTable.setString("Key", "Line" + (b + 1));
            } else {
                dataTable.setString("Key", "Line" + b);
            }
            ++i;
        }
        document.addDirtyTableFlag("ED_ComboBoxDetail");
    }

    public void setDictViewColumn() throws Throwable {
        int b = 0;
        RichDocument document = this.getMidContext().getRichDocument();
        DataTable dataTable = document.getDataTable("ED_DictViewColumn");
        dataTable.append();
        int i = 0;
        while (i < dataTable.size()) {
            String key = dataTable.getString(i, "Key");
            if (key != null && key.indexOf("Line") != -1) {
                dataTable.setString("Key", "Line" + ++b);
            } else if (key == null) {
                dataTable.setString("Key", "Line" + (b + 1));
            } else {
                dataTable.setString("Key", "Line" + b);
            }
            ++i;
        }
        document.addDirtyTableFlag("ED_DictViewColumn");
    }

    public void setRow(String rowType) throws Throwable {
        String controlType = RowType.toString((Integer)Integer.parseInt(rowType));
        RichDocumentContext midContext = this.getMidContext();
        RichDocument document = midContext.getRichDocument();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup loopUp = IDLookup.getIDLookup(metaForm);
        DataTable dataTable = document.getDataTable("ED_NewRow");
        List<MetaGrid> metaGridList = loopUp.getMetaGrids();
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int b = 0;
        int i = 0;
        while (i < dataTable.size()) {
            for (MetaGrid grid : metaGridList) {
                MetaGridRowCollection metaGridRows = grid.getRowCollection();
                for (MetaGridRow metaGridRow : metaGridRows) {
                    String key = metaGridRow.getKey();
                    if (key.indexOf(controlType) != -1) {
                        ++i;
                    }
                    map.put(++b, key);
                }
            }
            if (map.containsValue(String.valueOf(controlType) + i)) {
                dataTable.setString("Key", String.valueOf(controlType) + (i + 1));
                dataTable.setString("Caption", String.valueOf(controlType) + (i + 1));
            } else {
                dataTable.setString("Key", String.valueOf(controlType) + i);
                dataTable.setString("Caption", String.valueOf(controlType) + i);
                document.addDirtyTableFlag("ED_NewRow");
            }
            ++i;
        }
    }

    public Boolean setEnable() throws Throwable {
        String para = (String)this.getMidContext().getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)this.getMidContext().getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLoopup = IDLookup.getIDLookup(metaForm);
        String fieldKey = (String)this.getMidContext().getDefaultContext().getPara("compKey");
        MetaComponent metaComponent = null;
        if (idLoopup.containFieldKey(fieldKey)) {
            metaComponent = idLoopup.getComponentByKey(fieldKey);
        } else if (Objects.isNull(metaComponent) && StringUtils.isNotBlank((CharSequence)containerKey)) {
            metaForm = this.getMidContext().getMetaFactory().getMetaForm(containerKey);
            idLoopup = IDLookup.getIDLookup(metaForm);
            metaComponent = idLoopup.getComponentByKey(fieldKey);
        }
        String parentGridKeyLU = IOMetaObject.FindSubDetail(metaForm, metaComponent);
        if (!"".equals(parentGridKeyLU)) {
            return true;
        }
        return false;
    }

    public Boolean setVestEnable() throws Throwable {
        String para = (String)this.getMidContext().getDefaultContext().getPara("OwnerFormKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        if (StringUtils.isBlank((CharSequence)metaForm.getExtend())) {
            return false;
        }
        return true;
    }

    public boolean isExtend() throws Throwable {
        String formKey = (String)this.getMidContext().getDefaultContext().getPara("OwnerFormKey");
        MetaForm form1 = null;
        MetaFormProfile metaFormProfile = (MetaFormProfile)this.getMidContext().getMetaFactory().getMetaFormList().get(formKey);
        if (metaFormProfile != null) {
            form1 = ((MetaFormProfile)this.getMidContext().getMetaFactory().getMetaFormList().get(formKey)).getForm();
        }
        String ref = "";
        if (form1 != null && form1.getDataSource() != null) {
            ref = form1.getDataSource().getRefObjectKey();
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        String refFinal = ref;
        this.getMidContext().getMetaFactory().getMetaFormList().forEach(form -> {
            MetaForm form2;
            if (formKey.equals(form.getExtend())) {
                atomicInteger.set(1);
                return;
            }
            if (formKey.equals(form.getExtend()) && (form2 = form.getForm()) != null && form2.getDataSource() != null && StringUtils.isNotEmpty((CharSequence)refFinal) && form2.getDataSource().getDataObject().getKey().equals(refFinal)) {
                atomicInteger.set(2);
                return;
            }
        });
        return atomicInteger.get() != 0;
    }

    public Boolean setTypeEnable() throws Throwable {
        String para = (String)this.getMidContext().getDefaultContext().getPara("OwnerFormKey");
        if (StringUtils.isBlank((CharSequence)para)) {
            return true;
        }
        IMetaFactory globalInstance = this.getMidContext().getMetaFactory();
        MetaDataObject metaDataObject = globalInstance.getDataObject(para);
        if (Objects.isNull(metaDataObject)) {
            MetaForm metaForm = globalInstance.getMetaForm(para);
            MetaDataSource dataSource = metaForm.getDataSource();
            if (dataSource != null) {
                metaDataObject = dataSource.getDataObject();
            } else {
                return false;
            }
        }
        if (metaDataObject.getSecondaryType() == 6) {
            return true;
        }
        return false;
    }

    public String parentTableKey(String tabKey) throws Throwable {
        String str = "0,\u65e0\u6570\u636e\u8868";
        if (StringUtils.isEmpty((CharSequence)tabKey)) {
            return str;
        }
        String rowStr = "";
        RichDocumentContext midContext = this.getMidContext();
        DefaultContext defaultContext = midContext.getDefaultContext();
        String para = (String)defaultContext.getPara("OwnerFormKey");
        String Type2 = (String)defaultContext.getPara("Type");
        String containerKey = (String)defaultContext.getPara("ContainerKey");
        MetaForm metaForm = null;
        MetaDataObject dataObject = null;
        MetaTableCollection tableCollection = null;
        if ("DataObject".equals(Type2)) {
            dataObject = this.getMidContext().getMetaFactory().getDataObject(para);
            if (dataObject != null) {
                tableCollection = dataObject.getTableCollection();
            }
        } else {
            MetaDataSource dataSource;
            metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
            if (Objects.isNull(metaForm.getDataSource()) && containerKey != null) {
                String OtherKey = containerKey;
                metaForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
            }
            if ((dataSource = metaForm.getDataSource()) != null) {
                tableCollection = dataSource.getDataObject().getTableCollection();
            }
        }
        if (tableCollection != null) {
            MetaTable ownerMetaTable = (MetaTable)tableCollection.get(tabKey);
            for (MetaTable metaTable : tableCollection) {
                String tableKey = metaTable.getKey();
                int tableMode = metaTable.getTableMode();
                if (tableKey.equals(tabKey) || tableMode == 0 || tabKey.equalsIgnoreCase(metaTable.getParentKey())) continue;
                String caption = metaTable.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                rowStr = ";" + tableKey + "," + tableKey + " " + caption;
                str = String.valueOf(str) + rowStr;
            }
        }
        return str;
    }

    public boolean checkDataType(String tableKey, String columnKey) throws Throwable {
        if ("\u65e0\u6570\u636e\u8868".equalsIgnoreCase(tableKey) || "\u65e0\u5b57\u6bb5".equalsIgnoreCase(columnKey) || "".equalsIgnoreCase(columnKey)) {
            return true;
        }
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSourse = metaForm.getDataSource();
        MetaTable table = null;
        if (dataSourse != null) {
            table = dataSourse.getDataObject().getTable(tableKey);
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
            table = metaForm.getDataSource().getDataObject().getTable(tableKey);
        }
        if (Objects.isNull(table)) {
            return true;
        }
        MetaColumn metaColumn = (MetaColumn)table.get(columnKey);
        if (Objects.isNull(metaColumn)) {
            return true;
        }
        int dataType = metaColumn.getDataType();
        return 1001 != dataType && 1010 != dataType;
    }

    public String relatedTable(int type) throws Throwable {
        int keylong;
        if (associatedTableMap != null) {
            associatedTableMap.clear();
        }
        String str = "0,\u65b0\u589e\u8868;1,\u65e0\u6570\u636e\u8868";
        String rowStr = "";
        RichDocumentContext midContext = this.getMidContext();
        DefaultContext defaultContext = midContext.getDefaultContext();
        String para = (String)defaultContext.getPara("OwnerFormKey");
        String containerKey = (String)defaultContext.getPara("ContainerKey");
        MetaForm containerForm = null;
        if (containerKey != null && (keylong = containerKey.length()) > 0 && !containerKey.equals("null")) {
            containerForm = this.getMidContext().getMetaFactory().getMetaForm(containerKey);
        }
        int i = 2;
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        if (Objects.isNull(metaForm.getDataSource())) {
            return str;
        }
        String refObjectKey = metaForm.getDataSource().getRefObjectKey();
        if (!refObjectKey.isEmpty()) {
            str = "1,\u65e0\u6570\u636e\u8868";
        }
        MetaTableCollection tableCollection = null;
        tableCollection = Objects.isNull(metaForm.getDataSource()) ? containerForm.getDataSource().getDataObject().getTableCollection() : metaForm.getDataSource().getDataObject().getTableCollection();
        for (MetaTable metaTable : tableCollection) {
            String tableKey = metaTable.getKey();
            int tableMode = metaTable.getTableMode();
            if (type == 2 ? tableMode != 0 : tableMode == 0 && type != 216) continue;
            String caption = metaTable.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            rowStr = ";" + i + "," + tableKey + " " + caption;
            str = String.valueOf(str) + rowStr;
            associatedTableMap.put(i, tableKey);
            ++i;
        }
        associatedTableMap.put(0, "HeadGrade");
        associatedTableMap.put(1, "");
        return str;
    }

    public String condTableKey() throws Throwable {
        StringBuilder str = new StringBuilder(256);
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        if (Objects.isNull(metaForm.getDataSource()) && containerKey != null) {
            String OtherKey = containerKey;
            metaForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
        }
        MetaTableCollection tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        for (MetaTable metaTable : tableCollection) {
            String caption = metaTable.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            StringBuilder rowStr = new StringBuilder().append(";").append(metaTable.getKey()).append(",").append(metaTable.getKey()).append(" ").append(caption);
            str = str.append((CharSequence)rowStr);
        }
        return str.toString();
    }

    public String condColumnKey(String tableKey) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        if (StringUtils.isNotEmpty((CharSequence)tableKey)) {
            MetaTable table;
            RichDocumentContext midContext = this.getMidContext();
            String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
            String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
            MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
            if (Objects.isNull(metaForm.getDataSource()) && containerKey != null) {
                String OtherKey = containerKey;
                metaForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
            }
            if ((table = metaForm.getDataSource().getDataObject().getTable(tableKey)) != null) {
                DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(table);
                DataTableMetaData dataTableMetaData = dataTable.getMetaData();
                int i = 0;
                int len = dataTableMetaData.getColumnCount();
                while (i < len) {
                    ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
                    String columnKey = columnInfo.getColumnKey();
                    if (!columnKey.equals("MapCount") && !columnKey.equals("SelectField")) {
                        StringBuilder columnStr = new StringBuilder().append(";").append(columnKey).append(",").append(columnKey);
                        str = str.append((CharSequence)columnStr);
                    }
                    ++i;
                }
            }
            return str.toString();
        }
        return str.toString();
    }

    public String getGridKey() throws Throwable {
        String str = "";
        RichDocumentContext midContext = this.getMidContext();
        DefaultContext defaultContext = midContext.getDefaultContext();
        String para = (String)defaultContext.getPara("OwnerFormKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLoopup = IDLookup.reloadIDLookup(metaForm);
        List<MetaGrid> metaGrids = idLoopup.getMetaGrids();
        List<MetaTableRow> metaDetailTableRows = idLoopup.getMetaDetailTableRows();
        if (StringUtils.isNotEmpty((CharSequence)IOMetaObject.currentFormKey) && !para.equalsIgnoreCase(IOMetaObject.currentFormKey) && !IOMetaObject.currentFormKey.equalsIgnoreCase("MobileFormDesigner")) {
            List<MetaTableRow> metaDetailTableRows1;
            MetaForm parenMetaForm = this.getMidContext().getMetaFactory().getMetaForm(IOMetaObject.currentFormKey);
            IDLookup parenLookup = IDLookup.reloadIDLookup(parenMetaForm);
            List<MetaGrid> metaGrids1 = parenLookup.getMetaGrids();
            if (metaGrids1 != null && !metaGrids1.isEmpty()) {
                for (MetaGrid metaGrid : metaGrids1) {
                    String key = metaGrid.getKey();
                    String caption = metaGrid.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    if (StringUtils.isEmpty((CharSequence)(caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"")))) {
                        caption = key;
                    }
                    str = String.valueOf(str) + key + "," + caption + ";";
                }
            }
            if ((metaDetailTableRows1 = parenLookup.getMetaDetailTableRows()) != null && !metaDetailTableRows1.isEmpty()) {
                for (MetaTableRow metaTableRow : metaDetailTableRows1) {
                    String key = metaTableRow.getKey();
                    String caption = metaTableRow.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    if (StringUtils.isEmpty((CharSequence)(caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"")))) {
                        caption = key;
                    }
                    str = String.valueOf(str) + key + "," + caption + ";";
                }
            }
        } else {
            String caption;
            String key;
            if (metaGrids != null && !metaGrids.isEmpty()) {
                for (MetaGrid metaGrid : metaGrids) {
                    key = metaGrid.getKey();
                    caption = metaGrid.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    if (StringUtils.isEmpty((CharSequence)(caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"")))) {
                        caption = key;
                    }
                    str = String.valueOf(str) + key + "," + caption + ";";
                }
            }
            if (metaDetailTableRows != null && !metaDetailTableRows.isEmpty()) {
                for (MetaTableRow metaTableRow : metaDetailTableRows) {
                    key = metaTableRow.getKey();
                    caption = metaTableRow.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    if (StringUtils.isEmpty((CharSequence)(caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"")))) {
                        caption = key;
                    }
                    str = String.valueOf(str) + key + "," + caption + ";";
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        return str.substring(0, str.length() - 1);
    }

    public void selectMacro() throws Throwable {
        String formKey;
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        RichDocument document = this.getMidContext().getRichDocument();
        DataTable dataTable = document.getDataTable("ED_NewMacroDetail");
        DataTable dataTableHead = document.getDataTable("ED_NewMacroHead");
        String inputMacroKey = dataTableHead.getString(0, "Key");
        if (StringUtils.isBlank((CharSequence)inputMacroKey)) {
            inputMacroKey = "";
        }
        if (StringUtils.isNotEmpty((CharSequence)(formKey = dataTableHead.getString(0, "FormKey")))) {
            para = formKey;
        }
        MetaForm ownerMetaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        String condition = dataTableHead.getString(0, "Condition");
        String projectKey = dataTableHead.getString(0, "ProjectKey");
        dataTableHead.clear();
        int row1 = dataTableHead.append();
        if (StringUtils.isNotEmpty((CharSequence)formKey)) {
            dataTableHead.setString(row1, "FormKey", formKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            dataTableHead.setString(row1, "Condition", condition);
        }
        if (StringUtils.isNotEmpty((CharSequence)projectKey)) {
            dataTableHead.setString(row1, "ProjectKey", projectKey);
        }
        dataTable.clear();
        try {
            String prokey = ownerMetaForm.getProject().getKey();
            if (StringUtils.isNotEmpty((CharSequence)projectKey)) {
                prokey = projectKey;
            }
            String solu = FilePathHelper.getCoreSolutionPath();
            String path = String.valueOf(solu) + File.separator + prokey + File.separator + "CommonDef.xml";
            if (!condition.equals("project")) {
                path = "erp".equals(condition) ? String.valueOf(solu) + File.separator + "CommonDef.xml" : LoadFileTree.getPathByFormKey(para);
            }
            DesignActionUtil.selectMacroList(dataTable, path, inputMacroKey);
            if (dataTable.size() <= 0) {
                int append = dataTable.append();
                dataTable.setState(0);
                dataTable.setString(append, "Formula", "\u672a\u67e5\u8be2\u5230\u7ed3\u679c");
            }
            document.addDirtyTableFlag("ED_NewMacroDetail");
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
    }

    public static void selectMacroList(DataTable dataTable, String path, String inputMacroKey) throws Throwable {
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path);
        com.bokesoft.yes.design.xml.node.TagNode node = xmlTreeWithPath.xmlTree.getRoot().getOrCreateChildByTagName("MacroCollection");
        List<AbstractNode> macroCollection = node.getChildren();
        int i = 0;
        while (i < macroCollection.size()) {
            String key;
            AbstractNode tagNode = macroCollection.get(i);
            if (tagNode instanceof com.bokesoft.yes.design.xml.node.TagNode && ((com.bokesoft.yes.design.xml.node.TagNode)tagNode).getTagName().equalsIgnoreCase("macro") && (key = ((com.bokesoft.yes.design.xml.node.TagNode)tagNode).getAttributes().get("Key")).contains(inputMacroKey)) {
                String args = ((com.bokesoft.yes.design.xml.node.TagNode)tagNode).getAttributes().get("Args");
                int row = dataTable.append();
                dataTable.setState(0);
                dataTable.setString(row, "Key", key);
                dataTable.setString(row, "Args", args);
                String a1 = "";
                for (AbstractNode child : ((com.bokesoft.yes.design.xml.node.TagNode)tagNode).getChildren()) {
                    if (!(child instanceof CDataNode)) continue;
                    a1 = child.getText();
                    break;
                }
                dataTable.setString(row, "Formula", a1);
            }
            ++i;
        }
    }

    public static void selectMacroList(DataTable dataTable, String path) throws Throwable {
        path = path.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path);
        com.bokesoft.yes.design.xml.node.TagNode node = xmlTreeWithPath.xmlTree.getRoot().getOrCreateChildByTagName("MacroCollection");
        List<AbstractNode> macroCollection = node.getChildren();
        int i = 0;
        while (i < macroCollection.size()) {
            AbstractNode tagNode = macroCollection.get(i);
            if (tagNode instanceof com.bokesoft.yes.design.xml.node.TagNode && ((com.bokesoft.yes.design.xml.node.TagNode)tagNode).getTagName().equalsIgnoreCase("macro")) {
                String key = ((com.bokesoft.yes.design.xml.node.TagNode)tagNode).getAttributes().get("Key");
                String args = ((com.bokesoft.yes.design.xml.node.TagNode)tagNode).getAttributes().get("Args");
                int row = dataTable.append();
                dataTable.setState(0);
                dataTable.setString(row, "Key", key);
                dataTable.setString(row, "Args", args);
                String a1 = "";
                for (AbstractNode child : ((com.bokesoft.yes.design.xml.node.TagNode)tagNode).getChildren()) {
                    if (!(child instanceof CDataNode)) continue;
                    a1 = child.getText();
                    break;
                }
                dataTable.setString(row, "Formula", a1);
            }
            ++i;
        }
    }

    public String LoadFormKey() throws Throwable {
        String[] str = new String[]{""};
        StringBuffer[] stringBuffer = new StringBuffer[1];
        MetaFormList metaFormList = this.getMidContext().getMetaFactory().getMetaFormList();
        for (MetaFormProfile metaForm : metaFormList) {
            if (metaForm.getForm() == null || metaForm.getForm().getDataSource() == null || metaForm.getForm().getDataSource().getDataObject() == null || metaForm.getFormType() == 3) continue;
            String key = metaForm.getKey();
            String caption = metaForm.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            stringBuffer[0] = new StringBuffer().append(key).append(",").append(key).append("  ").append(caption).append(";");
            str[0] = String.valueOf(str[0]) + stringBuffer[0];
        }
        String substring = str[0].substring(0, str[0].length() - 1);
        return substring;
    }

    public String loadDataObjectKeyByDataMigration() throws Throwable {
        String[] str = new String[]{""};
        StringBuffer[] stringBuffer = new StringBuffer[1];
        MetaDataObjectList dataObjectList = this.getMidContext().getMetaFactory().getDataObjectList();
        for (MetaDataObjectProfile dataObjec : dataObjectList) {
            if (dataObjec.getDataObject() == null || dataObjec.getDataObject().getSecondaryType() == 6) continue;
            String key = dataObjec.getKey();
            String caption = dataObjec.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            stringBuffer[0] = new StringBuffer().append(key).append(",").append(key).append("   ").append(caption).append(";");
            str[0] = String.valueOf(str[0]) + stringBuffer[0];
        }
        String substring = str[0].substring(0, str[0].length() - 1);
        return substring;
    }

    public StringBuffer setDefaultValue(String SourceFormKey, String TargetFormKey) {
        StringBuffer str = new StringBuffer();
        if (SourceFormKey == null || "".equals(SourceFormKey) || TargetFormKey == null || "".equals(TargetFormKey)) {
            return null;
        }
        String sourceFormKey = SourceFormKey.split(" ")[0];
        String targetFormKey = TargetFormKey.split(" ")[0];
        str.append(sourceFormKey).append("2").append(targetFormKey);
        return str;
    }

    public String LoadDataObject() throws Throwable {
        String[] str = new String[]{""};
        StringBuffer[] stringBuffer = new StringBuffer[1];
        MetaDataObjectList dataObjectList = this.getMidContext().getMetaFactory().getDataObjectList();
        for (MetaDataObjectProfile dataObjec : dataObjectList) {
            if (dataObjec.getDataObject() == null || dataObjec.getDataObject().getSecondaryType() != 6) continue;
            String key = dataObjec.getKey();
            String caption = dataObjec.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            stringBuffer[0] = new StringBuffer().append(key).append(",").append(key).append("   ").append(caption).append(";");
            str[0] = String.valueOf(str[0]) + stringBuffer[0];
        }
        String substring = str[0].substring(0, str[0].length() - 1);
        return substring;
    }

    public StringBuffer setDataObjectKey(String SourceDataObject, String TargetDataObject) throws Throwable {
        StringBuffer str = new StringBuffer();
        if (SourceDataObject != null && !"".equals(SourceDataObject) && TargetDataObject != null && !"".equals(TargetDataObject)) {
            String sourceFormKey = SourceDataObject.split(" ")[0];
            String targetFormKey = TargetDataObject.split(" ")[0];
            str.append(sourceFormKey).append("2").append(targetFormKey);
            MetaDataMigrationList dataMigrationList = this.getMidContext().getMetaFactory().getDataMigrationList();
            boolean isExist = dataMigrationList.containsKey(str.toString());
            if (isExist) {
                return str.append("_01");
            }
        } else {
            return null;
        }
        return str;
    }

    public String getVestAllComponent() throws Throwable {
        StringBuilder columnStr;
        String caption;
        String key2;
        StringBuilder str = new StringBuilder(256);
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        HashMap allUIComponents = metaForm.getAllUIComponents();
        String filePath = LoadFileTree.getPathByFormKey(this.getMidContext().getMetaFactory().getMetaForm(metaForm.getExtend()).getKey());
        com.bokesoft.yes.design.xml.node.XmlTree xmlTree1 = XmlTreeWithPath.parseFilePath((String)filePath).xmlTree;
        String erpXmlFilePath = LoadFileTree.getPathByFormKey(para);
        String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
        String vestFilePath = StringUtils.isNotBlank((CharSequence)tmpPath) ? tmpPath : erpXmlFilePath;
        com.bokesoft.yes.design.xml.node.XmlTree vestXmlTree = Xml4jUtil.parseTree(vestFilePath);
        HashMap<String, AbstractNode> mapNodes = vestXmlTree.getMapNodes();
        Set<String> strings = mapNodes.keySet();
        Function<String, Boolean> f = key -> {
            for (String string : strings) {
                boolean b = StringUtils.endsWith((CharSequence)string, (CharSequence)("@" + key));
                if (!b) continue;
                return true;
            }
            return false;
        };
        boolean exist = false;
        for (Map.Entry abstractMetaObjectMap : allUIComponents.entrySet()) {
            AbstractMetaObject allUIComponentsvalue = (AbstractMetaObject)abstractMetaObjectMap.getValue();
            if (!(allUIComponentsvalue instanceof MetaGrid)) continue;
            MetaGridColumnCollection columnCollection = ((MetaGrid)allUIComponentsvalue).getColumnCollection();
            for (MetaGridColumn metaGridColumn : columnCollection) {
                if (!Objects.nonNull(xmlTree1.getTagNode("GridColumn@" + metaGridColumn.getKey()))) continue;
                key2 = metaGridColumn.getKey();
                caption = metaGridColumn.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                MetaGridCell abstractMetaObject = (MetaGridCell)allUIComponents.get(key2);
                MetaGridColumn gridMetaColumnByKey = IDLookup.reloadIDLookup(metaForm).getGridMetaColumnByKey(key2);
                if (gridMetaColumnByKey.getKey().equalsIgnoreCase(key2)) {
                    key2 = metaGridColumn.getMetaKey();
                }
                int controlType = abstractMetaObject.getCellType();
                columnStr = new StringBuilder().append(";").append(String.valueOf(key2) + "@" + caption + "@" + ControlType.toString((Integer)controlType) + "@" + ((MetaGrid)allUIComponentsvalue).getKey()).append(",").append(key2).append("  ").append("[").append(caption).append("@").append(ControlType.toString((Integer)controlType)).append("]").append("  in ").append(((MetaGrid)allUIComponentsvalue).getKey());
                str = str.append((CharSequence)columnStr);
                exist = true;
            }
        }
        if (!exist) {
            if (StringUtils.isEmpty((CharSequence)metaForm.getExtend())) {
                return str.toString();
            }
            HashMap allUIComponents1 = this.getMidContext().getMetaFactory().getMetaForm(metaForm.getExtend()).getAllUIComponents();
            List<MetaGrid> metaGrids1 = IDLookup.getIDLookup(this.getMidContext().getMetaFactory().getMetaForm(metaForm.getExtend())).getMetaGrids();
            for (MetaGrid metaGrid : metaGrids1) {
                for (MetaGridColumn metaGridColumn : metaGrid.getColumnCollection()) {
                    key2 = metaGridColumn.getKey();
                    caption = metaGridColumn.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                    if (f.apply(key2).booleanValue() || !Objects.nonNull(xmlTree1.getTagNode("GridColumn@" + metaGridColumn.getKey()))) continue;
                    MetaGridCell metaGridCell = (MetaGridCell)allUIComponents1.get(key2);
                    int columnType = metaGridCell.getCellType();
                    columnStr = new StringBuilder().append(";").append(String.valueOf(key2) + "@" + caption + "@" + ControlType.toString((Integer)columnType) + "@" + metaGrid.getKey()).append(",").append(key2).append("  ").append("[").append(caption).append("@").append(ControlType.toString((Integer)columnType)).append("]").append("  in ").append(metaGrid.getKey());
                    str = str.append((CharSequence)columnStr);
                }
            }
        }
        return str.toString();
    }

    public String getVestAllHeadComponent() throws Throwable {
        StringBuilder str = new StringBuilder(256);
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        String extend = metaForm.getExtend();
        if (extend.isEmpty()) {
            return str.toString();
        }
        String erpXmlFilePath = LoadFileTree.getPathByFormKey(para);
        String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
        String filePath = StringUtils.isNotBlank((CharSequence)tmpPath) ? tmpPath : erpXmlFilePath;
        com.bokesoft.yes.design.xml.node.XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
        HashMap<String, AbstractNode> mapNodes = xmlTree.getMapNodes();
        Set<String> strings = mapNodes.keySet();
        Function<String, Boolean> f = key -> {
            for (String string : strings) {
                boolean b = StringUtils.endsWith((CharSequence)string, (CharSequence)("@" + key));
                if (!b) continue;
                return true;
            }
            return false;
        };
        ArrayList<MetaFormProfile> metaFormProfiles = new ArrayList<MetaFormProfile>();
        MetaFormList metaFormList = this.getMidContext().getMetaFactory().getMetaFormList();
        for (MetaFormProfile metaFormProfile : metaFormList) {
            if (!metaFormProfile.getMergeToSource().booleanValue()) continue;
            metaFormProfiles.add(metaFormProfile);
        }
        MetaForm specMetaForm = this.getMidContext().getMetaFactory().getMetaForm(extend);
        MetaForm xmlMetaForm = NewFormCmd.loadMetaForm(extend);
        List<MetaForm> sourceMetaFormList = Arrays.asList(xmlMetaForm, specMetaForm);
        for (MetaForm extendmetaForm : sourceMetaFormList) {
            HashMap allUIComponents = metaForm.getAllUIComponents();
            HashMap extendallUIComponents = extendmetaForm.getAllUIComponents();
            for (Map.Entry extendabstractMetaObjectMap : extendallUIComponents.entrySet()) {
                StringBuilder columnStr;
                ArrayList componentArray;
                boolean flag = false;
                String key2 = (String)extendabstractMetaObjectMap.getKey();
                AbstractMetaObject abstractMetaObject = (AbstractMetaObject)allUIComponents.get(key2);
                AbstractMetaObject extendvalue = (AbstractMetaObject)extendabstractMetaObjectMap.getValue();
                if (Objects.isNull(abstractMetaObject) && extendvalue instanceof MetaPanel) {
                    for (MetaFormProfile metaFormProfile : metaFormProfiles) {
                        AbstractMetaObject object = (AbstractMetaObject)metaFormProfile.getForm().getAllUIComponents().get(key2);
                        if (Objects.isNull(object) || !((MetaComponent)object).isExtend().booleanValue()) continue;
                        flag = true;
                    }
                    if (!flag) {
                        componentArray = ((MetaPanel)extendvalue).getComponentArray();
                        for (MetaComponent metaComponent : componentArray) {
                            String key1 = metaComponent.getKey();
                            if (StringUtils.contains((CharSequence)str, (CharSequence)(String.valueOf(key1) + "@"))) continue;
                            String caption1 = metaComponent.getCaption();
                            caption1 = RegExUtils.replaceAll((String)caption1, (String)",", (String)"\uff0c");
                            caption1 = RegExUtils.replaceAll((String)caption1, (String)"\\s*", (String)"");
                            int controlType1 = metaComponent.getControlType();
                            columnStr = new StringBuilder().append(";").append(String.valueOf(key1) + "@" + caption1 + "@" + ControlType.toString((Integer)controlType1) + "@" + key2).append(",").append(key1).append("  ").append("[").append(caption1).append("@").append(ControlType.toString((Integer)controlType1)).append("]").append("  in ").append(key2);
                            str = str.append((CharSequence)columnStr);
                        }
                    }
                }
                if (!(extendvalue instanceof MetaPanel) || abstractMetaObject == null) continue;
                componentArray = ((MetaPanel)abstractMetaObject).getComponentArray();
                ArrayList extendcomponentArray = ((MetaPanel)extendvalue).getComponentArray();
                HashMap<String, String> componentArrayHashMap = new HashMap<String, String>();
                for (MetaComponent metaComponent : componentArray) {
                    if (metaComponent.isExtend().booleanValue()) continue;
                    componentArrayHashMap.put(metaComponent.getKey(), metaComponent.getCaption());
                }
                for (MetaComponent extendmetaComponent : extendcomponentArray) {
                    String key1;
                    if (extendmetaComponent instanceof MetaSubDetail) continue;
                    String extendmetaComponentKey = extendmetaComponent.getKey();
                    String s = (String)componentArrayHashMap.get(extendmetaComponentKey);
                    if (f.apply(extendmetaComponentKey).booleanValue() || StringUtils.contains((CharSequence)str, (CharSequence)(String.valueOf(key1 = extendmetaComponent.getKey()) + "@"))) continue;
                    String caption = extendmetaComponent.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                    int controlType = extendmetaComponent.getControlType();
                    columnStr = new StringBuilder().append(";").append(String.valueOf(key1) + "@" + caption + "@" + ControlType.toString((Integer)controlType) + "@" + key2).append(",").append(key1).append("  ").append("[").append(caption).append("@").append(ControlType.toString((Integer)controlType)).append("]").append("  in ").append(key2);
                    str = str.append((CharSequence)columnStr);
                }
            }
        }
        return str.toString();
    }

    private boolean isBind(MetaPanel extendvalue, HashMap<String, String> componentArrayHashMap, String extendmetaComponentKey) {
        boolean s = false;
        for (Map.Entry<String, String> stringStringEntry : componentArrayHashMap.entrySet()) {
            String entryKey = stringStringEntry.getKey();
            if (Objects.isNull(extendvalue.getComponent(entryKey)) || !extendvalue.getComponent(entryKey).getBuddyKey().equals(extendmetaComponentKey)) continue;
            return true;
        }
        return s;
    }

    public String getVestPanelComponent() throws Throwable {
        StringBuilder str = new StringBuilder(256);
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String erpXmlFilePath = LoadFileTree.getPathByFormKey(para);
        String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
        String filePath = StringUtils.isNotBlank((CharSequence)tmpPath) ? tmpPath : erpXmlFilePath;
        com.bokesoft.yes.design.xml.node.XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
        HashMap<String, AbstractNode> mapNodes = xmlTree.getMapNodes();
        Set<String> strings = mapNodes.keySet();
        Function<String, Boolean> f = key -> {
            for (String string : strings) {
                boolean b = StringUtils.endsWith((CharSequence)string, (CharSequence)("@" + key));
                if (!b) continue;
                return true;
            }
            return false;
        };
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        HashMap allUIComponents = metaForm.getAllUIComponents();
        String extend = metaForm.getExtend();
        MetaForm specMetaForm = this.getMidContext().getMetaFactory().getMetaForm(extend);
        MetaForm xmlMetaForm = NewFormCmd.loadMetaForm(extend);
        List<MetaForm> sourceMetaFormList = Arrays.asList(xmlMetaForm, specMetaForm);
        for (MetaForm extendmetaForm : sourceMetaFormList) {
            HashMap extendallUIComponents = extendmetaForm.getAllUIComponents();
            for (Map.Entry extendabstractMetaObjectMap : extendallUIComponents.entrySet()) {
                String key2 = (String)extendabstractMetaObjectMap.getKey();
                AbstractMetaObject abstractMetaObject = (AbstractMetaObject)allUIComponents.get(key2);
                AbstractMetaObject extendvalue = (AbstractMetaObject)extendabstractMetaObjectMap.getValue();
                if (!(extendvalue instanceof MetaPanel) || abstractMetaObject == null) continue;
                ArrayList componentArray = ((MetaPanel)abstractMetaObject).getComponentArray();
                ArrayList extendcomponentArray = ((MetaPanel)extendvalue).getComponentArray();
                HashMap<String, String> componentArrayHashMap = new HashMap<String, String>();
                for (MetaComponent metaComponent : componentArray) {
                    componentArrayHashMap.put(metaComponent.getKey(), metaComponent.getCaption());
                }
                for (MetaComponent extendmetaComponent : extendcomponentArray) {
                    String key1 = extendmetaComponent.getKey();
                    if (StringUtils.contains((CharSequence)str, (CharSequence)(String.valueOf(key1) + "@")) || extendmetaComponent.getControlType() == 209 || f.apply(key1).booleanValue()) continue;
                    String caption = extendmetaComponent.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                    int controlType = extendmetaComponent.getControlType();
                    StringBuilder columnStr = new StringBuilder().append(";").append(String.valueOf(key1) + "@" + caption + "@" + ControlType.toString((Integer)controlType) + "@" + key2).append(",").append(key1).append("  ").append("[").append(caption).append("@").append(ControlType.toString((Integer)controlType)).append("]").append("  in ").append(key2);
                    str = str.append((CharSequence)columnStr);
                }
            }
        }
        return str.toString();
    }

    public Boolean checkValue(String value) {
        return PATTERN.matcher(value).matches();
    }

    public String isEnableLinkDataMap(String source, String target) throws Throwable {
        StringBuilder stringBuilder = new StringBuilder();
        IMetaFactory globalInstance = this.getMidContext().getMetaFactory();
        MetaFormProfile metaFormProfile = (MetaFormProfile)globalInstance.getMetaFormList().get(source);
        MetaFormProfile formProfile = (MetaFormProfile)globalInstance.getMetaFormList().get(target);
        if (metaFormProfile != null && formProfile != null) {
            List customList = this.getMidContext().getMetaFactory().getCustomList();
            String sourceVariable = globalInstance.getMetaForm(source).getExtend();
            String targetVariable = globalInstance.getMetaForm(target).getExtend();
            String sourceExtend = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{sourceVariable}) ? sourceVariable : source;
            String targetExtend = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{targetVariable}) ? targetVariable : target;
            for (KeyPairMetaObject erpMetaMap : customList) {
                String string;
                if (!(erpMetaMap instanceof ERPMetaMap) || StringUtils.isNotEmpty((CharSequence)((ERPMetaMap)erpMetaMap).getExtend())) continue;
                String key = erpMetaMap.getKey();
                String caption = ((ERPMetaMap)erpMetaMap).getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                String srcFormKey = ((ERPMetaMap)erpMetaMap).getSrcFormKey();
                String tgtFormKey = ((ERPMetaMap)erpMetaMap).getTgtFormKey();
                if (!srcFormKey.equals(sourceExtend) || !tgtFormKey.equals(targetExtend) || (string = stringBuilder.toString()).contains(String.valueOf(key) + " " + caption)) continue;
                stringBuilder.append(key).append(",").append(key).append(" ").append(caption).append(";");
            }
            String string = stringBuilder.toString();
            if (StringUtils.isEmpty((CharSequence)string)) {
                return "";
            }
            string = string.substring(0, string.length() - 1);
            return string;
        }
        return "";
    }

    public String isEnableLinkDataMigration(String source, String target) throws Throwable {
        StringBuilder stringBuilder = new StringBuilder();
        IMetaFactory globalInstance = this.getMidContext().getMetaFactory();
        MetaDataObjectProfile sourceDataObjectProfile = (MetaDataObjectProfile)globalInstance.getDataObjectList().get(source);
        MetaDataObjectProfile targetDataObjectProfile = (MetaDataObjectProfile)globalInstance.getDataObjectList().get(target);
        if (sourceDataObjectProfile != null && targetDataObjectProfile != null) {
            String sourceVariable = globalInstance.getDataObject(source).getExtend();
            String targetVariable = globalInstance.getDataObject(target).getExtend();
            String sourceExtend = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{sourceVariable}) ? sourceVariable : source;
            String targetExtend = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{targetVariable}) ? targetVariable : target;
            MetaDataMigrationList dataMigrationList = globalInstance.getDataMigrationList();
            for (MetaDataMigrationProfile metaDataMigrationProfile : dataMigrationList) {
                if (StringUtils.isNotEmpty((CharSequence)metaDataMigrationProfile.getDataMigration().getExtend())) continue;
                String srcDataObjectKey = metaDataMigrationProfile.getSrcDataObjectKey();
                String tgtDataObjectKey = metaDataMigrationProfile.getTgtDataObjectKey();
                if (!StringUtils.equals((CharSequence)sourceExtend, (CharSequence)srcDataObjectKey) || !StringUtils.equals((CharSequence)targetExtend, (CharSequence)tgtDataObjectKey)) continue;
                String key = metaDataMigrationProfile.getKey();
                String caption = metaDataMigrationProfile.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                String string = stringBuilder.toString();
                if (string.contains(String.valueOf(key) + " " + caption)) continue;
                stringBuilder.append(key).append(",").append(key).append(" ").append(caption).append(";");
            }
            String string = stringBuilder.toString();
            if (StringUtils.isEmpty((CharSequence)string)) {
                return "";
            }
            string = string.substring(0, string.length() - 1);
            return string;
        }
        return "";
    }

    public boolean ismergeToSource(String source, String target, String extend) throws Throwable {
        boolean merge = true;
        String dataMapPath = LoadFileTree.getDataMapPathByKey(extend);
        String sourcePath = LoadFileTree.getPathByFormKey(source);
        XmlTreeWithPath sourceParse = XmlTreeWithPath.parseFilePath(sourcePath);
        String toSource = sourceParse.xmlTree.getRoot().getAttributes().get("MergeToSource");
        if (!"true".equalsIgnoreCase(toSource)) {
            return false;
        }
        String targetPath = LoadFileTree.getPathByFormKey(target);
        XmlTreeWithPath targetParse = XmlTreeWithPath.parseFilePath(targetPath);
        String toTarget = targetParse.xmlTree.getRoot().getAttributes().get("MergeToSource");
        if (!"true".equalsIgnoreCase(toTarget)) {
            return false;
        }
        if (!dataMapPath.isEmpty()) {
            XmlTreeWithPath parse = XmlTreeWithPath.parseFilePath(dataMapPath);
            String mergeToSource = parse.xmlTree.getRoot().getAttributes().get("MergeToSource");
            if ("true".equalsIgnoreCase(mergeToSource)) {
                merge = false;
            }
        }
        return merge;
    }

    public void setFuncTable(String FunctionSearch) throws Throwable {
        cache = CacheFactory.getInstance().createCache("ERP_FormulaDataSource");
        RichDocument document = this.getMidContext().getRichDocument();
        String formulaKeys = (String)this.getMidContext().getPara("FormulaKeys");
        DataTable dataTable = document.getDataTable("ED_New_FunctionTable");
        dataTable.clear();
        Set formulaKeyCollect = Arrays.stream(formulaKeys.split(",")).collect(Collectors.toSet());
        for (String s : formulaKeyCollect) {
            HashMap dataSource = (HashMap)cache.get(s);
            this.dataTableSetFunc(FunctionSearch, dataTable, dataSource);
        }
        if (formulaKeyCollect.contains("designer") || formulaKeyCollect.contains("macro")) {
            ArrayList<String> macroIdList = (ArrayList<String>)cache.get("macroIdList");
            ArrayList<String> macroDescList = (ArrayList<String>)cache.get("macroDescList");
            if (CollectionUtils.isEmpty((Collection)macroIdList)) {
                macroIdList = new ArrayList<String>();
                macroDescList = new ArrayList<String>();
                Map<String, String> macroMap = this.getCommonDefMacro((DefaultContext)this.getMidContext());
                if (macroMap != null && !macroMap.isEmpty()) {
                    Map resultMap = macroMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
                    for (Map.Entry entry : resultMap.entrySet()) {
                        if (macroIdList.contains(entry.getKey())) continue;
                        macroIdList.add((String)entry.getKey());
                        macroDescList.add((String)entry.getValue());
                    }
                }
            }
            int i = 0;
            while (i < macroIdList.size()) {
                String FunctionCaption;
                String FunctionKey = (String)macroIdList.get(i);
                String string = FunctionCaption = CollectionUtils.isEmpty(macroDescList) ? "" : (String)macroDescList.get(i);
                if (FunctionKey.toLowerCase().contains(FunctionSearch.toLowerCase().trim()) || FunctionKey.toLowerCase().startsWith(FunctionSearch.trim().toLowerCase()) || FunctionCaption.toLowerCase().contains(FunctionSearch.toLowerCase().trim()) || FunctionCaption.toLowerCase().startsWith(FunctionSearch.trim().toLowerCase())) {
                    String ParamKey = "";
                    String ReturnKey = "";
                    dataTable.append();
                    dataTable.setString("FunctionKey", FunctionKey);
                    dataTable.setString("FunctionCaption", FunctionCaption);
                    dataTable.setString("ParamKey", ParamKey);
                    dataTable.setString("ReturnKey", ReturnKey);
                }
                ++i;
            }
        }
        document.addDirtyTableFlag("ED_New_FunctionTable");
    }

    public void setColumnList(String search) throws Throwable {
        RichDocument document = this.getMidContext().getRichDocument();
        MetaTable table = null;
        DataTable dataTable = document.getDataTable("ED_DetailColumn");
        dataTable.clear();
        String formKey = (String)this.getMidContext().getPara("FormKey");
        String tableKey = (String)this.getMidContext().getPara("TableKey");
        boolean isMainTable = StringUtils.isEmpty((CharSequence)tableKey);
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(formKey);
        MetaDataSource dataSource = metaForm.getDataSource();
        String refObjectKey = dataSource.getRefObjectKey();
        ArrayList<MetaColumn> columnList = new ArrayList<MetaColumn>();
        if (StringUtils.isNotEmpty((CharSequence)refObjectKey)) {
            MetaDataObject dataObject = this.getMidContext().getMetaFactory().getDataObject(refObjectKey);
            table = isMainTable ? dataObject.getMainTable() : dataObject.getTable(tableKey);
            if (Objects.isNull(table)) {
                return;
            }
            if (isMainTable) {
                tableKey = table.getKey();
            }
            Collection items = table.items();
            for (MetaColumn item : items) {
                columnList.add(item);
            }
        } else {
            table = isMainTable ? dataSource.getDataObject().getMainTable() : dataSource.getDataObject().getTable(tableKey);
            if (Objects.isNull(table)) {
                return;
            }
            Collection items = table.items();
            for (MetaColumn item : items) {
                columnList.add(item);
            }
        }
        int i = 0;
        while (i < columnList.size()) {
            MetaColumn metaColumn = (MetaColumn)columnList.get(i);
            if (metaColumn.getKey().toLowerCase().contains(search.toLowerCase().trim()) || metaColumn.getKey().toLowerCase().startsWith(search.trim().toLowerCase()) || metaColumn.getCaption().toLowerCase().contains(search.toLowerCase().trim()) || metaColumn.getCaption().toLowerCase().startsWith(search.trim().toLowerCase())) {
                int appendi = dataTable.append();
                if (isMainTable) {
                    dataTable.setString("ColumnKey", String.valueOf(table.getKey()) + "|" + metaColumn.getKey());
                } else {
                    dataTable.setString("ColumnKey", metaColumn.getKey());
                }
                dataTable.setString("Caption", metaColumn.getCaption());
                IOMetaObject.loadCellFormat(dataTable, metaForm, tableKey, IDLookup.reloadIDLookup(metaForm), metaColumn, appendi);
            }
            ++i;
        }
        document.addDirtyTableFlag("ED_DetailColumn");
    }

    public void dataTableSetFunc(String FunctionSearch, DataTable dataTable, HashMap<String, List<String>> dataSource) {
        List<String> funcList = dataSource.get("funcList");
        List<String> funcDescList = dataSource.get("funcDescList");
        List<String> paramDescList = dataSource.get("paramDescList");
        List<String> returnValueDescList = dataSource.get("returnValueDescList");
        if (!CollectionUtils.isEmpty(funcList)) {
            String ReturnKey;
            String ParamKey;
            String FunctionCaption;
            String FunctionKey;
            int i = 0;
            while (i < funcList.size()) {
                FunctionKey = funcList.get(i);
                String string = FunctionCaption = CollectionUtils.isEmpty(funcDescList) ? "" : funcDescList.get(i);
                if (FunctionKey.toLowerCase().contains(FunctionSearch.toLowerCase().trim()) || FunctionKey.toLowerCase().startsWith(FunctionSearch.trim().toLowerCase()) || FunctionCaption.toLowerCase().contains(FunctionSearch.toLowerCase().trim()) || FunctionCaption.toLowerCase().startsWith(FunctionSearch.trim().toLowerCase())) {
                    ParamKey = CollectionUtils.isEmpty(paramDescList) ? "" : paramDescList.get(i);
                    ReturnKey = CollectionUtils.isEmpty(returnValueDescList) ? "" : returnValueDescList.get(i);
                    dataTable.append();
                    dataTable.setString("FunctionKey", FunctionKey);
                    dataTable.setString("FunctionCaption", FunctionCaption);
                    dataTable.setString("ParamKey", ParamKey);
                    dataTable.setString("ReturnKey", ReturnKey);
                }
                ++i;
            }
            if (dataTable.size() == 0) {
                i = 0;
                while (i < funcList.size()) {
                    FunctionKey = funcList.get(i);
                    String string = FunctionCaption = CollectionUtils.isEmpty(funcDescList) ? "" : funcDescList.get(i);
                    if (FunctionKey.toLowerCase().contains(FunctionSearch.toLowerCase().trim()) || FunctionKey.toLowerCase().startsWith(FunctionSearch.trim().toLowerCase()) || FunctionCaption.toLowerCase().contains(FunctionSearch.toLowerCase().trim()) || FunctionCaption.toLowerCase().startsWith(FunctionSearch.trim().toLowerCase())) {
                        ParamKey = CollectionUtils.isEmpty(paramDescList) ? "" : paramDescList.get(i);
                        ReturnKey = CollectionUtils.isEmpty(returnValueDescList) ? "" : returnValueDescList.get(i);
                        dataTable.append();
                        dataTable.setString("FunctionKey", FunctionKey);
                        dataTable.setString("FunctionCaption", FunctionCaption);
                        dataTable.setString("ParamKey", ParamKey);
                        dataTable.setString("ReturnKey", ReturnKey);
                    }
                    ++i;
                }
            }
        }
    }

    public void setFormTable(String FormSearch, String isFuzzyQuery) throws Throwable {
        cache = CacheFactory.getInstance().createCache("ERP_FormulaDataSource");
        RichDocument document = this.getMidContext().getRichDocument();
        DataTable dataTable = document.getDataTable("ED_New_FormTable");
        DataTable fieldDataTable = document.getDataTable("ED_New_FieldTable");
        dataTable.clear();
        fieldDataTable.clear();
        ArrayList<String> formKeyList = (ArrayList<String>)cache.get("FormKeyList");
        ArrayList<String> formCaptionList = (ArrayList<String>)cache.get("formCaptionList");
        if (CollectionUtils.isEmpty((Collection)formKeyList)) {
            formKeyList = new ArrayList<String>();
            formCaptionList = new ArrayList<String>();
            IMetaFactory metaFactory = this.getMidContext().getVE().getMetaFactory();
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            int i = 0;
            while (i < metaFormList.size()) {
                MetaForm metaForm = ((MetaFormProfile)metaFormList.get(i)).getForm();
                formKeyList.add(metaForm.getKey());
                formCaptionList.add(metaForm.getCaption());
                ++i;
            }
        }
        if ("".equals(isFuzzyQuery) || Boolean.valueOf(isFuzzyQuery).booleanValue()) {
            int i = 0;
            while (i < formKeyList.size()) {
                String FormKey = (String)formKeyList.get(i);
                String FormCaption = (String)formCaptionList.get(i);
                if (FormKey.toLowerCase().contains(FormSearch.toLowerCase().trim()) || FormKey.toLowerCase().startsWith(FormSearch.trim().toLowerCase()) || FormCaption.toLowerCase().contains(FormSearch.toLowerCase().trim()) || FormCaption.toLowerCase().startsWith(FormSearch.trim().toLowerCase())) {
                    dataTable.append();
                    dataTable.setString("FormKey", FormKey);
                    dataTable.setString("FormCaption", FormCaption);
                }
                ++i;
            }
        } else {
            String[] split;
            String[] stringArray = split = FormSearch.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String fs = stringArray[n2];
                int i = 0;
                while (i < formKeyList.size()) {
                    String FormKey = (String)formKeyList.get(i);
                    String FormCaption = (String)formCaptionList.get(i);
                    if (FormKey.toLowerCase().equals(fs.toLowerCase().trim()) || FormCaption.toLowerCase().equals(fs.toLowerCase().trim())) {
                        dataTable.append();
                        dataTable.setString("FormKey", FormKey);
                        dataTable.setString("FormCaption", FormCaption);
                    }
                    ++i;
                }
                ++n2;
            }
        }
        document.addDirtyTableFlag("ED_New_FormTable");
        document.addDirtyTableFlag("ED_New_FieldTable");
    }

    public void setFieldTable(String SelectFormKey, String FieldSearch) throws Throwable {
        IDLookup idLookup;
        Collection<String> keys;
        if (StringUtils.isEmpty((CharSequence)SelectFormKey)) {
            return;
        }
        RichDocument document = this.getMidContext().getRichDocument();
        DataTable dataTable = document.getDataTable("ED_New_FieldTable");
        dataTable.clear();
        IMetaFactory metaFactory = this.getMidContext().getVE().getMetaFactory();
        MetaForm metaForm = metaFactory.getMetaForm(SelectFormKey);
        if (metaForm != null && (keys = (idLookup = IDLookup.getIDLookup(metaForm)).getFieldKeys()) != null && !keys.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>(keys);
            Collections.sort(list);
            String caption = "";
            for (String key : list) {
                if (!StringUtils.isNotEmpty((CharSequence)key)) continue;
                caption = idLookup.getFieldCaption(key);
                if (StringUtils.isEmpty((CharSequence)caption)) {
                    if (idLookup.getGridCellByKey(key) != null) {
                        caption = idLookup.getGridCellByKey(key).getCaption();
                    }
                    if (StringUtils.isEmpty((CharSequence)caption) && idLookup.getListViewColumnByKey(key) != null) {
                        caption = idLookup.getListViewColumnByKey(key).getCaption();
                    }
                }
                if (key.toLowerCase().indexOf(FieldSearch.toLowerCase().trim()) == -1 && !key.toLowerCase().startsWith(FieldSearch.trim().toLowerCase()) && caption.toLowerCase().indexOf(FieldSearch.toLowerCase().trim()) == -1 && !caption.toLowerCase().startsWith(FieldSearch.trim().toLowerCase())) continue;
                dataTable.append();
                dataTable.setString("FieldKey", key);
                dataTable.setString("FieldCaption", caption);
            }
        }
        document.addDirtyTableFlag("ED_New_FieldTable");
    }

    private Map<String, String> getCommonDefMacro(DefaultContext context) throws Throwable {
        HashMap<String, String> macroMap = new HashMap<String, String>(10000);
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        CountDownLatch countDownLatch = new CountDownLatch(2);
        Future<Map> commonMacro = executorService.submit(() -> {
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                try {
                    MetaCommonDef metaCommonDef = metaFactory.getCommonDef("");
                    if (metaCommonDef != null) {
                        this.setMacroMap(map, metaCommonDef.getMacroCollection());
                    }
                }
                catch (Throwable throwable) {
                    logger.warning(ExceptionUtils.getStackTrace((Throwable)throwable));
                    countDownLatch.countDown();
                }
            }
            finally {
                countDownLatch.countDown();
            }
            return map;
        });
        Future<Map> formsMacro = executorService.submit(() -> {
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                try {
                    MetaFormList metaFormList = this.getMidContext().getMetaFactory().getMetaFormList();
                    if (metaFormList != null && !metaFormList.isEmpty()) {
                        for (MetaFormProfile metaFormProfile : metaFormList) {
                            MetaProject metaProject = (MetaProject)metaFormProfile.getForm().getProject();
                            MetaCommonDef metaCommonDef = metaFactory.getCommonDef(metaProject.getKey());
                            if (metaCommonDef != null) {
                                this.setMacroMap(map, metaCommonDef.getMacroCollection());
                            }
                            MetaMacroCollection metaMacroCollection = metaFormProfile.getForm().getMacroCollection();
                            this.setMacroMap(map, metaMacroCollection);
                        }
                    }
                }
                catch (Throwable throwable) {
                    logger.warning(ExceptionUtils.getStackTrace((Throwable)throwable));
                    countDownLatch.countDown();
                }
            }
            finally {
                countDownLatch.countDown();
            }
            return map;
        });
        countDownLatch.await();
        macroMap.putAll(commonMacro.get());
        macroMap.putAll(formsMacro.get());
        return macroMap;
    }

    private void setMacroMap(Map<String, String> macroMap, MetaMacroCollection macroCollection) {
        if (macroCollection != null && !macroCollection.isEmpty()) {
            String args = "";
            String key = "";
            String value = "";
            for (MetaMacro metaMacro : macroCollection) {
                args = metaMacro.getArgs();
                key = StringUtils.isNotEmpty((CharSequence)args) ? String.valueOf(metaMacro.getKey()) + "(" + args + ")" : String.valueOf(metaMacro.getKey()) + "()";
                value = metaMacro.getContent();
                macroMap.put(key, value);
            }
        }
    }

    public void setInitKey() {
        IOMetaObject.setMetaTable(null);
        IOMetaObject.setGridTableKey(null);
    }

    public String getAddableCompComboBoxByVest() throws Throwable {
        MetaGridLayoutPanel originalParentPanel;
        MetaGridLayoutPanel parentPanel;
        String formKey = (String)this._context.getPara("OwnerFormKey");
        if (StringUtils.isBlank((CharSequence)formKey)) {
            return "";
        }
        IMetaFactory metaFactory = this.getMidContext().getMetaFactory();
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        String originalFormKey = metaForm.getExtend();
        MetaForm originalMetaForm = metaFactory.getMetaForm(originalFormKey);
        HashMap compMap = metaForm.getAllUIComponents();
        HashMap originalCompMap = originalMetaForm.getAllUIComponents();
        String parentCompKey = (String)this._context.getPara("ParentCompKey");
        AbstractMetaObject parentComp = (AbstractMetaObject)compMap.get(parentCompKey);
        AbstractMetaObject originalParentComp = (AbstractMetaObject)originalCompMap.get(parentCompKey);
        ArrayList<String> resultList = new ArrayList<String>();
        if (parentComp instanceof MetaGridLayoutPanel && originalParentComp instanceof MetaGridLayoutPanel) {
            parentPanel = (MetaGridLayoutPanel)parentComp;
            originalParentPanel = (MetaGridLayoutPanel)originalParentComp;
            Set buddyKeySet = originalParentPanel.getComponentArray().stream().map(MetaComponent::getBuddyKey).collect(Collectors.toSet());
            for (MetaComponent component : originalParentPanel.getComponentArray()) {
                String key = component.getKey();
                if (parentPanel.containsComponent(key) || buddyKeySet.contains(key)) continue;
                String caption = component.getCaption();
                caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                resultList.add(String.valueOf(key) + "," + (String)key + " " + caption);
            }
        }
        if (parentComp instanceof MetaGrid && originalParentComp instanceof MetaGrid) {
            parentPanel = (MetaGrid)parentComp;
            originalParentPanel = (MetaGrid)originalParentComp;
            HashSet<String> existKeySet = new HashSet<String>();
            MetaGridRowCollection rowCollection = parentPanel.getRowCollection();
            for (MetaGridRow cells : rowCollection) {
                for (MetaGridCell cell : cells) {
                    if (cell.isVestDeleted()) continue;
                    existKeySet.add(cell.getKey());
                }
            }
            MetaGridRowCollection originalRowCollection = originalParentPanel.getRowCollection();
            for (MetaGridRow cells : originalRowCollection) {
                for (MetaGridCell cell : cells) {
                    String key = cell.getKey();
                    if (existKeySet.contains(key)) continue;
                    String caption = cell.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                    resultList.add(String.valueOf(key) + "," + key + " " + caption);
                }
            }
        }
        return StringUtils.join(resultList, (String)";");
    }

    public String getParamGroup() throws Throwable {
        IMetaFactory metaFactory = this.getMidContext().getMetaFactory();
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        MetaParaTable paraTable = metaFactory.getParaTable();
        if (paraTable != null) {
            for (MetaParaGroup paraGroup : paraTable) {
                csb.addItem(paraGroup.getKey(), String.valueOf(paraGroup.getKey()) + " " + paraGroup.getCaption());
            }
        }
        return csb.toString();
    }

    public String getParamGroupByProjectKey(String projectKey) throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        IMetaFactory metaFactory = this.getMidContext().getMetaFactory();
        MetaParaTable paraTable = metaFactory.getParaTable();
        if (paraTable != null) {
            for (MetaParaGroup paraGroup : paraTable) {
                csb.addItem(paraGroup.getKey(), String.valueOf(paraGroup.getKey()) + " " + paraGroup.getCaption());
            }
        }
        return csb.toString();
    }

    public JSONArray getParamGroupDetail(String paraGroupKey) throws Throwable {
        IMetaFactory metaFactory = this.getMidContext().getMetaFactory();
        MetaParaTable paraTable = metaFactory.getParaTable();
        MetaParaGroup metaParaGroup = (MetaParaGroup)paraTable.get(paraGroupKey);
        if (metaParaGroup != null) {
            JSONArray result = new JSONArray();
            for (MetaParaItem paraItem : metaParaGroup) {
                JSONObject item = new JSONObject();
                item.put("Key", (Object)paraItem.getKey());
                item.put("Value", (Object)paraItem.getValue());
                item.put("Caption", (Object)paraItem.getCaption());
                result.put((Object)item);
            }
            return result;
        }
        return null;
    }

    public String getAllAuxiliaryType(String dataObjectKey) throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        csb.addItem("Normal", "\u666e\u901a\u6570\u636e\u5bf9\u8c61");
        csb.addItem("Dict", "\u5b57\u5178");
        csb.addItem("ChainDict", "\u94fe\u5f0f\u5b57\u5178");
        MetaFormList metaFormList = this.getMidContext().getMetaFactory().getMetaFormList();
        int i = 0;
        while (i < metaFormList.size()) {
            String refObjectKey;
            MetaDataObject dataObject;
            MetaFormProfile metaFormProfile = (MetaFormProfile)metaFormList.get(i);
            MetaForm form = metaFormProfile.getForm();
            if (form != null && form.getDataSource() != null && ((dataObject = form.getDataSource().getDataObject()) != null ? StringUtils.equals((CharSequence)dataObject.getKey(), (CharSequence)dataObjectKey) : StringUtils.equals((CharSequence)(refObjectKey = form.getDataSource().getRefObjectKey()), (CharSequence)dataObjectKey))) {
                return csb.toString();
            }
            ++i;
        }
        csb.addItem("Migration", "\u8fc1\u79fb\u8868");
        return csb.toString();
    }

    public String getAllTblKey(String dataSourceType) throws Throwable {
        ComboxStringBuilder csb;
        block2: {
            MetaForm metaForm;
            block3: {
                String formKey = (String)this._context.getPara("OwnerFormKey");
                csb = ComboxStringBuilder.newInstance();
                metaForm = this.getMidContext().getMetaFactory().getMetaForm(formKey);
                if (metaForm == null) break block2;
                if (!StringUtils.equalsIgnoreCase((CharSequence)dataSourceType, (CharSequence)ChartSourceType.toString((Integer)0))) break block3;
                MetaTableCollection metaTables = metaForm.getDataSource().getDataObject().getTableCollection();
                for (MetaTable metaTable : metaTables) {
                    csb.addItem(metaTable.getKey(), metaTable.getCaption());
                }
                break block2;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)dataSourceType, (CharSequence)ChartSourceType.toString((Integer)2))) break block2;
            HashMap uicomponents = metaForm.getAllUIComponents();
            for (String componentKey : uicomponents.keySet()) {
                if (!(uicomponents.get(componentKey) instanceof MetaGrid)) continue;
                MetaGrid metaGrid = (MetaGrid)uicomponents.get(componentKey);
                csb.addItem(componentKey, metaGrid.getCaption());
            }
        }
        return csb.toString();
    }

    public String getAllColKey(String tableKey, String dataSourceType) throws Throwable {
        ComboxStringBuilder csb;
        block2: {
            MetaForm metaForm;
            block3: {
                String formKey = (String)this._context.getPara("OwnerFormKey");
                csb = ComboxStringBuilder.newInstance();
                metaForm = this.getMidContext().getMetaFactory().getMetaForm(formKey);
                if (metaForm == null || !StringUtils.isNotEmpty((CharSequence)tableKey)) break block2;
                if (!StringUtils.equalsIgnoreCase((CharSequence)dataSourceType, (CharSequence)ChartSourceType.toString((Integer)0))) break block3;
                MetaTable metaTable = metaForm.getDataSource().getDataObject().getTable(tableKey);
                for (MetaColumn metaColumn : metaTable.items()) {
                    csb.addItem(metaColumn.getKey(), metaColumn.getCaption());
                }
                break block2;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)dataSourceType, (CharSequence)ChartSourceType.toString((Integer)2))) break block2;
            MetaGrid metaGrid = (MetaGrid)metaForm.componentByKey(tableKey);
            for (MetaGridColumn metaGridColumn : metaGrid.getColumnCollection()) {
                csb.addItem(metaGridColumn.getKey(), metaGridColumn.getCaption());
            }
        }
        return csb.toString();
    }

    public String getCommonDefVestScope() throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        csb.addItem("root", "[\u7cfb\u7edf\u7ea7\u522b]");
        for (String projectKey : MetaFactory.getGlobalInstance().getProjectKeys()) {
            csb.addItem(projectKey, "[" + projectKey + "] " + MetaFactory.getGlobalInstance().getMetaProject(projectKey).getCaption());
        }
        return csb.toString();
    }

    public DataTable getColumnList(String tableKey, String cellList, String OwnerFormKey) throws Throwable {
        RichDocumentContext context = this.getMidContext();
        MetaForm metaFormKeyDialog = context.getMetaFactory().getMetaForm("D_AutoColumnList");
        MetaTable gridMetaTable = metaFormKeyDialog.getDataSource().getDataObject().getMetaTable("ED_AutoColumnListDtl");
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(gridMetaTable);
        if (StringUtils.isBlank((CharSequence)tableKey)) {
            WebDesignerDataTableUtil.setSequence(dataTable);
            return dataTable;
        }
        if (tableKey.matches("^[0-9]*$") && StringUtils.isBlank((CharSequence)(tableKey = associatedTableMap.get(Integer.parseInt(tableKey))))) {
            WebDesignerDataTableUtil.setSequence(dataTable);
            return dataTable;
        }
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(OwnerFormKey);
        IDLookup idLookup = IDLookup.reloadIDLookup(metaForm);
        MetaDataSource dataSourse = metaForm.getDataSource();
        if (dataSourse == null) {
            WebDesignerDataTableUtil.setSequence(dataTable);
            return dataTable;
        }
        MetaTable table = dataSourse.getDataObject().getTable(tableKey);
        for (MetaColumn column : table) {
            String type;
            String key = column.getKey();
            if ("OID".equals(key) || "POID".equals(key) || "SOID".equals(key) || "VERID".equals(key) || "DVERID".equals(key) || "MapCount".equals(key) || "SelectField".equals(key) || key.contains("_NODB") || "Sequence".equals(key)) continue;
            AbstractMetaObject metaObjectColumnByKey = idLookup.getMetaObjectColumnByKey(key);
            MetaComponent componentByKey = null;
            MetaGridCell metaGridCell = null;
            if (metaObjectColumnByKey instanceof MetaComponent) {
                componentByKey = (MetaComponent)metaObjectColumnByKey;
            }
            if (Objects.isNull(componentByKey)) {
                metaGridCell = idLookup.getGridCellByKey(key);
            }
            if (componentByKey != null || metaGridCell != null) continue;
            String caption = column.getCaption();
            String dataElementKey = "";
            if (column.getDataElement() != null && column.getDataElement().getDomain() != null) {
                Integer refControlType = column.getDataElement().getDomain().getRefControlType();
                type = ControlType.toString((Integer)refControlType);
                dataElementKey = column.getDataElementKey();
            } else {
                int dataType = column.getDataType();
                String cellType = DataType.toString((Integer)dataType);
                type = XmlDiffProcessor.getGridCellType(cellType, key);
            }
            dataTable.append();
            dataTable.setString("ColumnKey", key);
            dataTable.setString("DataElementKey", dataElementKey);
            dataTable.setString("Key", key);
            dataTable.setString("ColumnName", StringUtils.isEmpty((CharSequence)caption) ? "\u5217\u540d\u79f0" : caption);
            dataTable.setString("ControlType", type);
            dataTable.setState(0);
        }
        WebDesignerDataTableUtil.setSequence(dataTable);
        return dataTable;
    }

    public String getAllDictItem() throws Throwable {
        IMetaFactory metaFactory = this.getMidContext().getMetaFactory();
        ArrayList<String> itemList = new ArrayList<String>();
        for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
            MetaForm metaForm = metaFormProfile.getForm();
            if (Objects.isNull(metaForm) || metaForm.getFormType() != 2 || metaForm.getDataSource() == null) continue;
            String itemKey = metaForm.getDataSource().getDataObject().getKey();
            itemList.add(String.valueOf(itemKey) + "," + itemKey + " " + metaForm.getCaption());
        }
        return StringUtils.join(itemList, (String)";");
    }

    public static String getPreferencesInfo(String key) {
        String value;
        File file = new File(String.valueOf(WebDesignerConfiguration.getDesignerDataPath()) + File.separator + "DesignerData.xml");
        if (!file.exists()) {
            return null;
        }
        try {
            String s = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            XmlTree parse = XmlParser.parse((String)s);
            TagNode node = parse.getRoot().findFirstTagNodeByTagName(key);
            value = node != null ? ((String)node.getAttributes().get("Value")).toString() : ("Font".equalsIgnoreCase(key) ? "inherit" : ("FontSize".equalsIgnoreCase(key) ? "inherit" : ("ReloadOnlyComment".equalsIgnoreCase(key) ? "false" : ("FileTreeRowClick".equalsIgnoreCase(key) ? "false" : "true"))));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    public void setPreferencesInfo(String key, String value) {
        String dataPath = String.valueOf(WebDesignerConfiguration.getDesignerDataPath()) + File.separator + "DesignerData.xml";
        File file = new File(dataPath);
        if (!file.exists()) {
            throw new RuntimeException("\u8bbe\u8ba1\u5668DesignerData.xml\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        try {
            XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(dataPath);
            com.bokesoft.yes.design.xml.node.TagNode root = xmlTree.xmlTree.getRoot();
            com.bokesoft.yes.design.xml.node.TagNode node = root.findFirstTagNodeByTagName(key);
            if (node != null) {
                node.setAttribute("Value", value);
                String xml = DesignIOMetaUtil.getXml(root);
                FileUtils.writeStringToFile((File)file, (String)xml, (Charset)StandardCharsets.UTF_8);
            } else {
                node = new com.bokesoft.yes.design.xml.node.TagNode(key, null).setAttribute("Value", value);
                com.bokesoft.yes.design.xml.node.TagNode preference = root.getChildByTagName("Preference");
                preference.addNode(node);
                String xml = DesignIOMetaUtil.getXml(root);
                FileUtils.writeStringToFile((File)file, (String)xml, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (key.equals("DelayedProcessScope")) {
            ReloadForm.setDelayedProcessScope(Boolean.parseBoolean(value));
        }
    }

    public String getDataElements() throws Throwable {
        StringBuilder str = new StringBuilder(256).append(",");
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
        MetaProject metaProject = null;
        String solutionKey = "";
        IMetaFactory metaFactory = midContext.getMetaFactory();
        metaProject = metaFactory.getMetaFormList().get(para) == null ? (MetaProject)((MetaDataObjectProfile)metaFactory.getDataObjectList().get(para)).getProject() : (containerKey != null && !containerKey.isEmpty() ? (MetaProject)((MetaFormProfile)metaFactory.getMetaFormList().get(containerKey)).getProject() : (MetaProject)((MetaFormProfile)metaFactory.getMetaFormList().get(para)).getProject());
        MetaSolution solution = (MetaSolution)metaProject.getSolution();
        solutionKey = solution.getKey();
        MetaDataElementDef dataElementDef = this.getMidContext().getMetaFactory().getDataElementDef(solutionKey);
        if (dataElementDef.getDataElementCollection() == null) {
            return "";
        }
        for (MetaDataElement metaDataElement : dataElementDef.getDataElementCollection()) {
            String key = metaDataElement.getKey();
            String caption = metaDataElement.getCaption();
            StringBuilder columnStr = new StringBuilder().append(";").append(key).append(",").append(key).append(" ").append(caption == null ? "" : caption.replaceAll(",", " "));
            str = str.append((CharSequence)columnStr);
        }
        return str.toString();
    }

    public String getDomainKeys() throws Throwable {
        StringBuilder str = new StringBuilder(256).append(",");
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String filePath = FilePathHelper.toBackFilePath(para);
        String projectKey = LoadFileTree.getProjectKey(filePath);
        this.getDomainKey(str, projectKey);
        return str.toString();
    }

    public String getDomainKeyorNewKeys(String projectKey) throws Throwable {
        StringBuilder str = new StringBuilder(256).append("NewDomain,\u65b0\u589e\u57df \u65b0\u589e\u57df");
        this.getDomainKey(str, projectKey);
        return str.toString();
    }

    private String getDomainKey(StringBuilder str, String projectKey) throws Throwable {
        String solutionKey = "";
        IMetaFactory metaFactory = this.getMidContext().getMetaFactory();
        if (StringUtils.isEmpty((CharSequence)projectKey)) {
            solutionKey = "";
        } else {
            MetaSolution solution = (MetaSolution)metaFactory.getMetaProject(projectKey).getSolution();
            solutionKey = solution.getKey();
        }
        MetaDomainDef domainDef = this.getMidContext().getMetaFactory().getDomainDef(solutionKey);
        if (domainDef.getDomainCollection() == null) {
            return "";
        }
        for (MetaDomain metaDomain : domainDef.getDomainCollection()) {
            String key = metaDomain.getKey();
            String caption = metaDomain.getCaption();
            StringBuilder columnStr = new StringBuilder().append(";").append(key).append(",").append(key).append(" ").append(caption == null ? "" : caption);
            str = str.append((CharSequence)columnStr);
        }
        return str.toString();
    }

    public String getQueryDomainFileKeys() {
        StringBuilder str = new StringBuilder(256);
        cache = CacheFactory.getInstance().createCache("mapDomainKeyToFileKey");
        HashMap mapDomainKeyToFileKey = new HashMap();
        LoadFileTree.mapDomainKeyToXmlPath.forEach((key, treeNode) -> {
            StringBuilder columnStr = new StringBuilder().append(treeNode.name.substring(0, treeNode.name.indexOf(".xml"))).append(",").append(treeNode.name.substring(0, treeNode.name.indexOf(".xml"))).append(" ").append(treeNode.description).append(";");
            str.append((CharSequence)columnStr);
            com.bokesoft.yes.design.xml.node.XmlTree xmlTree = null;
            try {
                xmlTree = Xml4jUtil.parseTree(treeNode.key);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<String, AbstractNode> entry : xmlTree.getMapNodes().entrySet()) {
                com.bokesoft.yes.design.xml.node.TagNode node = (com.bokesoft.yes.design.xml.node.TagNode)entry.getValue();
                if (!"Domain".equals(node.getTagName())) continue;
                mapDomainKeyToFileKey.put(node.getAttributes().get("Key"), treeNode.name.substring(0, treeNode.name.indexOf(".xml")));
            }
        });
        cache.put("mapDomainKeyToFileKey", mapDomainKeyToFileKey);
        return str.toString();
    }

    public String getQueryDataElementFileKeys() {
        StringBuilder str = new StringBuilder(256);
        cache = CacheFactory.getInstance().createCache("mapDataElementKeyToFileKey");
        HashMap mapDataElementKeyToFileKey = new HashMap();
        LoadFileTree.mapDataElementKeyToXmlPath.forEach((key, treeNode) -> {
            StringBuilder columnStr = new StringBuilder().append(treeNode.name.substring(0, treeNode.name.indexOf(".xml"))).append(",").append(treeNode.name.substring(0, treeNode.name.indexOf(".xml"))).append(" ").append(treeNode.description).append(";");
            str.append((CharSequence)columnStr);
            com.bokesoft.yes.design.xml.node.XmlTree xmlTree = null;
            try {
                xmlTree = Xml4jUtil.parseTree(treeNode.key);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<String, AbstractNode> entry : xmlTree.getMapNodes().entrySet()) {
                com.bokesoft.yes.design.xml.node.TagNode node = (com.bokesoft.yes.design.xml.node.TagNode)entry.getValue();
                if (!"DataElement".equals(node.getTagName())) continue;
                mapDataElementKeyToFileKey.put(node.getAttributes().get("Key"), treeNode.name.substring(0, treeNode.name.indexOf(".xml")));
            }
        });
        cache.put("mapDataElementKeyToFileKey", mapDataElementKeyToFileKey);
        return str.toString();
    }

    public DataTable getDomainData(String domainKey, String domainName, String controlType, String dataType, String domainFileKey) throws Throwable {
        RichDocumentContext context = this.getMidContext();
        MetaForm metaFormKeyDialog = context.getMetaFactory().getMetaForm("D_SetDomainData_Rpt");
        MetaTable gridMetaTable = metaFormKeyDialog.getDataSource().getDataObject().getMetaTable("ED_SetDomainDataDtl");
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(gridMetaTable);
        cache = CacheFactory.getInstance().createCache("mapDomainKeyToFileKey");
        HashMap mapDomainKeyToFileKey = (HashMap)cache.get("mapDomainKeyToFileKey");
        MetaDomainDef domainDef = this.getMidContext().getMetaFactory().getDomainDef("");
        if (domainDef.getDomainCollection() == null) {
            return dataTable;
        }
        for (MetaDomain metaDomain : domainDef.getDomainCollection()) {
            Boolean result = true;
            if (StringUtils.isNotEmpty((CharSequence)domainKey)) {
                result = result != false && StringUtils.contains((CharSequence)metaDomain.getKey().toUpperCase(), (CharSequence)domainKey.toUpperCase());
            }
            if (StringUtils.isNotEmpty((CharSequence)domainName)) {
                result = result != false && StringUtils.contains((CharSequence)metaDomain.getCaption().toUpperCase(), (CharSequence)domainName.toUpperCase());
            }
            if (StringUtils.isNotEmpty((CharSequence)controlType)) {
                result = result != false && StringUtils.equals((CharSequence)ControlType.toString((Integer)metaDomain.getRefControlType()), (CharSequence)controlType);
            }
            if (StringUtils.isNotEmpty((CharSequence)dataType)) {
                result = result != false && StringUtils.equals((CharSequence)DataType.toString((Integer)metaDomain.getDataType()), (CharSequence)dataType);
            }
            if (StringUtils.isNotEmpty((CharSequence)domainFileKey)) {
                result = result != false && StringUtils.equals((CharSequence)((CharSequence)mapDomainKeyToFileKey.get(metaDomain.getKey())), (CharSequence)domainFileKey);
            }
            if (!result.booleanValue()) continue;
            dataTable.append();
            dataTable.setString("DetailDomainKey", metaDomain.getKey());
            dataTable.setString("DetailDomainName", metaDomain.getCaption());
            dataTable.setString("DetailControlType", ControlType.toString((Integer)metaDomain.getRefControlType()));
            dataTable.setString("DetailDataType", DataType.toString((Integer)metaDomain.getDataType()));
            dataTable.setString("DetailDomainFileKey", (String)mapDomainKeyToFileKey.get(metaDomain.getKey()));
        }
        return dataTable;
    }

    /*
     * Unable to fully structure code
     */
    public String beautifySQL(String sqlString) throws Throwable {
        block20: {
            if (sqlString == null) {
                return null;
            }
            sqlFormat = null;
            try {
                sqlFormat = CCJSqlParserUtil.parse((String)sqlString).toString();
                break block20;
            }
            catch (Exception e) {
                keyWords = new String[]{"ADD", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOTH", "BY", "CALL", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "CONDITION", "CONNECTION", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DATABASES", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELAYED", "DELETE", "DESC", "DESCRIBE", "DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE", "DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "ENCLOSED", "ESCAPED", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH", "FLOAT", "FLOAT4", "FLOAT8", "FOR", "FORCE", "FOREIGN", "FROM", "FULLTEXT", "GRANT", "GROUP", "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF", "IGNORE", "IN", "INDEX", "INFILE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INT1", "INT2", "INT3", "INT4", "INT8", "INTEGER", "INTERVAL", "INTO", "IS", "ITERATE", "JOIN", "KEY", "KEYS", "KILL", "LABEL", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LINEAR", "LINES", "LOAD", "LOCALTIME", "LOCALTIMESTAMP", "LOCK", "LONG", "LONGBLOB", "LONGTEXT", "LOOP", "LOW_PRIORITY", "MATCH", "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NOT", "NO_WRITE_TO_BINLOG", "NULL", "NUMERIC", "ON", "OPTIMIZE", "OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "PRECISION", "PRIMARY", "PROCEDURE", "PURGE", "RAID0", "RANGE", "READ", "READS", "REAL", "REFERENCES", "REGEXP", "RELEASE", "RENAME", "REPEAT", "REPLACE", "REQUIRE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "RLIKE", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SELECT", "SENSITIVE", "SEPARATOR", "SET", "SHOW", "SMALLINT", "SPATIAL", "SPECIFIC", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT", "SSL", "STARTING", "STRAIGHT_JOIN", "TABLE", "TERMINATED", "THEN", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK", "UNSIGNED", "UPDATE", "USAGE", "USE", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARYING", "WHEN", "WHERE", "WHILE", "WITH", "WRITE", "X509", "XOR", "YEAR_MONTH", "ZEROFILL"};
                sqlFormat = sqlString.trim().replaceAll("\\s+", " ").replaceAll("\n", " ").replaceAll("\t", "").replaceAll("\\(\\s+", "(").replaceAll("\\s+\\)", ")").replaceAll("\\s+,\\s+", ", ");
                var9_7 = keyWords;
                var8_8 = keyWords.length;
                var7_10 = 0;
                ** while (var7_10 < var8_8)
            }
lbl-1000:
            // 1 sources

            {
                word = var9_7[var7_10];
                regex = "\\b" + word + "\\b";
                matcher = Pattern.compile(regex).matcher(sqlFormat.toUpperCase());
                while (matcher.find()) {
                    sqlFormat = String.valueOf(sqlFormat.substring(0, matcher.start())) + word + sqlFormat.substring(matcher.end());
                }
                ++var7_10;
                continue;
            }
        }
        try {
            var7_11 = singleLineWords = new String[]{"FROM", "HAVING", "SELECT", "WHERE", "ORDER BY", "GROUP BY", "VALUES", "UNION ALL"};
            word = singleLineWords.length;
            matcher = 0;
            while (matcher < word) {
                word = var7_11[matcher];
                if (sqlFormat.contains(word)) {
                    if (sqlFormat.indexOf(word) == 0) {
                        sqlFormat = StringUtils.replace((String)sqlFormat, (String)(String.valueOf(word) + " "), (String)(String.valueOf(word) + "\n\t"));
                    } else {
                        sqlFormat = StringUtils.replace((String)sqlFormat, (String)(" " + word + " "), (String)("\n" + word + "\n\t"));
                        sqlFormat = StringUtils.replace((String)sqlFormat, (String)("(" + word + " "), (String)("(" + word + "\n\t"));
                    }
                }
                ++matcher;
            }
            var8_9 = keyWords = new String[]{"AND", "OR", "LEFT JOIN", "INNER JOIN", "JOIN", "IF", "SET", "UNION", "WHEN", "WHILE"};
            var7_12 = keyWords.length;
            word = 0;
            while (word < var7_12) {
                word = var8_9[word];
                if (sqlFormat.contains(word)) {
                    if (StringUtils.equals((CharSequence)word, (CharSequence)"JOIN")) {
                        spiltStrings = sqlFormat.split(" ");
                        index = Arrays.asList(spiltStrings).indexOf(word);
                        if (index != -1 && !spiltStrings[index - 1].endsWith("INNER") && !spiltStrings[index - 1].endsWith("LEFT")) {
                            sqlFormat = StringUtils.replace((String)sqlFormat, (String)(" " + word + " "), (String)("\n" + word + " "));
                        }
                    } else {
                        sqlFormat = StringUtils.replace((String)sqlFormat, (String)(" " + word + " "), (String)("\n" + word + " "));
                    }
                }
                ++word;
            }
            if (sqlFormat.contains(",")) {
                sqlFormat = StringUtils.replace((String)sqlFormat, (String)", ", (String)",\n\t");
            }
            if (sqlFormat.contains("(")) {
                index = sqlFormat.indexOf("(");
                lastIndex = sqlFormat.lastIndexOf(")");
                if (lastIndex != -1) {
                    oriIndent = 0;
                    while (sqlFormat.substring(index - oriIndent - 1, index - oriIndent).equals("\t")) {
                        ++oriIndent;
                    }
                    sqlFormat = String.valueOf(sqlFormat.substring(0, index)) + this.addIndent(sqlFormat.substring(index + 1, lastIndex), oriIndent + 1) + sqlFormat.substring(lastIndex + 1);
                }
            }
        }
        catch (Exception e) {
            return sqlFormat;
        }
        return sqlFormat;
    }

    private String addIndent(String braceString, int num) {
        if (!(braceString.contains(" ") || braceString.contains(",") || braceString.contains("\n"))) {
            return "(" + braceString + ")";
        }
        String result = braceString;
        int index = braceString.indexOf("(");
        int lastIndex = braceString.lastIndexOf(")");
        if (index != -1 && lastIndex != -1) {
            result = braceString.substring(index + 1, lastIndex);
            result = String.valueOf(braceString.substring(0, index)) + this.addIndent(result, num + 1);
        }
        int i = 0;
        while (i < num) {
            result = "\t" + result;
            result = result.replace("\n", "\n\t");
            ++i;
        }
        return "(\n" + result + "\n)";
    }

    public boolean isExistDoman(String key) throws Throwable {
        return MetaUtil.getDomain((IMetaFactory)this.getMidContext().getMetaFactory(), (String)key) != null;
    }

    public boolean isExistDataElement(String key) throws Throwable {
        return MetaUtil.getDataElement((IMetaFactory)this.getMidContext().getMetaFactory(), (String)key) != null;
    }

    public String checkMacro(String key, String dataSourceType) throws Throwable {
        RichDocument richDocument = this._context.getRichDocument();
        if (dataSourceType.isEmpty()) {
            dataSourceType = "xml";
        }
        if (!dataSourceType.equalsIgnoreCase("xml")) {
            return "true";
        }
        DataTable dataTable = richDocument.get("ED_MacroFormula_Head");
        if (dataTable == null) {
            if (key.endsWith("@pre")) {
                return "\u975e\u9a6c\u7532\u8868\u5355\u4e0d\u5141\u8bb8\u5b58\u5728@pre\u7ed3\u5c3e\u5b8f\u516c\u5f0f";
            }
            if (key.endsWith("@post")) {
                return "\u975e\u9a6c\u7532\u8868\u5355\u4e0d\u5141\u8bb8\u5b58\u5728@post\u7ed3\u5c3e\u5b8f\u516c\u5f0f";
            }
            return "true";
        }
        String FormKey = dataTable.getString("FormKey");
        if (StringUtils.isNotEmpty((CharSequence)FormKey)) {
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(FormKey);
            String extend = metaForm.getExtend();
            if (extend.isEmpty() && key.endsWith("@pre")) {
                return "\u975e\u9a6c\u7532\u8868\u5355\u4e0d\u5141\u8bb8\u5b58\u5728@pre\u7ed3\u5c3e\u5b8f\u516c\u5f0f";
            }
            if (extend.isEmpty() && key.endsWith("@post")) {
                return "\u975e\u9a6c\u7532\u8868\u5355\u4e0d\u5141\u8bb8\u5b58\u5728@post\u7ed3\u5c3e\u5b8f\u516c\u5f0f";
            }
        } else {
            if (key.endsWith("@pre")) {
                return "\u975e\u9a6c\u7532\u8868\u5355\u4e0d\u5141\u8bb8\u5b58\u5728@pre\u7ed3\u5c3e\u5b8f\u516c\u5f0f";
            }
            if (key.endsWith("@post")) {
                return "\u975e\u9a6c\u7532\u8868\u5355\u4e0d\u5141\u8bb8\u5b58\u5728@post\u7ed3\u5c3e\u5b8f\u516c\u5f0f";
            }
        }
        return "true";
    }

    public Object changeDomainKey(String key, String name) throws Throwable {
        MetaDomain domain = MetaUtil.getDomain((IMetaFactory)this.getMidContext().getMetaFactory(), (String)key);
        switch (name) {
            case "DataType": {
                return DataType.toString((Integer)domain.getDataType());
            }
            case "Precision": {
                return domain.getPrecision() == null ? 0 : domain.getPrecision();
            }
            case "Scale": {
                return domain.getScale() == null ? 0 : domain.getScale();
            }
            case "Length": {
                return domain.getLength() == null ? 0 : domain.getLength();
            }
        }
        return "";
    }

    public void changeDomainKey(String key) throws Throwable {
        if (MetaUtil.getDomain((IMetaFactory)this.getMidContext().getMetaFactory(), (String)key) != null) {
            RichDocument richDocument = this.getMidContext().getRichDocument();
            DataTable ed_newDomain = richDocument.get("ED_NewDomain");
            MetaDomain domain = MetaUtil.getDomain((IMetaFactory)this.getMidContext().getMetaFactory(), (String)key);
            ed_newDomain.setObject("DataType", (Object)DataType.toString((Integer)domain.getDataType()));
            ed_newDomain.setObject("Precision", (Object)(domain.getPrecision() == null ? 0 : domain.getPrecision()));
            ed_newDomain.setObject("Scale", (Object)(domain.getScale() == null ? 0 : domain.getScale()));
            ed_newDomain.setObject("Length", (Object)(domain.getLength() == null ? 0 : domain.getLength()));
            ed_newDomain.setObject("DomainCaption", (Object)(domain.getCaption() == null ? "" : domain.getCaption()));
            ed_newDomain.setObject("DomainNewKey", (Object)(domain.getKey() == null ? "" : domain.getKey()));
            ed_newDomain.setObject("AllowMultiSelection", domain.isAllowMultiSelection() == null ? "" : domain.isAllowMultiSelection());
            ed_newDomain.setObject("Case", domain.getCase() == null ? "" : domain.getCase());
            ed_newDomain.setObject("ItemKey", (Object)(domain.getItemKey() == null ? "" : domain.getItemKey()));
            ed_newDomain.setObject("GroupKey", (Object)(domain.getGroupKey() == null ? "" : domain.getGroupKey()));
            ed_newDomain.setObject("SourceType", (Object)ComboBoxSourceType.format((Integer)(domain.getSourceType() == null ? -1 : domain.getSourceType())));
            Integer refControlType = domain.getRefControlType();
            if (refControlType == null) {
                refControlType = 215;
            }
            ed_newDomain.setObject("ControlType", (Object)ControlType.toString((Integer)refControlType));
            DataTable ed_defaultItem = richDocument.get("ED_DefaultItem");
            MetaListBoxItemCollection items = domain.getItems();
            if (items != null) {
                ed_defaultItem.clear();
                for (MetaDefaultItem item : items) {
                    String value = item.getValue();
                    String caption = item.getCaption();
                    String icon = item.getIcon();
                    int append = ed_defaultItem.append();
                    ed_defaultItem.setObject(append, "Key", (Object)item.getKey());
                    ed_defaultItem.setObject(append, "Value", (Object)value);
                    ed_defaultItem.setObject(append, "Caption", (Object)caption);
                    ed_defaultItem.setObject(append, "Icon", (Object)icon);
                }
                richDocument.addDirtyTableFlag("ED_DefaultItem");
            }
            richDocument.addDirtyTableFlag("ED_NewDomain");
        }
    }

    public Object changeDataElementKey(String key, String name) throws Throwable {
        MetaDataElement dataElement = MetaUtil.getDataElement((IMetaFactory)this.getMidContext().getMetaFactory(), (String)key);
        switch (name) {
            case "DataType": {
                return dataElement.getDataType();
            }
            case "Precision": {
                return dataElement.getPrecision() == null ? 0 : dataElement.getPrecision();
            }
            case "Scale": {
                return dataElement.getScale() == null ? 0 : dataElement.getScale();
            }
            case "Length": {
                return dataElement.getLength() == null ? 0 : dataElement.getLength();
            }
        }
        return "";
    }

    public boolean isExistParaGroup(String key) throws Throwable {
        MetaParaGroup metaParaItems = (MetaParaGroup)MetaFactory.getGlobalInstance().getParaTable().get(key);
        if (metaParaItems != null) {
            return metaParaItems.isExtend();
        }
        return false;
    }

    public boolean isExistParameter(String key) throws Throwable {
        MetaParameterID metaParaItems = (MetaParameterID)MetaFactory.getGlobalInstance().getParameter().get(key);
        return metaParaItems != null;
    }

    public String getDataElementFileKeys(String dataElementPath, String formKey) throws Throwable {
        StringBuilder str = new StringBuilder(256).append("NewDataElementFile,NewDataElementFile \u521b\u5efa\u65b0\u7684\u6570\u636e\u5143\u7d20\u6587\u4ef6");
        String formPath = LoadFileTree.getPathByFormKey(formKey);
        LoadFileTree.mapDataElementKeyToXmlPath.forEach((a, b) -> {
            String path = StringUtils.isNotEmpty((CharSequence)dataElementPath) ? Paths.get(FilePathHelper.toBackFilePath(dataElementPath), new String[0]).relativize(Paths.get(b.key, new String[0])).toString() : (StringUtils.isNotEmpty((CharSequence)formPath) ? Paths.get(formPath, new String[0]).relativize(Paths.get(b.key, new String[0])).toString() : b.key);
            StringBuilder rowStr = new StringBuilder().append(";").append(path).append(",").append((String)a).append(" ").append(path);
            str.append((CharSequence)rowStr);
        });
        return str.toString();
    }

    public String getDomainFileKeys(String domainPath, String formKey) throws Throwable {
        StringBuilder str = new StringBuilder(256).append("NewDomainFile,NewDomainFile \u521b\u5efa\u65b0\u7684\u57df\u6587\u4ef6");
        String formPath = LoadFileTree.getPathByFormKey(formKey);
        LoadFileTree.mapDomainKeyToXmlPath.forEach((a, b) -> {
            String path = StringUtils.isNotEmpty((CharSequence)domainPath) ? Paths.get(FilePathHelper.toBackFilePath(domainPath), new String[0]).relativize(Paths.get(b.key, new String[0])).toString() : (StringUtils.isNotEmpty((CharSequence)formPath) ? Paths.get(formPath, new String[0]).relativize(Paths.get(b.key, new String[0])).toString() : b.key);
            StringBuilder rowStr = new StringBuilder().append(";").append(b.key).append(",").append((String)a).append(" ").append(path);
            str.append((CharSequence)rowStr);
        });
        return str.toString();
    }

    public String getFilePosition() throws Throwable {
        IMetaFactory metaFactory = this.getMidContext().getMetaFactory();
        StringBuilder sb = new StringBuilder(256).append(", \u5f53\u524d\u4f5c\u7528\u57df");
        MetaProjectCollection projectCollection = metaFactory.getSolution().getProjectCollection();
        for (MetaProjectProfile metaProjectProfile : projectCollection) {
            MetaSolution metaSolution;
            IMetaSolution solution;
            boolean flag;
            MetaProject metaProject = metaProjectProfile.getProject();
            if (Objects.isNull(metaProject) || !(flag = (solution = metaProject.getSolution()) instanceof MetaSolution) || !LoadFileTree.isDesignableSolution((metaSolution = (MetaSolution)solution).getKey())) continue;
            String key = metaProjectProfile.getKey();
            String caption = metaProjectProfile.getCaption();
            caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
            caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(key).append(",").append(key).append(" ").append(caption);
        }
        return sb.toString();
    }

    public Boolean checkColumn(String type, String tableKey, String formKey, String columnKey) throws Throwable {
        String str = "success";
        TwoTuple<MetaForm, MetaDataObject> twoTuple = null;
        twoTuple = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
        boolean metaFormNotNull = twoTuple.metaForm != null;
        boolean metaDataObjectNotNull = twoTuple.metaDataObject != null;
        MetaForm metaForm = (MetaForm)twoTuple.metaForm;
        MetaDataObject metaDataObject = (MetaDataObject)twoTuple.metaDataObject;
        if ("TableKey".equals(type)) {
            MetaTable table;
            if (metaFormNotNull) {
                MetaTable table2 = metaForm.getDataSource().getDataObject().getTable(tableKey);
                if (table2 != null) {
                    str = "\u5f53\u524d\u6dfb\u52a0\u7684\u8868\u6807\u8bc6 <span style = 'color:red;font-size:14px'>" + tableKey + "</span>" + " \u5df2\u7ecf\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0";
                }
            } else if (metaDataObjectNotNull && (table = metaDataObject.getTable(tableKey)) != null) {
                str = "\u5f53\u524d\u6dfb\u52a0\u7684\u8868\u6807\u8bc6 <span style = 'color:red;font-size:14px'>" + tableKey + "</span>" + " \u5df2\u7ecf\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0";
            }
        } else if ("ColumnKey".equals(type)) {
            MetaColumn metaColumn;
            if (metaFormNotNull) {
                MetaColumn metaColumn2 = metaForm.getDataSource().getDataObject().findColumn(tableKey, columnKey);
                if (metaColumn2 != null) {
                    str = "\u5f53\u524d\u6dfb\u52a0\u7684\u5217\u6807\u8bc6 <span style = 'color:red;font-size:14px'>" + columnKey + "</span>" + " \u5df2\u7ecf\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0";
                }
            } else if (metaDataObjectNotNull && (metaColumn = metaDataObject.findColumn(tableKey, columnKey)) != null) {
                str = "\u5f53\u524d\u6dfb\u52a0\u7684\u5217\u6807\u8bc6 <span style = 'color:red;font-size:14px'>" + columnKey + "</span>" + " \u5df2\u7ecf\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0";
            }
        }
        if (str != "success") {
            throw new RuntimeException(str);
        }
        return true;
    }

    public boolean newDtl() throws Throwable {
        RichDocumentContext midContext = this.getMidContext();
        RichDocument document = midContext.getRichDocument();
        DataTable tableCollection = document.getDataTable("ED_TableCollection");
        Long parentId = tableCollection.getLong("OID");
        DataTable tableFields = document.getDataTable("ED_TableFields");
        if (tableFields.findRow("POID", (Object)parentId) == -1) {
            tableFields.append();
            tableFields.setLong("POID", parentId);
            tableFields.setString("ColumnKey", "OID");
            tableFields.setString("ColumnName", "\u5bf9\u8c61\u6807\u8bc6");
            tableFields.setString("DataElementKey", "OID");
            tableFields.setString("ColumnType", MetaUtil.getDataElement((IMetaFactory)this.getMidContext().getMetaFactory(), (String)"OID").getDataType().toString());
            tableFields.append();
            tableFields.setLong("POID", parentId);
            tableFields.setString("ColumnKey", "SOID");
            tableFields.setString("ColumnName", "\u4e3b\u5bf9\u8c61\u6807\u8bc6");
            tableFields.setString("DataElementKey", "SOID");
            tableFields.setString("ColumnType", MetaUtil.getDataElement((IMetaFactory)this.getMidContext().getMetaFactory(), (String)"SOID").getDataType().toString());
            tableFields.append();
            tableFields.setLong("POID", parentId);
            tableFields.setString("ColumnKey", "POID");
            tableFields.setString("ColumnName", "\u7236\u5bf9\u8c61\u6807\u8bc6");
            tableFields.setString("DataElementKey", "POID");
            tableFields.setString("ColumnType", MetaUtil.getDataElement((IMetaFactory)this.getMidContext().getMetaFactory(), (String)"POID").getDataType().toString());
            tableFields.append();
            tableFields.setLong("POID", parentId);
            tableFields.setString("ColumnKey", "VERID");
            tableFields.setString("ColumnName", "\u5bf9\u8c61\u7248\u672c");
            tableFields.setString("DataElementKey", "VERID");
            tableFields.setString("ColumnType", MetaUtil.getDataElement((IMetaFactory)this.getMidContext().getMetaFactory(), (String)"VERID").getDataType().toString());
            tableFields.append();
            tableFields.setLong("POID", parentId);
            tableFields.setString("ColumnKey", "DVERID");
            tableFields.setString("ColumnName", "\u5bf9\u8c61\u660e\u7ec6\u7248\u672c");
            tableFields.setString("DataElementKey", "DVERID");
            tableFields.setString("ColumnType", MetaUtil.getDataElement((IMetaFactory)this.getMidContext().getMetaFactory(), (String)"DVERID").getDataType().toString());
            document.addDirtyTableFlag("ED_TableFields");
            return true;
        }
        return false;
    }

    public Boolean IsReport(String formKey) throws Throwable {
        MetaForm metaForm;
        boolean metaFormNotNull;
        TwoTuple<MetaForm, MetaDataObject> twoTuple = null;
        twoTuple = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
        boolean bl = metaFormNotNull = twoTuple.metaForm != null;
        if (metaFormNotNull && (metaForm = (MetaForm)twoTuple.metaForm).getFormType() == 5) {
            return true;
        }
        return false;
    }

    public String getColumnKeyByDataEle(int controlType) throws Throwable {
        RichDocumentContext midContext = this.getMidContext();
        String ownerFormKey = (String)midContext.getPara("OwnerFormKey");
        String gridKey = (String)midContext.getPara("GridKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(ownerFormKey);
        MetaGrid metaGrid = (MetaGrid)metaForm.getAllUIComponents().get(gridKey);
        String tableKey = metaGrid.getTableKey();
        return this.getColumnKeyByDataEle(tableKey, controlType * 10);
    }

    public String getColumnKeyByDataEle(String tableKey, int controlType) throws Throwable {
        StringBuilder str = new StringBuilder(256).append("\u65e0\u5b57\u6bb5,\u65e0\u5b57\u6bb5");
        if (StringUtils.isBlank((CharSequence)tableKey)) {
            return str.toString();
        }
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSourse = metaForm.getDataSource();
        MetaTable table = null;
        if (dataSourse != null) {
            table = dataSourse.getDataObject().getTable(tableKey);
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
            table = metaForm.getDataSource().getDataObject().getTable(tableKey);
        }
        if (Objects.isNull(table)) {
            return str.toString();
        }
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(table);
        DataTableMetaData dataTableMetaData = dataTable.getMetaData();
        int i = 0;
        int len = dataTableMetaData.getColumnCount();
        while (i < len) {
            MetaColumn metaColumn;
            ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
            String columnKey = columnInfo.getColumnKey();
            if (!"MapCount".equals(columnKey) && !"SelectField".equals(columnKey) && (metaColumn = (MetaColumn)table.get(columnKey)) != null) {
                StringBuilder columnStr;
                String caption;
                if (metaColumn.getDataElement() != null && metaColumn.getDataElement().getDomain() != null && metaColumn.getDataElement().getDomain().getRefControlType() == controlType / 10) {
                    caption = metaColumn.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                    columnStr = new StringBuilder().append(";").append(columnKey).append(",").append(columnKey).append(" ").append(caption);
                    str = str.append((CharSequence)columnStr);
                }
                if (metaColumn.getDataElement() == null) {
                    caption = metaColumn.getCaption();
                    caption = RegExUtils.replaceAll((String)caption, (String)",", (String)"\uff0c");
                    caption = RegExUtils.replaceAll((String)caption, (String)"\\s*", (String)"");
                    columnStr = new StringBuilder().append(";").append(columnKey).append(",").append(columnKey).append(" ").append(caption);
                    str = str.append((CharSequence)columnStr);
                }
            }
            ++i;
        }
        return str.toString();
    }

    public String getDataElementKeyToGridColumn(String columnKey) throws Throwable {
        RichDocumentContext midContext = this.getMidContext();
        String ownerFormKey = (String)midContext.getPara("OwnerFormKey");
        String gridKey = (String)midContext.getPara("GridKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(ownerFormKey);
        MetaGrid metaGrid = (MetaGrid)metaForm.getAllUIComponents().get(gridKey);
        String tableKey = metaGrid.getTableKey();
        if (tableKey.contains("_NODB")) {
            return "";
        }
        return this.getDataElementKey(tableKey, columnKey);
    }

    public String getDataElementKey(String tableKey, String columnKey) throws Throwable {
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSourse = metaForm.getDataSource();
        MetaTable table = null;
        if (dataSourse != null) {
            table = dataSourse.getDataObject().getTable(tableKey);
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
            table = metaForm.getDataSource().getDataObject().getTable(tableKey);
        }
        if (table == null) {
            return "";
        }
        MetaColumn metaColumn = (MetaColumn)table.get(columnKey);
        if (metaColumn == null) {
            return "";
        }
        return metaColumn.getDataElementKey();
    }

    public String getItemKeyByDataElementKey(String dataElementKey) throws Throwable {
        RichDocumentContext midContext = this.getMidContext();
        MetaDataElement dataElement = MetaUtil.getDataElement((IMetaFactory)midContext.getMetaFactory(), (String)dataElementKey);
        if (dataElement == null) {
            return "";
        }
        MetaDomain domain = dataElement.getDomain();
        if (domain == null) {
            return "";
        }
        return domain.getItemKey() == null ? "" : domain.getItemKey();
    }

    public boolean isNewColumnToGrid(String columnKey) throws Throwable {
        if (columnKey.isEmpty()) {
            return true;
        }
        RichDocumentContext midContext = this.getMidContext();
        String ownerFormKey = (String)midContext.getPara("OwnerFormKey");
        String gridKey = (String)midContext.getPara("GridKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(ownerFormKey);
        MetaGrid metaGrid = (MetaGrid)metaForm.getAllUIComponents().get(gridKey);
        String tableKey = metaGrid.getTableKey();
        if (tableKey.contains("_NODB")) {
            return true;
        }
        return this.isNewColumn(tableKey, columnKey);
    }

    public boolean isNewColumn(String tableKey, String columnKey) throws Throwable {
        RichDocumentContext midContext = this.getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = this.getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSourse = metaForm.getDataSource();
        MetaTable table = null;
        if (dataSourse != null) {
            table = dataSourse.getDataObject().getTable(tableKey);
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = this.getMidContext().getMetaFactory().getMetaForm(OtherKey);
            table = metaForm.getDataSource().getDataObject().getTable(tableKey);
        }
        if (table == null) {
            return true;
        }
        MetaColumn metaColumn = (MetaColumn)table.get(columnKey);
        return metaColumn == null ? true : metaColumn.getDataElement() == null;
    }

    public String getDataElementsByDomainKey(String domainKey, String formKey) throws Throwable {
        String solutionKey;
        RichDocumentContext midContext = this.getMidContext();
        StringBuilder sb = new StringBuilder(256);
        if (StringUtils.isEmpty((CharSequence)formKey)) {
            solutionKey = "";
        } else {
            MetaProject project = (MetaProject)((MetaFormProfile)midContext.getMetaFactory().getMetaFormList().get(formKey)).getProject();
            MetaSolution solution = (MetaSolution)project.getSolution();
            solutionKey = solution.getKey();
        }
        MetaDataElementDef dataElementDef = midContext.getMetaFactory().getDataElementDef(solutionKey);
        if (dataElementDef == null) {
            return sb.toString();
        }
        MetaDataElementCollection dataElementCollection = dataElementDef.getDataElementCollection();
        if (dataElementCollection == null) {
            return sb.toString();
        }
        for (MetaDataElement metaDataElement : dataElementCollection) {
            if (metaDataElement.getDomainKey() == null || !metaDataElement.getDomainKey().equals(domainKey)) continue;
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(metaDataElement.getKey()).append(",").append(" ").append(metaDataElement.getCaption().replaceAll(",", " "));
        }
        return sb.toString();
    }

    public void setDataElementInfo(String dataElementKey) throws Throwable {
        MetaDataElement dataElement = MetaUtil.getDataElement((IMetaFactory)this.getMidContext().getMetaFactory(), (String)dataElementKey);
        if (dataElement == null) {
            return;
        }
        RichDocument richDocument = this.getMidContext().getRichDocument();
        DataTable ed_NewDataElement = richDocument.get("ED_NewDataElement");
        ed_NewDataElement.setObject("DataElementCaption", (Object)(StringUtils.isEmpty((CharSequence)dataElement.getCaption()) ? "" : dataElement.getCaption()));
        ed_NewDataElement.setObject("ParamID", (Object)(StringUtils.isEmpty((CharSequence)dataElement.getParamID()) ? "" : dataElement.getParamID()));
        ed_NewDataElement.setObject("DefaultCaption", (Object)(StringUtils.isEmpty((CharSequence)dataElement.getDefaultCaption()) ? "" : dataElement.getDefaultCaption()));
        ed_NewDataElement.setObject("DataDiffLog", (Object)(dataElement.getDataDiffLog() != null ? 1 : 0));
        ed_NewDataElement.setObject("NoHistory", (Object)(dataElement.getNoHistory() != null ? 1 : 0));
        DataTable ed_fieldLabelCollection = richDocument.get("ED_FieldLabelCollection");
        MetaFieldLabelCollection fieldLabelCollection = dataElement.getFieldLabelCollection();
        if (fieldLabelCollection != null) {
            ed_fieldLabelCollection.clear();
            for (MetaFieldLabel label : fieldLabelCollection) {
                int append = ed_fieldLabelCollection.append();
                ed_fieldLabelCollection.setObject(append, "Key", (Object)label.getKey());
                ed_fieldLabelCollection.setObject(append, "Length", (Object)label.getLength());
                ed_fieldLabelCollection.setObject(append, "Text", (Object)(StringUtils.isEmpty((CharSequence)label.getText()) ? "" : label.getText()));
            }
            richDocument.addDirtyTableFlag("ED_NewDataElement");
        }
        richDocument.addDirtyTableFlag("ED_NewDataElement");
    }

    public String getControlType(String controlType) throws Throwable {
        if (StringUtils.isEmpty((CharSequence)controlType)) {
            return "TextEditor";
        }
        int num = Integer.parseInt(controlType);
        if (controlType.length() > 3) {
            num /= 10;
        }
        return ControlType.toString((Integer)num);
    }

    public String getFileTreeIcon(String type, String name, String parentKey) {
        String iconPath = "webdesigner/fileTree/";
        String fileName = "";
        String realName = name.split(" ")[0];
        boolean isForm = parentKey.endsWith("Form");
        if ("solution".equals(type) || "importsolution".equals(type) || "jarsolution".equals(type)) {
            fileName = "Solution.png";
        } else if ("project".equals(type)) {
            fileName = "Project.png";
        } else if ("file".equals(type)) {
            fileName = "XML.png";
        } else if ("fold".equals(type)) {
            fileName = "BPM".equals(realName) ? "BPM.png" : ("Custom".equals(realName) || "DataMap".equals(realName) || "DataStruct".equals(realName) ? "DataMap.png" : ("DataMigration".equals(realName) ? "DataMigration.png" : ("DataObject".equals(realName) ? "DataObject.png" : ("ExcelTemplate".equals(realName) || "Report".equals(realName) && !isForm ? "Report.png" : ("i18n".equals(realName) ? "i18n2.png" : ("Form".equals(realName) || "Template".equals(realName) ? "Form.png" : ("initializeData".equals(realName) ? "hot.png" : ("RelationCheck".equals(realName) ? "Relation.png" : ("DataElement".equals(realName) || "Domain".equals(realName) ? "BPMItem.png" : (isForm ? "Fold.png" : "Empty.png"))))))))));
        }
        iconPath = String.valueOf(iconPath) + fileName;
        return iconPath;
    }

    public boolean hasExtensionForm(String sourceFormKey) throws Throwable {
        if (sourceFormKey.isEmpty()) {
            return false;
        }
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(sourceFormKey);
        MetaForm extensionForm = ExtensionUtil.newDefaultProvider().getExtMetaForm((DefaultContext)this.getMidContext(), metaForm);
        return extensionForm != null;
    }

    public DataTable getDataElementData(String dataElementKey, String dataElementName, String DataElementFileKey, String domainKey, String domainName, String controlType, String dataType, String domainFileKey) throws Throwable {
        RichDocumentContext context = this.getMidContext();
        MetaForm metaFormKeyDialog = context.getMetaFactory().getMetaForm("D_SetDataElement_Rpt");
        MetaTable gridMetaTable = metaFormKeyDialog.getDataSource().getDataObject().getMetaTable("ED_SetDataElementDtl");
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(gridMetaTable);
        ArrayList dataElementKeyList = new ArrayList();
        cache = CacheFactory.getInstance().createCache("mapDataElementKeyToFileKey");
        HashMap mapDataElementKeyToFileKey = (HashMap)cache.get("mapDataElementKeyToFileKey");
        cache = CacheFactory.getInstance().createCache("mapDomainKeyToFileKey");
        HashMap mapDomainKeyToFileKey = (HashMap)cache.get("mapDomainKeyToFileKey");
        MetaDataElementDef dataElementDef = this.getMidContext().getMetaFactory().getDataElementDef();
        if (dataElementDef.getDataElementCollection() == null) {
            return dataTable;
        }
        MetaDomainDef domainDef = this.getMidContext().getMetaFactory().getDomainDef();
        if (domainDef.getDomainCollection() == null) {
            return dataTable;
        }
        for (MetaDataElement metaDataElement : dataElementDef.getDataElementCollection()) {
            MetaDomain metaDomain = (MetaDomain)domainDef.getDomainCollection().get(metaDataElement.getDomainKey());
            Boolean result = true;
            if (StringUtils.isNotEmpty((CharSequence)dataElementKey)) {
                result = result != false && StringUtils.contains((CharSequence)metaDataElement.getKey().toUpperCase(), (CharSequence)dataElementKey.toUpperCase());
            }
            if (StringUtils.isNotEmpty((CharSequence)dataElementName)) {
                result = result != false && StringUtils.contains((CharSequence)(metaDataElement.getCaption() == null ? "" : metaDataElement.getCaption().toUpperCase()), (CharSequence)dataElementName.toUpperCase());
            }
            if (StringUtils.isNotEmpty((CharSequence)DataElementFileKey)) {
                result = result != false && StringUtils.equals((CharSequence)((CharSequence)mapDataElementKeyToFileKey.get(metaDataElement.getKey())), (CharSequence)DataElementFileKey);
            }
            if (StringUtils.isNotEmpty((CharSequence)domainKey)) {
                result = result != false && StringUtils.contains((CharSequence)metaDomain.getKey().toUpperCase(), (CharSequence)domainKey.toUpperCase());
            }
            if (StringUtils.isNotEmpty((CharSequence)domainName)) {
                result = result != false && StringUtils.contains((CharSequence)(metaDomain.getCaption() == null ? "" : metaDomain.getCaption().toUpperCase()), (CharSequence)domainName.toUpperCase());
            }
            if (StringUtils.isNotEmpty((CharSequence)controlType)) {
                result = result != false && StringUtils.equals((CharSequence)ControlType.toString((Integer)metaDomain.getRefControlType()), (CharSequence)controlType);
            }
            if (StringUtils.isNotEmpty((CharSequence)dataType)) {
                result = result != false && StringUtils.equals((CharSequence)DataType.toString((Integer)metaDomain.getDataType()), (CharSequence)dataType);
            }
            if (StringUtils.isNotEmpty((CharSequence)domainFileKey)) {
                result = result != false && StringUtils.equals((CharSequence)((CharSequence)mapDomainKeyToFileKey.get(metaDomain.getKey())), (CharSequence)domainFileKey);
            }
            if (!result.booleanValue()) continue;
            dataTable.append();
            dataTable.setString("DetailDataElementKey", metaDataElement.getKey());
            dataTable.setString("DetailDataElementName", metaDataElement.getCaption());
            dataTable.setString("DetailDataElementFileKey", (String)mapDataElementKeyToFileKey.get(metaDataElement.getKey()));
            dataTable.setString("DetailDomainKey", metaDomain.getKey());
            dataTable.setString("DetailDomainName", metaDomain.getCaption());
            dataTable.setString("DetailControlType", ControlType.toString((Integer)metaDomain.getRefControlType()));
            dataTable.setString("DetailDataType", DataType.toString((Integer)metaDomain.getDataType()));
            dataTable.setString("DetailDomainFileKey", (String)mapDomainKeyToFileKey.get(metaDomain.getKey()));
        }
        return dataTable;
    }

    public DataTable getUnusedSystemField(String dataObjectKey, String tableKey) throws Throwable {
        MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(dataObjectKey);
        RichDocumentContext context = this.getMidContext();
        MetaForm metaFormKeyDialog = context.getMetaFactory().getMetaForm("D_SetSystemRow_Rpt");
        MetaTable gridMetaTable = metaFormKeyDialog.getDataSource().getDataObject().getMetaTable("ED_SetSystemRowDtl");
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(gridMetaTable);
        XmlDiffProcessor.PRIMARY_TABLE_COLUMN_LIST.stream().filter(itemMap -> {
            String key = (String)itemMap.get("Key");
            if (dataObject == null || dataObject.getTable(tableKey) == null) {
                return true;
            }
            MetaTable table = dataObject.getTable(tableKey);
            return !table.containsKey(key);
        }).forEach(itemMap -> {
            dataTable.append();
            dataTable.setString("FieldKey", (String)itemMap.get("Key"));
            dataTable.setString("Caption", (String)itemMap.get("Caption"));
            dataTable.setString("DataElementKey", (String)itemMap.get("DataElementKey"));
        });
        return dataTable;
    }

    public void addSystemRow(String datas, String tableKey) throws Throwable {
        if (StringUtils.isEmpty((CharSequence)datas)) {
            return;
        }
        RichDocumentContext context = this.getMidContext();
        RichDocument parentDocument = context.getParentDocument();
        Long poid = -1L;
        DataTable ed_tableCollection = parentDocument.getDataTable("ED_TableCollection");
        int i = 0;
        while (i < ed_tableCollection.size()) {
            String tableMark = ed_tableCollection.getString("TableMark");
            if (tableMark.equals(tableKey)) {
                poid = ed_tableCollection.getLong("OID");
            }
            ++i;
        }
        if (poid < 0L) {
            return;
        }
        JSONArray jsonArray = new JSONArray(datas);
        DataTable ed_tableFields = parentDocument.getDataTable("ED_TableFields");
        int i2 = 0;
        while (i2 < jsonArray.length()) {
            JSONObject data = jsonArray.getJSONObject(i2);
            ed_tableFields.append();
            ed_tableFields.setString("ColumnKey", data.getString("FieldKey"));
            ed_tableFields.setString("ColumnName", data.getString("Caption"));
            String dataElementKey = data.getString("DataElementKey");
            ed_tableFields.setString("DataElementKey", dataElementKey);
            ed_tableFields.setLong("POID", poid);
            MetaDataElement dataElement = MetaUtil.getDataElement((IMetaFactory)this.getMidContext().getMetaFactory(), (String)dataElementKey);
            if (dataElement != null) {
                ed_tableFields.setInt("ColumnType", dataElement.getDataType());
                ed_tableFields.setInt("Precision", Integer.valueOf(dataElement.getPrecision() == null ? 0 : dataElement.getPrecision()));
                ed_tableFields.setInt("Scale", Integer.valueOf(dataElement.getScale() == null ? 0 : dataElement.getScale()));
                ed_tableFields.setInt("Length", Integer.valueOf(dataElement.getLength() == null ? 0 : dataElement.getLength()));
            }
            ed_tableFields.setString("IsPrimaryKey", "false");
            ed_tableFields.setString("SupportI18n", "false");
            ed_tableFields.setString("Persist", "1");
            ed_tableFields.setString("NeedRights", "0");
            ed_tableFields.setString("SortType", "0");
            ++i2;
        }
        parentDocument.addDirtyTableFlag("ED_TableFields");
    }

    public String GetActiveValue() throws Throwable {
        StringBuffer sql = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        sql.append("Select m.Code, t.Name From EAU_AuthorityActivity m left join EAU_AuthorityActivity_T t on m.SOID = t.SOID and t.Lang = ?");
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.getMidContext().getEnv().getLocale());
        IDBManager dbManager = this.getMidContext().getDBManager();
        DataTable table = dbManager.execPrepareQuery(sql.toString(), values);
        table.beforeFirst();
        while (table.next()) {
            String name = table.getString("Name");
            String code = table.getString("Code");
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(code).append(",").append(code).append(" ").append(name.replaceAll(",", " "));
        }
        return sb.toString();
    }

    public String GetTCodeValue() throws Throwable {
        StringBuffer sql = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        sql.append("Select m.Code, t.Name From EGS_TCode m left join EGS_TCode_T t on m.SOID = t.SOID and t.Lang = ?");
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.getMidContext().getEnv().getLocale());
        IDBManager dbManager = this.getMidContext().getDBManager();
        DataTable table = dbManager.execPrepareQuery(sql.toString(), values);
        table.beforeFirst();
        while (table.next()) {
            String name = table.getString("Name");
            if (name == null) {
                name = "";
            }
            String code = table.getString("Code");
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(code).append(",").append(code).append(" ").append(name.replaceAll(",", " "));
        }
        return sb.toString();
    }

    public DataTable getBreakpoint(long oid) throws Throwable {
        RichDocumentContext context = this.getMidContext();
        MetaTable metaTable = context.getDataObject().getMetaTable("ED_Breakpoint");
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);
        Breakpoint breakpoint = DebuggerFacade.getBreakpoint((long)oid);
        int rowIndex = dataTable.append();
        if (Objects.isNull(breakpoint)) {
            dataTable.setLong(rowIndex, "OID", context.applyNewOID());
            dataTable.setString(rowIndex, "Type", "Expr");
            dataTable.setString(rowIndex, "ScriptText", "");
            dataTable.setString(rowIndex, "Condition", "");
            dataTable.setBoolean(rowIndex, "IsEnable", Boolean.valueOf(true));
        } else {
            dataTable.setLong(rowIndex, "OID", Long.valueOf(oid));
            dataTable.setString(rowIndex, "Type", String.valueOf(breakpoint.getType()));
            dataTable.setString(rowIndex, "ScriptText", breakpoint.getText());
            dataTable.setString(rowIndex, "Condition", breakpoint.getCondition());
            dataTable.setBoolean(rowIndex, "IsEnable", breakpoint.getEnable());
        }
        context.getRichDocument().addDirtyTableFlag("ED_Breakpoint");
        return dataTable;
    }

    public void saveBreakpoint() throws Throwable {
        RichDocument document = this.getDocument();
        DataTable dataTable = document.getDataTable("ED_Breakpoint");
        Long oid = dataTable.getLong("OID");
        Optional<Breakpoint> optional = Optional.ofNullable(DebuggerFacade.getBreakpoint((long)oid));
        Breakpoint breakpoint = optional.orElse(new Breakpoint());
        breakpoint.setOid(oid);
        breakpoint.setEnable(dataTable.getBoolean("IsEnable"));
        breakpoint.setType(dataTable.getString("Type"));
        breakpoint.setText(dataTable.getString("ScriptText"));
        breakpoint.setCondition(dataTable.getString("Condition"));
        RichDocumentContext context = this.getMidContext();
        RichDocument parentDocument = context.getParentDocument();
        DataTable dataTableList = parentDocument.getDataTable("ED_BreakpointList");
        int rowIndex = optional.map(item -> dataTableList.getPos()).orElseGet(() -> ((DataTable)dataTableList).append());
        dataTableList.setLong(rowIndex, "OID", breakpoint.getOid());
        dataTableList.setString(rowIndex, "Type", String.valueOf(breakpoint.getType()));
        dataTableList.setString(rowIndex, "ScriptText", breakpoint.getText());
        dataTableList.setString(rowIndex, "Condition", breakpoint.getCondition());
        dataTableList.setBoolean(rowIndex, "IsEnable", breakpoint.getEnable());
        dataTableList.setString(rowIndex, "EditButton", "\u7f16\u8f91");
        dataTableList.setString(rowIndex, "DeleteButton", "\u5220\u9664");
        parentDocument.addDirtyTableFlag("ED_BreakpointList");
        DebuggerFacade.saveBreakpoint((Breakpoint)breakpoint);
    }

    public void deleteBreakpoint(Long oid) throws Throwable {
        RichDocument document = this.getDocument();
        DataTable dataTable = document.getDataTable("ED_BreakpointList");
        int size = dataTable.size();
        int rowIndex = size - 1;
        while (rowIndex >= 0) {
            Long aLong = dataTable.getLong(rowIndex, "OID");
            if (Objects.equals(aLong, oid)) {
                dataTable.delete(rowIndex);
                document.addDirtyTableFlag("ED_BreakpointList");
                DebuggerFacade.deleteBreakpoint((Long)oid);
                return;
            }
            --rowIndex;
        }
    }

    public void deleteAllBreakpoint() throws Throwable {
        RichDocument document = this.getDocument();
        DataTable dataTable = document.getDataTable("ED_BreakpointList");
        dataTable.deleteAll();
        document.addDirtyTableFlag("ED_BreakpointList");
        DebuggerFacade.clearBreakpoint();
    }

    public void toggleBreakpoint(Long oid) throws Throwable {
        Breakpoint breakpoint = DebuggerFacade.getBreakpoint((long)oid);
        if (Objects.isNull(breakpoint)) {
            return;
        }
        RichDocument document = this.getDocument();
        DataTable dataTable = document.getDataTable("ED_BreakpointList");
        breakpoint.setEnable(dataTable.getBoolean("IsEnable"));
        DebuggerFacade.saveBreakpoint((Breakpoint)breakpoint);
    }

    public void toggleDebugger(boolean enable) throws Throwable {
        RichDocument document = this.getDocument();
        DataTable dataTable = document.getDataTable("ED_Toolbar");
        dataTable.setInt("ToggleEnableVisible", Integer.valueOf(enable ? 0 : 1));
        document.addDirtyTableFlag("ED_Toolbar");
        DebuggerFacade.toggleDebugger((boolean)enable);
    }

    public <EC extends IEvalContext> boolean toggleStack(int oid) throws Throwable {
        if (oid < 0) {
            return false;
        }
        RichDocument document = this.getDocument();
        DebuggerContext debuggerContext = DebuggerContext.getInstance();
        SyntaxTreeWrapper syntaxTreeWrapper = (SyntaxTreeWrapper)debuggerContext.getSyntaxTreeWrapperMap().get(oid);
        DataTable dataTable = document.getDataTable("ED_VariantList");
        dataTable.clear();
        IOMetaObject.paddingVariant(dataTable, syntaxTreeWrapper);
        document.addDirtyTableFlag("ED_VariantList");
        dataTable = document.getDataTable("ED_SyntaxTree");
        dataTable.clear();
        IOMetaObject.paddingSyntaxTree(dataTable, syntaxTreeWrapper);
        document.addDirtyTableFlag("ED_SyntaxTree");
        return true;
    }

    public void operateDebugger(String operateType) {
        DebuggerFacade.operateDebugger((OperateTypeEnum)OperateTypeEnum.getEnum((String)operateType));
    }

    public boolean isText(String value) {
        return StringUtils.equals((CharSequence)value, (CharSequence)"Text");
    }

    public boolean isNumber(String value) {
        return StringUtils.equals((CharSequence)value, (CharSequence)"Number");
    }

    public boolean isBoolean(String value) {
        return StringUtils.equals((CharSequence)value, (CharSequence)"Boolean");
    }

    public boolean CanVisible(String formKey) throws Throwable {
        String ownerFormKey = (String)this._context.getPara("OwnerFormKey");
        if (MetaFactory.getGlobalInstance().getMetaFormList().get(ownerFormKey) == null) {
            return false;
        }
        return !MetaFactory.getGlobalInstance().getMetaForm(ownerFormKey).getExtend().isEmpty();
    }

    public String getParamID() throws Throwable {
        StringBuilder sb = new StringBuilder(256);
        MetaParameter parameter = this._context.getMetaFactory().getParameter();
        if (parameter == null) {
            return sb.toString();
        }
        int i = 0;
        while (i < parameter.size()) {
            MetaParameterID metaParameterID = (MetaParameterID)parameter.get(i);
            String key = metaParameterID.getKey();
            String description = metaParameterID.getDescription();
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(key).append(",").append(" ").append(description.replaceAll(",", " "));
            ++i;
        }
        return sb.toString();
    }
}

