/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.function;

import com.bokesoft.erp.entity.util.EntityDesigerContextAction;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CompositeComponentUtil
extends EntityDesigerContextAction {
    public CompositeComponentUtil(RichDocumentContext _context) {
        super(_context);
    }

    public String getCompositeComponentList() throws Throwable {
        StringBuilder sb = new StringBuilder(256);
        Element node = CompositeComponentUtil.getCompositeComponentRoot();
        List compositeComponents = node.elements("CompositeComponent");
        int i = 0;
        while (i < compositeComponents.size()) {
            Element element = (Element)compositeComponents.get(i);
            String key = element.attributeValue("Key");
            String caption = element.attributeValue("Caption");
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(key).append(",").append(" ").append(caption);
            ++i;
        }
        return sb.toString();
    }

    public static Element getCompositeComponentRoot() throws Throwable {
        String solutionPath = LoadFileTree.getSolutionPath("YigoERP");
        String entryPath = Paths.get(solutionPath, String.valueOf(File.separator) + "Resource" + File.separator + "designer" + File.separator + "CompositeComponents.xml").toString();
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(entryPath));
        Element node = document.getRootElement();
        return node;
    }
}

