/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.datamap.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.dataMigration.util.DataMigrationOperJsonUtil;
import com.bokesoft.yes.design.dataMigration.util.DataMigrationOperXmlUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperJsonUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.design.utils.XmlFormat;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.design.vo.JsonDataMapVo;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.Xml4jUtil;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultCDATA;

public class DataMapOperXmlUtil {
    private static final Logger logger = Logger.getLogger(DataMapOperXmlUtil.class.getName());
    private static final DataMapOperJsonUtil dataMapOperJsonUtil;
    private static final DataMigrationOperJsonUtil dataMigrationOperJsonUtil;

    static {
        dataMigrationOperJsonUtil = new DataMigrationOperJsonUtil();
        dataMapOperJsonUtil = new DataMapOperJsonUtil();
    }

    public ResponseResult<JSONArray> dataMapUpdateXml(JsonDataMapVo jsonDataMapVo) throws Throwable {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        FileOutputStream fileOutputStream = null;
        XMLWriter writer = null;
        String filePaths = jsonDataMapVo.getFilePath();
        JSONObject frontUpdateJson = JSON.parseObject((String)jsonDataMapVo.getContent());
        if (jsonDataMapVo.getBatchAddArr() != null && jsonDataMapVo.getBatchAddArr().size() >= 0) {
            String tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
            if (StringUtils.isBlank((CharSequence)tempPath)) {
                tempPath = filePaths;
            }
            SAXReader reader = new SAXReader();
            Document document = reader.read(new File(tempPath));
            for (String field : jsonDataMapVo.getBatchAddArr()) {
                frontUpdateJson.put("value", (Object)field);
                try {
                    this.getJsonArrayResponseResultByArry(frontUpdateJson, jsonDataMapVo, result, document);
                }
                catch (Exception e) {
                    logger.warning("\u66f4\u65b0xml\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
                    result.setCode(999);
                    result.setMsg("\u66f4\u65b0xml\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
                }
                catch (Throwable throwable) {
                    logger.warning(throwable.getMessage());
                }
            }
            OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
            String solutionPath = String.valueOf(FilePathHelper.getWorkspacePath()) + File.separator;
            String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", String.valueOf(filePaths.substring(solutionPath.length()).replace(File.separator, "__")) + "." + System.currentTimeMillis()).toString();
            fileOutputStream = new FileOutputStream(newFilePath);
            XmlFileProcessor.stackput(filePaths, newFilePath);
            writer = new XMLWriter(fileOutputStream, format);
            writer.write(document);
            result.setCode(0);
            result.setMsg("\u66f4\u65b0xml\u6210\u529f");
            DataMapOperXmlUtil.setData(result, filePaths);
            DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
        } else {
            this.getJsonArrayResponseResult(frontUpdateJson, jsonDataMapVo, result, fileOutputStream, writer, filePaths);
        }
        return result;
    }

    private ResponseResult<JSONArray> getJsonArrayResponseResultByArry(JSONObject frontUpdateJson, JsonDataMapVo jsonDataMapVo, ResponseResult<JSONArray> result, Document document) throws Throwable {
        ResponseResult<JSONArray> result1 = this.getJsonArrayResponseResult(frontUpdateJson, jsonDataMapVo, result, document);
        return result1;
    }

    private ResponseResult<JSONArray> getJsonArrayResponseResult(JSONObject frontUpdateJson, JsonDataMapVo jsonDataMapVo, ResponseResult<JSONArray> result, Document document) throws Throwable {
        String name;
        String[] split;
        String targetField = jsonDataMapVo.getTargetField();
        Element root = document.getRootElement();
        boolean mergeToSource = StringUtils.isNotEmpty((CharSequence)root.attributeValue("MergeToSource"));
        boolean extend = StringUtils.isNotEmpty((CharSequence)root.attributeValue("Extend"));
        String formKey = jsonDataMapVo.getFormKey();
        String oldValue = jsonDataMapVo.getOldValue();
        if (oldValue != null) {
            oldValue = oldValue.replaceAll("'", "\"");
        }
        String key = frontUpdateJson.getString("key");
        String keyID = frontUpdateJson.getString("keyID");
        String width = frontUpdateJson.getString("width");
        String endField = frontUpdateJson.getString("targetField");
        if (endField != null) {
            endField = endField.replaceAll("'", "\"");
        }
        String value = "";
        String field = "";
        String nodeName = "";
        String tableKey = "";
        String type = "";
        String fieldKey = "";
        try {
            tableKey = frontUpdateJson.getString("tableKey");
            type = frontUpdateJson.getString("Type");
            fieldKey = frontUpdateJson.getString("fieldKey");
            if (fieldKey != null) {
                fieldKey = fieldKey.replaceAll("'", "\"");
            }
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        if ("formField".equalsIgnoreCase(key) || "targetFormField".equalsIgnoreCase(key)) {
            value = frontUpdateJson.getString("value");
            split = value.split("_@_");
            formKey = split[4];
            field = split[1];
            tableKey = split[3];
            nodeName = jsonDataMapVo.getNodeName();
        } else if (key.contains("feedbackFormField")) {
            value = frontUpdateJson.getString("value");
            split = value.split("_@_");
            formKey = split[4];
            field = split[1];
            tableKey = split[3];
            nodeName = jsonDataMapVo.getNodeName();
        } else if ("StatusFieldKey_Feed".equalsIgnoreCase(key) || "Condition_Feed".equalsIgnoreCase(key) || "StatusValue_Feed".equalsIgnoreCase(key)) {
            nodeName = "";
            value = frontUpdateJson.getString("value");
        } else {
            nodeName = jsonDataMapVo.getNodeName();
            value = frontUpdateJson.getString("value");
            if (value != null) {
                value = value.replaceAll("'", "\"");
            }
        }
        String tableNode = "";
        String filedNode = "";
        List elements = null;
        if ("SourceTableCollection".equalsIgnoreCase(nodeName)) {
            tableNode = "SourceTable";
            filedNode = "SourceField";
            elements = root.element(nodeName).elements(tableNode);
        } else if ("TargetTableCollection".equalsIgnoreCase(nodeName)) {
            tableNode = "TargetTable";
            filedNode = "TargetField";
            elements = root.element(nodeName).elements(tableNode);
        } else if ("FeedbackCollection".equalsIgnoreCase(nodeName)) {
            if (!"sourcekey".equalsIgnoreCase(key)) {
                key = "FeedBackField";
            }
            tableNode = "FeedbackTable";
            filedNode = "FeedbackField";
        }
        if (formKey != null) {
            formKey = formKey.split("__")[0];
            name = root.getName();
            if ("Map".equalsIgnoreCase(name)) {
                if ("SourceTableCollection".equalsIgnoreCase(nodeName)) {
                    formKey = root.attributeValue("SrcFormKey");
                } else if ("TargetTableCollection".equalsIgnoreCase(nodeName)) {
                    formKey = root.attributeValue("TgtFormKey");
                } else if ("FeedbackCollection".equalsIgnoreCase(nodeName)) {
                    List feedbackElements = root.element("FeedbackCollection").elements("FeedbackObject");
                    for (Element element1 : feedbackElements) {
                        if (!formKey.equalsIgnoreCase(element1.attributeValue("FormKey"))) continue;
                        formKey = element1.attributeValue("FormKey");
                        break;
                    }
                }
            } else if ("SourceTableCollection".equalsIgnoreCase(nodeName)) {
                formKey = root.attributeValue("SrcDataObjectKey");
            } else if ("TargetTableCollection".equalsIgnoreCase(nodeName)) {
                formKey = root.attributeValue("TgtDataObjectKey");
            }
        }
        name = root.getQName().getName();
        String nodeKey = "Key";
        if ("DataMigration".equalsIgnoreCase(name)) {
            nodeKey = "TableKey";
        }
        block44 : switch (key) {
            case "Caption": 
            case "MinPushValue": 
            case "StatusFieldKey": 
            case "RemainderPushValue": 
            case "MapCondition": 
            case "Description": 
            case "StatusValue": 
            case "HeadCondition": 
            case "DetailCondition": 
            case "PostProcess": {
                if ("DetailCondition".equalsIgnoreCase(key)) {
                    key = "Condition";
                }
                if (StringUtils.isNotEmpty((CharSequence)value)) {
                    root.addAttribute(key, value);
                    break;
                }
                this.deleteXmlElementAttribute(root, root.attribute(key));
                break;
            }
            case "StatusFieldKey_Feed": {
                Element element5 = root.element("FeedbackCollection");
                if (StringUtils.isNotEmpty((CharSequence)value)) {
                    element5.addAttribute("StatusFieldKey", value);
                    break;
                }
                this.deleteXmlElementAttribute(element5, element5.attribute("StatusFieldKey"));
                break;
            }
            case "StatusValue_Feed": {
                Element element3 = root.element("FeedbackCollection");
                if (StringUtils.isNotEmpty((CharSequence)value)) {
                    element3.addAttribute("StatusValue", value);
                    break;
                }
                this.deleteXmlElementAttribute(element3, element3.attribute("StatusValue"));
                break;
            }
            case "Condition_Feed": {
                Element element4 = root.element("FeedbackCollection");
                if (StringUtils.isNotEmpty((CharSequence)value)) {
                    element4.addAttribute("Condition", value);
                    break;
                }
                this.deleteXmlElementAttribute(element4, element4.attribute("Condition"));
                break;
            }
            case "MarkMapCount": 
            case "MapRelationValue": 
            case "AllowRemainderPush": {
                if ("false".equalsIgnoreCase(value)) {
                    root.addAttribute(key, value);
                    break;
                }
                this.deleteXmlElementAttribute(root, root.attribute(key));
                break;
            }
            case "PullDataOnly": {
                if ("true".equalsIgnoreCase(value)) {
                    root.addAttribute(key, value);
                    break;
                }
                this.deleteXmlElementAttribute(root, root.attribute(key));
                break;
            }
            case "sourceTypeKey": {
                Element node = (Element)root.selectSingleNode("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']");
                String maxKey1 = node.attributeValue("MaxKey");
                Element elements11 = (Element)root.selectSingleNode("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']/SourceField[@Definition='" + fieldKey + "'][@TargetFieldKey='" + endField + "']");
                if ("default".equals(value)) {
                    if (mergeToSource) {
                        if (StringUtils.isNotEmpty((CharSequence)maxKey1)) {
                            node.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey1) + 1));
                            elements11.addAttribute("Key", "merge_" + (Integer.valueOf(maxKey1) + 1));
                            break;
                        }
                        node.addAttribute("MaxKey", String.valueOf(node.elements().size()));
                        elements11.addAttribute("Key", "merge_" + node.elements().size());
                        break;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)maxKey1)) {
                        node.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey1) + 1));
                        elements11.addAttribute("Key", "field_" + (Integer.valueOf(maxKey1) + 1));
                        break;
                    }
                    node.addAttribute("MaxKey", String.valueOf(node.elements().size()));
                    elements11.addAttribute("Key", "field_" + node.elements().size());
                    break;
                }
                elements11.addAttribute("Key", value);
                break;
            }
            case "targetFormField": 
            case "formField": {
                Element element = root.element(nodeName);
                Element tabelele = null;
                if (Objects.isNull(element.element(tableNode))) {
                    tabelele = element.addElement(tableNode);
                    if ("DataMigration".equalsIgnoreCase(name)) {
                        tabelele.addAttribute("TableKey", tableKey);
                        if (nodeName.equalsIgnoreCase("TargetTableCollection")) {
                            tabelele.addElement(filedNode).addAttribute("FieldKey", field);
                            break;
                        }
                        tabelele.addElement(filedNode).addAttribute("Definition", field);
                        break;
                    }
                    tabelele.addAttribute("DataSource", tableKey);
                    tabelele.addAttribute("Key", tableKey);
                    tabelele.addAttribute("Type", "Table");
                    if (nodeName.equalsIgnoreCase("SourceTableCollection")) {
                        if (mergeToSource) {
                            tabelele.addElement(filedNode).addAttribute("Definition", field).addAttribute("Key", "merge_1");
                            tabelele.addAttribute("MaxKey", "1");
                            break;
                        }
                        if (!extend) {
                            tabelele.addElement(filedNode).addAttribute("Definition", field).addAttribute("Key", "1");
                            tabelele.addAttribute("MaxKey", "1");
                            break;
                        }
                        tabelele.addElement(filedNode).addAttribute("Definition", field).addAttribute("Key", "field_1");
                        tabelele.addAttribute("MaxKey", "1");
                        break;
                    }
                    tabelele.addElement(filedNode).addAttribute("Definition", field);
                    break;
                }
                List tableList = element.elements(tableNode);
                ArrayList<String> list = new ArrayList<String>();
                for (Element eleList : tableList) {
                    if ("Map".equalsIgnoreCase(name)) {
                        list.add(eleList.attributeValue("Key"));
                        continue;
                    }
                    if (!"DataMigration".equalsIgnoreCase(name)) continue;
                    list.add(eleList.attributeValue("TableKey"));
                }
                if (!list.contains(tableKey)) {
                    tabelele = element.addElement(tableNode);
                    if ("DataMigration".equalsIgnoreCase(name)) {
                        tabelele.addAttribute("TableKey", tableKey);
                        if ("targetFormField".equalsIgnoreCase(key)) {
                            tabelele.addElement(filedNode).addAttribute("FieldKey", field);
                            break;
                        }
                        tabelele.addElement(filedNode).addAttribute("Definition", field);
                        break;
                    }
                    tabelele.addAttribute("DataSource", tableKey);
                    tabelele.addAttribute("Key", tableKey);
                    tabelele.addAttribute("Type", "Table");
                    if (nodeName.equalsIgnoreCase("SourceTableCollection")) {
                        if (mergeToSource) {
                            tabelele.addElement(filedNode).addAttribute("Definition", field).addAttribute("Key", "merge_1");
                            tabelele.addAttribute("MaxKey", "1");
                            break;
                        }
                        if (!extend) {
                            tabelele.addElement(filedNode).addAttribute("Definition", field).addAttribute("Key", "1");
                            tabelele.addAttribute("MaxKey", "1");
                            break;
                        }
                        tabelele.addElement(filedNode).addAttribute("Definition", field).addAttribute("Key", "field_1");
                        tabelele.addAttribute("MaxKey", "1");
                        break;
                    }
                    tabelele.addElement(filedNode).addAttribute("Definition", field);
                    break;
                }
                this.findTablekey(nodeName, field, tableKey, filedNode, tableList, name, mergeToSource, extend);
                break;
            }
            case "sourcekey": 
            case "sourceContent": {
                if ("FeedbackCollection".equalsIgnoreCase(nodeName)) {
                    List feedbackObject = root.element(nodeName).elements("FeedbackObject");
                    for (Element ele : feedbackObject) {
                        List feedbackTable = ele.elements(tableNode);
                        for (Element element1 : feedbackTable) {
                            if (!element1.attributeValue("TableKey").equalsIgnoreCase(tableKey) || !StringUtils.isNotEmpty((CharSequence)value)) continue;
                            if (StringUtils.isNotEmpty((CharSequence)oldValue)) {
                                List Field2 = element1.elements(filedNode);
                                for (Element eleCoustOrFormula : Field2) {
                                    if (!eleCoustOrFormula.attributeValue("FieldKey").equalsIgnoreCase(oldValue)) continue;
                                    eleCoustOrFormula.addAttribute("FieldKey", value);
                                }
                                continue;
                            }
                            ele.addElement(filedNode).addAttribute("FieldKey", value);
                        }
                    }
                    break;
                }
                for (Element ele : elements) {
                    String table = DataMapOperXmlUtil.getTableKey(ele);
                    if (!table.equalsIgnoreCase(tableKey)) continue;
                    List Field3 = ele.elements(filedNode);
                    if (StringUtils.isNotEmpty((CharSequence)value)) {
                        if (StringUtils.isNotEmpty((CharSequence)oldValue)) {
                            for (Element eleCoustOrFormula : Field3) {
                                String name1 = root.getName();
                                if (!"DataMigration".equalsIgnoreCase(name1) && !"TargetField".equalsIgnoreCase(filedNode)) {
                                    if (!eleCoustOrFormula.attributeValue("Key").equalsIgnoreCase(keyID) && !eleCoustOrFormula.attributeValue("Definition").equalsIgnoreCase(oldValue)) continue;
                                    eleCoustOrFormula.addAttribute("Definition", value);
                                    continue;
                                }
                                if (!eleCoustOrFormula.attributeValue("Definition").equalsIgnoreCase(oldValue)) continue;
                                eleCoustOrFormula.addAttribute("Definition", value);
                            }
                            continue;
                        }
                        Node node1 = ele.selectSingleNode("SourceField[@Definition='" + value + "']");
                        if (node1 != null) break block44;
                        String maxKey = ele.attributeValue("MaxKey");
                        if (mergeToSource) {
                            if (StringUtils.isNotEmpty((CharSequence)maxKey)) {
                                ele.addElement(filedNode).addAttribute("Definition", value).addAttribute("Type", type).addAttribute("Key", "merge_" + (Integer.valueOf(maxKey) + 1));
                                ele.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey) + 1));
                                continue;
                            }
                            ele.addElement(filedNode).addAttribute("Definition", value).addAttribute("Type", type).addAttribute("Key", "merge_" + ele.elements().size());
                            ele.addAttribute("MaxKey", String.valueOf(ele.elements().size()));
                            continue;
                        }
                        if (!extend) {
                            if (StringUtils.isNotEmpty((CharSequence)maxKey)) {
                                if ("TargetField".equalsIgnoreCase(filedNode)) {
                                    ele.addElement(filedNode).addAttribute("Definition", value).addAttribute("Type", type);
                                } else {
                                    ele.addElement(filedNode).addAttribute("Definition", value).addAttribute("Type", type).addAttribute("Key", String.valueOf(Integer.valueOf(maxKey) + 1));
                                }
                                ele.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey) + 1));
                                continue;
                            }
                            if ("TargetField".equalsIgnoreCase(filedNode)) {
                                ele.addElement(filedNode).addAttribute("Definition", value).addAttribute("Type", type);
                            } else {
                                ele.addElement(filedNode).addAttribute("Definition", value).addAttribute("Type", type).addAttribute("Key", String.valueOf(ele.elements().size()));
                            }
                            ele.addAttribute("MaxKey", String.valueOf(ele.elements().size()));
                            continue;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)maxKey)) {
                            if ("TargetField".equalsIgnoreCase(filedNode)) {
                                ele.addElement(filedNode).addAttribute("Definition", value).addAttribute("Type", type);
                            } else {
                                ele.addElement(filedNode).addAttribute("Definition", value).addAttribute("Type", type).addAttribute("Key", "field_" + (Integer.valueOf(maxKey) + 1));
                            }
                            ele.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey) + 1));
                            continue;
                        }
                        if ("TargetField".equalsIgnoreCase(filedNode)) {
                            ele.addElement(filedNode).addAttribute("Definition", value).addAttribute("Type", type);
                        } else {
                            ele.addElement(filedNode).addAttribute("Definition", value).addAttribute("Type", type).addAttribute("Key", "field_" + ele.elements().size());
                        }
                        ele.addAttribute("MaxKey", String.valueOf(ele.elements().size()));
                        continue;
                    }
                    for (Element elefield : Field3) {
                        if (!elefield.attributeValue("Definition").equalsIgnoreCase(oldValue)) continue;
                        ele.remove(elefield);
                    }
                }
                break;
            }
            case "TargetTableKey": {
                boolean TargetFlag = false;
                Element tagNode = null;
                for (Element ele : elements) {
                    if (ele.attributeValue("TargetTableKey") != null && ele.attributeValue("TargetTableKey").equalsIgnoreCase(value) && !ele.attributeValue("Key").equalsIgnoreCase(tableKey)) {
                        TargetFlag = true;
                        break;
                    }
                    if (!ele.attributeValue("Key").equalsIgnoreCase(tableKey)) continue;
                    tagNode = ele;
                }
                if (Objects.isNull(tagNode)) {
                    tableNode = "SourceTable";
                    nodeName = "SourceTableCollection";
                    elements = root.element(nodeName).elements(tableNode);
                    for (Element ele : elements) {
                        if (ele.attributeValue("TargetTableKey") != null && ele.attributeValue("TargetTableKey").equalsIgnoreCase(value) && !ele.attributeValue("Key").equalsIgnoreCase(tableKey)) {
                            TargetFlag = true;
                            break;
                        }
                        if (!ele.attributeValue("Key").equalsIgnoreCase(tableKey)) continue;
                        tagNode = ele;
                    }
                }
                if (TargetFlag) {
                    result.setCode(999);
                    result.setMsg("\u8be5\u8868\u662f\u5176\u4ed6\u6e90\u8868\u7684\u76ee\u6807\u8868,\u4e0d\u80fd\u518d\u9009\uff01");
                    return result;
                }
                if (value.isEmpty()) {
                    tagNode.remove(tagNode.attribute("TargetTableKey"));
                    break;
                }
                tagNode.addAttribute("TargetTableKey", value);
                break;
            }
            case "IsPrimary": {
                if ("true".equalsIgnoreCase(value)) {
                    for (Element ele : elements) {
                        if ("true".equalsIgnoreCase(ele.attributeValue("IsPrimary")) && !ele.attributeValue(nodeKey).equalsIgnoreCase(tableKey)) {
                            ele.remove(ele.attribute("IsPrimary"));
                            continue;
                        }
                        if (!ele.attributeValue(nodeKey).equalsIgnoreCase(tableKey)) continue;
                        ele.addAttribute("IsPrimary", value);
                    }
                } else {
                    for (Element eleNode : elements) {
                        if (!eleNode.attributeValue(nodeKey).equalsIgnoreCase(tableKey) || eleNode.attribute("IsPrimary") == null) continue;
                        eleNode.remove(eleNode.attribute("IsPrimary"));
                        break block44;
                    }
                }
                break;
            }
            case "DataMapCondition": {
                for (Element eleNode : elements) {
                    if (!eleNode.attributeValue(nodeKey).equalsIgnoreCase(tableKey)) continue;
                    if (eleNode.attribute("Condition") != null) {
                        eleNode.remove(eleNode.attribute("Condition"));
                    }
                    eleNode.addAttribute("Condition", value);
                    break block44;
                }
                break;
            }
            case "RowTrigger": {
                for (Element eleNode : elements) {
                    if (!eleNode.attributeValue(nodeKey).equalsIgnoreCase(tableKey)) continue;
                    if (eleNode.attribute("RowTrigger") != null) {
                        eleNode.remove(eleNode.attribute("RowTrigger"));
                    }
                    eleNode.addAttribute("RowTrigger", value);
                    break block44;
                }
                break;
            }
            case "RefFieldKey": {
                for (Element ele : elements) {
                    String tableKey1 = DataMapOperXmlUtil.getTableKey(ele);
                    if (!tableKey1.equalsIgnoreCase(tableKey)) continue;
                    List sourceField = ele.elements("SourceField");
                    for (Element elefield : sourceField) {
                        if (!elefield.attributeValue("Definition").equalsIgnoreCase(fieldKey)) continue;
                        if (!"".equalsIgnoreCase(value) && StringUtils.isNotEmpty((CharSequence)value)) {
                            elefield.addAttribute("RefFieldKey", value);
                            continue;
                        }
                        elefield.remove(elefield.attribute("RefFieldKey"));
                    }
                }
                break;
            }
            case "EdgeType": {
                if ("Focus".equalsIgnoreCase(value)) {
                    for (Element ele : elements) {
                        List sourceField = ele.elements("SourceField");
                        for (Element elefield : sourceField) {
                            if (!"Focus".equalsIgnoreCase(elefield.attributeValue("EdgeType")) || elefield.attributeValue("Definition").equalsIgnoreCase(fieldKey)) continue;
                            result.setCode(999);
                            result.setMsg("\u4fee\u6539\u5931\u8d25,\u5173\u6ce8\u5b57\u6bb5\u5df2\u7ecf\u5b58\u5728\u65e0\u6cd5\u8bbe\u7f6e");
                            return result;
                        }
                        for (Element elefield : sourceField) {
                            if (!elefield.attributeValue("Definition").equalsIgnoreCase(fieldKey) || !endField.equalsIgnoreCase(elefield.attributeValue("TargetFieldKey"))) continue;
                            elefield.addAttribute("EdgeType", "Focus");
                        }
                    }
                } else {
                    for (Element ele : elements) {
                        List sourceField = ele.elements("SourceField");
                        for (Element elefield : sourceField) {
                            if (!elefield.attributeValue("Definition").equalsIgnoreCase(fieldKey) || !endField.equalsIgnoreCase(elefield.attributeValue("TargetFieldKey"))) continue;
                            elefield.remove(elefield.attribute("EdgeType"));
                        }
                    }
                }
                break;
            }
            case "FeedbackFormKey": {
                String left;
                Element feedbackCollection = root.element("FeedbackCollection");
                String top = frontUpdateJson.getString("top");
                if ("null".equalsIgnoreCase(top)) {
                    top = "26";
                }
                if ("null".equalsIgnoreCase(left = frontUpdateJson.getString("left"))) {
                    left = "723";
                }
                String dataObject = MetaFactory.getGlobalInstance().getMetaForm(value).getDataSource().getDataObject().getKey();
                if (Objects.isNull(feedbackCollection) && value != null) {
                    Element collection = root.addElement("FeedbackCollection").addElement("FeedbackObject");
                    collection.addAttribute("Height", "60").addAttribute("FormKey", value).addAttribute("ObjectKey", dataObject).addAttribute("Width", width).addAttribute("X", left).addAttribute("Y", String.valueOf(Integer.valueOf(top) + 80));
                    break;
                }
                if (value == null) break;
                Element collection = feedbackCollection.addElement("FeedbackObject");
                collection.addAttribute("Height", "60").addAttribute("FormKey", value).addAttribute("ObjectKey", dataObject).addAttribute("Width", width).addAttribute("X", left).addAttribute("Y", String.valueOf(Integer.valueOf(top) + 80));
                break;
            }
            case "FeedBackField": {
                Boolean flag = false;
                List feedbackObject = root.element(nodeName).elements("FeedbackObject");
                for (Element ele : feedbackObject) {
                    if (!ele.attributeValue("FormKey").equalsIgnoreCase(formKey)) continue;
                    List feedbackTable = ele.elements(tableNode);
                    for (Element element1 : feedbackTable) {
                        List filedNode1 = element1.elements(filedNode);
                        boolean a = false;
                        for (Element element2 : filedNode1) {
                            if (!element2.attributeValue("FieldKey").equalsIgnoreCase(field)) continue;
                            a = true;
                            flag = true;
                            break;
                        }
                        if (a || !element1.attributeValue("TableKey").equalsIgnoreCase(tableKey)) continue;
                        element1.addElement(filedNode).addAttribute("FieldKey", field);
                        flag = true;
                    }
                    if (flag.booleanValue()) continue;
                    ele.addElement(tableNode).addAttribute("TableKey", tableKey).addElement(filedNode).addAttribute("FieldKey", field);
                }
                break;
            }
            case "ConditionField": 
            case "Editable": {
                this.setLigature(key, value, nodeName, tableKey, fieldKey, root, endField);
                break;
            }
            case "OpSign": 
            case "FeedCondition": 
            case "PostFormulaTrigger": 
            case "PostTrigger": {
                List targetTable = root.element(nodeName).elements("TargetTable");
                this.dataProcessing(key, endField, value, tableKey, fieldKey, targetTable);
                break;
            }
            case "IsNegtive": 
            case "PeriodValue": 
            case "MigrationOpSign": 
            case "MapFormula": 
            case "GroupingPolicy": {
                if ("MigrationOpSign".equalsIgnoreCase(key)) {
                    key = key.split("Migration")[1];
                }
                for (Element ele : elements) {
                    String tableKey1 = DataMapOperXmlUtil.getTableKey(ele);
                    if (!tableKey1.equalsIgnoreCase(tableKey)) continue;
                    List sourceField = ele.elements("SourceField");
                    for (Element source : sourceField) {
                        if (!source.attributeValue("Definition").equalsIgnoreCase(fieldKey) || targetField == null || !source.attributeValue("TargetFieldKey").equalsIgnoreCase(targetField)) continue;
                        if (value != null && !"".equalsIgnoreCase(value)) {
                            source.addAttribute(key, value);
                            continue;
                        }
                        source.remove(source.attribute(key));
                    }
                }
                break;
            }
        }
        return null;
    }

    private ResponseResult<JSONArray> getJsonArrayResponseResult(JSONObject frontUpdateJson, JsonDataMapVo jsonDataMapVo, ResponseResult<JSONArray> result, FileOutputStream fileOutputStream, XMLWriter writer, String filePaths) throws Throwable {
        try {
            SAXReader reader;
            Document document;
            ResponseResult<JSONArray> result1;
            String tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
            if (StringUtils.isBlank((CharSequence)tempPath)) {
                tempPath = filePaths;
            }
            if ((result1 = this.getJsonArrayResponseResult(frontUpdateJson, jsonDataMapVo, result, document = (reader = new SAXReader()).read(new File(tempPath)))) != null) {
                ResponseResult<JSONArray> responseResult = result1;
                return responseResult;
            }
            try {
                OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
                String solutionPath = String.valueOf(FilePathHelper.getWorkspacePath()) + File.separator;
                String tmpDirPath = String.valueOf(WebDesignerConfiguration.getDesignerDataPath()) + File.separator + "tmp";
                File tmpDirFile = new File(tmpDirPath);
                if (!tmpDirFile.exists() || tmpDirFile.isDirectory()) {
                    tmpDirFile.mkdirs();
                }
                String newFilePath = Paths.get(tmpDirPath, String.valueOf(filePaths.substring(solutionPath.length()).replace(File.separator, "__")) + "." + System.currentTimeMillis()).toString();
                fileOutputStream = new FileOutputStream(newFilePath);
                XmlFileProcessor.stackput(filePaths, newFilePath);
                writer = new XMLWriter(fileOutputStream, format);
                writer.write(document);
                result.setCode(0);
                result.setMsg("\u66f4\u65b0xml\u6210\u529f");
            }
            catch (Exception e) {
                logger.warning("\u66f4\u65b0xml\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
                result.setCode(999);
                result.setMsg("\u66f4\u65b0xml\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
            }
            catch (Throwable throwable) {
                logger.warning(throwable.getMessage());
            }
        }
        finally {
            DataMapOperXmlUtil.setData(result, filePaths);
            DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
        }
        return null;
    }

    public static void setData(ResponseResult<JSONArray> result, String filePaths) throws Throwable {
        String xml_file = XmlFormat.formatXML_file(filePaths);
        String secondLine = DesignIOMetaUtil.getSecondLine(xml_file);
        JSONObject jsonFileContent = secondLine.indexOf("<DataMigration") == 0 ? dataMigrationOperJsonUtil.convertXmlToJson(filePaths) : dataMapOperJsonUtil.convertXmlToJson(filePaths);
        JSONArray array = new JSONArray();
        array.add((Object)jsonFileContent);
        result.setData(array);
    }

    public void findTablekey(String nodeName, String field, String tableKey, String filedNode, List<Element> tableList, String name, boolean mergeToSource, boolean extend) {
        for (Element ele : tableList) {
            String table = DataMapOperXmlUtil.getTableKey(ele);
            if (!table.equalsIgnoreCase(tableKey)) continue;
            boolean isBe = false;
            List elements1 = ele.elements(filedNode);
            for (Element ele1 : elements1) {
                String fieldValue = DataMapOperXmlUtil.getFieldValue(ele1);
                if (!fieldValue.equalsIgnoreCase(field) || !Objects.isNull(ele1.element("TargetFieldKey"))) continue;
                isBe = true;
            }
            if (isBe) continue;
            if ("Map".equalsIgnoreCase(name)) {
                if ("SourceTableCollection".equalsIgnoreCase(nodeName)) {
                    String maxKey;
                    if (mergeToSource) {
                        ele.addElement(filedNode).addAttribute("Definition", field).addAttribute("Key", "merge_" + ele.elements().size());
                        maxKey = ele.attributeValue("MaxKey");
                        if (StringUtils.isNotEmpty((CharSequence)maxKey)) {
                            ele.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey) + 1));
                            continue;
                        }
                        ele.addAttribute("MaxKey", "" + ele.elements().size());
                        continue;
                    }
                    if (!extend) {
                        maxKey = ele.attributeValue("MaxKey");
                        if (StringUtils.isNotEmpty((CharSequence)maxKey)) {
                            ele.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey) + 1));
                            ele.addElement(filedNode).addAttribute("Definition", field).addAttribute("Key", String.valueOf(Integer.valueOf(maxKey) + 1));
                            continue;
                        }
                        ele.addAttribute("MaxKey", "" + ele.elements().size());
                        ele.addElement(filedNode).addAttribute("Definition", field).addAttribute("Key", String.valueOf(ele.elements().size()));
                        continue;
                    }
                    ele.addElement(filedNode).addAttribute("Definition", field).addAttribute("Key", "field_" + ele.elements().size());
                    maxKey = ele.attributeValue("MaxKey");
                    if (StringUtils.isNotEmpty((CharSequence)maxKey)) {
                        ele.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey) + 1));
                        continue;
                    }
                    ele.addAttribute("MaxKey", "" + ele.elements().size());
                    continue;
                }
                ele.addElement(filedNode).addAttribute("Definition", field);
                continue;
            }
            if (!"DataMigration".equalsIgnoreCase(name)) continue;
            if ("SourceTableCollection".equalsIgnoreCase(nodeName)) {
                ele.addElement(filedNode).addAttribute("Definition", field);
                continue;
            }
            ele.addElement(filedNode).addAttribute("FieldKey", field);
        }
    }

    public ResponseResult<JSONArray> getFormField(JsonDataMapVo jsonDataMapVo, Element root) {
        boolean isIdentical = root.attributeValue("SrcDataObjectKey").equalsIgnoreCase(root.attributeValue("TgtDataObjectKey"));
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            String name = root.getName();
            String formKey = jsonDataMapVo.getFormKey();
            String filePath = jsonDataMapVo.getFilePath();
            String temFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
            if (temFilePath != null) {
                filePath = temFilePath;
            }
            if ("Map".equals(name)) {
                if ("source".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
                    formKey = root.attributeValue("SrcFormKey");
                } else if ("target".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
                    formKey = root.attributeValue("TgtFormKey");
                } else {
                    String objectKey = jsonDataMapVo.getFormKey().split("__")[0];
                    Element element = DataMapOperJsonUtil.getElement(filePath);
                    List elements = element.element("FeedbackCollection").elements("FeedbackObject");
                    for (Element element1 : elements) {
                        if (!objectKey.equalsIgnoreCase(element1.attributeValue("FormKey"))) continue;
                        formKey = element1.attributeValue("FormKey");
                        break;
                    }
                }
            } else if ("source".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
                formKey = root.attributeValue("SrcDataObjectKey");
            } else if ("target".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
                formKey = root.attributeValue("TgtDataObjectKey");
            }
            TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
            MetaForm metaForm = (MetaForm)metaFormOrMetaDataObject.metaForm;
            MetaDataObject metaDataObject = (MetaDataObject)metaFormOrMetaDataObject.metaDataObject;
            JSONArray nodesJsonArray = new JSONArray();
            MetaTableCollection tableCollection = null;
            if (isIdentical && root.attributeValue("SrcDataObjectKey").equalsIgnoreCase(formKey) && "source".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
                formKey = String.valueOf(formKey) + "__S";
            } else if (isIdentical && root.attributeValue("TgtDataObjectKey").equalsIgnoreCase(formKey) && "target".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
                formKey = String.valueOf(formKey) + "__T";
            } else if ((root.attributeValue("SrcDataObjectKey").equalsIgnoreCase(formKey) || root.attributeValue("TgtDataObjectKey").equalsIgnoreCase(formKey)) && "feedback".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
                formKey = String.valueOf(formKey) + "__Feed";
            }
            if ("Map".equals(name)) {
                String extend = root.attributeValue("Extend");
                String mergeToSource = root.attributeValue("MergeToSource");
                boolean isFilter = StringUtils.isNotEmpty((CharSequence)extend) && StringUtils.isNotEmpty((CharSequence)mergeToSource);
                String formKey1 = jsonDataMapVo.getFormKey().split("__")[0];
                if ("source".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
                    formKey1 = root.attributeValue("SrcFormKey");
                } else if ("target".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
                    formKey1 = root.attributeValue("TgtFormKey");
                } else {
                    String objectKey = jsonDataMapVo.getFormKey().split("__")[0];
                    Element element = DataMapOperJsonUtil.getElement(filePath);
                    List elements = element.element("FeedbackCollection").elements("FeedbackObject");
                    for (Element element1 : elements) {
                        if (!objectKey.equalsIgnoreCase(element1.attributeValue("FormKey"))) continue;
                        formKey1 = element1.attributeValue("FormKey");
                        break;
                    }
                }
                MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey1);
                IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
                if (metaForm != null) {
                    tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
                } else if (metaDataObject != null) {
                    tableCollection = metaDataObject.getTableCollection();
                }
                if (tableCollection != null) {
                    int i = 0;
                    while (i < tableCollection.size()) {
                        Collection elementMap;
                        MetaTable metaColumns = (MetaTable)tableCollection.get(i);
                        int finalI = i + 1;
                        String finalTableKey = metaColumns.getKey();
                        Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTableKey);
                        if (!MapUtils.isEmpty(columKeysAndFieldKeys) && !finalTableKey.contains("_NODB") && (elementMap = metaColumns.items()) != null) {
                            for (MetaColumn metaColumn : elementMap) {
                                List<String> fieldKeys;
                                if (metaColumn.getKey().contains("_NODB") || CollectionUtils.isEmpty(fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey()))) continue;
                                for (String fieldKey : fieldKeys) {
                                    if (isFilter) {
                                        Map<String, String> map = DataMapOperXmlUtil.filterFiledMap(extend, metaForm1);
                                        if (map.containsValue(fieldKey)) continue;
                                        this.setArray(formKey, nodesJsonArray, finalI, finalTableKey, metaColumn, false, true, "", metaColumns, null, idLookup, fieldKey);
                                        continue;
                                    }
                                    this.setArray(formKey, nodesJsonArray, finalI, finalTableKey, metaColumn, false, true, "", metaColumns, null, idLookup, fieldKey);
                                }
                            }
                        }
                        ++i;
                    }
                }
            } else if ("DataMigration".equals(name)) {
                this.setArrayUniversal(formKey, metaForm, metaDataObject, nodesJsonArray, true, true);
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5\u6210\u529f");
            result.setData(nodesJsonArray);
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    public void setArrayUniversal(String formKey, MetaForm metaForm, MetaDataObject metaDataObject, JSONArray nodesJsonArray, boolean isNotMap, boolean isAll) throws Throwable {
        MetaTableCollection tableCollection = null;
        if (metaForm != null) {
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        } else if (metaDataObject != null) {
            tableCollection = metaDataObject.getTableCollection();
        }
        if (tableCollection != null) {
            int i = 0;
            while (i < tableCollection.size()) {
                Collection elementMap;
                MetaTable metaColumns = (MetaTable)tableCollection.get(i);
                int finalI = i + 1;
                String finalTable = metaColumns.getKey();
                if (!metaColumns.getKey().contains("_NODB") && (elementMap = metaColumns.items()) != null) {
                    for (MetaColumn metaColumn : elementMap) {
                        if ("MapCount".equalsIgnoreCase(metaColumn.getKey()) || metaColumn.getKey().contains("_NODB") || !isNotMap) continue;
                        this.setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, isNotMap, isAll, "", metaColumns, null, null, null);
                    }
                }
                ++i;
            }
        }
    }

    public void setLayuiArrayUniversal(String formKey, MetaForm metaForm, MetaDataObject metaDataObject, JSONArray nodesJsonArray, boolean isNotMap, boolean isAll, String nodeName, XmlTreeWithPath xmlTree) throws Throwable {
        MetaTableCollection tableCollection = null;
        if (metaForm != null) {
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        } else if (metaDataObject != null) {
            tableCollection = metaDataObject.getTableCollection();
        }
        if (tableCollection != null) {
            int i = 0;
            while (i < tableCollection.size()) {
                Collection elementMap;
                MetaTable metaColumns = (MetaTable)tableCollection.get(i);
                int finalI = i + 1;
                String finalTable = metaColumns.getKey();
                if (!metaColumns.getKey().contains("_NODB") && (elementMap = metaColumns.items()) != null) {
                    for (MetaColumn metaColumn : elementMap) {
                        if ("MapCount".equals(metaColumn.getKey()) || metaColumn.getKey().contains("_NODB") || !isNotMap) continue;
                        this.setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, isNotMap, isAll, nodeName, metaColumns, xmlTree, null, null);
                    }
                }
                ++i;
            }
        }
    }

    public void setArrayUniversalByTableKey(String formKey, MetaForm metaForm, MetaDataObject metaDataObject, JSONArray nodesJsonArray, String tableKey, boolean isNotMap, boolean isAll, String nodeName, XmlTreeWithPath xmlTreeWithPath) throws Throwable {
        MetaTableCollection tableCollection = null;
        if (metaForm != null) {
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        } else if (metaDataObject != null) {
            tableCollection = metaDataObject.getTableCollection();
        }
        if (tableCollection != null) {
            int i = 0;
            while (i < tableCollection.size()) {
                Collection elementMap;
                MetaTable metaColumns = (MetaTable)tableCollection.get(i);
                int finalI = i + 1;
                String finalTable = metaColumns.getKey();
                if (metaColumns.getKey().equals(tableKey) && (elementMap = metaColumns.items()) != null) {
                    for (MetaColumn metaColumn : elementMap) {
                        if (metaColumn.getKey().contains("_NODB")) continue;
                        this.setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, isNotMap, isAll, nodeName, metaColumns, xmlTreeWithPath, null, null);
                    }
                }
                ++i;
            }
        }
    }

    public void setArray(String formKey, JSONArray nodesJsonArray, int finalI, String finalTable, MetaColumn metaColumn, boolean isNotMap, boolean isAll, String nodeName, MetaTable table, XmlTreeWithPath xmlTree, IDLookup idLookup, String fieldKey) throws Throwable {
        Set<String> set;
        JSONObject nodeJsonObj = new JSONObject();
        nodeJsonObj.put("DataSource", (Object)("(\u8868" + finalI + ")"));
        if (isNotMap && StringUtils.isNotEmpty((CharSequence)nodeName)) {
            nodeJsonObj.put("Key", (Object)metaColumn.getKey());
            int groupType = metaColumn.getGroupType();
            String Caption = String.valueOf(metaColumn.getCaption()) + DataMigrationOperJsonUtil.getGroupType(groupType);
            nodeJsonObj.put("Caption", (Object)("SourceTableCollection".equalsIgnoreCase(nodeName) ? metaColumn.getCaption() : Caption));
            nodeJsonObj.put("name", (Object)("(\u8868" + finalI + ")" + metaColumn.getKey() + "  " + metaColumn.getCaption()));
            nodeJsonObj.put("value", (Object)(String.valueOf(finalI) + "_@_" + metaColumn.getKey() + "_@_" + metaColumn.getCaption() + "_@_" + finalTable + "_@_" + formKey));
        } else if (isNotMap) {
            nodeJsonObj.put("Key", (Object)metaColumn.getKey());
            nodeJsonObj.put("Caption", (Object)metaColumn.getCaption());
            nodeJsonObj.put("name", (Object)("(\u8868" + finalI + ")" + metaColumn.getKey() + "  " + metaColumn.getCaption()));
            nodeJsonObj.put("value", (Object)(String.valueOf(finalI) + "_@_" + metaColumn.getKey() + "_@_" + metaColumn.getCaption() + "_@_" + finalTable + "_@_" + formKey));
        } else {
            Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
            List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
            if (fieldKeys.size() > 0) {
                nodeJsonObj.put("Key", (Object)fieldKey);
                nodeJsonObj.put("name", (Object)("(\u8868" + finalI + ")" + fieldKey + "  " + metaColumn.getCaption()));
                nodeJsonObj.put("value", (Object)(String.valueOf(finalI) + "_@_" + fieldKey + "_@_" + metaColumn.getCaption() + "_@_" + finalTable + "_@_" + formKey));
            } else {
                nodeJsonObj.put("Key", (Object)metaColumn.getKey());
                nodeJsonObj.put("name", (Object)("(\u8868" + finalI + ")" + metaColumn.getKey() + "  " + metaColumn.getCaption()));
                nodeJsonObj.put("value", (Object)(String.valueOf(finalI) + "_@_" + metaColumn.getKey() + "_@_" + metaColumn.getCaption() + "_@_" + finalTable + "_@_" + formKey));
            }
            nodeJsonObj.put("Caption", (Object)metaColumn.getCaption());
        }
        nodeJsonObj.put("TableKey", (Object)finalTable);
        if (!isAll && StringUtils.isNotEmpty((CharSequence)nodeName) && xmlTree != null && !isNotMap) {
            TagNode root = xmlTree.xmlTree.getRoot();
            set = publicMethodUtil.getNodes(table, nodeName, formKey, root);
            nodeJsonObj.put("checked", (Object)set.contains(fieldKey));
        } else if (StringUtils.isNotEmpty((CharSequence)nodeName) && xmlTree != null) {
            TagNode root = xmlTree.xmlTree.getRoot();
            set = publicMethodUtil.getNodes(table, nodeName, formKey, root);
            nodeJsonObj.put("checked", (Object)set.contains(metaColumn.getKey()));
        }
        nodesJsonArray.add((Object)nodeJsonObj);
    }

    public static Map<String, String> filterFiledMap(String extend, MetaForm metaForm) throws Throwable {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String extendForm = metaForm != null && StringUtils.isNotEmpty((CharSequence)metaForm.getExtend()) ? metaForm.getExtend() : metaForm.getKey();
        String dataMapPath = LoadFileTree.getDataMapPathByKey(extend);
        if (StringUtils.isNotEmpty((CharSequence)dataMapPath)) {
            TagNode node = Xml4jUtil.parseTree(dataMapPath).getRoot();
            boolean srcFormKey = node.getAttributes().get("SrcFormKey").equalsIgnoreCase(extendForm);
            List<TagNode> tagNodes = srcFormKey ? node.findNodesByTagName("SourceField") : node.findNodesByTagName("TargetField");
            DataMapOperXmlUtil.setFilterFiledMap(hashMap, tagNodes, true);
            List<TagNode> feedbackFieldList = node.findNodesByTagName("FeedbackField");
            DataMapOperXmlUtil.setFilterFiledMap(hashMap, feedbackFieldList, false);
        }
        return hashMap;
    }

    private static void setFilterFiledMap(HashMap<String, String> hashMap, List<TagNode> tagNodes, boolean notFeed) {
        for (TagNode tagNode : tagNodes) {
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            String definition = "";
            definition = notFeed ? (tagNode.getTagName().equals("SourceField") ? tagNode.getAttributes().get("Key") : tagNode.getAttributes().get("Definition")) : tagNode.getAttributes().get("FieldKey");
            hashMap.put(uuid, definition);
        }
    }

    public ResponseResult<JSONArray> getTableKeyField(JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            String formKey = jsonDataMapVo.getFormKey().split("__")[0];
            String tableKey = jsonDataMapVo.getTableKey();
            String nodeName = jsonDataMapVo.getNodeName();
            String filePath = jsonDataMapVo.getFilePath();
            String tmpFile = XmlFileProcessor.instance.getTmpFile(filePath);
            if (tmpFile != null) {
                filePath = tmpFile;
            }
            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
            Element element = DataMapOperJsonUtil.getElement(filePath);
            String name = element.getName();
            if ("Map".equals(name)) {
                if ("SourceTableCollection".equals(nodeName)) {
                    formKey = element.attributeValue("SrcFormKey");
                } else if ("TargetTableCollection".equals(nodeName)) {
                    formKey = element.attributeValue("TgtFormKey");
                }
            } else if ("SourceTableCollection".equals(nodeName)) {
                formKey = element.attributeValue("SrcDataObjectKey");
            } else if ("TargetTableCollection".equals(nodeName)) {
                formKey = element.attributeValue("TgtDataObjectKey");
            }
            JSONArray nodesJsonArray = new JSONArray();
            TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
            MetaForm metaForm = (MetaForm)metaFormOrMetaDataObject.metaForm;
            MetaDataObject metaDataObject = (MetaDataObject)metaFormOrMetaDataObject.metaDataObject;
            if ("Map".equals(name)) {
                boolean isFilter;
                MetaTableCollection tableCollection = null;
                String formKey1 = jsonDataMapVo.getFormKey().split("__")[0];
                String extend = element.attributeValue("Extend");
                String mergeToSource = element.attributeValue("MergeToSource");
                boolean bl = isFilter = StringUtils.isNotEmpty((CharSequence)extend) && StringUtils.isNotEmpty((CharSequence)mergeToSource);
                if ("SourceTableCollection".equals(nodeName)) {
                    formKey1 = element.attributeValue("SrcFormKey");
                } else if ("TargetTableCollection".equals(nodeName)) {
                    formKey1 = element.attributeValue("TgtFormKey");
                } else {
                    String objectKey = jsonDataMapVo.getFormKey().split("__")[0];
                    List elements = element.element("FeedbackCollection").elements("FeedbackObject");
                    for (Element element1 : elements) {
                        if (!objectKey.equalsIgnoreCase(element1.attributeValue("FormKey"))) continue;
                        formKey1 = element1.attributeValue("FormKey");
                        break;
                    }
                }
                MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey1);
                IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
                if (metaForm != null) {
                    tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
                } else if (metaDataObject != null) {
                    tableCollection = metaDataObject.getTableCollection();
                }
                if (tableCollection != null) {
                    int i = 0;
                    while (i < tableCollection.size()) {
                        Collection elementMap;
                        MetaTable metaColumns = (MetaTable)tableCollection.get(i);
                        int finalI = i + 1;
                        String finalTable = metaColumns.getKey();
                        Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
                        if (!MapUtils.isEmpty(columKeysAndFieldKeys) && metaColumns.getKey().equals(tableKey) && (elementMap = metaColumns.items()) != null) {
                            for (MetaColumn metaColumn : elementMap) {
                                List<String> fieldKeys;
                                if (metaColumn.getKey().contains("_NODB") || CollectionUtils.isEmpty(fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey()))) continue;
                                for (String fieldKey : fieldKeys) {
                                    if (isFilter) {
                                        Map<String, String> map = DataMapOperXmlUtil.filterFiledMap(extend, metaForm1);
                                        if (map.containsValue(fieldKey)) continue;
                                        this.setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, false, false, nodeName, metaColumns, xmlTreeWithPath, idLookup, fieldKey);
                                        continue;
                                    }
                                    this.setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, false, false, nodeName, metaColumns, xmlTreeWithPath, idLookup, fieldKey);
                                }
                            }
                        }
                        ++i;
                    }
                }
            } else if ("DataMigration".equals(name)) {
                this.setArrayUniversalByTableKey(formKey, metaForm, metaDataObject, nodesJsonArray, tableKey, true, false, nodeName, xmlTreeWithPath);
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u6570\u636e\u8868\u5b57\u6bb5\u6210\u529f");
            result.setData(nodesJsonArray);
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u6570\u636e\u8868\u5b57\u6bb5\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u6570\u636e\u8868\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    public static Map<String, String> filterTableFiled(String formKey, String tableKey, String extend) throws Throwable {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String linkPath = StringUtils.isNotEmpty((CharSequence)extend) ? LoadFileTree.getDataMapPathByKey(extend) : null;
        TagNode root = Objects.requireNonNull(Xml4jUtil.parseTree(linkPath)).getRoot();
        boolean srcDataObjectKey = root.getAttributes().get("SrcDataObjectKey").equalsIgnoreCase(formKey);
        List<TagNode> tagNodes = srcDataObjectKey ? root.findNodesByTagName("SourceTable") : root.findNodesByTagName("TargetTable");
        for (TagNode tagNode : tagNodes) {
            if (!tagNode.getAttributes().get("DataSource").equalsIgnoreCase(tableKey)) continue;
            List<TagNode> filedNodes = srcDataObjectKey ? tagNode.findNodesByTagName("SourceField") : tagNode.findNodesByTagName("TargetField");
            DataMapOperXmlUtil.setFilterFiledMap(hashMap, filedNodes, true);
            break;
        }
        return hashMap;
    }

    public ResponseResult<JSONArray> getTreeFields(JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        JSONArray nodesJsonArray = new JSONArray();
        try {
            String formKey = jsonDataMapVo.getFormKey().split("__")[0];
            String tableKey = jsonDataMapVo.getTableKey();
            String filePath = jsonDataMapVo.getFilePath();
            String tmpFile = XmlFileProcessor.instance.getTmpFile(filePath);
            if (tmpFile != null) {
                filePath = tmpFile;
            }
            Element element = DataMapOperJsonUtil.getElement(filePath);
            String nodeName = jsonDataMapVo.getNodeName();
            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
            String name = element.getName();
            if ("Map".equals(name)) {
                if ("SourceTableCollection".equals(nodeName)) {
                    formKey = element.attributeValue("SrcFormKey");
                } else if ("TargetTableCollection".equals(nodeName)) {
                    formKey = element.attributeValue("TgtFormKey");
                } else {
                    String objectKey = jsonDataMapVo.getFormKey().split("__")[0];
                    List elements = element.element("FeedbackCollection").elements("FeedbackObject");
                    for (Element element1 : elements) {
                        if (!objectKey.equalsIgnoreCase(element1.attributeValue("FormKey"))) continue;
                        formKey = element1.attributeValue("FormKey");
                        break;
                    }
                }
            } else if ("SourceTableCollection".equals(nodeName)) {
                formKey = element.attributeValue("SrcDataObjectKey");
            } else if ("TargetTableCollection".equals(nodeName)) {
                formKey = element.attributeValue("TgtDataObjectKey");
            }
            TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
            MetaForm metaForm = (MetaForm)metaFormOrMetaDataObject.metaForm;
            MetaDataObject metaDataObject = (MetaDataObject)metaFormOrMetaDataObject.metaDataObject;
            if ("Map".equals(name)) {
                String extend = element.attributeValue("Extend");
                String mergeToSource = element.attributeValue("MergeToSource");
                boolean isFilter = StringUtils.isNotEmpty((CharSequence)extend) && StringUtils.isNotEmpty((CharSequence)mergeToSource);
                MetaTableCollection tableCollection = null;
                String formKey1 = jsonDataMapVo.getFormKey().split("__")[0];
                if ("SourceTableCollection".equals(nodeName)) {
                    formKey1 = element.attributeValue("SrcFormKey");
                } else if ("TargetTableCollection".equals(nodeName)) {
                    formKey1 = element.attributeValue("TgtFormKey");
                } else {
                    String objectKey = jsonDataMapVo.getFormKey().split("__")[0];
                    List elements = element.element("FeedbackCollection").elements("FeedbackObject");
                    for (Element element1 : elements) {
                        if (!objectKey.equalsIgnoreCase(element1.attributeValue("FormKey"))) continue;
                        formKey1 = element1.attributeValue("FormKey");
                        break;
                    }
                }
                MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey1);
                IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
                if (metaForm != null) {
                    tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
                } else if (metaDataObject != null) {
                    tableCollection = metaDataObject.getTableCollection();
                }
                if (tableCollection != null) {
                    int i = 0;
                    while (i < tableCollection.size()) {
                        Collection elementMap;
                        MetaTable metaColumns = (MetaTable)tableCollection.get(i);
                        int finalI = i + 1;
                        String finalTable = metaColumns.getKey();
                        Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
                        if (!MapUtils.isEmpty(columKeysAndFieldKeys) && metaColumns.getKey().equals(tableKey) && (elementMap = metaColumns.items()) != null) {
                            for (MetaColumn metaColumn : elementMap) {
                                List<String> fieldKeys;
                                if (metaColumn.getKey().contains("_NODB") || CollectionUtils.isEmpty(fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey()))) continue;
                                for (String fieldKey : fieldKeys) {
                                    if (isFilter) {
                                        Map<String, String> map = DataMapOperXmlUtil.filterFiledMap(extend, metaForm1);
                                        if (map.containsValue(fieldKey)) continue;
                                        this.setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, false, false, nodeName, metaColumns, xmlTreeWithPath, idLookup, fieldKey);
                                        continue;
                                    }
                                    this.setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, false, false, nodeName, metaColumns, xmlTreeWithPath, idLookup, fieldKey);
                                }
                            }
                        }
                        ++i;
                    }
                }
            } else if ("DataMigration".equals(name)) {
                this.setArrayUniversalByTableKey(formKey, metaForm, metaDataObject, nodesJsonArray, tableKey, true, false, nodeName, xmlTreeWithPath);
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u6570\u636e\u8868\u5b57\u6bb5\u6210\u529f");
            result.setData(nodesJsonArray);
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u6570\u636e\u8868\u5b57\u6bb5\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u6570\u636e\u8868\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    public ResponseResult<JSONArray> getdeleteField(JsonDataMapVo jsonDataMapVo) throws Throwable {
        ResponseResult<JSONArray> result;
        block23: {
            result = new ResponseResult<JSONArray>();
            FileOutputStream fileOutputStream = null;
            XMLWriter writer = null;
            String tempPath = "";
            String filePaths = "";
            try {
                try {
                    String key;
                    filePaths = jsonDataMapVo.getFilePath();
                    tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
                    if (StringUtils.isBlank((CharSequence)tempPath)) {
                        tempPath = filePaths;
                    }
                    if ((key = jsonDataMapVo.getFieldKey()) != null) {
                        key = key.replaceAll("'", "\"");
                    }
                    String formKey = jsonDataMapVo.getFormKey().split("__")[0];
                    String tableKey = jsonDataMapVo.getTableKey();
                    String nodeName = jsonDataMapVo.getNodeName();
                    SAXReader reader = new SAXReader();
                    Document document = reader.read(new File(tempPath));
                    if ("SourceTableCollection".equalsIgnoreCase(nodeName)) {
                        List<Node> sourceFieldList = DataMapOperXmlUtil.getMapSourceFieldNodeListByTableKey(document, tableKey);
                        Element sourceTable = DataMapOperXmlUtil.getMapSourceTableNodeByTableKey(document, tableKey);
                        Element sourceField = DataMapOperXmlUtil.getMapSourceFieldNodeByTableKey_Definitionkey(document, tableKey, key);
                        if (sourceFieldList.size() == 1) {
                            Element sourceTableList = DataMapOperXmlUtil.getMapSourceTableCollectionNode(document);
                            if (Objects.isNull(sourceTableList)) {
                                String xpathExpression = "/DataMigration/SourceTableCollection";
                                sourceTableList = (Element)document.selectSingleNode(xpathExpression);
                            }
                            sourceTableList.remove(sourceTable);
                        } else {
                            sourceTable.remove(sourceField);
                        }
                    } else if ("TargetTableCollection".equalsIgnoreCase(nodeName)) {
                        List<Node> targetFieldList = DataMapOperXmlUtil.getMapTargetFieldNodeListByTableKey(document, tableKey);
                        Element targetTable = DataMapOperXmlUtil.getMapTargetTableNodeByTableKey(document, tableKey);
                        Element targetField = DataMapOperXmlUtil.getMapTargetFieldNodeByTableKey_Definitionkey(document, tableKey, key);
                        if (targetFieldList.size() == 1) {
                            Element targetTableList = DataMapOperXmlUtil.getMapTargetTableCollectionNode(document);
                            if (targetTableList == null) {
                                targetTableList = (Element)document.selectSingleNode("/DataMigration/TargetTableCollection");
                            }
                            targetTableList.remove(targetTable);
                        } else {
                            targetTable.remove(targetField);
                        }
                        List<Node> mapSourceTableNodeList = DataMapOperXmlUtil.getMapSourceTableNodeList(document);
                        for (Node sourceTableNode : mapSourceTableNodeList) {
                            List sourceFieldNodeList = sourceTableNode.selectNodes("SourceField[@TargetFieldKey='" + key + "']");
                            for (Node sourceFieldNode : sourceFieldNodeList) {
                                Element node = (Element)sourceFieldNode;
                                String tableKey1 = node.attributeValue("TargetTableKey");
                                if (StringUtils.isNotEmpty((CharSequence)tableKey1)) {
                                    if (!tableKey.equalsIgnoreCase(tableKey1)) continue;
                                    node.remove(node.attribute("TargetTableKey"));
                                    node.remove(node.attribute("TargetFieldKey"));
                                    continue;
                                }
                                node.remove(node.attribute("TargetFieldKey"));
                            }
                        }
                    } else if ("FeedbackCollection".equalsIgnoreCase(nodeName)) {
                        List<Node> feedbackFieldList = DataMapOperXmlUtil.getMapFeedbackFieldNodeList(document, formKey, tableKey);
                        Element feedbackTable = DataMapOperXmlUtil.getMapFeedbackTableNode(document, formKey, tableKey);
                        Element feedField = DataMapOperXmlUtil.getMapFeedbackFieldNode(document, formKey, tableKey, key);
                        if (feedbackFieldList.size() == 1 && feedField != null) {
                            Element feedbackTableList = DataMapOperXmlUtil.getMapFeedbackObjectNode(document, formKey);
                            feedbackTableList.remove(feedbackTable);
                        } else {
                            feedbackTable.remove(feedField);
                        }
                        this.deleteField(key, tableKey, document);
                    }
                    OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
                    String solutionPath = String.valueOf(FilePathHelper.getWorkspacePath()) + File.separator;
                    String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", String.valueOf(filePaths.substring(solutionPath.length()).replace(File.separator, "__")) + "." + System.currentTimeMillis()).toString();
                    fileOutputStream = new FileOutputStream(newFilePath);
                    writer = new XMLWriter(fileOutputStream, format);
                    writer.write(document);
                    XmlFileProcessor.stackput(filePaths, newFilePath);
                    result.setCode(0);
                    result.setMsg("\u5220\u9664\u5b57\u6bb5\u6210\u529f");
                }
                catch (Exception e) {
                    logger.warning("\u5220\u9664\u5b57\u6bb5\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
                    result.setCode(999);
                    result.setMsg("\u5220\u9664\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
                    DataMapOperXmlUtil.setData(result, filePaths);
                    DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
                    break block23;
                }
            }
            catch (Throwable throwable) {
                DataMapOperXmlUtil.setData(result, filePaths);
                DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
                throw throwable;
            }
            DataMapOperXmlUtil.setData(result, filePaths);
            DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
        }
        return result;
    }

    private void deleteField(String key, String tableKey, Document document) {
        List<Node> mapTargetTableNodeList = DataMapOperXmlUtil.getMapTargetTableNodeList(document);
        for (Node targetTableNode : mapTargetTableNodeList) {
            List targetFieldNodeList = targetTableNode.selectNodes("TargetField");
            for (Node targetFieldNode : targetFieldNodeList) {
                List feedbackNodes = targetFieldNode.selectNodes("Feedback[@FieldKey='" + key + "']");
                for (Node feedbackNode : feedbackNodes) {
                    String tableValue = ((Element)feedbackNode).attributeValue("TableKey");
                    if (!tableKey.equalsIgnoreCase(tableValue)) continue;
                    ((Element)targetFieldNode).remove(feedbackNode);
                }
            }
        }
    }

    public static Element getMapSourceTableCollectionNode(Document document) {
        String xpathExpression = "/Map/SourceTableCollection";
        Element nodes = (Element)document.selectSingleNode(xpathExpression);
        return nodes;
    }

    public static Element getMapTargetTableCollectionNode(Document document) {
        String xpathExpression = "/Map/TargetTableCollection";
        Element nodes = (Element)document.selectSingleNode(xpathExpression);
        return nodes;
    }

    public static Element getMapFeedbackObjectNode(Document document, String formKey) {
        Element node = (Element)document.selectSingleNode("/Map/FeedbackCollection/FeedbackObject[@FormKey='" + formKey + "']");
        return node;
    }

    public static Element getMapFeedbackTableNode(Document document, String formKey, String tableKey) {
        Element node = (Element)DataMapOperXmlUtil.getMapFeedbackObjectNode(document, formKey).selectSingleNode("FeedbackTable[@TableKey='" + tableKey + "']");
        return node;
    }

    public static List<Node> getMapFeedbackFieldNodeList(Document document, String formKey, String tableKey) {
        List feedbackField = DataMapOperXmlUtil.getMapFeedbackTableNode(document, formKey, tableKey).selectNodes("FeedbackField");
        return feedbackField;
    }

    public static Element getMapFeedbackFieldNode(Document document, String formKey, String tableKey, String key) {
        Element node = (Element)DataMapOperXmlUtil.getMapFeedbackTableNode(document, formKey, tableKey).selectSingleNode("FeedbackField[@FieldKey='" + key + "']");
        return node;
    }

    public static List<Node> getMapSourceTableNodeList(Document document) {
        List node = Objects.isNull(DataMapOperXmlUtil.getMapSourceTableCollectionNode(document)) ? DataMigrationOperXmlUtil.getMapSourceTableCollectionNode(document).selectNodes("SourceTable") : DataMapOperXmlUtil.getMapSourceTableCollectionNode(document).selectNodes("SourceTable");
        return node;
    }

    public static List<Node> getMapTargetTableNodeList(Document document) {
        List node = Objects.isNull(DataMapOperXmlUtil.getMapTargetTableCollectionNode(document)) ? DataMigrationOperXmlUtil.getMapTargetTableCollectionNode(document).selectNodes("SourceTable") : DataMapOperXmlUtil.getMapTargetTableCollectionNode(document).selectNodes("SourceTable");
        return node;
    }

    public static Element getMapSourceTableNodeByTableKey(Document document, String tableKey) {
        Element node = null;
        node = Objects.isNull(DataMapOperXmlUtil.getMapSourceTableCollectionNode(document)) ? (Element)DataMigrationOperXmlUtil.getMapSourceTableCollectionNode(document).selectSingleNode("SourceTable[@TableKey='" + tableKey + "']") : (Element)DataMapOperXmlUtil.getMapSourceTableCollectionNode(document).selectSingleNode("SourceTable[@Key='" + tableKey + "']");
        return node;
    }

    public static Element getMapTargetTableNodeByTableKey(Document document, String tableKey) {
        Element node = null;
        node = Objects.isNull(DataMapOperXmlUtil.getMapTargetTableCollectionNode(document)) ? (Element)DataMigrationOperXmlUtil.getMapTargetTableCollectionNode(document).selectSingleNode("TargetTable[@TableKey='" + tableKey + "']") : (Element)DataMapOperXmlUtil.getMapTargetTableCollectionNode(document).selectSingleNode("TargetTable[@Key='" + tableKey + "']");
        return node;
    }

    public static List<Node> getMapSourceFieldNodeListByTableKey(Document document, String tableKey) {
        List nodes1 = DataMapOperXmlUtil.getMapSourceTableNodeByTableKey(document, tableKey).selectNodes("SourceField");
        return nodes1;
    }

    public static List<Node> getMapTargetFieldNodeListByTableKey(Document document, String tableKey) {
        List nodes1 = DataMapOperXmlUtil.getMapTargetTableNodeByTableKey(document, tableKey).selectNodes("TargetField");
        return nodes1;
    }

    public static Element getMapSourceFieldNodeByTableKey_Definitionkey(Document document, String tableKey, String key) {
        if (key != null) {
            key = key.replaceAll("'", "\"");
        }
        Element nodes1 = (Element)DataMapOperXmlUtil.getMapSourceTableNodeByTableKey(document, tableKey).selectSingleNode("SourceField[@Definition='" + key + "']");
        return nodes1;
    }

    public static Element getMapSourceFieldNodeByTableKey_TargetFieldKey(Document document, String tableKey, String key) {
        Element nodes1 = (Element)DataMapOperXmlUtil.getMapSourceTableNodeByTableKey(document, tableKey).selectSingleNode("SourceField[@TargetFieldKey='" + key + "']");
        return nodes1;
    }

    public static Element getMapTargetFieldNodeByTableKey_Definitionkey(Document document, String tableKey, String key) {
        Element nodes1;
        if (key != null) {
            key = key.replaceAll("'", "\"");
        }
        if (Objects.isNull(nodes1 = (Element)DataMapOperXmlUtil.getMapTargetTableNodeByTableKey(document, tableKey).selectSingleNode("TargetField[@Definition='" + key + "']"))) {
            nodes1 = (Element)DataMapOperXmlUtil.getMapTargetTableNodeByTableKey(document, tableKey).selectSingleNode("TargetField[@FieldKey='" + key + "']");
        }
        return nodes1;
    }

    public ResponseResult<JSONArray> fieldInfo(JsonDataMapVo jsonDataMapVo) throws Throwable {
        String tempPath = XmlFileProcessor.instance.getTmpFile(jsonDataMapVo.getFilePath());
        if (StringUtils.isBlank((CharSequence)tempPath)) {
            tempPath = jsonDataMapVo.getFilePath();
        }
        Element root = DataMapOperJsonUtil.getElement(tempPath);
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        MetaTable metaTable = null;
        JSONArray array = null;
        IDLookup idLookup = null;
        try {
            Element element;
            array = new JSONArray();
            JSONObject nodeJson = new JSONObject();
            String formKey = jsonDataMapVo.getFormKey().split("__")[0];
            String fieldKey = jsonDataMapVo.getFieldKey();
            if (fieldKey != null) {
                fieldKey = fieldKey.replaceAll("'", "\"");
            }
            String tableKey = jsonDataMapVo.getTableKey();
            String nodeName = jsonDataMapVo.getNodeName();
            String operationType = jsonDataMapVo.getOperationType();
            TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
            MetaForm metaForm = (MetaForm)metaFormOrMetaDataObject.metaForm;
            MetaDataObject metaDataObject = (MetaDataObject)metaFormOrMetaDataObject.metaDataObject;
            if (metaForm != null) {
                metaTable = metaForm.getMetaTable(tableKey);
                idLookup = IDLookup.getIDLookup(metaForm);
            } else if (metaDataObject != null) {
                metaTable = metaDataObject.getMetaTable(tableKey);
            }
            if (metaTable != null) {
                String tableNode = "";
                String filedNode = "";
                if ("SourceTableCollection".equalsIgnoreCase(nodeName)) {
                    tableNode = "SourceTable";
                    filedNode = "SourceField";
                } else if ("TargetTableCollection".equalsIgnoreCase(nodeName)) {
                    tableNode = "TargetTable";
                    filedNode = "TargetField";
                } else if ("FeedbackCollection".equalsIgnoreCase(nodeName)) {
                    tableNode = "FeedbackTable";
                    filedNode = "FeedbackField";
                }
                List elements = root.element(nodeName).elements(tableNode);
                if ("FeedbackCollection".equalsIgnoreCase(nodeName)) {
                    List feedbackObject = root.element(nodeName).elements("FeedbackObject");
                    for (Element ele : feedbackObject) {
                        if (!ele.attributeValue("FormKey").equalsIgnoreCase(formKey)) continue;
                        elements = ele.elements("tableNode");
                    }
                }
                String TargetTableKey = null;
                String refFieldKey = null;
                String IsPrimary = "false";
                String Condition = "";
                String RowTrigger = " ";
                String keyId = "";
                if ("field".equalsIgnoreCase(operationType)) {
                    MetaColumn metaColumn = DataMapOperXmlUtil.getMetaColumn(fieldKey, tableKey, metaTable, idLookup);
                    if (Objects.isNull(metaColumn)) {
                        metaColumn = (MetaColumn)metaTable.get(fieldKey);
                    }
                    block4: for (Element ele : elements) {
                        Boolean key = DataMapOperXmlUtil.isMigration(nodeName, nodeJson, tableKey, ele);
                        if (!key.booleanValue()) continue;
                        IsPrimary = String.valueOf(!"SourceField".equals(filedNode));
                        List sourceField = ele.elements("SourceField");
                        for (Element element2 : sourceField) {
                            if (!element2.attributeValue("Definition").equalsIgnoreCase(fieldKey)) continue;
                            refFieldKey = element2.attributeValue("RefFieldKey");
                            keyId = element2.attributeValue("Key");
                            if (ele.attributeValue("IsPrimary") == null) continue block4;
                            IsPrimary = ele.attributeValue("IsPrimary");
                            continue block4;
                        }
                    }
                    if (refFieldKey != null) {
                        nodeJson.put("refFieldKey", refFieldKey);
                    } else {
                        nodeJson.put("refFieldKey", (Object)"");
                    }
                    nodeJson.put("IsPrimary", (Object)IsPrimary);
                    if (!"DataMigration".equalsIgnoreCase(root.getName())) {
                        nodeJson.put("Key", (Object)keyId);
                    }
                    if (metaColumn != null) {
                        nodeJson.put("Caption", (Object)metaColumn.getCaption());
                        nodeJson.put("DataType", (Object)DataType.toString((Integer)metaColumn.getDataType()));
                    }
                } else if ("table".equalsIgnoreCase(operationType)) {
                    for (Element ele : elements) {
                        Boolean key = DataMapOperXmlUtil.isMigration(nodeName, nodeJson, tableKey, ele);
                        if (!key.booleanValue()) continue;
                        TargetTableKey = ele.attributeValue("TargetTableKey");
                        if (ele.attributeValue("IsPrimary") != null && "true".equalsIgnoreCase(IsPrimary = ele.attributeValue("IsPrimary"))) {
                            Condition = ele.attributeValue("Condition");
                        }
                        RowTrigger = ele.attributeValue("RowTrigger");
                    }
                    nodeJson.put("tableKey", (Object)metaTable.getKey());
                    nodeJson.put("tableCaption", (Object)metaTable.getCaption());
                    nodeJson.put("TargetTableKey", TargetTableKey);
                    nodeJson.put("IsPrimary", (Object)IsPrimary);
                    nodeJson.put("Condition", (Object)Condition);
                    nodeJson.put("RowTrigger", (Object)RowTrigger);
                } else if ("ConstAndFormula".equalsIgnoreCase(operationType)) {
                    for (Element ele : elements) {
                        Boolean key = DataMapOperXmlUtil.isMigration(nodeName, nodeJson, tableKey, ele);
                        if (!key.booleanValue()) continue;
                        List Field2 = ele.elements(filedNode);
                        if ("".equalsIgnoreCase(fieldKey)) {
                            String tableKey1 = DataMapOperXmlUtil.getTableKey(ele);
                            if (!tableKey1.equalsIgnoreCase(tableKey)) continue;
                            if (ele.attributeValue("IsPrimary") != null) {
                                IsPrimary = ele.attributeValue("IsPrimary");
                            }
                            nodeJson.put("IsPrimary", (Object)IsPrimary);
                            continue;
                        }
                        String name = root.getName();
                        IsPrimary = this.loadformula(nodeJson, fieldKey, IsPrimary, ele, Field2, name);
                    }
                }
                nodeJson.put("isMigration", (Object)root.getQName().getName());
            } else if ("collection".equalsIgnoreCase(operationType) && (element = root.element("FeedbackCollection")) != null) {
                nodeJson.put("StatusFieldKey", (Object)element.attributeValue("StatusFieldKey"));
                nodeJson.put("StatusValue", (Object)element.attributeValue("StatusValue"));
                nodeJson.put("Condition", (Object)element.attributeValue("Condition"));
            }
            array.add((Object)nodeJson);
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u6210\u529f");
            result.setData(array);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return result;
    }

    public String loadformula(JSONObject nodeJson, String fieldKey, String isPrimary, Element ele, List<Element> field, String name) {
        for (Element elefield : field) {
            if (!Objects.isNull(elefield.attributeValue("Definition")) && !elefield.attributeValue("Definition").equalsIgnoreCase(fieldKey)) continue;
            String type = elefield.attributeValue("Type");
            if (ele.attributeValue("IsPrimary") != null) {
                isPrimary = ele.attributeValue("IsPrimary");
            }
            nodeJson.put("IsPrimary", (Object)isPrimary);
            nodeJson.put("refFieldKey", (Object)elefield.attributeValue("RefFieldKey"));
            nodeJson.put("type", (Object)type);
            if ("DataMigration".equalsIgnoreCase(name)) break;
            nodeJson.put("Key", (Object)elefield.attributeValue("Key"));
            break;
        }
        return isPrimary;
    }

    public static Boolean isMigration(String nodeName, JSONObject nodeJson, String tableKey, Element ele) {
        Boolean key = false;
        if (ele.attributeValue("Key") != null) {
            key = ele.attributeValue("Key").equalsIgnoreCase(tableKey);
        } else if (ele.attributeValue("TableKey") != null) {
            key = ele.attributeValue("TableKey").equalsIgnoreCase(tableKey);
            if ("TargetTableCollection".equalsIgnoreCase(nodeName)) {
                nodeJson.put("isMigration", (Object)"isMigration");
            }
        }
        return key;
    }

    public static MetaColumn getMetaColumn(String fieldKey, String tableKey, MetaTable table, IDLookup idLookup) {
        MetaColumn metaColumn = null;
        if (Objects.isNull(metaColumn) && idLookup != null && table != null && Objects.isNull(metaColumn = (MetaColumn)table.get(fieldKey))) {
            Map<String, String> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldKeys(tableKey);
            for (String key : columKeysAndFieldKeys.keySet()) {
                if (key.indexOf("_NODB") != -1 || !columKeysAndFieldKeys.get(key).equalsIgnoreCase(fieldKey)) continue;
                metaColumn = (MetaColumn)table.get(key);
            }
        }
        return metaColumn;
    }

    public ResponseResult<JSONArray> getTargetTableList(JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        JSONArray array = null;
        try {
            array = new JSONArray();
            String filePaths = jsonDataMapVo.getFilePath();
            String tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
            if (StringUtils.isBlank((CharSequence)tempPath)) {
                tempPath = filePaths;
            }
            SAXReader reader = new SAXReader();
            Document document = reader.read(new File(tempPath));
            Element root = document.getRootElement();
            List elements = root.element("TargetTableCollection").elements("TargetTable");
            for (Element ele : elements) {
                JSONObject nodeJson = new JSONObject();
                nodeJson.put("name", (Object)ele.attributeValue("Key"));
                nodeJson.put("value", (Object)ele.attributeValue("Key"));
                array.add((Object)nodeJson);
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u76ee\u6807\u8868\u6210\u529f");
            result.setData(array);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u76ee\u6807\u8868\u5931\u8d25\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u76ee\u6807\u8868\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return result;
    }

    public ResponseResult<JSONArray> getSourceFieldList(JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        JSONArray array = null;
        try {
            array = new JSONArray();
            String filePaths = jsonDataMapVo.getFilePath();
            String tableKey = jsonDataMapVo.getTableKey();
            String tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
            if (StringUtils.isBlank((CharSequence)tempPath)) {
                tempPath = filePaths;
            }
            SAXReader reader = new SAXReader();
            Document document = reader.read(new File(tempPath));
            Element root = document.getRootElement();
            String extend = root.attributeValue("Extend");
            JSONObject defaults = new JSONObject();
            defaults.put("name", (Object)"\u9ed8\u8ba4");
            defaults.put("value", (Object)"default");
            array.add((Object)defaults);
            if (StringUtils.isNotEmpty((CharSequence)extend)) {
                String dataMapPathByKey = LoadFileTree.getDataMapPathByKey(extend);
                root = reader.read(new File(dataMapPathByKey)).getRootElement();
                List elements = root.selectNodes("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']/SourceField");
                for (Node ele1 : elements) {
                    Element ele = (Element)ele1;
                    JSONObject nodeJson = new JSONObject();
                    nodeJson.put("name", (Object)(String.valueOf(ele.attributeValue("Definition")) + "->" + ele.attributeValue("TargetFieldKey") + "  _" + ele.attributeValue("Key")));
                    nodeJson.put("value", (Object)ele.attributeValue("Key"));
                    array.add((Object)nodeJson);
                }
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u76ee\u6807\u8868\u6210\u529f");
            result.setData(array);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u76ee\u6807\u8868\u5931\u8d25\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u76ee\u6807\u8868\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return result;
    }

    public ResponseResult<JSONArray> getRefFieldKey(JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        JSONArray array = null;
        try {
            array = new JSONArray();
            String filePaths = jsonDataMapVo.getFilePath();
            String tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
            if (StringUtils.isBlank((CharSequence)tempPath)) {
                tempPath = filePaths;
            }
            SAXReader reader = new SAXReader();
            Document document = reader.read(new File(tempPath));
            Element root = document.getRootElement();
            String formKey = root.attributeValue("SrcDataObjectKey");
            TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
            MetaForm metaForm = (MetaForm)metaFormOrMetaDataObject.metaForm;
            MetaDataObject metaDataObject = (MetaDataObject)metaFormOrMetaDataObject.metaDataObject;
            List elements = root.element("SourceTableCollection").elements("SourceTable");
            for (Element ele : elements) {
                if (!"true".equalsIgnoreCase(ele.attributeValue("IsPrimary"))) continue;
                String name = root.getQName().getName();
                String tableKey = ele.attributeValue("Map".equalsIgnoreCase(name) ? "Key" : "TableKey");
                MetaTable table = Optional.ofNullable(metaForm).map(form -> form.getDataSource().getDataObject().getTable(tableKey)).orElse(Optional.ofNullable(metaDataObject).map(dataObject -> dataObject.getTable(tableKey)).orElse(null));
                for (MetaColumn col : Objects.requireNonNull(table)) {
                    if ("MapCount".equalsIgnoreCase(col.getKey())) continue;
                    JSONObject nodeJson = new JSONObject();
                    nodeJson.put("name", (Object)("\u4e3b\u8868   " + col.getKey() + "  " + col.getCaption()));
                    nodeJson.put("value", (Object)col.getKey());
                    array.add((Object)nodeJson);
                }
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u4e3b\u8868\u5b57\u6bb5\u6210\u529f");
            result.setData(array);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u4e3b\u8868\u5b57\u6bb5\u6210\u529f\u5931\u8d25\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u4e3b\u8868\u5b57\u6bb5\u6210\u529f\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return result;
    }

    public ResponseResult<JSONArray> setTargetField(JsonDataMapVo jsonDataMapVo) throws Throwable {
        ResponseResult<JSONArray> result;
        block19: {
            result = new ResponseResult<JSONArray>();
            FileOutputStream fileOutputStream = null;
            XMLWriter writer = null;
            String tempPath = "";
            String filePaths = "";
            try {
                filePaths = jsonDataMapVo.getFilePath();
                tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
                if (StringUtils.isBlank((CharSequence)tempPath)) {
                    tempPath = filePaths;
                }
                SAXReader reader = new SAXReader();
                Document document = reader.read(new File(tempPath));
                Element root = document.getRootElement();
                Map<String, String> map = DataMapOperXmlUtil.carveUp(jsonDataMapVo);
                String targetFormKey = map.get("targetFormKey").split("__")[0];
                String sourceField = map.get("sourceField");
                String targetField = map.get("targetField");
                String sourceTableKey = map.get("sourceTableKey");
                String targetTablekey = map.get("targetTablekey");
                if (sourceField != null) {
                    sourceField = sourceField.replaceAll("'", "\"");
                }
                if (targetField != null) {
                    targetField = targetField.replaceAll("'", "\"");
                }
                String nodeName = jsonDataMapVo.getNodeName();
                String name = root.getName();
                if ("Map".equalsIgnoreCase(name)) {
                    if ("SourceTableCollection".equalsIgnoreCase(nodeName)) {
                        this.sourceAddTarget(root, sourceField, targetField, sourceTableKey, targetTablekey);
                    } else if ("TargetTableCollection".equalsIgnoreCase(nodeName)) {
                        List feedbackElements = root.element("FeedbackCollection").elements("FeedbackObject");
                        for (Element element1 : feedbackElements) {
                            if (!targetFormKey.equalsIgnoreCase(element1.attributeValue("FormKey"))) continue;
                            targetFormKey = element1.attributeValue("FormKey");
                            break;
                        }
                        this.addtargetField(root, targetFormKey, sourceField, targetField, sourceTableKey, targetTablekey, nodeName);
                    }
                } else if ("SourceTableCollection".equalsIgnoreCase(nodeName)) {
                    this.sourceAddTarget(root, sourceField, targetField, sourceTableKey, targetTablekey);
                } else if ("TargetTableCollection".equalsIgnoreCase(nodeName)) {
                    this.addtargetField(root, targetFormKey, sourceField, targetField, sourceTableKey, targetTablekey, nodeName);
                }
                OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
                String solutionPath = String.valueOf(FilePathHelper.getWorkspacePath()) + File.separator;
                String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", String.valueOf(filePaths.substring(solutionPath.length()).replace(File.separator, "__")) + "." + System.currentTimeMillis()).toString();
                fileOutputStream = new FileOutputStream(newFilePath);
                writer = new XMLWriter(fileOutputStream, format);
                writer.write(document);
                XmlFileProcessor.stackput(filePaths, newFilePath);
                result.setCode(0);
                result.setMsg("success");
            }
            catch (Exception e) {
                logger.warning("failure\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
                result.setCode(999);
                result.setMsg("failure\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
                DataMapOperXmlUtil.setData(result, filePaths);
                DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
                break block19;
            }
            catch (Throwable throwable) {
                try {
                    logger.warning(throwable.getMessage());
                    break block19;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    DataMapOperXmlUtil.setData(result, filePaths);
                    DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
                }
            }
            DataMapOperXmlUtil.setData(result, filePaths);
            DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
        }
        return result;
    }

    public void addtargetField(Element root, String targetFormKey, String sourceField, String targetField, String sourceTableKey, String targetTablekey, String nodeName) throws Throwable {
        List targetTable = root.element(nodeName).elements("TargetTable");
        for (Element ele : targetTable) {
            if (!ele.attributeValue("Key").equalsIgnoreCase(sourceTableKey)) continue;
            List targetField1 = ele.elements("TargetField");
            for (Element targetfield : targetField1) {
                if (!targetfield.attributeValue("Definition").equalsIgnoreCase(sourceField)) continue;
                List feedbacks = targetfield.elements("Feedback");
                boolean isExist = false;
                for (Element feedback : feedbacks) {
                    isExist = feedback.attributeValue("FieldKey").equalsIgnoreCase(targetField);
                }
                if (isExist) continue;
                MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(targetFormKey);
                String key = metaForm.getDataSource().getDataObject().getKey();
                targetfield.addElement("Feedback").addAttribute("DataObjectKey", key).addAttribute("FeedFormKey", targetFormKey).addAttribute("FieldKey", targetField).addAttribute("TableKey", targetTablekey);
            }
        }
    }

    public void sourceAddTarget(Element root, String sourceField, String targetField, String sourceTableKey, String targetTablekey) {
        List elements = root.element("SourceTableCollection").elements("SourceTable");
        boolean mergeToSource = StringUtils.isNotEmpty((CharSequence)root.attributeValue("MergeToSource"));
        boolean extend = StringUtils.isNotEmpty((CharSequence)root.attributeValue("Extend"));
        String type = null;
        block0: for (Element ele : elements) {
            String tableKey = DataMapOperXmlUtil.getTableKey(ele);
            if (!tableKey.equalsIgnoreCase(sourceTableKey)) continue;
            List sourceField1 = ele.elements("SourceField");
            for (Element elefiled : sourceField1) {
                String attributeValue = elefiled.attributeValue("Definition").replaceAll("'", "\"");
                boolean definition = attributeValue.equalsIgnoreCase(sourceField);
                boolean targetFieldKey = Objects.isNull(elefiled.attributeValue("TargetFieldKey"));
                boolean isEqual = false;
                if (elefiled.attributeValue("TargetFieldKey") != null) {
                    isEqual = elefiled.attributeValue("TargetFieldKey").equalsIgnoreCase(targetField) ? !targetTablekey.equalsIgnoreCase(elefiled.attributeValue("TargetTableKey")) : true;
                }
                if (!definition) continue;
                if (targetFieldKey) {
                    elefiled.addAttribute("Definition", sourceField).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey);
                } else {
                    type = elefiled.attributeValue("Type");
                }
                String maxKey = ele.attributeValue("MaxKey");
                if (!isEqual) continue block0;
                if (StringUtils.isNotEmpty((CharSequence)type)) {
                    if (mergeToSource) {
                        if (StringUtils.isNotEmpty((CharSequence)maxKey)) {
                            ele.addElement("SourceField").addAttribute("Definition", sourceField).addAttribute("Type", type).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey).addAttribute("Key", "merge_" + (Integer.valueOf(maxKey) + 1));
                            ele.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey) + 1));
                            continue block0;
                        }
                        ele.addElement("SourceField").addAttribute("Definition", sourceField).addAttribute("Type", type).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey).addAttribute("Key", "merge_" + ele.elements().size());
                        ele.addAttribute("MaxKey", String.valueOf(ele.elements().size()));
                        continue block0;
                    }
                    if (!extend) {
                        if (StringUtils.isNotEmpty((CharSequence)maxKey)) {
                            ele.addElement("SourceField").addAttribute("Definition", sourceField).addAttribute("Type", type).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey).addAttribute("Key", String.valueOf(Integer.valueOf(maxKey) + 1));
                            ele.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey) + 1));
                            continue block0;
                        }
                        ele.addElement("SourceField").addAttribute("Definition", sourceField).addAttribute("Type", type).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey).addAttribute("Key", String.valueOf(ele.elements().size()));
                        ele.addAttribute("MaxKey", String.valueOf(ele.elements().size()));
                        continue block0;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)maxKey)) {
                        ele.addElement("SourceField").addAttribute("Definition", sourceField).addAttribute("Type", type).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey).addAttribute("Key", "field_" + (Integer.valueOf(maxKey) + 1));
                        ele.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey) + 1));
                        continue block0;
                    }
                    ele.addElement("SourceField").addAttribute("Definition", sourceField).addAttribute("Type", type).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey).addAttribute("Key", "field_" + ele.elements().size());
                    ele.addAttribute("MaxKey", String.valueOf(ele.elements().size()));
                    continue block0;
                }
                if (mergeToSource) {
                    if (StringUtils.isNotEmpty((CharSequence)maxKey)) {
                        ele.addElement("SourceField").addAttribute("Definition", sourceField).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey).addAttribute("Key", "merge_" + (Integer.valueOf(maxKey) + 1));
                        ele.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey) + 1));
                        continue block0;
                    }
                    ele.addElement("SourceField").addAttribute("Definition", sourceField).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey).addAttribute("Key", "merge_" + ele.elements().size());
                    ele.addAttribute("MaxKey", String.valueOf(ele.elements().size()));
                    continue block0;
                }
                if (!extend) {
                    if (StringUtils.isNotEmpty((CharSequence)maxKey)) {
                        ele.addElement("SourceField").addAttribute("Definition", sourceField).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey).addAttribute("Key", String.valueOf(Integer.valueOf(maxKey) + 1));
                        ele.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey) + 1));
                        continue block0;
                    }
                    ele.addElement("SourceField").addAttribute("Definition", sourceField).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey).addAttribute("Key", String.valueOf(ele.elements().size()));
                    ele.addAttribute("MaxKey", String.valueOf(ele.elements().size()));
                    continue block0;
                }
                if (StringUtils.isNotEmpty((CharSequence)maxKey)) {
                    ele.addElement("SourceField").addAttribute("Definition", sourceField).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey).addAttribute("Key", "field_" + (Integer.valueOf(maxKey) + 1));
                    ele.addAttribute("MaxKey", String.valueOf(Integer.valueOf(maxKey) + 1));
                    continue block0;
                }
                ele.addElement("SourceField").addAttribute("Definition", sourceField).addAttribute("TargetFieldKey", targetField).addAttribute("TargetTableKey", targetTablekey).addAttribute("Key", "field_" + ele.elements().size());
                ele.addAttribute("MaxKey", String.valueOf(ele.elements().size()));
                continue block0;
            }
        }
    }

    public ResponseResult<Boolean> isConnected(JsonDataMapVo jsonDataMapVo) throws IOException {
        ResponseResult<Boolean> result = new ResponseResult<Boolean>();
        try {
            String targetFieldKey;
            String sourceFieldKey;
            String filePaths = jsonDataMapVo.getFilePath();
            String temFilePath = XmlFileProcessor.instance.getTmpFile(filePaths);
            if (temFilePath != null) {
                filePaths = temFilePath;
            }
            if ((sourceFieldKey = jsonDataMapVo.getSourceFieldKey()) != null) {
                sourceFieldKey = sourceFieldKey.replaceAll("'", "\"");
            }
            if ((targetFieldKey = jsonDataMapVo.getTargetFieldKey()) != null) {
                targetFieldKey = targetFieldKey.replaceAll("'", "\"");
            }
            String key = jsonDataMapVo.getFormKey().split("&&")[0];
            String targetKey = jsonDataMapVo.getFormKey().split("&&")[1];
            if (targetKey.indexOf("__") != -1) {
                targetKey = targetKey.split("__")[0];
            }
            if (key.indexOf("__") != -1) {
                key = key.split("__")[0];
            }
            XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(filePaths);
            boolean isExist = false;
            if ("SourceTableCollection".equalsIgnoreCase(jsonDataMapVo.getNodeName())) {
                isExist = this.handleSTL(sourceFieldKey, targetFieldKey, xmlTree, isExist);
                isExist = publicMethodUtil.isExist(sourceFieldKey, isExist, key, targetKey, targetFieldKey, result);
            } else if ("TargetTableCollection".equalsIgnoreCase(jsonDataMapVo.getNodeName())) {
                List<TagNode> targetField = xmlTree.xmlTree.getRoot().findNodesByTagName("TargetField");
                block3: for (TagNode element : targetField) {
                    if (!element.getAttributes().get("Definition").equalsIgnoreCase(sourceFieldKey)) continue;
                    List<TagNode> feedback = element.findNodesByTagName("Feedback");
                    for (TagNode element1 : feedback) {
                        if (element1.getAttributes().get("FieldKey").equalsIgnoreCase(targetFieldKey)) continue block3;
                    }
                }
                isExist = publicMethodUtil.isExist(sourceFieldKey, isExist, key, targetKey, targetFieldKey, result);
            }
            result.setCode(0);
            result.setData(isExist);
        }
        catch (Exception e) {
            logger.warning("\u5224\u65ad\u5931\u8d25\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u5224\u65ad\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return result;
    }

    private boolean handleSTL(String sourceFieldKey, String targetFieldKey, XmlTreeWithPath xmlTree, boolean isExist) {
        List<TagNode> sourceField = xmlTree.xmlTree.getRoot().findNodesByTagName("SourceField");
        for (TagNode element1 : sourceField) {
            if (!element1.getAttributes().get("Definition").equalsIgnoreCase(sourceFieldKey) || element1.getAttributes().get("TargetFieldKey") == null) continue;
            isExist = element1.getAttributes().get("TargetFieldKey").equalsIgnoreCase(targetFieldKey);
            break;
        }
        return isExist;
    }

    public ResponseResult<JSONArray> ligatureinfo(JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        JSONArray array = new JSONArray();
        JSONObject nodeJson = new JSONObject();
        try {
            boolean extend;
            block71: {
                MetaColumn targetmetaColumn;
                MetaColumn metaColumn;
                String operationType;
                String sourceTableKey;
                String targetField;
                String sourceField;
                Element root;
                block64: {
                    String targetTablekey;
                    block66: {
                        List sourceField1;
                        String tableKey;
                        List elements;
                        String sourceFormKey;
                        block65: {
                            String tempPath = XmlFileProcessor.instance.getTmpFile(jsonDataMapVo.getFilePath());
                            if (StringUtils.isBlank((CharSequence)tempPath)) {
                                tempPath = jsonDataMapVo.getFilePath();
                            }
                            root = DataMapOperJsonUtil.getElement(tempPath);
                            extend = StringUtils.isNotEmpty((CharSequence)root.attributeValue("Extend"));
                            String name = root.getQName().getName();
                            Map<String, String> map = DataMapOperXmlUtil.carveUp(jsonDataMapVo);
                            sourceFormKey = map.get("sourceFormKey").split("__")[0];
                            String targetFormKey = map.get("targetFormKey").split("__")[0];
                            sourceField = map.get("sourceField");
                            targetField = map.get("targetField");
                            sourceTableKey = map.get("sourceTableKey");
                            targetTablekey = map.get("targetTablekey");
                            operationType = jsonDataMapVo.getOperationType();
                            metaColumn = null;
                            targetmetaColumn = null;
                            if ("Map".equalsIgnoreCase(name)) {
                                MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(sourceFormKey);
                                MetaTable table = metaForm.getDataSource().getDataObject().getTable(sourceTableKey);
                                IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                                metaColumn = DataMapOperXmlUtil.getMetaColumn(sourceField, sourceTableKey, table, idLookup);
                                MetaForm targetmetaForm = MetaFactory.getGlobalInstance().getMetaForm(targetFormKey);
                                MetaTable targettable = targetmetaForm.getDataSource().getDataObject().getTable(targetTablekey);
                                IDLookup targetidLookup = IDLookup.getIDLookup(targetmetaForm);
                                targetmetaColumn = DataMapOperXmlUtil.getMetaColumn(targetField, targetTablekey, targettable, targetidLookup);
                            } else if ("DataMigration".equalsIgnoreCase(name)) {
                                sourceFormKey = root.attributeValue("SrcDataObjectKey");
                                targetFormKey = root.attributeValue("TgtDataObjectKey");
                                MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(targetFormKey);
                                MetaTable targettable = dataObject.getTable(targetTablekey);
                                targetmetaColumn = (MetaColumn)targettable.get(targetField);
                                int groupType = -1;
                                if (targetmetaColumn != null) {
                                    groupType = targetmetaColumn.getGroupType();
                                }
                                String fieldCaption = DataMigrationOperJsonUtil.getGroupType(groupType);
                                nodeJson.put("Migration", (Object)"Migration");
                                nodeJson.put("GroupType", (Object)fieldCaption);
                            }
                            if (metaColumn != null) {
                                nodeJson.put("sourcekey", (Object)metaColumn.getKey());
                                nodeJson.put("sourceCaption", (Object)metaColumn.getCaption());
                            }
                            if (sourceField != null) {
                                sourceField = sourceField.replaceAll("'", "\"");
                            }
                            if (targetField != null) {
                                targetField = targetField.replaceAll("'", "\"");
                            }
                            if (!"false".equalsIgnoreCase(operationType)) break block64;
                            if (!"Map".equalsIgnoreCase(name)) break block65;
                            if (!root.attributeValue("SrcFormKey").equalsIgnoreCase(sourceFormKey)) break block66;
                            elements = root.element("SourceTableCollection").elements("SourceTable");
                            for (Element ele : elements) {
                                tableKey = DataMapOperXmlUtil.getTableKey(ele);
                                if (!tableKey.equalsIgnoreCase(sourceTableKey)) continue;
                                sourceField1 = ele.elements("SourceField");
                                for (Element eleFiled : sourceField1) {
                                    block67: {
                                        String fieldValue = DataMapOperXmlUtil.getFieldValue(eleFiled);
                                        String targetValue = eleFiled.attributeValue("TargetFieldKey");
                                        if (StringUtils.isNotEmpty((CharSequence)targetValue)) {
                                            targetValue = targetValue.replaceAll("'", "\"");
                                        }
                                        if (!(fieldValue = fieldValue.replaceAll("'", "\"")).equalsIgnoreCase(sourceField) || targetField == null || !targetField.equalsIgnoreCase(targetValue)) continue;
                                        if (nodeJson.get((Object)"Migration") == null) break block67;
                                        List<String> keys = Arrays.asList("GroupingPolicy", "PeriodValue", "OpSign", "IsNegtive");
                                        for (String key : keys) {
                                            String value = eleFiled.attributeValue(key);
                                            switch (key) {
                                                case "OpSign": 
                                                case "IsNegtive": 
                                                case "PeriodValue": 
                                                case "GroupingPolicy": {
                                                    nodeJson.put(key, (Object)value);
                                                    break;
                                                }
                                            }
                                        }
                                        continue;
                                    }
                                    String editable = eleFiled.attributeValue("Editable");
                                    String EdgeType = eleFiled.attributeValue("EdgeType");
                                    String ConditionField = eleFiled.attributeValue("Condition");
                                    nodeJson.put("targetkey", (Object)eleFiled.attributeValue("TargetFieldKey"));
                                    nodeJson.put("targetTableKey", (Object)eleFiled.attributeValue("TargetTableKey"));
                                    if (editable != null) {
                                        nodeJson.put("Editable", (Object)editable);
                                    } else {
                                        nodeJson.put("Editable", (Object)"true");
                                    }
                                    if (EdgeType != null) {
                                        nodeJson.put("EdgeType", (Object)EdgeType);
                                    } else {
                                        nodeJson.put("EdgeType", (Object)"common");
                                    }
                                    if (ConditionField != null) {
                                        nodeJson.put("ConditionField", (Object)ConditionField);
                                    } else {
                                        nodeJson.put("ConditionField", (Object)"");
                                    }
                                    String key1 = eleFiled.attributeValue("Key");
                                    nodeJson.put("sourceTypeKey", (Object)key1);
                                }
                            }
                            break block66;
                        }
                        if (!root.attributeValue("SrcDataObjectKey").equalsIgnoreCase(sourceFormKey)) break block66;
                        elements = root.element("SourceTableCollection").elements("SourceTable");
                        for (Element ele : elements) {
                            tableKey = DataMapOperXmlUtil.getTableKey(ele);
                            if (!tableKey.equalsIgnoreCase(sourceTableKey)) continue;
                            sourceField1 = ele.elements("SourceField");
                            for (Element eleFiled : sourceField1) {
                                block69: {
                                    String fieldValue = DataMapOperXmlUtil.getFieldValue(eleFiled);
                                    if (!fieldValue.equalsIgnoreCase(sourceField) || !eleFiled.attributeValue("TargetFieldKey").equalsIgnoreCase(targetField)) continue;
                                    if (nodeJson.get((Object)"Migration") == null) break block69;
                                    List<String> keys = Arrays.asList("GroupingPolicy", "PeriodValue", "OpSign", "IsNegtive", "MapFormula");
                                    for (String key : keys) {
                                        String value = eleFiled.attributeValue(key);
                                        switch (key) {
                                            case "OpSign": 
                                            case "IsNegtive": 
                                            case "PeriodValue": 
                                            case "MapFormula": 
                                            case "GroupingPolicy": {
                                                nodeJson.put(key, (Object)value);
                                                break;
                                            }
                                        }
                                    }
                                    continue;
                                }
                                String editable = eleFiled.attributeValue("Editable");
                                String EdgeType = eleFiled.attributeValue("EdgeType");
                                String ConditionField = eleFiled.attributeValue("Condition");
                                if (editable != null) {
                                    nodeJson.put("Editable", (Object)editable);
                                } else {
                                    nodeJson.put("Editable", (Object)"true");
                                }
                                if (EdgeType != null) {
                                    nodeJson.put("EdgeType", (Object)EdgeType);
                                } else {
                                    nodeJson.put("EdgeType", (Object)"common");
                                }
                                if (ConditionField != null) {
                                    nodeJson.put("ConditionField", (Object)ConditionField);
                                    continue;
                                }
                                nodeJson.put("ConditionField", (Object)"");
                            }
                        }
                    }
                    if (targetmetaColumn == null) break block71;
                    nodeJson.put("targetkey", (Object)targetmetaColumn.getKey());
                    nodeJson.put("targetCaption", (Object)targetmetaColumn.getCaption());
                    nodeJson.put("targetTableKey", (Object)targetTablekey);
                    break block71;
                }
                if ("true".equalsIgnoreCase(operationType)) {
                    nodeJson.put("FieldCaption", (Object)targetmetaColumn.getCaption());
                    if (Objects.isNull(metaColumn)) {
                        nodeJson.put("sourceCaption", (Object)"");
                    } else {
                        nodeJson.put("sourceCaption", (Object)metaColumn.getCaption());
                    }
                    Element targetTableCollection = root.element("TargetTableCollection");
                    if (targetTableCollection != null) {
                        List targetTable = targetTableCollection.elements("TargetTable");
                        for (Element ele : targetTable) {
                            if (!ele.attributeValue("Key").equalsIgnoreCase(sourceTableKey)) continue;
                            List fields = ele.elements("TargetField");
                            for (Element field : fields) {
                                if (!field.attributeValue("Definition").equalsIgnoreCase(sourceField)) continue;
                                List feedback = field.elements("Feedback");
                                this.loadInfo(nodeJson, targetField, feedback);
                            }
                        }
                    }
                }
            }
            if (!extend) {
                nodeJson.put("sourceTypeKey", (Object)"canNot");
            }
            array.add((Object)nodeJson);
            result.setCode(0);
            result.setData(array);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u8fde\u7ebf\u4fe1\u606f\u5931\u8d25\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u8fde\u7ebf\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return result;
    }

    private void loadInfo(JSONObject nodeJson, String targetField, List<Element> feedback) {
        for (Element feed : feedback) {
            if (!feed.attributeValue("FieldKey").equalsIgnoreCase(targetField)) continue;
            if (StringUtils.isBlank((CharSequence)feed.attributeValue("OpSign"))) {
                nodeJson.put("OpSign", (Object)"");
            } else {
                nodeJson.put("OpSign", (Object)feed.attributeValue("OpSign"));
            }
            Element postTrigger = feed.element("PostTrigger");
            if (Objects.isNull(postTrigger)) {
                nodeJson.put("PostTrigger", (Object)"");
            } else {
                List content = postTrigger.content();
                String text = this.getCDATA(content);
                nodeJson.put("PostTrigger", (Object)text);
            }
            Element postFormulaTrigger = feed.element("PostFormulaTrigger");
            if (Objects.isNull(postFormulaTrigger)) {
                nodeJson.put("PostFormulaTrigger", (Object)"");
            } else {
                List content = postFormulaTrigger.content();
                String text = this.getCDATA(content);
                nodeJson.put("PostFormulaTrigger", (Object)text);
            }
            if (StringUtils.isBlank((CharSequence)feed.attributeValue("Condition"))) {
                nodeJson.put("Condition", (Object)"");
                continue;
            }
            nodeJson.put("Condition", (Object)feed.attributeValue("Condition"));
        }
    }

    private String getCDATA(List<Node> content) {
        String text = "";
        for (Node con : content) {
            if (!(con instanceof DefaultCDATA)) continue;
            text = con.getText();
        }
        return text;
    }

    public ResponseResult<JSONArray> getAllFormkey(JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        JSONArray array = new JSONArray();
        try {
            MetaFormList metaForm = MetaFactory.getGlobalInstance().getMetaFormList();
            JSONObject placeholder = new JSONObject();
            placeholder.put("id", (Object)"placeholder");
            placeholder.put("text", (Object)"  ");
            array.add((Object)placeholder);
            metaForm.forEach(formKey -> {
                JSONObject json = new JSONObject();
                if (formKey.getFormType() != 3) {
                    json.put("id", (Object)(String.valueOf(formKey.getKey()) + "  " + formKey.getCaption()));
                    json.put("text", (Object)(String.valueOf(formKey.getKey()) + "  " + formKey.getCaption()));
                    array.add((Object)json);
                }
            });
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u6240\u6709\u8868\u5355\u6210\u529f");
            result.setData(array);
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u6240\u6709\u8868\u5355\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u6240\u6709\u8868\u5355\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    public ResponseResult<JSONArray> coordinateData(JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        JSONArray array = new JSONArray();
        try {
            String nodeName;
            String filePaths = jsonDataMapVo.getFilePath();
            String tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
            if (StringUtils.isBlank((CharSequence)tempPath)) {
                tempPath = filePaths;
            }
            Element root = DataMapOperJsonUtil.getElement(tempPath);
            String formKey = jsonDataMapVo.getFormKey();
            switch (nodeName = jsonDataMapVo.getNodeName()) {
                case "SourceTableCollection": {
                    Element sourceTableCollection = root.element(nodeName);
                    JSONObject sourceJson = new JSONObject();
                    sourceJson.put("Height", (Object)sourceTableCollection.attributeValue("Height"));
                    sourceJson.put("Width", (Object)sourceTableCollection.attributeValue("Width"));
                    sourceJson.put("X", (Object)sourceTableCollection.attributeValue("X"));
                    sourceJson.put("Y", (Object)sourceTableCollection.attributeValue("Y"));
                    array.add((Object)sourceJson);
                    break;
                }
                case "TargetTableCollection": {
                    Element targetTableCollection = root.element(nodeName);
                    JSONObject targetJson = new JSONObject();
                    targetJson.put("Height", (Object)targetTableCollection.attributeValue("Height"));
                    targetJson.put("Width", (Object)targetTableCollection.attributeValue("Width"));
                    targetJson.put("X", (Object)targetTableCollection.attributeValue("X"));
                    targetJson.put("Y", (Object)targetTableCollection.attributeValue("Y"));
                    array.add((Object)targetJson);
                    break;
                }
                case "FeedbackCollection": {
                    List feedbackObject = root.element(nodeName).elements("FeedbackObject");
                    for (Element ele : feedbackObject) {
                        if (!ele.attributeValue("FormKey").equalsIgnoreCase(formKey)) continue;
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("X", (Object)ele.attributeValue("X"));
                        jsonObject.put("Y", (Object)ele.attributeValue("Y"));
                        array.add((Object)jsonObject);
                    }
                    break;
                }
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u5750\u6807\u6210\u529f");
            result.setData(array);
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u5750\u6807\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u5750\u6807\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    public ResponseResult<JSONArray> updateLigatureXML(JsonDataMapVo jsonDataMapVo) throws IOException {
        ResponseResult<JSONArray> result;
        block29: {
            result = new ResponseResult<JSONArray>();
            FileOutputStream fileOutputStream = null;
            XMLWriter writer = null;
            String tempPath = "";
            try {
                String filePaths = jsonDataMapVo.getFilePath();
                tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
                if (StringUtils.isBlank((CharSequence)tempPath)) {
                    tempPath = filePaths;
                }
                SAXReader reader = new SAXReader();
                Document document = reader.read(new File(tempPath));
                Element root = document.getRootElement();
                Map<String, String> map = DataMapOperXmlUtil.carveUp(jsonDataMapVo);
                String sourceField = map.get("sourceField");
                String targetField = map.get("targetField");
                String sourceTableKey = map.get("sourceTableKey");
                if (sourceField != null) {
                    sourceField = sourceField.replaceAll("'", "\"");
                }
                if (targetField != null) {
                    targetField = targetField.replaceAll("'", "\"");
                }
                String nodeName = jsonDataMapVo.getNodeName();
                String tableNode = "";
                String filedNode = "";
                if ("SourceTableCollection".equalsIgnoreCase(nodeName)) {
                    tableNode = "SourceTable";
                    filedNode = "SourceField";
                } else if ("TargetTableCollection".equalsIgnoreCase(nodeName)) {
                    tableNode = "TargetTable";
                    filedNode = "TargetField";
                }
                switch (nodeName) {
                    case "SourceTableCollection": 
                    case "TargetTableCollection": {
                        List table = root.element(nodeName).elements(tableNode);
                        for (Element ele : table) {
                            String tableKey = DataMapOperXmlUtil.getTableKey(ele);
                            if (!tableKey.equalsIgnoreCase(sourceTableKey)) continue;
                            List Field2 = ele.elements(filedNode);
                            Boolean haveRepeat = false;
                            Element node = null;
                            for (Element field : Field2) {
                                if ("SourceTableCollection".equalsIgnoreCase(nodeName)) {
                                    if (field.attributeValue("Definition").equalsIgnoreCase(sourceField) && field.attributeValue("TargetFieldKey") != null && !field.attributeValue("TargetFieldKey").equalsIgnoreCase(targetField)) {
                                        haveRepeat = true;
                                    }
                                    if (!field.attributeValue("Definition").equalsIgnoreCase(sourceField) || field.attributeValue("TargetFieldKey") == null || !field.attributeValue("TargetFieldKey").equalsIgnoreCase(targetField)) continue;
                                    List attributes = field.attributes();
                                    String type = null;
                                    for (Attribute attribute : attributes) {
                                        if (!"Type".equalsIgnoreCase(attribute.getQName().getName())) continue;
                                        type = attribute.getValue();
                                    }
                                    if (haveRepeat.booleanValue()) {
                                        node = field;
                                        continue;
                                    }
                                    String key = field.attributeValue("Key");
                                    attributes.clear();
                                    if (type != null && !"".equalsIgnoreCase(type)) {
                                        field.addAttribute("Definition", sourceField).addAttribute("Type", type).addAttribute("Key", key);
                                        continue;
                                    }
                                    field.addAttribute("Definition", sourceField).addAttribute("Key", key);
                                    continue;
                                }
                                if (!"TargetTableCollection".equalsIgnoreCase(nodeName)) continue;
                                this.updateTargetLigatureXML(sourceField, targetField, field);
                            }
                            if (!haveRepeat.booleanValue()) continue;
                            Field2.remove(node);
                        }
                        break;
                    }
                }
                OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
                String solutionPath = String.valueOf(FilePathHelper.getWorkspacePath()) + File.separator;
                String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", String.valueOf(filePaths.substring(solutionPath.length()).replace(File.separator, "__")) + "." + System.currentTimeMillis()).toString();
                fileOutputStream = new FileOutputStream(newFilePath);
                writer = new XMLWriter(fileOutputStream, format);
                writer.write(document);
                XmlFileProcessor.stackput(filePaths, newFilePath);
                result.setCode(0);
                result.setMsg("success");
            }
            catch (Exception e) {
                logger.warning("failure\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
                result.setCode(999);
                result.setMsg("failure\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
                DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
                break block29;
            }
            catch (Throwable throwable) {
                try {
                    logger.warning(throwable.getMessage());
                    break block29;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
                }
            }
            DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public ResponseResult<JSONArray> handleDeleteXML(JsonDataMapVo jsonDataMapVo) throws Throwable {
        block11: {
            result = new ResponseResult<JSONArray>();
            fileOutputStream = null;
            writer = null;
            tempPath = "";
            filePaths = "";
            try {
                block12: {
                    filePaths = jsonDataMapVo.getFilePath();
                    tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
                    if (StringUtils.isBlank((CharSequence)tempPath)) {
                        tempPath = filePaths;
                    }
                    reader = new SAXReader();
                    document = reader.read(new File(tempPath));
                    element = document.getRootElement();
                    formKey = jsonDataMapVo.getFormKey().split("__Feed")[0];
                    mapFeedbackObjectNode = DataMapOperXmlUtil.getMapFeedbackObjectNode(document, formKey);
                    feedbackTableNodeList = mapFeedbackObjectNode.selectNodes("FeedbackTable");
                    for (Node feedbackTableNode : feedbackTableNodeList) {
                        tableKey = ((Element)feedbackTableNode).attributeValue("TableKey");
                        feedbackFieldNodeList = feedbackTableNode.selectNodes("FeedbackField");
                        for (Node feedbackFieldNode : feedbackFieldNodeList) {
                            fieldKey = ((Element)feedbackFieldNode).attributeValue("FieldKey");
                            this.deleteField(fieldKey, tableKey, document);
                        }
                    }
                    feedbackObject = element.element("FeedbackCollection").elements("FeedbackObject");
                    iterator = feedbackObject.iterator();
                    if (feedbackObject.size() > 1) ** GOTO lbl35
                    element.remove(element.element("FeedbackCollection"));
                    break block12;
lbl-1000:
                    // 1 sources

                    {
                        next = (Element)iterator.next();
                        if (!next.attributeValue("FormKey").equalsIgnoreCase(formKey)) continue;
                        iterator.remove();
lbl35:
                        // 3 sources

                        ** while (iterator.hasNext())
                    }
                }
                format = DataMapOperXmlUtil.getOutputFormat();
                solutionPath = String.valueOf(FilePathHelper.getWorkspacePath()) + File.separator;
                newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), new String[]{"tmp", String.valueOf(filePaths.substring(solutionPath.length()).replace(File.separator, "__")) + "." + System.currentTimeMillis()}).toString();
                fileOutputStream = new FileOutputStream(newFilePath);
                writer = new XMLWriter(fileOutputStream, format);
                writer.write(document);
                XmlFileProcessor.stackput(filePaths, newFilePath);
                result.setCode(0);
                result.setMsg("success");
            }
            catch (Exception e) {
                DataMapOperXmlUtil.logger.warning("\u5220\u9664\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
                result.setCode(999);
                result.setMsg("\u5220\u9664\u5f02\u5e38\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
                DataMapOperXmlUtil.setData(result, filePaths);
                DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
                break block11;
            }
            catch (Throwable throwable) {
                try {
                    DataMapOperXmlUtil.logger.warning(throwable.getMessage());
                    break block11;
                }
                catch (Throwable var20_22) {
                    throw var20_22;
                }
                finally {
                    DataMapOperXmlUtil.setData(result, filePaths);
                    DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
                }
            }
            DataMapOperXmlUtil.setData(result, filePaths);
            DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
        }
        return result;
    }

    public void updateTargetLigatureXML(String sourceField, String targetField, Element field) {
        if (field.attributeValue("Definition").equalsIgnoreCase(sourceField)) {
            List feedback = field.elements("Feedback");
            for (Element feed : feedback) {
                if (!feed.attributeValue("FieldKey").equalsIgnoreCase(targetField)) continue;
                field.remove(feed);
            }
        }
    }

    public ResponseResult<List<JSONObject>> SaveHtml(String filePaths) throws Throwable {
        ResponseResult<List<JSONObject>> result = new ResponseResult<List<JSONObject>>();
        try {
            File file = new File(filePaths);
            String tmpFile = XmlFileProcessor.instance.getTmpFile(filePaths);
            if (StringUtils.isBlank((CharSequence)tmpFile)) {
                tmpFile = filePaths;
            }
            String newContent = FileUtils.readFileToString((File)new File(tmpFile), (String)"UTF-8");
            FileUtils.writeStringToFile((File)file, (String)newContent, (String)"UTF-8");
            result.setCode(0);
            result.setMsg("\u4fdd\u5b58\u6210\u529f");
            XmlFileProcessor.instance.clearTmpFile(filePaths);
            String fileContent = FileUtils.readFileToString((File)new File(filePaths), (String)"UTF-8");
            XmlTree parse = XmlParser.parse(fileContent);
            TagNode root = parse.getRoot();
            if ("Map".equalsIgnoreCase(root.getTagName())) {
                String isPrimary;
                List<TagNode> targetTable = root.findNodesByTagName("TargetTable");
                List<TagNode> sourceTable = root.findNodesByTagName("SourceTable");
                IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
                String srcFormKey = root.getAttributes().get("SrcFormKey");
                String tgtFormKey = root.getAttributes().get("TgtFormKey");
                MetaFormList metaFormList = metaFactory.getMetaFormList();
                MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
                MetaFormProfile metaFormProfile = (MetaFormProfile)metaFormList.get(srcFormKey);
                MetaFormProfile formProfile = (MetaFormProfile)metaFormList.get(tgtFormKey);
                String srcObjectKey = root.getAttributes().get("SrcDataObjectKey");
                String tgtObjectKey = root.getAttributes().get("TgtDataObjectKey");
                String extend = root.getAttributes().get("Extend");
                MetaDataObjectProfile dataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(srcObjectKey);
                MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(tgtObjectKey);
                String targetTableKey = null;
                String sourceTableKey = null;
                for (TagNode tagNode : targetTable) {
                    isPrimary = tagNode.getAttributes().get("IsPrimary");
                    if (isPrimary == null || "false".equalsIgnoreCase(isPrimary)) continue;
                    targetTableKey = tagNode.getAttributes().get("Key");
                }
                for (TagNode tagNode : sourceTable) {
                    isPrimary = tagNode.getAttributes().get("IsPrimary");
                    if (isPrimary == null || "false".equalsIgnoreCase(isPrimary)) continue;
                    sourceTableKey = tagNode.getAttributes().get("DataMigration".equalsIgnoreCase(root.getTagName()) ? "TableKey" : "DataSource");
                }
                ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
                String pullDataOnly = root.getAttributes().get("PullDataOnly");
                if (("false".equalsIgnoreCase(pullDataOnly) || StringUtils.isEmpty((CharSequence)pullDataOnly)) && StringUtils.isEmpty((CharSequence)extend)) {
                    MetaDataObject dataObject;
                    if (sourceTableKey != null && metaFormProfile != null && "".equalsIgnoreCase(metaFactory.getMetaForm(srcFormKey).getDataSource().getRefObjectKey())) {
                        MetaForm srcMetaForm = metaFormProfile.getForm();
                        this.setsourcefiled(jsonObjects, srcMetaForm, null, srcFormKey, sourceTableKey, targetTableKey);
                    } else if (sourceTableKey != null && dataObjectProfile != null) {
                        dataObject = dataObjectProfile.getDataObject();
                        this.setsourcefiled(jsonObjects, null, dataObject, srcFormKey, sourceTableKey, targetTableKey);
                    }
                    if (targetTableKey != null && formProfile != null && "".equalsIgnoreCase(formProfile.getForm().getDataSource().getRefObjectKey())) {
                        MetaForm tgtMetaForm = formProfile.getForm();
                        this.setargetfiled(jsonObjects, tgtMetaForm, null, tgtFormKey, targetTableKey, sourceTableKey);
                    } else if (targetTableKey != null && formProfile != null && metaDataObjectProfile != null) {
                        dataObject = metaDataObjectProfile.getDataObject();
                        this.setargetfiled(jsonObjects, formProfile.getForm(), dataObject, tgtFormKey, targetTableKey, sourceTableKey);
                    }
                }
                result.setData(jsonObjects);
                String projectKey = LoadFileTree.getProjectKey(filePaths);
                ReloadForm.reloadCustom(projectKey, LoadFileTree.getKeyByFilePath(filePaths));
            } else {
                IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
                String key = LoadFileTree.getKeyByFilePath(filePaths);
                MetaDataMigrationProfile metaDataMigrationProfile = (MetaDataMigrationProfile)iMetaFactory.getDataMigrationList().get(key);
                String resource = LoadFileTree.getResource(filePaths, metaDataMigrationProfile.getProject().getKey());
                ReloadForm.reloadDataMigrationKey(iMetaFactory, key, resource);
            }
        }
        catch (Throwable e) {
            throw new Throwable("\u4fdd\u5b58\u51fa\u73b0\u5f02\u5e38\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    private void setsourcefiled(List<JSONObject> jsonObjects, MetaForm metaForm, MetaDataObject dataObject, String srcFormKey, String mainTableKey, String targetTableKey) throws Throwable {
        String filePath;
        String path = null;
        if (dataObject != null) {
            String key = dataObject.getKey();
            path = LoadFileTree.loadFilePathByDataObjectFieldKey(key);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("filePath", (Object)path);
            jsonObject.put("key", (Object)key);
            jsonObject.put("type", (Object)"DataObject");
            jsonObjects.add(jsonObject);
        } else if (metaForm != null) {
            path = LoadFileTree.getPathByFormKey(srcFormKey);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("filePath", (Object)path);
            jsonObject.put("key", (Object)srcFormKey);
            jsonObject.put("type", (Object)"Form");
            jsonObjects.add(jsonObject);
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(path));
        Element element = document.getRootElement();
        boolean checkColumn = false;
        XmlTreeWithPath xmlTree = null;
        if (dataObject != null) {
            filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(dataObject.getKey());
            xmlTree = XmlTreeWithPath.parseFilePath(filePath);
        } else if (metaForm != null) {
            filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
            xmlTree = XmlTreeWithPath.parseFilePath(filePath);
        }
        List<TagNode> table = xmlTree.xmlTree.getRoot().findNodesByTagName("Table");
        block0: for (TagNode tag : table) {
            if (!tag.getAttributes().get("Key").equalsIgnoreCase(mainTableKey)) continue;
            String strings = "MapCount";
            List<TagNode> column = tag.findNodesByTagName("Column");
            for (TagNode tagNode : column) {
                String key = tagNode.getAttributes().get("Key");
                if (!strings.equalsIgnoreCase(key)) continue;
                checkColumn = true;
                continue block0;
            }
        }
        if (!checkColumn && !mainTableKey.isEmpty()) {
            List<Element> tableNode = this.findTableNode(element);
            for (Element ele : tableNode) {
                if (!ele.attributeValue("Key").equalsIgnoreCase(mainTableKey)) continue;
                ele.addElement("Column").addAttribute("Key", "MapCount").addAttribute("Caption", "MapCount").addAttribute("DataType", "Integer");
            }
            OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
            FileOutputStream fileOutputStream = new FileOutputStream(path);
            XMLWriter writer = new XMLWriter(fileOutputStream, format);
            writer.write(document);
            if (dataObject != null) {
                String key = dataObject.getKey();
                String resource1 = LoadFileTree.getPathByDataObject(key);
                DataObjectHelper.reload(null, key, resource1, null);
            } else {
                DesignReloadMetaObject.reloadMetaFormRollbackError(null, srcFormKey);
            }
        }
    }

    private void setargetfiled(List<JSONObject> jsonObjects, MetaForm metaForm, MetaDataObject dataObject, String tgtFormKey, String mainTableKey, String sourceTableKey) throws Throwable {
        String path = null;
        String dataObjectPath = null;
        String formPath = null;
        if (dataObject != null) {
            String key = dataObject.getKey();
            dataObjectPath = path = LoadFileTree.loadFilePathByDataObjectFieldKey(key);
            formPath = LoadFileTree.getPathByFormKey(metaForm.getKey());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("filePath", (Object)path);
            jsonObject.put("key", (Object)key);
            jsonObject.put("type", (Object)"DataObject");
            jsonObjects.add(jsonObject);
        } else if (metaForm != null) {
            formPath = path = LoadFileTree.getPathByFormKey(tgtFormKey);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("filePath", (Object)path);
            jsonObject.put("key", (Object)tgtFormKey);
            jsonObject.put("type", (Object)"Form");
            jsonObjects.add(jsonObject);
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(path));
        Element element = document.getRootElement();
        boolean checkColumn = this.checkColumn(metaForm, dataObject, mainTableKey);
        if (!checkColumn && sourceTableKey != null) {
            List<Element> tableNode = this.findTableNode(element);
            for (Element ele : tableNode) {
                if (!ele.attributeValue("Key").equalsIgnoreCase(mainTableKey)) continue;
                List<String> longs = Arrays.asList("SrcOID", "SrcSOID", "SrcSequence");
                for (String keyAndCaption : longs) {
                    ele.addElement("Column").addAttribute("Key", keyAndCaption).addAttribute("Caption", keyAndCaption).addAttribute("DataType", "Long");
                }
                List<String> strings = Arrays.asList("MapKey", "SrcDocumentNumber", "SrcFormKey");
                for (String keyAndCaption : strings) {
                    ele.addElement("Column").addAttribute("Key", keyAndCaption).addAttribute("Caption", keyAndCaption).addAttribute("DataType", "Varchar");
                }
            }
            if (dataObject != null) {
                OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
                FileOutputStream fileOutputStream = new FileOutputStream(path);
                XMLWriter writer = new XMLWriter(fileOutputStream, format);
                writer.write(document);
                Document formDocument = reader.read(new File(formPath));
                element = formDocument.getRootElement();
                String cellKey = this.getGridCellKey(metaForm, mainTableKey);
                if (cellKey != null) {
                    String columnKey = this.getGridColumnKey(metaForm, cellKey);
                    boolean checkGridColumn = this.checkGridColumn(metaForm, mainTableKey);
                    boolean checkGridCell = this.checkGridCell(metaForm, mainTableKey);
                    if (columnKey != null && columnKey.equalsIgnoreCase(cellKey)) {
                        List elements = element.element("Body").element("Block").element("FlexFlowLayoutPanel").elements("SplitPanel");
                        if (!checkGridColumn) {
                            this.findcheckGridColumnNode(elements, cellKey);
                        }
                        if (!checkGridCell) {
                            this.findcheckGridCellNode(elements, cellKey);
                        }
                    }
                }
                FileOutputStream fileOutputStream1 = new FileOutputStream(formPath);
                XMLWriter writer1 = new XMLWriter(fileOutputStream1, format);
                writer1.write(formDocument);
            } else {
                String cellKey = this.getGridCellKey(metaForm, mainTableKey);
                if (cellKey != null) {
                    String columnKey = this.getGridColumnKey(metaForm, cellKey);
                    boolean checkGridColumn = this.checkGridColumn(metaForm, mainTableKey);
                    boolean checkGridCell = this.checkGridCell(metaForm, mainTableKey);
                    if (columnKey != null && columnKey.equalsIgnoreCase(cellKey)) {
                        List elements = element.element("Body").element("Block").element("FlexFlowLayoutPanel").elements("SplitPanel");
                        if (!checkGridColumn) {
                            this.findcheckGridColumnNode(elements, cellKey);
                        }
                        if (!checkGridCell) {
                            this.findcheckGridCellNode(elements, cellKey);
                        }
                    }
                }
                OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
                FileOutputStream fileOutputStream = new FileOutputStream(path);
                XMLWriter writer = new XMLWriter(fileOutputStream, format);
                writer.write(document);
            }
            if (dataObject != null) {
                String resource = LoadFileTree.getPathByDataObject(dataObject.getKey());
                DataObjectHelper.reload(null, dataObject.getKey(), resource, null);
            } else {
                String metaFormKey = metaForm.getKey();
                DesignReloadMetaObject.reloadMetaFormRollbackError(null, metaFormKey);
            }
        }
    }

    private List<Element> findTableNode(Element element) {
        List elements = "DataObject".equalsIgnoreCase(element.getQName().getName()) ? element.element("TableCollection").elements("Table") : element.element("DataSource").element("DataObject").element("TableCollection").elements("Table");
        return elements;
    }

    private void findcheckGridColumnNode(List<Element> elements, String keyss) {
        for (Element element1 : elements) {
            if (keyss.equalsIgnoreCase(element1.attributeValue("Key"))) {
                List<String> strings = Arrays.asList("SrcOID", "SrcSOID", "SrcSequence", "MapKey", "SrcDocumentNumber", "SrcFormKey");
                Element elementGridColumn = element1.element("GridColumnCollection");
                for (String keyAndCaption : strings) {
                    elementGridColumn.addElement("GridColumn").addAttribute("Key", keyAndCaption).addAttribute("Caption", keyAndCaption).addAttribute("Width", "80px").addAttribute("Visible", "DebugMode()");
                }
                break;
            }
            elements = element1.elements();
            if (elements.size() <= 0) continue;
            this.findcheckGridColumnNode(elements, keyss);
        }
    }

    private void findcheckGridCellNode(List<Element> elements, String keyss) {
        for (Element element1 : elements) {
            block20: {
                if (!keyss.equalsIgnoreCase(element1.attributeValue("Key"))) break block20;
                List<String> strings = Arrays.asList("SrcOID", "SrcSOID", "SrcSequence", "MapKey", "SrcDocumentNumber", "SrcFormKey");
                Element elementGridCell = element1.element("GridRowCollection").element("GridRow");
                Iterator<String> iterator = strings.iterator();
                while (iterator.hasNext()) {
                    String keyAndCaption;
                    switch (keyAndCaption = iterator.next()) {
                        case "SrcOID": 
                        case "SrcSequence": 
                        case "SrcSOID": {
                            elementGridCell.addElement("GridCell").addAttribute("Key", keyAndCaption).addAttribute("Caption", keyAndCaption).addAttribute("CellType", "NumberEditor").addAttribute("Enable", "false").addElement("DataBinding").addAttribute("ColumnKey", keyAndCaption);
                            break;
                        }
                        case "MapKey": 
                        case "SrcFormKey": 
                        case "SrcDocumentNumber": {
                            elementGridCell.addElement("GridCell").addAttribute("Key", keyAndCaption).addAttribute("Caption", keyAndCaption).addAttribute("CellType", "TextEditor").addAttribute("Enable", "false").addElement("DataBinding").addAttribute("ColumnKey", keyAndCaption);
                            break;
                        }
                    }
                }
                continue;
            }
            elements = element1.elements();
            if (elements.size() <= 0) continue;
            this.findcheckGridCellNode(elements, keyss);
        }
    }

    private boolean checkColumn(MetaForm metaForm, MetaDataObject dataObject, String mainTableKey) throws Throwable {
        String filePath;
        boolean ishas = false;
        XmlTreeWithPath xmlTree = null;
        if (dataObject != null) {
            filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(dataObject.getKey());
            xmlTree = XmlTreeWithPath.parseFilePath(filePath);
        } else if (metaForm != null) {
            filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
            xmlTree = XmlTreeWithPath.parseFilePath(filePath);
        }
        if (xmlTree != null) {
            List<TagNode> table = xmlTree.xmlTree.getRoot().findNodesByTagName("Table");
            block0: for (TagNode tag : table) {
                if (!tag.getAttributes().get("Key").equalsIgnoreCase(mainTableKey)) continue;
                List<String> strings = Arrays.asList("SrcOID", "SrcSOID", "SrcSequence", "MapKey", "SrcDocumentNumber", "SrcFormKey");
                List<TagNode> column = tag.findNodesByTagName("Column");
                for (TagNode tagNode : column) {
                    String key = tagNode.getAttributes().get("Key");
                    if (!strings.contains(key)) continue;
                    ishas = strings.contains(key);
                    continue block0;
                }
            }
        }
        return ishas;
    }

    private boolean checkGridCell(MetaForm metaForm, String mainTableKey) throws Throwable {
        boolean ishas = false;
        String filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
        XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(filePath);
        List<TagNode> grid = xmlTree.xmlTree.getRoot().findNodesByTagName("GridRow");
        block0: for (TagNode tag : grid) {
            if (!tag.getAttributes().get("TableKey").equalsIgnoreCase(mainTableKey)) continue;
            List<String> strings = Arrays.asList("SrcOID", "SrcSOID", "SrcSequence", "MapKey", "SrcDocumentNumber", "SrcFormKey");
            List<TagNode> gridColumnCollection = tag.findNodesByTagName("GridCell");
            for (TagNode tagNode : gridColumnCollection) {
                if (!strings.contains(tagNode.getAttributes().get("Key"))) continue;
                ishas = true;
                continue block0;
            }
        }
        return ishas;
    }

    private boolean checkGridColumn(MetaForm metaForm, String mainTableKey) throws Throwable {
        boolean ishas = false;
        String filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
        XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(filePath);
        List<TagNode> grid = xmlTree.xmlTree.getRoot().findNodesByTagName("GridRow");
        block0: for (TagNode tag : grid) {
            if (!tag.getAttributes().get("TableKey").equalsIgnoreCase(mainTableKey)) continue;
            List<String> strings = Arrays.asList("SrcOID", "SrcSOID", "SrcSequence", "MapKey", "SrcDocumentNumber", "SrcFormKey");
            List<TagNode> gridColumnCollection = tag.findNodesByTagName("GridColumnCollection");
            for (TagNode tagNode : gridColumnCollection) {
                if (!strings.contains(tagNode.getAttributes().get("Key"))) continue;
                ishas = true;
                continue block0;
            }
        }
        return ishas;
    }

    private String getGridColumnKey(MetaForm metaForm, String cellKey) throws Throwable {
        String tableKey = null;
        String filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
        XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(filePath);
        List<TagNode> grid = xmlTree.xmlTree.getRoot().findNodesByTagName("GridColumn");
        for (TagNode tagNode : grid) {
            String key = tagNode.getParent().getParent().getAttributes().get("Key");
            if (!cellKey.equalsIgnoreCase(key)) continue;
            tableKey = cellKey;
        }
        return tableKey;
    }

    private String getGridCellKey(MetaForm metaForm, String mainTableKey) throws Throwable {
        XmlTreeWithPath xmlTree = null;
        String tableKey = null;
        String filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
        xmlTree = XmlTreeWithPath.parseFilePath(filePath);
        List<TagNode> grid = xmlTree != null ? xmlTree.xmlTree.getRoot().findNodesByTagName("GridRow") : null;
        for (TagNode tagNode : grid) {
            String key;
            if (!mainTableKey.equalsIgnoreCase(tagNode.getAttributes().get("TableKey"))) continue;
            tableKey = key = tagNode.getParent().getParent().getAttributes().get("Key");
        }
        return tableKey;
    }

    public void sourceAndTargetSwap(String bFiled, String sField, String tableKey, boolean isMap, String filedNode, String filedLabel, Element element) {
        if (element.attributeValue(isMap ? "Key" : "TableKey").equalsIgnoreCase(tableKey)) {
            List filedList = element.elements(filedNode);
            Integer bIndex = null;
            Integer sIndex = null;
            Element tempBNode = null;
            for (Element node : filedList) {
                if (node.attributeValue(filedLabel).equalsIgnoreCase(bFiled)) {
                    bIndex = filedList.indexOf(node);
                    tempBNode = node;
                }
                if (!node.attributeValue(filedLabel).equalsIgnoreCase(sField)) continue;
                sIndex = filedList.indexOf(node);
            }
            if (bIndex != null && sIndex != null) {
                filedList.set(bIndex, (Element)((Element)filedList.get(sIndex)).clone());
                filedList.set(sIndex, (Element)tempBNode.clone());
                bIndex = null;
                sIndex = null;
            }
        }
    }

    public void feedBackSwap(String bFiled, String sField, String tableKey, List<Element> feedBackTableList) {
        feedBackTableList.forEach(table -> {
            if (table.attributeValue("TableKey").equalsIgnoreCase(tableKey)) {
                List feedBackField = table.elements("FeedbackField");
                Integer bIndex = null;
                Integer sIndex = null;
                Element bNode = null;
                for (Element field : feedBackField) {
                    if (field.attributeValue("FieldKey").equalsIgnoreCase(bFiled)) {
                        bIndex = feedBackField.indexOf(field);
                        bNode = field;
                    }
                    if (field.attributeValue("FieldKey").equalsIgnoreCase(sField)) {
                        sIndex = feedBackField.indexOf(field);
                    }
                    if (bIndex == null || sIndex == null) continue;
                    feedBackField.set(bIndex, (Element)((Element)feedBackField.get(sIndex)).clone());
                    feedBackField.set(sIndex, (Element)bNode.clone());
                    bIndex = null;
                    sIndex = null;
                }
            }
        });
    }

    private static Map<String, String> carveUp(JsonDataMapVo jsonDataMapVo) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String sourceFormKey = "";
        String targetFormKey = "";
        String sourceField = "";
        String targetField = "";
        String sourceTableKey = "";
        String targetTablekey = "";
        if (jsonDataMapVo.getFormKey() != null) {
            sourceFormKey = jsonDataMapVo.getFormKey().split("&&")[0];
            targetFormKey = jsonDataMapVo.getFormKey().split("&&")[1];
            map.put("sourceFormKey", sourceFormKey);
            map.put("targetFormKey", targetFormKey);
        }
        if (jsonDataMapVo.getFieldKey() != null) {
            sourceField = jsonDataMapVo.getSourceFieldKey();
            targetField = jsonDataMapVo.getTargetFieldKey();
            map.put("sourceField", sourceField);
            map.put("targetField", targetField);
        }
        if (jsonDataMapVo.getTableKey() != null) {
            sourceTableKey = jsonDataMapVo.getTableKey().split("&&")[0];
            targetTablekey = jsonDataMapVo.getTableKey().split("&&")[1];
            map.put("sourceTableKey", sourceTableKey);
            map.put("targetTablekey", targetTablekey);
        }
        return map;
    }

    public void dataProcessing(String key, String endField, String value, String tableKey, String fieldKey, List<Element> targetTable) {
        for (Element ele : targetTable) {
            if (!tableKey.equalsIgnoreCase(ele.attributeValue("DataSource")) && !tableKey.equalsIgnoreCase(ele.attributeValue("Key"))) continue;
            List targetField = ele.elements("TargetField");
            for (Element target : targetField) {
                if (!target.attributeValue("Definition").equalsIgnoreCase(fieldKey)) continue;
                this.dataProcessing(key, endField, value, target);
            }
        }
    }

    public void dataProcessing(String key, String endField, String value, Element target) {
        List feedback = target.elements("Feedback");
        for (Element feed : feedback) {
            if (!feed.attributeValue("FieldKey").equalsIgnoreCase(endField)) continue;
            if ("OpSign".equalsIgnoreCase(key)) {
                if ("AddDelta".equalsIgnoreCase(value)) {
                    feed.addAttribute(key, value);
                    continue;
                }
                feed.remove(feed.attribute(key));
                continue;
            }
            if ("PostTrigger".equalsIgnoreCase(key)) {
                this.setNode(key, value, feed);
                continue;
            }
            if ("PostFormulaTrigger".equalsIgnoreCase(key)) {
                this.setNode(key, value, feed);
                continue;
            }
            if (!"FeedCondition".equalsIgnoreCase(key)) continue;
            if (value != null) {
                feed.addAttribute("Condition", value);
                continue;
            }
            feed.remove(feed.attribute("Condition"));
        }
    }

    public void setNode(String key, String value, Element feed) {
        if (value != null && Objects.isNull(feed.element(key))) {
            feed.addElement(key).addCDATA(value);
        } else if (value != null && feed.element(key) != null) {
            feed.remove(feed.element(key));
            feed.addElement(key).addCDATA(value);
        } else {
            feed.remove(feed.element(key));
        }
    }

    private void setLigature(String key, String value, String nodeName, String tableKey, String fieldKey, Element root, String endField) {
        List targetTable = root.element(nodeName).elements("SourceTable");
        for (Element ele : targetTable) {
            if (!tableKey.equalsIgnoreCase(StringUtils.isNotEmpty((CharSequence)ele.attributeValue("DataSource")) ? ele.attributeValue("DataSource") : ele.attributeValue("Key"))) continue;
            List sourceField = ele.elements("SourceField");
            for (Element source : sourceField) {
                if (!source.attributeValue("Definition").equalsIgnoreCase(fieldKey) || !source.attributeValue("TargetFieldKey").equalsIgnoreCase(endField)) continue;
                if ("Editable".equalsIgnoreCase(key)) {
                    if ("false".equalsIgnoreCase(value)) {
                        source.addAttribute(key, value);
                        continue;
                    }
                    source.remove(source.attribute("Editable"));
                    continue;
                }
                if (!"ConditionField".equalsIgnoreCase(key)) continue;
                if (value != null) {
                    source.addAttribute("Condition", value);
                    continue;
                }
                source.remove(source.attribute("Condition"));
            }
        }
    }

    public static OutputFormat getOutputFormat() {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(4);
        format.setExpandEmptyElements(false);
        format.setPadText(false);
        return format;
    }

    private void deleteXmlElementAttribute(Element element, Attribute attribute) {
        if (attribute != null) {
            element.remove(attribute);
        }
    }

    public static void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            logger.warning("\u5173\u95edwriter\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static String getTableKey(Element ele) {
        String table = "";
        if (ele.attributeValue("Key") != null) {
            table = ele.attributeValue("Key");
        } else if (ele.attributeValue("TableKey") != null) {
            table = ele.attributeValue("TableKey");
        }
        return table;
    }

    public static String getFieldValue(Element ele1) {
        String filedVaule = "";
        if (ele1.attributeValue("Definition") != null) {
            filedVaule = ele1.attributeValue("Definition");
        } else if (ele1.attributeValue("FieldKey") != null) {
            filedVaule = ele1.attributeValue("FieldKey");
        }
        return filedVaule;
    }

    public ResponseResult<JSONArray> isHaveMainTable(String filePaths) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(filePaths);
            String tagName = xmlTree.xmlTree.getRoot().getTagName();
            List<TagNode> sourceTable = xmlTree.xmlTree.getRoot().findNodesByTagName("SourceTable");
            List<TagNode> targetTable = xmlTree.xmlTree.getRoot().findNodesByTagName("TargetTable");
            if ("Map".equalsIgnoreCase(tagName)) {
                sourceTable.addAll(targetTable);
                ArrayList<String> strings = new ArrayList<String>();
                for (TagNode tagNode : sourceTable) {
                    if (!"true".equalsIgnoreCase(tagNode.getAttributes().get("IsPrimary"))) continue;
                    String name = tagNode.getTagName();
                    strings.add(name);
                }
                if (strings.size() == 0 || strings.size() == 1 && strings.contains("TargetTable")) {
                    result.setCode(0);
                    result.setMsg("\u6620\u5c04\u95ee\u9898:\u6e90\u8868\u5355\u672a\u8bbe\u7f6e\u4e3b\u8868");
                } else if (strings.size() == 2) {
                    result.setCode(0);
                } else if (strings.contains("SourceTable")) {
                    result.setCode(0);
                    result.setMsg("\u6620\u5c04\u95ee\u9898:\u76ee\u6807\u8868\u5355\u672a\u8bbe\u7f6e\u4e3b\u8868");
                }
            } else if ("DataMigration".equalsIgnoreCase(tagName)) {
                for (TagNode tagNode : sourceTable) {
                    if (!"true".equalsIgnoreCase(tagNode.getAttributes().get("IsPrimary"))) continue;
                    result.setCode(0);
                    return result;
                }
                result.setCode(0);
                result.setMsg("\u8fc1\u79fb\u95ee\u9898:\u6765\u6e90\u5355\u672a\u8bbe\u7f6e\u4e3b\u8868");
            }
        }
        catch (Throwable e) {
            logger.warning("\u9a8c\u8bc1\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u9a8c\u8bc1\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }
}

