/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.datamap.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class DataMapOperJsonUtil {
    public static final DataMapOperJsonUtil instance = new DataMapOperJsonUtil();
    private static final String XML_EXTENSION = ".xml";
    private static final List<String> undoSet = new ArrayList<String>();

    public Map<String, String> createDataMapXml(String projectKey, String sourceFormKey, String targetFormKey, String key, String caption, String version, String extend) {
        HashMap<String, String> result = new HashMap<String, String>(10);
        String dataMapPathByKey = LoadFileTree.getDataMapPathByKey(key);
        if (StringUtils.isNotEmpty((CharSequence)dataMapPathByKey)) {
            result.put("result", "false");
            return result;
        }
        String filePath = "";
        try {
            int verionNo = Integer.parseInt(version) + 1;
            String newFileName = String.valueOf(key) + XML_EXTENSION;
            filePath = LoadFileTree.newDataMap(projectKey, newFileName, key, caption);
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(sourceFormKey);
            String extendFormKey = null;
            String srcDataObjectKey = "";
            String targetDataObjectKey = "";
            if (metaFormOrMetaDataObject.metaForm != null) {
                extendFormKey = globalInstance.getMetaForm(sourceFormKey).getExtend();
                if (StringUtils.isNotEmpty((CharSequence)extendFormKey)) {
                    MetaForm metaForm = globalInstance.getMetaForm(extendFormKey);
                    srcDataObjectKey = metaForm.getDataSource().getDataObject().getKey();
                } else {
                    srcDataObjectKey = globalInstance.getMetaForm(sourceFormKey).getDataSource().getDataObject().getKey();
                }
            } else if (metaFormOrMetaDataObject.metaDataObject != null) {
                srcDataObjectKey = ((MetaDataObject)metaFormOrMetaDataObject.metaDataObject).getKey();
            }
            metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(targetFormKey);
            String extendTargetForm = null;
            if (metaFormOrMetaDataObject.metaForm != null) {
                extendTargetForm = globalInstance.getMetaForm(targetFormKey).getExtend();
                if (StringUtils.isNotEmpty((CharSequence)extendTargetForm)) {
                    MetaForm metaForm = globalInstance.getMetaForm(extendTargetForm);
                    targetDataObjectKey = metaForm.getDataSource().getDataObject().getKey();
                } else {
                    targetDataObjectKey = globalInstance.getMetaForm(targetFormKey).getDataSource().getDataObject().getKey();
                }
            } else if (metaFormOrMetaDataObject.metaDataObject != null) {
                targetDataObjectKey = ((MetaDataObject)metaFormOrMetaDataObject.metaDataObject).getKey();
            }
            String fileContent = StringUtils.isNotEmpty((CharSequence)extend) ? this.createDataMapVestXml(caption, key, extend, srcDataObjectKey, sourceFormKey, targetDataObjectKey, targetFormKey) : "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Map Caption=\"" + caption + "\" Key=\"" + key + "\" SrcDataObjectKey=\"" + srcDataObjectKey + "\"" + " SrcFormKey=\"" + sourceFormKey + "\" TgtDataObjectKey=\"" + targetDataObjectKey + "\" TgtFormKey=\"" + targetFormKey + "\">\n" + "    <SourceTableCollection Height=\"60\" Width=\"296\" X=\"30\" Y=\"80\"/>\n" + "    <TargetTableCollection Height=\"60\" Width=\"296\" X=\"457\" Y=\"80\"/>\n" + "</Map>\n";
            XmlFileProcessor.instance.saveTempFile(filePath, fileContent, projectKey);
            FileUtils.writeStringToFile((File)new File(filePath), (String)fileContent, (String)"UTF-8");
            result.put("result", "true");
            result.put("filePath", filePath);
            result.put("version", String.valueOf(verionNo));
            result.put("fileName", newFileName.replaceAll(XML_EXTENSION, ""));
        }
        catch (Exception e) {
            result.put("result", "false");
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        return result;
    }

    public JSONObject convertXmlToJson(String filePaths) throws Throwable {
        JSONObject workFlowJson = new JSONObject(new LinkedHashMap());
        String temFilePath = XmlFileProcessor.instance.getTmpFile(filePaths);
        if (StringUtils.isBlank((CharSequence)temFilePath)) {
            temFilePath = filePaths;
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(temFilePath));
        Element root = document.getRootElement();
        String caption = root.attributeValue("Caption");
        String extend = root.attributeValue("Extend");
        try {
            OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
            FileOutputStream fileOutputStream = new FileOutputStream(temFilePath);
            XMLWriter writer = null;
            writer = new XMLWriter(fileOutputStream, format);
            writer.write(document);
            JSONObject paths = this.setPaths(root);
            JSONObject workFlowDesc = this.setWorkFlowAttributes(root);
            workFlowJson.put("paths", (Object)paths);
            workFlowJson.put("dataMapprops", (Object)workFlowDesc);
            workFlowJson.put("Caption", (Object)caption);
            workFlowJson.put("extend", (Object)extend);
            DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
        }
        catch (Throwable e) {
            throw new Throwable(e);
        }
        return workFlowJson;
    }

    public static Element getElement(String filePath) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(filePath));
        return document.getRootElement();
    }

    public static List<String> getFeedBackFormKeys(String filePath) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(new File(filePath));
        Element root = doc.getRootElement();
        ArrayList<String> feedBackKeyList = new ArrayList<String>();
        Node feedbackCollection = root.selectSingleNode("FeedbackCollection");
        if (Objects.isNull(feedbackCollection)) {
            return feedBackKeyList;
        }
        List feedbackObjectList = feedbackCollection.selectNodes("FeedbackObject");
        int i = 0;
        while (i < feedbackObjectList.size()) {
            Element element = (Element)feedbackObjectList.get(i);
            String formKey = element.attributeValue("FormKey");
            feedBackKeyList.add(formKey);
            ++i;
        }
        return feedBackKeyList;
    }

    public JSONObject setWorkFlowAttributes(Element root) throws Throwable {
        List<String> keyList = Arrays.asList("Key", "Caption", "Description", "SrcDataObjectKey", "TgtDataObjectKey", "SrcFormKey", "TgtFormKey", "MapRelationValue", "AllowRemainderPush", "MarkMapCount", "PullDataOnly", "RemainderPushValue", "MinPushValue", "MapCondition", "PostProcess", "FeedbackForm", "Extend", "StatusFieldKey_Feed", "Condition_Feed", "StatusValue_Feed");
        JSONObject workFlowDescSub = new JSONObject(new LinkedHashMap());
        for (String key : keyList) {
            String value = root.attributeValue(key);
            boolean isEmpty = value == null || StringUtils.isEmpty((CharSequence)value);
            switch (key) {
                case "PullDataOnly": {
                    if (!isEmpty) break;
                    value = "false";
                    break;
                }
                case "MarkMapCount": 
                case "MapRelationValue": 
                case "AllowRemainderPush": {
                    if (!isEmpty) break;
                    value = "true";
                    break;
                }
                case "FeedbackForm": {
                    Element feedbackCollection = root.element("FeedbackCollection");
                    List elements = null;
                    if (feedbackCollection != null) {
                        elements = feedbackCollection.elements("FeedbackObject");
                    }
                    JSONObject FeedbackForm = new JSONObject();
                    if (elements == null || elements.size() == 0) break;
                    for (Element ele : elements) {
                        JSONObject json = new JSONObject(new LinkedHashMap());
                        json.put("FeedbackForm", (Object)ele.attributeValue("FormKey"));
                        String formKey = ele.attributeValue("FormKey");
                        if (StringUtils.isEmpty((CharSequence)formKey)) {
                            throw new Throwable("\u8bf7\u5728\u6570\u636e\u6620\u5c04\u6e90\u4ee3\u7801\u4e2d\u7684FeedbackObject\u8282\u70b9\u4e2d\u65b0\u589eFormKey\u5c5e\u6027\u4f8b\u5982:<FeedbackObject Height=\"60\" ObjectKey=\"Material\" FormKey=\"V_Material\" Width=\"256\" X=\"723\" Y=\"106\">");
                        }
                        TwoTuple<MetaForm, MetaDataObject> formOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(ele.attributeValue("FormKey"));
                        String FeedbackCaption = "";
                        if (formOrMetaDataObject.metaForm != null) {
                            FeedbackCaption = ((MetaForm)formOrMetaDataObject.metaForm).getCaption();
                        } else if (formOrMetaDataObject.metaDataObject != null) {
                            FeedbackCaption = ((MetaDataObject)formOrMetaDataObject.metaDataObject).getCaption();
                        }
                        json.put("FeedbackCaption", (Object)FeedbackCaption);
                        json.put("Width", (Object)ele.attributeValue("Width"));
                        json.put("X", (Object)ele.attributeValue("X"));
                        json.put("Y", (Object)ele.attributeValue("Y"));
                        FeedbackForm.put(ele.attributeValue("FormKey"), (Object)json);
                    }
                    JSONObject FeedbackFormvalue = new JSONObject(new LinkedHashMap());
                    FeedbackFormvalue.put("value", (Object)FeedbackForm);
                    workFlowDescSub.put("FeedbackForm", (Object)FeedbackFormvalue);
                    break;
                }
                case "Condition_Feed": 
                case "StatusValue_Feed": 
                case "StatusFieldKey_Feed": {
                    Element feedbackCollection1 = root.element("FeedbackCollection");
                    value = Objects.isNull(feedbackCollection1) ? "" : feedbackCollection1.attributeValue(key);
                    break;
                }
            }
            if ("FeedbackForm".equalsIgnoreCase(key)) continue;
            JSONObject temp = new JSONObject(new LinkedHashMap());
            temp.put("value", (Object)value);
            workFlowDescSub.put(key, (Object)temp);
        }
        JSONObject workFlowDesc = new JSONObject(new LinkedHashMap());
        workFlowDesc.put("dataMapprops", (Object)workFlowDescSub);
        return workFlowDesc;
    }

    public JSONObject setSourceFormJson(Element root) {
        boolean isIdentical = root.attributeValue("SrcFormKey").equalsIgnoreCase(root.attributeValue("TgtFormKey"));
        String srcFormKey1 = root.attributeValue("SrcFormKey");
        if (isIdentical) {
            srcFormKey1 = String.valueOf(root.attributeValue("SrcFormKey")) + "__S";
        }
        JSONObject setSourceFormJson = null;
        JSONObject setSourceTableJson = null;
        MetaDataObject dataObject = null;
        MetaForm metaForm = null;
        IDLookup idLookup = null;
        try {
            String key = "Definition";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            setSourceFormJson = new JSONObject(new LinkedHashMap());
            setSourceTableJson = new JSONObject(new LinkedHashMap());
            Element sourceTableCollection = root.element("SourceTableCollection");
            String srcFormKey = root.attributeValue("SrcFormKey");
            List sourceTable = sourceTableCollection.elements("SourceTable");
            if (sourceTable.size() != 0) {
                for (Element tableNode : sourceTable) {
                    if (!"Table".equalsIgnoreCase(tableNode.attributeValue("Type")) && !"SERVICE".equalsIgnoreCase(tableNode.attributeValue("Type"))) continue;
                    List SourceField = tableNode.elements("SourceField");
                    String tableKey = tableNode.attributeValue("Key");
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Type", (Object)tableNode.attributeValue("Type"));
                    setSourceTableJson.put(tableKey, (Object)jsonObject);
                    int i = 0;
                    while (i < SourceField.size()) {
                        MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(srcFormKey);
                        idLookup = IDLookup.getIDLookup(metaForm1);
                        TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(srcFormKey);
                        metaForm = (MetaForm)metaFormOrMetaDataObject.metaForm;
                        dataObject = (MetaDataObject)metaFormOrMetaDataObject.metaDataObject;
                        Element sourceField = (Element)SourceField.get(i);
                        JSONObject temp = new JSONObject(new LinkedHashMap());
                        if (!hashMap.containsKey(String.valueOf(sourceField.attributeValue("Definition")) + tableKey)) {
                            this.getSourceField(setSourceFormJson, temp, key, sourceField, srcFormKey1, metaForm, dataObject, tableKey, idLookup);
                        }
                        hashMap.put(String.valueOf(sourceField.attributeValue("Definition")) + tableKey, sourceField.attributeValue("Definition"));
                        ++i;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        JSONObject sourceJson = new JSONObject(new LinkedHashMap());
        sourceJson.put("source", (Object)setSourceFormJson);
        sourceJson.put("table", (Object)setSourceTableJson);
        return sourceJson;
    }

    public void synchronizeMaxKey(int[] keyList, Element tableEle) {
        int last = Arrays.stream(keyList).max().getAsInt();
        tableEle.addAttribute("MaxKey", String.valueOf(last));
    }

    public void getSourceField(JSONObject setSourceFormJson, JSONObject temp, String key, Element sourceField, String srcFormKey, MetaForm metaForm, MetaDataObject metaDataObject, String tableKey, IDLookup idLookup) {
        MetaTable metaTable = null;
        MetaTableCollection metaTableCollection = null;
        if (metaForm != null) {
            metaTable = metaForm.getDataSource().getDataObject().getTable(tableKey);
            metaTableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        } else if (metaDataObject != null) {
            metaTable = metaDataObject.getTable(tableKey);
            metaTableCollection = metaDataObject.getTableCollection();
        }
        String definitionKey = sourceField.attributeValue("Definition");
        MetaColumn metaColumn = null;
        metaColumn = DataMapOperXmlUtil.getMetaColumn(definitionKey, tableKey, metaTable, idLookup);
        if (metaTable != null && !tableKey.contains("_NODB") && metaTableCollection != null) {
            int indexOf = metaTableCollection.indexOf(metaTable);
            String fieldCaption = null;
            if (metaColumn != null) {
                fieldCaption = metaColumn.getCaption();
            }
            if (StringUtils.isNotEmpty((CharSequence)sourceField.attributeValue("Type"))) {
                if (StringUtils.isBlank((CharSequence)definitionKey)) {
                    definitionKey = "  ";
                }
                StringBuffer fieldValue = new StringBuffer().append(indexOf + 1).append("_@_").append(definitionKey).append("_@_").append("  ").append("_@_").append(tableKey).append("_@_").append(srcFormKey);
                temp.put("Definition", (Object)fieldValue);
            } else {
                StringBuffer fieldValue = new StringBuffer().append(indexOf + 1).append("_@_").append(definitionKey).append("_@_").append(StringUtils.isEmpty((CharSequence)fieldCaption) ? "SpecialField" : fieldCaption).append("_@_").append(tableKey).append("_@_").append(srcFormKey);
                temp.put("Definition", (Object)fieldValue);
            }
            setSourceFormJson.put(String.valueOf(key) + (setSourceFormJson.size() + 1), (Object)temp);
        } else if (Objects.isNull(metaTable)) {
            definitionKey = sourceField.attributeValue("Definition");
            if (StringUtils.isNotEmpty((CharSequence)sourceField.attributeValue("Type"))) {
                if (StringUtils.isBlank((CharSequence)definitionKey)) {
                    definitionKey = "  ";
                }
                StringBuffer fieldValue = new StringBuffer().append(-1).append("_@_").append(definitionKey).append("_@_").append("  ").append("_@_").append(tableKey).append("_@_").append(srcFormKey);
                temp.put("Definition", (Object)fieldValue);
            } else {
                StringBuffer fieldValue = new StringBuffer().append(-1).append("_@_").append(definitionKey).append("_@_").append(" ").append("_@_").append(tableKey).append("_@_").append(srcFormKey);
                temp.put("Definition", (Object)fieldValue);
            }
            setSourceFormJson.put(String.valueOf(key) + (setSourceFormJson.size() + 1), (Object)temp);
        }
    }

    public JSONObject setTargetFormJson(Element root) {
        boolean isIdentical = root.attributeValue("SrcFormKey").equalsIgnoreCase(root.attributeValue("TgtFormKey"));
        JSONObject settargetFormJson = null;
        MetaForm metaForm = null;
        MetaDataObject dataObject = null;
        IDLookup idLookup = null;
        MetaTable metaTable = null;
        MetaTableCollection metaTableCollection = null;
        try {
            String key = "Definition";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            settargetFormJson = new JSONObject(new LinkedHashMap());
            Element targetTableCollection = root.element("TargetTableCollection");
            if (Objects.isNull(targetTableCollection)) {
                JSONObject sourceJson = new JSONObject(new LinkedHashMap());
                sourceJson.put("target", null);
                return sourceJson;
            }
            String tgtFormKey = root.attributeValue("TgtFormKey");
            List targetTable = targetTableCollection.elements("TargetTable");
            String tgtFormKey1 = root.attributeValue("TgtFormKey");
            if (isIdentical) {
                tgtFormKey1 = String.valueOf(root.attributeValue("TgtFormKey")) + "__T";
            }
            if (targetTable.size() != 0) {
                MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(tgtFormKey);
                idLookup = IDLookup.getIDLookup(metaForm1);
                TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(tgtFormKey);
                metaForm = (MetaForm)metaFormOrMetaDataObject.metaForm;
                dataObject = (MetaDataObject)metaFormOrMetaDataObject.metaDataObject;
                if (Objects.isNull(dataObject)) {
                    dataObject = metaForm.getDataSource().getDataObject();
                }
                for (Element Definition : targetTable) {
                    List TargetField = Definition.elements("TargetField");
                    String tableKey = Definition.attributeValue("Key");
                    if (metaForm != null) {
                        metaTable = metaForm.getMetaTable(tableKey);
                        metaTableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
                    } else if (dataObject != null) {
                        metaTable = dataObject.getMetaTable(tableKey);
                        metaTableCollection = dataObject.getTableCollection();
                    }
                    int i = 0;
                    while (i < TargetField.size()) {
                        Element targetField = (Element)TargetField.get(i);
                        JSONObject temp = new JSONObject(new LinkedHashMap());
                        if (!tableKey.contains("_NODB") && Objects.isNull(hashMap.get(String.valueOf(targetField.attributeValue("Definition")) + tableKey))) {
                            StringBuffer fieldValue;
                            MetaTable mainTable;
                            int indexOf = metaTableCollection.indexOf(metaTable);
                            String definitionKey = targetField.attributeValue("Definition");
                            String fieldCaption = null;
                            MetaColumn metaColumn = DataMapOperXmlUtil.getMetaColumn(definitionKey, tableKey, metaTable, idLookup);
                            if (Objects.isNull(metaColumn) && (mainTable = dataObject.getMainTable()) != null) {
                                metaColumn = DataMapOperXmlUtil.getMetaColumn(definitionKey, mainTable.getKey(), mainTable, idLookup);
                            }
                            if (metaColumn != null) {
                                fieldCaption = metaColumn.getCaption();
                            }
                            if ("Formula".equalsIgnoreCase(targetField.attributeValue("Type")) || "Const".equalsIgnoreCase(targetField.attributeValue("Type"))) {
                                fieldValue = new StringBuffer().append(indexOf + 1).append("_@_").append(definitionKey).append("_@_").append("  ").append("_@_").append(tableKey).append("_@_").append(tgtFormKey1);
                                temp.put("Definition", (Object)fieldValue);
                                settargetFormJson.put(String.valueOf(key) + (settargetFormJson.size() + 1), (Object)temp);
                            } else {
                                fieldValue = new StringBuffer().append(indexOf + 1).append("_@_").append(definitionKey).append("_@_").append(StringUtils.isEmpty((CharSequence)fieldCaption) ? "SpecialField" : fieldCaption).append("_@_").append(tableKey).append("_@_").append(tgtFormKey1);
                                temp.put("Definition", (Object)fieldValue);
                                settargetFormJson.put(String.valueOf(key) + (settargetFormJson.size() + 1), (Object)temp);
                            }
                        }
                        hashMap.put(String.valueOf(targetField.attributeValue("Definition")) + tableKey, targetField.attributeValue("Definition"));
                        ++i;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        JSONObject sourceJson = new JSONObject(new LinkedHashMap());
        sourceJson.put("target", (Object)settargetFormJson);
        return sourceJson;
    }

    public JSONObject setPaths(Element root) throws DocumentException {
        String tgtFormKey;
        JSONObject pathJson = new JSONObject(new LinkedHashMap());
        int i = 1;
        String srcFormKey = root.attributeValue("SrcFormKey");
        boolean isIdentical = srcFormKey.equalsIgnoreCase(tgtFormKey = root.attributeValue("TgtFormKey"));
        if (isIdentical) {
            srcFormKey = String.valueOf(srcFormKey) + "__S";
            tgtFormKey = String.valueOf(tgtFormKey) + "__T";
        }
        List elements = root.element("SourceTableCollection").elements("SourceTable");
        String extend = root.attributeValue("Extend");
        boolean isLinkDataMapKey = StringUtils.isNotEmpty((CharSequence)extend);
        HashMap<String, Integer> listHashMap = new HashMap<String, Integer>();
        int listHashMapi = -1;
        for (Element ele : elements) {
            List sourceField = ele.elements("SourceField");
            for (Element elefield : sourceField) {
                JSONObject temp;
                if (elefield.attributeValue("Type") != null && !listHashMap.containsKey(elefield.attributeValue("Definition"))) {
                    String definition = elefield.attributeValue("Definition");
                    listHashMap.put(definition, ++listHashMapi);
                }
                if (elefield.attributeValue("TargetFieldKey") != null && !listHashMap.containsKey(elefield.attributeValue("Definition"))) {
                    temp = new JSONObject(new LinkedHashMap());
                    String tableKey = DataMapOperXmlUtil.getTableKey(ele);
                    StringBuffer sourceID = new StringBuffer().append("F_").append(srcFormKey).append(elefield.attributeValue("Definition")).append(tableKey);
                    this.isConstOrFormula(root, temp, tgtFormKey, ele, elefield);
                    temp.put("sourceEndpoint", (Object)sourceID);
                    if ("Focus".equalsIgnoreCase(elefield.attributeValue("EdgeType"))) {
                        temp.put("EdgeType", (Object)"Focus");
                    }
                    if (isLinkDataMapKey) {
                        String key = elefield.attributeValue("Key");
                        String dataMapPathByKey = LoadFileTree.getDataMapPathByKey(extend);
                        Element sourceRoot = DataMapOperJsonUtil.getElement(dataMapPathByKey);
                        Element elements11 = (Element)sourceRoot.selectSingleNode("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']/SourceField[@Key='" + key + "']");
                        if (elements11 != null) {
                            temp.put("Key", (Object)elefield.attributeValue("Key"));
                        }
                    }
                    if (temp.size() > 1) {
                        pathJson.put("path" + i, (Object)temp);
                    }
                    ++i;
                    continue;
                }
                if (elefield.attributeValue("TargetFieldKey") == null || !listHashMap.containsKey(elefield.attributeValue("Definition"))) continue;
                temp = new JSONObject(new LinkedHashMap());
                StringBuffer sourceConstAndFormula = null;
                String tableKey = DataMapOperXmlUtil.getTableKey(ele);
                int index = (Integer)listHashMap.get(elefield.attributeValue("Definition"));
                sourceConstAndFormula = new StringBuffer().append("F_").append(tableKey).append(srcFormKey).append(index + 1);
                this.isConstOrFormula(root, temp, tgtFormKey, ele, elefield);
                temp.put("sourceEndpoint", (Object)sourceConstAndFormula);
                if ("Focus".equalsIgnoreCase(elefield.attributeValue("EdgeType"))) {
                    temp.put("EdgeType", (Object)"Focus");
                }
                if (temp.size() > 1) {
                    pathJson.put("path" + i, (Object)temp);
                }
                ++i;
            }
            listHashMap.clear();
        }
        if (root.element("FeedbackCollection") != null) {
            this.targetToFeedback(root, pathJson, i);
        }
        JSONObject setpathJson = new JSONObject(new LinkedHashMap());
        setpathJson.put("path", (Object)pathJson);
        return setpathJson;
    }

    public void targetToFeedback(Element root, JSONObject pathJson, int i) {
        int numberID = 0;
        Element targetTableCollection = root.element("TargetTableCollection");
        if (targetTableCollection != null) {
            List targetTable = targetTableCollection.elements("TargetTable");
            for (Element ele : targetTable) {
                List targetField = ele.elements("TargetField");
                for (Element targetfield : targetField) {
                    List feedback;
                    if ("Formula".equalsIgnoreCase(targetfield.attributeValue("Type")) || "Const".equalsIgnoreCase(targetfield.attributeValue("Type"))) {
                        ++numberID;
                    }
                    if ((feedback = targetfield.elements("Feedback")).size() == 0) continue;
                    String tgtDataformKey = root.attributeValue("TgtFormKey");
                    if (tgtDataformKey.equalsIgnoreCase(root.attributeValue("SrcFormKey"))) {
                        tgtDataformKey = String.valueOf(tgtDataformKey) + "__T";
                    }
                    String tableKey = ele.attributeValue("Key");
                    StringBuffer targetBuffer = null;
                    if (StringUtils.isBlank((CharSequence)targetfield.attributeValue("Type"))) {
                        targetBuffer = new StringBuffer().append("F_" + tgtDataformKey).append(targetfield.attributeValue("Definition")).append(tableKey);
                    } else if ("Formula".equalsIgnoreCase(targetfield.attributeValue("Type")) || "Const".equalsIgnoreCase(targetfield.attributeValue("Type"))) {
                        targetBuffer = new StringBuffer().append("F_").append(tableKey).append(tgtDataformKey).append(numberID);
                    }
                    for (Element feed : feedback) {
                        JSONObject temp = new JSONObject();
                        String feedFormKey = feed.attributeValue("FeedFormKey");
                        if (feedFormKey.equalsIgnoreCase(root.attributeValue("SrcFormKey")) || feedFormKey.equalsIgnoreCase(root.attributeValue("TgtFormKey"))) {
                            feedFormKey = String.valueOf(feedFormKey) + "__Feed";
                        }
                        StringBuffer feedstr = new StringBuffer().append("F_" + feedFormKey).append(feed.attributeValue("FieldKey")).append(feed.attributeValue("TableKey"));
                        temp.put("FeedEndpoint", (Object)feedstr);
                        temp.put("TgEndpoint", (Object)targetBuffer);
                        if (temp.size() > 1) {
                            pathJson.put("path" + i, (Object)temp);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public void isConstOrFormula(Element root, JSONObject temp, String tgtDataObjectKey, Element ele, Element elefield) {
        List elementList = root.element("TargetTableCollection").elements("TargetTable");
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, Integer> listHashMap = new HashMap<String, Integer>();
        int listHashMapi = -1;
        String targetTableKey = elefield.attributeValue("TargetTableKey");
        for (Element targetele : elementList) {
            String fieldValue;
            List targetField;
            String tableKey;
            if (StringUtils.isBlank((CharSequence)targetTableKey)) {
                targetTableKey = ele.attributeValue("TargetTableKey");
            }
            if ((tableKey = DataMapOperXmlUtil.getTableKey(targetele)).equalsIgnoreCase(targetTableKey)) {
                targetField = targetele.elements("TargetField");
                for (Element targetfield : targetField) {
                    if (targetfield.attributeValue("Type") != null) {
                        fieldValue = DataMapOperXmlUtil.getFieldValue(targetfield);
                        listHashMap.put(fieldValue, ++listHashMapi);
                        list.add(fieldValue);
                    }
                    if (!(fieldValue = DataMapOperXmlUtil.getFieldValue(targetfield)).equalsIgnoreCase(elefield.attributeValue("TargetFieldKey"))) continue;
                    if ("Const".equalsIgnoreCase(targetfield.attributeValue("Type")) || "Formula".equalsIgnoreCase(targetfield.attributeValue("Type"))) {
                        int index = (Integer)listHashMap.get(fieldValue);
                        StringBuffer targetID = new StringBuffer().append("F_").append(targetTableKey).append(tgtDataObjectKey).append(index + 1);
                        temp.put("targetEndpoint", (Object)targetID);
                        continue;
                    }
                    if (!StringUtils.isBlank((CharSequence)targetfield.attributeValue("Type"))) continue;
                    StringBuffer targetID = new StringBuffer().append("F_").append(tgtDataObjectKey).append(elefield.attributeValue("TargetFieldKey")).append(targetTableKey);
                    temp.put("targetEndpoint", (Object)targetID);
                }
                continue;
            }
            targetField = targetele.elements("TargetField");
            for (Element targetfield : targetField) {
                if (targetfield.attributeValue("Type") == null) continue;
                fieldValue = DataMapOperXmlUtil.getFieldValue(targetfield);
                listHashMap.put(fieldValue, ++listHashMapi);
                list.add(fieldValue);
            }
        }
    }

    public JSONObject setFeedback(Element root) throws Throwable {
        JSONObject feedbackJson = new JSONObject(new LinkedHashMap());
        int b = 1;
        Element feedbackCollection = root.element("FeedbackCollection");
        if (feedbackCollection != null) {
            List feedbackObject = feedbackCollection.elements("FeedbackObject");
            for (Element ele : feedbackObject) {
                JSONObject temp;
                List feedbackTable = ele.elements("FeedbackTable");
                if (feedbackTable.size() != 0) {
                    for (Element feedback : feedbackTable) {
                        List feedbackField = feedback.elements("FeedbackField");
                        for (Element feedbackfield : feedbackField) {
                            String feedFormKey = ele.attributeValue("FormKey");
                            if (StringUtils.isEmpty((CharSequence)feedFormKey)) {
                                throw new Throwable("\u8bf7\u5728\u6570\u636e\u6620\u5c04\u6e90\u4ee3\u7801\u4e2d\u7684FeedbackObject\u8282\u70b9\u4e2d\u65b0\u589eFormKey\u5c5e\u6027\u4f8b\u5982:<FeedbackObject Height=\"60\" ObjectKey=\"Material\" FormKey=\"V_Material\" Width=\"256\" X=\"723\" Y=\"106\">");
                            }
                            String tableKey = feedback.attributeValue("TableKey");
                            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(feedFormKey);
                            IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                            MetaTable metaTable = metaForm.getMetaTable(tableKey);
                            int indexOf = metaForm.getDataSource().getDataObject().getTableCollection().indexOf(metaTable);
                            MetaColumn metaColumn = DataMapOperXmlUtil.getMetaColumn(feedbackfield.attributeValue("FieldKey"), tableKey, metaTable, idLookup);
                            if (feedFormKey.equalsIgnoreCase(root.attributeValue("SrcFormKey")) || feedFormKey.equalsIgnoreCase(root.attributeValue("TgtFormKey"))) {
                                feedFormKey = String.valueOf(feedFormKey) + "__Feed";
                            }
                            StringBuffer str = new StringBuffer().append(indexOf + 1).append("_@_").append(feedbackfield.attributeValue("FieldKey")).append("_@_").append(Objects.isNull(metaColumn) ? "SpecialField" : metaColumn.getCaption()).append("_@_").append(feedback.attributeValue("TableKey")).append("_@_").append(feedFormKey);
                            temp = new JSONObject();
                            temp.put("FeedBack", (Object)str);
                            feedbackJson.put("FeedBack" + b, (Object)temp);
                            ++b;
                        }
                    }
                    continue;
                }
                String feedformKey = ele.attributeValue("FormKey");
                StringBuffer str = new StringBuffer().append(feedformKey);
                temp = new JSONObject();
                temp.put("FeedBack", (Object)str);
                feedbackJson.put("FeedBack" + b, (Object)temp);
                ++b;
            }
        }
        JSONObject setFeedbackJson = new JSONObject(new LinkedHashMap());
        setFeedbackJson.put("feedBack", (Object)feedbackJson);
        return setFeedbackJson;
    }

    public List<String> resultSet() {
        return undoSet;
    }

    public boolean existDataMapVest(String extend, IMetaFactory globalInstance) throws Throwable {
        List metaDataMapList = globalInstance.getMetaCustomObjects(ERPMetaMap.class);
        for (ERPMetaMap erpMetaMap : metaDataMapList) {
            if (StringUtils.isEmpty((CharSequence)extend)) break;
            if (StringUtils.isEmpty((CharSequence)erpMetaMap.getExtend()) || !erpMetaMap.getExtend().equals(extend.split(" ")[0])) continue;
            return true;
        }
        return false;
    }

    public String createDataMapVestXml(String caption, String key, String extend, String srcDataObjectKey, String sourceFormKey, String targetDataObjectKey, String targetFormKey) throws Throwable {
        StringBuilder sb = new StringBuilder();
        String filePath = LoadFileTree.getDataMapPathByKey(extend.split(" ")[0]);
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(filePath));
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        sb.append("<Map Caption=\"" + caption + "\" Key=\"" + key + "\"");
        sb.append(" Extend=\"" + extend.split(" ")[0] + "\"");
        sb.append(" SrcFormKey=\"" + sourceFormKey + "\" TgtFormKey=\"" + targetFormKey + "\" ");
        sb.append(">\n");
        sb.append("    <SourceTableCollection Height=\"60\" Width=\"296\" X=\"30\" Y=\"80\"/>\n");
        sb.append("    <TargetTableCollection Height=\"60\" Width=\"296\" X=\"457\" Y=\"80\"/>\n");
        sb.append("</Map>");
        return sb.toString();
    }
}

