/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.dataMigration.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.dataMigration.util.DataMigrationOperJsonUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.design.vo.JsonDataMapVo;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DataMigrationOperXmlUtil {
    private static final Logger logger = Logger.getLogger(DataMapOperXmlUtil.class.getName());

    public ResponseResult<JSONArray> getMigrationField(JsonDataMapVo jsonDataMapVo, Element root) {
        boolean isIdentical = root.attributeValue("SrcDataObjectKey").equalsIgnoreCase(root.attributeValue("TgtDataObjectKey"));
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            String formKey = jsonDataMapVo.getFormKey();
            if (formKey != null) {
                formKey = formKey.split("__")[0];
            }
            formKey = "source".equalsIgnoreCase(jsonDataMapVo.getOperationType()) ? root.attributeValue("SrcDataObjectKey") : root.attributeValue("TgtDataObjectKey");
            MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(formKey);
            MetaTableCollection tableCollection = dataObject.getTableCollection();
            JSONArray nodesJsonArray = new JSONArray();
            if (isIdentical && root.attributeValue("SrcDataObjectKey").equalsIgnoreCase(formKey) && "source".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
                formKey = String.valueOf(formKey) + "__S";
            } else if (isIdentical && root.attributeValue("TgtDataObjectKey").equalsIgnoreCase(formKey) && "target".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
                formKey = String.valueOf(formKey) + "__T";
            }
            int i = 0;
            while (i < tableCollection.size()) {
                MetaTable metaColumns = (MetaTable)tableCollection.get(i);
                if (!metaColumns.getKey().contains("_NODB")) {
                    for (MetaColumn m : metaColumns) {
                        JSONObject nodeJsonObj = new JSONObject();
                        int groupType = m.getGroupType();
                        String fieldCaption = DataMigrationOperJsonUtil.getGroupType(groupType);
                        nodeJsonObj.put("name", (Object)("(\u8868" + (i + 1) + ")" + m.getKey() + "  " + m.getCaption() + "  " + fieldCaption));
                        nodeJsonObj.put("value", (Object)(String.valueOf(i + 1) + "_@_" + m.getKey() + "_@_" + m.getCaption() + fieldCaption + "_@_" + metaColumns.getKey() + "_@_" + formKey + "_@_" + "Migration"));
                        nodesJsonArray.add((Object)nodeJsonObj);
                    }
                }
                ++i;
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u6570\u636e\u5bf9\u8c61\u5b57\u6bb5\u6210\u529f");
            result.setData(nodesJsonArray);
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u6570\u636e\u5bf9\u8c61\u5b57\u6bb5\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u6570\u636e\u5bf9\u8c61\u5b57\u6bb5\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    public static Element getMapSourceTableCollectionNode(Document document) {
        String xpathExpression = "/DataMigration/SourceTableCollection";
        Element nodes = (Element)document.selectSingleNode(xpathExpression);
        return nodes;
    }

    public static Element getMapTargetTableCollectionNode(Document document) {
        String xpathExpression = "/DataMigration/TargetTableCollection";
        Element nodes = (Element)document.selectSingleNode(xpathExpression);
        return nodes;
    }

    public ResponseResult<JSONArray> getStatusFideldKey(JsonDataMapVo jsonDataMapVo) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        JSONArray array = null;
        try {
            array = new JSONArray();
            String filePaths = jsonDataMapVo.getFilePath();
            SAXReader reader = new SAXReader();
            Document document = reader.read(new File(filePaths));
            Element root = document.getRootElement();
            String formKey = root.attributeValue("SrcDataObjectKey");
            TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
            MetaForm metaForm = (MetaForm)metaFormOrMetaDataObject.metaForm;
            MetaDataObject metaDataObject = (MetaDataObject)metaFormOrMetaDataObject.metaDataObject;
            String mainTableKey = Optional.ofNullable(metaForm).map(form -> form.getDataSource().getDataObject().getMainTableKey()).orElse(Optional.ofNullable(metaDataObject).map(MetaDataObject::getMainTableKey).orElse(null));
            MetaTable table = Optional.ofNullable(metaForm).map(form -> metaForm.getDataSource().getDataObject().getTable(mainTableKey)).orElse(Optional.ofNullable(metaDataObject).map(dataObject -> dataObject.getTable(mainTableKey)).orElse(null));
            for (MetaColumn metaColumn : Objects.requireNonNull(table)) {
                JSONObject nodeJson;
                String caption;
                if (metaColumn == null) continue;
                String key = metaColumn.getKey();
                if (!SystemField.isSystemField((String)key)) {
                    caption = metaColumn.getCaption();
                    nodeJson = new JSONObject();
                    nodeJson.put("name", (Object)(String.valueOf(key) + "  " + caption));
                    nodeJson.put("value", (Object)key);
                    array.add((Object)nodeJson);
                    continue;
                }
                if (!key.equalsIgnoreCase("Status")) continue;
                caption = metaColumn.getCaption();
                nodeJson = new JSONObject();
                nodeJson.put("name", (Object)(String.valueOf(key) + "  " + caption));
                nodeJson.put("value", (Object)key);
                array.add((Object)nodeJson);
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6\u72b6\u6001\u5b57\u6bb5\u6807\u8bc6\u6210\u529f");
            result.setData(array);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6\u72b6\u6001\u5b57\u6bb5\u6807\u8bc6\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6\u72b6\u6001\u5b57\u6bb5\u6807\u8bc6\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return result;
    }
}

