/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.datamap.util.DataMapOperJsonUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class WebDataMapDesign
extends DesignerServiceCmd {
    public static final String CMD = "WebDataMapDesign";
    private String projectKey;
    private String filePath;
    private String sourceFormKey;
    private String targetFormKey;
    private String key;
    private String caption;
    private String extend;
    private int type;
    public static final int CONST_ONE = 1;
    public static final int CONST_TWO = 2;
    public static final String CONST_TRUE = "true";
    public static final String CONST_FALSE = "false";
    public static final String CONST_RESULT = "result";
    private static final DataMapOperJsonUtil datamapoperUtil = new DataMapOperJsonUtil();

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.filePath = FilePathHelper.toBackFilePath((String)arguments.get((Object)"filePath"));
        this.projectKey = (String)arguments.get((Object)"projectKey");
        this.sourceFormKey = (String)arguments.get((Object)"sourceFormKey");
        this.targetFormKey = (String)arguments.get((Object)"targetFormKey");
        this.key = (String)arguments.get((Object)"key");
        this.caption = (String)arguments.get((Object)"caption");
        this.extend = (String)arguments.get((Object)"extend");
        this.type = Integer.parseInt(String.valueOf(arguments.get((Object)"type")));
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        JSONObject result = new JSONObject();
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        if (1 == this.type) {
            if (datamapoperUtil.existDataMapVest(this.extend, globalInstance)) {
                result.put("code", (Object)1);
                result.put("msg", (Object)("\u65b0\u589e\u6570\u636e\u6620\u5c04\u9a6c\u7532\u5931\u8d25\uff1a\u5df2\u5b58\u5728" + this.extend + "\u7684\u6570\u636e\u6620\u5c04\u9a6c\u7532"));
            } else {
                Map<String, String> res = datamapoperUtil.createDataMapXml(this.projectKey, this.sourceFormKey, this.targetFormKey, this.key, this.caption, "0", this.extend);
                if (CONST_TRUE.equals(res.get(CONST_RESULT))) {
                    this.filePath = FilePathHelper.toBackFilePath(res.get("filePath"));
                    result.put("code", (Object)0);
                    result.put("msg", (Object)"\u65b0\u589e\u6587\u4ef6\u6210\u529f");
                    result.put("filePath", (Object)this.filePath);
                    String projectKey = LoadFileTree.getProjectKey(this.filePath);
                    try {
                        ReloadForm.reloadCustom(projectKey, this.key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ArrayList<UICommand> uiCommands = new ArrayList<UICommand>();
                    uiCommands.add(UICommand.reloadFileTree(this.filePath));
                    uiCommands.add(UICommand.reloadMenuTree());
                    result.put("uICommands", (Object)UICommand.toJson(uiCommands));
                    result.put("caption", (Object)this.caption);
                    result.put("version", (Object)"V1");
                } else {
                    result.put("code", (Object)1);
                    result.put("msg", (Object)"\u65b0\u589e\u6587\u4ef6\u5931\u8d25,\u6807\u8bc6\u5b58\u5728");
                }
            }
        } else if (2 == this.type) {
            SAXReader reader = new SAXReader();
            Document document = reader.read(new File(this.filePath));
            Element root = document.getRootElement();
            JSONObject jsonFileContent = new JSONObject();
            String extend = root.attributeValue("Extend");
            jsonFileContent.put("extend", (Object)extend);
            result.put("jsonFileContent", (Object)jsonFileContent);
            List metaDataMapList = globalInstance.getMetaCustomObjects(ERPMetaMap.class);
            String linkDataMapCaption = this.getLinkCaption(extend, metaDataMapList);
            result.put("linkDataMapCaption", (Object)linkDataMapCaption);
            String dataMapPath = LoadFileTree.getDataMapPathByKey(extend);
            result.put("linkDataMapPath", (Object)dataMapPath);
            return JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.DisableCircularReferenceDetect});
        }
        return result;
    }

    public static JSONObject getJsonFileContent(String filePath) throws Throwable {
        return datamapoperUtil.convertXmlToJson(filePath);
    }

    private String getLinkCaption(String extend, List<ERPMetaMap> metaDataMapList) {
        String linkDataMapCaption = null;
        for (ERPMetaMap erpMetaMap : metaDataMapList) {
            if (StringUtils.isEmpty((CharSequence)extend)) break;
            if (!erpMetaMap.getKey().equals(extend)) continue;
            linkDataMapCaption = erpMetaMap.getCaption();
            break;
        }
        return linkDataMapCaption;
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new WebDataMapDesign();
    }
}

